// Copyright (c) 2016, Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v3.18.1
// source: p4/v1/p4runtime.proto

// This package and its contents are a work-in-progress.

package v1

import (
	v1 "github.com/p4lang/p4runtime/go/p4/config/v1"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ------------------------------------------------------------------------------
// Reserved controller-specified SDN port numbers for reference.
type SdnPort int32

const (
	SdnPort_SDN_PORT_UNKNOWN SdnPort = 0
	// SDN ports are numbered starting form 1.
	SdnPort_SDN_PORT_MIN SdnPort = 1
	// 0xfffffeff: The maximum value of an SDN port (physical or logical).
	SdnPort_SDN_PORT_MAX SdnPort = -257
	// Reserved SDN port numbers (0xffffff00 - 0xffffffff)
	// 0xfffffffa: Recirculate the packet back to ingress
	SdnPort_SDN_PORT_RECIRCULATE SdnPort = -6
	// 0xfffffffd: Send to CPU
	SdnPort_SDN_PORT_CPU SdnPort = -3
)

// Enum value maps for SdnPort.
var (
	SdnPort_name = map[int32]string{
		0:    "SDN_PORT_UNKNOWN",
		1:    "SDN_PORT_MIN",
		-257: "SDN_PORT_MAX",
		-6:   "SDN_PORT_RECIRCULATE",
		-3:   "SDN_PORT_CPU",
	}
	SdnPort_value = map[string]int32{
		"SDN_PORT_UNKNOWN":     0,
		"SDN_PORT_MIN":         1,
		"SDN_PORT_MAX":         -257,
		"SDN_PORT_RECIRCULATE": -6,
		"SDN_PORT_CPU":         -3,
	}
)

func (x SdnPort) Enum() *SdnPort {
	p := new(SdnPort)
	*p = x
	return p
}

func (x SdnPort) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SdnPort) Descriptor() protoreflect.EnumDescriptor {
	return file_p4_v1_p4runtime_proto_enumTypes[0].Descriptor()
}

func (SdnPort) Type() protoreflect.EnumType {
	return &file_p4_v1_p4runtime_proto_enumTypes[0]
}

func (x SdnPort) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SdnPort.Descriptor instead.
func (SdnPort) EnumDescriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{0}
}

type WriteRequest_Atomicity int32

const (
	// Required. This is the default behavior. The batch is processed in a
	// non-atomic manner from a data plane point of view. Each operation within
	// the batch must be attempted even if one or more encounter errors.
	// Every data plane packet is guaranteed to be processed according to
	// table contents as they are between two individual operations of the
	// batch, but there could be several packets processed that see each of
	// these intermediate stages.
	WriteRequest_CONTINUE_ON_ERROR WriteRequest_Atomicity = 0
	// Optional. Operations within the batch are committed to data plane until
	// an error is encountered. At this point, the operations must be rolled
	// back such that both software and data plane state is consistent with the
	// state before the batch was attempted. The resulting behavior is
	// all-or-none, except the batch is not atomic from a data plane point of
	// view. Every data plane packet is guaranteed to be processed according to
	// table contents as they are between two individual operations of the
	// batch, but there could be several packets processed that see each of
	// these intermediate stages.
	WriteRequest_ROLLBACK_ON_ERROR WriteRequest_Atomicity = 1
	// Optional. Every data plane packet is guaranteed to be processed according
	// to table contents before the batch began, or after the batch completed
	// and the operations were programmed to the hardware.
	// The batch is therefore treated as a transaction.
	WriteRequest_DATAPLANE_ATOMIC WriteRequest_Atomicity = 2
)

// Enum value maps for WriteRequest_Atomicity.
var (
	WriteRequest_Atomicity_name = map[int32]string{
		0: "CONTINUE_ON_ERROR",
		1: "ROLLBACK_ON_ERROR",
		2: "DATAPLANE_ATOMIC",
	}
	WriteRequest_Atomicity_value = map[string]int32{
		"CONTINUE_ON_ERROR": 0,
		"ROLLBACK_ON_ERROR": 1,
		"DATAPLANE_ATOMIC":  2,
	}
)

func (x WriteRequest_Atomicity) Enum() *WriteRequest_Atomicity {
	p := new(WriteRequest_Atomicity)
	*p = x
	return p
}

func (x WriteRequest_Atomicity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WriteRequest_Atomicity) Descriptor() protoreflect.EnumDescriptor {
	return file_p4_v1_p4runtime_proto_enumTypes[1].Descriptor()
}

func (WriteRequest_Atomicity) Type() protoreflect.EnumType {
	return &file_p4_v1_p4runtime_proto_enumTypes[1]
}

func (x WriteRequest_Atomicity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WriteRequest_Atomicity.Descriptor instead.
func (WriteRequest_Atomicity) EnumDescriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{0, 0}
}

type Update_Type int32

const (
	Update_UNSPECIFIED Update_Type = 0
	Update_INSERT      Update_Type = 1
	Update_MODIFY      Update_Type = 2
	Update_DELETE      Update_Type = 3
)

// Enum value maps for Update_Type.
var (
	Update_Type_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "INSERT",
		2: "MODIFY",
		3: "DELETE",
	}
	Update_Type_value = map[string]int32{
		"UNSPECIFIED": 0,
		"INSERT":      1,
		"MODIFY":      2,
		"DELETE":      3,
	}
)

func (x Update_Type) Enum() *Update_Type {
	p := new(Update_Type)
	*p = x
	return p
}

func (x Update_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Update_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_p4_v1_p4runtime_proto_enumTypes[2].Descriptor()
}

func (Update_Type) Type() protoreflect.EnumType {
	return &file_p4_v1_p4runtime_proto_enumTypes[2]
}

func (x Update_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Update_Type.Descriptor instead.
func (Update_Type) EnumDescriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{4, 0}
}

type SetForwardingPipelineConfigRequest_Action int32

const (
	SetForwardingPipelineConfigRequest_UNSPECIFIED SetForwardingPipelineConfigRequest_Action = 0
	// Verify that the target can realize the given config. Do not modify the
	// forwarding state in the target. Returns error if config is not provided
	// of if the provided config cannot be realized.
	SetForwardingPipelineConfigRequest_VERIFY SetForwardingPipelineConfigRequest_Action = 1
	// Save the config if the target can realize it. Do not modify the
	// forwarding state in the target. Any subsequent read/write requests must
	// refer to fields in the new config. Returns error if config is not
	// provided of if the provided config cannot be realized.
	SetForwardingPipelineConfigRequest_VERIFY_AND_SAVE SetForwardingPipelineConfigRequest_Action = 2
	// Verify, save and realize the given config. Clear the forwarding state
	// in the target. Returns error if config is not provided of if the
	// provided config cannot be realized.
	SetForwardingPipelineConfigRequest_VERIFY_AND_COMMIT SetForwardingPipelineConfigRequest_Action = 3
	// Realize the last saved, but not yet committed, config. Update the
	// forwarding state in the target by replaying the write requests since the
	// last config was saved. Config should not be provided for this action
	// type. Returns an error if no saved config is found or if a config is
	// provided with this message.
	SetForwardingPipelineConfigRequest_COMMIT SetForwardingPipelineConfigRequest_Action = 4
	// Verify, save and realize the given config, while preserving the
	// forwarding state in the target. This is an advanced use case to enable
	// changes to the P4 forwarding pipeline configuration with minimal traffic
	// loss. P4Runtime does not impose any constraints on the duration of the
	// traffic loss. The support for this option is not expected to be uniform
	// across all P4Runtime targets. A target that does not support this option
	// may return an UNIMPLEMENTED error. For targets that support this option,
	// an INVALID_ARGUMENT error is returned if no config is provided, or if
	// the existing forwarding state cannot be preserved for the given config
	// by the target.
	SetForwardingPipelineConfigRequest_RECONCILE_AND_COMMIT SetForwardingPipelineConfigRequest_Action = 5
)

// Enum value maps for SetForwardingPipelineConfigRequest_Action.
var (
	SetForwardingPipelineConfigRequest_Action_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "VERIFY",
		2: "VERIFY_AND_SAVE",
		3: "VERIFY_AND_COMMIT",
		4: "COMMIT",
		5: "RECONCILE_AND_COMMIT",
	}
	SetForwardingPipelineConfigRequest_Action_value = map[string]int32{
		"UNSPECIFIED":          0,
		"VERIFY":               1,
		"VERIFY_AND_SAVE":      2,
		"VERIFY_AND_COMMIT":    3,
		"COMMIT":               4,
		"RECONCILE_AND_COMMIT": 5,
	}
)

func (x SetForwardingPipelineConfigRequest_Action) Enum() *SetForwardingPipelineConfigRequest_Action {
	p := new(SetForwardingPipelineConfigRequest_Action)
	*p = x
	return p
}

func (x SetForwardingPipelineConfigRequest_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SetForwardingPipelineConfigRequest_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_p4_v1_p4runtime_proto_enumTypes[3].Descriptor()
}

func (SetForwardingPipelineConfigRequest_Action) Type() protoreflect.EnumType {
	return &file_p4_v1_p4runtime_proto_enumTypes[3]
}

func (x SetForwardingPipelineConfigRequest_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SetForwardingPipelineConfigRequest_Action.Descriptor instead.
func (SetForwardingPipelineConfigRequest_Action) EnumDescriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{46, 0}
}

// Specifies the fields to populate in the response.
type GetForwardingPipelineConfigRequest_ResponseType int32

const (
	// Default behaviour. Returns a ForwardingPipelineConfig with all fields set
	// as stored by the target.
	GetForwardingPipelineConfigRequest_ALL GetForwardingPipelineConfigRequest_ResponseType = 0
	// Reply by setting only the cookie field, omitting all other fields.
	GetForwardingPipelineConfigRequest_COOKIE_ONLY GetForwardingPipelineConfigRequest_ResponseType = 1
	// Reply by setting the p4info and cookie fields.
	GetForwardingPipelineConfigRequest_P4INFO_AND_COOKIE GetForwardingPipelineConfigRequest_ResponseType = 2
	// Reply by setting the p4_device_config and cookie fields.
	GetForwardingPipelineConfigRequest_DEVICE_CONFIG_AND_COOKIE GetForwardingPipelineConfigRequest_ResponseType = 3
)

// Enum value maps for GetForwardingPipelineConfigRequest_ResponseType.
var (
	GetForwardingPipelineConfigRequest_ResponseType_name = map[int32]string{
		0: "ALL",
		1: "COOKIE_ONLY",
		2: "P4INFO_AND_COOKIE",
		3: "DEVICE_CONFIG_AND_COOKIE",
	}
	GetForwardingPipelineConfigRequest_ResponseType_value = map[string]int32{
		"ALL":                      0,
		"COOKIE_ONLY":              1,
		"P4INFO_AND_COOKIE":        2,
		"DEVICE_CONFIG_AND_COOKIE": 3,
	}
)

func (x GetForwardingPipelineConfigRequest_ResponseType) Enum() *GetForwardingPipelineConfigRequest_ResponseType {
	p := new(GetForwardingPipelineConfigRequest_ResponseType)
	*p = x
	return p
}

func (x GetForwardingPipelineConfigRequest_ResponseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetForwardingPipelineConfigRequest_ResponseType) Descriptor() protoreflect.EnumDescriptor {
	return file_p4_v1_p4runtime_proto_enumTypes[4].Descriptor()
}

func (GetForwardingPipelineConfigRequest_ResponseType) Type() protoreflect.EnumType {
	return &file_p4_v1_p4runtime_proto_enumTypes[4]
}

func (x GetForwardingPipelineConfigRequest_ResponseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetForwardingPipelineConfigRequest_ResponseType.Descriptor instead.
func (GetForwardingPipelineConfigRequest_ResponseType) EnumDescriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{49, 0}
}

// ------------------------------------------------------------------------------
type WriteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DeviceId uint64 `protobuf:"varint,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// Deprecated in v1.4.0
	//
	// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
	RoleId uint64 `protobuf:"varint,2,opt,name=role_id,json=roleId,proto3" json:"role_id,omitempty"`
	// Added in v1.4.0
	Role       string   `protobuf:"bytes,6,opt,name=role,proto3" json:"role,omitempty"`
	ElectionId *Uint128 `protobuf:"bytes,3,opt,name=election_id,json=electionId,proto3" json:"election_id,omitempty"`
	// The write batch, comprising a list of Update operations. The P4Runtime
	// server may arbitrarily reorder messages within a batch to maximize
	// performance.
	Updates   []*Update              `protobuf:"bytes,4,rep,name=updates,proto3" json:"updates,omitempty"`
	Atomicity WriteRequest_Atomicity `protobuf:"varint,5,opt,name=atomicity,proto3,enum=p4.v1.WriteRequest_Atomicity" json:"atomicity,omitempty"`
}

func (x *WriteRequest) Reset() {
	*x = WriteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteRequest) ProtoMessage() {}

func (x *WriteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteRequest.ProtoReflect.Descriptor instead.
func (*WriteRequest) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{0}
}

func (x *WriteRequest) GetDeviceId() uint64 {
	if x != nil {
		return x.DeviceId
	}
	return 0
}

// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
func (x *WriteRequest) GetRoleId() uint64 {
	if x != nil {
		return x.RoleId
	}
	return 0
}

func (x *WriteRequest) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *WriteRequest) GetElectionId() *Uint128 {
	if x != nil {
		return x.ElectionId
	}
	return nil
}

func (x *WriteRequest) GetUpdates() []*Update {
	if x != nil {
		return x.Updates
	}
	return nil
}

func (x *WriteRequest) GetAtomicity() WriteRequest_Atomicity {
	if x != nil {
		return x.Atomicity
	}
	return WriteRequest_CONTINUE_ON_ERROR
}

type WriteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WriteResponse) Reset() {
	*x = WriteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteResponse) ProtoMessage() {}

func (x *WriteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteResponse.ProtoReflect.Descriptor instead.
func (*WriteResponse) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{1}
}

type ReadRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DeviceId uint64 `protobuf:"varint,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// When specified, only return table entries for the given role.
	// Added in 1.4.0.
	Role     string    `protobuf:"bytes,3,opt,name=role,proto3" json:"role,omitempty"`
	Entities []*Entity `protobuf:"bytes,2,rep,name=entities,proto3" json:"entities,omitempty"`
}

func (x *ReadRequest) Reset() {
	*x = ReadRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRequest) ProtoMessage() {}

func (x *ReadRequest) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRequest.ProtoReflect.Descriptor instead.
func (*ReadRequest) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{2}
}

func (x *ReadRequest) GetDeviceId() uint64 {
	if x != nil {
		return x.DeviceId
	}
	return 0
}

func (x *ReadRequest) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *ReadRequest) GetEntities() []*Entity {
	if x != nil {
		return x.Entities
	}
	return nil
}

type ReadResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Entities []*Entity `protobuf:"bytes,1,rep,name=entities,proto3" json:"entities,omitempty"`
}

func (x *ReadResponse) Reset() {
	*x = ReadResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResponse) ProtoMessage() {}

func (x *ReadResponse) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResponse.ProtoReflect.Descriptor instead.
func (*ReadResponse) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{3}
}

func (x *ReadResponse) GetEntities() []*Entity {
	if x != nil {
		return x.Entities
	}
	return nil
}

type Update struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type   Update_Type `protobuf:"varint,1,opt,name=type,proto3,enum=p4.v1.Update_Type" json:"type,omitempty"`
	Entity *Entity     `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
}

func (x *Update) Reset() {
	*x = Update{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Update) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Update) ProtoMessage() {}

func (x *Update) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Update.ProtoReflect.Descriptor instead.
func (*Update) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{4}
}

func (x *Update) GetType() Update_Type {
	if x != nil {
		return x.Type
	}
	return Update_UNSPECIFIED
}

func (x *Update) GetEntity() *Entity {
	if x != nil {
		return x.Entity
	}
	return nil
}

type Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Entity:
	//
	//	*Entity_ExternEntry
	//	*Entity_TableEntry
	//	*Entity_ActionProfileMember
	//	*Entity_ActionProfileGroup
	//	*Entity_MeterEntry
	//	*Entity_DirectMeterEntry
	//	*Entity_CounterEntry
	//	*Entity_DirectCounterEntry
	//	*Entity_PacketReplicationEngineEntry
	//	*Entity_ValueSetEntry
	//	*Entity_RegisterEntry
	//	*Entity_DigestEntry
	Entity isEntity_Entity `protobuf_oneof:"entity"`
}

func (x *Entity) Reset() {
	*x = Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entity) ProtoMessage() {}

func (x *Entity) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entity.ProtoReflect.Descriptor instead.
func (*Entity) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{5}
}

func (m *Entity) GetEntity() isEntity_Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (x *Entity) GetExternEntry() *ExternEntry {
	if x, ok := x.GetEntity().(*Entity_ExternEntry); ok {
		return x.ExternEntry
	}
	return nil
}

func (x *Entity) GetTableEntry() *TableEntry {
	if x, ok := x.GetEntity().(*Entity_TableEntry); ok {
		return x.TableEntry
	}
	return nil
}

func (x *Entity) GetActionProfileMember() *ActionProfileMember {
	if x, ok := x.GetEntity().(*Entity_ActionProfileMember); ok {
		return x.ActionProfileMember
	}
	return nil
}

func (x *Entity) GetActionProfileGroup() *ActionProfileGroup {
	if x, ok := x.GetEntity().(*Entity_ActionProfileGroup); ok {
		return x.ActionProfileGroup
	}
	return nil
}

func (x *Entity) GetMeterEntry() *MeterEntry {
	if x, ok := x.GetEntity().(*Entity_MeterEntry); ok {
		return x.MeterEntry
	}
	return nil
}

func (x *Entity) GetDirectMeterEntry() *DirectMeterEntry {
	if x, ok := x.GetEntity().(*Entity_DirectMeterEntry); ok {
		return x.DirectMeterEntry
	}
	return nil
}

func (x *Entity) GetCounterEntry() *CounterEntry {
	if x, ok := x.GetEntity().(*Entity_CounterEntry); ok {
		return x.CounterEntry
	}
	return nil
}

func (x *Entity) GetDirectCounterEntry() *DirectCounterEntry {
	if x, ok := x.GetEntity().(*Entity_DirectCounterEntry); ok {
		return x.DirectCounterEntry
	}
	return nil
}

func (x *Entity) GetPacketReplicationEngineEntry() *PacketReplicationEngineEntry {
	if x, ok := x.GetEntity().(*Entity_PacketReplicationEngineEntry); ok {
		return x.PacketReplicationEngineEntry
	}
	return nil
}

func (x *Entity) GetValueSetEntry() *ValueSetEntry {
	if x, ok := x.GetEntity().(*Entity_ValueSetEntry); ok {
		return x.ValueSetEntry
	}
	return nil
}

func (x *Entity) GetRegisterEntry() *RegisterEntry {
	if x, ok := x.GetEntity().(*Entity_RegisterEntry); ok {
		return x.RegisterEntry
	}
	return nil
}

func (x *Entity) GetDigestEntry() *DigestEntry {
	if x, ok := x.GetEntity().(*Entity_DigestEntry); ok {
		return x.DigestEntry
	}
	return nil
}

type isEntity_Entity interface {
	isEntity_Entity()
}

type Entity_ExternEntry struct {
	ExternEntry *ExternEntry `protobuf:"bytes,1,opt,name=extern_entry,json=externEntry,proto3,oneof"`
}

type Entity_TableEntry struct {
	TableEntry *TableEntry `protobuf:"bytes,2,opt,name=table_entry,json=tableEntry,proto3,oneof"`
}

type Entity_ActionProfileMember struct {
	ActionProfileMember *ActionProfileMember `protobuf:"bytes,3,opt,name=action_profile_member,json=actionProfileMember,proto3,oneof"`
}

type Entity_ActionProfileGroup struct {
	ActionProfileGroup *ActionProfileGroup `protobuf:"bytes,4,opt,name=action_profile_group,json=actionProfileGroup,proto3,oneof"`
}

type Entity_MeterEntry struct {
	MeterEntry *MeterEntry `protobuf:"bytes,5,opt,name=meter_entry,json=meterEntry,proto3,oneof"`
}

type Entity_DirectMeterEntry struct {
	DirectMeterEntry *DirectMeterEntry `protobuf:"bytes,6,opt,name=direct_meter_entry,json=directMeterEntry,proto3,oneof"`
}

type Entity_CounterEntry struct {
	CounterEntry *CounterEntry `protobuf:"bytes,7,opt,name=counter_entry,json=counterEntry,proto3,oneof"`
}

type Entity_DirectCounterEntry struct {
	DirectCounterEntry *DirectCounterEntry `protobuf:"bytes,8,opt,name=direct_counter_entry,json=directCounterEntry,proto3,oneof"`
}

type Entity_PacketReplicationEngineEntry struct {
	PacketReplicationEngineEntry *PacketReplicationEngineEntry `protobuf:"bytes,9,opt,name=packet_replication_engine_entry,json=packetReplicationEngineEntry,proto3,oneof"`
}

type Entity_ValueSetEntry struct {
	ValueSetEntry *ValueSetEntry `protobuf:"bytes,10,opt,name=value_set_entry,json=valueSetEntry,proto3,oneof"`
}

type Entity_RegisterEntry struct {
	RegisterEntry *RegisterEntry `protobuf:"bytes,11,opt,name=register_entry,json=registerEntry,proto3,oneof"`
}

type Entity_DigestEntry struct {
	DigestEntry *DigestEntry `protobuf:"bytes,12,opt,name=digest_entry,json=digestEntry,proto3,oneof"`
}

func (*Entity_ExternEntry) isEntity_Entity() {}

func (*Entity_TableEntry) isEntity_Entity() {}

func (*Entity_ActionProfileMember) isEntity_Entity() {}

func (*Entity_ActionProfileGroup) isEntity_Entity() {}

func (*Entity_MeterEntry) isEntity_Entity() {}

func (*Entity_DirectMeterEntry) isEntity_Entity() {}

func (*Entity_CounterEntry) isEntity_Entity() {}

func (*Entity_DirectCounterEntry) isEntity_Entity() {}

func (*Entity_PacketReplicationEngineEntry) isEntity_Entity() {}

func (*Entity_ValueSetEntry) isEntity_Entity() {}

func (*Entity_RegisterEntry) isEntity_Entity() {}

func (*Entity_DigestEntry) isEntity_Entity() {}

type ExternEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the extern_type_id is unique for a given architecture and must be in the
	// range [0x81, 0xfe].
	ExternTypeId uint32     `protobuf:"varint,1,opt,name=extern_type_id,json=externTypeId,proto3" json:"extern_type_id,omitempty"`
	ExternId     uint32     `protobuf:"varint,2,opt,name=extern_id,json=externId,proto3" json:"extern_id,omitempty"` // id of the instance
	Entry        *anypb.Any `protobuf:"bytes,3,opt,name=entry,proto3" json:"entry,omitempty"`
}

func (x *ExternEntry) Reset() {
	*x = ExternEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExternEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternEntry) ProtoMessage() {}

func (x *ExternEntry) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternEntry.ProtoReflect.Descriptor instead.
func (*ExternEntry) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{6}
}

func (x *ExternEntry) GetExternTypeId() uint32 {
	if x != nil {
		return x.ExternTypeId
	}
	return 0
}

func (x *ExternEntry) GetExternId() uint32 {
	if x != nil {
		return x.ExternId
	}
	return 0
}

func (x *ExternEntry) GetEntry() *anypb.Any {
	if x != nil {
		return x.Entry
	}
	return nil
}

type TableEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TableId uint32        `protobuf:"varint,1,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	Match   []*FieldMatch `protobuf:"bytes,2,rep,name=match,proto3" json:"match,omitempty"`
	Action  *TableAction  `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
	// Should only be set if the match implies a TCAM lookup, i.e. at least one of
	// the match fields is Optional, Ternary or Range.  A higher number indicates
	// higher priority.  Only a highest priority entry that matches the packet
	// must be selected.  Multiple entries in the same table with the same
	// priority value are permitted.  See Section "TableEntry" in the
	// specification for details of the behavior.
	Priority int32 `protobuf:"varint,4,opt,name=priority,proto3" json:"priority,omitempty"`
	// Metadata (cookie) opaque to the target. There is no requirement of where
	// this is stored, as long as it is returned with the rest of the entry in
	// a Read RPC. This is deprecated in favor of the more flexible metadata
	// field.
	//
	// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
	ControllerMetadata uint64 `protobuf:"varint,5,opt,name=controller_metadata,json=controllerMetadata,proto3" json:"controller_metadata,omitempty"`
	// meter_config, counter_data and meter_counter_data are convenience fields
	// that enable the controller to configure the direct resources associated
	// with the table at the same time as a match-action entry is inserted or
	// modified.
	// Table write:
	//   - If the table does not contain a direct resource, then setting the
	//     corresponding direct resource field in any table write operation will
	//     return an error.
	//   - When inserting a new table entry, leaving these fields unset means that
	//     the direct resources of this table (if any) will assume default values.
	//     For counters, the default value is 0, and for meters, the default value
	//     is always green.
	//   - When updating a table entry, leaving meter_config unset will reset the
	//     meter (if any) to its default configuration, while leaving counter_data
	//     or meter_counter_data unset means that the counter (if any) will not be
	//     updated.
	//
	// Table read:
	//   - If the table does not contain a direct resource, then the corresponding
	//     field will not be set in the read table entry.
	//   - If meter_config is unset in the request, or if the meter has a default
	//     configuration, meter_config will not be set in the response.
	//   - If counter_data or meter_counter_data is unset in the request, it will
	//     be unset in the response as well.
	MeterConfig *MeterConfig `protobuf:"bytes,6,opt,name=meter_config,json=meterConfig,proto3" json:"meter_config,omitempty"`
	CounterData *CounterData `protobuf:"bytes,7,opt,name=counter_data,json=counterData,proto3" json:"counter_data,omitempty"`
	// Per color counters for tables with a direct meter.
	// Added in v1.4.0
	MeterCounterData *MeterCounterData `protobuf:"bytes,12,opt,name=meter_counter_data,json=meterCounterData,proto3" json:"meter_counter_data,omitempty"`
	// Set to true if the table entry is being used to update the non-const
	// default action of the table. If true, the "match" field must be empty and
	// the "action" field must be populated with a valid direct action.
	IsDefaultAction bool `protobuf:"varint,8,opt,name=is_default_action,json=isDefaultAction,proto3" json:"is_default_action,omitempty"`
	// The TTL for the entry, in nanoseconds. A value of 0 means that the table
	// entry never "expires".
	IdleTimeoutNs int64 `protobuf:"varint,9,opt,name=idle_timeout_ns,json=idleTimeoutNs,proto3" json:"idle_timeout_ns,omitempty"`
	// Table write: this field should be left unset.
	// Table read: if the table supports idle timeout and time_since_last_hit is
	// set in the request, this field will be set in the response.
	TimeSinceLastHit *TableEntry_IdleTimeout `protobuf:"bytes,10,opt,name=time_since_last_hit,json=timeSinceLastHit,proto3" json:"time_since_last_hit,omitempty"`
	// Arbitrary metadata from the controller that is opaque to the target.
	Metadata []byte `protobuf:"bytes,11,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// True if and only if the entry cannot be deleted or modified,
	// i.e. any of the following:
	//   - Any entry read from a table declared with `const entries`
	//   - The default entry read from a table declared with `const
	//     default_action`
	//   - Any entry declared with `entries` without the `const` qualifier
	//     before `entries`, where the individual entry has the `const`
	//     qualifier on it in the P4 source code.
	//
	// Note: Older P4Runtime API servers before the `is_const` field was
	// added to this message will not return a value for `is_const` in
	// the first two cases above, but newer P4Runtime API servers will.
	// Added in 1.4.0.
	IsConst bool `protobuf:"varint,13,opt,name=is_const,json=isConst,proto3" json:"is_const,omitempty"`
}

func (x *TableEntry) Reset() {
	*x = TableEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableEntry) ProtoMessage() {}

func (x *TableEntry) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableEntry.ProtoReflect.Descriptor instead.
func (*TableEntry) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{7}
}

func (x *TableEntry) GetTableId() uint32 {
	if x != nil {
		return x.TableId
	}
	return 0
}

func (x *TableEntry) GetMatch() []*FieldMatch {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *TableEntry) GetAction() *TableAction {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *TableEntry) GetPriority() int32 {
	if x != nil {
		return x.Priority
	}
	return 0
}

// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
func (x *TableEntry) GetControllerMetadata() uint64 {
	if x != nil {
		return x.ControllerMetadata
	}
	return 0
}

func (x *TableEntry) GetMeterConfig() *MeterConfig {
	if x != nil {
		return x.MeterConfig
	}
	return nil
}

func (x *TableEntry) GetCounterData() *CounterData {
	if x != nil {
		return x.CounterData
	}
	return nil
}

func (x *TableEntry) GetMeterCounterData() *MeterCounterData {
	if x != nil {
		return x.MeterCounterData
	}
	return nil
}

func (x *TableEntry) GetIsDefaultAction() bool {
	if x != nil {
		return x.IsDefaultAction
	}
	return false
}

func (x *TableEntry) GetIdleTimeoutNs() int64 {
	if x != nil {
		return x.IdleTimeoutNs
	}
	return 0
}

func (x *TableEntry) GetTimeSinceLastHit() *TableEntry_IdleTimeout {
	if x != nil {
		return x.TimeSinceLastHit
	}
	return nil
}

func (x *TableEntry) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *TableEntry) GetIsConst() bool {
	if x != nil {
		return x.IsConst
	}
	return false
}

// field_match_type ::= exact | ternary | lpm | range | optional
type FieldMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	FieldId uint32 `protobuf:"varint,1,opt,name=field_id,json=fieldId,proto3" json:"field_id,omitempty"`
	// Types that are assignable to FieldMatchType:
	//
	//	*FieldMatch_Exact_
	//	*FieldMatch_Ternary_
	//	*FieldMatch_Lpm
	//	*FieldMatch_Range_
	//	*FieldMatch_Optional_
	//	*FieldMatch_Other
	FieldMatchType isFieldMatch_FieldMatchType `protobuf_oneof:"field_match_type"`
}

func (x *FieldMatch) Reset() {
	*x = FieldMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldMatch) ProtoMessage() {}

func (x *FieldMatch) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldMatch.ProtoReflect.Descriptor instead.
func (*FieldMatch) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{8}
}

func (x *FieldMatch) GetFieldId() uint32 {
	if x != nil {
		return x.FieldId
	}
	return 0
}

func (m *FieldMatch) GetFieldMatchType() isFieldMatch_FieldMatchType {
	if m != nil {
		return m.FieldMatchType
	}
	return nil
}

func (x *FieldMatch) GetExact() *FieldMatch_Exact {
	if x, ok := x.GetFieldMatchType().(*FieldMatch_Exact_); ok {
		return x.Exact
	}
	return nil
}

func (x *FieldMatch) GetTernary() *FieldMatch_Ternary {
	if x, ok := x.GetFieldMatchType().(*FieldMatch_Ternary_); ok {
		return x.Ternary
	}
	return nil
}

func (x *FieldMatch) GetLpm() *FieldMatch_LPM {
	if x, ok := x.GetFieldMatchType().(*FieldMatch_Lpm); ok {
		return x.Lpm
	}
	return nil
}

func (x *FieldMatch) GetRange() *FieldMatch_Range {
	if x, ok := x.GetFieldMatchType().(*FieldMatch_Range_); ok {
		return x.Range
	}
	return nil
}

func (x *FieldMatch) GetOptional() *FieldMatch_Optional {
	if x, ok := x.GetFieldMatchType().(*FieldMatch_Optional_); ok {
		return x.Optional
	}
	return nil
}

func (x *FieldMatch) GetOther() *anypb.Any {
	if x, ok := x.GetFieldMatchType().(*FieldMatch_Other); ok {
		return x.Other
	}
	return nil
}

type isFieldMatch_FieldMatchType interface {
	isFieldMatch_FieldMatchType()
}

type FieldMatch_Exact_ struct {
	Exact *FieldMatch_Exact `protobuf:"bytes,2,opt,name=exact,proto3,oneof"`
}

type FieldMatch_Ternary_ struct {
	Ternary *FieldMatch_Ternary `protobuf:"bytes,3,opt,name=ternary,proto3,oneof"`
}

type FieldMatch_Lpm struct {
	Lpm *FieldMatch_LPM `protobuf:"bytes,4,opt,name=lpm,proto3,oneof"`
}

type FieldMatch_Range_ struct {
	Range *FieldMatch_Range `protobuf:"bytes,6,opt,name=range,proto3,oneof"`
}

type FieldMatch_Optional_ struct {
	Optional *FieldMatch_Optional `protobuf:"bytes,7,opt,name=optional,proto3,oneof"`
}

type FieldMatch_Other struct {
	// Architecture-specific match value; it corresponds to the other_match_type
	// in the P4Info MatchField message.
	Other *anypb.Any `protobuf:"bytes,100,opt,name=other,proto3,oneof"`
}

func (*FieldMatch_Exact_) isFieldMatch_FieldMatchType() {}

func (*FieldMatch_Ternary_) isFieldMatch_FieldMatchType() {}

func (*FieldMatch_Lpm) isFieldMatch_FieldMatchType() {}

func (*FieldMatch_Range_) isFieldMatch_FieldMatchType() {}

func (*FieldMatch_Optional_) isFieldMatch_FieldMatchType() {}

func (*FieldMatch_Other) isFieldMatch_FieldMatchType() {}

// table_actions ::= action_specification | action_profile_specification
type TableAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*TableAction_Action
	//	*TableAction_ActionProfileMemberId
	//	*TableAction_ActionProfileGroupId
	//	*TableAction_ActionProfileActionSet
	Type isTableAction_Type `protobuf_oneof:"type"`
}

func (x *TableAction) Reset() {
	*x = TableAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableAction) ProtoMessage() {}

func (x *TableAction) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableAction.ProtoReflect.Descriptor instead.
func (*TableAction) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{9}
}

func (m *TableAction) GetType() isTableAction_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *TableAction) GetAction() *Action {
	if x, ok := x.GetType().(*TableAction_Action); ok {
		return x.Action
	}
	return nil
}

func (x *TableAction) GetActionProfileMemberId() uint32 {
	if x, ok := x.GetType().(*TableAction_ActionProfileMemberId); ok {
		return x.ActionProfileMemberId
	}
	return 0
}

func (x *TableAction) GetActionProfileGroupId() uint32 {
	if x, ok := x.GetType().(*TableAction_ActionProfileGroupId); ok {
		return x.ActionProfileGroupId
	}
	return 0
}

func (x *TableAction) GetActionProfileActionSet() *ActionProfileActionSet {
	if x, ok := x.GetType().(*TableAction_ActionProfileActionSet); ok {
		return x.ActionProfileActionSet
	}
	return nil
}

type isTableAction_Type interface {
	isTableAction_Type()
}

type TableAction_Action struct {
	Action *Action `protobuf:"bytes,1,opt,name=action,proto3,oneof"`
}

type TableAction_ActionProfileMemberId struct {
	ActionProfileMemberId uint32 `protobuf:"varint,2,opt,name=action_profile_member_id,json=actionProfileMemberId,proto3,oneof"`
}

type TableAction_ActionProfileGroupId struct {
	ActionProfileGroupId uint32 `protobuf:"varint,3,opt,name=action_profile_group_id,json=actionProfileGroupId,proto3,oneof"`
}

type TableAction_ActionProfileActionSet struct {
	ActionProfileActionSet *ActionProfileActionSet `protobuf:"bytes,4,opt,name=action_profile_action_set,json=actionProfileActionSet,proto3,oneof"`
}

func (*TableAction_Action) isTableAction_Type() {}

func (*TableAction_ActionProfileMemberId) isTableAction_Type() {}

func (*TableAction_ActionProfileGroupId) isTableAction_Type() {}

func (*TableAction_ActionProfileActionSet) isTableAction_Type() {}

type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ActionId uint32          `protobuf:"varint,1,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	Params   []*Action_Param `protobuf:"bytes,4,rep,name=params,proto3" json:"params,omitempty"`
}

func (x *Action) Reset() {
	*x = Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{10}
}

func (x *Action) GetActionId() uint32 {
	if x != nil {
		return x.ActionId
	}
	return 0
}

func (x *Action) GetParams() []*Action_Param {
	if x != nil {
		return x.Params
	}
	return nil
}

type ActionProfileActionSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ActionProfileActions []*ActionProfileAction `protobuf:"bytes,1,rep,name=action_profile_actions,json=actionProfileActions,proto3" json:"action_profile_actions,omitempty"`
}

func (x *ActionProfileActionSet) Reset() {
	*x = ActionProfileActionSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionProfileActionSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionProfileActionSet) ProtoMessage() {}

func (x *ActionProfileActionSet) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionProfileActionSet.ProtoReflect.Descriptor instead.
func (*ActionProfileActionSet) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{11}
}

func (x *ActionProfileActionSet) GetActionProfileActions() []*ActionProfileAction {
	if x != nil {
		return x.ActionProfileActions
	}
	return nil
}

type ActionProfileAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Action *Action `protobuf:"bytes,1,opt,name=action,proto3" json:"action,omitempty"`
	Weight int32   `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	// Types that are assignable to WatchKind:
	//
	//	*ActionProfileAction_Watch
	//	*ActionProfileAction_WatchPort
	WatchKind isActionProfileAction_WatchKind `protobuf_oneof:"watch_kind"`
}

func (x *ActionProfileAction) Reset() {
	*x = ActionProfileAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionProfileAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionProfileAction) ProtoMessage() {}

func (x *ActionProfileAction) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionProfileAction.ProtoReflect.Descriptor instead.
func (*ActionProfileAction) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{12}
}

func (x *ActionProfileAction) GetAction() *Action {
	if x != nil {
		return x.Action
	}
	return nil
}

func (x *ActionProfileAction) GetWeight() int32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (m *ActionProfileAction) GetWatchKind() isActionProfileAction_WatchKind {
	if m != nil {
		return m.WatchKind
	}
	return nil
}

// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
func (x *ActionProfileAction) GetWatch() int32 {
	if x, ok := x.GetWatchKind().(*ActionProfileAction_Watch); ok {
		return x.Watch
	}
	return 0
}

func (x *ActionProfileAction) GetWatchPort() []byte {
	if x, ok := x.GetWatchKind().(*ActionProfileAction_WatchPort); ok {
		return x.WatchPort
	}
	return nil
}

type isActionProfileAction_WatchKind interface {
	isActionProfileAction_WatchKind()
}

type ActionProfileAction_Watch struct {
	// Using int32 as ports is deprecated, use watch_port instead.
	//
	// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
	Watch int32 `protobuf:"varint,3,opt,name=watch,proto3,oneof"`
}

type ActionProfileAction_WatchPort struct {
	WatchPort []byte `protobuf:"bytes,4,opt,name=watch_port,json=watchPort,proto3,oneof"`
}

func (*ActionProfileAction_Watch) isActionProfileAction_WatchKind() {}

func (*ActionProfileAction_WatchPort) isActionProfileAction_WatchKind() {}

// ------------------------------------------------------------------------------
type ActionProfileMember struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ActionProfileId uint32  `protobuf:"varint,1,opt,name=action_profile_id,json=actionProfileId,proto3" json:"action_profile_id,omitempty"`
	MemberId        uint32  `protobuf:"varint,2,opt,name=member_id,json=memberId,proto3" json:"member_id,omitempty"`
	Action          *Action `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
}

func (x *ActionProfileMember) Reset() {
	*x = ActionProfileMember{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionProfileMember) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionProfileMember) ProtoMessage() {}

func (x *ActionProfileMember) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionProfileMember.ProtoReflect.Descriptor instead.
func (*ActionProfileMember) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{13}
}

func (x *ActionProfileMember) GetActionProfileId() uint32 {
	if x != nil {
		return x.ActionProfileId
	}
	return 0
}

func (x *ActionProfileMember) GetMemberId() uint32 {
	if x != nil {
		return x.MemberId
	}
	return 0
}

func (x *ActionProfileMember) GetAction() *Action {
	if x != nil {
		return x.Action
	}
	return nil
}

// ------------------------------------------------------------------------------
type ActionProfileGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ActionProfileId uint32                       `protobuf:"varint,1,opt,name=action_profile_id,json=actionProfileId,proto3" json:"action_profile_id,omitempty"`
	GroupId         uint32                       `protobuf:"varint,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	Members         []*ActionProfileGroup_Member `protobuf:"bytes,3,rep,name=members,proto3" json:"members,omitempty"`
	// Max number of weighted member entries in this group. It cannot be modified
	// after a group has been created. It must not exceed the static
	// max_group_size included in P4Info. If the max size is not known at group
	// creation-time, the client may leave this field unset (default value 0), in
	// which case the static max_group_size value will be used and the group will
	// be able to include up to max_group_size weighted member entries.
	MaxSize int32 `protobuf:"varint,4,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
}

func (x *ActionProfileGroup) Reset() {
	*x = ActionProfileGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionProfileGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionProfileGroup) ProtoMessage() {}

func (x *ActionProfileGroup) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionProfileGroup.ProtoReflect.Descriptor instead.
func (*ActionProfileGroup) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{14}
}

func (x *ActionProfileGroup) GetActionProfileId() uint32 {
	if x != nil {
		return x.ActionProfileId
	}
	return 0
}

func (x *ActionProfileGroup) GetGroupId() uint32 {
	if x != nil {
		return x.GroupId
	}
	return 0
}

func (x *ActionProfileGroup) GetMembers() []*ActionProfileGroup_Member {
	if x != nil {
		return x.Members
	}
	return nil
}

func (x *ActionProfileGroup) GetMaxSize() int32 {
	if x != nil {
		return x.MaxSize
	}
	return 0
}

// An index as a protobuf message. In proto3, fields cannot be optional and
// there is no difference between an unset integer field and an integer field
// set to 0. This is inconvenient for reading from P4 array-like structures,
// such as indirect counters and meters. We need a way to do a wildcard read on
// these but we cannot use a default zero index value to do so, as zero is a
// valid index (first entry in the array). We therefore wrap the index in a
// message.
type Index struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Index int64 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
}

func (x *Index) Reset() {
	*x = Index{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Index) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Index) ProtoMessage() {}

func (x *Index) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Index.ProtoReflect.Descriptor instead.
func (*Index) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{15}
}

func (x *Index) GetIndex() int64 {
	if x != nil {
		return x.Index
	}
	return 0
}

// ------------------------------------------------------------------------------
// For WriteRequest, Update.Type must be MODIFY.
// For ReadRequest, the scope is defined as follows:
// - All meter cells for all meters if meter_id = 0 (default).
// - All meter cells for given meter_id if index is unset (default).
type MeterEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MeterId uint32       `protobuf:"varint,1,opt,name=meter_id,json=meterId,proto3" json:"meter_id,omitempty"`
	Index   *Index       `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
	Config  *MeterConfig `protobuf:"bytes,3,opt,name=config,proto3" json:"config,omitempty"`
	// Added in v1.4.0
	CounterData *MeterCounterData `protobuf:"bytes,4,opt,name=counter_data,json=counterData,proto3" json:"counter_data,omitempty"`
}

func (x *MeterEntry) Reset() {
	*x = MeterEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MeterEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeterEntry) ProtoMessage() {}

func (x *MeterEntry) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeterEntry.ProtoReflect.Descriptor instead.
func (*MeterEntry) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{16}
}

func (x *MeterEntry) GetMeterId() uint32 {
	if x != nil {
		return x.MeterId
	}
	return 0
}

func (x *MeterEntry) GetIndex() *Index {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *MeterEntry) GetConfig() *MeterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *MeterEntry) GetCounterData() *MeterCounterData {
	if x != nil {
		return x.CounterData
	}
	return nil
}

// ------------------------------------------------------------------------------
// For WriteRequest, Update.Type must be MODIFY. INSERT and DELETE on direct
// meters is not allowed and will return an error. The insertion/deletion
// should happen as part of INSERT/DELETE on the associated table-entry.
// For ReadRequest, the scope is defined as follows:
//   - All meter cells for all tables if table_entry.table_id = 0.
//   - All meter cells of a table if table_entry.table_id is present and
//     table_entry.match is empty.
type DirectMeterEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The associated table entry. This field is required.
	// table_entry.action is ignored. Other fields specify the match.
	TableEntry *TableEntry  `protobuf:"bytes,1,opt,name=table_entry,json=tableEntry,proto3" json:"table_entry,omitempty"`
	Config     *MeterConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Added in v1.4.0
	CounterData *MeterCounterData `protobuf:"bytes,3,opt,name=counter_data,json=counterData,proto3" json:"counter_data,omitempty"`
}

func (x *DirectMeterEntry) Reset() {
	*x = DirectMeterEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectMeterEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectMeterEntry) ProtoMessage() {}

func (x *DirectMeterEntry) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectMeterEntry.ProtoReflect.Descriptor instead.
func (*DirectMeterEntry) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{17}
}

func (x *DirectMeterEntry) GetTableEntry() *TableEntry {
	if x != nil {
		return x.TableEntry
	}
	return nil
}

func (x *DirectMeterEntry) GetConfig() *MeterConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *DirectMeterEntry) GetCounterData() *MeterCounterData {
	if x != nil {
		return x.CounterData
	}
	return nil
}

// Modeled to support both RFC 2698: A Two Rate Three Color Marker (trTCM) and
// RFC 2697: A Single Rate Three Color Marker (srTCM) based on the `type` of the
// corresponding MeterSpec.
//
// The trTCM meters a packet stream and marks its packets based on two rates,
// Peak Information Rate (PIR) and Committed Information Rate (CIR), and their
// associated burst sizes to be either green, yellow, or red.  A packet is
// marked red if it exceeds the PIR.  Otherwise it is marked either yellow or
// green depending on whether it exceeds or doesn't exceed the CIR. For this
// meter type, `eburst` must be unset.
//
// The srTCM meters a packet stream and marks its packets based on one rate,
// Committed Information Rate (CIR), and its associated burst size as well as an
// Excess Burst Size (EBS) to be either green, yellow, or red. Roughly, a packet
// is marked green if it doesn't exceed the CIR.  Otherwise it is marked either
// yellow or green depending on whether it exceeds or doesn't exceed the EBS.
// For this meter type, it must be the case that `cir == pir && cburst ==
// pburst`.
type MeterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Committed information rate (units per sec)
	Cir int64 `protobuf:"varint,1,opt,name=cir,proto3" json:"cir,omitempty"`
	// Committed burst size
	Cburst int64 `protobuf:"varint,2,opt,name=cburst,proto3" json:"cburst,omitempty"`
	// Peak information rate (units per sec)
	Pir int64 `protobuf:"varint,3,opt,name=pir,proto3" json:"pir,omitempty"`
	// Peak burst size
	Pburst int64 `protobuf:"varint,4,opt,name=pburst,proto3" json:"pburst,omitempty"`
	// Excess burst size (only used by srTCM).
	// Added in 1.4.0.
	Eburst int64 `protobuf:"varint,5,opt,name=eburst,proto3" json:"eburst,omitempty"`
}

func (x *MeterConfig) Reset() {
	*x = MeterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MeterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeterConfig) ProtoMessage() {}

func (x *MeterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeterConfig.ProtoReflect.Descriptor instead.
func (*MeterConfig) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{18}
}

func (x *MeterConfig) GetCir() int64 {
	if x != nil {
		return x.Cir
	}
	return 0
}

func (x *MeterConfig) GetCburst() int64 {
	if x != nil {
		return x.Cburst
	}
	return 0
}

func (x *MeterConfig) GetPir() int64 {
	if x != nil {
		return x.Pir
	}
	return 0
}

func (x *MeterConfig) GetPburst() int64 {
	if x != nil {
		return x.Pburst
	}
	return 0
}

func (x *MeterConfig) GetEburst() int64 {
	if x != nil {
		return x.Eburst
	}
	return 0
}

// ------------------------------------------------------------------------------
// For WriteRequest, Update.Type must be MODIFY.
// For ReadRequest, the scope is defined as follows:
// - All counter cells for all counters if counter_id = 0 (default).
// - All counter cells for given counter_id if index is unset (default).
type CounterEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CounterId uint32       `protobuf:"varint,1,opt,name=counter_id,json=counterId,proto3" json:"counter_id,omitempty"`
	Index     *Index       `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
	Data      *CounterData `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *CounterEntry) Reset() {
	*x = CounterEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CounterEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CounterEntry) ProtoMessage() {}

func (x *CounterEntry) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CounterEntry.ProtoReflect.Descriptor instead.
func (*CounterEntry) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{19}
}

func (x *CounterEntry) GetCounterId() uint32 {
	if x != nil {
		return x.CounterId
	}
	return 0
}

func (x *CounterEntry) GetIndex() *Index {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *CounterEntry) GetData() *CounterData {
	if x != nil {
		return x.Data
	}
	return nil
}

// ------------------------------------------------------------------------------
// For WriteRequest, Update.Type must be MODIFY. INSERT and DELETE on direct
// counters is not allowed and will return an error. The insertion/deletion
// should happen as part of INSERT/DELETE on the associated table-entry.
// For ReadRequest, the scope is defined as follows:
//   - All counter cells for all tables if table_entry.table_id = 0.
//   - All counter cells of a table if table_entry.table_id is present and
//     table_entry.match is empty.
type DirectCounterEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The associated table entry. This field is required.
	// table_entry.action is ignored. Other fields specify the match.
	TableEntry *TableEntry  `protobuf:"bytes,1,opt,name=table_entry,json=tableEntry,proto3" json:"table_entry,omitempty"`
	Data       *CounterData `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *DirectCounterEntry) Reset() {
	*x = DirectCounterEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DirectCounterEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectCounterEntry) ProtoMessage() {}

func (x *DirectCounterEntry) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectCounterEntry.ProtoReflect.Descriptor instead.
func (*DirectCounterEntry) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{20}
}

func (x *DirectCounterEntry) GetTableEntry() *TableEntry {
	if x != nil {
		return x.TableEntry
	}
	return nil
}

func (x *DirectCounterEntry) GetData() *CounterData {
	if x != nil {
		return x.Data
	}
	return nil
}

type CounterData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ByteCount   int64 `protobuf:"varint,1,opt,name=byte_count,json=byteCount,proto3" json:"byte_count,omitempty"`
	PacketCount int64 `protobuf:"varint,2,opt,name=packet_count,json=packetCount,proto3" json:"packet_count,omitempty"`
}

func (x *CounterData) Reset() {
	*x = CounterData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CounterData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CounterData) ProtoMessage() {}

func (x *CounterData) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CounterData.ProtoReflect.Descriptor instead.
func (*CounterData) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{21}
}

func (x *CounterData) GetByteCount() int64 {
	if x != nil {
		return x.ByteCount
	}
	return 0
}

func (x *CounterData) GetPacketCount() int64 {
	if x != nil {
		return x.PacketCount
	}
	return 0
}

// Added in v1.4.0
type MeterCounterData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Green  *CounterData `protobuf:"bytes,1,opt,name=green,proto3" json:"green,omitempty"`
	Yellow *CounterData `protobuf:"bytes,2,opt,name=yellow,proto3" json:"yellow,omitempty"`
	Red    *CounterData `protobuf:"bytes,3,opt,name=red,proto3" json:"red,omitempty"`
}

func (x *MeterCounterData) Reset() {
	*x = MeterCounterData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MeterCounterData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeterCounterData) ProtoMessage() {}

func (x *MeterCounterData) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeterCounterData.ProtoReflect.Descriptor instead.
func (*MeterCounterData) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{22}
}

func (x *MeterCounterData) GetGreen() *CounterData {
	if x != nil {
		return x.Green
	}
	return nil
}

func (x *MeterCounterData) GetYellow() *CounterData {
	if x != nil {
		return x.Yellow
	}
	return nil
}

func (x *MeterCounterData) GetRed() *CounterData {
	if x != nil {
		return x.Red
	}
	return nil
}

// ------------------------------------------------------------------------------
// Only one instance of a Packet Replication Engine (PRE) is expected in the
// P4 pipeline. Hence, no instance id is needed to access the PRE.
type PacketReplicationEngineEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*PacketReplicationEngineEntry_MulticastGroupEntry
	//	*PacketReplicationEngineEntry_CloneSessionEntry
	Type isPacketReplicationEngineEntry_Type `protobuf_oneof:"type"`
}

func (x *PacketReplicationEngineEntry) Reset() {
	*x = PacketReplicationEngineEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketReplicationEngineEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketReplicationEngineEntry) ProtoMessage() {}

func (x *PacketReplicationEngineEntry) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketReplicationEngineEntry.ProtoReflect.Descriptor instead.
func (*PacketReplicationEngineEntry) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{23}
}

func (m *PacketReplicationEngineEntry) GetType() isPacketReplicationEngineEntry_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *PacketReplicationEngineEntry) GetMulticastGroupEntry() *MulticastGroupEntry {
	if x, ok := x.GetType().(*PacketReplicationEngineEntry_MulticastGroupEntry); ok {
		return x.MulticastGroupEntry
	}
	return nil
}

func (x *PacketReplicationEngineEntry) GetCloneSessionEntry() *CloneSessionEntry {
	if x, ok := x.GetType().(*PacketReplicationEngineEntry_CloneSessionEntry); ok {
		return x.CloneSessionEntry
	}
	return nil
}

type isPacketReplicationEngineEntry_Type interface {
	isPacketReplicationEngineEntry_Type()
}

type PacketReplicationEngineEntry_MulticastGroupEntry struct {
	MulticastGroupEntry *MulticastGroupEntry `protobuf:"bytes,1,opt,name=multicast_group_entry,json=multicastGroupEntry,proto3,oneof"`
}

type PacketReplicationEngineEntry_CloneSessionEntry struct {
	CloneSessionEntry *CloneSessionEntry `protobuf:"bytes,2,opt,name=clone_session_entry,json=cloneSessionEntry,proto3,oneof"`
}

func (*PacketReplicationEngineEntry_MulticastGroupEntry) isPacketReplicationEngineEntry_Type() {}

func (*PacketReplicationEngineEntry_CloneSessionEntry) isPacketReplicationEngineEntry_Type() {}

// Used for replicas created for cloning and multicasting actions.
type Replica struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to PortKind:
	//
	//	*Replica_EgressPort
	//	*Replica_Port
	PortKind isReplica_PortKind `protobuf_oneof:"port_kind"`
	Instance uint32             `protobuf:"varint,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *Replica) Reset() {
	*x = Replica{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Replica) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Replica) ProtoMessage() {}

func (x *Replica) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Replica.ProtoReflect.Descriptor instead.
func (*Replica) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{24}
}

func (m *Replica) GetPortKind() isReplica_PortKind {
	if m != nil {
		return m.PortKind
	}
	return nil
}

// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
func (x *Replica) GetEgressPort() uint32 {
	if x, ok := x.GetPortKind().(*Replica_EgressPort); ok {
		return x.EgressPort
	}
	return 0
}

func (x *Replica) GetPort() []byte {
	if x, ok := x.GetPortKind().(*Replica_Port); ok {
		return x.Port
	}
	return nil
}

func (x *Replica) GetInstance() uint32 {
	if x != nil {
		return x.Instance
	}
	return 0
}

type isReplica_PortKind interface {
	isReplica_PortKind()
}

type Replica_EgressPort struct {
	// Using uint32 as ports is deprecated, use port field instead.
	// Deprecated in v1.4.0
	//
	// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
	EgressPort uint32 `protobuf:"varint,1,opt,name=egress_port,json=egressPort,proto3,oneof"`
}

type Replica_Port struct {
	// Added in v1.4.0
	Port []byte `protobuf:"bytes,3,opt,name=port,proto3,oneof"`
}

func (*Replica_EgressPort) isReplica_PortKind() {}

func (*Replica_Port) isReplica_PortKind() {}

// The (port, instance) pair must be unique for each replica in a given
// multicast group entry. A packet may be multicast by setting the
// multicast_group field of PSA ingress output metadata to multicast_group_id
// of a programmed multicast group entry. The port and instance fields of each
// replica's egress input metadata will be set to the respective values
// programmed in the multicast group entry.
type MulticastGroupEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MulticastGroupId uint32     `protobuf:"varint,1,opt,name=multicast_group_id,json=multicastGroupId,proto3" json:"multicast_group_id,omitempty"`
	Replicas         []*Replica `protobuf:"bytes,2,rep,name=replicas,proto3" json:"replicas,omitempty"`
	// Arbitrary metadata from the controller that is opaque to the target.
	// Added in 1.4.0.
	Metadata []byte `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *MulticastGroupEntry) Reset() {
	*x = MulticastGroupEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MulticastGroupEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MulticastGroupEntry) ProtoMessage() {}

func (x *MulticastGroupEntry) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MulticastGroupEntry.ProtoReflect.Descriptor instead.
func (*MulticastGroupEntry) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{25}
}

func (x *MulticastGroupEntry) GetMulticastGroupId() uint32 {
	if x != nil {
		return x.MulticastGroupId
	}
	return 0
}

func (x *MulticastGroupEntry) GetReplicas() []*Replica {
	if x != nil {
		return x.Replicas
	}
	return nil
}

func (x *MulticastGroupEntry) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// A packet may be cloned by setting the clone_session_id field of PSA
// ingress/egress output metadata to session_id of a programmed clone session
// entry. Multiple clones may be created via a single clone session entry by
// using the replicas message. The clones may be distinguished in the egress
// using the instance field. The class_of_service field of the clone's egress
// input metadata will be set to the respective value programmed in the clone
// session entry. Note that in case of multiple clones, all clones, defined
// for a clone session, will get the same class of service. The
// packet_length_bytes field must be set to a non-zero value if the clone
// packet(s) should be truncated to the given value (in bytes). The packet
// length is also common to all clones in the clone session. If the
// packet_length_bytes field is 0, no truncation on the clone(s) will be
// performed.
type CloneSessionEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SessionId         uint32     `protobuf:"varint,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	Replicas          []*Replica `protobuf:"bytes,2,rep,name=replicas,proto3" json:"replicas,omitempty"`
	ClassOfService    uint32     `protobuf:"varint,3,opt,name=class_of_service,json=classOfService,proto3" json:"class_of_service,omitempty"`
	PacketLengthBytes int32      `protobuf:"varint,4,opt,name=packet_length_bytes,json=packetLengthBytes,proto3" json:"packet_length_bytes,omitempty"`
}

func (x *CloneSessionEntry) Reset() {
	*x = CloneSessionEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloneSessionEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloneSessionEntry) ProtoMessage() {}

func (x *CloneSessionEntry) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloneSessionEntry.ProtoReflect.Descriptor instead.
func (*CloneSessionEntry) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{26}
}

func (x *CloneSessionEntry) GetSessionId() uint32 {
	if x != nil {
		return x.SessionId
	}
	return 0
}

func (x *CloneSessionEntry) GetReplicas() []*Replica {
	if x != nil {
		return x.Replicas
	}
	return nil
}

func (x *CloneSessionEntry) GetClassOfService() uint32 {
	if x != nil {
		return x.ClassOfService
	}
	return 0
}

func (x *CloneSessionEntry) GetPacketLengthBytes() int32 {
	if x != nil {
		return x.PacketLengthBytes
	}
	return 0
}

// A member in a P4 value set. Each member defines a list of matches, which can
// have different match types.
type ValueSetMember struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Match []*FieldMatch `protobuf:"bytes,1,rep,name=match,proto3" json:"match,omitempty"`
}

func (x *ValueSetMember) Reset() {
	*x = ValueSetMember{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValueSetMember) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueSetMember) ProtoMessage() {}

func (x *ValueSetMember) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueSetMember.ProtoReflect.Descriptor instead.
func (*ValueSetMember) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{27}
}

func (x *ValueSetMember) GetMatch() []*FieldMatch {
	if x != nil {
		return x.Match
	}
	return nil
}

// ------------------------------------------------------------------------------
// For writing and reading matches in a parser value set. A state transition
// on an empty value set will never be taken. The number of matches must be at
// most the size of the value set as specified by the size argument of the
// value_set constructor in the P4 program.
//
// For Write Requests:
//   - MODIFY will write the given matches in the repeated field to the value
//     set.
//   - INSERT and DELETE are not allowed.
//
// For Read Requests:
//   - All matches for all value-set entries if value_set_id = 0
//   - All matches of the value-set if a valid value_set_id is specified
//   - The 'match' field must never be set in the ReadRequest
type ValueSetEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ValueSetId uint32            `protobuf:"varint,1,opt,name=value_set_id,json=valueSetId,proto3" json:"value_set_id,omitempty"`
	Members    []*ValueSetMember `protobuf:"bytes,2,rep,name=members,proto3" json:"members,omitempty"`
}

func (x *ValueSetEntry) Reset() {
	*x = ValueSetEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ValueSetEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueSetEntry) ProtoMessage() {}

func (x *ValueSetEntry) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueSetEntry.ProtoReflect.Descriptor instead.
func (*ValueSetEntry) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{28}
}

func (x *ValueSetEntry) GetValueSetId() uint32 {
	if x != nil {
		return x.ValueSetId
	}
	return 0
}

func (x *ValueSetEntry) GetMembers() []*ValueSetMember {
	if x != nil {
		return x.Members
	}
	return nil
}

// ------------------------------------------------------------------------------
type RegisterEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RegisterId uint32  `protobuf:"varint,1,opt,name=register_id,json=registerId,proto3" json:"register_id,omitempty"`
	Index      *Index  `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
	Data       *P4Data `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *RegisterEntry) Reset() {
	*x = RegisterEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterEntry) ProtoMessage() {}

func (x *RegisterEntry) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterEntry.ProtoReflect.Descriptor instead.
func (*RegisterEntry) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{29}
}

func (x *RegisterEntry) GetRegisterId() uint32 {
	if x != nil {
		return x.RegisterId
	}
	return 0
}

func (x *RegisterEntry) GetIndex() *Index {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *RegisterEntry) GetData() *P4Data {
	if x != nil {
		return x.Data
	}
	return nil
}

// ------------------------------------------------------------------------------
// Used to configure the digest extern only, not to stream digests or acks
type DigestEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DigestId uint32              `protobuf:"varint,1,opt,name=digest_id,json=digestId,proto3" json:"digest_id,omitempty"`
	Config   *DigestEntry_Config `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
}

func (x *DigestEntry) Reset() {
	*x = DigestEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DigestEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DigestEntry) ProtoMessage() {}

func (x *DigestEntry) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DigestEntry.ProtoReflect.Descriptor instead.
func (*DigestEntry) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{30}
}

func (x *DigestEntry) GetDigestId() uint32 {
	if x != nil {
		return x.DigestId
	}
	return 0
}

func (x *DigestEntry) GetConfig() *DigestEntry_Config {
	if x != nil {
		return x.Config
	}
	return nil
}

// ------------------------------------------------------------------------------
type StreamMessageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Update:
	//
	//	*StreamMessageRequest_Arbitration
	//	*StreamMessageRequest_Packet
	//	*StreamMessageRequest_DigestAck
	//	*StreamMessageRequest_Other
	Update isStreamMessageRequest_Update `protobuf_oneof:"update"`
}

func (x *StreamMessageRequest) Reset() {
	*x = StreamMessageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamMessageRequest) ProtoMessage() {}

func (x *StreamMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamMessageRequest.ProtoReflect.Descriptor instead.
func (*StreamMessageRequest) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{31}
}

func (m *StreamMessageRequest) GetUpdate() isStreamMessageRequest_Update {
	if m != nil {
		return m.Update
	}
	return nil
}

func (x *StreamMessageRequest) GetArbitration() *MasterArbitrationUpdate {
	if x, ok := x.GetUpdate().(*StreamMessageRequest_Arbitration); ok {
		return x.Arbitration
	}
	return nil
}

func (x *StreamMessageRequest) GetPacket() *PacketOut {
	if x, ok := x.GetUpdate().(*StreamMessageRequest_Packet); ok {
		return x.Packet
	}
	return nil
}

func (x *StreamMessageRequest) GetDigestAck() *DigestListAck {
	if x, ok := x.GetUpdate().(*StreamMessageRequest_DigestAck); ok {
		return x.DigestAck
	}
	return nil
}

func (x *StreamMessageRequest) GetOther() *anypb.Any {
	if x, ok := x.GetUpdate().(*StreamMessageRequest_Other); ok {
		return x.Other
	}
	return nil
}

type isStreamMessageRequest_Update interface {
	isStreamMessageRequest_Update()
}

type StreamMessageRequest_Arbitration struct {
	Arbitration *MasterArbitrationUpdate `protobuf:"bytes,1,opt,name=arbitration,proto3,oneof"`
}

type StreamMessageRequest_Packet struct {
	Packet *PacketOut `protobuf:"bytes,2,opt,name=packet,proto3,oneof"`
}

type StreamMessageRequest_DigestAck struct {
	DigestAck *DigestListAck `protobuf:"bytes,3,opt,name=digest_ack,json=digestAck,proto3,oneof"`
}

type StreamMessageRequest_Other struct {
	Other *anypb.Any `protobuf:"bytes,4,opt,name=other,proto3,oneof"`
}

func (*StreamMessageRequest_Arbitration) isStreamMessageRequest_Update() {}

func (*StreamMessageRequest_Packet) isStreamMessageRequest_Update() {}

func (*StreamMessageRequest_DigestAck) isStreamMessageRequest_Update() {}

func (*StreamMessageRequest_Other) isStreamMessageRequest_Update() {}

// Packet sent from the controller to the switch.
type PacketOut struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Payload []byte `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	// This will be based on P4 header annotated as
	// @controller_header("packet_out").
	// At most one P4 header can have this annotation.
	Metadata []*PacketMetadata `protobuf:"bytes,2,rep,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *PacketOut) Reset() {
	*x = PacketOut{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketOut) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketOut) ProtoMessage() {}

func (x *PacketOut) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketOut.ProtoReflect.Descriptor instead.
func (*PacketOut) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{32}
}

func (x *PacketOut) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *PacketOut) GetMetadata() []*PacketMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Used by the controller to ack a DigestList message. To avoid flooding the
// controller, the switch must not generate digest notifications for the same
// data until a DigestListAck message with the same list_id is received or the
// ack timeout (ack_timeout_ns field in DigestEntry.Config) expires.
type DigestListAck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DigestId uint32 `protobuf:"varint,1,opt,name=digest_id,json=digestId,proto3" json:"digest_id,omitempty"`
	ListId   uint64 `protobuf:"varint,2,opt,name=list_id,json=listId,proto3" json:"list_id,omitempty"`
}

func (x *DigestListAck) Reset() {
	*x = DigestListAck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DigestListAck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DigestListAck) ProtoMessage() {}

func (x *DigestListAck) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DigestListAck.ProtoReflect.Descriptor instead.
func (*DigestListAck) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{33}
}

func (x *DigestListAck) GetDigestId() uint32 {
	if x != nil {
		return x.DigestId
	}
	return 0
}

func (x *DigestListAck) GetListId() uint64 {
	if x != nil {
		return x.ListId
	}
	return 0
}

type StreamMessageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Update:
	//
	//	*StreamMessageResponse_Arbitration
	//	*StreamMessageResponse_Packet
	//	*StreamMessageResponse_Digest
	//	*StreamMessageResponse_IdleTimeoutNotification
	//	*StreamMessageResponse_Other
	//	*StreamMessageResponse_Error
	Update isStreamMessageResponse_Update `protobuf_oneof:"update"`
}

func (x *StreamMessageResponse) Reset() {
	*x = StreamMessageResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamMessageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamMessageResponse) ProtoMessage() {}

func (x *StreamMessageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamMessageResponse.ProtoReflect.Descriptor instead.
func (*StreamMessageResponse) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{34}
}

func (m *StreamMessageResponse) GetUpdate() isStreamMessageResponse_Update {
	if m != nil {
		return m.Update
	}
	return nil
}

func (x *StreamMessageResponse) GetArbitration() *MasterArbitrationUpdate {
	if x, ok := x.GetUpdate().(*StreamMessageResponse_Arbitration); ok {
		return x.Arbitration
	}
	return nil
}

func (x *StreamMessageResponse) GetPacket() *PacketIn {
	if x, ok := x.GetUpdate().(*StreamMessageResponse_Packet); ok {
		return x.Packet
	}
	return nil
}

func (x *StreamMessageResponse) GetDigest() *DigestList {
	if x, ok := x.GetUpdate().(*StreamMessageResponse_Digest); ok {
		return x.Digest
	}
	return nil
}

func (x *StreamMessageResponse) GetIdleTimeoutNotification() *IdleTimeoutNotification {
	if x, ok := x.GetUpdate().(*StreamMessageResponse_IdleTimeoutNotification); ok {
		return x.IdleTimeoutNotification
	}
	return nil
}

func (x *StreamMessageResponse) GetOther() *anypb.Any {
	if x, ok := x.GetUpdate().(*StreamMessageResponse_Other); ok {
		return x.Other
	}
	return nil
}

func (x *StreamMessageResponse) GetError() *StreamError {
	if x, ok := x.GetUpdate().(*StreamMessageResponse_Error); ok {
		return x.Error
	}
	return nil
}

type isStreamMessageResponse_Update interface {
	isStreamMessageResponse_Update()
}

type StreamMessageResponse_Arbitration struct {
	Arbitration *MasterArbitrationUpdate `protobuf:"bytes,1,opt,name=arbitration,proto3,oneof"`
}

type StreamMessageResponse_Packet struct {
	Packet *PacketIn `protobuf:"bytes,2,opt,name=packet,proto3,oneof"`
}

type StreamMessageResponse_Digest struct {
	Digest *DigestList `protobuf:"bytes,3,opt,name=digest,proto3,oneof"`
}

type StreamMessageResponse_IdleTimeoutNotification struct {
	IdleTimeoutNotification *IdleTimeoutNotification `protobuf:"bytes,4,opt,name=idle_timeout_notification,json=idleTimeoutNotification,proto3,oneof"`
}

type StreamMessageResponse_Other struct {
	Other *anypb.Any `protobuf:"bytes,5,opt,name=other,proto3,oneof"`
}

type StreamMessageResponse_Error struct {
	// Used by the server to asynchronously report errors which occur when
	// processing StreamMessageRequest messages.
	Error *StreamError `protobuf:"bytes,6,opt,name=error,proto3,oneof"`
}

func (*StreamMessageResponse_Arbitration) isStreamMessageResponse_Update() {}

func (*StreamMessageResponse_Packet) isStreamMessageResponse_Update() {}

func (*StreamMessageResponse_Digest) isStreamMessageResponse_Update() {}

func (*StreamMessageResponse_IdleTimeoutNotification) isStreamMessageResponse_Update() {}

func (*StreamMessageResponse_Other) isStreamMessageResponse_Update() {}

func (*StreamMessageResponse_Error) isStreamMessageResponse_Update() {}

// Packet sent from the switch to the controller.
type PacketIn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Payload []byte `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	// This will be based on P4 header annotated as
	// @controller_header("packet_in").
	// At most one P4 header can have this annotation.
	Metadata []*PacketMetadata `protobuf:"bytes,2,rep,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *PacketIn) Reset() {
	*x = PacketIn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketIn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketIn) ProtoMessage() {}

func (x *PacketIn) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketIn.ProtoReflect.Descriptor instead.
func (*PacketIn) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{35}
}

func (x *PacketIn) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *PacketIn) GetMetadata() []*PacketMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

type DigestList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DigestId uint32 `protobuf:"varint,1,opt,name=digest_id,json=digestId,proto3" json:"digest_id,omitempty"` // identifies the digest extern instance
	ListId   uint64 `protobuf:"varint,2,opt,name=list_id,json=listId,proto3" json:"list_id,omitempty"`       // identifies a list of entries, used by receiver to ack
	// List of entries: each call to the Digest<T>::pack() method corresponds to
	// one entry and we can have as little as one entry.
	Data []*P4Data `protobuf:"bytes,3,rep,name=data,proto3" json:"data,omitempty"`
	// Timestamp at which the server generated the message (in nanoseconds since
	// Epoch)
	Timestamp int64 `protobuf:"varint,4,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *DigestList) Reset() {
	*x = DigestList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DigestList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DigestList) ProtoMessage() {}

func (x *DigestList) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DigestList.ProtoReflect.Descriptor instead.
func (*DigestList) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{36}
}

func (x *DigestList) GetDigestId() uint32 {
	if x != nil {
		return x.DigestId
	}
	return 0
}

func (x *DigestList) GetListId() uint64 {
	if x != nil {
		return x.ListId
	}
	return 0
}

func (x *DigestList) GetData() []*P4Data {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *DigestList) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

// Any metadata associated with Packet-IO (controller Packet-In or Packet-Out)
// needs to be modeled as P4 headers carrying special annotations
// @controller_header("packet_out") and @controller_header("packet_in")
// respectively. There can be at most one header each with these annotations.
// These special headers are captured in P4Info ControllerPacketMetadata.
type PacketMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This refers to Metadata.id coming from P4Info ControllerPacketMetadata.
	MetadataId uint32 `protobuf:"varint,1,opt,name=metadata_id,json=metadataId,proto3" json:"metadata_id,omitempty"`
	Value      []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *PacketMetadata) Reset() {
	*x = PacketMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketMetadata) ProtoMessage() {}

func (x *PacketMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketMetadata.ProtoReflect.Descriptor instead.
func (*PacketMetadata) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{37}
}

func (x *PacketMetadata) GetMetadataId() uint32 {
	if x != nil {
		return x.MetadataId
	}
	return 0
}

func (x *PacketMetadata) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type MasterArbitrationUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DeviceId uint64 `protobuf:"varint,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// The role for which the primary client is being arbitrated. For use-cases
	// where multiple roles are not needed, the controller can leave this unset,
	// implying default role and full pipeline access.
	Role *Role `protobuf:"bytes,2,opt,name=role,proto3" json:"role,omitempty"`
	// The stream RPC with the highest election_id is the primary. The 'primary'
	// controller instance populates this with its latest election_id. Switch
	// populates with the highest election ID it has received from all connected
	// controllers.
	ElectionId *Uint128 `protobuf:"bytes,3,opt,name=election_id,json=electionId,proto3" json:"election_id,omitempty"`
	// Switch populates this with OK for the client that is the primary, and
	// with an error status for all other connected clients (at every primary
	// client change). The controller does not populate this field.
	Status *status.Status `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *MasterArbitrationUpdate) Reset() {
	*x = MasterArbitrationUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MasterArbitrationUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MasterArbitrationUpdate) ProtoMessage() {}

func (x *MasterArbitrationUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MasterArbitrationUpdate.ProtoReflect.Descriptor instead.
func (*MasterArbitrationUpdate) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{38}
}

func (x *MasterArbitrationUpdate) GetDeviceId() uint64 {
	if x != nil {
		return x.DeviceId
	}
	return 0
}

func (x *MasterArbitrationUpdate) GetRole() *Role {
	if x != nil {
		return x.Role
	}
	return nil
}

func (x *MasterArbitrationUpdate) GetElectionId() *Uint128 {
	if x != nil {
		return x.ElectionId
	}
	return nil
}

func (x *MasterArbitrationUpdate) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type Role struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uniquely identifies this role.
	// Deprecated in 1.4.0.
	//
	// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
	Id uint64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Added in 1.4.0.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Describes the role configuration, i.e. what operations, P4 entities,
	// behaviors, etc. are in the scope of a given role. If config is not set
	// (default case), it implies all P4 objects and control behaviors are in
	// scope, i.e. full pipeline access. The format of this message is
	// out-of-scope of P4Runtime.
	Config *anypb.Any `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
}

func (x *Role) Reset() {
	*x = Role{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Role) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Role) ProtoMessage() {}

func (x *Role) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Role.ProtoReflect.Descriptor instead.
func (*Role) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{39}
}

// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
func (x *Role) GetId() uint64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Role) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Role) GetConfig() *anypb.Any {
	if x != nil {
		return x.Config
	}
	return nil
}

type IdleTimeoutNotification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The only fields that are required to be set in each TableEntry are the
	// "key" fields (table_id, match and priority) along with controller_metadata,
	// metadata and idle_timeout_ns.
	TableEntry []*TableEntry `protobuf:"bytes,1,rep,name=table_entry,json=tableEntry,proto3" json:"table_entry,omitempty"`
	// Timestamp at which the server generated the message (in nanoseconds since
	// Epoch)
	Timestamp int64 `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
}

func (x *IdleTimeoutNotification) Reset() {
	*x = IdleTimeoutNotification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IdleTimeoutNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IdleTimeoutNotification) ProtoMessage() {}

func (x *IdleTimeoutNotification) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IdleTimeoutNotification.ProtoReflect.Descriptor instead.
func (*IdleTimeoutNotification) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{40}
}

func (x *IdleTimeoutNotification) GetTableEntry() []*TableEntry {
	if x != nil {
		return x.TableEntry
	}
	return nil
}

func (x *IdleTimeoutNotification) GetTimestamp() int64 {
	if x != nil {
		return x.Timestamp
	}
	return 0
}

// Used by the server to asynchronously report errors which occur when
// processing StreamMessageRequest messages.
type StreamError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// gRPC canonical error code (see
	// https://developers.google.com/maps-booking/reference/grpc-api/status_codes)
	CanonicalCode int32 `protobuf:"varint,1,opt,name=canonical_code,json=canonicalCode,proto3" json:"canonical_code,omitempty"`
	// Optional. An explanation of the error.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Optional. Target and architecture specific space to which this error
	// belongs.
	// We encourage using triplet: <target>-<arch>-<vendor>,
	// e.g."targetX-psa-vendor1" or "targetY-psa-vendor2".
	Space string `protobuf:"bytes,3,opt,name=space,proto3" json:"space,omitempty"`
	// Optional. Numeric code drawn from target-specific error space above.
	Code int32 `protobuf:"varint,4,opt,name=code,proto3" json:"code,omitempty"`
	// Used by the server to convey additional information about the error. One of
	// the fields must be set (so that the client can identify which type of
	// stream message triggered the error), but that field may be set to its
	// default value.
	//
	// Types that are assignable to Details:
	//
	//	*StreamError_PacketOut
	//	*StreamError_DigestListAck
	//	*StreamError_Other
	Details isStreamError_Details `protobuf_oneof:"details"`
}

func (x *StreamError) Reset() {
	*x = StreamError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamError) ProtoMessage() {}

func (x *StreamError) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamError.ProtoReflect.Descriptor instead.
func (*StreamError) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{41}
}

func (x *StreamError) GetCanonicalCode() int32 {
	if x != nil {
		return x.CanonicalCode
	}
	return 0
}

func (x *StreamError) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *StreamError) GetSpace() string {
	if x != nil {
		return x.Space
	}
	return ""
}

func (x *StreamError) GetCode() int32 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (m *StreamError) GetDetails() isStreamError_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *StreamError) GetPacketOut() *PacketOutError {
	if x, ok := x.GetDetails().(*StreamError_PacketOut); ok {
		return x.PacketOut
	}
	return nil
}

func (x *StreamError) GetDigestListAck() *DigestListAckError {
	if x, ok := x.GetDetails().(*StreamError_DigestListAck); ok {
		return x.DigestListAck
	}
	return nil
}

func (x *StreamError) GetOther() *StreamOtherError {
	if x, ok := x.GetDetails().(*StreamError_Other); ok {
		return x.Other
	}
	return nil
}

type isStreamError_Details interface {
	isStreamError_Details()
}

type StreamError_PacketOut struct {
	PacketOut *PacketOutError `protobuf:"bytes,5,opt,name=packet_out,json=packetOut,proto3,oneof"`
}

type StreamError_DigestListAck struct {
	DigestListAck *DigestListAckError `protobuf:"bytes,6,opt,name=digest_list_ack,json=digestListAck,proto3,oneof"`
}

type StreamError_Other struct {
	Other *StreamOtherError `protobuf:"bytes,7,opt,name=other,proto3,oneof"`
}

func (*StreamError_PacketOut) isStreamError_Details() {}

func (*StreamError_DigestListAck) isStreamError_Details() {}

func (*StreamError_Other) isStreamError_Details() {}

type PacketOutError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The packet out message that caused the error.
	PacketOut *PacketOut `protobuf:"bytes,1,opt,name=packet_out,json=packetOut,proto3" json:"packet_out,omitempty"`
}

func (x *PacketOutError) Reset() {
	*x = PacketOutError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PacketOutError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PacketOutError) ProtoMessage() {}

func (x *PacketOutError) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PacketOutError.ProtoReflect.Descriptor instead.
func (*PacketOutError) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{42}
}

func (x *PacketOutError) GetPacketOut() *PacketOut {
	if x != nil {
		return x.PacketOut
	}
	return nil
}

type DigestListAckError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The digest list acknowledgement message that caused the error.
	DigestListAck *DigestListAck `protobuf:"bytes,1,opt,name=digest_list_ack,json=digestListAck,proto3" json:"digest_list_ack,omitempty"`
}

func (x *DigestListAckError) Reset() {
	*x = DigestListAckError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DigestListAckError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DigestListAckError) ProtoMessage() {}

func (x *DigestListAckError) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DigestListAckError.ProtoReflect.Descriptor instead.
func (*DigestListAckError) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{43}
}

func (x *DigestListAckError) GetDigestListAck() *DigestListAck {
	if x != nil {
		return x.DigestListAck
	}
	return nil
}

type StreamOtherError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The architecture-specific stream message that caused the error.
	Other *anypb.Any `protobuf:"bytes,1,opt,name=other,proto3" json:"other,omitempty"`
}

func (x *StreamOtherError) Reset() {
	*x = StreamOtherError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamOtherError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamOtherError) ProtoMessage() {}

func (x *StreamOtherError) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamOtherError.ProtoReflect.Descriptor instead.
func (*StreamOtherError) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{44}
}

func (x *StreamOtherError) GetOther() *anypb.Any {
	if x != nil {
		return x.Other
	}
	return nil
}

type Uint128 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Highest 64 bits of a 128 bit number.
	High uint64 `protobuf:"varint,1,opt,name=high,proto3" json:"high,omitempty"`
	// Lowest 64 bits of a 128 bit number.
	Low uint64 `protobuf:"varint,2,opt,name=low,proto3" json:"low,omitempty"`
}

func (x *Uint128) Reset() {
	*x = Uint128{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Uint128) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Uint128) ProtoMessage() {}

func (x *Uint128) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Uint128.ProtoReflect.Descriptor instead.
func (*Uint128) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{45}
}

func (x *Uint128) GetHigh() uint64 {
	if x != nil {
		return x.High
	}
	return 0
}

func (x *Uint128) GetLow() uint64 {
	if x != nil {
		return x.Low
	}
	return 0
}

// ------------------------------------------------------------------------------
type SetForwardingPipelineConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DeviceId uint64 `protobuf:"varint,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// Deprecated in 1.4.0.
	//
	// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
	RoleId uint64 `protobuf:"varint,2,opt,name=role_id,json=roleId,proto3" json:"role_id,omitempty"`
	// Added in 1.4.0.
	Role       string                                    `protobuf:"bytes,6,opt,name=role,proto3" json:"role,omitempty"`
	ElectionId *Uint128                                  `protobuf:"bytes,3,opt,name=election_id,json=electionId,proto3" json:"election_id,omitempty"`
	Action     SetForwardingPipelineConfigRequest_Action `protobuf:"varint,4,opt,name=action,proto3,enum=p4.v1.SetForwardingPipelineConfigRequest_Action" json:"action,omitempty"`
	Config     *ForwardingPipelineConfig                 `protobuf:"bytes,5,opt,name=config,proto3" json:"config,omitempty"`
}

func (x *SetForwardingPipelineConfigRequest) Reset() {
	*x = SetForwardingPipelineConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetForwardingPipelineConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetForwardingPipelineConfigRequest) ProtoMessage() {}

func (x *SetForwardingPipelineConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetForwardingPipelineConfigRequest.ProtoReflect.Descriptor instead.
func (*SetForwardingPipelineConfigRequest) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{46}
}

func (x *SetForwardingPipelineConfigRequest) GetDeviceId() uint64 {
	if x != nil {
		return x.DeviceId
	}
	return 0
}

// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
func (x *SetForwardingPipelineConfigRequest) GetRoleId() uint64 {
	if x != nil {
		return x.RoleId
	}
	return 0
}

func (x *SetForwardingPipelineConfigRequest) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *SetForwardingPipelineConfigRequest) GetElectionId() *Uint128 {
	if x != nil {
		return x.ElectionId
	}
	return nil
}

func (x *SetForwardingPipelineConfigRequest) GetAction() SetForwardingPipelineConfigRequest_Action {
	if x != nil {
		return x.Action
	}
	return SetForwardingPipelineConfigRequest_UNSPECIFIED
}

func (x *SetForwardingPipelineConfigRequest) GetConfig() *ForwardingPipelineConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

type SetForwardingPipelineConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SetForwardingPipelineConfigResponse) Reset() {
	*x = SetForwardingPipelineConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetForwardingPipelineConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetForwardingPipelineConfigResponse) ProtoMessage() {}

func (x *SetForwardingPipelineConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetForwardingPipelineConfigResponse.ProtoReflect.Descriptor instead.
func (*SetForwardingPipelineConfigResponse) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{47}
}

type ForwardingPipelineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	P4Info *v1.P4Info `protobuf:"bytes,1,opt,name=p4info,proto3" json:"p4info,omitempty"`
	// Target-specific P4 configuration.
	P4DeviceConfig []byte                           `protobuf:"bytes,2,opt,name=p4_device_config,json=p4DeviceConfig,proto3" json:"p4_device_config,omitempty"`
	Cookie         *ForwardingPipelineConfig_Cookie `protobuf:"bytes,3,opt,name=cookie,proto3" json:"cookie,omitempty"`
}

func (x *ForwardingPipelineConfig) Reset() {
	*x = ForwardingPipelineConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardingPipelineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardingPipelineConfig) ProtoMessage() {}

func (x *ForwardingPipelineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardingPipelineConfig.ProtoReflect.Descriptor instead.
func (*ForwardingPipelineConfig) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{48}
}

func (x *ForwardingPipelineConfig) GetP4Info() *v1.P4Info {
	if x != nil {
		return x.P4Info
	}
	return nil
}

func (x *ForwardingPipelineConfig) GetP4DeviceConfig() []byte {
	if x != nil {
		return x.P4DeviceConfig
	}
	return nil
}

func (x *ForwardingPipelineConfig) GetCookie() *ForwardingPipelineConfig_Cookie {
	if x != nil {
		return x.Cookie
	}
	return nil
}

type GetForwardingPipelineConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DeviceId     uint64                                          `protobuf:"varint,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	ResponseType GetForwardingPipelineConfigRequest_ResponseType `protobuf:"varint,2,opt,name=response_type,json=responseType,proto3,enum=p4.v1.GetForwardingPipelineConfigRequest_ResponseType" json:"response_type,omitempty"`
}

func (x *GetForwardingPipelineConfigRequest) Reset() {
	*x = GetForwardingPipelineConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetForwardingPipelineConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetForwardingPipelineConfigRequest) ProtoMessage() {}

func (x *GetForwardingPipelineConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetForwardingPipelineConfigRequest.ProtoReflect.Descriptor instead.
func (*GetForwardingPipelineConfigRequest) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{49}
}

func (x *GetForwardingPipelineConfigRequest) GetDeviceId() uint64 {
	if x != nil {
		return x.DeviceId
	}
	return 0
}

func (x *GetForwardingPipelineConfigRequest) GetResponseType() GetForwardingPipelineConfigRequest_ResponseType {
	if x != nil {
		return x.ResponseType
	}
	return GetForwardingPipelineConfigRequest_ALL
}

type GetForwardingPipelineConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Config *ForwardingPipelineConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
}

func (x *GetForwardingPipelineConfigResponse) Reset() {
	*x = GetForwardingPipelineConfigResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetForwardingPipelineConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetForwardingPipelineConfigResponse) ProtoMessage() {}

func (x *GetForwardingPipelineConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetForwardingPipelineConfigResponse.ProtoReflect.Descriptor instead.
func (*GetForwardingPipelineConfigResponse) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{50}
}

func (x *GetForwardingPipelineConfigResponse) GetConfig() *ForwardingPipelineConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

// Error message used to report a single P4-entity error for a Write RPC.
type Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// gRPC canonical error code (see
	// https://developers.google.com/maps-booking/reference/grpc-api/status_codes)
	CanonicalCode int32 `protobuf:"varint,1,opt,name=canonical_code,json=canonicalCode,proto3" json:"canonical_code,omitempty"`
	// Detailed error message.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Target and architecture specific space to which this error belongs.
	// We encourage using triplet: <target>-<arch>-<vendor>,
	// e.g."targetX-psa-vendor1" or "targetY-psa-vendor2".
	Space string `protobuf:"bytes,3,opt,name=space,proto3" json:"space,omitempty"`
	// Numeric code drawn from target-specific error space above.
	Code int32 `protobuf:"varint,4,opt,name=code,proto3" json:"code,omitempty"`
	// Optional: Allows reporting back additional target-specific details on the
	// error.
	Details *anypb.Any `protobuf:"bytes,5,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *Error) Reset() {
	*x = Error{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Error) ProtoMessage() {}

func (x *Error) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Error.ProtoReflect.Descriptor instead.
func (*Error) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{51}
}

func (x *Error) GetCanonicalCode() int32 {
	if x != nil {
		return x.CanonicalCode
	}
	return 0
}

func (x *Error) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Error) GetSpace() string {
	if x != nil {
		return x.Space
	}
	return ""
}

func (x *Error) GetCode() int32 {
	if x != nil {
		return x.Code
	}
	return 0
}

func (x *Error) GetDetails() *anypb.Any {
	if x != nil {
		return x.Details
	}
	return nil
}

// ------------------------------------------------------------------------------
type CapabilitiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CapabilitiesRequest) Reset() {
	*x = CapabilitiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CapabilitiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CapabilitiesRequest) ProtoMessage() {}

func (x *CapabilitiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CapabilitiesRequest.ProtoReflect.Descriptor instead.
func (*CapabilitiesRequest) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{52}
}

type CapabilitiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full semantic version string (e.g. "1.1.0-rc.1") corresponding to the
	// version of the P4Runtime API currently implemented by the server.
	P4RuntimeApiVersion string `protobuf:"bytes,1,opt,name=p4runtime_api_version,json=p4runtimeApiVersion,proto3" json:"p4runtime_api_version,omitempty"`
}

func (x *CapabilitiesResponse) Reset() {
	*x = CapabilitiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CapabilitiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CapabilitiesResponse) ProtoMessage() {}

func (x *CapabilitiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CapabilitiesResponse.ProtoReflect.Descriptor instead.
func (*CapabilitiesResponse) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{53}
}

func (x *CapabilitiesResponse) GetP4RuntimeApiVersion() string {
	if x != nil {
		return x.P4RuntimeApiVersion
	}
	return ""
}

type TableEntry_IdleTimeout struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time elapsed - in nanoseconds - since the table entry was last "hit" as
	// part of a data plane table lookup.
	ElapsedNs int64 `protobuf:"varint,1,opt,name=elapsed_ns,json=elapsedNs,proto3" json:"elapsed_ns,omitempty"`
}

func (x *TableEntry_IdleTimeout) Reset() {
	*x = TableEntry_IdleTimeout{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableEntry_IdleTimeout) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableEntry_IdleTimeout) ProtoMessage() {}

func (x *TableEntry_IdleTimeout) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableEntry_IdleTimeout.ProtoReflect.Descriptor instead.
func (*TableEntry_IdleTimeout) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{7, 0}
}

func (x *TableEntry_IdleTimeout) GetElapsedNs() int64 {
	if x != nil {
		return x.ElapsedNs
	}
	return 0
}

// Matches can be performed on arbitrarily-large inputs; the protobuf type
// 'bytes' is used to model arbitrarily-large values.
type FieldMatch_Exact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value []byte `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *FieldMatch_Exact) Reset() {
	*x = FieldMatch_Exact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldMatch_Exact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldMatch_Exact) ProtoMessage() {}

func (x *FieldMatch_Exact) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldMatch_Exact.ProtoReflect.Descriptor instead.
func (*FieldMatch_Exact) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{8, 0}
}

func (x *FieldMatch_Exact) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type FieldMatch_Ternary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value []byte `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Mask  []byte `protobuf:"bytes,2,opt,name=mask,proto3" json:"mask,omitempty"`
}

func (x *FieldMatch_Ternary) Reset() {
	*x = FieldMatch_Ternary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldMatch_Ternary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldMatch_Ternary) ProtoMessage() {}

func (x *FieldMatch_Ternary) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldMatch_Ternary.ProtoReflect.Descriptor instead.
func (*FieldMatch_Ternary) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{8, 1}
}

func (x *FieldMatch_Ternary) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *FieldMatch_Ternary) GetMask() []byte {
	if x != nil {
		return x.Mask
	}
	return nil
}

type FieldMatch_LPM struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value     []byte `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	PrefixLen int32  `protobuf:"varint,2,opt,name=prefix_len,json=prefixLen,proto3" json:"prefix_len,omitempty"` // in bits
}

func (x *FieldMatch_LPM) Reset() {
	*x = FieldMatch_LPM{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldMatch_LPM) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldMatch_LPM) ProtoMessage() {}

func (x *FieldMatch_LPM) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldMatch_LPM.ProtoReflect.Descriptor instead.
func (*FieldMatch_LPM) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{8, 2}
}

func (x *FieldMatch_LPM) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *FieldMatch_LPM) GetPrefixLen() int32 {
	if x != nil {
		return x.PrefixLen
	}
	return 0
}

// A Range is logically a set that contains all values numerically between
// 'low' and 'high' inclusively.
type FieldMatch_Range struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Low  []byte `protobuf:"bytes,1,opt,name=low,proto3" json:"low,omitempty"`
	High []byte `protobuf:"bytes,2,opt,name=high,proto3" json:"high,omitempty"`
}

func (x *FieldMatch_Range) Reset() {
	*x = FieldMatch_Range{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldMatch_Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldMatch_Range) ProtoMessage() {}

func (x *FieldMatch_Range) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldMatch_Range.ProtoReflect.Descriptor instead.
func (*FieldMatch_Range) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{8, 3}
}

func (x *FieldMatch_Range) GetLow() []byte {
	if x != nil {
		return x.Low
	}
	return nil
}

func (x *FieldMatch_Range) GetHigh() []byte {
	if x != nil {
		return x.High
	}
	return nil
}

// If the Optional match should be a wildcard, the FieldMatch must be omitted.
// Otherwise, this behaves like an exact match.
type FieldMatch_Optional struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value []byte `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *FieldMatch_Optional) Reset() {
	*x = FieldMatch_Optional{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldMatch_Optional) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldMatch_Optional) ProtoMessage() {}

func (x *FieldMatch_Optional) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldMatch_Optional.ProtoReflect.Descriptor instead.
func (*FieldMatch_Optional) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{8, 4}
}

func (x *FieldMatch_Optional) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type Action_Param struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ParamId uint32 `protobuf:"varint,2,opt,name=param_id,json=paramId,proto3" json:"param_id,omitempty"`
	Value   []byte `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Action_Param) Reset() {
	*x = Action_Param{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_Param) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_Param) ProtoMessage() {}

func (x *Action_Param) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_Param.ProtoReflect.Descriptor instead.
func (*Action_Param) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{10, 0}
}

func (x *Action_Param) GetParamId() uint32 {
	if x != nil {
		return x.ParamId
	}
	return 0
}

func (x *Action_Param) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

type ActionProfileGroup_Member struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MemberId uint32 `protobuf:"varint,1,opt,name=member_id,json=memberId,proto3" json:"member_id,omitempty"`
	Weight   int32  `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
	// Types that are assignable to WatchKind:
	//
	//	*ActionProfileGroup_Member_Watch
	//	*ActionProfileGroup_Member_WatchPort
	WatchKind isActionProfileGroup_Member_WatchKind `protobuf_oneof:"watch_kind"`
}

func (x *ActionProfileGroup_Member) Reset() {
	*x = ActionProfileGroup_Member{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionProfileGroup_Member) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionProfileGroup_Member) ProtoMessage() {}

func (x *ActionProfileGroup_Member) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionProfileGroup_Member.ProtoReflect.Descriptor instead.
func (*ActionProfileGroup_Member) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{14, 0}
}

func (x *ActionProfileGroup_Member) GetMemberId() uint32 {
	if x != nil {
		return x.MemberId
	}
	return 0
}

func (x *ActionProfileGroup_Member) GetWeight() int32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (m *ActionProfileGroup_Member) GetWatchKind() isActionProfileGroup_Member_WatchKind {
	if m != nil {
		return m.WatchKind
	}
	return nil
}

// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
func (x *ActionProfileGroup_Member) GetWatch() int32 {
	if x, ok := x.GetWatchKind().(*ActionProfileGroup_Member_Watch); ok {
		return x.Watch
	}
	return 0
}

func (x *ActionProfileGroup_Member) GetWatchPort() []byte {
	if x, ok := x.GetWatchKind().(*ActionProfileGroup_Member_WatchPort); ok {
		return x.WatchPort
	}
	return nil
}

type isActionProfileGroup_Member_WatchKind interface {
	isActionProfileGroup_Member_WatchKind()
}

type ActionProfileGroup_Member_Watch struct {
	// Using int32 as ports is deprecated, use watch_port instead.
	//
	// Deprecated: Marked as deprecated in p4/v1/p4runtime.proto.
	Watch int32 `protobuf:"varint,3,opt,name=watch,proto3,oneof"`
}

type ActionProfileGroup_Member_WatchPort struct {
	WatchPort []byte `protobuf:"bytes,4,opt,name=watch_port,json=watchPort,proto3,oneof"`
}

func (*ActionProfileGroup_Member_Watch) isActionProfileGroup_Member_WatchKind() {}

func (*ActionProfileGroup_Member_WatchPort) isActionProfileGroup_Member_WatchKind() {}

// a DigestList message is streamed when the following conditions are met:
//   - there is at least one digest ready
//   - the oldest digest in the list has been waiting for at least
//     max_timeout_ns nanoseconds or we have gathered max_list_size digests
//     already
type DigestEntry_Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MaxTimeoutNs int64 `protobuf:"varint,1,opt,name=max_timeout_ns,json=maxTimeoutNs,proto3" json:"max_timeout_ns,omitempty"` // max timeout for outstanding digest data
	MaxListSize  int32 `protobuf:"varint,2,opt,name=max_list_size,json=maxListSize,proto3" json:"max_list_size,omitempty"`    // max size for a digest list
	AckTimeoutNs int64 `protobuf:"varint,3,opt,name=ack_timeout_ns,json=ackTimeoutNs,proto3" json:"ack_timeout_ns,omitempty"` // timeout for DigestListAck message
}

func (x *DigestEntry_Config) Reset() {
	*x = DigestEntry_Config{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DigestEntry_Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DigestEntry_Config) ProtoMessage() {}

func (x *DigestEntry_Config) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DigestEntry_Config.ProtoReflect.Descriptor instead.
func (*DigestEntry_Config) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{30, 0}
}

func (x *DigestEntry_Config) GetMaxTimeoutNs() int64 {
	if x != nil {
		return x.MaxTimeoutNs
	}
	return 0
}

func (x *DigestEntry_Config) GetMaxListSize() int32 {
	if x != nil {
		return x.MaxListSize
	}
	return 0
}

func (x *DigestEntry_Config) GetAckTimeoutNs() int64 {
	if x != nil {
		return x.AckTimeoutNs
	}
	return 0
}

// Metadata (cookie) opaque to the target. A control plane may use this field
// to uniquely identify this config. There are no restrictions on how such
// value is computed, or where this is stored on the target, as long as it is
// returned with a GetForwardingPipelineConfig RPC. When reading the cookie,
// we need to distinguish those cases where a cookie is NOT present (e.g. not
// set in the SetForwardingPipelineConfigRequest, therefore we wrap the actual
// uint64 value in a protobuf message.
type ForwardingPipelineConfig_Cookie struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Cookie uint64 `protobuf:"varint,1,opt,name=cookie,proto3" json:"cookie,omitempty"`
}

func (x *ForwardingPipelineConfig_Cookie) Reset() {
	*x = ForwardingPipelineConfig_Cookie{}
	if protoimpl.UnsafeEnabled {
		mi := &file_p4_v1_p4runtime_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardingPipelineConfig_Cookie) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardingPipelineConfig_Cookie) ProtoMessage() {}

func (x *ForwardingPipelineConfig_Cookie) ProtoReflect() protoreflect.Message {
	mi := &file_p4_v1_p4runtime_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardingPipelineConfig_Cookie.ProtoReflect.Descriptor instead.
func (*ForwardingPipelineConfig_Cookie) Descriptor() ([]byte, []int) {
	return file_p4_v1_p4runtime_proto_rawDescGZIP(), []int{48, 0}
}

func (x *ForwardingPipelineConfig_Cookie) GetCookie() uint64 {
	if x != nil {
		return x.Cookie
	}
	return 0
}

var File_p4_v1_p4runtime_proto protoreflect.FileDescriptor

var file_p4_v1_p4runtime_proto_rawDesc = []byte{
	0x0a, 0x15, 0x70, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x34, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x05, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x70, 0x34, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31,
	0x2f, 0x70, 0x34, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x12, 0x70,
	0x34, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x34, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xc4, 0x02, 0x0a, 0x0c, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x1b, 0x0a, 0x07, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x72, 0x6f, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x72, 0x6f, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65,
	0x12, 0x2f, 0x0a, 0x0b, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x69,
	0x6e, 0x74, 0x31, 0x32, 0x38, 0x52, 0x0a, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x27, 0x0a, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x52, 0x07, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x09, 0x61, 0x74,
	0x6f, 0x6d, 0x69, 0x63, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e,
	0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x41, 0x74, 0x6f, 0x6d, 0x69, 0x63, 0x69, 0x74, 0x79, 0x52, 0x09, 0x61, 0x74,
	0x6f, 0x6d, 0x69, 0x63, 0x69, 0x74, 0x79, 0x22, 0x4f, 0x0a, 0x09, 0x41, 0x74, 0x6f, 0x6d, 0x69,
	0x63, 0x69, 0x74, 0x79, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x4f, 0x4e, 0x54, 0x49, 0x4e, 0x55, 0x45,
	0x5f, 0x4f, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x52,
	0x4f, 0x4c, 0x4c, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x4f, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x41, 0x54, 0x41, 0x50, 0x4c, 0x41, 0x4e, 0x45, 0x5f,
	0x41, 0x54, 0x4f, 0x4d, 0x49, 0x43, 0x10, 0x02, 0x22, 0x0f, 0x0a, 0x0d, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x69, 0x0a, 0x0b, 0x52, 0x65, 0x61,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x29, 0x0a, 0x08, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x70, 0x34,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x22, 0x39, 0x0a, 0x0c, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22,
	0x94, 0x01, 0x0a, 0x06, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x25, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x3b, 0x0a, 0x04, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x53, 0x45, 0x52, 0x54, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x59, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x22, 0xd2, 0x06, 0x0a, 0x06, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x12, 0x37, 0x0a, 0x0c, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x5f, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x34, 0x0a, 0x0b, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x50, 0x0a, 0x15, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x48, 0x00, 0x52, 0x13, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x12, 0x4d, 0x0a, 0x14, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00, 0x52, 0x12, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x34, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x47, 0x0a, 0x12, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x48, 0x00, 0x52, 0x10,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x3a, 0x0a, 0x0d, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0c,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x4d, 0x0a, 0x14,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x48, 0x00, 0x52, 0x12, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x6c, 0x0a, 0x1f, 0x70,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x63,
	0x6b, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x48, 0x00, 0x52, 0x1c, 0x70, 0x61, 0x63,
	0x6b, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x3e, 0x0a, 0x0f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x53, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0d, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x53, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x3d, 0x0a, 0x0e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x37, 0x0a, 0x0c, 0x64, 0x69, 0x67, 0x65,
	0x73, 0x74, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x08, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x22, 0x7c, 0x0a, 0x0b, 0x45,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x24, 0x0a, 0x0e, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x0c, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64,
	0x12, 0x1b, 0x0a, 0x09, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x08, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x49, 0x64, 0x12, 0x2a, 0x0a,
	0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41,
	0x6e, 0x79, 0x52, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x89, 0x05, 0x0a, 0x0a, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x2a, 0x0a, 0x06,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70,
	0x34, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x12, 0x33, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x04, 0x42, 0x02, 0x18, 0x01, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65,
	0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x35, 0x0a, 0x0c, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0b, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x35, 0x0a, 0x0c, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0b, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x12, 0x45, 0x0a, 0x12, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x65,
	0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x10, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x12, 0x2a,
	0x0a, 0x11, 0x69, 0x73, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x69, 0x73, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0f, 0x69, 0x64,
	0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x6e, 0x73, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0d, 0x69, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x4e, 0x73, 0x12, 0x4c, 0x0a, 0x13, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x69, 0x6e, 0x63, 0x65,
	0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x68, 0x69, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x49, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x52, 0x10,
	0x74, 0x69, 0x6d, 0x65, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x4c, 0x61, 0x73, 0x74, 0x48, 0x69, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x19, 0x0a, 0x08,
	0x69, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x69, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x1a, 0x2c, 0x0a, 0x0b, 0x49, 0x64, 0x6c, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x6c, 0x61, 0x70, 0x73, 0x65,
	0x64, 0x5f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x65, 0x6c, 0x61, 0x70,
	0x73, 0x65, 0x64, 0x4e, 0x73, 0x22, 0xc8, 0x04, 0x0a, 0x0a, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x12, 0x19, 0x0a, 0x08, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x49, 0x64, 0x12,
	0x2f, 0x0a, 0x05, 0x65, 0x78, 0x61, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x2e, 0x45, 0x78, 0x61, 0x63, 0x74, 0x48, 0x00, 0x52, 0x05, 0x65, 0x78, 0x61, 0x63, 0x74,
	0x12, 0x35, 0x0a, 0x07, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x2e, 0x54, 0x65, 0x72, 0x6e, 0x61, 0x72, 0x79, 0x48, 0x00, 0x52, 0x07,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x72, 0x79, 0x12, 0x29, 0x0a, 0x03, 0x6c, 0x70, 0x6d, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x4c, 0x50, 0x4d, 0x48, 0x00, 0x52, 0x03, 0x6c,
	0x70, 0x6d, 0x12, 0x2f, 0x0a, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x2e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x05, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x38, 0x0a, 0x08, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x48, 0x00, 0x52, 0x08, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x12, 0x2c, 0x0a,
	0x05, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41,
	0x6e, 0x79, 0x48, 0x00, 0x52, 0x05, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x1a, 0x1d, 0x0a, 0x05, 0x45,
	0x78, 0x61, 0x63, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x33, 0x0a, 0x07, 0x54, 0x65,
	0x72, 0x6e, 0x61, 0x72, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x6d, 0x61, 0x73, 0x6b, 0x1a,
	0x3a, 0x0a, 0x03, 0x4c, 0x50, 0x4d, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4c, 0x65, 0x6e, 0x1a, 0x2d, 0x0a, 0x05, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6c, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x03, 0x6c, 0x6f, 0x77, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x69, 0x67, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x68, 0x69, 0x67, 0x68, 0x1a, 0x20, 0x0a, 0x08, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x12, 0x0a, 0x10,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x22, 0x8e, 0x02, 0x0a, 0x0b, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x27, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0d, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x18, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52, 0x15, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x37, 0x0a, 0x17, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52, 0x14, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x5a, 0x0a,
	0x19, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x48,
	0x00, 0x52, 0x16, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x22, 0x8c, 0x01, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x08, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70, 0x34, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x1a, 0x38, 0x0a, 0x05, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x12,
	0x19, 0x0a, 0x08, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x07, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0x6a, 0x0a, 0x16, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x12, 0x50, 0x0a, 0x16, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x70, 0x34, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x9f, 0x01, 0x0a,
	0x13, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x77, 0x65, 0x69,
	0x67, 0x68, 0x74, 0x12, 0x1a, 0x0a, 0x05, 0x77, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x05, 0x77, 0x61, 0x74, 0x63, 0x68, 0x12,
	0x1f, 0x0a, 0x0a, 0x77, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x09, 0x77, 0x61, 0x74, 0x63, 0x68, 0x50, 0x6f, 0x72, 0x74,
	0x42, 0x0c, 0x0a, 0x0a, 0x77, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x85,
	0x01, 0x0a, 0x13, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x2a, 0x0a, 0x11, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x25, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0d, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbd, 0x02, 0x0a, 0x12, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x2a, 0x0a,
	0x11, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x12, 0x19, 0x0a, 0x08, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x07, 0x6d, 0x61, 0x78, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0x88, 0x01, 0x0a, 0x06,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x1a, 0x0a, 0x05, 0x77,
	0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00,
	0x52, 0x05, 0x77, 0x61, 0x74, 0x63, 0x68, 0x12, 0x1f, 0x0a, 0x0a, 0x77, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x09, 0x77,
	0x61, 0x74, 0x63, 0x68, 0x50, 0x6f, 0x72, 0x74, 0x42, 0x0c, 0x0a, 0x0a, 0x77, 0x61, 0x74, 0x63,
	0x68, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x1d, 0x0a, 0x05, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0xb3, 0x01, 0x0a, 0x0a, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x22, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c,
	0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x2a, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x3a, 0x0a, 0x0c, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65,
	0x74, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x0b,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x22, 0xae, 0x01, 0x0a, 0x10,
	0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x32, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x2a, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x3a, 0x0a, 0x0c, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x0b, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x22, 0x79, 0x0a, 0x0b,
	0x4d, 0x65, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x63,
	0x69, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x63, 0x69, 0x72, 0x12, 0x16, 0x0a,
	0x06, 0x63, 0x62, 0x75, 0x72, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x63,
	0x62, 0x75, 0x72, 0x73, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x70, 0x69, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x03, 0x70, 0x69, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x62, 0x75, 0x72, 0x73,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x70, 0x62, 0x75, 0x72, 0x73, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x65, 0x62, 0x75, 0x72, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x06, 0x65, 0x62, 0x75, 0x72, 0x73, 0x74, 0x22, 0x79, 0x0a, 0x0c, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x26, 0x0a, 0x04, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x04, 0x64, 0x61,
	0x74, 0x61, 0x22, 0x70, 0x0a, 0x12, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x32, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x26, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x34, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x22, 0x4f, 0x0a, 0x0b, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x79, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x62, 0x79, 0x74, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x8e, 0x01, 0x0a, 0x10, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x12, 0x28, 0x0a, 0x05, 0x67, 0x72,
	0x65, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x34, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x05, 0x67,
	0x72, 0x65, 0x65, 0x6e, 0x12, 0x2a, 0x0a, 0x06, 0x79, 0x65, 0x6c, 0x6c, 0x6f, 0x77, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x52, 0x06, 0x79, 0x65, 0x6c, 0x6c, 0x6f, 0x77,
	0x12, 0x24, 0x0a, 0x03, 0x72, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74,
	0x61, 0x52, 0x03, 0x72, 0x65, 0x64, 0x22, 0xc4, 0x01, 0x0a, 0x1c, 0x50, 0x61, 0x63, 0x6b, 0x65,
	0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x50, 0x0a, 0x15, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x63, 0x61, 0x73, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x48, 0x00, 0x52, 0x13, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x4a, 0x0a, 0x13, 0x63, 0x6c, 0x6f,
	0x6e, 0x65, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x6f, 0x6e, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x48, 0x00, 0x52, 0x11, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x6f, 0x0a,
	0x07, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x12, 0x25, 0x0a, 0x0b, 0x65, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x02, 0x18,
	0x01, 0x48, 0x00, 0x52, 0x0a, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x72, 0x74, 0x12,
	0x14, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52,
	0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x42, 0x0b, 0x0a, 0x09, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x8b,
	0x01, 0x0a, 0x13, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2c, 0x0a, 0x12, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63,
	0x61, 0x73, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x10, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x52, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73,
	0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xb8, 0x01, 0x0a,
	0x11, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x2a, 0x0a, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x52, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x12, 0x28, 0x0a,
	0x10, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4f, 0x66,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x61, 0x63, 0x6b, 0x65,
	0x74, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x4c, 0x65, 0x6e, 0x67,
	0x74, 0x68, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x39, 0x0a, 0x0e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x53, 0x65, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x05, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x05, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x22, 0x62, 0x0a, 0x0d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x65, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x20, 0x0a, 0x0c, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x07, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x53, 0x65, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x52, 0x07, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x22, 0x77, 0x0a, 0x0d, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x21, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x70, 0x34, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x34, 0x44, 0x61, 0x74, 0x61, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22,
	0xd7, 0x01, 0x0a, 0x0b, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x1b, 0x0a, 0x09, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x08, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x06,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x70,
	0x34, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a,
	0x78, 0x0a, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x24, 0x0a, 0x0e, 0x6d, 0x61, 0x78,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4e, 0x73, 0x12,
	0x22, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x5f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x61, 0x63, 0x6b,
	0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4e, 0x73, 0x22, 0xf5, 0x01, 0x0a, 0x14, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x42, 0x0a, 0x0b, 0x61, 0x72, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x72, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x72, 0x62, 0x69, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x06, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x4f, 0x75, 0x74, 0x48, 0x00, 0x52, 0x06, 0x70, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x12, 0x35, 0x0a, 0x0a, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x63, 0x6b,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x6b, 0x48, 0x00, 0x52, 0x09,
	0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x41, 0x63, 0x6b, 0x12, 0x2c, 0x0a, 0x05, 0x6f, 0x74, 0x68,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x48, 0x00,
	0x52, 0x05, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x22, 0x58, 0x0a, 0x09, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x4f, 0x75, 0x74, 0x12, 0x18,
	0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x31, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x34, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x45, 0x0a, 0x0d, 0x44,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x6b, 0x12, 0x1b, 0x0a, 0x09,
	0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x08, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x6c, 0x69, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x6c, 0x69, 0x73, 0x74,
	0x49, 0x64, 0x22, 0xf5, 0x02, 0x0a, 0x15, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x0b,
	0x61, 0x72, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x41, 0x72, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x72, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x29, 0x0a, 0x06, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0f, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x49,
	0x6e, 0x48, 0x00, 0x52, 0x06, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x64,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x34,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00,
	0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x19, 0x69, 0x64, 0x6c, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x70, 0x34,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x17, 0x69,
	0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x05, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x48, 0x00, 0x52, 0x05, 0x6f,
	0x74, 0x68, 0x65, 0x72, 0x12, 0x2a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x42, 0x08, 0x0a, 0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x22, 0x57, 0x0a, 0x08, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x49, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x12, 0x31, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x83, 0x01, 0x0a, 0x0a, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x4c, 0x69,
	0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12,
	0x17, 0x0a, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x06, 0x6c, 0x69, 0x73, 0x74, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x34, 0x44, 0x61, 0x74, 0x61, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1c, 0x0a, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x47, 0x0a, 0x0e, 0x50, 0x61, 0x63,
	0x6b, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1f, 0x0a, 0x0b, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0a, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x22, 0xb4, 0x01, 0x0a, 0x17, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x41, 0x72, 0x62,
	0x69, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x1b,
	0x0a, 0x09, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x08, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x04, 0x72,
	0x6f, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x70, 0x34, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x2f, 0x0a, 0x0b,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0e, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x69, 0x6e, 0x74, 0x31, 0x32,
	0x38, 0x52, 0x0a, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2a, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x5c, 0x0a, 0x04, 0x52, 0x6f, 0x6c,
	0x65, 0x12, 0x12, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x6b, 0x0a, 0x17, 0x49, 0x64, 0x6c, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x22, 0xb1, 0x02, 0x0a, 0x0b, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61,
	0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x63, 0x61,
	0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12,
	0x36, 0x0a, 0x0a, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x4f, 0x75, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x09, 0x70, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x4f, 0x75, 0x74, 0x12, 0x43, 0x0a, 0x0f, 0x64, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x61, 0x63, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x63, 0x6b, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x0d, 0x64,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x6b, 0x12, 0x2f, 0x0a, 0x05,
	0x6f, 0x74, 0x68, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x70, 0x34,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x05, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x42, 0x09, 0x0a,
	0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x41, 0x0a, 0x0e, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x4f, 0x75, 0x74, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x2f, 0x0a, 0x0a, 0x70, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10,
	0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x4f, 0x75, 0x74,
	0x52, 0x09, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x4f, 0x75, 0x74, 0x22, 0x52, 0x0a, 0x12, 0x44,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x6b, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x3c, 0x0a, 0x0f, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x6c, 0x69, 0x73, 0x74,
	0x5f, 0x61, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x34, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x6b,
	0x52, 0x0d, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x6b, 0x22,
	0x3e, 0x0a, 0x10, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x2a, 0x0a, 0x05, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x05, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x22,
	0x2f, 0x0a, 0x07, 0x55, 0x69, 0x6e, 0x74, 0x31, 0x32, 0x38, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x69,
	0x67, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x68, 0x69, 0x67, 0x68, 0x12, 0x10,
	0x0a, 0x03, 0x6c, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x6c, 0x6f, 0x77,
	0x22, 0x9f, 0x03, 0x0a, 0x22, 0x53, 0x65, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69,
	0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x07, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x04, 0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x72, 0x6f, 0x6c, 0x65, 0x49,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x2f, 0x0a, 0x0b, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x70, 0x34, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x69, 0x6e, 0x74, 0x31, 0x32, 0x38, 0x52, 0x0a, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x48, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x37, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x77, 0x0a, 0x06, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x56, 0x45, 0x52, 0x49, 0x46, 0x59, 0x10, 0x01,
	0x12, 0x13, 0x0a, 0x0f, 0x56, 0x45, 0x52, 0x49, 0x46, 0x59, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x53,
	0x41, 0x56, 0x45, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x56, 0x45, 0x52, 0x49, 0x46, 0x59, 0x5f,
	0x41, 0x4e, 0x44, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06,
	0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x43, 0x4f,
	0x4e, 0x43, 0x49, 0x4c, 0x45, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x49, 0x54,
	0x10, 0x05, 0x22, 0x25, 0x0a, 0x23, 0x53, 0x65, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x18, 0x46, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x06, 0x70, 0x34, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x34, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x34, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x70, 0x34,
	0x69, 0x6e, 0x66, 0x6f, 0x12, 0x28, 0x0a, 0x10, 0x70, 0x34, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e,
	0x70, 0x34, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3e,
	0x0a, 0x06, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x52, 0x06, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x1a, 0x20,
	0x0a, 0x06, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6f, 0x6b,
	0x69, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x06, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65,
	0x22, 0xfd, 0x01, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69,
	0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x08, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x64, 0x12, 0x5b, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x70, 0x34,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x5d, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x4f,
	0x4f, 0x4b, 0x49, 0x45, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x50,
	0x34, 0x49, 0x4e, 0x46, 0x4f, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x43, 0x4f, 0x4f, 0x4b, 0x49, 0x45,
	0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x43, 0x4f, 0x4f, 0x4b, 0x49, 0x45, 0x10, 0x03,
	0x22, 0x5e, 0x0a, 0x23, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xa2, 0x01, 0x0a, 0x05, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61,
	0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0d, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x2e, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x07, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x15, 0x0a, 0x13, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x4a, 0x0a, 0x14,
	0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x70, 0x34, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x13, 0x70, 0x34, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x41, 0x70,
	0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2a, 0x8a, 0x01, 0x0a, 0x07, 0x53, 0x64, 0x6e,
	0x50, 0x6f, 0x72, 0x74, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x44, 0x4e, 0x5f, 0x50, 0x4f, 0x52, 0x54,
	0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x44,
	0x4e, 0x5f, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4d, 0x49, 0x4e, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x0c,
	0x53, 0x44, 0x4e, 0x5f, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x4d, 0x41, 0x58, 0x10, 0xff, 0xfd, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x21, 0x0a, 0x14, 0x53, 0x44, 0x4e, 0x5f, 0x50,
	0x4f, 0x52, 0x54, 0x5f, 0x52, 0x45, 0x43, 0x49, 0x52, 0x43, 0x55, 0x4c, 0x41, 0x54, 0x45, 0x10,
	0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x12, 0x19, 0x0a, 0x0c, 0x53, 0x44,
	0x4e, 0x5f, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x43, 0x50, 0x55, 0x10, 0xfd, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x01, 0x32, 0x83, 0x04, 0x0a, 0x09, 0x50, 0x34, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x05, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x13, 0x2e, 0x70,
	0x34, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x14, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x33, 0x0a, 0x04, 0x52, 0x65, 0x61,
	0x64, 0x12, 0x12, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x13, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x61, 0x64, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x30, 0x01, 0x12, 0x76,
	0x0a, 0x1b, 0x53, 0x65, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x2e,
	0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x76, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x72,
	0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2a, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x50,
	0x0a, 0x0d, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12,
	0x1b, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x70,
	0x34, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01,
	0x12, 0x49, 0x0a, 0x0c, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x12, 0x1a, 0x2e, 0x70, 0x34, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x70,
	0x34, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x42, 0x29, 0x5a, 0x24, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x70, 0x34, 0x6c, 0x61, 0x6e, 0x67,
	0x2f, 0x70, 0x34, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x34,
	0x2f, 0x76, 0x31, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_p4_v1_p4runtime_proto_rawDescOnce sync.Once
	file_p4_v1_p4runtime_proto_rawDescData = file_p4_v1_p4runtime_proto_rawDesc
)

func file_p4_v1_p4runtime_proto_rawDescGZIP() []byte {
	file_p4_v1_p4runtime_proto_rawDescOnce.Do(func() {
		file_p4_v1_p4runtime_proto_rawDescData = protoimpl.X.CompressGZIP(file_p4_v1_p4runtime_proto_rawDescData)
	})
	return file_p4_v1_p4runtime_proto_rawDescData
}

var file_p4_v1_p4runtime_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_p4_v1_p4runtime_proto_msgTypes = make([]protoimpl.MessageInfo, 64)
var file_p4_v1_p4runtime_proto_goTypes = []interface{}{
	(SdnPort)(0),                // 0: p4.v1.SdnPort
	(WriteRequest_Atomicity)(0), // 1: p4.v1.WriteRequest.Atomicity
	(Update_Type)(0),            // 2: p4.v1.Update.Type
	(SetForwardingPipelineConfigRequest_Action)(0),       // 3: p4.v1.SetForwardingPipelineConfigRequest.Action
	(GetForwardingPipelineConfigRequest_ResponseType)(0), // 4: p4.v1.GetForwardingPipelineConfigRequest.ResponseType
	(*WriteRequest)(nil),                                 // 5: p4.v1.WriteRequest
	(*WriteResponse)(nil),                                // 6: p4.v1.WriteResponse
	(*ReadRequest)(nil),                                  // 7: p4.v1.ReadRequest
	(*ReadResponse)(nil),                                 // 8: p4.v1.ReadResponse
	(*Update)(nil),                                       // 9: p4.v1.Update
	(*Entity)(nil),                                       // 10: p4.v1.Entity
	(*ExternEntry)(nil),                                  // 11: p4.v1.ExternEntry
	(*TableEntry)(nil),                                   // 12: p4.v1.TableEntry
	(*FieldMatch)(nil),                                   // 13: p4.v1.FieldMatch
	(*TableAction)(nil),                                  // 14: p4.v1.TableAction
	(*Action)(nil),                                       // 15: p4.v1.Action
	(*ActionProfileActionSet)(nil),                       // 16: p4.v1.ActionProfileActionSet
	(*ActionProfileAction)(nil),                          // 17: p4.v1.ActionProfileAction
	(*ActionProfileMember)(nil),                          // 18: p4.v1.ActionProfileMember
	(*ActionProfileGroup)(nil),                           // 19: p4.v1.ActionProfileGroup
	(*Index)(nil),                                        // 20: p4.v1.Index
	(*MeterEntry)(nil),                                   // 21: p4.v1.MeterEntry
	(*DirectMeterEntry)(nil),                             // 22: p4.v1.DirectMeterEntry
	(*MeterConfig)(nil),                                  // 23: p4.v1.MeterConfig
	(*CounterEntry)(nil),                                 // 24: p4.v1.CounterEntry
	(*DirectCounterEntry)(nil),                           // 25: p4.v1.DirectCounterEntry
	(*CounterData)(nil),                                  // 26: p4.v1.CounterData
	(*MeterCounterData)(nil),                             // 27: p4.v1.MeterCounterData
	(*PacketReplicationEngineEntry)(nil),                 // 28: p4.v1.PacketReplicationEngineEntry
	(*Replica)(nil),                                      // 29: p4.v1.Replica
	(*MulticastGroupEntry)(nil),                          // 30: p4.v1.MulticastGroupEntry
	(*CloneSessionEntry)(nil),                            // 31: p4.v1.CloneSessionEntry
	(*ValueSetMember)(nil),                               // 32: p4.v1.ValueSetMember
	(*ValueSetEntry)(nil),                                // 33: p4.v1.ValueSetEntry
	(*RegisterEntry)(nil),                                // 34: p4.v1.RegisterEntry
	(*DigestEntry)(nil),                                  // 35: p4.v1.DigestEntry
	(*StreamMessageRequest)(nil),                         // 36: p4.v1.StreamMessageRequest
	(*PacketOut)(nil),                                    // 37: p4.v1.PacketOut
	(*DigestListAck)(nil),                                // 38: p4.v1.DigestListAck
	(*StreamMessageResponse)(nil),                        // 39: p4.v1.StreamMessageResponse
	(*PacketIn)(nil),                                     // 40: p4.v1.PacketIn
	(*DigestList)(nil),                                   // 41: p4.v1.DigestList
	(*PacketMetadata)(nil),                               // 42: p4.v1.PacketMetadata
	(*MasterArbitrationUpdate)(nil),                      // 43: p4.v1.MasterArbitrationUpdate
	(*Role)(nil),                                         // 44: p4.v1.Role
	(*IdleTimeoutNotification)(nil),                      // 45: p4.v1.IdleTimeoutNotification
	(*StreamError)(nil),                                  // 46: p4.v1.StreamError
	(*PacketOutError)(nil),                               // 47: p4.v1.PacketOutError
	(*DigestListAckError)(nil),                           // 48: p4.v1.DigestListAckError
	(*StreamOtherError)(nil),                             // 49: p4.v1.StreamOtherError
	(*Uint128)(nil),                                      // 50: p4.v1.Uint128
	(*SetForwardingPipelineConfigRequest)(nil),           // 51: p4.v1.SetForwardingPipelineConfigRequest
	(*SetForwardingPipelineConfigResponse)(nil),          // 52: p4.v1.SetForwardingPipelineConfigResponse
	(*ForwardingPipelineConfig)(nil),                     // 53: p4.v1.ForwardingPipelineConfig
	(*GetForwardingPipelineConfigRequest)(nil),           // 54: p4.v1.GetForwardingPipelineConfigRequest
	(*GetForwardingPipelineConfigResponse)(nil),          // 55: p4.v1.GetForwardingPipelineConfigResponse
	(*Error)(nil),                                        // 56: p4.v1.Error
	(*CapabilitiesRequest)(nil),                          // 57: p4.v1.CapabilitiesRequest
	(*CapabilitiesResponse)(nil),                         // 58: p4.v1.CapabilitiesResponse
	(*TableEntry_IdleTimeout)(nil),                       // 59: p4.v1.TableEntry.IdleTimeout
	(*FieldMatch_Exact)(nil),                             // 60: p4.v1.FieldMatch.Exact
	(*FieldMatch_Ternary)(nil),                           // 61: p4.v1.FieldMatch.Ternary
	(*FieldMatch_LPM)(nil),                               // 62: p4.v1.FieldMatch.LPM
	(*FieldMatch_Range)(nil),                             // 63: p4.v1.FieldMatch.Range
	(*FieldMatch_Optional)(nil),                          // 64: p4.v1.FieldMatch.Optional
	(*Action_Param)(nil),                                 // 65: p4.v1.Action.Param
	(*ActionProfileGroup_Member)(nil),                    // 66: p4.v1.ActionProfileGroup.Member
	(*DigestEntry_Config)(nil),                           // 67: p4.v1.DigestEntry.Config
	(*ForwardingPipelineConfig_Cookie)(nil),              // 68: p4.v1.ForwardingPipelineConfig.Cookie
	(*anypb.Any)(nil),                                    // 69: google.protobuf.Any
	(*P4Data)(nil),                                       // 70: p4.v1.P4Data
	(*status.Status)(nil),                                // 71: google.rpc.Status
	(*v1.P4Info)(nil),                                    // 72: p4.config.v1.P4Info
}
var file_p4_v1_p4runtime_proto_depIdxs = []int32{
	50, // 0: p4.v1.WriteRequest.election_id:type_name -> p4.v1.Uint128
	9,  // 1: p4.v1.WriteRequest.updates:type_name -> p4.v1.Update
	1,  // 2: p4.v1.WriteRequest.atomicity:type_name -> p4.v1.WriteRequest.Atomicity
	10, // 3: p4.v1.ReadRequest.entities:type_name -> p4.v1.Entity
	10, // 4: p4.v1.ReadResponse.entities:type_name -> p4.v1.Entity
	2,  // 5: p4.v1.Update.type:type_name -> p4.v1.Update.Type
	10, // 6: p4.v1.Update.entity:type_name -> p4.v1.Entity
	11, // 7: p4.v1.Entity.extern_entry:type_name -> p4.v1.ExternEntry
	12, // 8: p4.v1.Entity.table_entry:type_name -> p4.v1.TableEntry
	18, // 9: p4.v1.Entity.action_profile_member:type_name -> p4.v1.ActionProfileMember
	19, // 10: p4.v1.Entity.action_profile_group:type_name -> p4.v1.ActionProfileGroup
	21, // 11: p4.v1.Entity.meter_entry:type_name -> p4.v1.MeterEntry
	22, // 12: p4.v1.Entity.direct_meter_entry:type_name -> p4.v1.DirectMeterEntry
	24, // 13: p4.v1.Entity.counter_entry:type_name -> p4.v1.CounterEntry
	25, // 14: p4.v1.Entity.direct_counter_entry:type_name -> p4.v1.DirectCounterEntry
	28, // 15: p4.v1.Entity.packet_replication_engine_entry:type_name -> p4.v1.PacketReplicationEngineEntry
	33, // 16: p4.v1.Entity.value_set_entry:type_name -> p4.v1.ValueSetEntry
	34, // 17: p4.v1.Entity.register_entry:type_name -> p4.v1.RegisterEntry
	35, // 18: p4.v1.Entity.digest_entry:type_name -> p4.v1.DigestEntry
	69, // 19: p4.v1.ExternEntry.entry:type_name -> google.protobuf.Any
	13, // 20: p4.v1.TableEntry.match:type_name -> p4.v1.FieldMatch
	14, // 21: p4.v1.TableEntry.action:type_name -> p4.v1.TableAction
	23, // 22: p4.v1.TableEntry.meter_config:type_name -> p4.v1.MeterConfig
	26, // 23: p4.v1.TableEntry.counter_data:type_name -> p4.v1.CounterData
	27, // 24: p4.v1.TableEntry.meter_counter_data:type_name -> p4.v1.MeterCounterData
	59, // 25: p4.v1.TableEntry.time_since_last_hit:type_name -> p4.v1.TableEntry.IdleTimeout
	60, // 26: p4.v1.FieldMatch.exact:type_name -> p4.v1.FieldMatch.Exact
	61, // 27: p4.v1.FieldMatch.ternary:type_name -> p4.v1.FieldMatch.Ternary
	62, // 28: p4.v1.FieldMatch.lpm:type_name -> p4.v1.FieldMatch.LPM
	63, // 29: p4.v1.FieldMatch.range:type_name -> p4.v1.FieldMatch.Range
	64, // 30: p4.v1.FieldMatch.optional:type_name -> p4.v1.FieldMatch.Optional
	69, // 31: p4.v1.FieldMatch.other:type_name -> google.protobuf.Any
	15, // 32: p4.v1.TableAction.action:type_name -> p4.v1.Action
	16, // 33: p4.v1.TableAction.action_profile_action_set:type_name -> p4.v1.ActionProfileActionSet
	65, // 34: p4.v1.Action.params:type_name -> p4.v1.Action.Param
	17, // 35: p4.v1.ActionProfileActionSet.action_profile_actions:type_name -> p4.v1.ActionProfileAction
	15, // 36: p4.v1.ActionProfileAction.action:type_name -> p4.v1.Action
	15, // 37: p4.v1.ActionProfileMember.action:type_name -> p4.v1.Action
	66, // 38: p4.v1.ActionProfileGroup.members:type_name -> p4.v1.ActionProfileGroup.Member
	20, // 39: p4.v1.MeterEntry.index:type_name -> p4.v1.Index
	23, // 40: p4.v1.MeterEntry.config:type_name -> p4.v1.MeterConfig
	27, // 41: p4.v1.MeterEntry.counter_data:type_name -> p4.v1.MeterCounterData
	12, // 42: p4.v1.DirectMeterEntry.table_entry:type_name -> p4.v1.TableEntry
	23, // 43: p4.v1.DirectMeterEntry.config:type_name -> p4.v1.MeterConfig
	27, // 44: p4.v1.DirectMeterEntry.counter_data:type_name -> p4.v1.MeterCounterData
	20, // 45: p4.v1.CounterEntry.index:type_name -> p4.v1.Index
	26, // 46: p4.v1.CounterEntry.data:type_name -> p4.v1.CounterData
	12, // 47: p4.v1.DirectCounterEntry.table_entry:type_name -> p4.v1.TableEntry
	26, // 48: p4.v1.DirectCounterEntry.data:type_name -> p4.v1.CounterData
	26, // 49: p4.v1.MeterCounterData.green:type_name -> p4.v1.CounterData
	26, // 50: p4.v1.MeterCounterData.yellow:type_name -> p4.v1.CounterData
	26, // 51: p4.v1.MeterCounterData.red:type_name -> p4.v1.CounterData
	30, // 52: p4.v1.PacketReplicationEngineEntry.multicast_group_entry:type_name -> p4.v1.MulticastGroupEntry
	31, // 53: p4.v1.PacketReplicationEngineEntry.clone_session_entry:type_name -> p4.v1.CloneSessionEntry
	29, // 54: p4.v1.MulticastGroupEntry.replicas:type_name -> p4.v1.Replica
	29, // 55: p4.v1.CloneSessionEntry.replicas:type_name -> p4.v1.Replica
	13, // 56: p4.v1.ValueSetMember.match:type_name -> p4.v1.FieldMatch
	32, // 57: p4.v1.ValueSetEntry.members:type_name -> p4.v1.ValueSetMember
	20, // 58: p4.v1.RegisterEntry.index:type_name -> p4.v1.Index
	70, // 59: p4.v1.RegisterEntry.data:type_name -> p4.v1.P4Data
	67, // 60: p4.v1.DigestEntry.config:type_name -> p4.v1.DigestEntry.Config
	43, // 61: p4.v1.StreamMessageRequest.arbitration:type_name -> p4.v1.MasterArbitrationUpdate
	37, // 62: p4.v1.StreamMessageRequest.packet:type_name -> p4.v1.PacketOut
	38, // 63: p4.v1.StreamMessageRequest.digest_ack:type_name -> p4.v1.DigestListAck
	69, // 64: p4.v1.StreamMessageRequest.other:type_name -> google.protobuf.Any
	42, // 65: p4.v1.PacketOut.metadata:type_name -> p4.v1.PacketMetadata
	43, // 66: p4.v1.StreamMessageResponse.arbitration:type_name -> p4.v1.MasterArbitrationUpdate
	40, // 67: p4.v1.StreamMessageResponse.packet:type_name -> p4.v1.PacketIn
	41, // 68: p4.v1.StreamMessageResponse.digest:type_name -> p4.v1.DigestList
	45, // 69: p4.v1.StreamMessageResponse.idle_timeout_notification:type_name -> p4.v1.IdleTimeoutNotification
	69, // 70: p4.v1.StreamMessageResponse.other:type_name -> google.protobuf.Any
	46, // 71: p4.v1.StreamMessageResponse.error:type_name -> p4.v1.StreamError
	42, // 72: p4.v1.PacketIn.metadata:type_name -> p4.v1.PacketMetadata
	70, // 73: p4.v1.DigestList.data:type_name -> p4.v1.P4Data
	44, // 74: p4.v1.MasterArbitrationUpdate.role:type_name -> p4.v1.Role
	50, // 75: p4.v1.MasterArbitrationUpdate.election_id:type_name -> p4.v1.Uint128
	71, // 76: p4.v1.MasterArbitrationUpdate.status:type_name -> google.rpc.Status
	69, // 77: p4.v1.Role.config:type_name -> google.protobuf.Any
	12, // 78: p4.v1.IdleTimeoutNotification.table_entry:type_name -> p4.v1.TableEntry
	47, // 79: p4.v1.StreamError.packet_out:type_name -> p4.v1.PacketOutError
	48, // 80: p4.v1.StreamError.digest_list_ack:type_name -> p4.v1.DigestListAckError
	49, // 81: p4.v1.StreamError.other:type_name -> p4.v1.StreamOtherError
	37, // 82: p4.v1.PacketOutError.packet_out:type_name -> p4.v1.PacketOut
	38, // 83: p4.v1.DigestListAckError.digest_list_ack:type_name -> p4.v1.DigestListAck
	69, // 84: p4.v1.StreamOtherError.other:type_name -> google.protobuf.Any
	50, // 85: p4.v1.SetForwardingPipelineConfigRequest.election_id:type_name -> p4.v1.Uint128
	3,  // 86: p4.v1.SetForwardingPipelineConfigRequest.action:type_name -> p4.v1.SetForwardingPipelineConfigRequest.Action
	53, // 87: p4.v1.SetForwardingPipelineConfigRequest.config:type_name -> p4.v1.ForwardingPipelineConfig
	72, // 88: p4.v1.ForwardingPipelineConfig.p4info:type_name -> p4.config.v1.P4Info
	68, // 89: p4.v1.ForwardingPipelineConfig.cookie:type_name -> p4.v1.ForwardingPipelineConfig.Cookie
	4,  // 90: p4.v1.GetForwardingPipelineConfigRequest.response_type:type_name -> p4.v1.GetForwardingPipelineConfigRequest.ResponseType
	53, // 91: p4.v1.GetForwardingPipelineConfigResponse.config:type_name -> p4.v1.ForwardingPipelineConfig
	69, // 92: p4.v1.Error.details:type_name -> google.protobuf.Any
	5,  // 93: p4.v1.P4Runtime.Write:input_type -> p4.v1.WriteRequest
	7,  // 94: p4.v1.P4Runtime.Read:input_type -> p4.v1.ReadRequest
	51, // 95: p4.v1.P4Runtime.SetForwardingPipelineConfig:input_type -> p4.v1.SetForwardingPipelineConfigRequest
	54, // 96: p4.v1.P4Runtime.GetForwardingPipelineConfig:input_type -> p4.v1.GetForwardingPipelineConfigRequest
	36, // 97: p4.v1.P4Runtime.StreamChannel:input_type -> p4.v1.StreamMessageRequest
	57, // 98: p4.v1.P4Runtime.Capabilities:input_type -> p4.v1.CapabilitiesRequest
	6,  // 99: p4.v1.P4Runtime.Write:output_type -> p4.v1.WriteResponse
	8,  // 100: p4.v1.P4Runtime.Read:output_type -> p4.v1.ReadResponse
	52, // 101: p4.v1.P4Runtime.SetForwardingPipelineConfig:output_type -> p4.v1.SetForwardingPipelineConfigResponse
	55, // 102: p4.v1.P4Runtime.GetForwardingPipelineConfig:output_type -> p4.v1.GetForwardingPipelineConfigResponse
	39, // 103: p4.v1.P4Runtime.StreamChannel:output_type -> p4.v1.StreamMessageResponse
	58, // 104: p4.v1.P4Runtime.Capabilities:output_type -> p4.v1.CapabilitiesResponse
	99, // [99:105] is the sub-list for method output_type
	93, // [93:99] is the sub-list for method input_type
	93, // [93:93] is the sub-list for extension type_name
	93, // [93:93] is the sub-list for extension extendee
	0,  // [0:93] is the sub-list for field type_name
}

func init() { file_p4_v1_p4runtime_proto_init() }
func file_p4_v1_p4runtime_proto_init() {
	if File_p4_v1_p4runtime_proto != nil {
		return
	}
	file_p4_v1_p4data_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_p4_v1_p4runtime_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Update); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExternEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionProfileActionSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionProfileAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionProfileMember); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionProfileGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Index); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MeterEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DirectMeterEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MeterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CounterEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DirectCounterEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CounterData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MeterCounterData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketReplicationEngineEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Replica); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MulticastGroupEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloneSessionEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValueSetMember); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ValueSetEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DigestEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamMessageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketOut); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DigestListAck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamMessageResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketIn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DigestList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MasterArbitrationUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Role); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IdleTimeoutNotification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PacketOutError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DigestListAckError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamOtherError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Uint128); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetForwardingPipelineConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetForwardingPipelineConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ForwardingPipelineConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetForwardingPipelineConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetForwardingPipelineConfigResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Error); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CapabilitiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CapabilitiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TableEntry_IdleTimeout); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldMatch_Exact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldMatch_Ternary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldMatch_LPM); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldMatch_Range); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldMatch_Optional); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_Param); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionProfileGroup_Member); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DigestEntry_Config); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_p4_v1_p4runtime_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ForwardingPipelineConfig_Cookie); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_p4_v1_p4runtime_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*Entity_ExternEntry)(nil),
		(*Entity_TableEntry)(nil),
		(*Entity_ActionProfileMember)(nil),
		(*Entity_ActionProfileGroup)(nil),
		(*Entity_MeterEntry)(nil),
		(*Entity_DirectMeterEntry)(nil),
		(*Entity_CounterEntry)(nil),
		(*Entity_DirectCounterEntry)(nil),
		(*Entity_PacketReplicationEngineEntry)(nil),
		(*Entity_ValueSetEntry)(nil),
		(*Entity_RegisterEntry)(nil),
		(*Entity_DigestEntry)(nil),
	}
	file_p4_v1_p4runtime_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*FieldMatch_Exact_)(nil),
		(*FieldMatch_Ternary_)(nil),
		(*FieldMatch_Lpm)(nil),
		(*FieldMatch_Range_)(nil),
		(*FieldMatch_Optional_)(nil),
		(*FieldMatch_Other)(nil),
	}
	file_p4_v1_p4runtime_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*TableAction_Action)(nil),
		(*TableAction_ActionProfileMemberId)(nil),
		(*TableAction_ActionProfileGroupId)(nil),
		(*TableAction_ActionProfileActionSet)(nil),
	}
	file_p4_v1_p4runtime_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*ActionProfileAction_Watch)(nil),
		(*ActionProfileAction_WatchPort)(nil),
	}
	file_p4_v1_p4runtime_proto_msgTypes[23].OneofWrappers = []interface{}{
		(*PacketReplicationEngineEntry_MulticastGroupEntry)(nil),
		(*PacketReplicationEngineEntry_CloneSessionEntry)(nil),
	}
	file_p4_v1_p4runtime_proto_msgTypes[24].OneofWrappers = []interface{}{
		(*Replica_EgressPort)(nil),
		(*Replica_Port)(nil),
	}
	file_p4_v1_p4runtime_proto_msgTypes[31].OneofWrappers = []interface{}{
		(*StreamMessageRequest_Arbitration)(nil),
		(*StreamMessageRequest_Packet)(nil),
		(*StreamMessageRequest_DigestAck)(nil),
		(*StreamMessageRequest_Other)(nil),
	}
	file_p4_v1_p4runtime_proto_msgTypes[34].OneofWrappers = []interface{}{
		(*StreamMessageResponse_Arbitration)(nil),
		(*StreamMessageResponse_Packet)(nil),
		(*StreamMessageResponse_Digest)(nil),
		(*StreamMessageResponse_IdleTimeoutNotification)(nil),
		(*StreamMessageResponse_Other)(nil),
		(*StreamMessageResponse_Error)(nil),
	}
	file_p4_v1_p4runtime_proto_msgTypes[41].OneofWrappers = []interface{}{
		(*StreamError_PacketOut)(nil),
		(*StreamError_DigestListAck)(nil),
		(*StreamError_Other)(nil),
	}
	file_p4_v1_p4runtime_proto_msgTypes[61].OneofWrappers = []interface{}{
		(*ActionProfileGroup_Member_Watch)(nil),
		(*ActionProfileGroup_Member_WatchPort)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_p4_v1_p4runtime_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   64,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_p4_v1_p4runtime_proto_goTypes,
		DependencyIndexes: file_p4_v1_p4runtime_proto_depIdxs,
		EnumInfos:         file_p4_v1_p4runtime_proto_enumTypes,
		MessageInfos:      file_p4_v1_p4runtime_proto_msgTypes,
	}.Build()
	File_p4_v1_p4runtime_proto = out.File
	file_p4_v1_p4runtime_proto_rawDesc = nil
	file_p4_v1_p4runtime_proto_goTypes = nil
	file_p4_v1_p4runtime_proto_depIdxs = nil
}
