package dnscache

import (
	"context"
	"fmt"
	"net"
	"net/http"
)

func Example() {
	r := &Resolver{}
	t := &http.Transport{
		DialContext: func(ctx context.Context, network string, addr string) (conn net.Conn, err error) {
			host, port, err := net.SplitHostPort(addr)
			if err != nil {
				return nil, err
			}
			ips, err := r.LookupHost(ctx, host)
			if err != nil {
				return nil, err
			}
			for _, ip := range ips {
				var dialer net.Dialer
				conn, err = dialer.DialContext(ctx, network, net.JoinHostPort(ip, port))
				if err == nil {
					break
				}
			}
			return
		},
	}
	c := &http.Client{Transport: t}
	res, err := c.Get("http://httpbin.org/status/418")
	if err == nil {
		fmt.Println(res.StatusCode)
	}
	// Output: 418
}
