package wazero_test

import (
	"context"
	_ "embed"
	"fmt"
	"log"

	"github.com/tetratelabs/wazero"
	"github.com/tetratelabs/wazero/imports/wasi_snapshot_preview1"
)

// addWasm was generated by the following:
//
//	cd examples/basic/testdata; tinygo build -o add.wasm -target=wasi add.go
//
//go:embed examples/basic/testdata/add.wasm
var addWasm []byte

// This is an example of how to extend a Go application with an addition
// function defined in WebAssembly.
//
// Since addWasm was compiled with TinyGo's `wasi` target, we need to configure
// WASI host imports.
//
// A complete project that does the same as this is available here:
// https://github.com/tetratelabs/wazero/tree/main/examples/basic
func Example() {
	// Choose the context to use for function calls.
	ctx := context.Background()

	// Create a new WebAssembly Runtime.
	r := wazero.NewRuntime(ctx)
	defer r.Close(ctx) // This closes everything this Runtime created.

	// Instantiate WASI, which implements host functions needed for TinyGo to
	// implement `panic`.
	wasi_snapshot_preview1.MustInstantiate(ctx, r)

	// Instantiate the guest Wasm into the same runtime. It exports the `add`
	// function, implemented in WebAssembly.
	mod, err := r.Instantiate(ctx, addWasm)
	if err != nil {
		log.Panicln(err)
	}

	// Call the `add` function and print the results to the console.
	x, y := uint64(1), uint64(2)
	results, err := mod.ExportedFunction("add").Call(ctx, x, y)
	if err != nil {
		log.Panicln(err)
	}

	fmt.Printf("%d + %d = %d\n", x, y, results[0])

	// Output:
	// 1 + 2 = 3
}
