// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ExponentialHistogram represents the type of a metric that is calculated by aggregating
// as a ExponentialHistogram of all reported double measurements over a time interval.
type ExponentialHistogram struct {
	DataPoints             []*ExponentialHistogramDataPoint
	AggregationTemporality AggregationTemporality
}

var (
	protoPoolExponentialHistogram = sync.Pool{
		New: func() any {
			return &ExponentialHistogram{}
		},
	}
)

func NewExponentialHistogram() *ExponentialHistogram {
	if !UseProtoPooling.IsEnabled() {
		return &ExponentialHistogram{}
	}
	return protoPoolExponentialHistogram.Get().(*ExponentialHistogram)
}

func DeleteExponentialHistogram(orig *ExponentialHistogram, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.DataPoints {
		DeleteExponentialHistogramDataPoint(orig.DataPoints[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolExponentialHistogram.Put(orig)
	}
}

func CopyExponentialHistogram(dest, src *ExponentialHistogram) *ExponentialHistogram {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExponentialHistogram()
	}
	dest.DataPoints = CopyExponentialHistogramDataPointPtrSlice(dest.DataPoints, src.DataPoints)

	dest.AggregationTemporality = src.AggregationTemporality

	return dest
}

func CopyExponentialHistogramSlice(dest, src []ExponentialHistogram) []ExponentialHistogram {
	var newDest []ExponentialHistogram
	if cap(dest) < len(src) {
		newDest = make([]ExponentialHistogram, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExponentialHistogram(&dest[i], false)
		}
	}
	for i := range src {
		CopyExponentialHistogram(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExponentialHistogramPtrSlice(dest, src []*ExponentialHistogram) []*ExponentialHistogram {
	var newDest []*ExponentialHistogram
	if cap(dest) < len(src) {
		newDest = make([]*ExponentialHistogram, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExponentialHistogram()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExponentialHistogram(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExponentialHistogram()
		}
	}
	for i := range src {
		CopyExponentialHistogram(newDest[i], src[i])
	}
	return newDest
}

func (orig *ExponentialHistogram) Reset() {
	*orig = ExponentialHistogram{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ExponentialHistogram) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.DataPoints) > 0 {
		dest.WriteObjectField("dataPoints")
		dest.WriteArrayStart()
		orig.DataPoints[0].MarshalJSON(dest)
		for i := 1; i < len(orig.DataPoints); i++ {
			dest.WriteMore()
			orig.DataPoints[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}

	if int32(orig.AggregationTemporality) != 0 {
		dest.WriteObjectField("aggregationTemporality")
		dest.WriteInt32(int32(orig.AggregationTemporality))
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ExponentialHistogram) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "dataPoints", "data_points":
			for iter.ReadArray() {
				orig.DataPoints = append(orig.DataPoints, NewExponentialHistogramDataPoint())
				orig.DataPoints[len(orig.DataPoints)-1].UnmarshalJSON(iter)
			}

		case "aggregationTemporality", "aggregation_temporality":
			orig.AggregationTemporality = AggregationTemporality(iter.ReadEnumValue(AggregationTemporality_value))
		default:
			iter.Skip()
		}
	}
}

func (orig *ExponentialHistogram) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = orig.DataPoints[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.AggregationTemporality != 0 {
		n += 1 + proto.Sov(uint64(orig.AggregationTemporality))
	}
	return n
}

func (orig *ExponentialHistogram) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.DataPoints) - 1; i >= 0; i-- {
		l = orig.DataPoints[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	if orig.AggregationTemporality != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.AggregationTemporality))
		pos--
		buf[pos] = 0x10
	}
	return len(buf) - pos
}

func (orig *ExponentialHistogram) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.DataPoints = append(orig.DataPoints, NewExponentialHistogramDataPoint())
			err = orig.DataPoints[len(orig.DataPoints)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.AggregationTemporality = AggregationTemporality(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestExponentialHistogram() *ExponentialHistogram {
	orig := NewExponentialHistogram()
	orig.DataPoints = []*ExponentialHistogramDataPoint{{}, GenTestExponentialHistogramDataPoint()}
	orig.AggregationTemporality = AggregationTemporality(13)
	return orig
}

func GenTestExponentialHistogramPtrSlice() []*ExponentialHistogram {
	orig := make([]*ExponentialHistogram, 5)
	orig[0] = NewExponentialHistogram()
	orig[1] = GenTestExponentialHistogram()
	orig[2] = NewExponentialHistogram()
	orig[3] = GenTestExponentialHistogram()
	orig[4] = NewExponentialHistogram()
	return orig
}

func GenTestExponentialHistogramSlice() []ExponentialHistogram {
	orig := make([]ExponentialHistogram, 5)
	orig[1] = *GenTestExponentialHistogram()
	orig[3] = *GenTestExponentialHistogram()
	return orig
}
