// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectortrace "go.opentelemetry.io/proto/slim/otlp/collector/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExportTracePartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTracePartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExportTracePartialSuccess()
				CopyExportTracePartialSuccess(dest, src)
				assert.Equal(t, src, dest)
				CopyExportTracePartialSuccess(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExportTracePartialSuccessSlice(t *testing.T) {
	src := []ExportTracePartialSuccess{}
	dest := []ExportTracePartialSuccess{}
	// Test CopyTo empty
	dest = CopyExportTracePartialSuccessSlice(dest, src)
	assert.Equal(t, []ExportTracePartialSuccess{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportTracePartialSuccessSlice()
	dest = CopyExportTracePartialSuccessSlice(dest, src)
	assert.Equal(t, GenTestExportTracePartialSuccessSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportTracePartialSuccessSlice(dest, src)
	assert.Equal(t, GenTestExportTracePartialSuccessSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportTracePartialSuccessSlice(dest, []ExportTracePartialSuccess{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportTracePartialSuccessSlice(dest, src)
	assert.Equal(t, GenTestExportTracePartialSuccessSlice(), dest)
}

func TestCopyExportTracePartialSuccessPtrSlice(t *testing.T) {
	src := []*ExportTracePartialSuccess{}
	dest := []*ExportTracePartialSuccess{}
	// Test CopyTo empty
	dest = CopyExportTracePartialSuccessPtrSlice(dest, src)
	assert.Equal(t, []*ExportTracePartialSuccess{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportTracePartialSuccessPtrSlice()
	dest = CopyExportTracePartialSuccessPtrSlice(dest, src)
	assert.Equal(t, GenTestExportTracePartialSuccessPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportTracePartialSuccessPtrSlice(dest, src)
	assert.Equal(t, GenTestExportTracePartialSuccessPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportTracePartialSuccessPtrSlice(dest, []*ExportTracePartialSuccess{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportTracePartialSuccessPtrSlice(dest, src)
	assert.Equal(t, GenTestExportTracePartialSuccessPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExportTracePartialSuccessUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExportTracePartialSuccess()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExportTracePartialSuccess(), dest)
}

func TestMarshalAndUnmarshalJSONExportTracePartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTracePartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExportTracePartialSuccess()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExportTracePartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExportTracePartialSuccessFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportTracePartialSuccess() {
		t.Run(name, func(t *testing.T) {
			dest := NewExportTracePartialSuccess()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExportTracePartialSuccessUnknown(t *testing.T) {
	dest := NewExportTracePartialSuccess()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExportTracePartialSuccess(), dest)
}

func TestMarshalAndUnmarshalProtoExportTracePartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTracePartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExportTracePartialSuccess()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExportTracePartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportTracePartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTracePartialSuccess() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectortrace.ExportTracePartialSuccess{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExportTracePartialSuccess()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportTracePartialSuccess() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                 {0x02},
		"RejectedSpans/wrong_wire_type": {0xc},
		"RejectedSpans/missing_value":   {0x8},
		"ErrorMessage/wrong_wire_type":  {0x14},
		"ErrorMessage/missing_value":    {0x12},
	}
}

func genTestEncodingValuesExportTracePartialSuccess() map[string]*ExportTracePartialSuccess {
	return map[string]*ExportTracePartialSuccess{
		"empty":              NewExportTracePartialSuccess(),
		"RejectedSpans/test": {RejectedSpans: int64(13)},
		"ErrorMessage/test":  {ErrorMessage: "test_errormessage"},
	}
}
