// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Link represents a pointer from a profile Sample to a trace Span.
type Link struct {
	TraceId TraceID
	SpanId  SpanID
}

var (
	protoPoolLink = sync.Pool{
		New: func() any {
			return &Link{}
		},
	}
)

func NewLink() *Link {
	if !UseProtoPooling.IsEnabled() {
		return &Link{}
	}
	return protoPoolLink.Get().(*Link)
}

func DeleteLink(orig *Link, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteTraceID(&orig.TraceId, false)
	DeleteSpanID(&orig.SpanId, false)

	orig.Reset()
	if nullable {
		protoPoolLink.Put(orig)
	}
}

func CopyLink(dest, src *Link) *Link {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewLink()
	}
	CopyTraceID(&dest.TraceId, &src.TraceId)

	CopySpanID(&dest.SpanId, &src.SpanId)

	return dest
}

func CopyLinkSlice(dest, src []Link) []Link {
	var newDest []Link
	if cap(dest) < len(src) {
		newDest = make([]Link, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteLink(&dest[i], false)
		}
	}
	for i := range src {
		CopyLink(&newDest[i], &src[i])
	}
	return newDest
}

func CopyLinkPtrSlice(dest, src []*Link) []*Link {
	var newDest []*Link
	if cap(dest) < len(src) {
		newDest = make([]*Link, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewLink()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteLink(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewLink()
		}
	}
	for i := range src {
		CopyLink(newDest[i], src[i])
	}
	return newDest
}

func (orig *Link) Reset() {
	*orig = Link{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Link) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if !orig.TraceId.IsEmpty() {
		dest.WriteObjectField("traceId")
		orig.TraceId.MarshalJSON(dest)
	}
	if !orig.SpanId.IsEmpty() {
		dest.WriteObjectField("spanId")
		orig.SpanId.MarshalJSON(dest)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Link) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "traceId", "trace_id":

			orig.TraceId.UnmarshalJSON(iter)
		case "spanId", "span_id":

			orig.SpanId.UnmarshalJSON(iter)
		default:
			iter.Skip()
		}
	}
}

func (orig *Link) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.TraceId.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	l = orig.SpanId.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func (orig *Link) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.TraceId.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	l = orig.SpanId.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	return len(buf) - pos
}

func (orig *Link) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.TraceId.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.SpanId.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestLink() *Link {
	orig := NewLink()
	orig.TraceId = *GenTestTraceID()
	orig.SpanId = *GenTestSpanID()
	return orig
}

func GenTestLinkPtrSlice() []*Link {
	orig := make([]*Link, 5)
	orig[0] = NewLink()
	orig[1] = GenTestLink()
	orig[2] = NewLink()
	orig[3] = GenTestLink()
	orig[4] = NewLink()
	return orig
}

func GenTestLinkSlice() []Link {
	orig := make([]Link, 5)
	orig[1] = *GenTestLink()
	orig[3] = *GenTestLink()
	return orig
}
