// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectorprofiles "go.opentelemetry.io/proto/slim/otlp/collector/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExportProfilesServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExportProfilesServiceRequest()
				CopyExportProfilesServiceRequest(dest, src)
				assert.Equal(t, src, dest)
				CopyExportProfilesServiceRequest(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExportProfilesServiceRequestSlice(t *testing.T) {
	src := []ExportProfilesServiceRequest{}
	dest := []ExportProfilesServiceRequest{}
	// Test CopyTo empty
	dest = CopyExportProfilesServiceRequestSlice(dest, src)
	assert.Equal(t, []ExportProfilesServiceRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportProfilesServiceRequestSlice()
	dest = CopyExportProfilesServiceRequestSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesServiceRequestSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportProfilesServiceRequestSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesServiceRequestSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportProfilesServiceRequestSlice(dest, []ExportProfilesServiceRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportProfilesServiceRequestSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesServiceRequestSlice(), dest)
}

func TestCopyExportProfilesServiceRequestPtrSlice(t *testing.T) {
	src := []*ExportProfilesServiceRequest{}
	dest := []*ExportProfilesServiceRequest{}
	// Test CopyTo empty
	dest = CopyExportProfilesServiceRequestPtrSlice(dest, src)
	assert.Equal(t, []*ExportProfilesServiceRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportProfilesServiceRequestPtrSlice()
	dest = CopyExportProfilesServiceRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesServiceRequestPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportProfilesServiceRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesServiceRequestPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportProfilesServiceRequestPtrSlice(dest, []*ExportProfilesServiceRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportProfilesServiceRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesServiceRequestPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExportProfilesServiceRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExportProfilesServiceRequest()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExportProfilesServiceRequest(), dest)
}

func TestMarshalAndUnmarshalJSONExportProfilesServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExportProfilesServiceRequest()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExportProfilesServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExportProfilesServiceRequestFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportProfilesServiceRequest() {
		t.Run(name, func(t *testing.T) {
			dest := NewExportProfilesServiceRequest()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExportProfilesServiceRequestUnknown(t *testing.T) {
	dest := NewExportProfilesServiceRequest()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExportProfilesServiceRequest(), dest)
}

func TestMarshalAndUnmarshalProtoExportProfilesServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExportProfilesServiceRequest()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExportProfilesServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportProfilesServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesServiceRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectorprofiles.ExportProfilesServiceRequest{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExportProfilesServiceRequest()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportProfilesServiceRequest() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                    {0x02},
		"ResourceProfiles/wrong_wire_type": {0xc},
		"ResourceProfiles/missing_value":   {0xa},
		"Dictionary/wrong_wire_type":       {0x14},
		"Dictionary/missing_value":         {0x12},
	}
}

func genTestEncodingValuesExportProfilesServiceRequest() map[string]*ExportProfilesServiceRequest {
	return map[string]*ExportProfilesServiceRequest{
		"empty":                 NewExportProfilesServiceRequest(),
		"ResourceProfiles/test": {ResourceProfiles: []*ResourceProfiles{{}, GenTestResourceProfiles()}},
		"Dictionary/test":       {Dictionary: *GenTestProfilesDictionary()},
	}
}
