// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlplogs "go.opentelemetry.io/proto/slim/otlp/logs/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyLogsData(t *testing.T) {
	for name, src := range genTestEncodingValuesLogsData() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewLogsData()
				CopyLogsData(dest, src)
				assert.Equal(t, src, dest)
				CopyLogsData(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyLogsDataSlice(t *testing.T) {
	src := []LogsData{}
	dest := []LogsData{}
	// Test CopyTo empty
	dest = CopyLogsDataSlice(dest, src)
	assert.Equal(t, []LogsData{}, dest)

	// Test CopyTo larger slice
	src = GenTestLogsDataSlice()
	dest = CopyLogsDataSlice(dest, src)
	assert.Equal(t, GenTestLogsDataSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyLogsDataSlice(dest, src)
	assert.Equal(t, GenTestLogsDataSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyLogsDataSlice(dest, []LogsData{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyLogsDataSlice(dest, src)
	assert.Equal(t, GenTestLogsDataSlice(), dest)
}

func TestCopyLogsDataPtrSlice(t *testing.T) {
	src := []*LogsData{}
	dest := []*LogsData{}
	// Test CopyTo empty
	dest = CopyLogsDataPtrSlice(dest, src)
	assert.Equal(t, []*LogsData{}, dest)

	// Test CopyTo larger slice
	src = GenTestLogsDataPtrSlice()
	dest = CopyLogsDataPtrSlice(dest, src)
	assert.Equal(t, GenTestLogsDataPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyLogsDataPtrSlice(dest, src)
	assert.Equal(t, GenTestLogsDataPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyLogsDataPtrSlice(dest, []*LogsData{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyLogsDataPtrSlice(dest, src)
	assert.Equal(t, GenTestLogsDataPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONLogsDataUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewLogsData()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewLogsData(), dest)
}

func TestMarshalAndUnmarshalJSONLogsData(t *testing.T) {
	for name, src := range genTestEncodingValuesLogsData() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewLogsData()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteLogsData(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoLogsDataFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesLogsData() {
		t.Run(name, func(t *testing.T) {
			dest := NewLogsData()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoLogsDataUnknown(t *testing.T) {
	dest := NewLogsData()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewLogsData(), dest)
}

func TestMarshalAndUnmarshalProtoLogsData(t *testing.T) {
	for name, src := range genTestEncodingValuesLogsData() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewLogsData()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteLogsData(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufLogsData(t *testing.T) {
	for name, src := range genTestEncodingValuesLogsData() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlplogs.LogsData{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewLogsData()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesLogsData() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                {0x02},
		"ResourceLogs/wrong_wire_type": {0xc},
		"ResourceLogs/missing_value":   {0xa},
	}
}

func genTestEncodingValuesLogsData() map[string]*LogsData {
	return map[string]*LogsData{
		"empty":             NewLogsData(),
		"ResourceLogs/test": {ResourceLogs: []*ResourceLogs{{}, GenTestResourceLogs()}},
	}
}
