// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pmetric

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestResourceMetrics_MoveTo(t *testing.T) {
	ms := generateTestResourceMetrics()
	dest := NewResourceMetrics()
	ms.MoveTo(dest)
	assert.Equal(t, NewResourceMetrics(), ms)
	assert.Equal(t, generateTestResourceMetrics(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestResourceMetrics(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newResourceMetrics(internal.NewResourceMetrics(), sharedState)) })
	assert.Panics(t, func() { newResourceMetrics(internal.NewResourceMetrics(), sharedState).MoveTo(dest) })
}

func TestResourceMetrics_CopyTo(t *testing.T) {
	ms := NewResourceMetrics()
	orig := NewResourceMetrics()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestResourceMetrics()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newResourceMetrics(internal.NewResourceMetrics(), sharedState)) })
}

func TestResourceMetrics_Resource(t *testing.T) {
	ms := NewResourceMetrics()
	assert.Equal(t, pcommon.NewResource(), ms.Resource())
	ms.orig.Resource = *internal.GenTestResource()
	assert.Equal(t, pcommon.Resource(internal.GenTestResourceWrapper()), ms.Resource())
}

func TestResourceMetrics_ScopeMetrics(t *testing.T) {
	ms := NewResourceMetrics()
	assert.Equal(t, NewScopeMetricsSlice(), ms.ScopeMetrics())
	ms.orig.ScopeMetrics = internal.GenTestScopeMetricsPtrSlice()
	assert.Equal(t, generateTestScopeMetricsSlice(), ms.ScopeMetrics())
}

func TestResourceMetrics_SchemaUrl(t *testing.T) {
	ms := NewResourceMetrics()
	assert.Empty(t, ms.SchemaUrl())
	ms.SetSchemaUrl("test_schemaurl")
	assert.Equal(t, "test_schemaurl", ms.SchemaUrl())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newResourceMetrics(internal.NewResourceMetrics(), sharedState).SetSchemaUrl("test_schemaurl") })
}

func generateTestResourceMetrics() ResourceMetrics {
	return newResourceMetrics(internal.GenTestResourceMetrics(), internal.NewState())
}
