// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package bigquery provides access to the BigQuery API.
//
// This package is DEPRECATED. Use package cloud.google.com/go/bigquery instead.
//
// For product documentation, see: https://cloud.google.com/bigquery/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/bigquery/v2"
//	...
//	ctx := context.Background()
//	bigqueryService, err := bigquery.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	bigqueryService, err := bigquery.NewService(ctx, option.WithScopes(bigquery.DevstorageReadWriteScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	bigqueryService, err := bigquery.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	bigqueryService, err := bigquery.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package bigquery // import "google.golang.org/api/bigquery/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "bigquery:v2"
const apiName = "bigquery"
const apiVersion = "v2"
const basePath = "https://bigquery.googleapis.com/bigquery/v2/"
const basePathTemplate = "https://bigquery.UNIVERSE_DOMAIN/bigquery/v2/"
const mtlsBasePath = "https://bigquery.mtls.googleapis.com/bigquery/v2/"

// OAuth2 scopes used by this API.
const (
	// View and manage your data in Google BigQuery and see the email address for
	// your Google Account
	BigqueryScope = "https://www.googleapis.com/auth/bigquery"

	// Insert data into Google BigQuery
	BigqueryInsertdataScope = "https://www.googleapis.com/auth/bigquery.insertdata"

	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View your data across Google Cloud services and see the email address of
	// your Google Account
	CloudPlatformReadOnlyScope = "https://www.googleapis.com/auth/cloud-platform.read-only"

	// Manage your data and permissions in Cloud Storage and see the email address
	// for your Google Account
	DevstorageFullControlScope = "https://www.googleapis.com/auth/devstorage.full_control"

	// View your data in Google Cloud Storage
	DevstorageReadOnlyScope = "https://www.googleapis.com/auth/devstorage.read_only"

	// Manage your data in Cloud Storage and see the email address of your Google
	// Account
	DevstorageReadWriteScope = "https://www.googleapis.com/auth/devstorage.read_write"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/bigquery",
		"https://www.googleapis.com/auth/bigquery.insertdata",
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/cloud-platform.read-only",
		"https://www.googleapis.com/auth/devstorage.full_control",
		"https://www.googleapis.com/auth/devstorage.read_only",
		"https://www.googleapis.com/auth/devstorage.read_write",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Datasets = NewDatasetsService(s)
	s.Jobs = NewJobsService(s)
	s.Models = NewModelsService(s)
	s.Projects = NewProjectsService(s)
	s.Routines = NewRoutinesService(s)
	s.RowAccessPolicies = NewRowAccessPoliciesService(s)
	s.Tabledata = NewTabledataService(s)
	s.Tables = NewTablesService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Datasets *DatasetsService

	Jobs *JobsService

	Models *ModelsService

	Projects *ProjectsService

	Routines *RoutinesService

	RowAccessPolicies *RowAccessPoliciesService

	Tabledata *TabledataService

	Tables *TablesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewDatasetsService(s *Service) *DatasetsService {
	rs := &DatasetsService{s: s}
	return rs
}

type DatasetsService struct {
	s *Service
}

func NewJobsService(s *Service) *JobsService {
	rs := &JobsService{s: s}
	return rs
}

type JobsService struct {
	s *Service
}

func NewModelsService(s *Service) *ModelsService {
	rs := &ModelsService{s: s}
	return rs
}

type ModelsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	return rs
}

type ProjectsService struct {
	s *Service
}

func NewRoutinesService(s *Service) *RoutinesService {
	rs := &RoutinesService{s: s}
	return rs
}

type RoutinesService struct {
	s *Service
}

func NewRowAccessPoliciesService(s *Service) *RowAccessPoliciesService {
	rs := &RowAccessPoliciesService{s: s}
	return rs
}

type RowAccessPoliciesService struct {
	s *Service
}

func NewTabledataService(s *Service) *TabledataService {
	rs := &TabledataService{s: s}
	return rs
}

type TabledataService struct {
	s *Service
}

func NewTablesService(s *Service) *TablesService {
	rs := &TablesService{s: s}
	return rs
}

type TablesService struct {
	s *Service
}

// AggregateClassificationMetrics: Aggregate metrics for
// classification/classifier models. For multi-class models, the metrics are
// either macro-averaged or micro-averaged. When macro-averaged, the metrics
// are calculated for each label and then an unweighted average is taken of
// those values. When micro-averaged, the metric is calculated globally by
// counting the total number of correctly predicted rows.
type AggregateClassificationMetrics struct {
	// Accuracy: Accuracy is the fraction of predictions given the correct label.
	// For multiclass this is a micro-averaged metric.
	Accuracy float64 `json:"accuracy,omitempty"`
	// F1Score: The F1 score is an average of recall and precision. For multiclass
	// this is a macro-averaged metric.
	F1Score float64 `json:"f1Score,omitempty"`
	// LogLoss: Logarithmic Loss. For multiclass this is a macro-averaged metric.
	LogLoss float64 `json:"logLoss,omitempty"`
	// Precision: Precision is the fraction of actual positive predictions that had
	// positive actual labels. For multiclass this is a macro-averaged metric
	// treating each class as a binary classifier.
	Precision float64 `json:"precision,omitempty"`
	// Recall: Recall is the fraction of actual positive labels that were given a
	// positive prediction. For multiclass this is a macro-averaged metric.
	Recall float64 `json:"recall,omitempty"`
	// RocAuc: Area Under a ROC Curve. For multiclass this is a macro-averaged
	// metric.
	RocAuc float64 `json:"rocAuc,omitempty"`
	// Threshold: Threshold at which the metrics are computed. For binary
	// classification models this is the positive class threshold. For multi-class
	// classification models this is the confidence threshold.
	Threshold float64 `json:"threshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Accuracy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accuracy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregateClassificationMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod AggregateClassificationMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *AggregateClassificationMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod AggregateClassificationMetrics
	var s1 struct {
		Accuracy  gensupport.JSONFloat64 `json:"accuracy"`
		F1Score   gensupport.JSONFloat64 `json:"f1Score"`
		LogLoss   gensupport.JSONFloat64 `json:"logLoss"`
		Precision gensupport.JSONFloat64 `json:"precision"`
		Recall    gensupport.JSONFloat64 `json:"recall"`
		RocAuc    gensupport.JSONFloat64 `json:"rocAuc"`
		Threshold gensupport.JSONFloat64 `json:"threshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Accuracy = float64(s1.Accuracy)
	s.F1Score = float64(s1.F1Score)
	s.LogLoss = float64(s1.LogLoss)
	s.Precision = float64(s1.Precision)
	s.Recall = float64(s1.Recall)
	s.RocAuc = float64(s1.RocAuc)
	s.Threshold = float64(s1.Threshold)
	return nil
}

// AggregationThresholdPolicy: Represents privacy policy associated with
// "aggregation threshold" method.
type AggregationThresholdPolicy struct {
	// PrivacyUnitColumns: Optional. The privacy unit column(s) associated with
	// this policy. For now, only one column per data source object (table, view)
	// is allowed as a privacy unit column. Representing as a repeated field in
	// metadata for extensibility to multiple columns in future. Duplicates and
	// Repeated struct fields are not allowed. For nested fields, use dot notation
	// ("outer.inner")
	PrivacyUnitColumns []string `json:"privacyUnitColumns,omitempty"`
	// Threshold: Optional. The threshold for the "aggregation threshold" policy.
	Threshold int64 `json:"threshold,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "PrivacyUnitColumns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrivacyUnitColumns") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AggregationThresholdPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod AggregationThresholdPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Argument: Input/output argument of a function or a stored procedure.
type Argument struct {
	// ArgumentKind: Optional. Defaults to FIXED_TYPE.
	//
	// Possible values:
	//   "ARGUMENT_KIND_UNSPECIFIED" - Default value.
	//   "FIXED_TYPE" - The argument is a variable with fully specified type, which
	// can be a struct or an array, but not a table.
	//   "ANY_TYPE" - The argument is any type, including struct or array, but not
	// a table.
	ArgumentKind string `json:"argumentKind,omitempty"`
	// DataType: Set if argument_kind == FIXED_TYPE.
	DataType *StandardSqlDataType `json:"dataType,omitempty"`
	// IsAggregate: Optional. Whether the argument is an aggregate function
	// parameter. Must be Unset for routine types other than AGGREGATE_FUNCTION.
	// For AGGREGATE_FUNCTION, if set to false, it is equivalent to adding "NOT
	// AGGREGATE" clause in DDL; Otherwise, it is equivalent to omitting "NOT
	// AGGREGATE" clause in DDL.
	IsAggregate bool `json:"isAggregate,omitempty"`
	// Mode: Optional. Specifies whether the argument is input or output. Can be
	// set for procedures only.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Default value.
	//   "IN" - The argument is input-only.
	//   "OUT" - The argument is output-only.
	//   "INOUT" - The argument is both an input and an output.
	Mode string `json:"mode,omitempty"`
	// Name: Optional. The name of this argument. Can be absent for function return
	// argument.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArgumentKind") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArgumentKind") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Argument) MarshalJSON() ([]byte, error) {
	type NoMethod Argument
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ArimaCoefficients: Arima coefficients.
type ArimaCoefficients struct {
	// AutoRegressiveCoefficients: Auto-regressive coefficients, an array of
	// double.
	AutoRegressiveCoefficients []float64 `json:"autoRegressiveCoefficients,omitempty"`
	// InterceptCoefficient: Intercept coefficient, just a double not an array.
	InterceptCoefficient float64 `json:"interceptCoefficient,omitempty"`
	// MovingAverageCoefficients: Moving-average coefficients, an array of double.
	MovingAverageCoefficients []float64 `json:"movingAverageCoefficients,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoRegressiveCoefficients")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoRegressiveCoefficients") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ArimaCoefficients) MarshalJSON() ([]byte, error) {
	type NoMethod ArimaCoefficients
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ArimaCoefficients) UnmarshalJSON(data []byte) error {
	type NoMethod ArimaCoefficients
	var s1 struct {
		AutoRegressiveCoefficients []gensupport.JSONFloat64 `json:"autoRegressiveCoefficients"`
		InterceptCoefficient       gensupport.JSONFloat64   `json:"interceptCoefficient"`
		MovingAverageCoefficients  []gensupport.JSONFloat64 `json:"movingAverageCoefficients"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AutoRegressiveCoefficients = make([]float64, len(s1.AutoRegressiveCoefficients))
	for i := range s1.AutoRegressiveCoefficients {
		s.AutoRegressiveCoefficients[i] = float64(s1.AutoRegressiveCoefficients[i])
	}
	s.InterceptCoefficient = float64(s1.InterceptCoefficient)
	s.MovingAverageCoefficients = make([]float64, len(s1.MovingAverageCoefficients))
	for i := range s1.MovingAverageCoefficients {
		s.MovingAverageCoefficients[i] = float64(s1.MovingAverageCoefficients[i])
	}
	return nil
}

// ArimaFittingMetrics: ARIMA model fitting metrics.
type ArimaFittingMetrics struct {
	// Aic: AIC.
	Aic float64 `json:"aic,omitempty"`
	// LogLikelihood: Log-likelihood.
	LogLikelihood float64 `json:"logLikelihood,omitempty"`
	// Variance: Variance.
	Variance float64 `json:"variance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Aic") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Aic") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ArimaFittingMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ArimaFittingMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ArimaFittingMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod ArimaFittingMetrics
	var s1 struct {
		Aic           gensupport.JSONFloat64 `json:"aic"`
		LogLikelihood gensupport.JSONFloat64 `json:"logLikelihood"`
		Variance      gensupport.JSONFloat64 `json:"variance"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Aic = float64(s1.Aic)
	s.LogLikelihood = float64(s1.LogLikelihood)
	s.Variance = float64(s1.Variance)
	return nil
}

// ArimaForecastingMetrics: Model evaluation metrics for ARIMA forecasting
// models.
type ArimaForecastingMetrics struct {
	// ArimaFittingMetrics: Arima model fitting metrics.
	ArimaFittingMetrics []*ArimaFittingMetrics `json:"arimaFittingMetrics,omitempty"`
	// ArimaSingleModelForecastingMetrics: Repeated as there can be many metric
	// sets (one for each model) in auto-arima and the large-scale case.
	ArimaSingleModelForecastingMetrics []*ArimaSingleModelForecastingMetrics `json:"arimaSingleModelForecastingMetrics,omitempty"`
	// HasDrift: Whether Arima model fitted with drift or not. It is always false
	// when d is not 1.
	HasDrift []bool `json:"hasDrift,omitempty"`
	// NonSeasonalOrder: Non-seasonal order.
	NonSeasonalOrder []*ArimaOrder `json:"nonSeasonalOrder,omitempty"`
	// SeasonalPeriods: Seasonal periods. Repeated because multiple periods are
	// supported for one time series.
	//
	// Possible values:
	//   "SEASONAL_PERIOD_TYPE_UNSPECIFIED" - Unspecified seasonal period.
	//   "NO_SEASONALITY" - No seasonality
	//   "DAILY" - Daily period, 24 hours.
	//   "WEEKLY" - Weekly period, 7 days.
	//   "MONTHLY" - Monthly period, 30 days or irregular.
	//   "QUARTERLY" - Quarterly period, 90 days or irregular.
	//   "YEARLY" - Yearly period, 365 days or irregular.
	SeasonalPeriods []string `json:"seasonalPeriods,omitempty"`
	// TimeSeriesId: Id to differentiate different time series for the large-scale
	// case.
	TimeSeriesId []string `json:"timeSeriesId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArimaFittingMetrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArimaFittingMetrics") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ArimaForecastingMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ArimaForecastingMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ArimaModelInfo: Arima model information.
type ArimaModelInfo struct {
	// ArimaCoefficients: Arima coefficients.
	ArimaCoefficients *ArimaCoefficients `json:"arimaCoefficients,omitempty"`
	// ArimaFittingMetrics: Arima fitting metrics.
	ArimaFittingMetrics *ArimaFittingMetrics `json:"arimaFittingMetrics,omitempty"`
	// HasDrift: Whether Arima model fitted with drift or not. It is always false
	// when d is not 1.
	HasDrift bool `json:"hasDrift,omitempty"`
	// HasHolidayEffect: If true, holiday_effect is a part of time series
	// decomposition result.
	HasHolidayEffect bool `json:"hasHolidayEffect,omitempty"`
	// HasSpikesAndDips: If true, spikes_and_dips is a part of time series
	// decomposition result.
	HasSpikesAndDips bool `json:"hasSpikesAndDips,omitempty"`
	// HasStepChanges: If true, step_changes is a part of time series decomposition
	// result.
	HasStepChanges bool `json:"hasStepChanges,omitempty"`
	// NonSeasonalOrder: Non-seasonal order.
	NonSeasonalOrder *ArimaOrder `json:"nonSeasonalOrder,omitempty"`
	// SeasonalPeriods: Seasonal periods. Repeated because multiple periods are
	// supported for one time series.
	//
	// Possible values:
	//   "SEASONAL_PERIOD_TYPE_UNSPECIFIED" - Unspecified seasonal period.
	//   "NO_SEASONALITY" - No seasonality
	//   "DAILY" - Daily period, 24 hours.
	//   "WEEKLY" - Weekly period, 7 days.
	//   "MONTHLY" - Monthly period, 30 days or irregular.
	//   "QUARTERLY" - Quarterly period, 90 days or irregular.
	//   "YEARLY" - Yearly period, 365 days or irregular.
	SeasonalPeriods []string `json:"seasonalPeriods,omitempty"`
	// TimeSeriesId: The time_series_id value for this time series. It will be one
	// of the unique values from the time_series_id_column specified during ARIMA
	// model training. Only present when time_series_id_column training option was
	// used.
	TimeSeriesId string `json:"timeSeriesId,omitempty"`
	// TimeSeriesIds: The tuple of time_series_ids identifying this time series. It
	// will be one of the unique tuples of values present in the
	// time_series_id_columns specified during ARIMA model training. Only present
	// when time_series_id_columns training option was used and the order of values
	// here are same as the order of time_series_id_columns.
	TimeSeriesIds []string `json:"timeSeriesIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArimaCoefficients") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArimaCoefficients") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ArimaModelInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ArimaModelInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ArimaOrder: Arima order, can be used for both non-seasonal and seasonal
// parts.
type ArimaOrder struct {
	// D: Order of the differencing part.
	D int64 `json:"d,omitempty,string"`
	// P: Order of the autoregressive part.
	P int64 `json:"p,omitempty,string"`
	// Q: Order of the moving-average part.
	Q int64 `json:"q,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "D") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "D") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ArimaOrder) MarshalJSON() ([]byte, error) {
	type NoMethod ArimaOrder
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ArimaResult: (Auto-)arima fitting result. Wrap everything in ArimaResult for
// easier refactoring if we want to use model-specific iteration results.
type ArimaResult struct {
	// ArimaModelInfo: This message is repeated because there are multiple arima
	// models fitted in auto-arima. For non-auto-arima model, its size is one.
	ArimaModelInfo []*ArimaModelInfo `json:"arimaModelInfo,omitempty"`
	// SeasonalPeriods: Seasonal periods. Repeated because multiple periods are
	// supported for one time series.
	//
	// Possible values:
	//   "SEASONAL_PERIOD_TYPE_UNSPECIFIED" - Unspecified seasonal period.
	//   "NO_SEASONALITY" - No seasonality
	//   "DAILY" - Daily period, 24 hours.
	//   "WEEKLY" - Weekly period, 7 days.
	//   "MONTHLY" - Monthly period, 30 days or irregular.
	//   "QUARTERLY" - Quarterly period, 90 days or irregular.
	//   "YEARLY" - Yearly period, 365 days or irregular.
	SeasonalPeriods []string `json:"seasonalPeriods,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArimaModelInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArimaModelInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ArimaResult) MarshalJSON() ([]byte, error) {
	type NoMethod ArimaResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ArimaSingleModelForecastingMetrics: Model evaluation metrics for a single
// ARIMA forecasting model.
type ArimaSingleModelForecastingMetrics struct {
	// ArimaFittingMetrics: Arima fitting metrics.
	ArimaFittingMetrics *ArimaFittingMetrics `json:"arimaFittingMetrics,omitempty"`
	// HasDrift: Is arima model fitted with drift or not. It is always false when d
	// is not 1.
	HasDrift bool `json:"hasDrift,omitempty"`
	// HasHolidayEffect: If true, holiday_effect is a part of time series
	// decomposition result.
	HasHolidayEffect bool `json:"hasHolidayEffect,omitempty"`
	// HasSpikesAndDips: If true, spikes_and_dips is a part of time series
	// decomposition result.
	HasSpikesAndDips bool `json:"hasSpikesAndDips,omitempty"`
	// HasStepChanges: If true, step_changes is a part of time series decomposition
	// result.
	HasStepChanges bool `json:"hasStepChanges,omitempty"`
	// NonSeasonalOrder: Non-seasonal order.
	NonSeasonalOrder *ArimaOrder `json:"nonSeasonalOrder,omitempty"`
	// SeasonalPeriods: Seasonal periods. Repeated because multiple periods are
	// supported for one time series.
	//
	// Possible values:
	//   "SEASONAL_PERIOD_TYPE_UNSPECIFIED" - Unspecified seasonal period.
	//   "NO_SEASONALITY" - No seasonality
	//   "DAILY" - Daily period, 24 hours.
	//   "WEEKLY" - Weekly period, 7 days.
	//   "MONTHLY" - Monthly period, 30 days or irregular.
	//   "QUARTERLY" - Quarterly period, 90 days or irregular.
	//   "YEARLY" - Yearly period, 365 days or irregular.
	SeasonalPeriods []string `json:"seasonalPeriods,omitempty"`
	// TimeSeriesId: The time_series_id value for this time series. It will be one
	// of the unique values from the time_series_id_column specified during ARIMA
	// model training. Only present when time_series_id_column training option was
	// used.
	TimeSeriesId string `json:"timeSeriesId,omitempty"`
	// TimeSeriesIds: The tuple of time_series_ids identifying this time series. It
	// will be one of the unique tuples of values present in the
	// time_series_id_columns specified during ARIMA model training. Only present
	// when time_series_id_columns training option was used and the order of values
	// here are same as the order of time_series_id_columns.
	TimeSeriesIds []string `json:"timeSeriesIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArimaFittingMetrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArimaFittingMetrics") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ArimaSingleModelForecastingMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ArimaSingleModelForecastingMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AvroOptions: Options for external data sources.
type AvroOptions struct {
	// UseAvroLogicalTypes: Optional. If sourceFormat is set to "AVRO", indicates
	// whether to interpret logical types as the corresponding BigQuery data type
	// (for example, TIMESTAMP), instead of using the raw type (for example,
	// INTEGER).
	UseAvroLogicalTypes bool `json:"useAvroLogicalTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UseAvroLogicalTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UseAvroLogicalTypes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AvroOptions) MarshalJSON() ([]byte, error) {
	type NoMethod AvroOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchDeleteRowAccessPoliciesRequest: Request message for the
// BatchDeleteRowAccessPoliciesRequest method.
type BatchDeleteRowAccessPoliciesRequest struct {
	// Force: If set to true, it deletes the row access policy even if it's the
	// last row access policy on the table and the deletion will widen the access
	// rather narrowing it.
	Force bool `json:"force,omitempty"`
	// PolicyIds: Required. Policy IDs of the row access policies.
	PolicyIds []string `json:"policyIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Force") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Force") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchDeleteRowAccessPoliciesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod BatchDeleteRowAccessPoliciesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BiEngineReason: Reason why BI Engine didn't accelerate the query (or
// sub-query).
type BiEngineReason struct {
	// Code: Output only. High-level BI Engine reason for partial or disabled
	// acceleration
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - BiEngineReason not specified.
	//   "NO_RESERVATION" - No reservation available for BI Engine acceleration.
	//   "INSUFFICIENT_RESERVATION" - Not enough memory available for BI Engine
	// acceleration.
	//   "UNSUPPORTED_SQL_TEXT" - This particular SQL text is not supported for
	// acceleration by BI Engine.
	//   "INPUT_TOO_LARGE" - Input too large for acceleration by BI Engine.
	//   "OTHER_REASON" - Catch-all code for all other cases for partial or
	// disabled acceleration.
	//   "TABLE_EXCLUDED" - One or more tables were not eligible for BI Engine
	// acceleration.
	Code string `json:"code,omitempty"`
	// Message: Output only. Free form human-readable reason for partial or
	// disabled acceleration.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BiEngineReason) MarshalJSON() ([]byte, error) {
	type NoMethod BiEngineReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BiEngineStatistics: Statistics for a BI Engine specific query. Populated as
// part of JobStatistics2
type BiEngineStatistics struct {
	// AccelerationMode: Output only. Specifies which mode of BI Engine
	// acceleration was performed (if any).
	//
	// Possible values:
	//   "BI_ENGINE_ACCELERATION_MODE_UNSPECIFIED" - BiEngineMode type not
	// specified.
	//   "BI_ENGINE_DISABLED" - BI Engine acceleration was attempted but disabled.
	// bi_engine_reasons specifies a more detailed reason.
	//   "PARTIAL_INPUT" - Some inputs were accelerated using BI Engine. See
	// bi_engine_reasons for why parts of the query were not accelerated.
	//   "FULL_INPUT" - All of the query inputs were accelerated using BI Engine.
	//   "FULL_QUERY" - All of the query was accelerated using BI Engine.
	AccelerationMode string `json:"accelerationMode,omitempty"`
	// BiEngineMode: Output only. Specifies which mode of BI Engine acceleration
	// was performed (if any).
	//
	// Possible values:
	//   "ACCELERATION_MODE_UNSPECIFIED" - BiEngineMode type not specified.
	//   "DISABLED" - BI Engine disabled the acceleration. bi_engine_reasons
	// specifies a more detailed reason.
	//   "PARTIAL" - Part of the query was accelerated using BI Engine. See
	// bi_engine_reasons for why parts of the query were not accelerated.
	//   "FULL" - All of the query was accelerated using BI Engine.
	BiEngineMode string `json:"biEngineMode,omitempty"`
	// BiEngineReasons: In case of DISABLED or PARTIAL bi_engine_mode, these
	// contain the explanatory reasons as to why BI Engine could not accelerate. In
	// case the full query was accelerated, this field is not populated.
	BiEngineReasons []*BiEngineReason `json:"biEngineReasons,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccelerationMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccelerationMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BiEngineStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod BiEngineStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BigLakeConfiguration: Configuration for BigQuery tables for Apache Iceberg
// (formerly BigLake managed tables.)
type BigLakeConfiguration struct {
	// ConnectionId: Optional. The connection specifying the credentials to be used
	// to read and write to external storage, such as Cloud Storage. The
	// connection_id can have the form `{project}.{location}.{connection_id}` or
	// `projects/{project}/locations/{location}/connections/{connection_id}".
	ConnectionId string `json:"connectionId,omitempty"`
	// FileFormat: Optional. The file format the table data is stored in.
	//
	// Possible values:
	//   "FILE_FORMAT_UNSPECIFIED" - Default Value.
	//   "PARQUET" - Apache Parquet format.
	FileFormat string `json:"fileFormat,omitempty"`
	// StorageUri: Optional. The fully qualified location prefix of the external
	// folder where table data is stored. The '*' wildcard character is not
	// allowed. The URI should be in the format `gs://bucket/path_to_table/`
	StorageUri string `json:"storageUri,omitempty"`
	// TableFormat: Optional. The table format the metadata only snapshots are
	// stored in.
	//
	// Possible values:
	//   "TABLE_FORMAT_UNSPECIFIED" - Default Value.
	//   "ICEBERG" - Apache Iceberg format.
	TableFormat string `json:"tableFormat,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BigLakeConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod BigLakeConfiguration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BigQueryModelTraining struct {
	// CurrentIteration: Deprecated.
	CurrentIteration int64 `json:"currentIteration,omitempty"`
	// ExpectedTotalIterations: Deprecated.
	ExpectedTotalIterations int64 `json:"expectedTotalIterations,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CurrentIteration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrentIteration") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BigQueryModelTraining) MarshalJSON() ([]byte, error) {
	type NoMethod BigQueryModelTraining
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BigtableColumn: Information related to a Bigtable column.
type BigtableColumn struct {
	// Encoding: Optional. The encoding of the values when the type is not STRING.
	// Acceptable encoding values are: TEXT - indicates values are alphanumeric
	// text strings. BINARY - indicates values are encoded using HBase
	// Bytes.toBytes family of functions. 'encoding' can also be set at the column
	// family level. However, the setting at this level takes precedence if
	// 'encoding' is set at both levels.
	Encoding string `json:"encoding,omitempty"`
	// FieldName: Optional. If the qualifier is not a valid BigQuery field
	// identifier i.e. does not match a-zA-Z*, a valid identifier must be provided
	// as the column field name and is used as field name in queries.
	FieldName string `json:"fieldName,omitempty"`
	// OnlyReadLatest: Optional. If this is set, only the latest version of value
	// in this column are exposed. 'onlyReadLatest' can also be set at the column
	// family level. However, the setting at this level takes precedence if
	// 'onlyReadLatest' is set at both levels.
	OnlyReadLatest bool `json:"onlyReadLatest,omitempty"`
	// QualifierEncoded: [Required] Qualifier of the column. Columns in the parent
	// column family that has this exact qualifier are exposed as `.` field. If the
	// qualifier is valid UTF-8 string, it can be specified in the qualifier_string
	// field. Otherwise, a base-64 encoded value must be set to qualifier_encoded.
	// The column field name is the same as the column qualifier. However, if the
	// qualifier is not a valid BigQuery field identifier i.e. does not match
	// a-zA-Z*, a valid identifier must be provided as field_name.
	QualifierEncoded string `json:"qualifierEncoded,omitempty"`
	// QualifierString: Qualifier string.
	QualifierString string `json:"qualifierString,omitempty"`
	// Type: Optional. The type to convert the value in cells of this column. The
	// values are expected to be encoded using HBase Bytes.toBytes function when
	// using the BINARY encoding value. Following BigQuery types are allowed
	// (case-sensitive): * BYTES * STRING * INTEGER * FLOAT * BOOLEAN * JSON
	// Default type is BYTES. 'type' can also be set at the column family level.
	// However, the setting at this level takes precedence if 'type' is set at both
	// levels.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Encoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Encoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BigtableColumn) MarshalJSON() ([]byte, error) {
	type NoMethod BigtableColumn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BigtableColumnFamily: Information related to a Bigtable column family.
type BigtableColumnFamily struct {
	// Columns: Optional. Lists of columns that should be exposed as individual
	// fields as opposed to a list of (column name, value) pairs. All columns whose
	// qualifier matches a qualifier in this list can be accessed as `.`. Other
	// columns can be accessed as a list through the `.Column` field.
	Columns []*BigtableColumn `json:"columns,omitempty"`
	// Encoding: Optional. The encoding of the values when the type is not STRING.
	// Acceptable encoding values are: TEXT - indicates values are alphanumeric
	// text strings. BINARY - indicates values are encoded using HBase
	// Bytes.toBytes family of functions. This can be overridden for a specific
	// column by listing that column in 'columns' and specifying an encoding for
	// it.
	Encoding string `json:"encoding,omitempty"`
	// FamilyId: Identifier of the column family.
	FamilyId string `json:"familyId,omitempty"`
	// OnlyReadLatest: Optional. If this is set only the latest version of value
	// are exposed for all columns in this column family. This can be overridden
	// for a specific column by listing that column in 'columns' and specifying a
	// different setting for that column.
	OnlyReadLatest bool `json:"onlyReadLatest,omitempty"`
	// Type: Optional. The type to convert the value in cells of this column
	// family. The values are expected to be encoded using HBase Bytes.toBytes
	// function when using the BINARY encoding value. Following BigQuery types are
	// allowed (case-sensitive): * BYTES * STRING * INTEGER * FLOAT * BOOLEAN *
	// JSON Default type is BYTES. This can be overridden for a specific column by
	// listing that column in 'columns' and specifying a type for it.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Columns") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Columns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BigtableColumnFamily) MarshalJSON() ([]byte, error) {
	type NoMethod BigtableColumnFamily
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BigtableOptions: Options specific to Google Cloud Bigtable data sources.
type BigtableOptions struct {
	// ColumnFamilies: Optional. List of column families to expose in the table
	// schema along with their types. This list restricts the column families that
	// can be referenced in queries and specifies their value types. You can use
	// this list to do type conversions - see the 'type' field for more details. If
	// you leave this list empty, all column families are present in the table
	// schema and their values are read as BYTES. During a query only the column
	// families referenced in that query are read from Bigtable.
	ColumnFamilies []*BigtableColumnFamily `json:"columnFamilies,omitempty"`
	// IgnoreUnspecifiedColumnFamilies: Optional. If field is true, then the column
	// families that are not specified in columnFamilies list are not exposed in
	// the table schema. Otherwise, they are read with BYTES type values. The
	// default value is false.
	IgnoreUnspecifiedColumnFamilies bool `json:"ignoreUnspecifiedColumnFamilies,omitempty"`
	// OutputColumnFamiliesAsJson: Optional. If field is true, then each column
	// family will be read as a single JSON column. Otherwise they are read as a
	// repeated cell structure containing timestamp/value tuples. The default value
	// is false.
	OutputColumnFamiliesAsJson bool `json:"outputColumnFamiliesAsJson,omitempty"`
	// ReadRowkeyAsString: Optional. If field is true, then the rowkey column
	// families will be read and converted to string. Otherwise they are read with
	// BYTES type values and users need to manually cast them with CAST if
	// necessary. The default value is false.
	ReadRowkeyAsString bool `json:"readRowkeyAsString,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ColumnFamilies") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ColumnFamilies") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BigtableOptions) MarshalJSON() ([]byte, error) {
	type NoMethod BigtableOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BinaryClassificationMetrics: Evaluation metrics for binary
// classification/classifier models.
type BinaryClassificationMetrics struct {
	// AggregateClassificationMetrics: Aggregate classification metrics.
	AggregateClassificationMetrics *AggregateClassificationMetrics `json:"aggregateClassificationMetrics,omitempty"`
	// BinaryConfusionMatrixList: Binary confusion matrix at multiple thresholds.
	BinaryConfusionMatrixList []*BinaryConfusionMatrix `json:"binaryConfusionMatrixList,omitempty"`
	// NegativeLabel: Label representing the negative class.
	NegativeLabel string `json:"negativeLabel,omitempty"`
	// PositiveLabel: Label representing the positive class.
	PositiveLabel string `json:"positiveLabel,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AggregateClassificationMetrics") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregateClassificationMetrics")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BinaryClassificationMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod BinaryClassificationMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BinaryConfusionMatrix: Confusion matrix for binary classification models.
type BinaryConfusionMatrix struct {
	// Accuracy: The fraction of predictions given the correct label.
	Accuracy float64 `json:"accuracy,omitempty"`
	// F1Score: The equally weighted average of recall and precision.
	F1Score float64 `json:"f1Score,omitempty"`
	// FalseNegatives: Number of false samples predicted as false.
	FalseNegatives int64 `json:"falseNegatives,omitempty,string"`
	// FalsePositives: Number of false samples predicted as true.
	FalsePositives int64 `json:"falsePositives,omitempty,string"`
	// PositiveClassThreshold: Threshold value used when computing each of the
	// following metric.
	PositiveClassThreshold float64 `json:"positiveClassThreshold,omitempty"`
	// Precision: The fraction of actual positive predictions that had positive
	// actual labels.
	Precision float64 `json:"precision,omitempty"`
	// Recall: The fraction of actual positive labels that were given a positive
	// prediction.
	Recall float64 `json:"recall,omitempty"`
	// TrueNegatives: Number of true samples predicted as false.
	TrueNegatives int64 `json:"trueNegatives,omitempty,string"`
	// TruePositives: Number of true samples predicted as true.
	TruePositives int64 `json:"truePositives,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Accuracy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accuracy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BinaryConfusionMatrix) MarshalJSON() ([]byte, error) {
	type NoMethod BinaryConfusionMatrix
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *BinaryConfusionMatrix) UnmarshalJSON(data []byte) error {
	type NoMethod BinaryConfusionMatrix
	var s1 struct {
		Accuracy               gensupport.JSONFloat64 `json:"accuracy"`
		F1Score                gensupport.JSONFloat64 `json:"f1Score"`
		PositiveClassThreshold gensupport.JSONFloat64 `json:"positiveClassThreshold"`
		Precision              gensupport.JSONFloat64 `json:"precision"`
		Recall                 gensupport.JSONFloat64 `json:"recall"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Accuracy = float64(s1.Accuracy)
	s.F1Score = float64(s1.F1Score)
	s.PositiveClassThreshold = float64(s1.PositiveClassThreshold)
	s.Precision = float64(s1.Precision)
	s.Recall = float64(s1.Recall)
	return nil
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BqmlIterationResult struct {
	// DurationMs: Deprecated.
	DurationMs int64 `json:"durationMs,omitempty,string"`
	// EvalLoss: Deprecated.
	EvalLoss float64 `json:"evalLoss,omitempty"`
	// Index: Deprecated.
	Index int64 `json:"index,omitempty"`
	// LearnRate: Deprecated.
	LearnRate float64 `json:"learnRate,omitempty"`
	// TrainingLoss: Deprecated.
	TrainingLoss float64 `json:"trainingLoss,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DurationMs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DurationMs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BqmlIterationResult) MarshalJSON() ([]byte, error) {
	type NoMethod BqmlIterationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *BqmlIterationResult) UnmarshalJSON(data []byte) error {
	type NoMethod BqmlIterationResult
	var s1 struct {
		EvalLoss     gensupport.JSONFloat64 `json:"evalLoss"`
		LearnRate    gensupport.JSONFloat64 `json:"learnRate"`
		TrainingLoss gensupport.JSONFloat64 `json:"trainingLoss"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.EvalLoss = float64(s1.EvalLoss)
	s.LearnRate = float64(s1.LearnRate)
	s.TrainingLoss = float64(s1.TrainingLoss)
	return nil
}

type BqmlTrainingRun struct {
	// IterationResults: Deprecated.
	IterationResults []*BqmlIterationResult `json:"iterationResults,omitempty"`
	// StartTime: Deprecated.
	StartTime string `json:"startTime,omitempty"`
	// State: Deprecated.
	State string `json:"state,omitempty"`
	// TrainingOptions: Deprecated.
	TrainingOptions *BqmlTrainingRunTrainingOptions `json:"trainingOptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IterationResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IterationResults") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BqmlTrainingRun) MarshalJSON() ([]byte, error) {
	type NoMethod BqmlTrainingRun
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BqmlTrainingRunTrainingOptions: Deprecated.
type BqmlTrainingRunTrainingOptions struct {
	EarlyStop               bool    `json:"earlyStop,omitempty"`
	L1Reg                   float64 `json:"l1Reg,omitempty"`
	L2Reg                   float64 `json:"l2Reg,omitempty"`
	LearnRate               float64 `json:"learnRate,omitempty"`
	LearnRateStrategy       string  `json:"learnRateStrategy,omitempty"`
	LineSearchInitLearnRate float64 `json:"lineSearchInitLearnRate,omitempty"`
	MaxIteration            int64   `json:"maxIteration,omitempty,string"`
	MinRelProgress          float64 `json:"minRelProgress,omitempty"`
	WarmStart               bool    `json:"warmStart,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EarlyStop") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EarlyStop") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BqmlTrainingRunTrainingOptions) MarshalJSON() ([]byte, error) {
	type NoMethod BqmlTrainingRunTrainingOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *BqmlTrainingRunTrainingOptions) UnmarshalJSON(data []byte) error {
	type NoMethod BqmlTrainingRunTrainingOptions
	var s1 struct {
		L1Reg                   gensupport.JSONFloat64 `json:"l1Reg"`
		L2Reg                   gensupport.JSONFloat64 `json:"l2Reg"`
		LearnRate               gensupport.JSONFloat64 `json:"learnRate"`
		LineSearchInitLearnRate gensupport.JSONFloat64 `json:"lineSearchInitLearnRate"`
		MinRelProgress          gensupport.JSONFloat64 `json:"minRelProgress"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.L1Reg = float64(s1.L1Reg)
	s.L2Reg = float64(s1.L2Reg)
	s.LearnRate = float64(s1.LearnRate)
	s.LineSearchInitLearnRate = float64(s1.LineSearchInitLearnRate)
	s.MinRelProgress = float64(s1.MinRelProgress)
	return nil
}

// CategoricalValue: Representative value of a categorical feature.
type CategoricalValue struct {
	// CategoryCounts: Counts of all categories for the categorical feature. If
	// there are more than ten categories, we return top ten (by count) and return
	// one more CategoryCount with category "_OTHER_" and count as aggregate counts
	// of remaining categories.
	CategoryCounts []*CategoryCount `json:"categoryCounts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CategoryCounts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CategoryCounts") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CategoricalValue) MarshalJSON() ([]byte, error) {
	type NoMethod CategoricalValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CategoryCount: Represents the count of a single category within the cluster.
type CategoryCount struct {
	// Category: The name of category.
	Category string `json:"category,omitempty"`
	// Count: The count of training samples matching the category within the
	// cluster.
	Count int64 `json:"count,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CategoryCount) MarshalJSON() ([]byte, error) {
	type NoMethod CategoryCount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloneDefinition: Information about base table and clone time of a table
// clone.
type CloneDefinition struct {
	// BaseTableReference: Required. Reference describing the ID of the table that
	// was cloned.
	BaseTableReference *TableReference `json:"baseTableReference,omitempty"`
	// CloneTime: Required. The time at which the base table was cloned. This value
	// is reported in the JSON response using RFC3339 format.
	CloneTime string `json:"cloneTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseTableReference") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseTableReference") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloneDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod CloneDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Cluster: Message containing the information about one cluster.
type Cluster struct {
	// CentroidId: Centroid id.
	CentroidId int64 `json:"centroidId,omitempty,string"`
	// Count: Count of training data rows that were assigned to this cluster.
	Count int64 `json:"count,omitempty,string"`
	// FeatureValues: Values of highly variant features for this cluster.
	FeatureValues []*FeatureValue `json:"featureValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CentroidId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CentroidId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Cluster) MarshalJSON() ([]byte, error) {
	type NoMethod Cluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterInfo: Information about a single cluster for clustering model.
type ClusterInfo struct {
	// CentroidId: Centroid id.
	CentroidId int64 `json:"centroidId,omitempty,string"`
	// ClusterRadius: Cluster radius, the average distance from centroid to each
	// point assigned to the cluster.
	ClusterRadius float64 `json:"clusterRadius,omitempty"`
	// ClusterSize: Cluster size, the total number of points assigned to the
	// cluster.
	ClusterSize int64 `json:"clusterSize,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CentroidId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CentroidId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ClusterInfo) UnmarshalJSON(data []byte) error {
	type NoMethod ClusterInfo
	var s1 struct {
		ClusterRadius gensupport.JSONFloat64 `json:"clusterRadius"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ClusterRadius = float64(s1.ClusterRadius)
	return nil
}

// Clustering: Configures table clustering.
type Clustering struct {
	// Fields: One or more fields on which data should be clustered. Only
	// top-level, non-repeated, simple-type fields are supported. The ordering of
	// the clustering fields should be prioritized from most to least important for
	// filtering purposes. For additional information, see Introduction to
	// clustered tables
	// (https://cloud.google.com/bigquery/docs/clustered-tables#limitations).
	Fields []string `json:"fields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fields") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Clustering) MarshalJSON() ([]byte, error) {
	type NoMethod Clustering
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusteringMetrics: Evaluation metrics for clustering models.
type ClusteringMetrics struct {
	// Clusters: Information for all clusters.
	Clusters []*Cluster `json:"clusters,omitempty"`
	// DaviesBouldinIndex: Davies-Bouldin index.
	DaviesBouldinIndex float64 `json:"daviesBouldinIndex,omitempty"`
	// MeanSquaredDistance: Mean of squared distances between each sample to its
	// cluster centroid.
	MeanSquaredDistance float64 `json:"meanSquaredDistance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clusters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clusters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusteringMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ClusteringMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ClusteringMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod ClusteringMetrics
	var s1 struct {
		DaviesBouldinIndex  gensupport.JSONFloat64 `json:"daviesBouldinIndex"`
		MeanSquaredDistance gensupport.JSONFloat64 `json:"meanSquaredDistance"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DaviesBouldinIndex = float64(s1.DaviesBouldinIndex)
	s.MeanSquaredDistance = float64(s1.MeanSquaredDistance)
	return nil
}

// ConfusionMatrix: Confusion matrix for multi-class classification models.
type ConfusionMatrix struct {
	// ConfidenceThreshold: Confidence threshold used when computing the entries of
	// the confusion matrix.
	ConfidenceThreshold float64 `json:"confidenceThreshold,omitempty"`
	// Rows: One row per actual label.
	Rows []*Row `json:"rows,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidenceThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidenceThreshold") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfusionMatrix) MarshalJSON() ([]byte, error) {
	type NoMethod ConfusionMatrix
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ConfusionMatrix) UnmarshalJSON(data []byte) error {
	type NoMethod ConfusionMatrix
	var s1 struct {
		ConfidenceThreshold gensupport.JSONFloat64 `json:"confidenceThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ConfidenceThreshold = float64(s1.ConfidenceThreshold)
	return nil
}

// ConnectionProperty: A connection-level property to customize query behavior.
// Under JDBC, these correspond directly to connection properties passed to the
// DriverManager. Under ODBC, these correspond to properties in the connection
// string. Currently supported connection properties: * **dataset_project_id**:
// represents the default project for datasets that are used in the query.
// Setting the system variable `@@dataset_project_id` achieves the same
// behavior. For more information about system variables, see:
// https://cloud.google.com/bigquery/docs/reference/system-variables *
// **time_zone**: represents the default timezone used to run the query. *
// **session_id**: associates the query with a given session. *
// **query_label**: associates the query with a given job label. If set, all
// subsequent queries in a script or session will have this label. For the
// format in which a you can specify a query label, see labels in the
// JobConfiguration resource type:
// https://cloud.google.com/bigquery/docs/reference/rest/v2/Job#jobconfiguration
// * **service_account**: indicates the service account to use to run a
// continuous query. If set, the query job uses the service account to access
// Google Cloud resources. Service account access is bounded by the IAM
// permissions that you have granted to the service account. Additional
// properties are allowed, but ignored. Specifying multiple connection
// properties with the same key returns an error.
type ConnectionProperty struct {
	// Key: The key of the property to set.
	Key string `json:"key,omitempty"`
	// Value: The value of the property to set.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConnectionProperty) MarshalJSON() ([]byte, error) {
	type NoMethod ConnectionProperty
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CsvOptions: Information related to a CSV data source.
type CsvOptions struct {
	// AllowJaggedRows: Optional. Indicates if BigQuery should accept rows that are
	// missing trailing optional columns. If true, BigQuery treats missing trailing
	// columns as null values. If false, records with missing trailing columns are
	// treated as bad records, and if there are too many bad records, an invalid
	// error is returned in the job result. The default value is false.
	AllowJaggedRows bool `json:"allowJaggedRows,omitempty"`
	// AllowQuotedNewlines: Optional. Indicates if BigQuery should allow quoted
	// data sections that contain newline characters in a CSV file. The default
	// value is false.
	AllowQuotedNewlines bool `json:"allowQuotedNewlines,omitempty"`
	// Encoding: Optional. The character encoding of the data. The supported values
	// are UTF-8, ISO-8859-1, UTF-16BE, UTF-16LE, UTF-32BE, and UTF-32LE. The
	// default value is UTF-8. BigQuery decodes the data after the raw, binary data
	// has been split using the values of the quote and fieldDelimiter properties.
	Encoding string `json:"encoding,omitempty"`
	// FieldDelimiter: Optional. The separator character for fields in a CSV file.
	// The separator is interpreted as a single byte. For files encoded in
	// ISO-8859-1, any single character can be used as a separator. For files
	// encoded in UTF-8, characters represented in decimal range 1-127
	// (U+0001-U+007F) can be used without any modification. UTF-8 characters
	// encoded with multiple bytes (i.e. U+0080 and above) will have only the first
	// byte used for separating fields. The remaining bytes will be treated as a
	// part of the field. BigQuery also supports the escape sequence "\t" (U+0009)
	// to specify a tab separator. The default value is comma (",", U+002C).
	FieldDelimiter string `json:"fieldDelimiter,omitempty"`
	// NullMarker: Optional. Specifies a string that represents a null value in a
	// CSV file. For example, if you specify "\N", BigQuery interprets "\N" as a
	// null value when querying a CSV file. The default value is the empty string.
	// If you set this property to a custom value, BigQuery throws an error if an
	// empty string is present for all data types except for STRING and BYTE. For
	// STRING and BYTE columns, BigQuery interprets the empty string as an empty
	// value.
	NullMarker string `json:"nullMarker,omitempty"`
	// NullMarkers: Optional. A list of strings represented as SQL NULL value in a
	// CSV file. null_marker and null_markers can't be set at the same time. If
	// null_marker is set, null_markers has to be not set. If null_markers is set,
	// null_marker has to be not set. If both null_marker and null_markers are set
	// at the same time, a user error would be thrown. Any strings listed in
	// null_markers, including empty string would be interpreted as SQL NULL. This
	// applies to all column types.
	NullMarkers []string `json:"nullMarkers,omitempty"`
	// PreserveAsciiControlCharacters: Optional. Indicates if the embedded ASCII
	// control characters (the first 32 characters in the ASCII-table, from '\x00'
	// to '\x1F') are preserved.
	PreserveAsciiControlCharacters bool `json:"preserveAsciiControlCharacters,omitempty"`
	// Quote: Optional. The value that is used to quote data sections in a CSV
	// file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the
	// first byte of the encoded string to split the data in its raw, binary state.
	// The default value is a double-quote ("). If your data does not contain
	// quoted sections, set the property value to an empty string. If your data
	// contains quoted newline characters, you must also set the
	// allowQuotedNewlines property to true. To include the specific quote
	// character within a quoted value, precede it with an additional matching
	// quote character. For example, if you want to escape the default character '
	// " ', use ' "" '.
	//
	// Default: "
	Quote *string `json:"quote,omitempty"`
	// SkipLeadingRows: Optional. The number of rows at the top of a CSV file that
	// BigQuery will skip when reading the data. The default value is 0. This
	// property is useful if you have header rows in the file that should be
	// skipped. When autodetect is on, the behavior is the following: *
	// skipLeadingRows unspecified - Autodetect tries to detect headers in the
	// first row. If they are not detected, the row is read as data. Otherwise data
	// is read starting from the second row. * skipLeadingRows is 0 - Instructs
	// autodetect that there are no headers and data should be read starting from
	// the first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and
	// tries to detect headers in row N. If headers are not detected, row N is just
	// skipped. Otherwise row N is used to extract column names for the detected
	// schema.
	SkipLeadingRows int64 `json:"skipLeadingRows,omitempty,string"`
	// SourceColumnMatch: Optional. Controls the strategy used to match loaded
	// columns to the schema. If not set, a sensible default is chosen based on how
	// the schema is provided. If autodetect is used, then columns are matched by
	// name. Otherwise, columns are matched by position. This is done to keep the
	// behavior backward-compatible. Acceptable values are: POSITION - matches by
	// position. This assumes that the columns are ordered the same way as the
	// schema. NAME - matches by name. This reads the header row as column names
	// and reorders columns to match the field names in the schema.
	SourceColumnMatch string `json:"sourceColumnMatch,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowJaggedRows") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowJaggedRows") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CsvOptions) MarshalJSON() ([]byte, error) {
	type NoMethod CsvOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataFormatOptions: Options for data format adjustments.
type DataFormatOptions struct {
	// UseInt64Timestamp: Optional. Output timestamp as usec int64. Default is
	// false.
	UseInt64Timestamp bool `json:"useInt64Timestamp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UseInt64Timestamp") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UseInt64Timestamp") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataFormatOptions) MarshalJSON() ([]byte, error) {
	type NoMethod DataFormatOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataMaskingStatistics: Statistics for data-masking.
type DataMaskingStatistics struct {
	// DataMaskingApplied: Whether any accessed data was protected by the data
	// masking.
	DataMaskingApplied bool `json:"dataMaskingApplied,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataMaskingApplied") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataMaskingApplied") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataMaskingStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod DataMaskingStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataPolicyOption: Data policy option proto, it currently supports name only,
// will support precedence later.
type DataPolicyOption struct {
	// Name: Data policy resource name in the form of
	// projects/project_id/locations/location_id/dataPolicies/data_policy_id.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataPolicyOption) MarshalJSON() ([]byte, error) {
	type NoMethod DataPolicyOption
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataSplitResult: Data split result. This contains references to the training
// and evaluation data tables that were used to train the model.
type DataSplitResult struct {
	// EvaluationTable: Table reference of the evaluation data after split.
	EvaluationTable *TableReference `json:"evaluationTable,omitempty"`
	// TestTable: Table reference of the test data after split.
	TestTable *TableReference `json:"testTable,omitempty"`
	// TrainingTable: Table reference of the training data after split.
	TrainingTable *TableReference `json:"trainingTable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvaluationTable") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluationTable") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataSplitResult) MarshalJSON() ([]byte, error) {
	type NoMethod DataSplitResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Dataset: Represents a BigQuery dataset.
type Dataset struct {
	// Access: Optional. An array of objects that define dataset access for one or
	// more entities. You can set this property when inserting or updating a
	// dataset in order to control who is allowed to access the data. If
	// unspecified at dataset creation time, BigQuery adds default dataset access
	// for the following entities: access.specialGroup: projectReaders;
	// access.role: READER; access.specialGroup: projectWriters; access.role:
	// WRITER; access.specialGroup: projectOwners; access.role: OWNER;
	// access.userByEmail: [dataset creator email]; access.role: OWNER; If you
	// patch a dataset, then this field is overwritten by the patched dataset's
	// access field. To add entities, you must supply the entire existing access
	// array in addition to any new entities that you want to add.
	Access []*DatasetAccess `json:"access,omitempty"`
	// CreationTime: Output only. The time when this dataset was created, in
	// milliseconds since the epoch.
	CreationTime int64 `json:"creationTime,omitempty,string"`
	// DatasetReference: Required. A reference that identifies the dataset.
	DatasetReference *DatasetReference `json:"datasetReference,omitempty"`
	// DefaultCollation: Optional. Defines the default collation specification of
	// future tables created in the dataset. If a table is created in this dataset
	// without table-level default collation, then the table inherits the dataset
	// default collation, which is applied to the string fields that do not have
	// explicit collation specified. A change to this field affects only tables
	// created afterwards, and does not alter the existing tables. The following
	// values are supported: * 'und:ci': undetermined locale, case insensitive. *
	// '': empty string. Default to case-sensitive behavior.
	DefaultCollation string `json:"defaultCollation,omitempty"`
	// DefaultEncryptionConfiguration: The default encryption key for all tables in
	// the dataset. After this property is set, the encryption key of all
	// newly-created tables in the dataset is set to this value unless the table
	// creation request or query explicitly overrides the key.
	DefaultEncryptionConfiguration *EncryptionConfiguration `json:"defaultEncryptionConfiguration,omitempty"`
	// DefaultPartitionExpirationMs: This default partition expiration, expressed
	// in milliseconds. When new time-partitioned tables are created in a dataset
	// where this property is set, the table will inherit this value, propagated as
	// the `TimePartitioning.expirationMs` property on the new table. If you set
	// `TimePartitioning.expirationMs` explicitly when creating a table, the
	// `defaultPartitionExpirationMs` of the containing dataset is ignored. When
	// creating a partitioned table, if `defaultPartitionExpirationMs` is set, the
	// `defaultTableExpirationMs` value is ignored and the table will not be
	// inherit a table expiration deadline.
	DefaultPartitionExpirationMs int64 `json:"defaultPartitionExpirationMs,omitempty,string"`
	// DefaultRoundingMode: Optional. Defines the default rounding mode
	// specification of new tables created within this dataset. During table
	// creation, if this field is specified, the table within this dataset will
	// inherit the default rounding mode of the dataset. Setting the default
	// rounding mode on a table overrides this option. Existing tables in the
	// dataset are unaffected. If columns are defined during that table creation,
	// they will immediately inherit the table's default rounding mode, unless
	// otherwise specified.
	//
	// Possible values:
	//   "ROUNDING_MODE_UNSPECIFIED" - Unspecified will default to using
	// ROUND_HALF_AWAY_FROM_ZERO.
	//   "ROUND_HALF_AWAY_FROM_ZERO" - ROUND_HALF_AWAY_FROM_ZERO rounds half values
	// away from zero when applying precision and scale upon writing of NUMERIC and
	// BIGNUMERIC values. For Scale: 0 1.1, 1.2, 1.3, 1.4 => 1 1.5, 1.6, 1.7, 1.8,
	// 1.9 => 2
	//   "ROUND_HALF_EVEN" - ROUND_HALF_EVEN rounds half values to the nearest even
	// value when applying precision and scale upon writing of NUMERIC and
	// BIGNUMERIC values. For Scale: 0 1.1, 1.2, 1.3, 1.4 => 1 1.5 => 2 1.6, 1.7,
	// 1.8, 1.9 => 2 2.5 => 2
	DefaultRoundingMode string `json:"defaultRoundingMode,omitempty"`
	// DefaultTableExpirationMs: Optional. The default lifetime of all tables in
	// the dataset, in milliseconds. The minimum lifetime value is 3600000
	// milliseconds (one hour). To clear an existing default expiration with a
	// PATCH request, set to 0. Once this property is set, all newly-created tables
	// in the dataset will have an expirationTime property set to the creation time
	// plus the value in this property, and changing the value will only affect new
	// tables, not existing ones. When the expirationTime for a given table is
	// reached, that table will be deleted automatically. If a table's
	// expirationTime is modified or removed before the table expires, or if you
	// provide an explicit expirationTime when creating a table, that value takes
	// precedence over the default expiration time indicated by this property.
	DefaultTableExpirationMs int64 `json:"defaultTableExpirationMs,omitempty,string"`
	// Description: Optional. A user-friendly description of the dataset.
	Description string `json:"description,omitempty"`
	// Etag: Output only. A hash of the resource.
	Etag string `json:"etag,omitempty"`
	// ExternalCatalogDatasetOptions: Optional. Options defining open source
	// compatible datasets living in the BigQuery catalog. Contains metadata of
	// open source database, schema or namespace represented by the current
	// dataset.
	ExternalCatalogDatasetOptions *ExternalCatalogDatasetOptions `json:"externalCatalogDatasetOptions,omitempty"`
	// ExternalDatasetReference: Optional. Reference to a read-only external
	// dataset defined in data catalogs outside of BigQuery. Filled out when the
	// dataset type is EXTERNAL.
	ExternalDatasetReference *ExternalDatasetReference `json:"externalDatasetReference,omitempty"`
	// FriendlyName: Optional. A descriptive name for the dataset.
	FriendlyName string `json:"friendlyName,omitempty"`
	// Id: Output only. The fully-qualified unique name of the dataset in the
	// format projectId:datasetId. The dataset name without the project name is
	// given in the datasetId field. When creating a new dataset, leave this field
	// blank, and instead specify the datasetId field.
	Id string `json:"id,omitempty"`
	// IsCaseInsensitive: Optional. TRUE if the dataset and its table names are
	// case-insensitive, otherwise FALSE. By default, this is FALSE, which means
	// the dataset and its table names are case-sensitive. This field does not
	// affect routine references.
	IsCaseInsensitive bool `json:"isCaseInsensitive,omitempty"`
	// Kind: Output only. The resource type.
	Kind string `json:"kind,omitempty"`
	// Labels: The labels associated with this dataset. You can use these to
	// organize and group your datasets. You can set this property when inserting
	// or updating a dataset. See Creating and Updating Dataset Labels
	// (https://cloud.google.com/bigquery/docs/creating-managing-labels#creating_and_updating_dataset_labels)
	// for more information.
	Labels map[string]string `json:"labels,omitempty"`
	// LastModifiedTime: Output only. The date when this dataset was last modified,
	// in milliseconds since the epoch.
	LastModifiedTime int64 `json:"lastModifiedTime,omitempty,string"`
	// LinkedDatasetMetadata: Output only. Metadata about the LinkedDataset. Filled
	// out when the dataset type is LINKED.
	LinkedDatasetMetadata *LinkedDatasetMetadata `json:"linkedDatasetMetadata,omitempty"`
	// LinkedDatasetSource: Optional. The source dataset reference when the dataset
	// is of type LINKED. For all other dataset types it is not set. This field
	// cannot be updated once it is set. Any attempt to update this field using
	// Update and Patch API Operations will be ignored.
	LinkedDatasetSource *LinkedDatasetSource `json:"linkedDatasetSource,omitempty"`
	// Location: The geographic location where the dataset should reside. See
	// https://cloud.google.com/bigquery/docs/locations for supported locations.
	Location string `json:"location,omitempty"`
	// MaxTimeTravelHours: Optional. Defines the time travel window in hours. The
	// value can be from 48 to 168 hours (2 to 7 days). The default value is 168
	// hours if this is not set.
	MaxTimeTravelHours int64 `json:"maxTimeTravelHours,omitempty,string"`
	// ResourceTags: Optional. The tags
	// (https://cloud.google.com/bigquery/docs/tags) attached to this dataset. Tag
	// keys are globally unique. Tag key is expected to be in the namespaced
	// format, for example "123456789012/environment" where 123456789012 is the ID
	// of the parent organization or project resource for this tag key. Tag value
	// is expected to be the short name, for example "Production". See Tag
	// definitions
	// (https://cloud.google.com/iam/docs/tags-access-control#definitions) for more
	// details.
	ResourceTags map[string]string `json:"resourceTags,omitempty"`
	// Restrictions: Optional. Output only. Restriction config for all tables and
	// dataset. If set, restrict certain accesses on the dataset and all its tables
	// based on the config. See Data egress
	// (https://cloud.google.com/bigquery/docs/analytics-hub-introduction#data_egress)
	// for more details.
	Restrictions *RestrictionConfig `json:"restrictions,omitempty"`
	// SatisfiesPzi: Output only. Reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SelfLink: Output only. A URL that can be used to access the resource again.
	// You can use this URL in Get or Update requests to the resource.
	SelfLink string `json:"selfLink,omitempty"`
	// StorageBillingModel: Optional. Updates storage_billing_model for the
	// dataset.
	//
	// Possible values:
	//   "STORAGE_BILLING_MODEL_UNSPECIFIED" - Value not set.
	//   "LOGICAL" - Billing for logical bytes.
	//   "PHYSICAL" - Billing for physical bytes.
	StorageBillingModel string `json:"storageBillingModel,omitempty"`
	// Tags: Output only. Tags for the dataset. To provide tags as inputs, use the
	// `resourceTags` field.
	Tags []*DatasetTags `json:"tags,omitempty"`
	// Type: Output only. Same as `type` in `ListFormatDataset`. The type of the
	// dataset, one of: * DEFAULT - only accessible by owner and authorized
	// accounts, * PUBLIC - accessible by everyone, * LINKED - linked dataset, *
	// EXTERNAL - dataset with definition in external metadata catalog.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Access") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Access") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Dataset) MarshalJSON() ([]byte, error) {
	type NoMethod Dataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatasetAccess: An object that defines dataset access for an entity.
type DatasetAccess struct {
	// Condition: Optional. condition for the binding. If CEL expression in this
	// field is true, this access binding will be considered
	Condition *Expr `json:"condition,omitempty"`
	// Dataset: [Pick one] A grant authorizing all resources of a particular type
	// in a particular dataset access to this dataset. Only views are supported for
	// now. The role field is not required when this field is set. If that dataset
	// is deleted and re-created, its access needs to be granted again via an
	// update operation.
	Dataset *DatasetAccessEntry `json:"dataset,omitempty"`
	// Domain: [Pick one] A domain to grant access to. Any users signed in with the
	// domain specified will be granted the specified access. Example:
	// "example.com". Maps to IAM policy member "domain:DOMAIN".
	Domain string `json:"domain,omitempty"`
	// GroupByEmail: [Pick one] An email address of a Google Group to grant access
	// to. Maps to IAM policy member "group:GROUP".
	GroupByEmail string `json:"groupByEmail,omitempty"`
	// IamMember: [Pick one] Some other type of member that appears in the IAM
	// Policy but isn't a user, group, domain, or special group.
	IamMember string `json:"iamMember,omitempty"`
	// Role: An IAM role ID that should be granted to the user, group, or domain
	// specified in this access entry. The following legacy mappings will be
	// applied: * `OWNER`: `roles/bigquery.dataOwner` * `WRITER`:
	// `roles/bigquery.dataEditor` * `READER`: `roles/bigquery.dataViewer` This
	// field will accept any of the above formats, but will return only the legacy
	// format. For example, if you set this field to "roles/bigquery.dataOwner", it
	// will be returned back as "OWNER".
	Role string `json:"role,omitempty"`
	// Routine: [Pick one] A routine from a different dataset to grant access to.
	// Queries executed against that routine will have read access to
	// views/tables/routines in this dataset. Only UDF is supported for now. The
	// role field is not required when this field is set. If that routine is
	// updated by any user, access to the routine needs to be granted again via an
	// update operation.
	Routine *RoutineReference `json:"routine,omitempty"`
	// SpecialGroup: [Pick one] A special group to grant access to. Possible values
	// include: * projectOwners: Owners of the enclosing project. * projectReaders:
	// Readers of the enclosing project. * projectWriters: Writers of the enclosing
	// project. * allAuthenticatedUsers: All authenticated BigQuery users. Maps to
	// similarly-named IAM members.
	SpecialGroup string `json:"specialGroup,omitempty"`
	// UserByEmail: [Pick one] An email address of a user to grant access to. For
	// example: fred@example.com. Maps to IAM policy member "user:EMAIL" or
	// "serviceAccount:EMAIL".
	UserByEmail string `json:"userByEmail,omitempty"`
	// View: [Pick one] A view from a different dataset to grant access to. Queries
	// executed against that view will have read access to views/tables/routines in
	// this dataset. The role field is not required when this field is set. If that
	// view is updated by any user, access to the view needs to be granted again
	// via an update operation.
	View *TableReference `json:"view,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatasetAccess) MarshalJSON() ([]byte, error) {
	type NoMethod DatasetAccess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatasetTags: A global tag managed by Resource Manager.
// https://cloud.google.com/iam/docs/tags-access-control#definitions
type DatasetTags struct {
	// TagKey: Required. The namespaced friendly name of the tag key, e.g.
	// "12345/environment" where 12345 is org id.
	TagKey string `json:"tagKey,omitempty"`
	// TagValue: Required. The friendly short name of the tag value, e.g.
	// "production".
	TagValue string `json:"tagValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TagKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TagKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatasetTags) MarshalJSON() ([]byte, error) {
	type NoMethod DatasetTags
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatasetAccessEntry: Grants all resources of particular types in a particular
// dataset read access to the current dataset. Similar to how individually
// authorized views work, updates to any resource granted through its dataset
// (including creation of new resources) requires read permission to referenced
// resources, plus write permission to the authorizing dataset.
type DatasetAccessEntry struct {
	// Dataset: The dataset this entry applies to
	Dataset *DatasetReference `json:"dataset,omitempty"`
	// TargetTypes: Which resources in the dataset this entry applies to.
	// Currently, only views are supported, but additional target types may be
	// added in the future.
	//
	// Possible values:
	//   "TARGET_TYPE_UNSPECIFIED" - Do not use. You must set a target type
	// explicitly.
	//   "VIEWS" - This entry applies to views in the dataset.
	//   "ROUTINES" - This entry applies to routines in the dataset.
	TargetTypes []string `json:"targetTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dataset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatasetAccessEntry) MarshalJSON() ([]byte, error) {
	type NoMethod DatasetAccessEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatasetList: Response format for a page of results when listing datasets.
type DatasetList struct {
	// Datasets: An array of the dataset resources in the project. Each resource
	// contains basic information. For full information about a particular dataset
	// resource, use the Datasets: get method. This property is omitted when there
	// are no datasets in the project.
	Datasets []*DatasetListDatasets `json:"datasets,omitempty"`
	// Etag: Output only. A hash value of the results page. You can use this
	// property to determine if the page has changed since the last request.
	Etag string `json:"etag,omitempty"`
	// Kind: Output only. The resource type. This property always returns the value
	// "bigquery#datasetList"
	Kind string `json:"kind,omitempty"`
	// NextPageToken: A token that can be used to request the next results page.
	// This property is omitted on the final results page.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: A list of skipped locations that were unreachable. For more
	// information about BigQuery locations, see:
	// https://cloud.google.com/bigquery/docs/locations. Example: "europe-west5"
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Datasets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Datasets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatasetList) MarshalJSON() ([]byte, error) {
	type NoMethod DatasetList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatasetListDatasets: A dataset resource with only a subset of fields, to be
// returned in a list of datasets.
type DatasetListDatasets struct {
	// DatasetReference: The dataset reference. Use this property to access
	// specific parts of the dataset's ID, such as project ID or dataset ID.
	DatasetReference *DatasetReference `json:"datasetReference,omitempty"`
	// ExternalDatasetReference: Output only. Reference to a read-only external
	// dataset defined in data catalogs outside of BigQuery. Filled out when the
	// dataset type is EXTERNAL.
	ExternalDatasetReference *ExternalDatasetReference `json:"externalDatasetReference,omitempty"`
	// FriendlyName: An alternate name for the dataset. The friendly name is purely
	// decorative in nature.
	FriendlyName string `json:"friendlyName,omitempty"`
	// Id: The fully-qualified, unique, opaque ID of the dataset.
	Id string `json:"id,omitempty"`
	// Kind: The resource type. This property always returns the value
	// "bigquery#dataset"
	Kind string `json:"kind,omitempty"`
	// Labels: The labels associated with this dataset. You can use these to
	// organize and group your datasets.
	Labels map[string]string `json:"labels,omitempty"`
	// Location: The geographic location where the dataset resides.
	Location string `json:"location,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetReference") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetReference") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatasetListDatasets) MarshalJSON() ([]byte, error) {
	type NoMethod DatasetListDatasets
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatasetReference: Identifier for a dataset.
type DatasetReference struct {
	// DatasetId: Required. A unique ID for this dataset, without the project name.
	// The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores
	// (_). The maximum length is 1,024 characters.
	DatasetId string `json:"datasetId,omitempty"`
	// ProjectId: Optional. The ID of the project containing this dataset.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatasetReference) MarshalJSON() ([]byte, error) {
	type NoMethod DatasetReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DestinationTableProperties: Properties for the destination table.
type DestinationTableProperties struct {
	// Description: Optional. The description for the destination table. This will
	// only be used if the destination table is newly created. If the table already
	// exists and a value different than the current description is provided, the
	// job will fail.
	Description string `json:"description,omitempty"`
	// ExpirationTime: Internal use only.
	ExpirationTime string `json:"expirationTime,omitempty"`
	// FriendlyName: Optional. Friendly name for the destination table. If the
	// table already exists, it should be same as the existing friendly name.
	FriendlyName string `json:"friendlyName,omitempty"`
	// Labels: Optional. The labels associated with this table. You can use these
	// to organize and group your tables. This will only be used if the destination
	// table is newly created. If the table already exists and labels are different
	// than the current labels are provided, the job will fail.
	Labels map[string]string `json:"labels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DestinationTableProperties) MarshalJSON() ([]byte, error) {
	type NoMethod DestinationTableProperties
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DifferentialPrivacyPolicy: Represents privacy policy associated with
// "differential privacy" method.
type DifferentialPrivacyPolicy struct {
	// DeltaBudget: Optional. The total delta budget for all queries against the
	// privacy-protected view. Each subscriber query against this view charges the
	// amount of delta that is pre-defined by the contributor through the privacy
	// policy delta_per_query field. If there is sufficient budget, then the
	// subscriber query attempts to complete. It might still fail due to other
	// reasons, in which case the charge is refunded. If there is insufficient
	// budget the query is rejected. There might be multiple charge attempts if a
	// single query references multiple views. In this case there must be
	// sufficient budget for all charges or the query is rejected and charges are
	// refunded in best effort. The budget does not have a refresh policy and can
	// only be updated via ALTER VIEW or circumvented by creating a new view that
	// can be queried with a fresh budget.
	DeltaBudget float64 `json:"deltaBudget,omitempty"`
	// DeltaBudgetRemaining: Output only. The delta budget remaining. If budget is
	// exhausted, no more queries are allowed. Note that the budget for queries
	// that are in progress is deducted before the query executes. If the query
	// fails or is cancelled then the budget is refunded. In this case the amount
	// of budget remaining can increase.
	DeltaBudgetRemaining float64 `json:"deltaBudgetRemaining,omitempty"`
	// DeltaPerQuery: Optional. The delta value that is used per query. Delta
	// represents the probability that any row will fail to be epsilon
	// differentially private. Indicates the risk associated with exposing
	// aggregate rows in the result of a query.
	DeltaPerQuery float64 `json:"deltaPerQuery,omitempty"`
	// EpsilonBudget: Optional. The total epsilon budget for all queries against
	// the privacy-protected view. Each subscriber query against this view charges
	// the amount of epsilon they request in their query. If there is sufficient
	// budget, then the subscriber query attempts to complete. It might still fail
	// due to other reasons, in which case the charge is refunded. If there is
	// insufficient budget the query is rejected. There might be multiple charge
	// attempts if a single query references multiple views. In this case there
	// must be sufficient budget for all charges or the query is rejected and
	// charges are refunded in best effort. The budget does not have a refresh
	// policy and can only be updated via ALTER VIEW or circumvented by creating a
	// new view that can be queried with a fresh budget.
	EpsilonBudget float64 `json:"epsilonBudget,omitempty"`
	// EpsilonBudgetRemaining: Output only. The epsilon budget remaining. If budget
	// is exhausted, no more queries are allowed. Note that the budget for queries
	// that are in progress is deducted before the query executes. If the query
	// fails or is cancelled then the budget is refunded. In this case the amount
	// of budget remaining can increase.
	EpsilonBudgetRemaining float64 `json:"epsilonBudgetRemaining,omitempty"`
	// MaxEpsilonPerQuery: Optional. The maximum epsilon value that a query can
	// consume. If the subscriber specifies epsilon as a parameter in a SELECT
	// query, it must be less than or equal to this value. The epsilon parameter
	// controls the amount of noise that is added to the groups — a higher
	// epsilon means less noise.
	MaxEpsilonPerQuery float64 `json:"maxEpsilonPerQuery,omitempty"`
	// MaxGroupsContributed: Optional. The maximum groups contributed value that is
	// used per query. Represents the maximum number of groups to which each
	// protected entity can contribute. Changing this value does not improve or
	// worsen privacy. The best value for accuracy and utility depends on the query
	// and data.
	MaxGroupsContributed int64 `json:"maxGroupsContributed,omitempty,string"`
	// PrivacyUnitColumn: Optional. The privacy unit column associated with this
	// policy. Differential privacy policies can only have one privacy unit column
	// per data source object (table, view).
	PrivacyUnitColumn string `json:"privacyUnitColumn,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeltaBudget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeltaBudget") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DifferentialPrivacyPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod DifferentialPrivacyPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *DifferentialPrivacyPolicy) UnmarshalJSON(data []byte) error {
	type NoMethod DifferentialPrivacyPolicy
	var s1 struct {
		DeltaBudget            gensupport.JSONFloat64 `json:"deltaBudget"`
		DeltaBudgetRemaining   gensupport.JSONFloat64 `json:"deltaBudgetRemaining"`
		DeltaPerQuery          gensupport.JSONFloat64 `json:"deltaPerQuery"`
		EpsilonBudget          gensupport.JSONFloat64 `json:"epsilonBudget"`
		EpsilonBudgetRemaining gensupport.JSONFloat64 `json:"epsilonBudgetRemaining"`
		MaxEpsilonPerQuery     gensupport.JSONFloat64 `json:"maxEpsilonPerQuery"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DeltaBudget = float64(s1.DeltaBudget)
	s.DeltaBudgetRemaining = float64(s1.DeltaBudgetRemaining)
	s.DeltaPerQuery = float64(s1.DeltaPerQuery)
	s.EpsilonBudget = float64(s1.EpsilonBudget)
	s.EpsilonBudgetRemaining = float64(s1.EpsilonBudgetRemaining)
	s.MaxEpsilonPerQuery = float64(s1.MaxEpsilonPerQuery)
	return nil
}

// DimensionalityReductionMetrics: Model evaluation metrics for dimensionality
// reduction models.
type DimensionalityReductionMetrics struct {
	// TotalExplainedVarianceRatio: Total percentage of variance explained by the
	// selected principal components.
	TotalExplainedVarianceRatio float64 `json:"totalExplainedVarianceRatio,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "TotalExplainedVarianceRatio") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TotalExplainedVarianceRatio") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DimensionalityReductionMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod DimensionalityReductionMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *DimensionalityReductionMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod DimensionalityReductionMetrics
	var s1 struct {
		TotalExplainedVarianceRatio gensupport.JSONFloat64 `json:"totalExplainedVarianceRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TotalExplainedVarianceRatio = float64(s1.TotalExplainedVarianceRatio)
	return nil
}

// DmlStatistics: Detailed statistics for DML statements
type DmlStatistics struct {
	// DeletedRowCount: Output only. Number of deleted Rows. populated by DML
	// DELETE, MERGE and TRUNCATE statements.
	DeletedRowCount int64 `json:"deletedRowCount,omitempty,string"`
	// InsertedRowCount: Output only. Number of inserted Rows. Populated by DML
	// INSERT and MERGE statements
	InsertedRowCount int64 `json:"insertedRowCount,omitempty,string"`
	// UpdatedRowCount: Output only. Number of updated Rows. Populated by DML
	// UPDATE and MERGE statements.
	UpdatedRowCount int64 `json:"updatedRowCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DeletedRowCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeletedRowCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DmlStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod DmlStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DoubleCandidates: Discrete candidates of a double hyperparameter.
type DoubleCandidates struct {
	// Candidates: Candidates for the double parameter in increasing order.
	Candidates []float64 `json:"candidates,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DoubleCandidates) MarshalJSON() ([]byte, error) {
	type NoMethod DoubleCandidates
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *DoubleCandidates) UnmarshalJSON(data []byte) error {
	type NoMethod DoubleCandidates
	var s1 struct {
		Candidates []gensupport.JSONFloat64 `json:"candidates"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Candidates = make([]float64, len(s1.Candidates))
	for i := range s1.Candidates {
		s.Candidates[i] = float64(s1.Candidates[i])
	}
	return nil
}

// DoubleHparamSearchSpace: Search space for a double hyperparameter.
type DoubleHparamSearchSpace struct {
	// Candidates: Candidates of the double hyperparameter.
	Candidates *DoubleCandidates `json:"candidates,omitempty"`
	// Range: Range of the double hyperparameter.
	Range *DoubleRange `json:"range,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DoubleHparamSearchSpace) MarshalJSON() ([]byte, error) {
	type NoMethod DoubleHparamSearchSpace
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DoubleRange: Range of a double hyperparameter.
type DoubleRange struct {
	// Max: Max value of the double parameter.
	Max float64 `json:"max,omitempty"`
	// Min: Min value of the double parameter.
	Min float64 `json:"min,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Max") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Max") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DoubleRange) MarshalJSON() ([]byte, error) {
	type NoMethod DoubleRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *DoubleRange) UnmarshalJSON(data []byte) error {
	type NoMethod DoubleRange
	var s1 struct {
		Max gensupport.JSONFloat64 `json:"max"`
		Min gensupport.JSONFloat64 `json:"min"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Max = float64(s1.Max)
	s.Min = float64(s1.Min)
	return nil
}

// EncryptionConfiguration: Configuration for Cloud KMS encryption settings.
type EncryptionConfiguration struct {
	// KmsKeyName: Optional. Describes the Cloud KMS encryption key that will be
	// used to protect destination BigQuery table. The BigQuery Service Account
	// associated with your project requires access to this encryption key.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKeyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKeyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EncryptionConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod EncryptionConfiguration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Entry: A single entry in the confusion matrix.
type Entry struct {
	// ItemCount: Number of items being predicted as this label.
	ItemCount int64 `json:"itemCount,omitempty,string"`
	// PredictedLabel: The predicted label. For confidence_threshold > 0, we will
	// also add an entry indicating the number of items under the confidence
	// threshold.
	PredictedLabel string `json:"predictedLabel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ItemCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ItemCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Entry) MarshalJSON() ([]byte, error) {
	type NoMethod Entry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ErrorProto: Error details.
type ErrorProto struct {
	// DebugInfo: Debugging information. This property is internal to Google and
	// should not be used.
	DebugInfo string `json:"debugInfo,omitempty"`
	// Location: Specifies where the error occurred, if present.
	Location string `json:"location,omitempty"`
	// Message: A human-readable description of the error.
	Message string `json:"message,omitempty"`
	// Reason: A short error code that summarizes the error.
	Reason string `json:"reason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DebugInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DebugInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ErrorProto) MarshalJSON() ([]byte, error) {
	type NoMethod ErrorProto
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EvaluationMetrics: Evaluation metrics of a model. These are either computed
// on all training data or just the eval data based on whether eval data was
// used during training. These are not present for imported models.
type EvaluationMetrics struct {
	// ArimaForecastingMetrics: Populated for ARIMA models.
	ArimaForecastingMetrics *ArimaForecastingMetrics `json:"arimaForecastingMetrics,omitempty"`
	// BinaryClassificationMetrics: Populated for binary classification/classifier
	// models.
	BinaryClassificationMetrics *BinaryClassificationMetrics `json:"binaryClassificationMetrics,omitempty"`
	// ClusteringMetrics: Populated for clustering models.
	ClusteringMetrics *ClusteringMetrics `json:"clusteringMetrics,omitempty"`
	// DimensionalityReductionMetrics: Evaluation metrics when the model is a
	// dimensionality reduction model, which currently includes PCA.
	DimensionalityReductionMetrics *DimensionalityReductionMetrics `json:"dimensionalityReductionMetrics,omitempty"`
	// MultiClassClassificationMetrics: Populated for multi-class
	// classification/classifier models.
	MultiClassClassificationMetrics *MultiClassClassificationMetrics `json:"multiClassClassificationMetrics,omitempty"`
	// RankingMetrics: Populated for implicit feedback type matrix factorization
	// models.
	RankingMetrics *RankingMetrics `json:"rankingMetrics,omitempty"`
	// RegressionMetrics: Populated for regression models and explicit feedback
	// type matrix factorization models.
	RegressionMetrics *RegressionMetrics `json:"regressionMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArimaForecastingMetrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArimaForecastingMetrics") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EvaluationMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod EvaluationMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExplainQueryStage: A single stage of query execution.
type ExplainQueryStage struct {
	// CompletedParallelInputs: Number of parallel input segments completed.
	CompletedParallelInputs int64 `json:"completedParallelInputs,omitempty,string"`
	// ComputeMode: Output only. Compute mode for this stage.
	//
	// Possible values:
	//   "COMPUTE_MODE_UNSPECIFIED" - ComputeMode type not specified.
	//   "BIGQUERY" - This stage was processed using BigQuery slots.
	//   "BI_ENGINE" - This stage was processed using BI Engine compute.
	ComputeMode string `json:"computeMode,omitempty"`
	// ComputeMsAvg: Milliseconds the average shard spent on CPU-bound tasks.
	ComputeMsAvg int64 `json:"computeMsAvg,omitempty,string"`
	// ComputeMsMax: Milliseconds the slowest shard spent on CPU-bound tasks.
	ComputeMsMax int64 `json:"computeMsMax,omitempty,string"`
	// ComputeRatioAvg: Relative amount of time the average shard spent on
	// CPU-bound tasks.
	ComputeRatioAvg float64 `json:"computeRatioAvg,omitempty"`
	// ComputeRatioMax: Relative amount of time the slowest shard spent on
	// CPU-bound tasks.
	ComputeRatioMax float64 `json:"computeRatioMax,omitempty"`
	// EndMs: Stage end time represented as milliseconds since the epoch.
	EndMs int64 `json:"endMs,omitempty,string"`
	// Id: Unique ID for the stage within the plan.
	Id int64 `json:"id,omitempty,string"`
	// InputStages: IDs for stages that are inputs to this stage.
	InputStages googleapi.Int64s `json:"inputStages,omitempty"`
	// Name: Human-readable name for the stage.
	Name string `json:"name,omitempty"`
	// ParallelInputs: Number of parallel input segments to be processed
	ParallelInputs int64 `json:"parallelInputs,omitempty,string"`
	// ReadMsAvg: Milliseconds the average shard spent reading input.
	ReadMsAvg int64 `json:"readMsAvg,omitempty,string"`
	// ReadMsMax: Milliseconds the slowest shard spent reading input.
	ReadMsMax int64 `json:"readMsMax,omitempty,string"`
	// ReadRatioAvg: Relative amount of time the average shard spent reading input.
	ReadRatioAvg float64 `json:"readRatioAvg,omitempty"`
	// ReadRatioMax: Relative amount of time the slowest shard spent reading input.
	ReadRatioMax float64 `json:"readRatioMax,omitempty"`
	// RecordsRead: Number of records read into the stage.
	RecordsRead int64 `json:"recordsRead,omitempty,string"`
	// RecordsWritten: Number of records written by the stage.
	RecordsWritten int64 `json:"recordsWritten,omitempty,string"`
	// ShuffleOutputBytes: Total number of bytes written to shuffle.
	ShuffleOutputBytes int64 `json:"shuffleOutputBytes,omitempty,string"`
	// ShuffleOutputBytesSpilled: Total number of bytes written to shuffle and
	// spilled to disk.
	ShuffleOutputBytesSpilled int64 `json:"shuffleOutputBytesSpilled,omitempty,string"`
	// SlotMs: Slot-milliseconds used by the stage.
	SlotMs int64 `json:"slotMs,omitempty,string"`
	// StartMs: Stage start time represented as milliseconds since the epoch.
	StartMs int64 `json:"startMs,omitempty,string"`
	// Status: Current status for this stage.
	Status string `json:"status,omitempty"`
	// Steps: List of operations within the stage in dependency order
	// (approximately chronological).
	Steps []*ExplainQueryStep `json:"steps,omitempty"`
	// WaitMsAvg: Milliseconds the average shard spent waiting to be scheduled.
	WaitMsAvg int64 `json:"waitMsAvg,omitempty,string"`
	// WaitMsMax: Milliseconds the slowest shard spent waiting to be scheduled.
	WaitMsMax int64 `json:"waitMsMax,omitempty,string"`
	// WaitRatioAvg: Relative amount of time the average shard spent waiting to be
	// scheduled.
	WaitRatioAvg float64 `json:"waitRatioAvg,omitempty"`
	// WaitRatioMax: Relative amount of time the slowest shard spent waiting to be
	// scheduled.
	WaitRatioMax float64 `json:"waitRatioMax,omitempty"`
	// WriteMsAvg: Milliseconds the average shard spent on writing output.
	WriteMsAvg int64 `json:"writeMsAvg,omitempty,string"`
	// WriteMsMax: Milliseconds the slowest shard spent on writing output.
	WriteMsMax int64 `json:"writeMsMax,omitempty,string"`
	// WriteRatioAvg: Relative amount of time the average shard spent on writing
	// output.
	WriteRatioAvg float64 `json:"writeRatioAvg,omitempty"`
	// WriteRatioMax: Relative amount of time the slowest shard spent on writing
	// output.
	WriteRatioMax float64 `json:"writeRatioMax,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletedParallelInputs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletedParallelInputs") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExplainQueryStage) MarshalJSON() ([]byte, error) {
	type NoMethod ExplainQueryStage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ExplainQueryStage) UnmarshalJSON(data []byte) error {
	type NoMethod ExplainQueryStage
	var s1 struct {
		ComputeRatioAvg gensupport.JSONFloat64 `json:"computeRatioAvg"`
		ComputeRatioMax gensupport.JSONFloat64 `json:"computeRatioMax"`
		ReadRatioAvg    gensupport.JSONFloat64 `json:"readRatioAvg"`
		ReadRatioMax    gensupport.JSONFloat64 `json:"readRatioMax"`
		WaitRatioAvg    gensupport.JSONFloat64 `json:"waitRatioAvg"`
		WaitRatioMax    gensupport.JSONFloat64 `json:"waitRatioMax"`
		WriteRatioAvg   gensupport.JSONFloat64 `json:"writeRatioAvg"`
		WriteRatioMax   gensupport.JSONFloat64 `json:"writeRatioMax"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ComputeRatioAvg = float64(s1.ComputeRatioAvg)
	s.ComputeRatioMax = float64(s1.ComputeRatioMax)
	s.ReadRatioAvg = float64(s1.ReadRatioAvg)
	s.ReadRatioMax = float64(s1.ReadRatioMax)
	s.WaitRatioAvg = float64(s1.WaitRatioAvg)
	s.WaitRatioMax = float64(s1.WaitRatioMax)
	s.WriteRatioAvg = float64(s1.WriteRatioAvg)
	s.WriteRatioMax = float64(s1.WriteRatioMax)
	return nil
}

// ExplainQueryStep: An operation within a stage.
type ExplainQueryStep struct {
	// Kind: Machine-readable operation type.
	Kind string `json:"kind,omitempty"`
	// Substeps: Human-readable description of the step(s).
	Substeps []string `json:"substeps,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExplainQueryStep) MarshalJSON() ([]byte, error) {
	type NoMethod ExplainQueryStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Explanation: Explanation for a single feature.
type Explanation struct {
	// Attribution: Attribution of feature.
	Attribution float64 `json:"attribution,omitempty"`
	// FeatureName: The full feature name. For non-numerical features, will be
	// formatted like `.`. Overall size of feature name will always be truncated to
	// first 120 characters.
	FeatureName string `json:"featureName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attribution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attribution") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Explanation) MarshalJSON() ([]byte, error) {
	type NoMethod Explanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Explanation) UnmarshalJSON(data []byte) error {
	type NoMethod Explanation
	var s1 struct {
		Attribution gensupport.JSONFloat64 `json:"attribution"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Attribution = float64(s1.Attribution)
	return nil
}

// ExportDataStatistics: Statistics for the EXPORT DATA statement as part of
// Query Job. EXTRACT JOB statistics are populated in JobStatistics4.
type ExportDataStatistics struct {
	// FileCount: Number of destination files generated in case of EXPORT DATA
	// statement only.
	FileCount int64 `json:"fileCount,omitempty,string"`
	// RowCount: [Alpha] Number of destination rows generated in case of EXPORT
	// DATA statement only.
	RowCount int64 `json:"rowCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "FileCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportDataStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod ExportDataStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExternalCatalogDatasetOptions: Options defining open source compatible
// datasets living in the BigQuery catalog. Contains metadata of open source
// database, schema, or namespace represented by the current dataset.
type ExternalCatalogDatasetOptions struct {
	// DefaultStorageLocationUri: Optional. The storage location URI for all tables
	// in the dataset. Equivalent to hive metastore's database locationUri. Maximum
	// length of 1024 characters.
	DefaultStorageLocationUri string `json:"defaultStorageLocationUri,omitempty"`
	// Parameters: Optional. A map of key value pairs defining the parameters and
	// properties of the open source schema. Maximum size of 2MiB.
	Parameters map[string]string `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultStorageLocationUri")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultStorageLocationUri") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExternalCatalogDatasetOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalCatalogDatasetOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExternalCatalogTableOptions: Metadata about open source compatible table.
// The fields contained in these options correspond to Hive metastore's
// table-level properties.
type ExternalCatalogTableOptions struct {
	// ConnectionId: Optional. A connection ID that specifies the credentials to be
	// used to read external storage, such as Azure Blob, Cloud Storage, or Amazon
	// S3. This connection is needed to read the open source table from BigQuery.
	// The connection_id format must be either `..` or
	// `projects//locations//connections/`.
	ConnectionId string `json:"connectionId,omitempty"`
	// Parameters: Optional. A map of the key-value pairs defining the parameters
	// and properties of the open source table. Corresponds with Hive metastore
	// table parameters. Maximum size of 4MiB.
	Parameters map[string]string `json:"parameters,omitempty"`
	// StorageDescriptor: Optional. A storage descriptor containing information
	// about the physical storage of this table.
	StorageDescriptor *StorageDescriptor `json:"storageDescriptor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExternalCatalogTableOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalCatalogTableOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ExternalDataConfiguration struct {
	// Autodetect: Try to detect schema and format options automatically. Any
	// option specified explicitly will be honored.
	Autodetect bool `json:"autodetect,omitempty"`
	// AvroOptions: Optional. Additional properties to set if sourceFormat is set
	// to AVRO.
	AvroOptions *AvroOptions `json:"avroOptions,omitempty"`
	// BigtableOptions: Optional. Additional options if sourceFormat is set to
	// BIGTABLE.
	BigtableOptions *BigtableOptions `json:"bigtableOptions,omitempty"`
	// Compression: Optional. The compression type of the data source. Possible
	// values include GZIP and NONE. The default value is NONE. This setting is
	// ignored for Google Cloud Bigtable, Google Cloud Datastore backups, Avro, ORC
	// and Parquet formats. An empty string is an invalid value.
	Compression string `json:"compression,omitempty"`
	// ConnectionId: Optional. The connection specifying the credentials to be used
	// to read external storage, such as Azure Blob, Cloud Storage, or S3. The
	// connection_id can have the form `{project_id}.{location_id};{connection_id}`
	// or
	// `projects/{project_id}/locations/{location_id}/connections/{connection_id}`.
	ConnectionId string `json:"connectionId,omitempty"`
	// CsvOptions: Optional. Additional properties to set if sourceFormat is set to
	// CSV.
	CsvOptions *CsvOptions `json:"csvOptions,omitempty"`
	// DateFormat: Optional. Format used to parse DATE values. Supports C-style and
	// SQL-style values.
	DateFormat string `json:"dateFormat,omitempty"`
	// DatetimeFormat: Optional. Format used to parse DATETIME values. Supports
	// C-style and SQL-style values.
	DatetimeFormat string `json:"datetimeFormat,omitempty"`
	// DecimalTargetTypes: Defines the list of possible SQL data types to which the
	// source decimal values are converted. This list and the precision and the
	// scale parameters of the decimal field determine the target type. In the
	// order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the
	// specified list and if it supports the precision and the scale. STRING
	// supports all precision and scale values. If none of the listed types
	// supports the precision and the scale, the type supporting the widest range
	// in the specified list is picked, and if a value exceeds the supported range
	// when reading the data, an error will be thrown. Example: Suppose the value
	// of this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: *
	// (38,9) -> NUMERIC; * (39,9) -> BIGNUMERIC (NUMERIC cannot hold 30 integer
	// digits); * (38,10) -> BIGNUMERIC (NUMERIC cannot hold 10 fractional digits);
	// * (76,38) -> BIGNUMERIC; * (77,38) -> BIGNUMERIC (error if value exceeds
	// supported range). This field cannot contain duplicate types. The order of
	// the types in this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"]
	// is the same as ["NUMERIC", "BIGNUMERIC"] and NUMERIC always takes precedence
	// over BIGNUMERIC. Defaults to ["NUMERIC", "STRING"] for ORC and ["NUMERIC"]
	// for the other file formats.
	//
	// Possible values:
	//   "DECIMAL_TARGET_TYPE_UNSPECIFIED" - Invalid type.
	//   "NUMERIC" - Decimal values could be converted to NUMERIC type.
	//   "BIGNUMERIC" - Decimal values could be converted to BIGNUMERIC type.
	//   "STRING" - Decimal values could be converted to STRING type.
	DecimalTargetTypes []string `json:"decimalTargetTypes,omitempty"`
	// FileSetSpecType: Optional. Specifies how source URIs are interpreted for
	// constructing the file set to load. By default source URIs are expanded
	// against the underlying storage. Other options include specifying manifest
	// files. Only applicable to object storage systems.
	//
	// Possible values:
	//   "FILE_SET_SPEC_TYPE_FILE_SYSTEM_MATCH" - This option expands source URIs
	// by listing files from the object store. It is the default behavior if
	// FileSetSpecType is not set.
	//   "FILE_SET_SPEC_TYPE_NEW_LINE_DELIMITED_MANIFEST" - This option indicates
	// that the provided URIs are newline-delimited manifest files, with one URI
	// per line. Wildcard URIs are not supported.
	FileSetSpecType string `json:"fileSetSpecType,omitempty"`
	// GoogleSheetsOptions: Optional. Additional options if sourceFormat is set to
	// GOOGLE_SHEETS.
	GoogleSheetsOptions *GoogleSheetsOptions `json:"googleSheetsOptions,omitempty"`
	// HivePartitioningOptions: Optional. When set, configures hive partitioning
	// support. Not all storage formats support hive partitioning -- requesting
	// hive partitioning on an unsupported format will lead to an error, as will
	// providing an invalid specification.
	HivePartitioningOptions *HivePartitioningOptions `json:"hivePartitioningOptions,omitempty"`
	// IgnoreUnknownValues: Optional. Indicates if BigQuery should allow extra
	// values that are not represented in the table schema. If true, the extra
	// values are ignored. If false, records with extra columns are treated as bad
	// records, and if there are too many bad records, an invalid error is returned
	// in the job result. The default value is false. The sourceFormat property
	// determines what BigQuery treats as an extra value: CSV: Trailing columns
	// JSON: Named values that don't match any column names Google Cloud Bigtable:
	// This setting is ignored. Google Cloud Datastore backups: This setting is
	// ignored. Avro: This setting is ignored. ORC: This setting is ignored.
	// Parquet: This setting is ignored.
	IgnoreUnknownValues bool `json:"ignoreUnknownValues,omitempty"`
	// JsonExtension: Optional. Load option to be used together with source_format
	// newline-delimited JSON to indicate that a variant of JSON is being loaded.
	// To load newline-delimited GeoJSON, specify GEOJSON (and source_format must
	// be set to NEWLINE_DELIMITED_JSON).
	//
	// Possible values:
	//   "JSON_EXTENSION_UNSPECIFIED" - The default if provided value is not one
	// included in the enum, or the value is not specified. The source format is
	// parsed without any modification.
	//   "GEOJSON" - Use GeoJSON variant of JSON. See
	// https://tools.ietf.org/html/rfc7946.
	JsonExtension string `json:"jsonExtension,omitempty"`
	// JsonOptions: Optional. Additional properties to set if sourceFormat is set
	// to JSON.
	JsonOptions *JsonOptions `json:"jsonOptions,omitempty"`
	// MaxBadRecords: Optional. The maximum number of bad records that BigQuery can
	// ignore when reading data. If the number of bad records exceeds this value,
	// an invalid error is returned in the job result. The default value is 0,
	// which requires that all records are valid. This setting is ignored for
	// Google Cloud Bigtable, Google Cloud Datastore backups, Avro, ORC and Parquet
	// formats.
	MaxBadRecords int64 `json:"maxBadRecords,omitempty"`
	// MetadataCacheMode: Optional. Metadata Cache Mode for the table. Set this to
	// enable caching of metadata from external data source.
	//
	// Possible values:
	//   "METADATA_CACHE_MODE_UNSPECIFIED" - Unspecified metadata cache mode.
	//   "AUTOMATIC" - Set this mode to trigger automatic background refresh of
	// metadata cache from the external source. Queries will use the latest
	// available cache version within the table's maxStaleness interval.
	//   "MANUAL" - Set this mode to enable triggering manual refresh of the
	// metadata cache from external source. Queries will use the latest manually
	// triggered cache version within the table's maxStaleness interval.
	MetadataCacheMode string `json:"metadataCacheMode,omitempty"`
	// ObjectMetadata: Optional. ObjectMetadata is used to create Object Tables.
	// Object Tables contain a listing of objects (with their metadata) found at
	// the source_uris. If ObjectMetadata is set, source_format should be omitted.
	// Currently SIMPLE is the only supported Object Metadata type.
	//
	// Possible values:
	//   "OBJECT_METADATA_UNSPECIFIED" - Unspecified by default.
	//   "DIRECTORY" - A synonym for `SIMPLE`.
	//   "SIMPLE" - Directory listing of objects.
	ObjectMetadata string `json:"objectMetadata,omitempty"`
	// ParquetOptions: Optional. Additional properties to set if sourceFormat is
	// set to PARQUET.
	ParquetOptions *ParquetOptions `json:"parquetOptions,omitempty"`
	// ReferenceFileSchemaUri: Optional. When creating an external table, the user
	// can provide a reference file with the table schema. This is enabled for the
	// following formats: AVRO, PARQUET, ORC.
	ReferenceFileSchemaUri string `json:"referenceFileSchemaUri,omitempty"`
	// Schema: Optional. The schema for the data. Schema is required for CSV and
	// JSON formats if autodetect is not on. Schema is disallowed for Google Cloud
	// Bigtable, Cloud Datastore backups, Avro, ORC and Parquet formats.
	Schema *TableSchema `json:"schema,omitempty"`
	// SourceFormat: [Required] The data format. For CSV files, specify "CSV". For
	// Google sheets, specify "GOOGLE_SHEETS". For newline-delimited JSON, specify
	// "NEWLINE_DELIMITED_JSON". For Avro files, specify "AVRO". For Google Cloud
	// Datastore backups, specify "DATASTORE_BACKUP". For Apache Iceberg tables,
	// specify "ICEBERG". For ORC files, specify "ORC". For Parquet files, specify
	// "PARQUET". [Beta] For Google Cloud Bigtable, specify "BIGTABLE".
	SourceFormat string `json:"sourceFormat,omitempty"`
	// SourceUris: [Required] The fully-qualified URIs that point to your data in
	// Google Cloud. For Google Cloud Storage URIs: Each URI can contain one '*'
	// wildcard character and it must come after the 'bucket' name. Size limits
	// related to load jobs apply to external data sources. For Google Cloud
	// Bigtable URIs: Exactly one URI can be specified and it has be a fully
	// specified and valid HTTPS URL for a Google Cloud Bigtable table. For Google
	// Cloud Datastore backups, exactly one URI can be specified. Also, the '*'
	// wildcard character is not allowed.
	SourceUris []string `json:"sourceUris,omitempty"`
	// TimeFormat: Optional. Format used to parse TIME values. Supports C-style and
	// SQL-style values.
	TimeFormat string `json:"timeFormat,omitempty"`
	// TimeZone: Optional. Time zone used when parsing timestamp values that do not
	// have specific time zone information (e.g. 2024-04-20 12:34:56). The expected
	// format is a IANA timezone string (e.g. America/Los_Angeles).
	TimeZone string `json:"timeZone,omitempty"`
	// TimestampFormat: Optional. Format used to parse TIMESTAMP values. Supports
	// C-style and SQL-style values.
	TimestampFormat string `json:"timestampFormat,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Autodetect") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Autodetect") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExternalDataConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalDataConfiguration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExternalDatasetReference: Configures the access a dataset defined in an
// external metadata storage.
type ExternalDatasetReference struct {
	// Connection: Required. The connection id that is used to access the
	// external_source. Format:
	// projects/{project_id}/locations/{location_id}/connections/{connection_id}
	Connection string `json:"connection,omitempty"`
	// ExternalSource: Required. External source that backs this dataset.
	ExternalSource string `json:"externalSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Connection") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Connection") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExternalDatasetReference) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalDatasetReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExternalRuntimeOptions: Options for the runtime of the external system.
type ExternalRuntimeOptions struct {
	// ContainerCpu: Optional. Amount of CPU provisioned for the container
	// instance. If not specified, the default value is 0.33 vCPUs.
	ContainerCpu float64 `json:"containerCpu,omitempty"`
	// ContainerMemory: Optional. Amount of memory provisioned for the container
	// instance. Format: {number}{unit} where unit is one of "M", "G", "Mi" and
	// "Gi" (e.g. 1G, 512Mi). If not specified, the default value is 512Mi.
	ContainerMemory string `json:"containerMemory,omitempty"`
	// MaxBatchingRows: Optional. Maximum number of rows in each batch sent to the
	// external runtime. If absent or if 0, BigQuery dynamically decides the number
	// of rows in a batch.
	MaxBatchingRows int64 `json:"maxBatchingRows,omitempty,string"`
	// RuntimeConnection: Optional. Fully qualified name of the connection whose
	// service account will be used to execute the code in the container. Format:
	// ``"projects/{project_id}/locations/{location_id}/connections/{connection_id}
	// "``
	RuntimeConnection string `json:"runtimeConnection,omitempty"`
	// RuntimeVersion: Optional. Language runtime version (e.g. python-3.11).
	RuntimeVersion string `json:"runtimeVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerCpu") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerCpu") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExternalRuntimeOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalRuntimeOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ExternalRuntimeOptions) UnmarshalJSON(data []byte) error {
	type NoMethod ExternalRuntimeOptions
	var s1 struct {
		ContainerCpu gensupport.JSONFloat64 `json:"containerCpu"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ContainerCpu = float64(s1.ContainerCpu)
	return nil
}

// ExternalServiceCost: The external service cost is a portion of the total
// cost, these costs are not additive with total_bytes_billed. Moreover, this
// field only track external service costs that will show up as BigQuery costs
// (e.g. training BigQuery ML job with google cloud CAIP or Automl Tables
// services), not other costs which may be accrued by running the query (e.g.
// reading from Bigtable or Cloud Storage). The external service costs with
// different billing sku (e.g. CAIP job is charged based on VM usage) are
// converted to BigQuery billed_bytes and slot_ms with equivalent amount of US
// dollars. Services may not directly correlate to these metrics, but these are
// the equivalents for billing purposes. Output only.
type ExternalServiceCost struct {
	// BillingMethod: The billing method used for the external job. This field is
	// only used when billed on the services sku, set to "SERVICES_SKU". Otherwise,
	// it is unspecified for backward compatibility.
	BillingMethod string `json:"billingMethod,omitempty"`
	// BytesBilled: External service cost in terms of bigquery bytes billed.
	BytesBilled int64 `json:"bytesBilled,omitempty,string"`
	// BytesProcessed: External service cost in terms of bigquery bytes processed.
	BytesProcessed int64 `json:"bytesProcessed,omitempty,string"`
	// ExternalService: External service name.
	ExternalService string `json:"externalService,omitempty"`
	// ReservedSlotCount: Non-preemptable reserved slots used for external job. For
	// example, reserved slots for Cloua AI Platform job are the VM usages
	// converted to BigQuery slot with equivalent mount of price.
	ReservedSlotCount int64 `json:"reservedSlotCount,omitempty,string"`
	// SlotMs: External service cost in terms of bigquery slot milliseconds.
	SlotMs int64 `json:"slotMs,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BillingMethod") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BillingMethod") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExternalServiceCost) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalServiceCost
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FeatureValue: Representative value of a single feature within the cluster.
type FeatureValue struct {
	// CategoricalValue: The categorical feature value.
	CategoricalValue *CategoricalValue `json:"categoricalValue,omitempty"`
	// FeatureColumn: The feature column name.
	FeatureColumn string `json:"featureColumn,omitempty"`
	// NumericalValue: The numerical feature value. This is the centroid value for
	// this feature.
	NumericalValue float64 `json:"numericalValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CategoricalValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CategoricalValue") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FeatureValue) MarshalJSON() ([]byte, error) {
	type NoMethod FeatureValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *FeatureValue) UnmarshalJSON(data []byte) error {
	type NoMethod FeatureValue
	var s1 struct {
		NumericalValue gensupport.JSONFloat64 `json:"numericalValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NumericalValue = float64(s1.NumericalValue)
	return nil
}

// ForeignTypeInfo: Metadata about the foreign data type definition such as the
// system in which the type is defined.
type ForeignTypeInfo struct {
	// TypeSystem: Required. Specifies the system which defines the foreign data
	// type.
	//
	// Possible values:
	//   "TYPE_SYSTEM_UNSPECIFIED" - TypeSystem not specified.
	//   "HIVE" - Represents Hive data types.
	TypeSystem string `json:"typeSystem,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TypeSystem") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TypeSystem") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ForeignTypeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ForeignTypeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ForeignViewDefinition: A view can be represented in multiple ways. Each
// representation has its own dialect. This message stores the metadata
// required for these representations.
type ForeignViewDefinition struct {
	// Dialect: Optional. Represents the dialect of the query.
	Dialect string `json:"dialect,omitempty"`
	// Query: Required. The query that defines the view.
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dialect") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dialect") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ForeignViewDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod ForeignViewDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetIamPolicyRequest: Request message for `GetIamPolicy` method.
type GetIamPolicyRequest struct {
	// Options: OPTIONAL: A `GetPolicyOptions` object for specifying options to
	// `GetIamPolicy`.
	Options *GetPolicyOptions `json:"options,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Options") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Options") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetPolicyOptions: Encapsulates settings provided to GetIamPolicy.
type GetPolicyOptions struct {
	// RequestedPolicyVersion: Optional. The maximum policy version that will be
	// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
	// an invalid value will be rejected. Requests for policies with any
	// conditional role bindings must specify version 3. Policies with no
	// conditional role bindings may specify any valid value or leave the field
	// unset. The policy in the response might use the policy version that you
	// specified, or it might use a lower policy version. For example, if you
	// specify version 3, but the policy has no conditional role bindings, the
	// response uses version 1. To learn which resources support conditions in
	// their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	RequestedPolicyVersion int64 `json:"requestedPolicyVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestedPolicyVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestedPolicyVersion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetPolicyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GetPolicyOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetQueryResultsResponse: Response object of GetQueryResults.
type GetQueryResultsResponse struct {
	// CacheHit: Whether the query result was fetched from the query cache.
	CacheHit bool `json:"cacheHit,omitempty"`
	// Errors: Output only. The first errors or warnings encountered during the
	// running of the job. The final message includes the number of errors that
	// caused the process to stop. Errors here do not necessarily mean that the job
	// has completed or was unsuccessful. For more information about error
	// messages, see Error messages
	// (https://cloud.google.com/bigquery/docs/error-messages).
	Errors []*ErrorProto `json:"errors,omitempty"`
	// Etag: A hash of this response.
	Etag string `json:"etag,omitempty"`
	// JobComplete: Whether the query has completed or not. If rows or totalRows
	// are present, this will always be true. If this is false, totalRows will not
	// be available.
	JobComplete bool `json:"jobComplete,omitempty"`
	// JobReference: Reference to the BigQuery Job that was created to run the
	// query. This field will be present even if the original request timed out, in
	// which case GetQueryResults can be used to read the results once the query
	// has completed. Since this API only returns the first page of results,
	// subsequent pages can be fetched via the same mechanism (GetQueryResults).
	JobReference *JobReference `json:"jobReference,omitempty"`
	// Kind: The resource type of the response.
	Kind string `json:"kind,omitempty"`
	// NumDmlAffectedRows: Output only. The number of rows affected by a DML
	// statement. Present only for DML statements INSERT, UPDATE or DELETE.
	NumDmlAffectedRows int64 `json:"numDmlAffectedRows,omitempty,string"`
	// PageToken: A token used for paging results. When this token is non-empty, it
	// indicates additional results are available.
	PageToken string `json:"pageToken,omitempty"`
	// Rows: An object with as many results as can be contained within the maximum
	// permitted reply size. To get any additional rows, you can call
	// GetQueryResults and specify the jobReference returned above. Present only
	// when the query completes successfully. The REST-based representation of this
	// data leverages a series of JSON f,v objects for indicating fields and
	// values.
	Rows []*TableRow `json:"rows,omitempty"`
	// Schema: The schema of the results. Present only when the query completes
	// successfully.
	Schema *TableSchema `json:"schema,omitempty"`
	// TotalBytesProcessed: The total number of bytes processed for this query.
	TotalBytesProcessed int64 `json:"totalBytesProcessed,omitempty,string"`
	// TotalRows: The total number of rows in the complete query result set, which
	// can be more than the number of rows in this single page of results. Present
	// only when the query completes successfully.
	TotalRows uint64 `json:"totalRows,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CacheHit") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CacheHit") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetQueryResultsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetQueryResultsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetServiceAccountResponse: Response object of GetServiceAccount
type GetServiceAccountResponse struct {
	// Email: The service account email address.
	Email string `json:"email,omitempty"`
	// Kind: The resource type of the response.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Email") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Email") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetServiceAccountResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetServiceAccountResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GlobalExplanation: Global explanations containing the top most important
// features after training.
type GlobalExplanation struct {
	// ClassLabel: Class label for this set of global explanations. Will be
	// empty/null for binary logistic and linear regression models. Sorted
	// alphabetically in descending order.
	ClassLabel string `json:"classLabel,omitempty"`
	// Explanations: A list of the top global explanations. Sorted by absolute
	// value of attribution in descending order.
	Explanations []*Explanation `json:"explanations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClassLabel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClassLabel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GlobalExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GlobalExplanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleSheetsOptions: Options specific to Google Sheets data sources.
type GoogleSheetsOptions struct {
	// Range: Optional. Range of a sheet to query from. Only used when non-empty.
	// Typical format: sheet_name!top_left_cell_id:bottom_right_cell_id For
	// example: sheet1!A1:B20
	Range string `json:"range,omitempty"`
	// SkipLeadingRows: Optional. The number of rows at the top of a sheet that
	// BigQuery will skip when reading the data. The default value is 0. This
	// property is useful if you have header rows that should be skipped. When
	// autodetect is on, the behavior is the following: * skipLeadingRows
	// unspecified - Autodetect tries to detect headers in the first row. If they
	// are not detected, the row is read as data. Otherwise data is read starting
	// from the second row. * skipLeadingRows is 0 - Instructs autodetect that
	// there are no headers and data should be read starting from the first row. *
	// skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect
	// headers in row N. If headers are not detected, row N is just skipped.
	// Otherwise row N is used to extract column names for the detected schema.
	SkipLeadingRows int64 `json:"skipLeadingRows,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Range") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Range") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleSheetsOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleSheetsOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HighCardinalityJoin: High cardinality join detailed information.
type HighCardinalityJoin struct {
	// LeftRows: Output only. Count of left input rows.
	LeftRows int64 `json:"leftRows,omitempty,string"`
	// OutputRows: Output only. Count of the output rows.
	OutputRows int64 `json:"outputRows,omitempty,string"`
	// RightRows: Output only. Count of right input rows.
	RightRows int64 `json:"rightRows,omitempty,string"`
	// StepIndex: Output only. The index of the join operator in the
	// ExplainQueryStep lists.
	StepIndex int64 `json:"stepIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LeftRows") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LeftRows") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HighCardinalityJoin) MarshalJSON() ([]byte, error) {
	type NoMethod HighCardinalityJoin
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HivePartitioningOptions: Options for configuring hive partitioning detect.
type HivePartitioningOptions struct {
	// Fields: Output only. For permanent external tables, this field is populated
	// with the hive partition keys in the order they were inferred. The types of
	// the partition keys can be deduced by checking the table schema (which will
	// include the partition keys). Not every API will populate this field in the
	// output. For example, Tables.Get will populate it, but Tables.List will not
	// contain this field.
	Fields []string `json:"fields,omitempty"`
	// Mode: Optional. When set, what mode of hive partitioning to use when reading
	// data. The following modes are supported: * AUTO: automatically infer
	// partition key name(s) and type(s). * STRINGS: automatically infer partition
	// key name(s). All types are strings. * CUSTOM: partition key schema is
	// encoded in the source URI prefix. Not all storage formats support hive
	// partitioning. Requesting hive partitioning on an unsupported format will
	// lead to an error. Currently supported formats are: JSON, CSV, ORC, Avro and
	// Parquet.
	Mode string `json:"mode,omitempty"`
	// RequirePartitionFilter: Optional. If set to true, queries over this table
	// require a partition filter that can be used for partition elimination to be
	// specified. Note that this field should only be true when creating a
	// permanent external table or querying a temporary external table.
	// Hive-partitioned loads with require_partition_filter explicitly set to true
	// will fail.
	RequirePartitionFilter bool `json:"requirePartitionFilter,omitempty"`
	// SourceUriPrefix: Optional. When hive partition detection is requested, a
	// common prefix for all source uris must be required. The prefix must end
	// immediately before the partition key encoding begins. For example, consider
	// files following this data layout:
	// gs://bucket/path_to_table/dt=2019-06-01/country=USA/id=7/file.avro
	// gs://bucket/path_to_table/dt=2019-05-31/country=CA/id=3/file.avro When hive
	// partitioning is requested with either AUTO or STRINGS detection, the common
	// prefix can be either of gs://bucket/path_to_table or
	// gs://bucket/path_to_table/. CUSTOM detection requires encoding the
	// partitioning schema immediately after the common prefix. For CUSTOM, any of
	// * gs://bucket/path_to_table/{dt:DATE}/{country:STRING}/{id:INTEGER} *
	// gs://bucket/path_to_table/{dt:STRING}/{country:STRING}/{id:INTEGER} *
	// gs://bucket/path_to_table/{dt:DATE}/{country:STRING}/{id:STRING} would all
	// be valid source URI prefixes.
	SourceUriPrefix string `json:"sourceUriPrefix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fields") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HivePartitioningOptions) MarshalJSON() ([]byte, error) {
	type NoMethod HivePartitioningOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HparamSearchSpaces: Hyperparameter search spaces. These should be a subset
// of training_options.
type HparamSearchSpaces struct {
	// ActivationFn: Activation functions of neural network models.
	ActivationFn *StringHparamSearchSpace `json:"activationFn,omitempty"`
	// BatchSize: Mini batch sample size.
	BatchSize *IntHparamSearchSpace `json:"batchSize,omitempty"`
	// BoosterType: Booster type for boosted tree models.
	BoosterType *StringHparamSearchSpace `json:"boosterType,omitempty"`
	// ColsampleBylevel: Subsample ratio of columns for each level for boosted tree
	// models.
	ColsampleBylevel *DoubleHparamSearchSpace `json:"colsampleBylevel,omitempty"`
	// ColsampleBynode: Subsample ratio of columns for each node(split) for boosted
	// tree models.
	ColsampleBynode *DoubleHparamSearchSpace `json:"colsampleBynode,omitempty"`
	// ColsampleBytree: Subsample ratio of columns when constructing each tree for
	// boosted tree models.
	ColsampleBytree *DoubleHparamSearchSpace `json:"colsampleBytree,omitempty"`
	// DartNormalizeType: Dart normalization type for boosted tree models.
	DartNormalizeType *StringHparamSearchSpace `json:"dartNormalizeType,omitempty"`
	// Dropout: Dropout probability for dnn model training and boosted tree models
	// using dart booster.
	Dropout *DoubleHparamSearchSpace `json:"dropout,omitempty"`
	// HiddenUnits: Hidden units for neural network models.
	HiddenUnits *IntArrayHparamSearchSpace `json:"hiddenUnits,omitempty"`
	// L1Reg: L1 regularization coefficient.
	L1Reg *DoubleHparamSearchSpace `json:"l1Reg,omitempty"`
	// L2Reg: L2 regularization coefficient.
	L2Reg *DoubleHparamSearchSpace `json:"l2Reg,omitempty"`
	// LearnRate: Learning rate of training jobs.
	LearnRate *DoubleHparamSearchSpace `json:"learnRate,omitempty"`
	// MaxTreeDepth: Maximum depth of a tree for boosted tree models.
	MaxTreeDepth *IntHparamSearchSpace `json:"maxTreeDepth,omitempty"`
	// MinSplitLoss: Minimum split loss for boosted tree models.
	MinSplitLoss *DoubleHparamSearchSpace `json:"minSplitLoss,omitempty"`
	// MinTreeChildWeight: Minimum sum of instance weight needed in a child for
	// boosted tree models.
	MinTreeChildWeight *IntHparamSearchSpace `json:"minTreeChildWeight,omitempty"`
	// NumClusters: Number of clusters for k-means.
	NumClusters *IntHparamSearchSpace `json:"numClusters,omitempty"`
	// NumFactors: Number of latent factors to train on.
	NumFactors *IntHparamSearchSpace `json:"numFactors,omitempty"`
	// NumParallelTree: Number of parallel trees for boosted tree models.
	NumParallelTree *IntHparamSearchSpace `json:"numParallelTree,omitempty"`
	// Optimizer: Optimizer of TF models.
	Optimizer *StringHparamSearchSpace `json:"optimizer,omitempty"`
	// Subsample: Subsample the training data to grow tree to prevent overfitting
	// for boosted tree models.
	Subsample *DoubleHparamSearchSpace `json:"subsample,omitempty"`
	// TreeMethod: Tree construction algorithm for boosted tree models.
	TreeMethod *StringHparamSearchSpace `json:"treeMethod,omitempty"`
	// WalsAlpha: Hyperparameter for matrix factoration when implicit feedback type
	// is specified.
	WalsAlpha *DoubleHparamSearchSpace `json:"walsAlpha,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActivationFn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActivationFn") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HparamSearchSpaces) MarshalJSON() ([]byte, error) {
	type NoMethod HparamSearchSpaces
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HparamTuningTrial: Training info of a trial in hyperparameter tuning
// (https://cloud.google.com/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview)
// models.
type HparamTuningTrial struct {
	// EndTimeMs: Ending time of the trial.
	EndTimeMs int64 `json:"endTimeMs,omitempty,string"`
	// ErrorMessage: Error message for FAILED and INFEASIBLE trial.
	ErrorMessage string `json:"errorMessage,omitempty"`
	// EvalLoss: Loss computed on the eval data at the end of trial.
	EvalLoss float64 `json:"evalLoss,omitempty"`
	// EvaluationMetrics: Evaluation metrics of this trial calculated on the test
	// data. Empty in Job API.
	EvaluationMetrics *EvaluationMetrics `json:"evaluationMetrics,omitempty"`
	// HparamTuningEvaluationMetrics: Hyperparameter tuning evaluation metrics of
	// this trial calculated on the eval data. Unlike evaluation_metrics, only the
	// fields corresponding to the hparam_tuning_objectives are set.
	HparamTuningEvaluationMetrics *EvaluationMetrics `json:"hparamTuningEvaluationMetrics,omitempty"`
	// Hparams: The hyperprameters selected for this trial.
	Hparams *TrainingOptions `json:"hparams,omitempty"`
	// StartTimeMs: Starting time of the trial.
	StartTimeMs int64 `json:"startTimeMs,omitempty,string"`
	// Status: The status of the trial.
	//
	// Possible values:
	//   "TRIAL_STATUS_UNSPECIFIED" - Default value.
	//   "NOT_STARTED" - Scheduled but not started.
	//   "RUNNING" - Running state.
	//   "SUCCEEDED" - The trial succeeded.
	//   "FAILED" - The trial failed.
	//   "INFEASIBLE" - The trial is infeasible due to the invalid params.
	//   "STOPPED_EARLY" - Trial stopped early because it's not promising.
	Status string `json:"status,omitempty"`
	// TrainingLoss: Loss computed on the training data at the end of trial.
	TrainingLoss float64 `json:"trainingLoss,omitempty"`
	// TrialId: 1-based index of the trial.
	TrialId int64 `json:"trialId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EndTimeMs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTimeMs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HparamTuningTrial) MarshalJSON() ([]byte, error) {
	type NoMethod HparamTuningTrial
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *HparamTuningTrial) UnmarshalJSON(data []byte) error {
	type NoMethod HparamTuningTrial
	var s1 struct {
		EvalLoss     gensupport.JSONFloat64 `json:"evalLoss"`
		TrainingLoss gensupport.JSONFloat64 `json:"trainingLoss"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.EvalLoss = float64(s1.EvalLoss)
	s.TrainingLoss = float64(s1.TrainingLoss)
	return nil
}

// IndexUnusedReason: Reason about why no search index was used in the search
// query (or sub-query).
type IndexUnusedReason struct {
	// BaseTable: Specifies the base table involved in the reason that no search
	// index was used.
	BaseTable *TableReference `json:"baseTable,omitempty"`
	// Code: Specifies the high-level reason for the scenario when no search index
	// was used.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - Code not specified.
	//   "INDEX_CONFIG_NOT_AVAILABLE" - Indicates the search index configuration
	// has not been created.
	//   "PENDING_INDEX_CREATION" - Indicates the search index creation has not
	// been completed.
	//   "BASE_TABLE_TRUNCATED" - Indicates the base table has been truncated (rows
	// have been removed from table with TRUNCATE TABLE statement) since the last
	// time the search index was refreshed.
	//   "INDEX_CONFIG_MODIFIED" - Indicates the search index configuration has
	// been changed since the last time the search index was refreshed.
	//   "TIME_TRAVEL_QUERY" - Indicates the search query accesses data at a
	// timestamp before the last time the search index was refreshed.
	//   "NO_PRUNING_POWER" - Indicates the usage of search index will not
	// contribute to any pruning improvement for the search function, e.g. when the
	// search predicate is in a disjunction with other non-search predicates.
	//   "UNINDEXED_SEARCH_FIELDS" - Indicates the search index does not cover all
	// fields in the search function.
	//   "UNSUPPORTED_SEARCH_PATTERN" - Indicates the search index does not support
	// the given search query pattern.
	//   "OPTIMIZED_WITH_MATERIALIZED_VIEW" - Indicates the query has been
	// optimized by using a materialized view.
	//   "SECURED_BY_DATA_MASKING" - Indicates the query has been secured by data
	// masking, and thus search indexes are not applicable.
	//   "MISMATCHED_TEXT_ANALYZER" - Indicates that the search index and the
	// search function call do not have the same text analyzer.
	//   "BASE_TABLE_TOO_SMALL" - Indicates the base table is too small (below a
	// certain threshold). The index does not provide noticeable search performance
	// gains when the base table is too small.
	//   "BASE_TABLE_TOO_LARGE" - Indicates that the total size of indexed base
	// tables in your organization exceeds your region's limit and the index is not
	// used in the query. To index larger base tables, you can use your own
	// reservation for index-management jobs.
	//   "ESTIMATED_PERFORMANCE_GAIN_TOO_LOW" - Indicates that the estimated
	// performance gain from using the search index is too low for the given search
	// query.
	//   "COLUMN_METADATA_INDEX_NOT_USED" - Indicates that the column metadata
	// index (which the search index depends on) is not used. User can refer to the
	// [column metadata index
	// usage](https://cloud.google.com/bigquery/docs/metadata-indexing-managed-table
	// s#view_column_metadata_index_usage) for more details on why it was not used.
	//   "NOT_SUPPORTED_IN_STANDARD_EDITION" - Indicates that search indexes can
	// not be used for search query with STANDARD edition.
	//   "INDEX_SUPPRESSED_BY_FUNCTION_OPTION" - Indicates that an option in the
	// search function that cannot make use of the index has been selected.
	//   "QUERY_CACHE_HIT" - Indicates that the query was cached, and thus the
	// search index was not used.
	//   "STALE_INDEX" - The index cannot be used in the search query because it is
	// stale.
	//   "INTERNAL_ERROR" - Indicates an internal error that causes the search
	// index to be unused.
	//   "OTHER_REASON" - Indicates that the reason search indexes cannot be used
	// in the query is not covered by any of the other IndexUnusedReason options.
	Code string `json:"code,omitempty"`
	// IndexName: Specifies the name of the unused search index, if available.
	IndexName string `json:"indexName,omitempty"`
	// Message: Free form human-readable reason for the scenario when no search
	// index was used.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseTable") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseTable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IndexUnusedReason) MarshalJSON() ([]byte, error) {
	type NoMethod IndexUnusedReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputDataChange: Details about the input data change insight.
type InputDataChange struct {
	// RecordsReadDiffPercentage: Output only. Records read difference percentage
	// compared to a previous run.
	RecordsReadDiffPercentage float64 `json:"recordsReadDiffPercentage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RecordsReadDiffPercentage")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RecordsReadDiffPercentage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputDataChange) MarshalJSON() ([]byte, error) {
	type NoMethod InputDataChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *InputDataChange) UnmarshalJSON(data []byte) error {
	type NoMethod InputDataChange
	var s1 struct {
		RecordsReadDiffPercentage gensupport.JSONFloat64 `json:"recordsReadDiffPercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RecordsReadDiffPercentage = float64(s1.RecordsReadDiffPercentage)
	return nil
}

// IntArray: An array of int.
type IntArray struct {
	// Elements: Elements in the int array.
	Elements googleapi.Int64s `json:"elements,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Elements") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Elements") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IntArray) MarshalJSON() ([]byte, error) {
	type NoMethod IntArray
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IntArrayHparamSearchSpace: Search space for int array.
type IntArrayHparamSearchSpace struct {
	// Candidates: Candidates for the int array parameter.
	Candidates []*IntArray `json:"candidates,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IntArrayHparamSearchSpace) MarshalJSON() ([]byte, error) {
	type NoMethod IntArrayHparamSearchSpace
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IntCandidates: Discrete candidates of an int hyperparameter.
type IntCandidates struct {
	// Candidates: Candidates for the int parameter in increasing order.
	Candidates googleapi.Int64s `json:"candidates,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IntCandidates) MarshalJSON() ([]byte, error) {
	type NoMethod IntCandidates
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IntHparamSearchSpace: Search space for an int hyperparameter.
type IntHparamSearchSpace struct {
	// Candidates: Candidates of the int hyperparameter.
	Candidates *IntCandidates `json:"candidates,omitempty"`
	// Range: Range of the int hyperparameter.
	Range *IntRange `json:"range,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IntHparamSearchSpace) MarshalJSON() ([]byte, error) {
	type NoMethod IntHparamSearchSpace
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IntRange: Range of an int hyperparameter.
type IntRange struct {
	// Max: Max value of the int parameter.
	Max int64 `json:"max,omitempty,string"`
	// Min: Min value of the int parameter.
	Min int64 `json:"min,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Max") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Max") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IntRange) MarshalJSON() ([]byte, error) {
	type NoMethod IntRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IterationResult: Information about a single iteration of the training run.
type IterationResult struct {
	// ArimaResult: Arima result.
	ArimaResult *ArimaResult `json:"arimaResult,omitempty"`
	// ClusterInfos: Information about top clusters for clustering models.
	ClusterInfos []*ClusterInfo `json:"clusterInfos,omitempty"`
	// DurationMs: Time taken to run the iteration in milliseconds.
	DurationMs int64 `json:"durationMs,omitempty,string"`
	// EvalLoss: Loss computed on the eval data at the end of iteration.
	EvalLoss float64 `json:"evalLoss,omitempty"`
	// Index: Index of the iteration, 0 based.
	Index int64 `json:"index,omitempty"`
	// LearnRate: Learn rate used for this iteration.
	LearnRate float64 `json:"learnRate,omitempty"`
	// PrincipalComponentInfos: The information of the principal components.
	PrincipalComponentInfos []*PrincipalComponentInfo `json:"principalComponentInfos,omitempty"`
	// TrainingLoss: Loss computed on the training data at the end of iteration.
	TrainingLoss float64 `json:"trainingLoss,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArimaResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArimaResult") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IterationResult) MarshalJSON() ([]byte, error) {
	type NoMethod IterationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *IterationResult) UnmarshalJSON(data []byte) error {
	type NoMethod IterationResult
	var s1 struct {
		EvalLoss     gensupport.JSONFloat64 `json:"evalLoss"`
		LearnRate    gensupport.JSONFloat64 `json:"learnRate"`
		TrainingLoss gensupport.JSONFloat64 `json:"trainingLoss"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.EvalLoss = float64(s1.EvalLoss)
	s.LearnRate = float64(s1.LearnRate)
	s.TrainingLoss = float64(s1.TrainingLoss)
	return nil
}

type Job struct {
	// Configuration: Required. Describes the job configuration.
	Configuration *JobConfiguration `json:"configuration,omitempty"`
	// Etag: Output only. A hash of this resource.
	Etag string `json:"etag,omitempty"`
	// Id: Output only. Opaque ID field of the job.
	Id string `json:"id,omitempty"`
	// JobCreationReason: Output only. The reason why a Job was created.
	JobCreationReason *JobCreationReason `json:"jobCreationReason,omitempty"`
	// JobReference: Optional. Reference describing the unique-per-user name of the
	// job.
	JobReference *JobReference `json:"jobReference,omitempty"`
	// Kind: Output only. The type of the resource.
	Kind string `json:"kind,omitempty"`
	// PrincipalSubject: Output only. [Full-projection-only] String representation
	// of identity of requesting party. Populated for both first- and third-party
	// identities. Only present for APIs that support third-party identities.
	PrincipalSubject string `json:"principal_subject,omitempty"`
	// SelfLink: Output only. A URL that can be used to access the resource again.
	SelfLink string `json:"selfLink,omitempty"`
	// Statistics: Output only. Information about the job, including starting time
	// and ending time of the job.
	Statistics *JobStatistics `json:"statistics,omitempty"`
	// Status: Output only. The status of this job. Examine this value when polling
	// an asynchronous job to see if the job is complete.
	Status *JobStatus `json:"status,omitempty"`
	// UserEmail: Output only. Email address of the user who ran the job.
	UserEmail string `json:"user_email,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Configuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Configuration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Job) MarshalJSON() ([]byte, error) {
	type NoMethod Job
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobCancelResponse: Describes format of a jobs cancellation response.
type JobCancelResponse struct {
	// Job: The final state of the job.
	Job *Job `json:"job,omitempty"`
	// Kind: The resource type of the response.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Job") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Job") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobCancelResponse) MarshalJSON() ([]byte, error) {
	type NoMethod JobCancelResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type JobConfiguration struct {
	// Copy: [Pick one] Copies a table.
	Copy *JobConfigurationTableCopy `json:"copy,omitempty"`
	// DryRun: Optional. If set, don't actually run this job. A valid query will
	// return a mostly empty response with some processing statistics, while an
	// invalid query will return the same error it would if it wasn't a dry run.
	// Behavior of non-query jobs is undefined.
	DryRun bool `json:"dryRun,omitempty"`
	// Extract: [Pick one] Configures an extract job.
	Extract *JobConfigurationExtract `json:"extract,omitempty"`
	// JobTimeoutMs: Optional. Job timeout in milliseconds. If this time limit is
	// exceeded, BigQuery will attempt to stop a longer job, but may not always
	// succeed in canceling it before the job completes. For example, a job that
	// takes more than 60 seconds to complete has a better chance of being stopped
	// than a job that takes 10 seconds to complete.
	JobTimeoutMs int64 `json:"jobTimeoutMs,omitempty,string"`
	// JobType: Output only. The type of the job. Can be QUERY, LOAD, EXTRACT, COPY
	// or UNKNOWN.
	JobType string `json:"jobType,omitempty"`
	// Labels: The labels associated with this job. You can use these to organize
	// and group your jobs. Label keys and values can be no longer than 63
	// characters, can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. Label values
	// are optional. Label keys must start with a letter and each label in the list
	// must have a different key.
	Labels map[string]string `json:"labels,omitempty"`
	// Load: [Pick one] Configures a load job.
	Load *JobConfigurationLoad `json:"load,omitempty"`
	// Query: [Pick one] Configures a query job.
	Query *JobConfigurationQuery `json:"query,omitempty"`
	// Reservation: Optional. The reservation that job would use. User can specify
	// a reservation to execute the job. If reservation is not set, reservation is
	// determined based on the rules defined by the reservation assignments. The
	// expected format is
	// `projects/{project}/locations/{location}/reservations/{reservation}`.
	Reservation string `json:"reservation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Copy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Copy") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod JobConfiguration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobConfigurationExtract: JobConfigurationExtract configures a job that
// exports data from a BigQuery table into Google Cloud Storage.
type JobConfigurationExtract struct {
	// Compression: Optional. The compression type to use for exported files.
	// Possible values include DEFLATE, GZIP, NONE, SNAPPY, and ZSTD. The default
	// value is NONE. Not all compression formats are support for all file formats.
	// DEFLATE is only supported for Avro. ZSTD is only supported for Parquet. Not
	// applicable when extracting models.
	Compression string `json:"compression,omitempty"`
	// DestinationFormat: Optional. The exported file format. Possible values
	// include CSV, NEWLINE_DELIMITED_JSON, PARQUET, or AVRO for tables and
	// ML_TF_SAVED_MODEL or ML_XGBOOST_BOOSTER for models. The default value for
	// tables is CSV. Tables with nested or repeated fields cannot be exported as
	// CSV. The default value for models is ML_TF_SAVED_MODEL.
	DestinationFormat string `json:"destinationFormat,omitempty"`
	// DestinationUri: [Pick one] DEPRECATED: Use destinationUris instead, passing
	// only one URI as necessary. The fully-qualified Google Cloud Storage URI
	// where the extracted table should be written.
	DestinationUri string `json:"destinationUri,omitempty"`
	// DestinationUris: [Pick one] A list of fully-qualified Google Cloud Storage
	// URIs where the extracted table should be written.
	DestinationUris []string `json:"destinationUris,omitempty"`
	// FieldDelimiter: Optional. When extracting data in CSV format, this defines
	// the delimiter to use between fields in the exported data. Default is ','.
	// Not applicable when extracting models.
	FieldDelimiter string `json:"fieldDelimiter,omitempty"`
	// ModelExtractOptions: Optional. Model extract options only applicable when
	// extracting models.
	ModelExtractOptions *ModelExtractOptions `json:"modelExtractOptions,omitempty"`
	// PrintHeader: Optional. Whether to print out a header row in the results.
	// Default is true. Not applicable when extracting models.
	//
	// Default: true
	PrintHeader *bool `json:"printHeader,omitempty"`
	// SourceModel: A reference to the model being exported.
	SourceModel *ModelReference `json:"sourceModel,omitempty"`
	// SourceTable: A reference to the table being exported.
	SourceTable *TableReference `json:"sourceTable,omitempty"`
	// UseAvroLogicalTypes: Whether to use logical types when extracting to AVRO
	// format. Not applicable when extracting models.
	UseAvroLogicalTypes bool `json:"useAvroLogicalTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Compression") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Compression") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobConfigurationExtract) MarshalJSON() ([]byte, error) {
	type NoMethod JobConfigurationExtract
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobConfigurationLoad: JobConfigurationLoad contains the configuration
// properties for loading data into a destination table.
type JobConfigurationLoad struct {
	// AllowJaggedRows: Optional. Accept rows that are missing trailing optional
	// columns. The missing values are treated as nulls. If false, records with
	// missing trailing columns are treated as bad records, and if there are too
	// many bad records, an invalid error is returned in the job result. The
	// default value is false. Only applicable to CSV, ignored for other formats.
	AllowJaggedRows bool `json:"allowJaggedRows,omitempty"`
	// AllowQuotedNewlines: Indicates if BigQuery should allow quoted data sections
	// that contain newline characters in a CSV file. The default value is false.
	AllowQuotedNewlines bool `json:"allowQuotedNewlines,omitempty"`
	// Autodetect: Optional. Indicates if we should automatically infer the options
	// and schema for CSV and JSON sources.
	Autodetect bool `json:"autodetect,omitempty"`
	// Clustering: Clustering specification for the destination table.
	Clustering *Clustering `json:"clustering,omitempty"`
	// ColumnNameCharacterMap: Optional. Character map supported for column names
	// in CSV/Parquet loads. Defaults to STRICT and can be overridden by Project
	// Config Service. Using this option with unsupporting load formats will result
	// in an error.
	//
	// Possible values:
	//   "COLUMN_NAME_CHARACTER_MAP_UNSPECIFIED" - Unspecified column name
	// character map.
	//   "STRICT" - Support flexible column name and reject invalid column names.
	//   "V1" - Support alphanumeric + underscore characters and names must start
	// with a letter or underscore. Invalid column names will be normalized.
	//   "V2" - Support flexible column name. Invalid column names will be
	// normalized.
	ColumnNameCharacterMap string `json:"columnNameCharacterMap,omitempty"`
	// ConnectionProperties: Optional. Connection properties which can modify the
	// load job behavior. Currently, only the 'session_id' connection property is
	// supported, and is used to resolve _SESSION appearing as the dataset id.
	ConnectionProperties []*ConnectionProperty `json:"connectionProperties,omitempty"`
	// CopyFilesOnly: Optional. [Experimental] Configures the load job to copy
	// files directly to the destination BigLake managed table, bypassing file
	// content reading and rewriting. Copying files only is supported when all the
	// following are true: * `source_uris` are located in the same Cloud Storage
	// location as the destination table's `storage_uri` location. *
	// `source_format` is `PARQUET`. * `destination_table` is an existing BigLake
	// managed table. The table's schema does not have flexible column names. The
	// table's columns do not have type parameters other than precision and scale.
	// * No options other than the above are specified.
	CopyFilesOnly bool `json:"copyFilesOnly,omitempty"`
	// CreateDisposition: Optional. Specifies whether the job is allowed to create
	// new tables. The following values are supported: * CREATE_IF_NEEDED: If the
	// table does not exist, BigQuery creates the table. * CREATE_NEVER: The table
	// must already exist. If it does not, a 'notFound' error is returned in the
	// job result. The default value is CREATE_IF_NEEDED. Creation, truncation and
	// append actions occur as one atomic update upon job completion.
	CreateDisposition string `json:"createDisposition,omitempty"`
	// CreateSession: Optional. If this property is true, the job creates a new
	// session using a randomly generated session_id. To continue using a created
	// session with subsequent queries, pass the existing session identifier as a
	// `ConnectionProperty` value. The session identifier is returned as part of
	// the `SessionInfo` message within the query statistics. The new session's
	// location will be set to `Job.JobReference.location` if it is present,
	// otherwise it's set to the default location based on existing routing logic.
	CreateSession bool `json:"createSession,omitempty"`
	// DateFormat: Optional. Date format used for parsing DATE values.
	DateFormat string `json:"dateFormat,omitempty"`
	// DatetimeFormat: Optional. Date format used for parsing DATETIME values.
	DatetimeFormat string `json:"datetimeFormat,omitempty"`
	// DecimalTargetTypes: Defines the list of possible SQL data types to which the
	// source decimal values are converted. This list and the precision and the
	// scale parameters of the decimal field determine the target type. In the
	// order of NUMERIC, BIGNUMERIC, and STRING, a type is picked if it is in the
	// specified list and if it supports the precision and the scale. STRING
	// supports all precision and scale values. If none of the listed types
	// supports the precision and the scale, the type supporting the widest range
	// in the specified list is picked, and if a value exceeds the supported range
	// when reading the data, an error will be thrown. Example: Suppose the value
	// of this field is ["NUMERIC", "BIGNUMERIC"]. If (precision,scale) is: *
	// (38,9) -> NUMERIC; * (39,9) -> BIGNUMERIC (NUMERIC cannot hold 30 integer
	// digits); * (38,10) -> BIGNUMERIC (NUMERIC cannot hold 10 fractional digits);
	// * (76,38) -> BIGNUMERIC; * (77,38) -> BIGNUMERIC (error if value exceeds
	// supported range). This field cannot contain duplicate types. The order of
	// the types in this field is ignored. For example, ["BIGNUMERIC", "NUMERIC"]
	// is the same as ["NUMERIC", "BIGNUMERIC"] and NUMERIC always takes precedence
	// over BIGNUMERIC. Defaults to ["NUMERIC", "STRING"] for ORC and ["NUMERIC"]
	// for the other file formats.
	//
	// Possible values:
	//   "DECIMAL_TARGET_TYPE_UNSPECIFIED" - Invalid type.
	//   "NUMERIC" - Decimal values could be converted to NUMERIC type.
	//   "BIGNUMERIC" - Decimal values could be converted to BIGNUMERIC type.
	//   "STRING" - Decimal values could be converted to STRING type.
	DecimalTargetTypes []string `json:"decimalTargetTypes,omitempty"`
	// DestinationEncryptionConfiguration: Custom encryption configuration (e.g.,
	// Cloud KMS keys)
	DestinationEncryptionConfiguration *EncryptionConfiguration `json:"destinationEncryptionConfiguration,omitempty"`
	// DestinationTable: [Required] The destination table to load the data into.
	DestinationTable *TableReference `json:"destinationTable,omitempty"`
	// DestinationTableProperties: Optional. [Experimental] Properties with which
	// to create the destination table if it is new.
	DestinationTableProperties *DestinationTableProperties `json:"destinationTableProperties,omitempty"`
	// Encoding: Optional. The character encoding of the data. The supported values
	// are UTF-8, ISO-8859-1, UTF-16BE, UTF-16LE, UTF-32BE, and UTF-32LE. The
	// default value is UTF-8. BigQuery decodes the data after the raw, binary data
	// has been split using the values of the `quote` and `fieldDelimiter`
	// properties. If you don't specify an encoding, or if you specify a UTF-8
	// encoding when the CSV file is not UTF-8 encoded, BigQuery attempts to
	// convert the data to UTF-8. Generally, your data loads successfully, but it
	// may not match byte-for-byte what you expect. To avoid this, specify the
	// correct encoding by using the `--encoding` flag. If BigQuery can't convert a
	// character other than the ASCII `0` character, BigQuery converts the
	// character to the standard Unicode replacement character: �.
	Encoding string `json:"encoding,omitempty"`
	// FieldDelimiter: Optional. The separator character for fields in a CSV file.
	// The separator is interpreted as a single byte. For files encoded in
	// ISO-8859-1, any single character can be used as a separator. For files
	// encoded in UTF-8, characters represented in decimal range 1-127
	// (U+0001-U+007F) can be used without any modification. UTF-8 characters
	// encoded with multiple bytes (i.e. U+0080 and above) will have only the first
	// byte used for separating fields. The remaining bytes will be treated as a
	// part of the field. BigQuery also supports the escape sequence "\t" (U+0009)
	// to specify a tab separator. The default value is comma (",", U+002C).
	FieldDelimiter string `json:"fieldDelimiter,omitempty"`
	// FileSetSpecType: Optional. Specifies how source URIs are interpreted for
	// constructing the file set to load. By default, source URIs are expanded
	// against the underlying storage. You can also specify manifest files to
	// control how the file set is constructed. This option is only applicable to
	// object storage systems.
	//
	// Possible values:
	//   "FILE_SET_SPEC_TYPE_FILE_SYSTEM_MATCH" - This option expands source URIs
	// by listing files from the object store. It is the default behavior if
	// FileSetSpecType is not set.
	//   "FILE_SET_SPEC_TYPE_NEW_LINE_DELIMITED_MANIFEST" - This option indicates
	// that the provided URIs are newline-delimited manifest files, with one URI
	// per line. Wildcard URIs are not supported.
	FileSetSpecType string `json:"fileSetSpecType,omitempty"`
	// HivePartitioningOptions: Optional. When set, configures hive partitioning
	// support. Not all storage formats support hive partitioning -- requesting
	// hive partitioning on an unsupported format will lead to an error, as will
	// providing an invalid specification.
	HivePartitioningOptions *HivePartitioningOptions `json:"hivePartitioningOptions,omitempty"`
	// IgnoreUnknownValues: Optional. Indicates if BigQuery should allow extra
	// values that are not represented in the table schema. If true, the extra
	// values are ignored. If false, records with extra columns are treated as bad
	// records, and if there are too many bad records, an invalid error is returned
	// in the job result. The default value is false. The sourceFormat property
	// determines what BigQuery treats as an extra value: CSV: Trailing columns
	// JSON: Named values that don't match any column names in the table schema
	// Avro, Parquet, ORC: Fields in the file schema that don't exist in the table
	// schema.
	IgnoreUnknownValues bool `json:"ignoreUnknownValues,omitempty"`
	// JsonExtension: Optional. Load option to be used together with source_format
	// newline-delimited JSON to indicate that a variant of JSON is being loaded.
	// To load newline-delimited GeoJSON, specify GEOJSON (and source_format must
	// be set to NEWLINE_DELIMITED_JSON).
	//
	// Possible values:
	//   "JSON_EXTENSION_UNSPECIFIED" - The default if provided value is not one
	// included in the enum, or the value is not specified. The source format is
	// parsed without any modification.
	//   "GEOJSON" - Use GeoJSON variant of JSON. See
	// https://tools.ietf.org/html/rfc7946.
	JsonExtension string `json:"jsonExtension,omitempty"`
	// MaxBadRecords: Optional. The maximum number of bad records that BigQuery can
	// ignore when running the job. If the number of bad records exceeds this
	// value, an invalid error is returned in the job result. The default value is
	// 0, which requires that all records are valid. This is only supported for CSV
	// and NEWLINE_DELIMITED_JSON file formats.
	MaxBadRecords int64 `json:"maxBadRecords,omitempty"`
	// NullMarker: Optional. Specifies a string that represents a null value in a
	// CSV file. For example, if you specify "\N", BigQuery interprets "\N" as a
	// null value when loading a CSV file. The default value is the empty string.
	// If you set this property to a custom value, BigQuery throws an error if an
	// empty string is present for all data types except for STRING and BYTE. For
	// STRING and BYTE columns, BigQuery interprets the empty string as an empty
	// value.
	NullMarker string `json:"nullMarker,omitempty"`
	// NullMarkers: Optional. A list of strings represented as SQL NULL value in a
	// CSV file. null_marker and null_markers can't be set at the same time. If
	// null_marker is set, null_markers has to be not set. If null_markers is set,
	// null_marker has to be not set. If both null_marker and null_markers are set
	// at the same time, a user error would be thrown. Any strings listed in
	// null_markers, including empty string would be interpreted as SQL NULL. This
	// applies to all column types.
	NullMarkers []string `json:"nullMarkers,omitempty"`
	// ParquetOptions: Optional. Additional properties to set if sourceFormat is
	// set to PARQUET.
	ParquetOptions *ParquetOptions `json:"parquetOptions,omitempty"`
	// PreserveAsciiControlCharacters: Optional. When sourceFormat is set to "CSV",
	// this indicates whether the embedded ASCII control characters (the first 32
	// characters in the ASCII-table, from '\x00' to '\x1F') are preserved.
	PreserveAsciiControlCharacters bool `json:"preserveAsciiControlCharacters,omitempty"`
	// ProjectionFields: If sourceFormat is set to "DATASTORE_BACKUP", indicates
	// which entity properties to load into BigQuery from a Cloud Datastore backup.
	// Property names are case sensitive and must be top-level properties. If no
	// properties are specified, BigQuery loads all properties. If any named
	// property isn't found in the Cloud Datastore backup, an invalid error is
	// returned in the job result.
	ProjectionFields []string `json:"projectionFields,omitempty"`
	// Quote: Optional. The value that is used to quote data sections in a CSV
	// file. BigQuery converts the string to ISO-8859-1 encoding, and then uses the
	// first byte of the encoded string to split the data in its raw, binary state.
	// The default value is a double-quote ('"'). If your data does not contain
	// quoted sections, set the property value to an empty string. If your data
	// contains quoted newline characters, you must also set the
	// allowQuotedNewlines property to true. To include the specific quote
	// character within a quoted value, precede it with an additional matching
	// quote character. For example, if you want to escape the default character '
	// " ', use ' "" '. @default "
	//
	// Default: "
	Quote *string `json:"quote,omitempty"`
	// RangePartitioning: Range partitioning specification for the destination
	// table. Only one of timePartitioning and rangePartitioning should be
	// specified.
	RangePartitioning *RangePartitioning `json:"rangePartitioning,omitempty"`
	// ReferenceFileSchemaUri: Optional. The user can provide a reference file with
	// the reader schema. This file is only loaded if it is part of source URIs,
	// but is not loaded otherwise. It is enabled for the following formats: AVRO,
	// PARQUET, ORC.
	ReferenceFileSchemaUri string `json:"referenceFileSchemaUri,omitempty"`
	// Schema: Optional. The schema for the destination table. The schema can be
	// omitted if the destination table already exists, or if you're loading data
	// from Google Cloud Datastore.
	Schema *TableSchema `json:"schema,omitempty"`
	// SchemaInline: [Deprecated] The inline schema. For CSV schemas, specify as
	// "Field1:Type1[,Field2:Type2]*". For example, "foo:STRING, bar:INTEGER,
	// baz:FLOAT".
	SchemaInline string `json:"schemaInline,omitempty"`
	// SchemaInlineFormat: [Deprecated] The format of the schemaInline property.
	SchemaInlineFormat string `json:"schemaInlineFormat,omitempty"`
	// SchemaUpdateOptions: Allows the schema of the destination table to be
	// updated as a side effect of the load job if a schema is autodetected or
	// supplied in the job configuration. Schema update options are supported in
	// two cases: when writeDisposition is WRITE_APPEND; when writeDisposition is
	// WRITE_TRUNCATE and the destination table is a partition of a table,
	// specified by partition decorators. For normal tables, WRITE_TRUNCATE will
	// always overwrite the schema. One or more of the following values are
	// specified: * ALLOW_FIELD_ADDITION: allow adding a nullable field to the
	// schema. * ALLOW_FIELD_RELAXATION: allow relaxing a required field in the
	// original schema to nullable.
	SchemaUpdateOptions []string `json:"schemaUpdateOptions,omitempty"`
	// SkipLeadingRows: Optional. The number of rows at the top of a CSV file that
	// BigQuery will skip when loading the data. The default value is 0. This
	// property is useful if you have header rows in the file that should be
	// skipped. When autodetect is on, the behavior is the following: *
	// skipLeadingRows unspecified - Autodetect tries to detect headers in the
	// first row. If they are not detected, the row is read as data. Otherwise data
	// is read starting from the second row. * skipLeadingRows is 0 - Instructs
	// autodetect that there are no headers and data should be read starting from
	// the first row. * skipLeadingRows = N > 0 - Autodetect skips N-1 rows and
	// tries to detect headers in row N. If headers are not detected, row N is just
	// skipped. Otherwise row N is used to extract column names for the detected
	// schema.
	SkipLeadingRows int64 `json:"skipLeadingRows,omitempty"`
	// SourceColumnMatch: Optional. Controls the strategy used to match loaded
	// columns to the schema. If not set, a sensible default is chosen based on how
	// the schema is provided. If autodetect is used, then columns are matched by
	// name. Otherwise, columns are matched by position. This is done to keep the
	// behavior backward-compatible.
	//
	// Possible values:
	//   "SOURCE_COLUMN_MATCH_UNSPECIFIED" - Uses sensible defaults based on how
	// the schema is provided. If autodetect is used, then columns are matched by
	// name. Otherwise, columns are matched by position. This is done to keep the
	// behavior backward-compatible.
	//   "POSITION" - Matches by position. This assumes that the columns are
	// ordered the same way as the schema.
	//   "NAME" - Matches by name. This reads the header row as column names and
	// reorders columns to match the field names in the schema.
	SourceColumnMatch string `json:"sourceColumnMatch,omitempty"`
	// SourceFormat: Optional. The format of the data files. For CSV files, specify
	// "CSV". For datastore backups, specify "DATASTORE_BACKUP". For
	// newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify
	// "AVRO". For parquet, specify "PARQUET". For orc, specify "ORC". The default
	// value is CSV.
	SourceFormat string `json:"sourceFormat,omitempty"`
	// SourceUris: [Required] The fully-qualified URIs that point to your data in
	// Google Cloud. For Google Cloud Storage URIs: Each URI can contain one '*'
	// wildcard character and it must come after the 'bucket' name. Size limits
	// related to load jobs apply to external data sources. For Google Cloud
	// Bigtable URIs: Exactly one URI can be specified and it has be a fully
	// specified and valid HTTPS URL for a Google Cloud Bigtable table. For Google
	// Cloud Datastore backups: Exactly one URI can be specified. Also, the '*'
	// wildcard character is not allowed.
	SourceUris []string `json:"sourceUris,omitempty"`
	// TimeFormat: Optional. Date format used for parsing TIME values.
	TimeFormat string `json:"timeFormat,omitempty"`
	// TimePartitioning: Time-based partitioning specification for the destination
	// table. Only one of timePartitioning and rangePartitioning should be
	// specified.
	TimePartitioning *TimePartitioning `json:"timePartitioning,omitempty"`
	// TimeZone: Optional. Default time zone that will apply when parsing timestamp
	// values that have no specific time zone.
	TimeZone string `json:"timeZone,omitempty"`
	// TimestampFormat: Optional. Date format used for parsing TIMESTAMP values.
	TimestampFormat string `json:"timestampFormat,omitempty"`
	// UseAvroLogicalTypes: Optional. If sourceFormat is set to "AVRO", indicates
	// whether to interpret logical types as the corresponding BigQuery data type
	// (for example, TIMESTAMP), instead of using the raw type (for example,
	// INTEGER).
	UseAvroLogicalTypes bool `json:"useAvroLogicalTypes,omitempty"`
	// WriteDisposition: Optional. Specifies the action that occurs if the
	// destination table already exists. The following values are supported: *
	// WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the data,
	// removes the constraints and uses the schema from the load job. *
	// WRITE_TRUNCATE_DATA: If the table already exists, BigQuery overwrites the
	// data, but keeps the constraints and schema of the existing table. *
	// WRITE_APPEND: If the table already exists, BigQuery appends the data to the
	// table. * WRITE_EMPTY: If the table already exists and contains data, a
	// 'duplicate' error is returned in the job result. The default value is
	// WRITE_APPEND. Each action is atomic and only occurs if BigQuery is able to
	// complete the job successfully. Creation, truncation and append actions occur
	// as one atomic update upon job completion.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowJaggedRows") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowJaggedRows") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobConfigurationLoad) MarshalJSON() ([]byte, error) {
	type NoMethod JobConfigurationLoad
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobConfigurationQuery: JobConfigurationQuery configures a BigQuery query
// job.
type JobConfigurationQuery struct {
	// AllowLargeResults: Optional. If true and query uses legacy SQL dialect,
	// allows the query to produce arbitrarily large result tables at a slight cost
	// in performance. Requires destinationTable to be set. For GoogleSQL queries,
	// this flag is ignored and large results are always allowed. However, you must
	// still set destinationTable when result size exceeds the allowed maximum
	// response size.
	AllowLargeResults bool `json:"allowLargeResults,omitempty"`
	// Clustering: Clustering specification for the destination table.
	Clustering *Clustering `json:"clustering,omitempty"`
	// ConnectionProperties: Connection properties which can modify the query
	// behavior.
	ConnectionProperties []*ConnectionProperty `json:"connectionProperties,omitempty"`
	// Continuous: [Optional] Specifies whether the query should be executed as a
	// continuous query. The default value is false.
	Continuous bool `json:"continuous,omitempty"`
	// CreateDisposition: Optional. Specifies whether the job is allowed to create
	// new tables. The following values are supported: * CREATE_IF_NEEDED: If the
	// table does not exist, BigQuery creates the table. * CREATE_NEVER: The table
	// must already exist. If it does not, a 'notFound' error is returned in the
	// job result. The default value is CREATE_IF_NEEDED. Creation, truncation and
	// append actions occur as one atomic update upon job completion.
	CreateDisposition string `json:"createDisposition,omitempty"`
	// CreateSession: If this property is true, the job creates a new session using
	// a randomly generated session_id. To continue using a created session with
	// subsequent queries, pass the existing session identifier as a
	// `ConnectionProperty` value. The session identifier is returned as part of
	// the `SessionInfo` message within the query statistics. The new session's
	// location will be set to `Job.JobReference.location` if it is present,
	// otherwise it's set to the default location based on existing routing logic.
	CreateSession bool `json:"createSession,omitempty"`
	// DefaultDataset: Optional. Specifies the default dataset to use for
	// unqualified table names in the query. This setting does not alter behavior
	// of unqualified dataset names. Setting the system variable `@@dataset_id`
	// achieves the same behavior. See
	// https://cloud.google.com/bigquery/docs/reference/system-variables for more
	// information on system variables.
	DefaultDataset *DatasetReference `json:"defaultDataset,omitempty"`
	// DestinationEncryptionConfiguration: Custom encryption configuration (e.g.,
	// Cloud KMS keys)
	DestinationEncryptionConfiguration *EncryptionConfiguration `json:"destinationEncryptionConfiguration,omitempty"`
	// DestinationTable: Optional. Describes the table where the query results
	// should be stored. This property must be set for large results that exceed
	// the maximum response size. For queries that produce anonymous (cached)
	// results, this field will be populated by BigQuery.
	DestinationTable *TableReference `json:"destinationTable,omitempty"`
	// FlattenResults: Optional. If true and query uses legacy SQL dialect,
	// flattens all nested and repeated fields in the query results.
	// allowLargeResults must be true if this is set to false. For GoogleSQL
	// queries, this flag is ignored and results are never flattened.
	//
	// Default: true
	FlattenResults *bool `json:"flattenResults,omitempty"`
	// MaximumBillingTier: Optional. [Deprecated] Maximum billing tier allowed for
	// this query. The billing tier controls the amount of compute resources
	// allotted to the query, and multiplies the on-demand cost of the query
	// accordingly. A query that runs within its allotted resources will succeed
	// and indicate its billing tier in statistics.query.billingTier, but if the
	// query exceeds its allotted resources, it will fail with
	// billingTierLimitExceeded. WARNING: The billed byte amount can be multiplied
	// by an amount up to this number! Most users should not need to alter this
	// setting, and we recommend that you avoid introducing new uses of it.
	//
	// Default: 1
	MaximumBillingTier *int64 `json:"maximumBillingTier,omitempty"`
	// MaximumBytesBilled: Limits the bytes billed for this job. Queries that will
	// have bytes billed beyond this limit will fail (without incurring a charge).
	// If unspecified, this will be set to your project default.
	MaximumBytesBilled int64 `json:"maximumBytesBilled,omitempty,string"`
	// ParameterMode: GoogleSQL only. Set to POSITIONAL to use positional (?) query
	// parameters or to NAMED to use named (@myparam) query parameters in this
	// query.
	ParameterMode string `json:"parameterMode,omitempty"`
	// PreserveNulls: [Deprecated] This property is deprecated.
	PreserveNulls bool `json:"preserveNulls,omitempty"`
	// Priority: Optional. Specifies a priority for the query. Possible values
	// include INTERACTIVE and BATCH. The default value is INTERACTIVE.
	Priority string `json:"priority,omitempty"`
	// Query: [Required] SQL query text to execute. The useLegacySql field can be
	// used to indicate whether the query uses legacy SQL or GoogleSQL.
	Query string `json:"query,omitempty"`
	// QueryParameters: Query parameters for GoogleSQL queries.
	QueryParameters []*QueryParameter `json:"queryParameters,omitempty"`
	// RangePartitioning: Range partitioning specification for the destination
	// table. Only one of timePartitioning and rangePartitioning should be
	// specified.
	RangePartitioning *RangePartitioning `json:"rangePartitioning,omitempty"`
	// SchemaUpdateOptions: Allows the schema of the destination table to be
	// updated as a side effect of the query job. Schema update options are
	// supported in two cases: when writeDisposition is WRITE_APPEND; when
	// writeDisposition is WRITE_TRUNCATE and the destination table is a partition
	// of a table, specified by partition decorators. For normal tables,
	// WRITE_TRUNCATE will always overwrite the schema. One or more of the
	// following values are specified: * ALLOW_FIELD_ADDITION: allow adding a
	// nullable field to the schema. * ALLOW_FIELD_RELAXATION: allow relaxing a
	// required field in the original schema to nullable.
	SchemaUpdateOptions []string `json:"schemaUpdateOptions,omitempty"`
	// ScriptOptions: Options controlling the execution of scripts.
	ScriptOptions *ScriptOptions `json:"scriptOptions,omitempty"`
	// SystemVariables: Output only. System variables for GoogleSQL queries. A
	// system variable is output if the variable is settable and its value differs
	// from the system default. "@@" prefix is not included in the name of the
	// System variables.
	SystemVariables *SystemVariables `json:"systemVariables,omitempty"`
	// TableDefinitions: Optional. You can specify external table definitions,
	// which operate as ephemeral tables that can be queried. These definitions are
	// configured using a JSON map, where the string key represents the table
	// identifier, and the value is the corresponding external data configuration
	// object.
	TableDefinitions map[string]ExternalDataConfiguration `json:"tableDefinitions,omitempty"`
	// TimePartitioning: Time-based partitioning specification for the destination
	// table. Only one of timePartitioning and rangePartitioning should be
	// specified.
	TimePartitioning *TimePartitioning `json:"timePartitioning,omitempty"`
	// UseLegacySql: Optional. Specifies whether to use BigQuery's legacy SQL
	// dialect for this query. The default value is true. If set to false, the
	// query will use BigQuery's GoogleSQL:
	// https://cloud.google.com/bigquery/sql-reference/ When useLegacySql is set to
	// false, the value of flattenResults is ignored; query will be run as if
	// flattenResults is false.
	//
	// Default: true
	UseLegacySql *bool `json:"useLegacySql,omitempty"`
	// UseQueryCache: Optional. Whether to look for the result in the query cache.
	// The query cache is a best-effort cache that will be flushed whenever tables
	// in the query are modified. Moreover, the query cache is only available when
	// a query does not have a destination table specified. The default value is
	// true.
	//
	// Default: true
	UseQueryCache *bool `json:"useQueryCache,omitempty"`
	// UserDefinedFunctionResources: Describes user-defined function resources used
	// in the query.
	UserDefinedFunctionResources []*UserDefinedFunctionResource `json:"userDefinedFunctionResources,omitempty"`
	// WriteDisposition: Optional. Specifies the action that occurs if the
	// destination table already exists. The following values are supported: *
	// WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the data,
	// removes the constraints, and uses the schema from the query result. *
	// WRITE_TRUNCATE_DATA: If the table already exists, BigQuery overwrites the
	// data, but keeps the constraints and schema of the existing table. *
	// WRITE_APPEND: If the table already exists, BigQuery appends the data to the
	// table. * WRITE_EMPTY: If the table already exists and contains data, a
	// 'duplicate' error is returned in the job result. The default value is
	// WRITE_EMPTY. Each action is atomic and only occurs if BigQuery is able to
	// complete the job successfully. Creation, truncation and append actions occur
	// as one atomic update upon job completion.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// WriteIncrementalResults: Optional. This is only supported for a SELECT query
	// using a temporary table. If set, the query is allowed to write results
	// incrementally to the temporary result table. This may incur a performance
	// penalty. This option cannot be used with Legacy SQL. This feature is not yet
	// available.
	WriteIncrementalResults bool `json:"writeIncrementalResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowLargeResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowLargeResults") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobConfigurationQuery) MarshalJSON() ([]byte, error) {
	type NoMethod JobConfigurationQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobConfigurationTableCopy: JobConfigurationTableCopy configures a job that
// copies data from one table to another. For more information on copying
// tables, see Copy a table
// (https://cloud.google.com/bigquery/docs/managing-tables#copy-table).
type JobConfigurationTableCopy struct {
	// CreateDisposition: Optional. Specifies whether the job is allowed to create
	// new tables. The following values are supported: * CREATE_IF_NEEDED: If the
	// table does not exist, BigQuery creates the table. * CREATE_NEVER: The table
	// must already exist. If it does not, a 'notFound' error is returned in the
	// job result. The default value is CREATE_IF_NEEDED. Creation, truncation and
	// append actions occur as one atomic update upon job completion.
	CreateDisposition string `json:"createDisposition,omitempty"`
	// DestinationEncryptionConfiguration: Custom encryption configuration (e.g.,
	// Cloud KMS keys).
	DestinationEncryptionConfiguration *EncryptionConfiguration `json:"destinationEncryptionConfiguration,omitempty"`
	// DestinationExpirationTime: Optional. The time when the destination table
	// expires. Expired tables will be deleted and their storage reclaimed.
	DestinationExpirationTime string `json:"destinationExpirationTime,omitempty"`
	// DestinationTable: [Required] The destination table.
	DestinationTable *TableReference `json:"destinationTable,omitempty"`
	// OperationType: Optional. Supported operation types in table copy job.
	//
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED" - Unspecified operation type.
	//   "COPY" - The source and destination table have the same table type.
	//   "SNAPSHOT" - The source table type is TABLE and the destination table type
	// is SNAPSHOT.
	//   "RESTORE" - The source table type is SNAPSHOT and the destination table
	// type is TABLE.
	//   "CLONE" - The source and destination table have the same table type, but
	// only bill for unique data.
	OperationType string `json:"operationType,omitempty"`
	// SourceTable: [Pick one] Source table to copy.
	SourceTable *TableReference `json:"sourceTable,omitempty"`
	// SourceTables: [Pick one] Source tables to copy.
	SourceTables []*TableReference `json:"sourceTables,omitempty"`
	// WriteDisposition: Optional. Specifies the action that occurs if the
	// destination table already exists. The following values are supported: *
	// WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table
	// data and uses the schema and table constraints from the source table. *
	// WRITE_APPEND: If the table already exists, BigQuery appends the data to the
	// table. * WRITE_EMPTY: If the table already exists and contains data, a
	// 'duplicate' error is returned in the job result. The default value is
	// WRITE_EMPTY. Each action is atomic and only occurs if BigQuery is able to
	// complete the job successfully. Creation, truncation and append actions occur
	// as one atomic update upon job completion.
	WriteDisposition string `json:"writeDisposition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateDisposition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateDisposition") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobConfigurationTableCopy) MarshalJSON() ([]byte, error) {
	type NoMethod JobConfigurationTableCopy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobCreationReason: Reason about why a Job was created from a `jobs.query`
// (https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/query) method
// when used with `JOB_CREATION_OPTIONAL` Job creation mode. For `jobs.insert`
// (https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/insert)
// method calls it will always be `REQUESTED`.
type JobCreationReason struct {
	// Code: Output only. Specifies the high level reason why a Job was created.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - Reason is not specified.
	//   "REQUESTED" - Job creation was requested.
	//   "LONG_RUNNING" - The query request ran beyond a system defined timeout
	// specified by the [timeoutMs field in the
	// QueryRequest](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/q
	// uery#queryrequest). As a result it was considered a long running operation
	// for which a job was created.
	//   "LARGE_RESULTS" - The results from the query cannot fit in the response.
	//   "OTHER" - BigQuery has determined that the query needs to be executed as a
	// Job.
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobCreationReason) MarshalJSON() ([]byte, error) {
	type NoMethod JobCreationReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobList: JobList is the response format for a jobs.list call.
type JobList struct {
	// Etag: A hash of this page of results.
	Etag string `json:"etag,omitempty"`
	// Jobs: List of jobs that were requested.
	Jobs []*JobListJobs `json:"jobs,omitempty"`
	// Kind: The resource type of the response.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: A token to request the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: A list of skipped locations that were unreachable. For more
	// information about BigQuery locations, see:
	// https://cloud.google.com/bigquery/docs/locations. Example: "europe-west5"
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobList) MarshalJSON() ([]byte, error) {
	type NoMethod JobList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobListJobs: ListFormatJob is a partial projection of job information
// returned as part of a jobs.list response.
type JobListJobs struct {
	// Configuration: Required. Describes the job configuration.
	Configuration *JobConfiguration `json:"configuration,omitempty"`
	// ErrorResult: A result object that will be present only if the job has
	// failed.
	ErrorResult *ErrorProto `json:"errorResult,omitempty"`
	// Id: Unique opaque ID of the job.
	Id string `json:"id,omitempty"`
	// JobReference: Unique opaque ID of the job.
	JobReference *JobReference `json:"jobReference,omitempty"`
	// Kind: The resource type.
	Kind string `json:"kind,omitempty"`
	// PrincipalSubject: [Full-projection-only] String representation of identity
	// of requesting party. Populated for both first- and third-party identities.
	// Only present for APIs that support third-party identities.
	PrincipalSubject string `json:"principal_subject,omitempty"`
	// State: Running state of the job. When the state is DONE, errorResult can be
	// checked to determine whether the job succeeded or failed.
	State string `json:"state,omitempty"`
	// Statistics: Output only. Information about the job, including starting time
	// and ending time of the job.
	Statistics *JobStatistics `json:"statistics,omitempty"`
	// Status: [Full-projection-only] Describes the status of this job.
	Status *JobStatus `json:"status,omitempty"`
	// UserEmail: [Full-projection-only] Email address of the user who ran the job.
	UserEmail string `json:"user_email,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Configuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Configuration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobListJobs) MarshalJSON() ([]byte, error) {
	type NoMethod JobListJobs
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobReference: A job reference is a fully qualified identifier for referring
// to a job.
type JobReference struct {
	// JobId: Required. The ID of the job. The ID must contain only letters (a-z,
	// A-Z), numbers (0-9), underscores (_), or dashes (-). The maximum length is
	// 1,024 characters.
	JobId string `json:"jobId,omitempty"`
	// Location: Optional. The geographic location of the job. The default value is
	// US. For more information about BigQuery locations, see:
	// https://cloud.google.com/bigquery/docs/locations
	Location string `json:"location,omitempty"`
	// ProjectId: Required. The ID of the project containing this job.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JobId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JobId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobReference) MarshalJSON() ([]byte, error) {
	type NoMethod JobReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobStatistics: Statistics for a single job execution.
type JobStatistics struct {
	// CompletionRatio: Output only. [TrustedTester] Job progress (0.0 -> 1.0) for
	// LOAD and EXTRACT jobs.
	CompletionRatio float64 `json:"completionRatio,omitempty"`
	// Copy: Output only. Statistics for a copy job.
	Copy *JobStatistics5 `json:"copy,omitempty"`
	// CreationTime: Output only. Creation time of this job, in milliseconds since
	// the epoch. This field will be present on all jobs.
	CreationTime int64 `json:"creationTime,omitempty,string"`
	// DataMaskingStatistics: Output only. Statistics for data-masking. Present
	// only for query and extract jobs.
	DataMaskingStatistics *DataMaskingStatistics `json:"dataMaskingStatistics,omitempty"`
	// Edition: Output only. Name of edition corresponding to the reservation for
	// this job at the time of this update.
	//
	// Possible values:
	//   "RESERVATION_EDITION_UNSPECIFIED" - Default value, which will be treated
	// as ENTERPRISE.
	//   "STANDARD" - Standard edition.
	//   "ENTERPRISE" - Enterprise edition.
	//   "ENTERPRISE_PLUS" - Enterprise Plus edition.
	Edition string `json:"edition,omitempty"`
	// EndTime: Output only. End time of this job, in milliseconds since the epoch.
	// This field will be present whenever a job is in the DONE state.
	EndTime int64 `json:"endTime,omitempty,string"`
	// Extract: Output only. Statistics for an extract job.
	Extract *JobStatistics4 `json:"extract,omitempty"`
	// FinalExecutionDurationMs: Output only. The duration in milliseconds of the
	// execution of the final attempt of this job, as BigQuery may internally
	// re-attempt to execute the job.
	FinalExecutionDurationMs int64 `json:"finalExecutionDurationMs,omitempty,string"`
	// Load: Output only. Statistics for a load job.
	Load *JobStatistics3 `json:"load,omitempty"`
	// NumChildJobs: Output only. Number of child jobs executed.
	NumChildJobs int64 `json:"numChildJobs,omitempty,string"`
	// ParentJobId: Output only. If this is a child job, specifies the job ID of
	// the parent.
	ParentJobId string `json:"parentJobId,omitempty"`
	// Query: Output only. Statistics for a query job.
	Query *JobStatistics2 `json:"query,omitempty"`
	// QuotaDeferments: Output only. Quotas which delayed this job's start time.
	QuotaDeferments []string `json:"quotaDeferments,omitempty"`
	// ReservationUsage: Output only. Job resource usage breakdown by reservation.
	// This field reported misleading information and will no longer be populated.
	ReservationUsage []*JobStatisticsReservationUsage `json:"reservationUsage,omitempty"`
	// ReservationId: Output only. Name of the primary reservation assigned to this
	// job. Note that this could be different than reservations reported in the
	// reservation usage field if parent reservations were used to execute this
	// job.
	ReservationId string `json:"reservation_id,omitempty"`
	// RowLevelSecurityStatistics: Output only. Statistics for row-level security.
	// Present only for query and extract jobs.
	RowLevelSecurityStatistics *RowLevelSecurityStatistics `json:"rowLevelSecurityStatistics,omitempty"`
	// ScriptStatistics: Output only. If this a child job of a script, specifies
	// information about the context of this job within the script.
	ScriptStatistics *ScriptStatistics `json:"scriptStatistics,omitempty"`
	// SessionInfo: Output only. Information of the session if this job is part of
	// one.
	SessionInfo *SessionInfo `json:"sessionInfo,omitempty"`
	// StartTime: Output only. Start time of this job, in milliseconds since the
	// epoch. This field will be present when the job transitions from the PENDING
	// state to either RUNNING or DONE.
	StartTime int64 `json:"startTime,omitempty,string"`
	// TotalBytesProcessed: Output only. Total bytes processed for the job.
	TotalBytesProcessed int64 `json:"totalBytesProcessed,omitempty,string"`
	// TotalSlotMs: Output only. Slot-milliseconds for the job.
	TotalSlotMs int64 `json:"totalSlotMs,omitempty,string"`
	// TransactionInfo: Output only. [Alpha] Information of the multi-statement
	// transaction if this job is part of one. This property is only expected on a
	// child job or a job that is in a session. A script parent job is not part of
	// the transaction started in the script.
	TransactionInfo *TransactionInfo `json:"transactionInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletionRatio") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletionRatio") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod JobStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *JobStatistics) UnmarshalJSON(data []byte) error {
	type NoMethod JobStatistics
	var s1 struct {
		CompletionRatio gensupport.JSONFloat64 `json:"completionRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CompletionRatio = float64(s1.CompletionRatio)
	return nil
}

// JobStatisticsReservationUsage: Job resource usage breakdown by reservation.
type JobStatisticsReservationUsage struct {
	// Name: Reservation name or "unreserved" for on-demand resource usage and
	// multi-statement queries.
	Name string `json:"name,omitempty"`
	// SlotMs: Total slot milliseconds used by the reservation for a particular
	// job.
	SlotMs int64 `json:"slotMs,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobStatisticsReservationUsage) MarshalJSON() ([]byte, error) {
	type NoMethod JobStatisticsReservationUsage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobStatistics2: Statistics for a query job.
type JobStatistics2 struct {
	// BiEngineStatistics: Output only. BI Engine specific Statistics.
	BiEngineStatistics *BiEngineStatistics `json:"biEngineStatistics,omitempty"`
	// BillingTier: Output only. Billing tier for the job. This is a
	// BigQuery-specific concept which is not related to the Google Cloud notion of
	// "free tier". The value here is a measure of the query's resource consumption
	// relative to the amount of data scanned. For on-demand queries, the limit is
	// 100, and all queries within this limit are billed at the standard on-demand
	// rates. On-demand queries that exceed this limit will fail with a
	// billingTierLimitExceeded error.
	BillingTier int64 `json:"billingTier,omitempty"`
	// CacheHit: Output only. Whether the query result was fetched from the query
	// cache.
	CacheHit bool `json:"cacheHit,omitempty"`
	// DclTargetDataset: Output only. Referenced dataset for DCL statement.
	DclTargetDataset *DatasetReference `json:"dclTargetDataset,omitempty"`
	// DclTargetTable: Output only. Referenced table for DCL statement.
	DclTargetTable *TableReference `json:"dclTargetTable,omitempty"`
	// DclTargetView: Output only. Referenced view for DCL statement.
	DclTargetView *TableReference `json:"dclTargetView,omitempty"`
	// DdlAffectedRowAccessPolicyCount: Output only. The number of row access
	// policies affected by a DDL statement. Present only for DROP ALL ROW ACCESS
	// POLICIES queries.
	DdlAffectedRowAccessPolicyCount int64 `json:"ddlAffectedRowAccessPolicyCount,omitempty,string"`
	// DdlDestinationTable: Output only. The table after rename. Present only for
	// ALTER TABLE RENAME TO query.
	DdlDestinationTable *TableReference `json:"ddlDestinationTable,omitempty"`
	// DdlOperationPerformed: Output only. The DDL operation performed, possibly
	// dependent on the pre-existence of the DDL target.
	DdlOperationPerformed string `json:"ddlOperationPerformed,omitempty"`
	// DdlTargetDataset: Output only. The DDL target dataset. Present only for
	// CREATE/ALTER/DROP SCHEMA(dataset) queries.
	DdlTargetDataset *DatasetReference `json:"ddlTargetDataset,omitempty"`
	// DdlTargetRoutine: Output only. [Beta] The DDL target routine. Present only
	// for CREATE/DROP FUNCTION/PROCEDURE queries.
	DdlTargetRoutine *RoutineReference `json:"ddlTargetRoutine,omitempty"`
	// DdlTargetRowAccessPolicy: Output only. The DDL target row access policy.
	// Present only for CREATE/DROP ROW ACCESS POLICY queries.
	DdlTargetRowAccessPolicy *RowAccessPolicyReference `json:"ddlTargetRowAccessPolicy,omitempty"`
	// DdlTargetTable: Output only. The DDL target table. Present only for
	// CREATE/DROP TABLE/VIEW and DROP ALL ROW ACCESS POLICIES queries.
	DdlTargetTable *TableReference `json:"ddlTargetTable,omitempty"`
	// DmlStats: Output only. Detailed statistics for DML statements INSERT,
	// UPDATE, DELETE, MERGE or TRUNCATE.
	DmlStats *DmlStatistics `json:"dmlStats,omitempty"`
	// EstimatedBytesProcessed: Output only. The original estimate of bytes
	// processed for the job.
	EstimatedBytesProcessed int64 `json:"estimatedBytesProcessed,omitempty,string"`
	// ExportDataStatistics: Output only. Stats for EXPORT DATA statement.
	ExportDataStatistics *ExportDataStatistics `json:"exportDataStatistics,omitempty"`
	// ExternalServiceCosts: Output only. Job cost breakdown as bigquery internal
	// cost and external service costs.
	ExternalServiceCosts []*ExternalServiceCost `json:"externalServiceCosts,omitempty"`
	// LoadQueryStatistics: Output only. Statistics for a LOAD query.
	LoadQueryStatistics *LoadQueryStatistics `json:"loadQueryStatistics,omitempty"`
	// MaterializedViewStatistics: Output only. Statistics of materialized views of
	// a query job.
	MaterializedViewStatistics *MaterializedViewStatistics `json:"materializedViewStatistics,omitempty"`
	// MetadataCacheStatistics: Output only. Statistics of metadata cache usage in
	// a query for BigLake tables.
	MetadataCacheStatistics *MetadataCacheStatistics `json:"metadataCacheStatistics,omitempty"`
	// MlStatistics: Output only. Statistics of a BigQuery ML training job.
	MlStatistics *MlStatistics `json:"mlStatistics,omitempty"`
	// ModelTraining: Deprecated.
	ModelTraining *BigQueryModelTraining `json:"modelTraining,omitempty"`
	// ModelTrainingCurrentIteration: Deprecated.
	ModelTrainingCurrentIteration int64 `json:"modelTrainingCurrentIteration,omitempty"`
	// ModelTrainingExpectedTotalIteration: Deprecated.
	ModelTrainingExpectedTotalIteration int64 `json:"modelTrainingExpectedTotalIteration,omitempty,string"`
	// NumDmlAffectedRows: Output only. The number of rows affected by a DML
	// statement. Present only for DML statements INSERT, UPDATE or DELETE.
	NumDmlAffectedRows int64 `json:"numDmlAffectedRows,omitempty,string"`
	// PerformanceInsights: Output only. Performance insights.
	PerformanceInsights *PerformanceInsights `json:"performanceInsights,omitempty"`
	// QueryInfo: Output only. Query optimization information for a QUERY job.
	QueryInfo *QueryInfo `json:"queryInfo,omitempty"`
	// QueryPlan: Output only. Describes execution plan for the query.
	QueryPlan []*ExplainQueryStage `json:"queryPlan,omitempty"`
	// ReferencedRoutines: Output only. Referenced routines for the job.
	ReferencedRoutines []*RoutineReference `json:"referencedRoutines,omitempty"`
	// ReferencedTables: Output only. Referenced tables for the job.
	ReferencedTables []*TableReference `json:"referencedTables,omitempty"`
	// ReservationUsage: Output only. Job resource usage breakdown by reservation.
	// This field reported misleading information and will no longer be populated.
	ReservationUsage []*JobStatistics2ReservationUsage `json:"reservationUsage,omitempty"`
	// Schema: Output only. The schema of the results. Present only for successful
	// dry run of non-legacy SQL queries.
	Schema *TableSchema `json:"schema,omitempty"`
	// SearchStatistics: Output only. Search query specific statistics.
	SearchStatistics *SearchStatistics `json:"searchStatistics,omitempty"`
	// SparkStatistics: Output only. Statistics of a Spark procedure job.
	SparkStatistics *SparkStatistics `json:"sparkStatistics,omitempty"`
	// StatementType: Output only. The type of query statement, if valid. Possible
	// values: * `SELECT`: `SELECT`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/query-syntax#select_list)
	// statement. * `ASSERT`: `ASSERT`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/debugging-statements#assert)
	// statement. * `INSERT`: `INSERT`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/dml-syntax#insert_statement)
	// statement. * `UPDATE`: `UPDATE`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/dml-syntax#update_statement)
	// statement. * `DELETE`: `DELETE`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language)
	// statement. * `MERGE`: `MERGE`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language)
	// statement. * `CREATE_TABLE`: `CREATE TABLE`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#create_table_statement)
	// statement, without `AS SELECT`. * `CREATE_TABLE_AS_SELECT`: `CREATE TABLE AS
	// SELECT`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#create_table_statement)
	// statement. * `CREATE_VIEW`: `CREATE VIEW`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#create_view_statement)
	// statement. * `CREATE_MODEL`: `CREATE MODEL`
	// (https://cloud.google.com/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-create#create_model_statement)
	// statement. * `CREATE_MATERIALIZED_VIEW`: `CREATE MATERIALIZED VIEW`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#create_materialized_view_statement)
	// statement. * `CREATE_FUNCTION`: `CREATE FUNCTION`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#create_function_statement)
	// statement. * `CREATE_TABLE_FUNCTION`: `CREATE TABLE FUNCTION`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#create_table_function_statement)
	// statement. * `CREATE_PROCEDURE`: `CREATE PROCEDURE`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#create_procedure)
	// statement. * `CREATE_ROW_ACCESS_POLICY`: `CREATE ROW ACCESS POLICY`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#create_row_access_policy_statement)
	// statement. * `CREATE_SCHEMA`: `CREATE SCHEMA`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#create_schema_statement)
	// statement. * `CREATE_SNAPSHOT_TABLE`: `CREATE SNAPSHOT TABLE`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#create_snapshot_table_statement)
	// statement. * `CREATE_SEARCH_INDEX`: `CREATE SEARCH INDEX`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#create_search_index_statement)
	// statement. * `DROP_TABLE`: `DROP TABLE`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#drop_table_statement)
	// statement. * `DROP_EXTERNAL_TABLE`: `DROP EXTERNAL TABLE`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#drop_external_table_statement)
	// statement. * `DROP_VIEW`: `DROP VIEW`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#drop_view_statement)
	// statement. * `DROP_MODEL`: `DROP MODEL`
	// (https://cloud.google.com/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-drop-model)
	// statement. * `DROP_MATERIALIZED_VIEW`: `DROP MATERIALIZED VIEW`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#drop_materialized_view_statement)
	// statement. * `DROP_FUNCTION` : `DROP FUNCTION`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#drop_function_statement)
	// statement. * `DROP_TABLE_FUNCTION` : `DROP TABLE FUNCTION`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#drop_table_function)
	// statement. * `DROP_PROCEDURE`: `DROP PROCEDURE`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#drop_procedure_statement)
	// statement. * `DROP_SEARCH_INDEX`: `DROP SEARCH INDEX`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#drop_search_index)
	// statement. * `DROP_SCHEMA`: `DROP SCHEMA`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#drop_schema_statement)
	// statement. * `DROP_SNAPSHOT_TABLE`: `DROP SNAPSHOT TABLE`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#drop_snapshot_table_statement)
	// statement. * `DROP_ROW_ACCESS_POLICY`: [`DROP ALL] ROW ACCESS
	// POLICY|POLICIES`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#drop_row_access_policy_statement)
	// statement. * `ALTER_TABLE`: `ALTER TABLE`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#alter_table_set_options_statement)
	// statement. * `ALTER_VIEW`: `ALTER VIEW`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#alter_view_set_options_statement)
	// statement. * `ALTER_MATERIALIZED_VIEW`: `ALTER MATERIALIZED VIEW`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#alter_materialized_view_set_options_statement)
	// statement. * `ALTER_SCHEMA`: `ALTER SCHEMA`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#alter_schema_set_options_statement)
	// statement. * `SCRIPT`: `SCRIPT`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/procedural-language).
	// * `TRUNCATE_TABLE`: `TRUNCATE TABLE`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/dml-syntax#truncate_table_statement)
	// statement. * `CREATE_EXTERNAL_TABLE`: `CREATE EXTERNAL TABLE`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#create_external_table_statement)
	// statement. * `EXPORT_DATA`: `EXPORT DATA`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/other-statements#export_data_statement)
	// statement. * `EXPORT_MODEL`: `EXPORT MODEL`
	// (https://cloud.google.com/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-export-model)
	// statement. * `LOAD_DATA`: `LOAD DATA`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/other-statements#load_data_statement)
	// statement. * `CALL`: `CALL`
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/procedural-language#call)
	// statement.
	StatementType string `json:"statementType,omitempty"`
	// Timeline: Output only. Describes a timeline of job execution.
	Timeline []*QueryTimelineSample `json:"timeline,omitempty"`
	// TotalBytesBilled: Output only. If the project is configured to use on-demand
	// pricing, then this field contains the total bytes billed for the job. If the
	// project is configured to use flat-rate pricing, then you are not billed for
	// bytes and this field is informational only.
	TotalBytesBilled int64 `json:"totalBytesBilled,omitempty,string"`
	// TotalBytesProcessed: Output only. Total bytes processed for the job.
	TotalBytesProcessed int64 `json:"totalBytesProcessed,omitempty,string"`
	// TotalBytesProcessedAccuracy: Output only. For dry-run jobs,
	// totalBytesProcessed is an estimate and this field specifies the accuracy of
	// the estimate. Possible values can be: UNKNOWN: accuracy of the estimate is
	// unknown. PRECISE: estimate is precise. LOWER_BOUND: estimate is lower bound
	// of what the query would cost. UPPER_BOUND: estimate is upper bound of what
	// the query would cost.
	TotalBytesProcessedAccuracy string `json:"totalBytesProcessedAccuracy,omitempty"`
	// TotalPartitionsProcessed: Output only. Total number of partitions processed
	// from all partitioned tables referenced in the job.
	TotalPartitionsProcessed int64 `json:"totalPartitionsProcessed,omitempty,string"`
	// TotalServicesSkuSlotMs: Output only. Total slot-milliseconds for the job
	// that run on external services and billed on the service SKU. This field is
	// only populated for jobs that have external service costs, and is the total
	// of the usage for costs whose billing method is "SERVICES_SKU".
	TotalServicesSkuSlotMs int64 `json:"totalServicesSkuSlotMs,omitempty,string"`
	// TotalSlotMs: Output only. Slot-milliseconds for the job.
	TotalSlotMs int64 `json:"totalSlotMs,omitempty,string"`
	// TransferredBytes: Output only. Total bytes transferred for cross-cloud
	// queries such as Cross Cloud Transfer and CREATE TABLE AS SELECT (CTAS).
	TransferredBytes int64 `json:"transferredBytes,omitempty,string"`
	// UndeclaredQueryParameters: Output only. GoogleSQL only: list of undeclared
	// query parameters detected during a dry run validation.
	UndeclaredQueryParameters []*QueryParameter `json:"undeclaredQueryParameters,omitempty"`
	// VectorSearchStatistics: Output only. Vector Search query specific
	// statistics.
	VectorSearchStatistics *VectorSearchStatistics `json:"vectorSearchStatistics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BiEngineStatistics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BiEngineStatistics") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobStatistics2) MarshalJSON() ([]byte, error) {
	type NoMethod JobStatistics2
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobStatistics2ReservationUsage: Job resource usage breakdown by reservation.
type JobStatistics2ReservationUsage struct {
	// Name: Reservation name or "unreserved" for on-demand resource usage and
	// multi-statement queries.
	Name string `json:"name,omitempty"`
	// SlotMs: Total slot milliseconds used by the reservation for a particular
	// job.
	SlotMs int64 `json:"slotMs,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobStatistics2ReservationUsage) MarshalJSON() ([]byte, error) {
	type NoMethod JobStatistics2ReservationUsage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobStatistics3: Statistics for a load job.
type JobStatistics3 struct {
	// BadRecords: Output only. The number of bad records encountered. Note that if
	// the job has failed because of more bad records encountered than the maximum
	// allowed in the load job configuration, then this number can be less than the
	// total number of bad records present in the input data.
	BadRecords int64 `json:"badRecords,omitempty,string"`
	// InputFileBytes: Output only. Number of bytes of source data in a load job.
	InputFileBytes int64 `json:"inputFileBytes,omitempty,string"`
	// InputFiles: Output only. Number of source files in a load job.
	InputFiles int64 `json:"inputFiles,omitempty,string"`
	// OutputBytes: Output only. Size of the loaded data in bytes. Note that while
	// a load job is in the running state, this value may change.
	OutputBytes int64 `json:"outputBytes,omitempty,string"`
	// OutputRows: Output only. Number of rows imported in a load job. Note that
	// while an import job is in the running state, this value may change.
	OutputRows int64 `json:"outputRows,omitempty,string"`
	// Timeline: Output only. Describes a timeline of job execution.
	Timeline []*QueryTimelineSample `json:"timeline,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BadRecords") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BadRecords") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobStatistics3) MarshalJSON() ([]byte, error) {
	type NoMethod JobStatistics3
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobStatistics4: Statistics for an extract job.
type JobStatistics4 struct {
	// DestinationUriFileCounts: Output only. Number of files per destination URI
	// or URI pattern specified in the extract configuration. These values will be
	// in the same order as the URIs specified in the 'destinationUris' field.
	DestinationUriFileCounts googleapi.Int64s `json:"destinationUriFileCounts,omitempty"`
	// InputBytes: Output only. Number of user bytes extracted into the result.
	// This is the byte count as computed by BigQuery for billing purposes and
	// doesn't have any relationship with the number of actual result bytes
	// extracted in the desired format.
	InputBytes int64 `json:"inputBytes,omitempty,string"`
	// Timeline: Output only. Describes a timeline of job execution.
	Timeline []*QueryTimelineSample `json:"timeline,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationUriFileCounts")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationUriFileCounts") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobStatistics4) MarshalJSON() ([]byte, error) {
	type NoMethod JobStatistics4
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobStatistics5: Statistics for a copy job.
type JobStatistics5 struct {
	// CopiedLogicalBytes: Output only. Number of logical bytes copied to the
	// destination table.
	CopiedLogicalBytes int64 `json:"copiedLogicalBytes,omitempty,string"`
	// CopiedRows: Output only. Number of rows copied to the destination table.
	CopiedRows int64 `json:"copiedRows,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CopiedLogicalBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CopiedLogicalBytes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobStatistics5) MarshalJSON() ([]byte, error) {
	type NoMethod JobStatistics5
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type JobStatus struct {
	// ErrorResult: Output only. Final error result of the job. If present,
	// indicates that the job has completed and was unsuccessful.
	ErrorResult *ErrorProto `json:"errorResult,omitempty"`
	// Errors: Output only. The first errors encountered during the running of the
	// job. The final message includes the number of errors that caused the process
	// to stop. Errors here do not necessarily mean that the job has not completed
	// or was unsuccessful.
	Errors []*ErrorProto `json:"errors,omitempty"`
	// State: Output only. Running state of the job. Valid states include
	// 'PENDING', 'RUNNING', and 'DONE'.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ErrorResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ErrorResult") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobStatus) MarshalJSON() ([]byte, error) {
	type NoMethod JobStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JoinRestrictionPolicy: Represents privacy policy associated with "join
// restrictions". Join restriction gives data providers the ability to enforce
// joins on the 'join_allowed_columns' when data is queried from a privacy
// protected view.
type JoinRestrictionPolicy struct {
	// JoinAllowedColumns: Optional. The only columns that joins are allowed on.
	// This field is must be specified for join_conditions JOIN_ANY and JOIN_ALL
	// and it cannot be set for JOIN_BLOCKED.
	JoinAllowedColumns []string `json:"joinAllowedColumns,omitempty"`
	// JoinCondition: Optional. Specifies if a join is required or not on queries
	// for the view. Default is JOIN_CONDITION_UNSPECIFIED.
	//
	// Possible values:
	//   "JOIN_CONDITION_UNSPECIFIED" - A join is neither required nor restricted
	// on any column. Default value.
	//   "JOIN_ANY" - A join is required on at least one of the specified columns.
	//   "JOIN_ALL" - A join is required on all specified columns.
	//   "JOIN_NOT_REQUIRED" - A join is not required, but if present it is only
	// permitted on 'join_allowed_columns'
	//   "JOIN_BLOCKED" - Joins are blocked for all queries.
	JoinCondition string `json:"joinCondition,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JoinAllowedColumns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JoinAllowedColumns") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JoinRestrictionPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod JoinRestrictionPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JsonOptions: Json Options for load and make external tables.
type JsonOptions struct {
	// Encoding: Optional. The character encoding of the data. The supported values
	// are UTF-8, UTF-16BE, UTF-16LE, UTF-32BE, and UTF-32LE. The default value is
	// UTF-8.
	Encoding string `json:"encoding,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Encoding") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Encoding") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JsonOptions) MarshalJSON() ([]byte, error) {
	type NoMethod JsonOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type JsonValue interface{}

// LinkedDatasetMetadata: Metadata about the Linked Dataset.
type LinkedDatasetMetadata struct {
	// LinkState: Output only. Specifies whether Linked Dataset is currently in a
	// linked state or not.
	//
	// Possible values:
	//   "LINK_STATE_UNSPECIFIED" - The default value. Default to the LINKED state.
	//   "LINKED" - Normal Linked Dataset state. Data is queryable via the Linked
	// Dataset.
	//   "UNLINKED" - Data publisher or owner has unlinked this Linked Dataset. It
	// means you can no longer query or see the data in the Linked Dataset.
	LinkState string `json:"linkState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LinkState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LinkState") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LinkedDatasetMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod LinkedDatasetMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LinkedDatasetSource: A dataset source type which refers to another BigQuery
// dataset.
type LinkedDatasetSource struct {
	// SourceDataset: The source dataset reference contains project numbers and not
	// project ids.
	SourceDataset *DatasetReference `json:"sourceDataset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SourceDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SourceDataset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LinkedDatasetSource) MarshalJSON() ([]byte, error) {
	type NoMethod LinkedDatasetSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListModelsResponse: Response format for a single page when listing BigQuery
// ML models.
type ListModelsResponse struct {
	// Models: Models in the requested dataset. Only the following fields are
	// populated: model_reference, model_type, creation_time, last_modified_time
	// and labels.
	Models []*Model `json:"models,omitempty"`
	// NextPageToken: A token to request the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Models") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Models") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListModelsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListModelsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRoutinesResponse: Describes the format of a single result page when
// listing routines.
type ListRoutinesResponse struct {
	// NextPageToken: A token to request the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Routines: Routines in the requested dataset. Unless read_mask is set in the
	// request, only the following fields are populated: etag, project_id,
	// dataset_id, routine_id, routine_type, creation_time, last_modified_time,
	// language, and remote_function_options.
	Routines []*Routine `json:"routines,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRoutinesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRoutinesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRowAccessPoliciesResponse: Response message for the
// ListRowAccessPolicies method.
type ListRowAccessPoliciesResponse struct {
	// NextPageToken: A token to request the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// RowAccessPolicies: Row access policies on the requested table.
	RowAccessPolicies []*RowAccessPolicy `json:"rowAccessPolicies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRowAccessPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRowAccessPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LoadQueryStatistics: Statistics for a LOAD query.
type LoadQueryStatistics struct {
	// BadRecords: Output only. The number of bad records encountered while
	// processing a LOAD query. Note that if the job has failed because of more bad
	// records encountered than the maximum allowed in the load job configuration,
	// then this number can be less than the total number of bad records present in
	// the input data.
	BadRecords int64 `json:"badRecords,omitempty,string"`
	// BytesTransferred: Output only. This field is deprecated. The number of bytes
	// of source data copied over the network for a `LOAD` query.
	// `transferred_bytes` has the canonical value for physical transferred bytes,
	// which is used for BigQuery Omni billing.
	BytesTransferred int64 `json:"bytesTransferred,omitempty,string"`
	// InputFileBytes: Output only. Number of bytes of source data in a LOAD query.
	InputFileBytes int64 `json:"inputFileBytes,omitempty,string"`
	// InputFiles: Output only. Number of source files in a LOAD query.
	InputFiles int64 `json:"inputFiles,omitempty,string"`
	// OutputBytes: Output only. Size of the loaded data in bytes. Note that while
	// a LOAD query is in the running state, this value may change.
	OutputBytes int64 `json:"outputBytes,omitempty,string"`
	// OutputRows: Output only. Number of rows imported in a LOAD query. Note that
	// while a LOAD query is in the running state, this value may change.
	OutputRows int64 `json:"outputRows,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BadRecords") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BadRecords") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoadQueryStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod LoadQueryStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocationMetadata: BigQuery-specific metadata about a location. This will be
// set on google.cloud.location.Location.metadata in Cloud Location API
// responses.
type LocationMetadata struct {
	// LegacyLocationId: The legacy BigQuery location ID, e.g. “EU” for the
	// “europe” location. This is for any API consumers that need the legacy
	// “US” and “EU” locations.
	LegacyLocationId string `json:"legacyLocationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LegacyLocationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LegacyLocationId") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod LocationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaterializedView: A materialized view considered for a query job.
type MaterializedView struct {
	// Chosen: Whether the materialized view is chosen for the query. A
	// materialized view can be chosen to rewrite multiple parts of the same query.
	// If a materialized view is chosen to rewrite any part of the query, then this
	// field is true, even if the materialized view was not chosen to rewrite
	// others parts.
	Chosen bool `json:"chosen,omitempty"`
	// EstimatedBytesSaved: If present, specifies a best-effort estimation of the
	// bytes saved by using the materialized view rather than its base tables.
	EstimatedBytesSaved int64 `json:"estimatedBytesSaved,omitempty,string"`
	// RejectedReason: If present, specifies the reason why the materialized view
	// was not chosen for the query.
	//
	// Possible values:
	//   "REJECTED_REASON_UNSPECIFIED" - Default unspecified value.
	//   "NO_DATA" - View has no cached data because it has not refreshed yet.
	//   "COST" - The estimated cost of the view is more expensive than another
	// view or the base table. Note: The estimate cost might not match the billed
	// cost.
	//   "BASE_TABLE_TRUNCATED" - View has no cached data because a base table is
	// truncated.
	//   "BASE_TABLE_DATA_CHANGE" - View is invalidated because of a data change in
	// one or more base tables. It could be any recent change if the
	// [`maxStaleness`](https://cloud.google.com/bigquery/docs/reference/rest/v2/tab
	// les#Table.FIELDS.max_staleness) option is not set for the view, or otherwise
	// any change outside of the staleness window.
	//   "BASE_TABLE_PARTITION_EXPIRATION_CHANGE" - View is invalidated because a
	// base table's partition expiration has changed.
	//   "BASE_TABLE_EXPIRED_PARTITION" - View is invalidated because a base
	// table's partition has expired.
	//   "BASE_TABLE_INCOMPATIBLE_METADATA_CHANGE" - View is invalidated because a
	// base table has an incompatible metadata change.
	//   "TIME_ZONE" - View is invalidated because it was refreshed with a time
	// zone other than that of the current job.
	//   "OUT_OF_TIME_TRAVEL_WINDOW" - View is outside the time travel window.
	//   "BASE_TABLE_FINE_GRAINED_SECURITY_POLICY" - View is inaccessible to the
	// user because of a fine-grained security policy on one of its base tables.
	//   "BASE_TABLE_TOO_STALE" - One of the view's base tables is too stale. For
	// example, the cached metadata of a BigLake external table needs to be
	// updated.
	RejectedReason string `json:"rejectedReason,omitempty"`
	// TableReference: The candidate materialized view.
	TableReference *TableReference `json:"tableReference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Chosen") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Chosen") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaterializedView) MarshalJSON() ([]byte, error) {
	type NoMethod MaterializedView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaterializedViewDefinition: Definition and configuration of a materialized
// view.
type MaterializedViewDefinition struct {
	// AllowNonIncrementalDefinition: Optional. This option declares the intention
	// to construct a materialized view that isn't refreshed incrementally.
	// Non-incremental materialized views support an expanded range of SQL queries.
	// The `allow_non_incremental_definition` option can't be changed after the
	// materialized view is created.
	AllowNonIncrementalDefinition bool `json:"allowNonIncrementalDefinition,omitempty"`
	// EnableRefresh: Optional. Enable automatic refresh of the materialized view
	// when the base table is updated. The default value is "true".
	EnableRefresh bool `json:"enableRefresh,omitempty"`
	// LastRefreshTime: Output only. The time when this materialized view was last
	// refreshed, in milliseconds since the epoch.
	LastRefreshTime int64 `json:"lastRefreshTime,omitempty,string"`
	// MaxStaleness: [Optional] Max staleness of data that could be returned when
	// materizlized view is queried (formatted as Google SQL Interval type).
	MaxStaleness string `json:"maxStaleness,omitempty"`
	// Query: Required. A query whose results are persisted.
	Query string `json:"query,omitempty"`
	// RefreshIntervalMs: Optional. The maximum frequency at which this
	// materialized view will be refreshed. The default value is "1800000" (30
	// minutes).
	RefreshIntervalMs int64 `json:"refreshIntervalMs,omitempty,string"`
	// ForceSendFields is a list of field names (e.g.
	// "AllowNonIncrementalDefinition") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowNonIncrementalDefinition")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaterializedViewDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod MaterializedViewDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaterializedViewStatistics: Statistics of materialized views considered in a
// query job.
type MaterializedViewStatistics struct {
	// MaterializedView: Materialized views considered for the query job. Only
	// certain materialized views are used. For a detailed list, see the child
	// message. If many materialized views are considered, then the list might be
	// incomplete.
	MaterializedView []*MaterializedView `json:"materializedView,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaterializedView") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaterializedView") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaterializedViewStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod MaterializedViewStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaterializedViewStatus: Status of a materialized view. The last refresh
// timestamp status is omitted here, but is present in the
// MaterializedViewDefinition message.
type MaterializedViewStatus struct {
	// LastRefreshStatus: Output only. Error result of the last automatic refresh.
	// If present, indicates that the last automatic refresh was unsuccessful.
	LastRefreshStatus *ErrorProto `json:"lastRefreshStatus,omitempty"`
	// RefreshWatermark: Output only. Refresh watermark of materialized view. The
	// base tables' data were collected into the materialized view cache until this
	// time.
	RefreshWatermark string `json:"refreshWatermark,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastRefreshStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastRefreshStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaterializedViewStatus) MarshalJSON() ([]byte, error) {
	type NoMethod MaterializedViewStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MetadataCacheStatistics: Statistics for metadata caching in queried tables.
type MetadataCacheStatistics struct {
	// TableMetadataCacheUsage: Set for the Metadata caching eligible tables
	// referenced in the query.
	TableMetadataCacheUsage []*TableMetadataCacheUsage `json:"tableMetadataCacheUsage,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TableMetadataCacheUsage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TableMetadataCacheUsage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MetadataCacheStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod MetadataCacheStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MlStatistics: Job statistics specific to a BigQuery ML training job.
type MlStatistics struct {
	// HparamTrials: Output only. Trials of a hyperparameter tuning job
	// (https://cloud.google.com/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview)
	// sorted by trial_id.
	HparamTrials []*HparamTuningTrial `json:"hparamTrials,omitempty"`
	// IterationResults: Results for all completed iterations. Empty for
	// hyperparameter tuning jobs
	// (https://cloud.google.com/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview).
	IterationResults []*IterationResult `json:"iterationResults,omitempty"`
	// MaxIterations: Output only. Maximum number of iterations specified as
	// max_iterations in the 'CREATE MODEL' query. The actual number of iterations
	// may be less than this number due to early stop.
	MaxIterations int64 `json:"maxIterations,omitempty,string"`
	// ModelType: Output only. The type of the model that is being trained.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - Default value.
	//   "LINEAR_REGRESSION" - Linear regression model.
	//   "LOGISTIC_REGRESSION" - Logistic regression based classification model.
	//   "KMEANS" - K-means clustering model.
	//   "MATRIX_FACTORIZATION" - Matrix factorization model.
	//   "DNN_CLASSIFIER" - DNN classifier model.
	//   "TENSORFLOW" - An imported TensorFlow model.
	//   "DNN_REGRESSOR" - DNN regressor model.
	//   "XGBOOST" - An imported XGBoost model.
	//   "BOOSTED_TREE_REGRESSOR" - Boosted tree regressor model.
	//   "BOOSTED_TREE_CLASSIFIER" - Boosted tree classifier model.
	//   "ARIMA" - ARIMA model.
	//   "AUTOML_REGRESSOR" - AutoML Tables regression model.
	//   "AUTOML_CLASSIFIER" - AutoML Tables classification model.
	//   "PCA" - Prinpical Component Analysis model.
	//   "DNN_LINEAR_COMBINED_CLASSIFIER" - Wide-and-deep classifier model.
	//   "DNN_LINEAR_COMBINED_REGRESSOR" - Wide-and-deep regressor model.
	//   "AUTOENCODER" - Autoencoder model.
	//   "ARIMA_PLUS" - New name for the ARIMA model.
	//   "ARIMA_PLUS_XREG" - ARIMA with external regressors.
	//   "RANDOM_FOREST_REGRESSOR" - Random forest regressor model.
	//   "RANDOM_FOREST_CLASSIFIER" - Random forest classifier model.
	//   "TENSORFLOW_LITE" - An imported TensorFlow Lite model.
	//   "ONNX" - An imported ONNX model.
	//   "TRANSFORM_ONLY" - Model to capture the columns and logic in the TRANSFORM
	// clause along with statistics useful for ML analytic functions.
	//   "CONTRIBUTION_ANALYSIS" - The contribution analysis model.
	ModelType string `json:"modelType,omitempty"`
	// TrainingType: Output only. Training type of the job.
	//
	// Possible values:
	//   "TRAINING_TYPE_UNSPECIFIED" - Unspecified training type.
	//   "SINGLE_TRAINING" - Single training with fixed parameter space.
	//   "HPARAM_TUNING" - [Hyperparameter tuning
	// training](https://cloud.google.com/bigquery-ml/docs/reference/standard-sql/bi
	// gqueryml-syntax-hp-tuning-overview).
	TrainingType string `json:"trainingType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HparamTrials") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HparamTrials") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MlStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod MlStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Model struct {
	// BestTrialId: The best trial_id across all training runs.
	BestTrialId int64 `json:"bestTrialId,omitempty,string"`
	// CreationTime: Output only. The time when this model was created, in
	// millisecs since the epoch.
	CreationTime int64 `json:"creationTime,omitempty,string"`
	// DefaultTrialId: Output only. The default trial_id to use in TVFs when the
	// trial_id is not passed in. For single-objective hyperparameter tuning
	// (https://cloud.google.com/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview)
	// models, this is the best trial ID. For multi-objective hyperparameter tuning
	// (https://cloud.google.com/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview)
	// models, this is the smallest trial ID among all Pareto optimal trials.
	DefaultTrialId int64 `json:"defaultTrialId,omitempty,string"`
	// Description: Optional. A user-friendly description of this model.
	Description string `json:"description,omitempty"`
	// EncryptionConfiguration: Custom encryption configuration (e.g., Cloud KMS
	// keys). This shows the encryption configuration of the model data while
	// stored in BigQuery storage. This field can be used with PatchModel to update
	// encryption key for an already encrypted model.
	EncryptionConfiguration *EncryptionConfiguration `json:"encryptionConfiguration,omitempty"`
	// Etag: Output only. A hash of this resource.
	Etag string `json:"etag,omitempty"`
	// ExpirationTime: Optional. The time when this model expires, in milliseconds
	// since the epoch. If not present, the model will persist indefinitely.
	// Expired models will be deleted and their storage reclaimed. The
	// defaultTableExpirationMs property of the encapsulating dataset can be used
	// to set a default expirationTime on newly created models.
	ExpirationTime int64 `json:"expirationTime,omitempty,string"`
	// FeatureColumns: Output only. Input feature columns for the model inference.
	// If the model is trained with TRANSFORM clause, these are the input of the
	// TRANSFORM clause.
	FeatureColumns []*StandardSqlField `json:"featureColumns,omitempty"`
	// FriendlyName: Optional. A descriptive name for this model.
	FriendlyName string `json:"friendlyName,omitempty"`
	// HparamSearchSpaces: Output only. All hyperparameter search spaces in this
	// model.
	HparamSearchSpaces *HparamSearchSpaces `json:"hparamSearchSpaces,omitempty"`
	// HparamTrials: Output only. Trials of a hyperparameter tuning
	// (https://cloud.google.com/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview)
	// model sorted by trial_id.
	HparamTrials []*HparamTuningTrial `json:"hparamTrials,omitempty"`
	// LabelColumns: Output only. Label columns that were used to train this model.
	// The output of the model will have a "predicted_" prefix to these columns.
	LabelColumns []*StandardSqlField `json:"labelColumns,omitempty"`
	// Labels: The labels associated with this model. You can use these to organize
	// and group your models. Label keys and values can be no longer than 63
	// characters, can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. Label values
	// are optional. Label keys must start with a letter and each label in the list
	// must have a different key.
	Labels map[string]string `json:"labels,omitempty"`
	// LastModifiedTime: Output only. The time when this model was last modified,
	// in millisecs since the epoch.
	LastModifiedTime int64 `json:"lastModifiedTime,omitempty,string"`
	// Location: Output only. The geographic location where the model resides. This
	// value is inherited from the dataset.
	Location string `json:"location,omitempty"`
	// ModelReference: Required. Unique identifier for this model.
	ModelReference *ModelReference `json:"modelReference,omitempty"`
	// ModelType: Output only. Type of the model resource.
	//
	// Possible values:
	//   "MODEL_TYPE_UNSPECIFIED" - Default value.
	//   "LINEAR_REGRESSION" - Linear regression model.
	//   "LOGISTIC_REGRESSION" - Logistic regression based classification model.
	//   "KMEANS" - K-means clustering model.
	//   "MATRIX_FACTORIZATION" - Matrix factorization model.
	//   "DNN_CLASSIFIER" - DNN classifier model.
	//   "TENSORFLOW" - An imported TensorFlow model.
	//   "DNN_REGRESSOR" - DNN regressor model.
	//   "XGBOOST" - An imported XGBoost model.
	//   "BOOSTED_TREE_REGRESSOR" - Boosted tree regressor model.
	//   "BOOSTED_TREE_CLASSIFIER" - Boosted tree classifier model.
	//   "ARIMA" - ARIMA model.
	//   "AUTOML_REGRESSOR" - AutoML Tables regression model.
	//   "AUTOML_CLASSIFIER" - AutoML Tables classification model.
	//   "PCA" - Prinpical Component Analysis model.
	//   "DNN_LINEAR_COMBINED_CLASSIFIER" - Wide-and-deep classifier model.
	//   "DNN_LINEAR_COMBINED_REGRESSOR" - Wide-and-deep regressor model.
	//   "AUTOENCODER" - Autoencoder model.
	//   "ARIMA_PLUS" - New name for the ARIMA model.
	//   "ARIMA_PLUS_XREG" - ARIMA with external regressors.
	//   "RANDOM_FOREST_REGRESSOR" - Random forest regressor model.
	//   "RANDOM_FOREST_CLASSIFIER" - Random forest classifier model.
	//   "TENSORFLOW_LITE" - An imported TensorFlow Lite model.
	//   "ONNX" - An imported ONNX model.
	//   "TRANSFORM_ONLY" - Model to capture the columns and logic in the TRANSFORM
	// clause along with statistics useful for ML analytic functions.
	//   "CONTRIBUTION_ANALYSIS" - The contribution analysis model.
	ModelType string `json:"modelType,omitempty"`
	// OptimalTrialIds: Output only. For single-objective hyperparameter tuning
	// (https://cloud.google.com/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview)
	// models, it only contains the best trial. For multi-objective hyperparameter
	// tuning
	// (https://cloud.google.com/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview)
	// models, it contains all Pareto optimal trials sorted by trial_id.
	OptimalTrialIds googleapi.Int64s `json:"optimalTrialIds,omitempty"`
	// RemoteModelInfo: Output only. Remote model info
	RemoteModelInfo *RemoteModelInfo `json:"remoteModelInfo,omitempty"`
	// TrainingRuns: Information for all training runs in increasing order of
	// start_time.
	TrainingRuns []*TrainingRun `json:"trainingRuns,omitempty"`
	// TransformColumns: Output only. This field will be populated if a TRANSFORM
	// clause was used to train a model. TRANSFORM clause (if used) takes
	// feature_columns as input and outputs transform_columns. transform_columns
	// then are used to train the model.
	TransformColumns []*TransformColumn `json:"transformColumns,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BestTrialId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BestTrialId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Model) MarshalJSON() ([]byte, error) {
	type NoMethod Model
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ModelDefinition struct {
	// ModelOptions: Deprecated.
	ModelOptions *ModelDefinitionModelOptions `json:"modelOptions,omitempty"`
	// TrainingRuns: Deprecated.
	TrainingRuns []*BqmlTrainingRun `json:"trainingRuns,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModelOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModelOptions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModelDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod ModelDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModelDefinitionModelOptions: Deprecated.
type ModelDefinitionModelOptions struct {
	Labels    []string `json:"labels,omitempty"`
	LossType  string   `json:"lossType,omitempty"`
	ModelType string   `json:"modelType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModelDefinitionModelOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ModelDefinitionModelOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModelExtractOptions: Options related to model extraction.
type ModelExtractOptions struct {
	// TrialId: The 1-based ID of the trial to be exported from a hyperparameter
	// tuning model. If not specified, the trial with id = Model
	// (https://cloud.google.com/bigquery/docs/reference/rest/v2/models#resource:-model).defaultTrialId
	// is exported. This field is ignored for models not trained with
	// hyperparameter tuning.
	TrialId int64 `json:"trialId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "TrialId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrialId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModelExtractOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ModelExtractOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ModelReference: Id path of a model.
type ModelReference struct {
	// DatasetId: Required. The ID of the dataset containing this model.
	DatasetId string `json:"datasetId,omitempty"`
	// ModelId: Required. The ID of the model. The ID must contain only letters
	// (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024
	// characters.
	ModelId string `json:"modelId,omitempty"`
	// ProjectId: Required. The ID of the project containing this model.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ModelReference) MarshalJSON() ([]byte, error) {
	type NoMethod ModelReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MultiClassClassificationMetrics: Evaluation metrics for multi-class
// classification/classifier models.
type MultiClassClassificationMetrics struct {
	// AggregateClassificationMetrics: Aggregate classification metrics.
	AggregateClassificationMetrics *AggregateClassificationMetrics `json:"aggregateClassificationMetrics,omitempty"`
	// ConfusionMatrixList: Confusion matrix at different thresholds.
	ConfusionMatrixList []*ConfusionMatrix `json:"confusionMatrixList,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AggregateClassificationMetrics") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregateClassificationMetrics")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MultiClassClassificationMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod MultiClassClassificationMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ParquetOptions: Parquet Options for load and make external tables.
type ParquetOptions struct {
	// EnableListInference: Optional. Indicates whether to use schema inference
	// specifically for Parquet LIST logical type.
	EnableListInference bool `json:"enableListInference,omitempty"`
	// EnumAsString: Optional. Indicates whether to infer Parquet ENUM logical type
	// as STRING instead of BYTES by default.
	EnumAsString bool `json:"enumAsString,omitempty"`
	// MapTargetType: Optional. Indicates how to represent a Parquet map if
	// present.
	//
	// Possible values:
	//   "MAP_TARGET_TYPE_UNSPECIFIED" - In this mode, the map will have the
	// following schema: struct map_field_name { repeated struct key_value { key
	// value } }.
	//   "ARRAY_OF_STRUCT" - In this mode, the map will have the following schema:
	// repeated struct map_field_name { key value }.
	MapTargetType string `json:"mapTargetType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableListInference") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableListInference") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ParquetOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ParquetOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PartitionSkew: Partition skew detailed information.
type PartitionSkew struct {
	// SkewSources: Output only. Source stages which produce skewed data.
	SkewSources []*SkewSource `json:"skewSources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SkewSources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SkewSources") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PartitionSkew) MarshalJSON() ([]byte, error) {
	type NoMethod PartitionSkew
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PartitionedColumn: The partitioning column information.
type PartitionedColumn struct {
	// Field: Required. The name of the partition column.
	Field string `json:"field,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PartitionedColumn) MarshalJSON() ([]byte, error) {
	type NoMethod PartitionedColumn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PartitioningDefinition: The partitioning information, which includes managed
// table, external table and metastore partitioned table partition information.
type PartitioningDefinition struct {
	// PartitionedColumn: Optional. Details about each partitioning column. This
	// field is output only for all partitioning types other than metastore
	// partitioned tables. BigQuery native tables only support 1 partitioning
	// column. Other table types may support 0, 1 or more partitioning columns. For
	// metastore partitioned tables, the order must match the definition order in
	// the Hive Metastore, where it must match the physical layout of the table.
	// For example, CREATE TABLE a_table(id BIGINT, name STRING) PARTITIONED BY
	// (city STRING, state STRING). In this case the values must be ['city',
	// 'state'] in that order.
	PartitionedColumn []*PartitionedColumn `json:"partitionedColumn,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PartitionedColumn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PartitionedColumn") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PartitioningDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod PartitioningDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PerformanceInsights: Performance insights for the job.
type PerformanceInsights struct {
	// AvgPreviousExecutionMs: Output only. Average execution ms of previous runs.
	// Indicates the job ran slow compared to previous executions. To find previous
	// executions, use INFORMATION_SCHEMA tables and filter jobs with same query
	// hash.
	AvgPreviousExecutionMs int64 `json:"avgPreviousExecutionMs,omitempty,string"`
	// StagePerformanceChangeInsights: Output only. Query stage performance
	// insights compared to previous runs, for diagnosing performance regression.
	StagePerformanceChangeInsights []*StagePerformanceChangeInsight `json:"stagePerformanceChangeInsights,omitempty"`
	// StagePerformanceStandaloneInsights: Output only. Standalone query stage
	// performance insights, for exploring potential improvements.
	StagePerformanceStandaloneInsights []*StagePerformanceStandaloneInsight `json:"stagePerformanceStandaloneInsights,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvgPreviousExecutionMs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvgPreviousExecutionMs") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PerformanceInsights) MarshalJSON() ([]byte, error) {
	type NoMethod PerformanceInsights
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources. A `Policy` is a collection of
// `bindings`. A `binding` binds one or more `members`, or principals, to a
// single `role`. Principals can be user accounts, service accounts, Google
// groups, and domains (such as G Suite). A `role` is a named list of
// permissions; each `role` can be an IAM predefined role or a user-created
// custom role. For some types of Google Cloud resources, a `binding` can also
// specify a `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or both. To
// learn which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PrincipalComponentInfo: Principal component infos, used only for eigen
// decomposition based models, e.g., PCA. Ordered by explained_variance in the
// descending order.
type PrincipalComponentInfo struct {
	// CumulativeExplainedVarianceRatio: The explained_variance is pre-ordered in
	// the descending order to compute the cumulative explained variance ratio.
	CumulativeExplainedVarianceRatio float64 `json:"cumulativeExplainedVarianceRatio,omitempty"`
	// ExplainedVariance: Explained variance by this principal component, which is
	// simply the eigenvalue.
	ExplainedVariance float64 `json:"explainedVariance,omitempty"`
	// ExplainedVarianceRatio: Explained_variance over the total explained
	// variance.
	ExplainedVarianceRatio float64 `json:"explainedVarianceRatio,omitempty"`
	// PrincipalComponentId: Id of the principal component.
	PrincipalComponentId int64 `json:"principalComponentId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g.
	// "CumulativeExplainedVarianceRatio") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "CumulativeExplainedVarianceRatio") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s PrincipalComponentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod PrincipalComponentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *PrincipalComponentInfo) UnmarshalJSON(data []byte) error {
	type NoMethod PrincipalComponentInfo
	var s1 struct {
		CumulativeExplainedVarianceRatio gensupport.JSONFloat64 `json:"cumulativeExplainedVarianceRatio"`
		ExplainedVariance                gensupport.JSONFloat64 `json:"explainedVariance"`
		ExplainedVarianceRatio           gensupport.JSONFloat64 `json:"explainedVarianceRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CumulativeExplainedVarianceRatio = float64(s1.CumulativeExplainedVarianceRatio)
	s.ExplainedVariance = float64(s1.ExplainedVariance)
	s.ExplainedVarianceRatio = float64(s1.ExplainedVarianceRatio)
	return nil
}

// PrivacyPolicy: Represents privacy policy that contains the privacy
// requirements specified by the data owner. Currently, this is only supported
// on views.
type PrivacyPolicy struct {
	// AggregationThresholdPolicy: Optional. Policy used for aggregation
	// thresholds.
	AggregationThresholdPolicy *AggregationThresholdPolicy `json:"aggregationThresholdPolicy,omitempty"`
	// DifferentialPrivacyPolicy: Optional. Policy used for differential privacy.
	DifferentialPrivacyPolicy *DifferentialPrivacyPolicy `json:"differentialPrivacyPolicy,omitempty"`
	// JoinRestrictionPolicy: Optional. Join restriction policy is outside of the
	// one of policies, since this policy can be set along with other policies.
	// This policy gives data providers the ability to enforce joins on the
	// 'join_allowed_columns' when data is queried from a privacy protected view.
	JoinRestrictionPolicy *JoinRestrictionPolicy `json:"joinRestrictionPolicy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregationThresholdPolicy")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregationThresholdPolicy") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PrivacyPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod PrivacyPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProjectList: Response object of ListProjects
type ProjectList struct {
	// Etag: A hash of the page of results.
	Etag string `json:"etag,omitempty"`
	// Kind: The resource type of the response.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: Use this token to request the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Projects: Projects to which the user has at least READ access.
	Projects []*ProjectListProjects `json:"projects,omitempty"`
	// TotalItems: The total number of projects in the page. A wrapper is used here
	// because the field should still be in the response when the value is 0.
	TotalItems int64 `json:"totalItems,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProjectList) MarshalJSON() ([]byte, error) {
	type NoMethod ProjectList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProjectListProjects: Information about a single project.
type ProjectListProjects struct {
	// FriendlyName: A descriptive name for this project. A wrapper is used here
	// because friendlyName can be set to the empty string.
	FriendlyName string `json:"friendlyName,omitempty"`
	// Id: An opaque ID of this project.
	Id string `json:"id,omitempty"`
	// Kind: The resource type.
	Kind string `json:"kind,omitempty"`
	// NumericId: The numeric ID of this project.
	NumericId uint64 `json:"numericId,omitempty,string"`
	// ProjectReference: A unique reference to this project.
	ProjectReference *ProjectReference `json:"projectReference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FriendlyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FriendlyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProjectListProjects) MarshalJSON() ([]byte, error) {
	type NoMethod ProjectListProjects
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProjectReference: A unique reference to a project.
type ProjectReference struct {
	// ProjectId: Required. ID of the project. Can be either the numeric ID or the
	// assigned ID of the project.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProjectId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProjectId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProjectReference) MarshalJSON() ([]byte, error) {
	type NoMethod ProjectReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PythonOptions: Options for a user-defined Python function.
type PythonOptions struct {
	// EntryPoint: Required. The entry point function in the user's Python code.
	EntryPoint string `json:"entryPoint,omitempty"`
	// Packages: Optional. A list of package names along with versions to be
	// installed. Follows requirements.txt syntax (e.g. numpy==2.0, permutation,
	// urllib3<2.2.1)
	Packages []string `json:"packages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EntryPoint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EntryPoint") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PythonOptions) MarshalJSON() ([]byte, error) {
	type NoMethod PythonOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryInfo: Query optimization information for a QUERY job.
type QueryInfo struct {
	// OptimizationDetails: Output only. Information about query optimizations.
	OptimizationDetails googleapi.RawMessage `json:"optimizationDetails,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OptimizationDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OptimizationDetails") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryInfo) MarshalJSON() ([]byte, error) {
	type NoMethod QueryInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryParameter: A parameter given to a query.
type QueryParameter struct {
	// Name: Optional. If unset, this is a positional parameter. Otherwise, should
	// be unique within a query.
	Name string `json:"name,omitempty"`
	// ParameterType: Required. The type of this parameter.
	ParameterType *QueryParameterType `json:"parameterType,omitempty"`
	// ParameterValue: Required. The value of this parameter.
	ParameterValue *QueryParameterValue `json:"parameterValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryParameter) MarshalJSON() ([]byte, error) {
	type NoMethod QueryParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryParameterType: The type of a query parameter.
type QueryParameterType struct {
	// ArrayType: Optional. The type of the array's elements, if this is an array.
	ArrayType *QueryParameterType `json:"arrayType,omitempty"`
	// RangeElementType: Optional. The element type of the range, if this is a
	// range.
	RangeElementType *QueryParameterType `json:"rangeElementType,omitempty"`
	// StructTypes: Optional. The types of the fields of this struct, in order, if
	// this is a struct.
	StructTypes []*QueryParameterTypeStructTypes `json:"structTypes,omitempty"`
	// Type: Required. The top level type of this field.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArrayType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArrayType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryParameterType) MarshalJSON() ([]byte, error) {
	type NoMethod QueryParameterType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryParameterTypeStructTypes: The type of a struct parameter.
type QueryParameterTypeStructTypes struct {
	// Description: Optional. Human-oriented description of the field.
	Description string `json:"description,omitempty"`
	// Name: Optional. The name of this field.
	Name string `json:"name,omitempty"`
	// Type: Required. The type of this field.
	Type *QueryParameterType `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryParameterTypeStructTypes) MarshalJSON() ([]byte, error) {
	type NoMethod QueryParameterTypeStructTypes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryParameterValue: The value of a query parameter.
type QueryParameterValue struct {
	// ArrayValues: Optional. The array values, if this is an array type.
	ArrayValues []*QueryParameterValue `json:"arrayValues,omitempty"`
	// RangeValue: Optional. The range value, if this is a range type.
	RangeValue *RangeValue `json:"rangeValue,omitempty"`
	// StructValues: The struct field values.
	StructValues map[string]QueryParameterValue `json:"structValues,omitempty"`
	// Value: Optional. The value of this value, if a simple scalar type.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArrayValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArrayValues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryParameterValue) MarshalJSON() ([]byte, error) {
	type NoMethod QueryParameterValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryRequest: Describes the format of the jobs.query request.
type QueryRequest struct {
	// ConnectionProperties: Optional. Connection properties which can modify the
	// query behavior.
	ConnectionProperties []*ConnectionProperty `json:"connectionProperties,omitempty"`
	// Continuous: [Optional] Specifies whether the query should be executed as a
	// continuous query. The default value is false.
	Continuous bool `json:"continuous,omitempty"`
	// CreateSession: Optional. If true, creates a new session using a randomly
	// generated session_id. If false, runs query with an existing session_id
	// passed in ConnectionProperty, otherwise runs query in non-session mode. The
	// session location will be set to QueryRequest.location if it is present,
	// otherwise it's set to the default location based on existing routing logic.
	CreateSession bool `json:"createSession,omitempty"`
	// DefaultDataset: Optional. Specifies the default datasetId and projectId to
	// assume for any unqualified table names in the query. If not set, all table
	// names in the query string must be qualified in the format
	// 'datasetId.tableId'.
	DefaultDataset *DatasetReference `json:"defaultDataset,omitempty"`
	// DestinationEncryptionConfiguration: Optional. Custom encryption
	// configuration (e.g., Cloud KMS keys)
	DestinationEncryptionConfiguration *EncryptionConfiguration `json:"destinationEncryptionConfiguration,omitempty"`
	// DryRun: Optional. If set to true, BigQuery doesn't run the job. Instead, if
	// the query is valid, BigQuery returns statistics about the job such as how
	// many bytes would be processed. If the query is invalid, an error returns.
	// The default value is false.
	DryRun bool `json:"dryRun,omitempty"`
	// FormatOptions: Optional. Output format adjustments.
	FormatOptions *DataFormatOptions `json:"formatOptions,omitempty"`
	// JobCreationMode: Optional. If not set, jobs are always required. If set, the
	// query request will follow the behavior described JobCreationMode.
	//
	// Possible values:
	//   "JOB_CREATION_MODE_UNSPECIFIED" - If unspecified JOB_CREATION_REQUIRED is
	// the default.
	//   "JOB_CREATION_REQUIRED" - Default. Job creation is always required.
	//   "JOB_CREATION_OPTIONAL" - Job creation is optional. Returning immediate
	// results is prioritized. BigQuery will automatically determine if a Job needs
	// to be created. The conditions under which BigQuery can decide to not create
	// a Job are subject to change. If Job creation is required,
	// JOB_CREATION_REQUIRED mode should be used, which is the default.
	JobCreationMode string `json:"jobCreationMode,omitempty"`
	// JobTimeoutMs: Optional. Job timeout in milliseconds. If this time limit is
	// exceeded, BigQuery will attempt to stop a longer job, but may not always
	// succeed in canceling it before the job completes. For example, a job that
	// takes more than 60 seconds to complete has a better chance of being stopped
	// than a job that takes 10 seconds to complete. This timeout applies to the
	// query even if a job does not need to be created.
	JobTimeoutMs int64 `json:"jobTimeoutMs,omitempty,string"`
	// Kind: The resource type of the request.
	Kind string `json:"kind,omitempty"`
	// Labels: Optional. The labels associated with this query. Labels can be used
	// to organize and group query jobs. Label keys and values can be no longer
	// than 63 characters, can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. Label keys
	// must start with a letter and each label in the list must have a different
	// key.
	Labels map[string]string `json:"labels,omitempty"`
	// Location: The geographic location where the job should run. For more
	// information, see how to specify locations
	// (https://cloud.google.com/bigquery/docs/locations#specify_locations).
	Location string `json:"location,omitempty"`
	// MaxResults: Optional. The maximum number of rows of data to return per page
	// of results. Setting this flag to a small value such as 1000 and then paging
	// through results might improve reliability when the query result set is
	// large. In addition to this limit, responses are also limited to 10 MB. By
	// default, there is no maximum row count, and only the byte limit applies.
	MaxResults int64 `json:"maxResults,omitempty"`
	// MaximumBytesBilled: Optional. Limits the bytes billed for this query.
	// Queries with bytes billed above this limit will fail (without incurring a
	// charge). If unspecified, the project default is used.
	MaximumBytesBilled int64 `json:"maximumBytesBilled,omitempty,string"`
	// ParameterMode: GoogleSQL only. Set to POSITIONAL to use positional (?) query
	// parameters or to NAMED to use named (@myparam) query parameters in this
	// query.
	ParameterMode string `json:"parameterMode,omitempty"`
	// PreserveNulls: This property is deprecated.
	PreserveNulls bool `json:"preserveNulls,omitempty"`
	// Query: Required. A query string to execute, using Google Standard SQL or
	// legacy SQL syntax. Example: "SELECT COUNT(f1) FROM
	// myProjectId.myDatasetId.myTableId".
	Query string `json:"query,omitempty"`
	// QueryParameters: Query parameters for GoogleSQL queries.
	QueryParameters []*QueryParameter `json:"queryParameters,omitempty"`
	// RequestId: Optional. A unique user provided identifier to ensure idempotent
	// behavior for queries. Note that this is different from the job_id. It has
	// the following properties: 1. It is case-sensitive, limited to up to 36 ASCII
	// characters. A UUID is recommended. 2. Read only queries can ignore this
	// token since they are nullipotent by definition. 3. For the purposes of
	// idempotency ensured by the request_id, a request is considered duplicate of
	// another only if they have the same request_id and are actually duplicates.
	// When determining whether a request is a duplicate of another request, all
	// parameters in the request that may affect the result are considered. For
	// example, query, connection_properties, query_parameters, use_legacy_sql are
	// parameters that affect the result and are considered when determining
	// whether a request is a duplicate, but properties like timeout_ms don't
	// affect the result and are thus not considered. Dry run query requests are
	// never considered duplicate of another request. 4. When a duplicate mutating
	// query request is detected, it returns: a. the results of the mutation if it
	// completes successfully within the timeout. b. the running operation if it is
	// still in progress at the end of the timeout. 5. Its lifetime is limited to
	// 15 minutes. In other words, if two requests are sent with the same
	// request_id, but more than 15 minutes apart, idempotency is not guaranteed.
	RequestId string `json:"requestId,omitempty"`
	// Reservation: Optional. The reservation that jobs.query request would use.
	// User can specify a reservation to execute the job.query. The expected format
	// is `projects/{project}/locations/{location}/reservations/{reservation}`.
	Reservation string `json:"reservation,omitempty"`
	// TimeoutMs: Optional. Optional: Specifies the maximum amount of time, in
	// milliseconds, that the client is willing to wait for the query to complete.
	// By default, this limit is 10 seconds (10,000 milliseconds). If the query is
	// complete, the jobComplete field in the response is true. If the query has
	// not yet completed, jobComplete is false. You can request a longer timeout
	// period in the timeoutMs field. However, the call is not guaranteed to wait
	// for the specified timeout; it typically returns after around 200 seconds
	// (200,000 milliseconds), even if the query is not complete. If jobComplete is
	// false, you can continue to wait for the query to complete by calling the
	// getQueryResults method until the jobComplete field in the getQueryResults
	// response is true.
	TimeoutMs int64 `json:"timeoutMs,omitempty"`
	// UseLegacySql: Specifies whether to use BigQuery's legacy SQL dialect for
	// this query. The default value is true. If set to false, the query will use
	// BigQuery's GoogleSQL: https://cloud.google.com/bigquery/sql-reference/ When
	// useLegacySql is set to false, the value of flattenResults is ignored; query
	// will be run as if flattenResults is false.
	//
	// Default: true
	UseLegacySql *bool `json:"useLegacySql,omitempty"`
	// UseQueryCache: Optional. Whether to look for the result in the query cache.
	// The query cache is a best-effort cache that will be flushed whenever tables
	// in the query are modified. The default value is true.
	//
	// Default: true
	UseQueryCache *bool `json:"useQueryCache,omitempty"`
	// WriteIncrementalResults: Optional. This is only supported for SELECT query.
	// If set, the query is allowed to write results incrementally to the temporary
	// result table. This may incur a performance penalty. This option cannot be
	// used with Legacy SQL. This feature is not yet available.
	WriteIncrementalResults bool `json:"writeIncrementalResults,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionProperties") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionProperties") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod QueryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type QueryResponse struct {
	// CacheHit: Whether the query result was fetched from the query cache.
	CacheHit bool `json:"cacheHit,omitempty"`
	// CreationTime: Output only. Creation time of this query, in milliseconds
	// since the epoch. This field will be present on all queries.
	CreationTime int64 `json:"creationTime,omitempty,string"`
	// DmlStats: Output only. Detailed statistics for DML statements INSERT,
	// UPDATE, DELETE, MERGE or TRUNCATE.
	DmlStats *DmlStatistics `json:"dmlStats,omitempty"`
	// EndTime: Output only. End time of this query, in milliseconds since the
	// epoch. This field will be present whenever a query job is in the DONE state.
	EndTime int64 `json:"endTime,omitempty,string"`
	// Errors: Output only. The first errors or warnings encountered during the
	// running of the job. The final message includes the number of errors that
	// caused the process to stop. Errors here do not necessarily mean that the job
	// has completed or was unsuccessful. For more information about error
	// messages, see Error messages
	// (https://cloud.google.com/bigquery/docs/error-messages).
	Errors []*ErrorProto `json:"errors,omitempty"`
	// JobComplete: Whether the query has completed or not. If rows or totalRows
	// are present, this will always be true. If this is false, totalRows will not
	// be available.
	JobComplete bool `json:"jobComplete,omitempty"`
	// JobCreationReason: Optional. The reason why a Job was created. Only relevant
	// when a job_reference is present in the response. If job_reference is not
	// present it will always be unset.
	JobCreationReason *JobCreationReason `json:"jobCreationReason,omitempty"`
	// JobReference: Reference to the Job that was created to run the query. This
	// field will be present even if the original request timed out, in which case
	// GetQueryResults can be used to read the results once the query has
	// completed. Since this API only returns the first page of results, subsequent
	// pages can be fetched via the same mechanism (GetQueryResults). If
	// job_creation_mode was set to `JOB_CREATION_OPTIONAL` and the query completes
	// without creating a job, this field will be empty.
	JobReference *JobReference `json:"jobReference,omitempty"`
	// Kind: The resource type.
	Kind string `json:"kind,omitempty"`
	// Location: Output only. The geographic location of the query. For more
	// information about BigQuery locations, see:
	// https://cloud.google.com/bigquery/docs/locations
	Location string `json:"location,omitempty"`
	// NumDmlAffectedRows: Output only. The number of rows affected by a DML
	// statement. Present only for DML statements INSERT, UPDATE or DELETE.
	NumDmlAffectedRows int64 `json:"numDmlAffectedRows,omitempty,string"`
	// PageToken: A token used for paging results. A non-empty token indicates that
	// additional results are available. To see additional results, query the
	// `jobs.getQueryResults`
	// (https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/getQueryResults)
	// method. For more information, see Paging through table data
	// (https://cloud.google.com/bigquery/docs/paging-results).
	PageToken string `json:"pageToken,omitempty"`
	// QueryId: Auto-generated ID for the query.
	QueryId string `json:"queryId,omitempty"`
	// Rows: An object with as many results as can be contained within the maximum
	// permitted reply size. To get any additional rows, you can call
	// GetQueryResults and specify the jobReference returned above.
	Rows []*TableRow `json:"rows,omitempty"`
	// Schema: The schema of the results. Present only when the query completes
	// successfully.
	Schema *TableSchema `json:"schema,omitempty"`
	// SessionInfo: Output only. Information of the session if this job is part of
	// one.
	SessionInfo *SessionInfo `json:"sessionInfo,omitempty"`
	// StartTime: Output only. Start time of this query, in milliseconds since the
	// epoch. This field will be present when the query job transitions from the
	// PENDING state to either RUNNING or DONE.
	StartTime int64 `json:"startTime,omitempty,string"`
	// TotalBytesBilled: Output only. If the project is configured to use on-demand
	// pricing, then this field contains the total bytes billed for the job. If the
	// project is configured to use flat-rate pricing, then you are not billed for
	// bytes and this field is informational only.
	TotalBytesBilled int64 `json:"totalBytesBilled,omitempty,string"`
	// TotalBytesProcessed: The total number of bytes processed for this query. If
	// this query was a dry run, this is the number of bytes that would be
	// processed if the query were run.
	TotalBytesProcessed int64 `json:"totalBytesProcessed,omitempty,string"`
	// TotalRows: The total number of rows in the complete query result set, which
	// can be more than the number of rows in this single page of results.
	TotalRows uint64 `json:"totalRows,omitempty,string"`
	// TotalSlotMs: Output only. Number of slot ms the user is actually billed for.
	TotalSlotMs int64 `json:"totalSlotMs,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CacheHit") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CacheHit") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod QueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryTimelineSample: Summary of the state of query execution at a given
// time.
type QueryTimelineSample struct {
	// ActiveUnits: Total number of active workers. This does not correspond
	// directly to slot usage. This is the largest value observed since the last
	// sample.
	ActiveUnits int64 `json:"activeUnits,omitempty,string"`
	// CompletedUnits: Total parallel units of work completed by this query.
	CompletedUnits int64 `json:"completedUnits,omitempty,string"`
	// ElapsedMs: Milliseconds elapsed since the start of query execution.
	ElapsedMs int64 `json:"elapsedMs,omitempty,string"`
	// EstimatedRunnableUnits: Units of work that can be scheduled immediately.
	// Providing additional slots for these units of work will accelerate the
	// query, if no other query in the reservation needs additional slots.
	EstimatedRunnableUnits int64 `json:"estimatedRunnableUnits,omitempty,string"`
	// PendingUnits: Total units of work remaining for the query. This number can
	// be revised (increased or decreased) while the query is running.
	PendingUnits int64 `json:"pendingUnits,omitempty,string"`
	// ShuffleRamUsageRatio: Total shuffle usage ratio in shuffle RAM per
	// reservation of this query. This will be provided for reservation customers
	// only.
	ShuffleRamUsageRatio float64 `json:"shuffleRamUsageRatio,omitempty"`
	// TotalSlotMs: Cumulative slot-ms consumed by the query.
	TotalSlotMs int64 `json:"totalSlotMs,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ActiveUnits") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveUnits") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryTimelineSample) MarshalJSON() ([]byte, error) {
	type NoMethod QueryTimelineSample
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *QueryTimelineSample) UnmarshalJSON(data []byte) error {
	type NoMethod QueryTimelineSample
	var s1 struct {
		ShuffleRamUsageRatio gensupport.JSONFloat64 `json:"shuffleRamUsageRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ShuffleRamUsageRatio = float64(s1.ShuffleRamUsageRatio)
	return nil
}

type RangePartitioning struct {
	// Field: Required. The name of the column to partition the table on. It must
	// be a top-level, INT64 column whose mode is NULLABLE or REQUIRED.
	Field string `json:"field,omitempty"`
	// Range: [Experimental] Defines the ranges for range partitioning.
	Range *RangePartitioningRange `json:"range,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RangePartitioning) MarshalJSON() ([]byte, error) {
	type NoMethod RangePartitioning
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RangePartitioningRange: [Experimental] Defines the ranges for range
// partitioning.
type RangePartitioningRange struct {
	// End: [Experimental] The end of range partitioning, exclusive.
	End int64 `json:"end,omitempty,string"`
	// Interval: [Experimental] The width of each interval.
	Interval int64 `json:"interval,omitempty,string"`
	// Start: [Experimental] The start of range partitioning, inclusive.
	Start int64 `json:"start,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "End") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "End") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RangePartitioningRange) MarshalJSON() ([]byte, error) {
	type NoMethod RangePartitioningRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RangeValue: Represents the value of a range.
type RangeValue struct {
	// End: Optional. The end value of the range. A missing value represents an
	// unbounded end.
	End *QueryParameterValue `json:"end,omitempty"`
	// Start: Optional. The start value of the range. A missing value represents an
	// unbounded start.
	Start *QueryParameterValue `json:"start,omitempty"`
	// ForceSendFields is a list of field names (e.g. "End") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "End") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RangeValue) MarshalJSON() ([]byte, error) {
	type NoMethod RangeValue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RankingMetrics: Evaluation metrics used by weighted-ALS models specified by
// feedback_type=implicit.
type RankingMetrics struct {
	// AverageRank: Determines the goodness of a ranking by computing the
	// percentile rank from the predicted confidence and dividing it by the
	// original rank.
	AverageRank float64 `json:"averageRank,omitempty"`
	// MeanAveragePrecision: Calculates a precision per user for all the items by
	// ranking them and then averages all the precisions across all the users.
	MeanAveragePrecision float64 `json:"meanAveragePrecision,omitempty"`
	// MeanSquaredError: Similar to the mean squared error computed in regression
	// and explicit recommendation models except instead of computing the rating
	// directly, the output from evaluate is computed against a preference which is
	// 1 or 0 depending on if the rating exists or not.
	MeanSquaredError float64 `json:"meanSquaredError,omitempty"`
	// NormalizedDiscountedCumulativeGain: A metric to determine the goodness of a
	// ranking calculated from the predicted confidence by comparing it to an ideal
	// rank measured by the original ratings.
	NormalizedDiscountedCumulativeGain float64 `json:"normalizedDiscountedCumulativeGain,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AverageRank") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AverageRank") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RankingMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod RankingMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *RankingMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod RankingMetrics
	var s1 struct {
		AverageRank                        gensupport.JSONFloat64 `json:"averageRank"`
		MeanAveragePrecision               gensupport.JSONFloat64 `json:"meanAveragePrecision"`
		MeanSquaredError                   gensupport.JSONFloat64 `json:"meanSquaredError"`
		NormalizedDiscountedCumulativeGain gensupport.JSONFloat64 `json:"normalizedDiscountedCumulativeGain"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageRank = float64(s1.AverageRank)
	s.MeanAveragePrecision = float64(s1.MeanAveragePrecision)
	s.MeanSquaredError = float64(s1.MeanSquaredError)
	s.NormalizedDiscountedCumulativeGain = float64(s1.NormalizedDiscountedCumulativeGain)
	return nil
}

// RegressionMetrics: Evaluation metrics for regression and explicit feedback
// type matrix factorization models.
type RegressionMetrics struct {
	// MeanAbsoluteError: Mean absolute error.
	MeanAbsoluteError float64 `json:"meanAbsoluteError,omitempty"`
	// MeanSquaredError: Mean squared error.
	MeanSquaredError float64 `json:"meanSquaredError,omitempty"`
	// MeanSquaredLogError: Mean squared log error.
	MeanSquaredLogError float64 `json:"meanSquaredLogError,omitempty"`
	// MedianAbsoluteError: Median absolute error.
	MedianAbsoluteError float64 `json:"medianAbsoluteError,omitempty"`
	// RSquared: R^2 score. This corresponds to r2_score in ML.EVALUATE.
	RSquared float64 `json:"rSquared,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MeanAbsoluteError") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MeanAbsoluteError") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegressionMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod RegressionMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *RegressionMetrics) UnmarshalJSON(data []byte) error {
	type NoMethod RegressionMetrics
	var s1 struct {
		MeanAbsoluteError   gensupport.JSONFloat64 `json:"meanAbsoluteError"`
		MeanSquaredError    gensupport.JSONFloat64 `json:"meanSquaredError"`
		MeanSquaredLogError gensupport.JSONFloat64 `json:"meanSquaredLogError"`
		MedianAbsoluteError gensupport.JSONFloat64 `json:"medianAbsoluteError"`
		RSquared            gensupport.JSONFloat64 `json:"rSquared"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MeanAbsoluteError = float64(s1.MeanAbsoluteError)
	s.MeanSquaredError = float64(s1.MeanSquaredError)
	s.MeanSquaredLogError = float64(s1.MeanSquaredLogError)
	s.MedianAbsoluteError = float64(s1.MedianAbsoluteError)
	s.RSquared = float64(s1.RSquared)
	return nil
}

// RemoteFunctionOptions: Options for a remote user-defined function.
type RemoteFunctionOptions struct {
	// Connection: Fully qualified name of the user-provided connection object
	// which holds the authentication information to send requests to the remote
	// service. Format:
	// ``"projects/{projectId}/locations/{locationId}/connections/{connectionId}"`
	// `
	Connection string `json:"connection,omitempty"`
	// Endpoint: Endpoint of the user-provided remote service, e.g.
	// ```https://us-east1-my_gcf_project.cloudfunctions.net/remote_add```
	Endpoint string `json:"endpoint,omitempty"`
	// MaxBatchingRows: Max number of rows in each batch sent to the remote
	// service. If absent or if 0, BigQuery dynamically decides the number of rows
	// in a batch.
	MaxBatchingRows int64 `json:"maxBatchingRows,omitempty,string"`
	// UserDefinedContext: User-defined context as a set of key/value pairs, which
	// will be sent as function invocation context together with batched arguments
	// in the requests to the remote service. The total number of bytes of keys and
	// values must be less than 8KB.
	UserDefinedContext map[string]string `json:"userDefinedContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Connection") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Connection") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoteFunctionOptions) MarshalJSON() ([]byte, error) {
	type NoMethod RemoteFunctionOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RemoteModelInfo: Remote Model Info
type RemoteModelInfo struct {
	// Connection: Output only. Fully qualified name of the user-provided
	// connection object of the remote model. Format:
	// ``"projects/{project_id}/locations/{location_id}/connections/{connection_id}
	// "``
	Connection string `json:"connection,omitempty"`
	// Endpoint: Output only. The endpoint for remote model.
	Endpoint string `json:"endpoint,omitempty"`
	// MaxBatchingRows: Output only. Max number of rows in each batch sent to the
	// remote service. If unset, the number of rows in each batch is set
	// dynamically.
	MaxBatchingRows int64 `json:"maxBatchingRows,omitempty,string"`
	// RemoteModelVersion: Output only. The model version for LLM.
	RemoteModelVersion string `json:"remoteModelVersion,omitempty"`
	// RemoteServiceType: Output only. The remote service type for remote model.
	//
	// Possible values:
	//   "REMOTE_SERVICE_TYPE_UNSPECIFIED" - Unspecified remote service type.
	//   "CLOUD_AI_TRANSLATE_V3" - V3 Cloud AI Translation API. See more details at
	// [Cloud Translation API]
	// (https://cloud.google.com/translate/docs/reference/rest).
	//   "CLOUD_AI_VISION_V1" - V1 Cloud AI Vision API See more details at [Cloud
	// Vision API] (https://cloud.google.com/vision/docs/reference/rest).
	//   "CLOUD_AI_NATURAL_LANGUAGE_V1" - V1 Cloud AI Natural Language API. See
	// more details at [REST Resource:
	// documents](https://cloud.google.com/natural-language/docs/reference/rest/v1/d
	// ocuments).
	//   "CLOUD_AI_SPEECH_TO_TEXT_V2" - V2 Speech-to-Text API. See more details at
	// [Google Cloud Speech-to-Text V2
	// API](https://cloud.google.com/speech-to-text/v2/docs)
	RemoteServiceType string `json:"remoteServiceType,omitempty"`
	// SpeechRecognizer: Output only. The name of the speech recognizer to use for
	// speech recognition. The expected format is
	// `projects/{project}/locations/{location}/recognizers/{recognizer}`.
	// Customers can specify this field at model creation. If not specified, a
	// default recognizer `projects/{model project}/locations/global/recognizers/_`
	// will be used. See more details at recognizers
	// (https://cloud.google.com/speech-to-text/v2/docs/reference/rest/v2/projects.locations.recognizers)
	SpeechRecognizer string `json:"speechRecognizer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Connection") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Connection") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RemoteModelInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RemoteModelInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RestrictionConfig struct {
	// Type: Output only. Specifies the type of dataset/table restriction.
	//
	// Possible values:
	//   "RESTRICTION_TYPE_UNSPECIFIED" - Should never be used.
	//   "RESTRICTED_DATA_EGRESS" - Restrict data egress. See [Data
	// egress](https://cloud.google.com/bigquery/docs/analytics-hub-introduction#dat
	// a_egress) for more details.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RestrictionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RestrictionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Routine: A user-defined function or a stored procedure.
type Routine struct {
	// Arguments: Optional.
	Arguments []*Argument `json:"arguments,omitempty"`
	// CreationTime: Output only. The time when this routine was created, in
	// milliseconds since the epoch.
	CreationTime int64 `json:"creationTime,omitempty,string"`
	// DataGovernanceType: Optional. If set to `DATA_MASKING`, the function is
	// validated and made available as a masking function. For more information,
	// see Create custom masking routines
	// (https://cloud.google.com/bigquery/docs/user-defined-functions#custom-mask).
	//
	// Possible values:
	//   "DATA_GOVERNANCE_TYPE_UNSPECIFIED" - The data governance type is
	// unspecified.
	//   "DATA_MASKING" - The data governance type is data masking.
	DataGovernanceType string `json:"dataGovernanceType,omitempty"`
	// DefinitionBody: Required. The body of the routine. For functions, this is
	// the expression in the AS clause. If language=SQL, it is the substring inside
	// (but excluding) the parentheses. For example, for the function created with
	// the following statement: `CREATE FUNCTION JoinLines(x string, y string) as
	// (concat(x, "\n", y))` The definition_body is `concat(x, "\n", y)` (\n is not
	// replaced with linebreak). If language=JAVASCRIPT, it is the evaluated string
	// in the AS clause. For example, for the function created with the following
	// statement: `CREATE FUNCTION f() RETURNS STRING LANGUAGE js AS 'return
	// "\n";\n'` The definition_body is `return "\n";\n` Note that both \n are
	// replaced with linebreaks.
	DefinitionBody string `json:"definitionBody,omitempty"`
	// Description: Optional. The description of the routine, if defined.
	Description string `json:"description,omitempty"`
	// DeterminismLevel: Optional. The determinism level of the JavaScript UDF, if
	// defined.
	//
	// Possible values:
	//   "DETERMINISM_LEVEL_UNSPECIFIED" - The determinism of the UDF is
	// unspecified.
	//   "DETERMINISTIC" - The UDF is deterministic, meaning that 2 function calls
	// with the same inputs always produce the same result, even across 2 query
	// runs.
	//   "NOT_DETERMINISTIC" - The UDF is not deterministic.
	DeterminismLevel string `json:"determinismLevel,omitempty"`
	// Etag: Output only. A hash of this resource.
	Etag string `json:"etag,omitempty"`
	// ExternalRuntimeOptions: Optional. Options for the runtime of the external
	// system executing the routine. This field is only applicable for Python UDFs.
	// Preview (https://cloud.google.com/products/#product-launch-stages)
	ExternalRuntimeOptions *ExternalRuntimeOptions `json:"externalRuntimeOptions,omitempty"`
	// ImportedLibraries: Optional. If language = "JAVASCRIPT", this field stores
	// the path of the imported JAVASCRIPT libraries.
	ImportedLibraries []string `json:"importedLibraries,omitempty"`
	// Language: Optional. Defaults to "SQL" if remote_function_options field is
	// absent, not set otherwise.
	//
	// Possible values:
	//   "LANGUAGE_UNSPECIFIED" - Default value.
	//   "SQL" - SQL language.
	//   "JAVASCRIPT" - JavaScript language.
	//   "PYTHON" - Python language.
	//   "JAVA" - Java language.
	//   "SCALA" - Scala language.
	Language string `json:"language,omitempty"`
	// LastModifiedTime: Output only. The time when this routine was last modified,
	// in milliseconds since the epoch.
	LastModifiedTime int64 `json:"lastModifiedTime,omitempty,string"`
	// PythonOptions: Optional. Options for Python UDF. Preview
	// (https://cloud.google.com/products/#product-launch-stages)
	PythonOptions *PythonOptions `json:"pythonOptions,omitempty"`
	// RemoteFunctionOptions: Optional. Remote function specific options.
	RemoteFunctionOptions *RemoteFunctionOptions `json:"remoteFunctionOptions,omitempty"`
	// ReturnTableType: Optional. Can be set only if routine_type =
	// "TABLE_VALUED_FUNCTION". If absent, the return table type is inferred from
	// definition_body at query time in each query that references this routine. If
	// present, then the columns in the evaluated table result will be cast to
	// match the column types specified in return table type, at query time.
	ReturnTableType *StandardSqlTableType `json:"returnTableType,omitempty"`
	// ReturnType: Optional if language = "SQL"; required otherwise. Cannot be set
	// if routine_type = "TABLE_VALUED_FUNCTION". If absent, the return type is
	// inferred from definition_body at query time in each query that references
	// this routine. If present, then the evaluated result will be cast to the
	// specified returned type at query time. For example, for the functions
	// created with the following statements: * `CREATE FUNCTION Add(x FLOAT64, y
	// FLOAT64) RETURNS FLOAT64 AS (x + y);` * `CREATE FUNCTION Increment(x
	// FLOAT64) AS (Add(x, 1));` * `CREATE FUNCTION Decrement(x FLOAT64) RETURNS
	// FLOAT64 AS (Add(x, -1));` The return_type is `{type_kind: "FLOAT64"}` for
	// `Add` and `Decrement`, and is absent for `Increment` (inferred as FLOAT64 at
	// query time). Suppose the function `Add` is replaced by `CREATE OR REPLACE
	// FUNCTION Add(x INT64, y INT64) AS (x + y);` Then the inferred return type of
	// `Increment` is automatically changed to INT64 at query time, while the
	// return type of `Decrement` remains FLOAT64.
	ReturnType *StandardSqlDataType `json:"returnType,omitempty"`
	// RoutineReference: Required. Reference describing the ID of this routine.
	RoutineReference *RoutineReference `json:"routineReference,omitempty"`
	// RoutineType: Required. The type of routine.
	//
	// Possible values:
	//   "ROUTINE_TYPE_UNSPECIFIED" - Default value.
	//   "SCALAR_FUNCTION" - Non-built-in persistent scalar function.
	//   "PROCEDURE" - Stored procedure.
	//   "TABLE_VALUED_FUNCTION" - Non-built-in persistent TVF.
	//   "AGGREGATE_FUNCTION" - Non-built-in persistent aggregate function.
	RoutineType string `json:"routineType,omitempty"`
	// SecurityMode: Optional. The security mode of the routine, if defined. If not
	// defined, the security mode is automatically determined from the routine's
	// configuration.
	//
	// Possible values:
	//   "SECURITY_MODE_UNSPECIFIED" - The security mode of the routine is
	// unspecified.
	//   "DEFINER" - The routine is to be executed with the privileges of the user
	// who defines it.
	//   "INVOKER" - The routine is to be executed with the privileges of the user
	// who invokes it.
	SecurityMode string `json:"securityMode,omitempty"`
	// SparkOptions: Optional. Spark specific options.
	SparkOptions *SparkOptions `json:"sparkOptions,omitempty"`
	// StrictMode: Optional. Use this option to catch many common errors. Error
	// checking is not exhaustive, and successfully creating a procedure doesn't
	// guarantee that the procedure will successfully execute at runtime. If
	// `strictMode` is set to `TRUE`, the procedure body is further checked for
	// errors such as non-existent tables or columns. The `CREATE PROCEDURE`
	// statement fails if the body fails any of these checks. If `strictMode` is
	// set to `FALSE`, the procedure body is checked only for syntax. For
	// procedures that invoke themselves recursively, specify `strictMode=FALSE` to
	// avoid non-existent procedure errors during validation. Default value is
	// `TRUE`.
	StrictMode bool `json:"strictMode,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Arguments") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Arguments") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Routine) MarshalJSON() ([]byte, error) {
	type NoMethod Routine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RoutineReference: Id path of a routine.
type RoutineReference struct {
	// DatasetId: Required. The ID of the dataset containing this routine.
	DatasetId string `json:"datasetId,omitempty"`
	// ProjectId: Required. The ID of the project containing this routine.
	ProjectId string `json:"projectId,omitempty"`
	// RoutineId: Required. The ID of the routine. The ID must contain only letters
	// (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256
	// characters.
	RoutineId string `json:"routineId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RoutineReference) MarshalJSON() ([]byte, error) {
	type NoMethod RoutineReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Row: A single row in the confusion matrix.
type Row struct {
	// ActualLabel: The original label of this row.
	ActualLabel string `json:"actualLabel,omitempty"`
	// Entries: Info describing predicted label distribution.
	Entries []*Entry `json:"entries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActualLabel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActualLabel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Row) MarshalJSON() ([]byte, error) {
	type NoMethod Row
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RowAccessPolicy: Represents access on a subset of rows on the specified
// table, defined by its filter predicate. Access to the subset of rows is
// controlled by its IAM policy.
type RowAccessPolicy struct {
	// CreationTime: Output only. The time when this row access policy was created,
	// in milliseconds since the epoch.
	CreationTime string `json:"creationTime,omitempty"`
	// Etag: Output only. A hash of this resource.
	Etag string `json:"etag,omitempty"`
	// FilterPredicate: Required. A SQL boolean expression that represents the rows
	// defined by this row access policy, similar to the boolean expression in a
	// WHERE clause of a SELECT query on a table. References to other tables,
	// routines, and temporary functions are not supported. Examples: region="EU"
	// date_field = CAST('2019-9-27' as DATE) nullable_field is not NULL
	// numeric_field BETWEEN 1.0 AND 5.0
	FilterPredicate string `json:"filterPredicate,omitempty"`
	// Grantees: Optional. Input only. The optional list of iam_member users or
	// groups that specifies the initial members that the row-level access policy
	// should be created with. grantees types: - "user:alice@example.com": An email
	// address that represents a specific Google account. -
	// "serviceAccount:my-other-app@appspot.gserviceaccount.com": An email address
	// that represents a service account. - "group:admins@example.com": An email
	// address that represents a Google group. - "domain:example.com":The Google
	// Workspace domain (primary) that represents all the users of that domain. -
	// "allAuthenticatedUsers": A special identifier that represents all service
	// accounts and all users on the internet who have authenticated with a Google
	// Account. This identifier includes accounts that aren't connected to a Google
	// Workspace or Cloud Identity domain, such as personal Gmail accounts. Users
	// who aren't authenticated, such as anonymous visitors, aren't included. -
	// "allUsers":A special identifier that represents anyone who is on the
	// internet, including authenticated and unauthenticated users. Because
	// BigQuery requires authentication before a user can access the service,
	// allUsers includes only authenticated users.
	Grantees []string `json:"grantees,omitempty"`
	// LastModifiedTime: Output only. The time when this row access policy was last
	// modified, in milliseconds since the epoch.
	LastModifiedTime string `json:"lastModifiedTime,omitempty"`
	// RowAccessPolicyReference: Required. Reference describing the ID of this row
	// access policy.
	RowAccessPolicyReference *RowAccessPolicyReference `json:"rowAccessPolicyReference,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreationTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RowAccessPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod RowAccessPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RowAccessPolicyReference: Id path of a row access policy.
type RowAccessPolicyReference struct {
	// DatasetId: Required. The ID of the dataset containing this row access
	// policy.
	DatasetId string `json:"datasetId,omitempty"`
	// PolicyId: Required. The ID of the row access policy. The ID must contain
	// only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum
	// length is 256 characters.
	PolicyId string `json:"policyId,omitempty"`
	// ProjectId: Required. The ID of the project containing this row access
	// policy.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The ID of the table containing this row access policy.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RowAccessPolicyReference) MarshalJSON() ([]byte, error) {
	type NoMethod RowAccessPolicyReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RowLevelSecurityStatistics: Statistics for row-level security.
type RowLevelSecurityStatistics struct {
	// RowLevelSecurityApplied: Whether any accessed data was protected by row
	// access policies.
	RowLevelSecurityApplied bool `json:"rowLevelSecurityApplied,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RowLevelSecurityApplied") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RowLevelSecurityApplied") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RowLevelSecurityStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod RowLevelSecurityStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ScriptOptions: Options related to script execution.
type ScriptOptions struct {
	// KeyResultStatement: Determines which statement in the script represents the
	// "key result", used to populate the schema and query results of the script
	// job. Default is LAST.
	//
	// Possible values:
	//   "KEY_RESULT_STATEMENT_KIND_UNSPECIFIED" - Default value.
	//   "LAST" - The last result determines the key result.
	//   "FIRST_SELECT" - The first SELECT statement determines the key result.
	KeyResultStatement string `json:"keyResultStatement,omitempty"`
	// StatementByteBudget: Limit on the number of bytes billed per statement.
	// Exceeding this budget results in an error.
	StatementByteBudget int64 `json:"statementByteBudget,omitempty,string"`
	// StatementTimeoutMs: Timeout period for each statement in a script.
	StatementTimeoutMs int64 `json:"statementTimeoutMs,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "KeyResultStatement") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KeyResultStatement") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ScriptOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ScriptOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ScriptStackFrame: Represents the location of the statement/expression being
// evaluated. Line and column numbers are defined as follows: - Line and column
// numbers start with one. That is, line 1 column 1 denotes the start of the
// script. - When inside a stored procedure, all line/column numbers are
// relative to the procedure body, not the script in which the procedure was
// defined. - Start/end positions exclude leading/trailing comments and
// whitespace. The end position always ends with a ";", when present. -
// Multi-byte Unicode characters are treated as just one column. - If the
// original script (or procedure definition) contains TAB characters, a tab
// "snaps" the indentation forward to the nearest multiple of 8 characters,
// plus 1. For example, a TAB on column 1, 2, 3, 4, 5, 6 , or 8 will advance
// the next character to column 9. A TAB on column 9, 10, 11, 12, 13, 14, 15,
// or 16 will advance the next character to column 17.
type ScriptStackFrame struct {
	// EndColumn: Output only. One-based end column.
	EndColumn int64 `json:"endColumn,omitempty"`
	// EndLine: Output only. One-based end line.
	EndLine int64 `json:"endLine,omitempty"`
	// ProcedureId: Output only. Name of the active procedure, empty if in a
	// top-level script.
	ProcedureId string `json:"procedureId,omitempty"`
	// StartColumn: Output only. One-based start column.
	StartColumn int64 `json:"startColumn,omitempty"`
	// StartLine: Output only. One-based start line.
	StartLine int64 `json:"startLine,omitempty"`
	// Text: Output only. Text of the current statement/expression.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndColumn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndColumn") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ScriptStackFrame) MarshalJSON() ([]byte, error) {
	type NoMethod ScriptStackFrame
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ScriptStatistics: Job statistics specific to the child job of a script.
type ScriptStatistics struct {
	// EvaluationKind: Whether this child job was a statement or expression.
	//
	// Possible values:
	//   "EVALUATION_KIND_UNSPECIFIED" - Default value.
	//   "STATEMENT" - The statement appears directly in the script.
	//   "EXPRESSION" - The statement evaluates an expression that appears in the
	// script.
	EvaluationKind string `json:"evaluationKind,omitempty"`
	// StackFrames: Stack trace showing the line/column/procedure name of each
	// frame on the stack at the point where the current evaluation happened. The
	// leaf frame is first, the primary script is last. Never empty.
	StackFrames []*ScriptStackFrame `json:"stackFrames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvaluationKind") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvaluationKind") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ScriptStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod ScriptStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchStatistics: Statistics for a search query. Populated as part of
// JobStatistics2.
type SearchStatistics struct {
	// IndexUnusedReasons: When `indexUsageMode` is `UNUSED` or `PARTIALLY_USED`,
	// this field explains why indexes were not used in all or part of the search
	// query. If `indexUsageMode` is `FULLY_USED`, this field is not populated.
	IndexUnusedReasons []*IndexUnusedReason `json:"indexUnusedReasons,omitempty"`
	// IndexUsageMode: Specifies the index usage mode for the query.
	//
	// Possible values:
	//   "INDEX_USAGE_MODE_UNSPECIFIED" - Index usage mode not specified.
	//   "UNUSED" - No search indexes were used in the search query. See
	// [`indexUnusedReasons`]
	// (/bigquery/docs/reference/rest/v2/Job#IndexUnusedReason) for detailed
	// reasons.
	//   "PARTIALLY_USED" - Part of the search query used search indexes. See
	// [`indexUnusedReasons`]
	// (/bigquery/docs/reference/rest/v2/Job#IndexUnusedReason) for why other parts
	// of the query did not use search indexes.
	//   "FULLY_USED" - The entire search query used search indexes.
	IndexUsageMode string `json:"indexUsageMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IndexUnusedReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IndexUnusedReasons") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod SearchStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SerDeInfo: Serializer and deserializer information.
type SerDeInfo struct {
	// Name: Optional. Name of the SerDe. The maximum length is 256 characters.
	Name string `json:"name,omitempty"`
	// Parameters: Optional. Key-value pairs that define the initialization
	// parameters for the serialization library. Maximum size 10 Kib.
	Parameters map[string]string `json:"parameters,omitempty"`
	// SerializationLibrary: Required. Specifies a fully-qualified class name of
	// the serialization library that is responsible for the translation of data
	// between table representation and the underlying low-level input and output
	// format structures. The maximum length is 256 characters.
	SerializationLibrary string `json:"serializationLibrary,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SerDeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SerDeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SessionInfo: [Preview] Information related to sessions.
type SessionInfo struct {
	// SessionId: Output only. The id of the session.
	SessionId string `json:"sessionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SessionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SessionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SessionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SessionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *Policy `json:"policy,omitempty"`
	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
	// modify. Only the fields in the mask will be modified. If no mask is
	// provided, the following default mask is used: `paths: "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SkewSource: Details about source stages which produce skewed data.
type SkewSource struct {
	// StageId: Output only. Stage id of the skew source stage.
	StageId int64 `json:"stageId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "StageId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StageId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SkewSource) MarshalJSON() ([]byte, error) {
	type NoMethod SkewSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SnapshotDefinition: Information about base table and snapshot time of the
// snapshot.
type SnapshotDefinition struct {
	// BaseTableReference: Required. Reference describing the ID of the table that
	// was snapshot.
	BaseTableReference *TableReference `json:"baseTableReference,omitempty"`
	// SnapshotTime: Required. The time at which the base table was snapshot. This
	// value is reported in the JSON response using RFC3339 format.
	SnapshotTime string `json:"snapshotTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseTableReference") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseTableReference") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SnapshotDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod SnapshotDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkLoggingInfo: Spark job logs can be filtered by these fields in Cloud
// Logging.
type SparkLoggingInfo struct {
	// ProjectId: Output only. Project ID where the Spark logs were written.
	ProjectId string `json:"projectId,omitempty"`
	// ResourceType: Output only. Resource type used for logging.
	ResourceType string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProjectId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProjectId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkLoggingInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SparkLoggingInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkOptions: Options for a user-defined Spark routine.
type SparkOptions struct {
	// ArchiveUris: Archive files to be extracted into the working directory of
	// each executor. For more information about Apache Spark, see Apache Spark
	// (https://spark.apache.org/docs/latest/index.html).
	ArchiveUris []string `json:"archiveUris,omitempty"`
	// Connection: Fully qualified name of the user-provided Spark connection
	// object. Format:
	// ``"projects/{project_id}/locations/{location_id}/connections/{connection_id}
	// "``
	Connection string `json:"connection,omitempty"`
	// ContainerImage: Custom container image for the runtime environment.
	ContainerImage string `json:"containerImage,omitempty"`
	// FileUris: Files to be placed in the working directory of each executor. For
	// more information about Apache Spark, see Apache Spark
	// (https://spark.apache.org/docs/latest/index.html).
	FileUris []string `json:"fileUris,omitempty"`
	// JarUris: JARs to include on the driver and executor CLASSPATH. For more
	// information about Apache Spark, see Apache Spark
	// (https://spark.apache.org/docs/latest/index.html).
	JarUris []string `json:"jarUris,omitempty"`
	// MainClass: The fully qualified name of a class in jar_uris, for example,
	// com.example.wordcount. Exactly one of main_class and main_jar_uri field
	// should be set for Java/Scala language type.
	MainClass string `json:"mainClass,omitempty"`
	// MainFileUri: The main file/jar URI of the Spark application. Exactly one of
	// the definition_body field and the main_file_uri field must be set for
	// Python. Exactly one of main_class and main_file_uri field should be set for
	// Java/Scala language type.
	MainFileUri string `json:"mainFileUri,omitempty"`
	// Properties: Configuration properties as a set of key/value pairs, which will
	// be passed on to the Spark application. For more information, see Apache
	// Spark (https://spark.apache.org/docs/latest/index.html) and the procedure
	// option list
	// (https://cloud.google.com/bigquery/docs/reference/standard-sql/data-definition-language#procedure_option_list).
	Properties map[string]string `json:"properties,omitempty"`
	// PyFileUris: Python files to be placed on the PYTHONPATH for PySpark
	// application. Supported file types: `.py`, `.egg`, and `.zip`. For more
	// information about Apache Spark, see Apache Spark
	// (https://spark.apache.org/docs/latest/index.html).
	PyFileUris []string `json:"pyFileUris,omitempty"`
	// RuntimeVersion: Runtime version. If not specified, the default runtime
	// version is used.
	RuntimeVersion string `json:"runtimeVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArchiveUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkOptions) MarshalJSON() ([]byte, error) {
	type NoMethod SparkOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkStatistics: Statistics for a BigSpark query. Populated as part of
// JobStatistics2
type SparkStatistics struct {
	// Endpoints: Output only. Endpoints returned from Dataproc. Key list: -
	// history_server_endpoint: A link to Spark job UI.
	Endpoints map[string]string `json:"endpoints,omitempty"`
	// GcsStagingBucket: Output only. The Google Cloud Storage bucket that is used
	// as the default file system by the Spark application. This field is only
	// filled when the Spark procedure uses the invoker security mode. The
	// `gcsStagingBucket` bucket is inferred from the
	// `@@spark_proc_properties.staging_bucket` system variable (if it is
	// provided). Otherwise, BigQuery creates a default staging bucket for the job
	// and returns the bucket name in this field. Example: * `gs://[bucket_name]`
	GcsStagingBucket string `json:"gcsStagingBucket,omitempty"`
	// KmsKeyName: Output only. The Cloud KMS encryption key that is used to
	// protect the resources created by the Spark job. If the Spark procedure uses
	// the invoker security mode, the Cloud KMS encryption key is either inferred
	// from the provided system variable, `@@spark_proc_properties.kms_key_name`,
	// or the default key of the BigQuery job's project (if the CMEK organization
	// policy is enforced). Otherwise, the Cloud KMS key is either inferred from
	// the Spark connection associated with the procedure (if it is provided), or
	// from the default key of the Spark connection's project if the CMEK
	// organization policy is enforced. Example: *
	// `projects/[kms_project_id]/locations/[region]/keyRings/[key_region]/cryptoKey
	// s/[key]`
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// LoggingInfo: Output only. Logging info is used to generate a link to Cloud
	// Logging.
	LoggingInfo *SparkLoggingInfo `json:"loggingInfo,omitempty"`
	// SparkJobId: Output only. Spark job ID if a Spark job is created
	// successfully.
	SparkJobId string `json:"sparkJobId,omitempty"`
	// SparkJobLocation: Output only. Location where the Spark job is executed. A
	// location is selected by BigQueury for jobs configured to run in a
	// multi-region.
	SparkJobLocation string `json:"sparkJobLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Endpoints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Endpoints") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod SparkStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StagePerformanceChangeInsight: Performance insights compared to the previous
// executions for a specific stage.
type StagePerformanceChangeInsight struct {
	// InputDataChange: Output only. Input data change insight of the query stage.
	InputDataChange *InputDataChange `json:"inputDataChange,omitempty"`
	// StageId: Output only. The stage id that the insight mapped to.
	StageId int64 `json:"stageId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "InputDataChange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputDataChange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StagePerformanceChangeInsight) MarshalJSON() ([]byte, error) {
	type NoMethod StagePerformanceChangeInsight
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StagePerformanceStandaloneInsight: Standalone performance insights for a
// specific stage.
type StagePerformanceStandaloneInsight struct {
	// BiEngineReasons: Output only. If present, the stage had the following
	// reasons for being disqualified from BI Engine execution.
	BiEngineReasons []*BiEngineReason `json:"biEngineReasons,omitempty"`
	// HighCardinalityJoins: Output only. High cardinality joins in the stage.
	HighCardinalityJoins []*HighCardinalityJoin `json:"highCardinalityJoins,omitempty"`
	// InsufficientShuffleQuota: Output only. True if the stage has insufficient
	// shuffle quota.
	InsufficientShuffleQuota bool `json:"insufficientShuffleQuota,omitempty"`
	// PartitionSkew: Output only. Partition skew in the stage.
	PartitionSkew *PartitionSkew `json:"partitionSkew,omitempty"`
	// SlotContention: Output only. True if the stage has a slot contention issue.
	SlotContention bool `json:"slotContention,omitempty"`
	// StageId: Output only. The stage id that the insight mapped to.
	StageId int64 `json:"stageId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BiEngineReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BiEngineReasons") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StagePerformanceStandaloneInsight) MarshalJSON() ([]byte, error) {
	type NoMethod StagePerformanceStandaloneInsight
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StandardSqlDataType: The data type of a variable such as a function
// argument. Examples include: * INT64: `{"typeKind": "INT64"}` * ARRAY: {
// "typeKind": "ARRAY", "arrayElementType": {"typeKind": "STRING"} } * STRUCT>:
// { "typeKind": "STRUCT", "structType": { "fields": [ { "name": "x", "type":
// {"typeKind": "STRING"} }, { "name": "y", "type": { "typeKind": "ARRAY",
// "arrayElementType": {"typeKind": "DATE"} } } ] } } * RANGE: { "typeKind":
// "RANGE", "rangeElementType": {"typeKind": "DATE"} }
type StandardSqlDataType struct {
	// ArrayElementType: The type of the array's elements, if type_kind = "ARRAY".
	ArrayElementType *StandardSqlDataType `json:"arrayElementType,omitempty"`
	// RangeElementType: The type of the range's elements, if type_kind = "RANGE".
	RangeElementType *StandardSqlDataType `json:"rangeElementType,omitempty"`
	// StructType: The fields of this struct, in order, if type_kind = "STRUCT".
	StructType *StandardSqlStructType `json:"structType,omitempty"`
	// TypeKind: Required. The top level type of this field. Can be any GoogleSQL
	// data type (e.g., "INT64", "DATE", "ARRAY").
	//
	// Possible values:
	//   "TYPE_KIND_UNSPECIFIED" - Invalid type.
	//   "INT64" - Encoded as a string in decimal format.
	//   "BOOL" - Encoded as a boolean "false" or "true".
	//   "FLOAT64" - Encoded as a number, or string "NaN", "Infinity" or
	// "-Infinity".
	//   "STRING" - Encoded as a string value.
	//   "BYTES" - Encoded as a base64 string per RFC 4648, section 4.
	//   "TIMESTAMP" - Encoded as an RFC 3339 timestamp with mandatory "Z" time
	// zone string: 1985-04-12T23:20:50.52Z
	//   "DATE" - Encoded as RFC 3339 full-date format string: 1985-04-12
	//   "TIME" - Encoded as RFC 3339 partial-time format string: 23:20:50.52
	//   "DATETIME" - Encoded as RFC 3339 full-date "T" partial-time:
	// 1985-04-12T23:20:50.52
	//   "INTERVAL" - Encoded as fully qualified 3 part: 0-5 15 2:30:45.6
	//   "GEOGRAPHY" - Encoded as WKT
	//   "NUMERIC" - Encoded as a decimal string.
	//   "BIGNUMERIC" - Encoded as a decimal string.
	//   "JSON" - Encoded as a string.
	//   "ARRAY" - Encoded as a list with types matching Type.array_type.
	//   "STRUCT" - Encoded as a list with fields of type Type.struct_type[i]. List
	// is used because a JSON object cannot have duplicate field names.
	//   "RANGE" - Encoded as a pair with types matching range_element_type. Pairs
	// must begin with "[", end with ")", and be separated by ", ".
	TypeKind string `json:"typeKind,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArrayElementType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArrayElementType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StandardSqlDataType) MarshalJSON() ([]byte, error) {
	type NoMethod StandardSqlDataType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StandardSqlField: A field or a column.
type StandardSqlField struct {
	// Name: Optional. The name of this field. Can be absent for struct fields.
	Name string `json:"name,omitempty"`
	// Type: Optional. The type of this parameter. Absent if not explicitly
	// specified (e.g., CREATE FUNCTION statement can omit the return type; in this
	// case the output parameter does not have this "type" field).
	Type *StandardSqlDataType `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StandardSqlField) MarshalJSON() ([]byte, error) {
	type NoMethod StandardSqlField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StandardSqlStructType: The representation of a SQL STRUCT type.
type StandardSqlStructType struct {
	// Fields: Fields within the struct.
	Fields []*StandardSqlField `json:"fields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fields") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StandardSqlStructType) MarshalJSON() ([]byte, error) {
	type NoMethod StandardSqlStructType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StandardSqlTableType: A table type
type StandardSqlTableType struct {
	// Columns: The columns in this table type
	Columns []*StandardSqlField `json:"columns,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Columns") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Columns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StandardSqlTableType) MarshalJSON() ([]byte, error) {
	type NoMethod StandardSqlTableType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StorageDescriptor: Contains information about how a table's data is stored
// and accessed by open source query engines.
type StorageDescriptor struct {
	// InputFormat: Optional. Specifies the fully qualified class name of the
	// InputFormat (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat"). The
	// maximum length is 128 characters.
	InputFormat string `json:"inputFormat,omitempty"`
	// LocationUri: Optional. The physical location of the table (e.g.
	// `gs://spark-dataproc-data/pangea-data/case_sensitive/` or
	// `gs://spark-dataproc-data/pangea-data/*`). The maximum length is 2056 bytes.
	LocationUri string `json:"locationUri,omitempty"`
	// OutputFormat: Optional. Specifies the fully qualified class name of the
	// OutputFormat (e.g. "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat"). The
	// maximum length is 128 characters.
	OutputFormat string `json:"outputFormat,omitempty"`
	// SerdeInfo: Optional. Serializer and deserializer information.
	SerdeInfo *SerDeInfo `json:"serdeInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InputFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InputFormat") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StorageDescriptor) MarshalJSON() ([]byte, error) {
	type NoMethod StorageDescriptor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StoredColumnsUnusedReason: If the stored column was not used, explain why.
type StoredColumnsUnusedReason struct {
	// Code: Specifies the high-level reason for the unused scenario, each reason
	// must have a code associated.
	//
	// Possible values:
	//   "CODE_UNSPECIFIED" - Default value.
	//   "STORED_COLUMNS_COVER_INSUFFICIENT" - If stored columns do not fully cover
	// the columns.
	//   "BASE_TABLE_HAS_RLS" - If the base table has RLS (Row Level Security).
	//   "BASE_TABLE_HAS_CLS" - If the base table has CLS (Column Level Security).
	//   "UNSUPPORTED_PREFILTER" - If the provided prefilter is not supported.
	//   "INTERNAL_ERROR" - If an internal error is preventing stored columns from
	// being used.
	//   "OTHER_REASON" - Indicates that the reason stored columns cannot be used
	// in the query is not covered by any of the other StoredColumnsUnusedReason
	// options.
	Code string `json:"code,omitempty"`
	// Message: Specifies the detailed description for the scenario.
	Message string `json:"message,omitempty"`
	// UncoveredColumns: Specifies which columns were not covered by the stored
	// columns for the specified code up to 20 columns. This is populated when the
	// code is STORED_COLUMNS_COVER_INSUFFICIENT and BASE_TABLE_HAS_CLS.
	UncoveredColumns []string `json:"uncoveredColumns,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StoredColumnsUnusedReason) MarshalJSON() ([]byte, error) {
	type NoMethod StoredColumnsUnusedReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StoredColumnsUsage: Indicates the stored columns usage in the query.
type StoredColumnsUsage struct {
	// BaseTable: Specifies the base table.
	BaseTable *TableReference `json:"baseTable,omitempty"`
	// IsQueryAccelerated: Specifies whether the query was accelerated with stored
	// columns.
	IsQueryAccelerated bool `json:"isQueryAccelerated,omitempty"`
	// StoredColumnsUnusedReasons: If stored columns were not used, explain why.
	StoredColumnsUnusedReasons []*StoredColumnsUnusedReason `json:"storedColumnsUnusedReasons,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseTable") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseTable") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StoredColumnsUsage) MarshalJSON() ([]byte, error) {
	type NoMethod StoredColumnsUsage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Streamingbuffer struct {
	// EstimatedBytes: Output only. A lower-bound estimate of the number of bytes
	// currently in the streaming buffer.
	EstimatedBytes uint64 `json:"estimatedBytes,omitempty,string"`
	// EstimatedRows: Output only. A lower-bound estimate of the number of rows
	// currently in the streaming buffer.
	EstimatedRows uint64 `json:"estimatedRows,omitempty,string"`
	// OldestEntryTime: Output only. Contains the timestamp of the oldest entry in
	// the streaming buffer, in milliseconds since the epoch, if the streaming
	// buffer is available.
	OldestEntryTime uint64 `json:"oldestEntryTime,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "EstimatedBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EstimatedBytes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Streamingbuffer) MarshalJSON() ([]byte, error) {
	type NoMethod Streamingbuffer
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StringHparamSearchSpace: Search space for string and enum.
type StringHparamSearchSpace struct {
	// Candidates: Canididates for the string or enum parameter in lower case.
	Candidates []string `json:"candidates,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Candidates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Candidates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StringHparamSearchSpace) MarshalJSON() ([]byte, error) {
	type NoMethod StringHparamSearchSpace
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SystemVariables: System variables given to a query.
type SystemVariables struct {
	// Types: Output only. Data type for each system variable.
	Types map[string]StandardSqlDataType `json:"types,omitempty"`
	// Values: Output only. Value for each system variable.
	Values googleapi.RawMessage `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Types") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Types") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SystemVariables) MarshalJSON() ([]byte, error) {
	type NoMethod SystemVariables
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Table struct {
	// BiglakeConfiguration: Optional. Specifies the configuration of a BigQuery
	// table for Apache Iceberg.
	BiglakeConfiguration *BigLakeConfiguration `json:"biglakeConfiguration,omitempty"`
	// CloneDefinition: Output only. Contains information about the clone. This
	// value is set via the clone operation.
	CloneDefinition *CloneDefinition `json:"cloneDefinition,omitempty"`
	// Clustering: Clustering specification for the table. Must be specified with
	// time-based partitioning, data in the table will be first partitioned and
	// subsequently clustered.
	Clustering *Clustering `json:"clustering,omitempty"`
	// CreationTime: Output only. The time when this table was created, in
	// milliseconds since the epoch.
	CreationTime int64 `json:"creationTime,omitempty,string"`
	// DefaultCollation: Optional. Defines the default collation specification of
	// new STRING fields in the table. During table creation or update, if a STRING
	// field is added to this table without explicit collation specified, then the
	// table inherits the table default collation. A change to this field affects
	// only fields added afterwards, and does not alter the existing fields. The
	// following values are supported: * 'und:ci': undetermined locale, case
	// insensitive. * '': empty string. Default to case-sensitive behavior.
	DefaultCollation string `json:"defaultCollation,omitempty"`
	// DefaultRoundingMode: Optional. Defines the default rounding mode
	// specification of new decimal fields (NUMERIC OR BIGNUMERIC) in the table.
	// During table creation or update, if a decimal field is added to this table
	// without an explicit rounding mode specified, then the field inherits the
	// table default rounding mode. Changing this field doesn't affect existing
	// fields.
	//
	// Possible values:
	//   "ROUNDING_MODE_UNSPECIFIED" - Unspecified will default to using
	// ROUND_HALF_AWAY_FROM_ZERO.
	//   "ROUND_HALF_AWAY_FROM_ZERO" - ROUND_HALF_AWAY_FROM_ZERO rounds half values
	// away from zero when applying precision and scale upon writing of NUMERIC and
	// BIGNUMERIC values. For Scale: 0 1.1, 1.2, 1.3, 1.4 => 1 1.5, 1.6, 1.7, 1.8,
	// 1.9 => 2
	//   "ROUND_HALF_EVEN" - ROUND_HALF_EVEN rounds half values to the nearest even
	// value when applying precision and scale upon writing of NUMERIC and
	// BIGNUMERIC values. For Scale: 0 1.1, 1.2, 1.3, 1.4 => 1 1.5 => 2 1.6, 1.7,
	// 1.8, 1.9 => 2 2.5 => 2
	DefaultRoundingMode string `json:"defaultRoundingMode,omitempty"`
	// Description: Optional. A user-friendly description of this table.
	Description string `json:"description,omitempty"`
	// EncryptionConfiguration: Custom encryption configuration (e.g., Cloud KMS
	// keys).
	EncryptionConfiguration *EncryptionConfiguration `json:"encryptionConfiguration,omitempty"`
	// Etag: Output only. A hash of this resource.
	Etag string `json:"etag,omitempty"`
	// ExpirationTime: Optional. The time when this table expires, in milliseconds
	// since the epoch. If not present, the table will persist indefinitely.
	// Expired tables will be deleted and their storage reclaimed. The
	// defaultTableExpirationMs property of the encapsulating dataset can be used
	// to set a default expirationTime on newly created tables.
	ExpirationTime int64 `json:"expirationTime,omitempty,string"`
	// ExternalCatalogTableOptions: Optional. Options defining open source
	// compatible table.
	ExternalCatalogTableOptions *ExternalCatalogTableOptions `json:"externalCatalogTableOptions,omitempty"`
	// ExternalDataConfiguration: Optional. Describes the data format, location,
	// and other properties of a table stored outside of BigQuery. By defining
	// these properties, the data source can then be queried as if it were a
	// standard BigQuery table.
	ExternalDataConfiguration *ExternalDataConfiguration `json:"externalDataConfiguration,omitempty"`
	// FriendlyName: Optional. A descriptive name for this table.
	FriendlyName string `json:"friendlyName,omitempty"`
	// Id: Output only. An opaque ID uniquely identifying the table.
	Id string `json:"id,omitempty"`
	// Kind: The type of resource ID.
	Kind string `json:"kind,omitempty"`
	// Labels: The labels associated with this table. You can use these to organize
	// and group your tables. Label keys and values can be no longer than 63
	// characters, can only contain lowercase letters, numeric characters,
	// underscores and dashes. International characters are allowed. Label values
	// are optional. Label keys must start with a letter and each label in the list
	// must have a different key.
	Labels map[string]string `json:"labels,omitempty"`
	// LastModifiedTime: Output only. The time when this table was last modified,
	// in milliseconds since the epoch.
	LastModifiedTime uint64 `json:"lastModifiedTime,omitempty,string"`
	// Location: Output only. The geographic location where the table resides. This
	// value is inherited from the dataset.
	Location string `json:"location,omitempty"`
	// ManagedTableType: Optional. If set, overrides the default managed table type
	// configured in the dataset.
	//
	// Possible values:
	//   "MANAGED_TABLE_TYPE_UNSPECIFIED" - No managed table type specified.
	//   "NATIVE" - The managed table is a native BigQuery table.
	//   "BIGLAKE" - The managed table is a BigLake table for Apache Iceberg in
	// BigQuery.
	ManagedTableType string `json:"managedTableType,omitempty"`
	// MaterializedView: Optional. The materialized view definition.
	MaterializedView *MaterializedViewDefinition `json:"materializedView,omitempty"`
	// MaterializedViewStatus: Output only. The materialized view status.
	MaterializedViewStatus *MaterializedViewStatus `json:"materializedViewStatus,omitempty"`
	// MaxStaleness: Optional. The maximum staleness of data that could be returned
	// when the table (or stale MV) is queried. Staleness encoded as a string
	// encoding of sql IntervalValue type.
	MaxStaleness string `json:"maxStaleness,omitempty"`
	// Model: Deprecated.
	Model *ModelDefinition `json:"model,omitempty"`
	// NumActiveLogicalBytes: Output only. Number of logical bytes that are less
	// than 90 days old.
	NumActiveLogicalBytes int64 `json:"numActiveLogicalBytes,omitempty,string"`
	// NumActivePhysicalBytes: Output only. Number of physical bytes less than 90
	// days old. This data is not kept in real time, and might be delayed by a few
	// seconds to a few minutes.
	NumActivePhysicalBytes int64 `json:"numActivePhysicalBytes,omitempty,string"`
	// NumBytes: Output only. The size of this table in logical bytes, excluding
	// any data in the streaming buffer.
	NumBytes int64 `json:"numBytes,omitempty,string"`
	// NumCurrentPhysicalBytes: Output only. Number of physical bytes used by
	// current live data storage. This data is not kept in real time, and might be
	// delayed by a few seconds to a few minutes.
	NumCurrentPhysicalBytes int64 `json:"numCurrentPhysicalBytes,omitempty,string"`
	// NumLongTermBytes: Output only. The number of logical bytes in the table that
	// are considered "long-term storage".
	NumLongTermBytes int64 `json:"numLongTermBytes,omitempty,string"`
	// NumLongTermLogicalBytes: Output only. Number of logical bytes that are more
	// than 90 days old.
	NumLongTermLogicalBytes int64 `json:"numLongTermLogicalBytes,omitempty,string"`
	// NumLongTermPhysicalBytes: Output only. Number of physical bytes more than 90
	// days old. This data is not kept in real time, and might be delayed by a few
	// seconds to a few minutes.
	NumLongTermPhysicalBytes int64 `json:"numLongTermPhysicalBytes,omitempty,string"`
	// NumPartitions: Output only. The number of partitions present in the table or
	// materialized view. This data is not kept in real time, and might be delayed
	// by a few seconds to a few minutes.
	NumPartitions int64 `json:"numPartitions,omitempty,string"`
	// NumPhysicalBytes: Output only. The physical size of this table in bytes.
	// This includes storage used for time travel.
	NumPhysicalBytes int64 `json:"numPhysicalBytes,omitempty,string"`
	// NumRows: Output only. The number of rows of data in this table, excluding
	// any data in the streaming buffer.
	NumRows uint64 `json:"numRows,omitempty,string"`
	// NumTimeTravelPhysicalBytes: Output only. Number of physical bytes used by
	// time travel storage (deleted or changed data). This data is not kept in real
	// time, and might be delayed by a few seconds to a few minutes.
	NumTimeTravelPhysicalBytes int64 `json:"numTimeTravelPhysicalBytes,omitempty,string"`
	// NumTotalLogicalBytes: Output only. Total number of logical bytes in the
	// table or materialized view.
	NumTotalLogicalBytes int64 `json:"numTotalLogicalBytes,omitempty,string"`
	// NumTotalPhysicalBytes: Output only. The physical size of this table in
	// bytes. This also includes storage used for time travel. This data is not
	// kept in real time, and might be delayed by a few seconds to a few minutes.
	NumTotalPhysicalBytes int64 `json:"numTotalPhysicalBytes,omitempty,string"`
	// PartitionDefinition: Optional. The partition information for all table
	// formats, including managed partitioned tables, hive partitioned tables,
	// iceberg partitioned, and metastore partitioned tables. This field is only
	// populated for metastore partitioned tables. For other table formats, this is
	// an output only field.
	PartitionDefinition *PartitioningDefinition `json:"partitionDefinition,omitempty"`
	// RangePartitioning: If specified, configures range partitioning for this
	// table.
	RangePartitioning *RangePartitioning `json:"rangePartitioning,omitempty"`
	// Replicas: Optional. Output only. Table references of all replicas currently
	// active on the table.
	Replicas []*TableReference `json:"replicas,omitempty"`
	// RequirePartitionFilter: Optional. If set to true, queries over this table
	// require a partition filter that can be used for partition elimination to be
	// specified.
	RequirePartitionFilter bool `json:"requirePartitionFilter,omitempty"`
	// ResourceTags: [Optional] The tags associated with this table. Tag keys are
	// globally unique. See additional information on tags
	// (https://cloud.google.com/iam/docs/tags-access-control#definitions). An
	// object containing a list of "key": value pairs. The key is the namespaced
	// friendly name of the tag key, e.g. "12345/environment" where 12345 is parent
	// id. The value is the friendly short name of the tag value, e.g.
	// "production".
	ResourceTags map[string]string `json:"resourceTags,omitempty"`
	// Restrictions: Optional. Output only. Restriction config for table. If set,
	// restrict certain accesses on the table based on the config. See Data egress
	// (https://cloud.google.com/bigquery/docs/analytics-hub-introduction#data_egress)
	// for more details.
	Restrictions *RestrictionConfig `json:"restrictions,omitempty"`
	// Schema: Optional. Describes the schema of this table.
	Schema *TableSchema `json:"schema,omitempty"`
	// SelfLink: Output only. A URL that can be used to access this resource again.
	SelfLink string `json:"selfLink,omitempty"`
	// SnapshotDefinition: Output only. Contains information about the snapshot.
	// This value is set via snapshot creation.
	SnapshotDefinition *SnapshotDefinition `json:"snapshotDefinition,omitempty"`
	// StreamingBuffer: Output only. Contains information regarding this table's
	// streaming buffer, if one is present. This field will be absent if the table
	// is not being streamed to or if there is no data in the streaming buffer.
	StreamingBuffer *Streamingbuffer `json:"streamingBuffer,omitempty"`
	// TableConstraints: Optional. Tables Primary Key and Foreign Key information
	TableConstraints *TableConstraints `json:"tableConstraints,omitempty"`
	// TableReference: Required. Reference describing the ID of this table.
	TableReference *TableReference `json:"tableReference,omitempty"`
	// TableReplicationInfo: Optional. Table replication info for table created `AS
	// REPLICA` DDL like: `CREATE MATERIALIZED VIEW mv1 AS REPLICA OF src_mv`
	TableReplicationInfo *TableReplicationInfo `json:"tableReplicationInfo,omitempty"`
	// TimePartitioning: If specified, configures time-based partitioning for this
	// table.
	TimePartitioning *TimePartitioning `json:"timePartitioning,omitempty"`
	// Type: Output only. Describes the table type. The following values are
	// supported: * `TABLE`: A normal BigQuery table. * `VIEW`: A virtual table
	// defined by a SQL query. * `EXTERNAL`: A table that references data stored in
	// an external storage system, such as Google Cloud Storage. *
	// `MATERIALIZED_VIEW`: A precomputed view defined by a SQL query. *
	// `SNAPSHOT`: An immutable BigQuery table that preserves the contents of a
	// base table at a particular time. See additional information on table
	// snapshots (https://cloud.google.com/bigquery/docs/table-snapshots-intro).
	// The default value is `TABLE`.
	Type string `json:"type,omitempty"`
	// View: Optional. The view definition.
	View *ViewDefinition `json:"view,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BiglakeConfiguration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BiglakeConfiguration") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Table) MarshalJSON() ([]byte, error) {
	type NoMethod Table
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TableCell struct {
	V interface{} `json:"v,omitempty"`
	// ForceSendFields is a list of field names (e.g. "V") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "V") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableCell) MarshalJSON() ([]byte, error) {
	type NoMethod TableCell
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableConstraints: The TableConstraints defines the primary key and foreign
// key.
type TableConstraints struct {
	// ForeignKeys: Optional. Present only if the table has a foreign key. The
	// foreign key is not enforced.
	ForeignKeys []*TableConstraintsForeignKeys `json:"foreignKeys,omitempty"`
	// PrimaryKey: Represents the primary key constraint on a table's columns.
	PrimaryKey *TableConstraintsPrimaryKey `json:"primaryKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ForeignKeys") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ForeignKeys") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableConstraints) MarshalJSON() ([]byte, error) {
	type NoMethod TableConstraints
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableConstraintsForeignKeys: Represents a foreign key constraint on a
// table's columns.
type TableConstraintsForeignKeys struct {
	// ColumnReferences: Required. The columns that compose the foreign key.
	ColumnReferences []*TableConstraintsForeignKeysColumnReferences `json:"columnReferences,omitempty"`
	// Name: Optional. Set only if the foreign key constraint is named.
	Name            string                                      `json:"name,omitempty"`
	ReferencedTable *TableConstraintsForeignKeysReferencedTable `json:"referencedTable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ColumnReferences") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ColumnReferences") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableConstraintsForeignKeys) MarshalJSON() ([]byte, error) {
	type NoMethod TableConstraintsForeignKeys
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableConstraintsForeignKeysColumnReferences: The pair of the foreign key
// column and primary key column.
type TableConstraintsForeignKeysColumnReferences struct {
	// ReferencedColumn: Required. The column in the primary key that are
	// referenced by the referencing_column.
	ReferencedColumn string `json:"referencedColumn,omitempty"`
	// ReferencingColumn: Required. The column that composes the foreign key.
	ReferencingColumn string `json:"referencingColumn,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ReferencedColumn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReferencedColumn") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableConstraintsForeignKeysColumnReferences) MarshalJSON() ([]byte, error) {
	type NoMethod TableConstraintsForeignKeysColumnReferences
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TableConstraintsForeignKeysReferencedTable struct {
	DatasetId string `json:"datasetId,omitempty"`
	ProjectId string `json:"projectId,omitempty"`
	TableId   string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableConstraintsForeignKeysReferencedTable) MarshalJSON() ([]byte, error) {
	type NoMethod TableConstraintsForeignKeysReferencedTable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableConstraintsPrimaryKey: Represents the primary key constraint on a
// table's columns.
type TableConstraintsPrimaryKey struct {
	// Columns: Required. The columns that are composed of the primary key
	// constraint.
	Columns []string `json:"columns,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Columns") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Columns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableConstraintsPrimaryKey) MarshalJSON() ([]byte, error) {
	type NoMethod TableConstraintsPrimaryKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableDataInsertAllRequest: Request for sending a single streaming insert.
type TableDataInsertAllRequest struct {
	// IgnoreUnknownValues: Optional. Accept rows that contain values that do not
	// match the schema. The unknown values are ignored. Default is false, which
	// treats unknown values as errors.
	IgnoreUnknownValues bool `json:"ignoreUnknownValues,omitempty"`
	// Kind: Optional. The resource type of the response. The value is not checked
	// at the backend. Historically, it has been set to
	// "bigquery#tableDataInsertAllRequest" but you are not required to set it.
	Kind string                           `json:"kind,omitempty"`
	Rows []*TableDataInsertAllRequestRows `json:"rows,omitempty"`
	// SkipInvalidRows: Optional. Insert all valid rows of a request, even if
	// invalid rows exist. The default value is false, which causes the entire
	// request to fail if any invalid rows exist.
	SkipInvalidRows bool `json:"skipInvalidRows,omitempty"`
	// TemplateSuffix: Optional. If specified, treats the destination table as a
	// base template, and inserts the rows into an instance table named
	// "{destination}{templateSuffix}". BigQuery will manage creation of the
	// instance table, using the schema of the base template table. See
	// https://cloud.google.com/bigquery/streaming-data-into-bigquery#template-tables
	// for considerations when working with templates tables.
	TemplateSuffix string `json:"templateSuffix,omitempty"`
	// TraceId: Optional. Unique request trace id. Used for debugging purposes
	// only. It is case-sensitive, limited to up to 36 ASCII characters. A UUID is
	// recommended.
	TraceId string `json:"traceId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IgnoreUnknownValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IgnoreUnknownValues") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableDataInsertAllRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TableDataInsertAllRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableDataInsertAllRequestRows: Data for a single insertion row.
type TableDataInsertAllRequestRows struct {
	// InsertId: Insertion ID for best-effort deduplication. This feature is not
	// recommended, and users seeking stronger insertion semantics are encouraged
	// to use other mechanisms such as the BigQuery Write API.
	InsertId string `json:"insertId,omitempty"`
	// Json: Data for a single row.
	Json map[string]JsonValue `json:"json,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InsertId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InsertId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableDataInsertAllRequestRows) MarshalJSON() ([]byte, error) {
	type NoMethod TableDataInsertAllRequestRows
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableDataInsertAllResponse: Describes the format of a streaming insert
// response.
type TableDataInsertAllResponse struct {
	// InsertErrors: Describes specific errors encountered while processing the
	// request.
	InsertErrors []*TableDataInsertAllResponseInsertErrors `json:"insertErrors,omitempty"`
	// Kind: Returns "bigquery#tableDataInsertAllResponse".
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "InsertErrors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InsertErrors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableDataInsertAllResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TableDataInsertAllResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableDataInsertAllResponseInsertErrors: Error details about a single row's
// insertion.
type TableDataInsertAllResponseInsertErrors struct {
	// Errors: Error information for the row indicated by the index property.
	Errors []*ErrorProto `json:"errors,omitempty"`
	// Index: The index of the row that error applies to.
	Index int64 `json:"index,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableDataInsertAllResponseInsertErrors) MarshalJSON() ([]byte, error) {
	type NoMethod TableDataInsertAllResponseInsertErrors
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TableDataList struct {
	// Etag: A hash of this page of results.
	Etag string `json:"etag,omitempty"`
	// Kind: The resource type of the response.
	Kind string `json:"kind,omitempty"`
	// PageToken: A token used for paging results. Providing this token instead of
	// the startIndex parameter can help you retrieve stable results when an
	// underlying table is changing.
	PageToken string `json:"pageToken,omitempty"`
	// Rows: Rows of results.
	Rows []*TableRow `json:"rows,omitempty"`
	// TotalRows: Total rows of the entire table. In order to show default value 0
	// we have to present it as string.
	TotalRows int64 `json:"totalRows,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableDataList) MarshalJSON() ([]byte, error) {
	type NoMethod TableDataList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableFieldSchema: A field in TableSchema
type TableFieldSchema struct {
	// Categories: Deprecated.
	Categories *TableFieldSchemaCategories `json:"categories,omitempty"`
	// Collation: Optional. Field collation can be set only when the type of field
	// is STRING. The following values are supported: * 'und:ci': undetermined
	// locale, case insensitive. * '': empty string. Default to case-sensitive
	// behavior.
	Collation string `json:"collation,omitempty"`
	// DataPolicies: Optional. Data policy options, will replace the data_policies.
	DataPolicies []*DataPolicyOption `json:"dataPolicies,omitempty"`
	// DefaultValueExpression: Optional. A SQL expression to specify the [default
	// value] (https://cloud.google.com/bigquery/docs/default-values) for this
	// field.
	DefaultValueExpression string `json:"defaultValueExpression,omitempty"`
	// Description: Optional. The field description. The maximum length is 1,024
	// characters.
	Description string `json:"description,omitempty"`
	// Fields: Optional. Describes the nested schema fields if the type property is
	// set to RECORD.
	Fields []*TableFieldSchema `json:"fields,omitempty"`
	// ForeignTypeDefinition: Optional. Definition of the foreign data type. Only
	// valid for top-level schema fields (not nested fields). If the type is
	// FOREIGN, this field is required.
	ForeignTypeDefinition string `json:"foreignTypeDefinition,omitempty"`
	// MaxLength: Optional. Maximum length of values of this field for STRINGS or
	// BYTES. If max_length is not specified, no maximum length constraint is
	// imposed on this field. If type = "STRING", then max_length represents the
	// maximum UTF-8 length of strings in this field. If type = "BYTES", then
	// max_length represents the maximum number of bytes in this field. It is
	// invalid to set this field if type ≠ "STRING" and ≠ "BYTES".
	MaxLength int64 `json:"maxLength,omitempty,string"`
	// Mode: Optional. The field mode. Possible values include NULLABLE, REQUIRED
	// and REPEATED. The default value is NULLABLE.
	Mode string `json:"mode,omitempty"`
	// Name: Required. The field name. The name must contain only letters (a-z,
	// A-Z), numbers (0-9), or underscores (_), and must start with a letter or
	// underscore. The maximum length is 300 characters.
	Name string `json:"name,omitempty"`
	// PolicyTags: Optional. The policy tags attached to this field, used for
	// field-level access control. If not set, defaults to empty policy_tags.
	PolicyTags *TableFieldSchemaPolicyTags `json:"policyTags,omitempty"`
	// Precision: Optional. Precision (maximum number of total digits in base 10)
	// and scale (maximum number of digits in the fractional part in base 10)
	// constraints for values of this field for NUMERIC or BIGNUMERIC. It is
	// invalid to set precision or scale if type ≠ "NUMERIC" and ≠
	// "BIGNUMERIC". If precision and scale are not specified, no value range
	// constraint is imposed on this field insofar as values are permitted by the
	// type. Values of this NUMERIC or BIGNUMERIC field must be in this range when:
	// * Precision (P) and scale (S) are specified: [-10P-S + 10-S, 10P-S - 10-S] *
	// Precision (P) is specified but not scale (and thus scale is interpreted to
	// be equal to zero): [-10P + 1, 10P - 1]. Acceptable values for precision and
	// scale if both are specified: * If type = "NUMERIC": 1 ≤ precision - scale
	// ≤ 29 and 0 ≤ scale ≤ 9. * If type = "BIGNUMERIC": 1 ≤ precision -
	// scale ≤ 38 and 0 ≤ scale ≤ 38. Acceptable values for precision if only
	// precision is specified but not scale (and thus scale is interpreted to be
	// equal to zero): * If type = "NUMERIC": 1 ≤ precision ≤ 29. * If type =
	// "BIGNUMERIC": 1 ≤ precision ≤ 38. If scale is specified but not
	// precision, then it is invalid.
	Precision int64 `json:"precision,omitempty,string"`
	// RangeElementType: Represents the type of a field element.
	RangeElementType *TableFieldSchemaRangeElementType `json:"rangeElementType,omitempty"`
	// RoundingMode: Optional. Specifies the rounding mode to be used when storing
	// values of NUMERIC and BIGNUMERIC type.
	//
	// Possible values:
	//   "ROUNDING_MODE_UNSPECIFIED" - Unspecified will default to using
	// ROUND_HALF_AWAY_FROM_ZERO.
	//   "ROUND_HALF_AWAY_FROM_ZERO" - ROUND_HALF_AWAY_FROM_ZERO rounds half values
	// away from zero when applying precision and scale upon writing of NUMERIC and
	// BIGNUMERIC values. For Scale: 0 1.1, 1.2, 1.3, 1.4 => 1 1.5, 1.6, 1.7, 1.8,
	// 1.9 => 2
	//   "ROUND_HALF_EVEN" - ROUND_HALF_EVEN rounds half values to the nearest even
	// value when applying precision and scale upon writing of NUMERIC and
	// BIGNUMERIC values. For Scale: 0 1.1, 1.2, 1.3, 1.4 => 1 1.5 => 2 1.6, 1.7,
	// 1.8, 1.9 => 2 2.5 => 2
	RoundingMode string `json:"roundingMode,omitempty"`
	// Scale: Optional. See documentation for precision.
	Scale int64 `json:"scale,omitempty,string"`
	// Type: Required. The field data type. Possible values include: * STRING *
	// BYTES * INTEGER (or INT64) * FLOAT (or FLOAT64) * BOOLEAN (or BOOL) *
	// TIMESTAMP * DATE * TIME * DATETIME * GEOGRAPHY * NUMERIC * BIGNUMERIC * JSON
	// * RECORD (or STRUCT) * RANGE Use of RECORD/STRUCT indicates that the field
	// contains a nested schema.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Categories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Categories") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableFieldSchema) MarshalJSON() ([]byte, error) {
	type NoMethod TableFieldSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableFieldSchemaCategories: Deprecated.
type TableFieldSchemaCategories struct {
	// Names: Deprecated.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableFieldSchemaCategories) MarshalJSON() ([]byte, error) {
	type NoMethod TableFieldSchemaCategories
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableFieldSchemaPolicyTags: Optional. The policy tags attached to this
// field, used for field-level access control. If not set, defaults to empty
// policy_tags.
type TableFieldSchemaPolicyTags struct {
	// Names: A list of policy tag resource names. For example,
	// "projects/1/locations/eu/taxonomies/2/policyTags/3". At most 1 policy tag is
	// currently allowed.
	Names []string `json:"names,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Names") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Names") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableFieldSchemaPolicyTags) MarshalJSON() ([]byte, error) {
	type NoMethod TableFieldSchemaPolicyTags
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableFieldSchemaRangeElementType: Represents the type of a field element.
type TableFieldSchemaRangeElementType struct {
	// Type: Required. The type of a field element. For more information, see
	// TableFieldSchema.type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableFieldSchemaRangeElementType) MarshalJSON() ([]byte, error) {
	type NoMethod TableFieldSchemaRangeElementType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableList: Partial projection of the metadata for a given table in a list
// response.
type TableList struct {
	// Etag: A hash of this page of results.
	Etag string `json:"etag,omitempty"`
	// Kind: The type of list.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: A token to request the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Tables: Tables in the requested dataset.
	Tables []*TableListTables `json:"tables,omitempty"`
	// TotalItems: The total number of tables in the dataset.
	TotalItems int64 `json:"totalItems,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableList) MarshalJSON() ([]byte, error) {
	type NoMethod TableList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TableListTables struct {
	// Clustering: Clustering specification for this table, if configured.
	Clustering *Clustering `json:"clustering,omitempty"`
	// CreationTime: Output only. The time when this table was created, in
	// milliseconds since the epoch.
	CreationTime int64 `json:"creationTime,omitempty,string"`
	// ExpirationTime: The time when this table expires, in milliseconds since the
	// epoch. If not present, the table will persist indefinitely. Expired tables
	// will be deleted and their storage reclaimed.
	ExpirationTime int64 `json:"expirationTime,omitempty,string"`
	// FriendlyName: The user-friendly name for this table.
	FriendlyName string `json:"friendlyName,omitempty"`
	// Id: An opaque ID of the table.
	Id string `json:"id,omitempty"`
	// Kind: The resource type.
	Kind string `json:"kind,omitempty"`
	// Labels: The labels associated with this table. You can use these to organize
	// and group your tables.
	Labels map[string]string `json:"labels,omitempty"`
	// RangePartitioning: The range partitioning for this table.
	RangePartitioning *RangePartitioning `json:"rangePartitioning,omitempty"`
	// RequirePartitionFilter: Optional. If set to true, queries including this
	// table must specify a partition filter. This filter is used for partition
	// elimination.
	RequirePartitionFilter bool `json:"requirePartitionFilter,omitempty"`
	// TableReference: A reference uniquely identifying table.
	TableReference *TableReference `json:"tableReference,omitempty"`
	// TimePartitioning: The time-based partitioning for this table.
	TimePartitioning *TimePartitioning `json:"timePartitioning,omitempty"`
	// Type: The type of table.
	Type string `json:"type,omitempty"`
	// View: Information about a logical view.
	View *TableListTablesView `json:"view,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clustering") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clustering") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableListTables) MarshalJSON() ([]byte, error) {
	type NoMethod TableListTables
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableListTablesView: Information about a logical view.
type TableListTablesView struct {
	// PrivacyPolicy: Specifies the privacy policy for the view.
	PrivacyPolicy *PrivacyPolicy `json:"privacyPolicy,omitempty"`
	// UseLegacySql: True if view is defined in legacy SQL dialect, false if in
	// GoogleSQL.
	UseLegacySql bool `json:"useLegacySql,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PrivacyPolicy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PrivacyPolicy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableListTablesView) MarshalJSON() ([]byte, error) {
	type NoMethod TableListTablesView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableMetadataCacheUsage: Table level detail on the usage of metadata
// caching. Only set for Metadata caching eligible tables referenced in the
// query.
type TableMetadataCacheUsage struct {
	// Explanation: Free form human-readable reason metadata caching was unused for
	// the job.
	Explanation string `json:"explanation,omitempty"`
	// Staleness: Duration since last refresh as of this job for managed tables
	// (indicates metadata cache staleness as seen by this job).
	Staleness string `json:"staleness,omitempty"`
	// TableReference: Metadata caching eligible table referenced in the query.
	TableReference *TableReference `json:"tableReference,omitempty"`
	// TableType: Table type
	// (https://cloud.google.com/bigquery/docs/reference/rest/v2/tables#Table.FIELDS.type).
	TableType string `json:"tableType,omitempty"`
	// UnusedReason: Reason for not using metadata caching for the table.
	//
	// Possible values:
	//   "UNUSED_REASON_UNSPECIFIED" - Unused reasons not specified.
	//   "EXCEEDED_MAX_STALENESS" - Metadata cache was outside the table's
	// maxStaleness.
	//   "METADATA_CACHING_NOT_ENABLED" - Metadata caching feature is not enabled.
	// [Update BigLake tables]
	// (/bigquery/docs/create-cloud-storage-table-biglake#update-biglake-tables) to
	// enable the metadata caching.
	//   "OTHER_REASON" - Other unknown reason.
	UnusedReason string `json:"unusedReason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Explanation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Explanation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableMetadataCacheUsage) MarshalJSON() ([]byte, error) {
	type NoMethod TableMetadataCacheUsage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TableReference struct {
	// DatasetId: Required. The ID of the dataset containing this table.
	DatasetId string `json:"datasetId,omitempty"`
	// ProjectId: Required. The ID of the project containing this table.
	ProjectId string `json:"projectId,omitempty"`
	// TableId: Required. The ID of the table. The ID can contain Unicode
	// characters in category L (letter), M (mark), N (number), Pc (connector,
	// including underscore), Pd (dash), and Zs (space). For more information, see
	// General Category
	// (https://wikipedia.org/wiki/Unicode_character_property#General_Category).
	// The maximum length is 1,024 characters. Certain operations allow suffixing
	// of the table ID with a partition decorator, such as `sample_table$20190123`.
	TableId string `json:"tableId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableReference) MarshalJSON() ([]byte, error) {
	type NoMethod TableReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableReplicationInfo: Replication info of a table created using `AS REPLICA`
// DDL like: `CREATE MATERIALIZED VIEW mv1 AS REPLICA OF src_mv`
type TableReplicationInfo struct {
	// ReplicatedSourceLastRefreshTime: Optional. Output only. If source is a
	// materialized view, this field signifies the last refresh time of the source.
	ReplicatedSourceLastRefreshTime int64 `json:"replicatedSourceLastRefreshTime,omitempty,string"`
	// ReplicationError: Optional. Output only. Replication error that will
	// permanently stopped table replication.
	ReplicationError *ErrorProto `json:"replicationError,omitempty"`
	// ReplicationIntervalMs: Optional. Specifies the interval at which the source
	// table is polled for updates. It's Optional. If not specified, default
	// replication interval would be applied.
	ReplicationIntervalMs int64 `json:"replicationIntervalMs,omitempty,string"`
	// ReplicationStatus: Optional. Output only. Replication status of configured
	// replication.
	//
	// Possible values:
	//   "REPLICATION_STATUS_UNSPECIFIED" - Default value.
	//   "ACTIVE" - Replication is Active with no errors.
	//   "SOURCE_DELETED" - Source object is deleted.
	//   "PERMISSION_DENIED" - Source revoked replication permissions.
	//   "UNSUPPORTED_CONFIGURATION" - Source configuration doesn’t allow
	// replication.
	ReplicationStatus string `json:"replicationStatus,omitempty"`
	// SourceTable: Required. Source table reference that is replicated.
	SourceTable *TableReference `json:"sourceTable,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ReplicatedSourceLastRefreshTime") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ReplicatedSourceLastRefreshTime")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableReplicationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod TableReplicationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TableRow struct {
	// F: Represents a single row in the result set, consisting of one or more
	// fields.
	F []*TableCell `json:"f,omitempty"`
	// ForceSendFields is a list of field names (e.g. "F") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "F") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableRow) MarshalJSON() ([]byte, error) {
	type NoMethod TableRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TableSchema: Schema of a table
type TableSchema struct {
	// Fields: Describes the fields in a table.
	Fields []*TableFieldSchema `json:"fields,omitempty"`
	// ForeignTypeInfo: Optional. Specifies metadata of the foreign data type
	// definition in field schema (TableFieldSchema.foreign_type_definition).
	ForeignTypeInfo *ForeignTypeInfo `json:"foreignTypeInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Fields") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TableSchema) MarshalJSON() ([]byte, error) {
	type NoMethod TableSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions` method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TimePartitioning struct {
	// ExpirationMs: Optional. Number of milliseconds for which to keep the storage
	// for a partition. A wrapper is used here because 0 is an invalid value.
	ExpirationMs int64 `json:"expirationMs,omitempty,string"`
	// Field: Optional. If not set, the table is partitioned by pseudo column
	// '_PARTITIONTIME'; if set, the table is partitioned by this field. The field
	// must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or
	// REQUIRED. A wrapper is used here because an empty string is an invalid
	// value.
	Field string `json:"field,omitempty"`
	// RequirePartitionFilter: If set to true, queries over this table require a
	// partition filter that can be used for partition elimination to be specified.
	// This field is deprecated; please set the field with the same name on the
	// table itself instead. This field needs a wrapper because we want to output
	// the default value, false, if the user explicitly set it.
	RequirePartitionFilter bool `json:"requirePartitionFilter,omitempty"`
	// Type: Required. The supported types are DAY, HOUR, MONTH, and YEAR, which
	// will generate one partition per day, hour, month, and year, respectively.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExpirationMs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpirationMs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimePartitioning) MarshalJSON() ([]byte, error) {
	type NoMethod TimePartitioning
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TrainingOptions: Options used in model training.
type TrainingOptions struct {
	// ActivationFn: Activation function of the neural nets.
	ActivationFn string `json:"activationFn,omitempty"`
	// AdjustStepChanges: If true, detect step changes and make data adjustment in
	// the input time series.
	AdjustStepChanges bool `json:"adjustStepChanges,omitempty"`
	// ApproxGlobalFeatureContrib: Whether to use approximate feature contribution
	// method in XGBoost model explanation for global explain.
	ApproxGlobalFeatureContrib bool `json:"approxGlobalFeatureContrib,omitempty"`
	// AutoArima: Whether to enable auto ARIMA or not.
	AutoArima bool `json:"autoArima,omitempty"`
	// AutoArimaMaxOrder: The max value of the sum of non-seasonal p and q.
	AutoArimaMaxOrder int64 `json:"autoArimaMaxOrder,omitempty,string"`
	// AutoArimaMinOrder: The min value of the sum of non-seasonal p and q.
	AutoArimaMinOrder int64 `json:"autoArimaMinOrder,omitempty,string"`
	// AutoClassWeights: Whether to calculate class weights automatically based on
	// the popularity of each label.
	AutoClassWeights bool `json:"autoClassWeights,omitempty"`
	// BatchSize: Batch size for dnn models.
	BatchSize int64 `json:"batchSize,omitempty,string"`
	// BoosterType: Booster type for boosted tree models.
	//
	// Possible values:
	//   "BOOSTER_TYPE_UNSPECIFIED" - Unspecified booster type.
	//   "GBTREE" - Gbtree booster.
	//   "DART" - Dart booster.
	BoosterType string `json:"boosterType,omitempty"`
	// BudgetHours: Budget in hours for AutoML training.
	BudgetHours float64 `json:"budgetHours,omitempty"`
	// CalculatePValues: Whether or not p-value test should be computed for this
	// model. Only available for linear and logistic regression models.
	CalculatePValues bool `json:"calculatePValues,omitempty"`
	// CategoryEncodingMethod: Categorical feature encoding method.
	//
	// Possible values:
	//   "ENCODING_METHOD_UNSPECIFIED" - Unspecified encoding method.
	//   "ONE_HOT_ENCODING" - Applies one-hot encoding.
	//   "LABEL_ENCODING" - Applies label encoding.
	//   "DUMMY_ENCODING" - Applies dummy encoding.
	CategoryEncodingMethod string `json:"categoryEncodingMethod,omitempty"`
	// CleanSpikesAndDips: If true, clean spikes and dips in the input time series.
	CleanSpikesAndDips bool `json:"cleanSpikesAndDips,omitempty"`
	// ColorSpace: Enums for color space, used for processing images in Object
	// Table. See more details at
	// https://www.tensorflow.org/io/tutorials/colorspace.
	//
	// Possible values:
	//   "COLOR_SPACE_UNSPECIFIED" - Unspecified color space
	//   "RGB" - RGB
	//   "HSV" - HSV
	//   "YIQ" - YIQ
	//   "YUV" - YUV
	//   "GRAYSCALE" - GRAYSCALE
	ColorSpace string `json:"colorSpace,omitempty"`
	// ColsampleBylevel: Subsample ratio of columns for each level for boosted tree
	// models.
	ColsampleBylevel float64 `json:"colsampleBylevel,omitempty"`
	// ColsampleBynode: Subsample ratio of columns for each node(split) for boosted
	// tree models.
	ColsampleBynode float64 `json:"colsampleBynode,omitempty"`
	// ColsampleBytree: Subsample ratio of columns when constructing each tree for
	// boosted tree models.
	ColsampleBytree float64 `json:"colsampleBytree,omitempty"`
	// ContributionMetric: The contribution metric. Applies to contribution
	// analysis models. Allowed formats supported are for summable and summable
	// ratio contribution metrics. These include expressions such as `SUM(x)` or
	// `SUM(x)/SUM(y)`, where x and y are column names from the base table.
	ContributionMetric string `json:"contributionMetric,omitempty"`
	// DartNormalizeType: Type of normalization algorithm for boosted tree models
	// using dart booster.
	//
	// Possible values:
	//   "DART_NORMALIZE_TYPE_UNSPECIFIED" - Unspecified dart normalize type.
	//   "TREE" - New trees have the same weight of each of dropped trees.
	//   "FOREST" - New trees have the same weight of sum of dropped trees.
	DartNormalizeType string `json:"dartNormalizeType,omitempty"`
	// DataFrequency: The data frequency of a time series.
	//
	// Possible values:
	//   "DATA_FREQUENCY_UNSPECIFIED" - Default value.
	//   "AUTO_FREQUENCY" - Automatically inferred from timestamps.
	//   "YEARLY" - Yearly data.
	//   "QUARTERLY" - Quarterly data.
	//   "MONTHLY" - Monthly data.
	//   "WEEKLY" - Weekly data.
	//   "DAILY" - Daily data.
	//   "HOURLY" - Hourly data.
	//   "PER_MINUTE" - Per-minute data.
	DataFrequency string `json:"dataFrequency,omitempty"`
	// DataSplitColumn: The column to split data with. This column won't be used as
	// a feature. 1. When data_split_method is CUSTOM, the corresponding column
	// should be boolean. The rows with true value tag are eval data, and the false
	// are training data. 2. When data_split_method is SEQ, the first
	// DATA_SPLIT_EVAL_FRACTION rows (from smallest to largest) in the
	// corresponding column are used as training data, and the rest are eval data.
	// It respects the order in Orderable data types:
	// https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#data_type_properties
	DataSplitColumn string `json:"dataSplitColumn,omitempty"`
	// DataSplitEvalFraction: The fraction of evaluation data over the whole input
	// data. The rest of data will be used as training data. The format should be
	// double. Accurate to two decimal places. Default value is 0.2.
	DataSplitEvalFraction float64 `json:"dataSplitEvalFraction,omitempty"`
	// DataSplitMethod: The data split type for training and evaluation, e.g.
	// RANDOM.
	//
	// Possible values:
	//   "DATA_SPLIT_METHOD_UNSPECIFIED" - Default value.
	//   "RANDOM" - Splits data randomly.
	//   "CUSTOM" - Splits data with the user provided tags.
	//   "SEQUENTIAL" - Splits data sequentially.
	//   "NO_SPLIT" - Data split will be skipped.
	//   "AUTO_SPLIT" - Splits data automatically: Uses NO_SPLIT if the data size
	// is small. Otherwise uses RANDOM.
	DataSplitMethod string `json:"dataSplitMethod,omitempty"`
	// DecomposeTimeSeries: If true, perform decompose time series and save the
	// results.
	DecomposeTimeSeries bool `json:"decomposeTimeSeries,omitempty"`
	// DimensionIdColumns: Optional. Names of the columns to slice on. Applies to
	// contribution analysis models.
	DimensionIdColumns []string `json:"dimensionIdColumns,omitempty"`
	// DistanceType: Distance type for clustering models.
	//
	// Possible values:
	//   "DISTANCE_TYPE_UNSPECIFIED" - Default value.
	//   "EUCLIDEAN" - Eculidean distance.
	//   "COSINE" - Cosine distance.
	DistanceType string `json:"distanceType,omitempty"`
	// Dropout: Dropout probability for dnn models.
	Dropout float64 `json:"dropout,omitempty"`
	// EarlyStop: Whether to stop early when the loss doesn't improve significantly
	// any more (compared to min_relative_progress). Used only for iterative
	// training algorithms.
	EarlyStop bool `json:"earlyStop,omitempty"`
	// EnableGlobalExplain: If true, enable global explanation during training.
	EnableGlobalExplain bool `json:"enableGlobalExplain,omitempty"`
	// FeedbackType: Feedback type that specifies which algorithm to run for matrix
	// factorization.
	//
	// Possible values:
	//   "FEEDBACK_TYPE_UNSPECIFIED" - Default value.
	//   "IMPLICIT" - Use weighted-als for implicit feedback problems.
	//   "EXPLICIT" - Use nonweighted-als for explicit feedback problems.
	FeedbackType string `json:"feedbackType,omitempty"`
	// FitIntercept: Whether the model should include intercept during model
	// training.
	FitIntercept bool `json:"fitIntercept,omitempty"`
	// ForecastLimitLowerBound: The forecast limit lower bound that was used during
	// ARIMA model training with limits. To see more details of the algorithm:
	// https://otexts.com/fpp2/limits.html
	ForecastLimitLowerBound float64 `json:"forecastLimitLowerBound,omitempty"`
	// ForecastLimitUpperBound: The forecast limit upper bound that was used during
	// ARIMA model training with limits.
	ForecastLimitUpperBound float64 `json:"forecastLimitUpperBound,omitempty"`
	// HiddenUnits: Hidden units for dnn models.
	HiddenUnits googleapi.Int64s `json:"hiddenUnits,omitempty"`
	// HolidayRegion: The geographical region based on which the holidays are
	// considered in time series modeling. If a valid value is specified, then
	// holiday effects modeling is enabled.
	//
	// Possible values:
	//   "HOLIDAY_REGION_UNSPECIFIED" - Holiday region unspecified.
	//   "GLOBAL" - Global.
	//   "NA" - North America.
	//   "JAPAC" - Japan and Asia Pacific: Korea, Greater China, India, Australia,
	// and New Zealand.
	//   "EMEA" - Europe, the Middle East and Africa.
	//   "LAC" - Latin America and the Caribbean.
	//   "AE" - United Arab Emirates
	//   "AR" - Argentina
	//   "AT" - Austria
	//   "AU" - Australia
	//   "BE" - Belgium
	//   "BR" - Brazil
	//   "CA" - Canada
	//   "CH" - Switzerland
	//   "CL" - Chile
	//   "CN" - China
	//   "CO" - Colombia
	//   "CS" - Czechoslovakia
	//   "CZ" - Czech Republic
	//   "DE" - Germany
	//   "DK" - Denmark
	//   "DZ" - Algeria
	//   "EC" - Ecuador
	//   "EE" - Estonia
	//   "EG" - Egypt
	//   "ES" - Spain
	//   "FI" - Finland
	//   "FR" - France
	//   "GB" - Great Britain (United Kingdom)
	//   "GR" - Greece
	//   "HK" - Hong Kong
	//   "HU" - Hungary
	//   "ID" - Indonesia
	//   "IE" - Ireland
	//   "IL" - Israel
	//   "IN" - India
	//   "IR" - Iran
	//   "IT" - Italy
	//   "JP" - Japan
	//   "KR" - Korea (South)
	//   "LV" - Latvia
	//   "MA" - Morocco
	//   "MX" - Mexico
	//   "MY" - Malaysia
	//   "NG" - Nigeria
	//   "NL" - Netherlands
	//   "NO" - Norway
	//   "NZ" - New Zealand
	//   "PE" - Peru
	//   "PH" - Philippines
	//   "PK" - Pakistan
	//   "PL" - Poland
	//   "PT" - Portugal
	//   "RO" - Romania
	//   "RS" - Serbia
	//   "RU" - Russian Federation
	//   "SA" - Saudi Arabia
	//   "SE" - Sweden
	//   "SG" - Singapore
	//   "SI" - Slovenia
	//   "SK" - Slovakia
	//   "TH" - Thailand
	//   "TR" - Turkey
	//   "TW" - Taiwan
	//   "UA" - Ukraine
	//   "US" - United States
	//   "VE" - Venezuela
	//   "VN" - Vietnam
	//   "ZA" - South Africa
	HolidayRegion string `json:"holidayRegion,omitempty"`
	// HolidayRegions: A list of geographical regions that are used for time series
	// modeling.
	//
	// Possible values:
	//   "HOLIDAY_REGION_UNSPECIFIED" - Holiday region unspecified.
	//   "GLOBAL" - Global.
	//   "NA" - North America.
	//   "JAPAC" - Japan and Asia Pacific: Korea, Greater China, India, Australia,
	// and New Zealand.
	//   "EMEA" - Europe, the Middle East and Africa.
	//   "LAC" - Latin America and the Caribbean.
	//   "AE" - United Arab Emirates
	//   "AR" - Argentina
	//   "AT" - Austria
	//   "AU" - Australia
	//   "BE" - Belgium
	//   "BR" - Brazil
	//   "CA" - Canada
	//   "CH" - Switzerland
	//   "CL" - Chile
	//   "CN" - China
	//   "CO" - Colombia
	//   "CS" - Czechoslovakia
	//   "CZ" - Czech Republic
	//   "DE" - Germany
	//   "DK" - Denmark
	//   "DZ" - Algeria
	//   "EC" - Ecuador
	//   "EE" - Estonia
	//   "EG" - Egypt
	//   "ES" - Spain
	//   "FI" - Finland
	//   "FR" - France
	//   "GB" - Great Britain (United Kingdom)
	//   "GR" - Greece
	//   "HK" - Hong Kong
	//   "HU" - Hungary
	//   "ID" - Indonesia
	//   "IE" - Ireland
	//   "IL" - Israel
	//   "IN" - India
	//   "IR" - Iran
	//   "IT" - Italy
	//   "JP" - Japan
	//   "KR" - Korea (South)
	//   "LV" - Latvia
	//   "MA" - Morocco
	//   "MX" - Mexico
	//   "MY" - Malaysia
	//   "NG" - Nigeria
	//   "NL" - Netherlands
	//   "NO" - Norway
	//   "NZ" - New Zealand
	//   "PE" - Peru
	//   "PH" - Philippines
	//   "PK" - Pakistan
	//   "PL" - Poland
	//   "PT" - Portugal
	//   "RO" - Romania
	//   "RS" - Serbia
	//   "RU" - Russian Federation
	//   "SA" - Saudi Arabia
	//   "SE" - Sweden
	//   "SG" - Singapore
	//   "SI" - Slovenia
	//   "SK" - Slovakia
	//   "TH" - Thailand
	//   "TR" - Turkey
	//   "TW" - Taiwan
	//   "UA" - Ukraine
	//   "US" - United States
	//   "VE" - Venezuela
	//   "VN" - Vietnam
	//   "ZA" - South Africa
	HolidayRegions []string `json:"holidayRegions,omitempty"`
	// Horizon: The number of periods ahead that need to be forecasted.
	Horizon int64 `json:"horizon,omitempty,string"`
	// HparamTuningObjectives: The target evaluation metrics to optimize the
	// hyperparameters for.
	//
	// Possible values:
	//   "HPARAM_TUNING_OBJECTIVE_UNSPECIFIED" - Unspecified evaluation metric.
	//   "MEAN_ABSOLUTE_ERROR" - Mean absolute error. mean_absolute_error =
	// AVG(ABS(label - predicted))
	//   "MEAN_SQUARED_ERROR" - Mean squared error. mean_squared_error =
	// AVG(POW(label - predicted, 2))
	//   "MEAN_SQUARED_LOG_ERROR" - Mean squared log error. mean_squared_log_error
	// = AVG(POW(LN(1 + label) - LN(1 + predicted), 2))
	//   "MEDIAN_ABSOLUTE_ERROR" - Mean absolute error. median_absolute_error =
	// APPROX_QUANTILES(absolute_error, 2)[OFFSET(1)]
	//   "R_SQUARED" - R^2 score. This corresponds to r2_score in ML.EVALUATE.
	// r_squared = 1 - SUM(squared_error)/(COUNT(label)*VAR_POP(label))
	//   "EXPLAINED_VARIANCE" - Explained variance. explained_variance = 1 -
	// VAR_POP(label_error)/VAR_POP(label)
	//   "PRECISION" - Precision is the fraction of actual positive predictions
	// that had positive actual labels. For multiclass this is a macro-averaged
	// metric treating each class as a binary classifier.
	//   "RECALL" - Recall is the fraction of actual positive labels that were
	// given a positive prediction. For multiclass this is a macro-averaged metric.
	//   "ACCURACY" - Accuracy is the fraction of predictions given the correct
	// label. For multiclass this is a globally micro-averaged metric.
	//   "F1_SCORE" - The F1 score is an average of recall and precision. For
	// multiclass this is a macro-averaged metric.
	//   "LOG_LOSS" - Logarithmic Loss. For multiclass this is a macro-averaged
	// metric.
	//   "ROC_AUC" - Area Under an ROC Curve. For multiclass this is a
	// macro-averaged metric.
	//   "DAVIES_BOULDIN_INDEX" - Davies-Bouldin Index.
	//   "MEAN_AVERAGE_PRECISION" - Mean Average Precision.
	//   "NORMALIZED_DISCOUNTED_CUMULATIVE_GAIN" - Normalized Discounted Cumulative
	// Gain.
	//   "AVERAGE_RANK" - Average Rank.
	HparamTuningObjectives []string `json:"hparamTuningObjectives,omitempty"`
	// IncludeDrift: Include drift when fitting an ARIMA model.
	IncludeDrift bool `json:"includeDrift,omitempty"`
	// InitialLearnRate: Specifies the initial learning rate for the line search
	// learn rate strategy.
	InitialLearnRate float64 `json:"initialLearnRate,omitempty"`
	// InputLabelColumns: Name of input label columns in training data.
	InputLabelColumns []string `json:"inputLabelColumns,omitempty"`
	// InstanceWeightColumn: Name of the instance weight column for training data.
	// This column isn't be used as a feature.
	InstanceWeightColumn string `json:"instanceWeightColumn,omitempty"`
	// IntegratedGradientsNumSteps: Number of integral steps for the integrated
	// gradients explain method.
	IntegratedGradientsNumSteps int64 `json:"integratedGradientsNumSteps,omitempty,string"`
	// IsTestColumn: Name of the column used to determine the rows corresponding to
	// control and test. Applies to contribution analysis models.
	IsTestColumn string `json:"isTestColumn,omitempty"`
	// ItemColumn: Item column specified for matrix factorization models.
	ItemColumn string `json:"itemColumn,omitempty"`
	// KmeansInitializationColumn: The column used to provide the initial centroids
	// for kmeans algorithm when kmeans_initialization_method is CUSTOM.
	KmeansInitializationColumn string `json:"kmeansInitializationColumn,omitempty"`
	// KmeansInitializationMethod: The method used to initialize the centroids for
	// kmeans algorithm.
	//
	// Possible values:
	//   "KMEANS_INITIALIZATION_METHOD_UNSPECIFIED" - Unspecified initialization
	// method.
	//   "RANDOM" - Initializes the centroids randomly.
	//   "CUSTOM" - Initializes the centroids using data specified in
	// kmeans_initialization_column.
	//   "KMEANS_PLUS_PLUS" - Initializes with kmeans++.
	KmeansInitializationMethod string `json:"kmeansInitializationMethod,omitempty"`
	// L1RegActivation: L1 regularization coefficient to activations.
	L1RegActivation float64 `json:"l1RegActivation,omitempty"`
	// L1Regularization: L1 regularization coefficient.
	L1Regularization float64 `json:"l1Regularization,omitempty"`
	// L2Regularization: L2 regularization coefficient.
	L2Regularization float64 `json:"l2Regularization,omitempty"`
	// LabelClassWeights: Weights associated with each label class, for rebalancing
	// the training data. Only applicable for classification models.
	LabelClassWeights map[string]float64 `json:"labelClassWeights,omitempty"`
	// LearnRate: Learning rate in training. Used only for iterative training
	// algorithms.
	LearnRate float64 `json:"learnRate,omitempty"`
	// LearnRateStrategy: The strategy to determine learn rate for the current
	// iteration.
	//
	// Possible values:
	//   "LEARN_RATE_STRATEGY_UNSPECIFIED" - Default value.
	//   "LINE_SEARCH" - Use line search to determine learning rate.
	//   "CONSTANT" - Use a constant learning rate.
	LearnRateStrategy string `json:"learnRateStrategy,omitempty"`
	// LossType: Type of loss function used during training run.
	//
	// Possible values:
	//   "LOSS_TYPE_UNSPECIFIED" - Default value.
	//   "MEAN_SQUARED_LOSS" - Mean squared loss, used for linear regression.
	//   "MEAN_LOG_LOSS" - Mean log loss, used for logistic regression.
	LossType string `json:"lossType,omitempty"`
	// MaxIterations: The maximum number of iterations in training. Used only for
	// iterative training algorithms.
	MaxIterations int64 `json:"maxIterations,omitempty,string"`
	// MaxParallelTrials: Maximum number of trials to run in parallel.
	MaxParallelTrials int64 `json:"maxParallelTrials,omitempty,string"`
	// MaxTimeSeriesLength: The maximum number of time points in a time series that
	// can be used in modeling the trend component of the time series. Don't use
	// this option with the `timeSeriesLengthFraction` or `minTimeSeriesLength`
	// options.
	MaxTimeSeriesLength int64 `json:"maxTimeSeriesLength,omitempty,string"`
	// MaxTreeDepth: Maximum depth of a tree for boosted tree models.
	MaxTreeDepth int64 `json:"maxTreeDepth,omitempty,string"`
	// MinAprioriSupport: The apriori support minimum. Applies to contribution
	// analysis models.
	MinAprioriSupport float64 `json:"minAprioriSupport,omitempty"`
	// MinRelativeProgress: When early_stop is true, stops training when accuracy
	// improvement is less than 'min_relative_progress'. Used only for iterative
	// training algorithms.
	MinRelativeProgress float64 `json:"minRelativeProgress,omitempty"`
	// MinSplitLoss: Minimum split loss for boosted tree models.
	MinSplitLoss float64 `json:"minSplitLoss,omitempty"`
	// MinTimeSeriesLength: The minimum number of time points in a time series that
	// are used in modeling the trend component of the time series. If you use this
	// option you must also set the `timeSeriesLengthFraction` option. This
	// training option ensures that enough time points are available when you use
	// `timeSeriesLengthFraction` in trend modeling. This is particularly important
	// when forecasting multiple time series in a single query using
	// `timeSeriesIdColumn`. If the total number of time points is less than the
	// `minTimeSeriesLength` value, then the query uses all available time points.
	MinTimeSeriesLength int64 `json:"minTimeSeriesLength,omitempty,string"`
	// MinTreeChildWeight: Minimum sum of instance weight needed in a child for
	// boosted tree models.
	MinTreeChildWeight int64 `json:"minTreeChildWeight,omitempty,string"`
	// ModelRegistry: The model registry.
	//
	// Possible values:
	//   "MODEL_REGISTRY_UNSPECIFIED" - Default value.
	//   "VERTEX_AI" - Vertex AI.
	ModelRegistry string `json:"modelRegistry,omitempty"`
	// ModelUri: Google Cloud Storage URI from which the model was imported. Only
	// applicable for imported models.
	ModelUri string `json:"modelUri,omitempty"`
	// NonSeasonalOrder: A specification of the non-seasonal part of the ARIMA
	// model: the three components (p, d, q) are the AR order, the degree of
	// differencing, and the MA order.
	NonSeasonalOrder *ArimaOrder `json:"nonSeasonalOrder,omitempty"`
	// NumClusters: Number of clusters for clustering models.
	NumClusters int64 `json:"numClusters,omitempty,string"`
	// NumFactors: Num factors specified for matrix factorization models.
	NumFactors int64 `json:"numFactors,omitempty,string"`
	// NumParallelTree: Number of parallel trees constructed during each iteration
	// for boosted tree models.
	NumParallelTree int64 `json:"numParallelTree,omitempty,string"`
	// NumPrincipalComponents: Number of principal components to keep in the PCA
	// model. Must be <= the number of features.
	NumPrincipalComponents int64 `json:"numPrincipalComponents,omitempty,string"`
	// NumTrials: Number of trials to run this hyperparameter tuning job.
	NumTrials int64 `json:"numTrials,omitempty,string"`
	// OptimizationStrategy: Optimization strategy for training linear regression
	// models.
	//
	// Possible values:
	//   "OPTIMIZATION_STRATEGY_UNSPECIFIED" - Default value.
	//   "BATCH_GRADIENT_DESCENT" - Uses an iterative batch gradient descent
	// algorithm.
	//   "NORMAL_EQUATION" - Uses a normal equation to solve linear regression
	// problem.
	OptimizationStrategy string `json:"optimizationStrategy,omitempty"`
	// Optimizer: Optimizer used for training the neural nets.
	Optimizer string `json:"optimizer,omitempty"`
	// PcaExplainedVarianceRatio: The minimum ratio of cumulative explained
	// variance that needs to be given by the PCA model.
	PcaExplainedVarianceRatio float64 `json:"pcaExplainedVarianceRatio,omitempty"`
	// PcaSolver: The solver for PCA.
	//
	// Possible values:
	//   "UNSPECIFIED" - Default value.
	//   "FULL" - Full eigen-decoposition.
	//   "RANDOMIZED" - Randomized SVD.
	//   "AUTO" - Auto.
	PcaSolver string `json:"pcaSolver,omitempty"`
	// SampledShapleyNumPaths: Number of paths for the sampled Shapley explain
	// method.
	SampledShapleyNumPaths int64 `json:"sampledShapleyNumPaths,omitempty,string"`
	// ScaleFeatures: If true, scale the feature values by dividing the feature
	// standard deviation. Currently only apply to PCA.
	ScaleFeatures bool `json:"scaleFeatures,omitempty"`
	// StandardizeFeatures: Whether to standardize numerical features. Default to
	// true.
	StandardizeFeatures bool `json:"standardizeFeatures,omitempty"`
	// Subsample: Subsample fraction of the training data to grow tree to prevent
	// overfitting for boosted tree models.
	Subsample float64 `json:"subsample,omitempty"`
	// TfVersion: Based on the selected TF version, the corresponding docker image
	// is used to train external models.
	TfVersion string `json:"tfVersion,omitempty"`
	// TimeSeriesDataColumn: Column to be designated as time series data for ARIMA
	// model.
	TimeSeriesDataColumn string `json:"timeSeriesDataColumn,omitempty"`
	// TimeSeriesIdColumn: The time series id column that was used during ARIMA
	// model training.
	TimeSeriesIdColumn string `json:"timeSeriesIdColumn,omitempty"`
	// TimeSeriesIdColumns: The time series id columns that were used during ARIMA
	// model training.
	TimeSeriesIdColumns []string `json:"timeSeriesIdColumns,omitempty"`
	// TimeSeriesLengthFraction: The fraction of the interpolated length of the
	// time series that's used to model the time series trend component. All of the
	// time points of the time series are used to model the non-trend component.
	// This training option accelerates modeling training without sacrificing much
	// forecasting accuracy. You can use this option with `minTimeSeriesLength` but
	// not with `maxTimeSeriesLength`.
	TimeSeriesLengthFraction float64 `json:"timeSeriesLengthFraction,omitempty"`
	// TimeSeriesTimestampColumn: Column to be designated as time series timestamp
	// for ARIMA model.
	TimeSeriesTimestampColumn string `json:"timeSeriesTimestampColumn,omitempty"`
	// TreeMethod: Tree construction algorithm for boosted tree models.
	//
	// Possible values:
	//   "TREE_METHOD_UNSPECIFIED" - Unspecified tree method.
	//   "AUTO" - Use heuristic to choose the fastest method.
	//   "EXACT" - Exact greedy algorithm.
	//   "APPROX" - Approximate greedy algorithm using quantile sketch and gradient
	// histogram.
	//   "HIST" - Fast histogram optimized approximate greedy algorithm.
	TreeMethod string `json:"treeMethod,omitempty"`
	// TrendSmoothingWindowSize: Smoothing window size for the trend component.
	// When a positive value is specified, a center moving average smoothing is
	// applied on the history trend. When the smoothing window is out of the
	// boundary at the beginning or the end of the trend, the first element or the
	// last element is padded to fill the smoothing window before the average is
	// applied.
	TrendSmoothingWindowSize int64 `json:"trendSmoothingWindowSize,omitempty,string"`
	// UserColumn: User column specified for matrix factorization models.
	UserColumn string `json:"userColumn,omitempty"`
	// VertexAiModelVersionAliases: The version aliases to apply in Vertex AI model
	// registry. Always overwrite if the version aliases exists in a existing
	// model.
	VertexAiModelVersionAliases []string `json:"vertexAiModelVersionAliases,omitempty"`
	// WalsAlpha: Hyperparameter for matrix factoration when implicit feedback type
	// is specified.
	WalsAlpha float64 `json:"walsAlpha,omitempty"`
	// WarmStart: Whether to train a model from the last checkpoint.
	WarmStart bool `json:"warmStart,omitempty"`
	// XgboostVersion: User-selected XGBoost versions for training of XGBoost
	// models.
	XgboostVersion string `json:"xgboostVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActivationFn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActivationFn") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TrainingOptions) MarshalJSON() ([]byte, error) {
	type NoMethod TrainingOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *TrainingOptions) UnmarshalJSON(data []byte) error {
	type NoMethod TrainingOptions
	var s1 struct {
		BudgetHours               gensupport.JSONFloat64 `json:"budgetHours"`
		ColsampleBylevel          gensupport.JSONFloat64 `json:"colsampleBylevel"`
		ColsampleBynode           gensupport.JSONFloat64 `json:"colsampleBynode"`
		ColsampleBytree           gensupport.JSONFloat64 `json:"colsampleBytree"`
		DataSplitEvalFraction     gensupport.JSONFloat64 `json:"dataSplitEvalFraction"`
		Dropout                   gensupport.JSONFloat64 `json:"dropout"`
		ForecastLimitLowerBound   gensupport.JSONFloat64 `json:"forecastLimitLowerBound"`
		ForecastLimitUpperBound   gensupport.JSONFloat64 `json:"forecastLimitUpperBound"`
		InitialLearnRate          gensupport.JSONFloat64 `json:"initialLearnRate"`
		L1RegActivation           gensupport.JSONFloat64 `json:"l1RegActivation"`
		L1Regularization          gensupport.JSONFloat64 `json:"l1Regularization"`
		L2Regularization          gensupport.JSONFloat64 `json:"l2Regularization"`
		LearnRate                 gensupport.JSONFloat64 `json:"learnRate"`
		MinAprioriSupport         gensupport.JSONFloat64 `json:"minAprioriSupport"`
		MinRelativeProgress       gensupport.JSONFloat64 `json:"minRelativeProgress"`
		MinSplitLoss              gensupport.JSONFloat64 `json:"minSplitLoss"`
		PcaExplainedVarianceRatio gensupport.JSONFloat64 `json:"pcaExplainedVarianceRatio"`
		Subsample                 gensupport.JSONFloat64 `json:"subsample"`
		TimeSeriesLengthFraction  gensupport.JSONFloat64 `json:"timeSeriesLengthFraction"`
		WalsAlpha                 gensupport.JSONFloat64 `json:"walsAlpha"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.BudgetHours = float64(s1.BudgetHours)
	s.ColsampleBylevel = float64(s1.ColsampleBylevel)
	s.ColsampleBynode = float64(s1.ColsampleBynode)
	s.ColsampleBytree = float64(s1.ColsampleBytree)
	s.DataSplitEvalFraction = float64(s1.DataSplitEvalFraction)
	s.Dropout = float64(s1.Dropout)
	s.ForecastLimitLowerBound = float64(s1.ForecastLimitLowerBound)
	s.ForecastLimitUpperBound = float64(s1.ForecastLimitUpperBound)
	s.InitialLearnRate = float64(s1.InitialLearnRate)
	s.L1RegActivation = float64(s1.L1RegActivation)
	s.L1Regularization = float64(s1.L1Regularization)
	s.L2Regularization = float64(s1.L2Regularization)
	s.LearnRate = float64(s1.LearnRate)
	s.MinAprioriSupport = float64(s1.MinAprioriSupport)
	s.MinRelativeProgress = float64(s1.MinRelativeProgress)
	s.MinSplitLoss = float64(s1.MinSplitLoss)
	s.PcaExplainedVarianceRatio = float64(s1.PcaExplainedVarianceRatio)
	s.Subsample = float64(s1.Subsample)
	s.TimeSeriesLengthFraction = float64(s1.TimeSeriesLengthFraction)
	s.WalsAlpha = float64(s1.WalsAlpha)
	return nil
}

// TrainingRun: Information about a single training query run for the model.
type TrainingRun struct {
	// ClassLevelGlobalExplanations: Output only. Global explanation contains the
	// explanation of top features on the class level. Applies to classification
	// models only.
	ClassLevelGlobalExplanations []*GlobalExplanation `json:"classLevelGlobalExplanations,omitempty"`
	// DataSplitResult: Output only. Data split result of the training run. Only
	// set when the input data is actually split.
	DataSplitResult *DataSplitResult `json:"dataSplitResult,omitempty"`
	// EvaluationMetrics: Output only. The evaluation metrics over training/eval
	// data that were computed at the end of training.
	EvaluationMetrics *EvaluationMetrics `json:"evaluationMetrics,omitempty"`
	// ModelLevelGlobalExplanation: Output only. Global explanation contains the
	// explanation of top features on the model level. Applies to both regression
	// and classification models.
	ModelLevelGlobalExplanation *GlobalExplanation `json:"modelLevelGlobalExplanation,omitempty"`
	// Results: Output only. Output of each iteration run, results.size() <=
	// max_iterations.
	Results []*IterationResult `json:"results,omitempty"`
	// StartTime: Output only. The start time of this training run.
	StartTime string `json:"startTime,omitempty"`
	// TrainingOptions: Output only. Options that were used for this training run,
	// includes user specified and default options that were used.
	TrainingOptions *TrainingOptions `json:"trainingOptions,omitempty"`
	// TrainingStartTime: Output only. The start time of this training run, in
	// milliseconds since epoch.
	TrainingStartTime int64 `json:"trainingStartTime,omitempty,string"`
	// VertexAiModelId: The model id in the Vertex AI Model Registry
	// (https://cloud.google.com/vertex-ai/docs/model-registry/introduction) for
	// this training run.
	VertexAiModelId string `json:"vertexAiModelId,omitempty"`
	// VertexAiModelVersion: Output only. The model version in the Vertex AI Model
	// Registry
	// (https://cloud.google.com/vertex-ai/docs/model-registry/introduction) for
	// this training run.
	VertexAiModelVersion string `json:"vertexAiModelVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ClassLevelGlobalExplanations") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClassLevelGlobalExplanations") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TrainingRun) MarshalJSON() ([]byte, error) {
	type NoMethod TrainingRun
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransactionInfo: [Alpha] Information of a multi-statement transaction.
type TransactionInfo struct {
	// TransactionId: Output only. [Alpha] Id of the transaction.
	TransactionId string `json:"transactionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TransactionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TransactionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransactionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod TransactionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TransformColumn: Information about a single transform column.
type TransformColumn struct {
	// Name: Output only. Name of the column.
	Name string `json:"name,omitempty"`
	// TransformSql: Output only. The SQL expression used in the column transform.
	TransformSql string `json:"transformSql,omitempty"`
	// Type: Output only. Data type of the column after the transform.
	Type *StandardSqlDataType `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TransformColumn) MarshalJSON() ([]byte, error) {
	type NoMethod TransformColumn
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UndeleteDatasetRequest: Request format for undeleting a dataset.
type UndeleteDatasetRequest struct {
	// DeletionTime: Optional. The exact time when the dataset was deleted. If not
	// specified, the most recently deleted version is undeleted. Undeleting a
	// dataset using deletion time is not supported.
	DeletionTime string `json:"deletionTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeletionTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeletionTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UndeleteDatasetRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UndeleteDatasetRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserDefinedFunctionResource:  This is used for defining User Defined
// Function (UDF) resources only when using legacy SQL. Users of GoogleSQL
// should leverage either DDL (e.g. CREATE [TEMPORARY] FUNCTION ... ) or the
// Routines API to define UDF resources. For additional information on
// migrating, see:
// https://cloud.google.com/bigquery/docs/reference/standard-sql/migrating-from-legacy-sql#differences_in_user-defined_javascript_functions
type UserDefinedFunctionResource struct {
	// InlineCode: [Pick one] An inline resource that contains code for a
	// user-defined function (UDF). Providing a inline code resource is equivalent
	// to providing a URI for a file containing the same code.
	InlineCode string `json:"inlineCode,omitempty"`
	// ResourceUri: [Pick one] A code resource to load from a Google Cloud Storage
	// URI (gs://bucket/path).
	ResourceUri string `json:"resourceUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InlineCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InlineCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserDefinedFunctionResource) MarshalJSON() ([]byte, error) {
	type NoMethod UserDefinedFunctionResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VectorSearchStatistics: Statistics for a vector search query. Populated as
// part of JobStatistics2.
type VectorSearchStatistics struct {
	// IndexUnusedReasons: When `indexUsageMode` is `UNUSED` or `PARTIALLY_USED`,
	// this field explains why indexes were not used in all or part of the vector
	// search query. If `indexUsageMode` is `FULLY_USED`, this field is not
	// populated.
	IndexUnusedReasons []*IndexUnusedReason `json:"indexUnusedReasons,omitempty"`
	// IndexUsageMode: Specifies the index usage mode for the query.
	//
	// Possible values:
	//   "INDEX_USAGE_MODE_UNSPECIFIED" - Index usage mode not specified.
	//   "UNUSED" - No vector indexes were used in the vector search query. See
	// [`indexUnusedReasons`]
	// (/bigquery/docs/reference/rest/v2/Job#IndexUnusedReason) for detailed
	// reasons.
	//   "PARTIALLY_USED" - Part of the vector search query used vector indexes.
	// See [`indexUnusedReasons`]
	// (/bigquery/docs/reference/rest/v2/Job#IndexUnusedReason) for why other parts
	// of the query did not use vector indexes.
	//   "FULLY_USED" - The entire vector search query used vector indexes.
	IndexUsageMode string `json:"indexUsageMode,omitempty"`
	// StoredColumnsUsages: Specifies the usage of stored columns in the query when
	// stored columns are used in the query.
	StoredColumnsUsages []*StoredColumnsUsage `json:"storedColumnsUsages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IndexUnusedReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IndexUnusedReasons") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VectorSearchStatistics) MarshalJSON() ([]byte, error) {
	type NoMethod VectorSearchStatistics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ViewDefinition: Describes the definition of a logical view.
type ViewDefinition struct {
	// ForeignDefinitions: Optional. Foreign view representations.
	ForeignDefinitions []*ForeignViewDefinition `json:"foreignDefinitions,omitempty"`
	// PrivacyPolicy: Optional. Specifies the privacy policy for the view.
	PrivacyPolicy *PrivacyPolicy `json:"privacyPolicy,omitempty"`
	// Query: Required. A query that BigQuery executes when the view is referenced.
	Query string `json:"query,omitempty"`
	// UseExplicitColumnNames: True if the column names are explicitly specified.
	// For example by using the 'CREATE VIEW v(c1, c2) AS ...' syntax. Can only be
	// set for GoogleSQL views.
	UseExplicitColumnNames bool `json:"useExplicitColumnNames,omitempty"`
	// UseLegacySql: Specifies whether to use BigQuery's legacy SQL for this view.
	// The default value is true. If set to false, the view will use BigQuery's
	// GoogleSQL: https://cloud.google.com/bigquery/sql-reference/ Queries and
	// views that reference this view must use the same flag value. A wrapper is
	// used here because the default value is True.
	UseLegacySql bool `json:"useLegacySql,omitempty"`
	// UserDefinedFunctionResources: Describes user-defined function resources used
	// in the query.
	UserDefinedFunctionResources []*UserDefinedFunctionResource `json:"userDefinedFunctionResources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ForeignDefinitions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ForeignDefinitions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ViewDefinition) MarshalJSON() ([]byte, error) {
	type NoMethod ViewDefinition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type DatasetsDeleteCall struct {
	s          *Service
	projectId  string
	datasetId  string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the dataset specified by the datasetId value. Before you can
// delete a dataset, you must delete all its tables, either manually or by
// specifying deleteContents. Immediately after deletion, you can create
// another dataset with the same name.
//
// - datasetId: Dataset ID of dataset being deleted.
// - projectId: Project ID of the dataset being deleted.
func (r *DatasetsService) Delete(projectId string, datasetId string) *DatasetsDeleteCall {
	c := &DatasetsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	return c
}

// DeleteContents sets the optional parameter "deleteContents": If True, delete
// all the tables in the dataset. If False and the dataset contains tables, the
// request will fail. Default is False
func (c *DatasetsDeleteCall) DeleteContents(deleteContents bool) *DatasetsDeleteCall {
	c.urlParams_.Set("deleteContents", fmt.Sprint(deleteContents))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatasetsDeleteCall) Fields(s ...googleapi.Field) *DatasetsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatasetsDeleteCall) Context(ctx context.Context) *DatasetsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatasetsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatasetsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.datasets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.datasets.delete" call.
func (c *DatasetsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.datasets.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type DatasetsGetCall struct {
	s            *Service
	projectId    string
	datasetId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the dataset specified by datasetID.
//
// - datasetId: Dataset ID of the requested dataset.
// - projectId: Project ID of the requested dataset.
func (r *DatasetsService) Get(projectId string, datasetId string) *DatasetsGetCall {
	c := &DatasetsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	return c
}

// AccessPolicyVersion sets the optional parameter "accessPolicyVersion": The
// version of the access policy schema to fetch. Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected. Requests for
// conditional access policy binding in datasets must specify version 3.
// Dataset with no conditional role bindings in access policy may specify any
// valid value or leave the field unset. This field will be mapped to [IAM
// Policy version] (https://cloud.google.com/iam/docs/policies#versions) and
// will be used to fetch policy from IAM. If unset or if 0 or 1 value is used
// for dataset with conditional bindings, access entry with condition will have
// role string appended by 'withcond' string followed by a hash value. For
// example : { "access": [ { "role":
// "roles/bigquery.dataViewer_with_conditionalbinding_7a34awqsda",
// "userByEmail": "user@example.com", } ] } Please refer
// https://cloud.google.com/iam/docs/troubleshooting-withcond for more details.
func (c *DatasetsGetCall) AccessPolicyVersion(accessPolicyVersion int64) *DatasetsGetCall {
	c.urlParams_.Set("accessPolicyVersion", fmt.Sprint(accessPolicyVersion))
	return c
}

// DatasetView sets the optional parameter "datasetView": Specifies the view
// that determines which dataset information is returned. By default, metadata
// and ACL information are returned.
//
// Possible values:
//
//	"DATASET_VIEW_UNSPECIFIED" - The default value. Default to the FULL view.
//	"METADATA" - View metadata information for the dataset, such as
//
// friendlyName, description, labels, etc.
//
//	"ACL" - View ACL information for the dataset, which defines dataset access
//
// for one or more entities.
//
//	"FULL" - View both dataset metadata and ACL information.
func (c *DatasetsGetCall) DatasetView(datasetView string) *DatasetsGetCall {
	c.urlParams_.Set("datasetView", datasetView)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatasetsGetCall) Fields(s ...googleapi.Field) *DatasetsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DatasetsGetCall) IfNoneMatch(entityTag string) *DatasetsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatasetsGetCall) Context(ctx context.Context) *DatasetsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatasetsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatasetsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.datasets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.datasets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Dataset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatasetsGetCall) Do(opts ...googleapi.CallOption) (*Dataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Dataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.datasets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatasetsInsertCall struct {
	s          *Service
	projectId  string
	dataset    *Dataset
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a new empty dataset.
//
// - projectId: Project ID of the new dataset.
func (r *DatasetsService) Insert(projectId string, dataset *Dataset) *DatasetsInsertCall {
	c := &DatasetsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.dataset = dataset
	return c
}

// AccessPolicyVersion sets the optional parameter "accessPolicyVersion": The
// version of the provided access policy schema. Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected. This version refers
// to the schema version of the access policy and not the version of access
// policy. This field's value can be equal or more than the access policy
// schema provided in the request. For example, * Requests with conditional
// access policy binding in datasets must specify version 3. * But dataset with
// no conditional role bindings in access policy may specify any valid value or
// leave the field unset. If unset or if 0 or 1 value is used for dataset with
// conditional bindings, request will be rejected. This field will be mapped to
// IAM Policy version (https://cloud.google.com/iam/docs/policies#versions) and
// will be used to set policy in IAM.
func (c *DatasetsInsertCall) AccessPolicyVersion(accessPolicyVersion int64) *DatasetsInsertCall {
	c.urlParams_.Set("accessPolicyVersion", fmt.Sprint(accessPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatasetsInsertCall) Fields(s ...googleapi.Field) *DatasetsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatasetsInsertCall) Context(ctx context.Context) *DatasetsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatasetsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatasetsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.dataset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.datasets.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.datasets.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Dataset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatasetsInsertCall) Do(opts ...googleapi.CallOption) (*Dataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Dataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.datasets.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatasetsListCall struct {
	s            *Service
	projectId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all datasets in the specified project to which the user has been
// granted the READER dataset role.
//
// - projectId: Project ID of the datasets to be listed.
func (r *DatasetsService) List(projectId string) *DatasetsListCall {
	c := &DatasetsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	return c
}

// All sets the optional parameter "all": Whether to list all datasets,
// including hidden ones
func (c *DatasetsListCall) All(all bool) *DatasetsListCall {
	c.urlParams_.Set("all", fmt.Sprint(all))
	return c
}

// Filter sets the optional parameter "filter": An expression for filtering the
// results of the request by label. The syntax is `labels.[:]`. Multiple
// filters can be AND-ed together by connecting with a space. Example:
// `labels.department:receiving labels.active`. See Filtering datasets using
// labels
// (https://cloud.google.com/bigquery/docs/filtering-labels#filtering_datasets_using_labels)
// for details.
func (c *DatasetsListCall) Filter(filter string) *DatasetsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results to return in a single response page. Leverage the page tokens to
// iterate through the entire collection.
func (c *DatasetsListCall) MaxResults(maxResults int64) *DatasetsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call, to request the next page of results
func (c *DatasetsListCall) PageToken(pageToken string) *DatasetsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatasetsListCall) Fields(s ...googleapi.Field) *DatasetsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DatasetsListCall) IfNoneMatch(entityTag string) *DatasetsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatasetsListCall) Context(ctx context.Context) *DatasetsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatasetsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatasetsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.datasets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.datasets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *DatasetList.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatasetsListCall) Do(opts ...googleapi.CallOption) (*DatasetList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DatasetList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.datasets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *DatasetsListCall) Pages(ctx context.Context, f func(*DatasetList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type DatasetsPatchCall struct {
	s          *Service
	projectId  string
	datasetId  string
	dataset    *Dataset
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates information in an existing dataset. The update method
// replaces the entire dataset resource, whereas the patch method only replaces
// fields that are provided in the submitted dataset resource. This method
// supports RFC5789 patch semantics.
//
// - datasetId: Dataset ID of the dataset being updated.
// - projectId: Project ID of the dataset being updated.
func (r *DatasetsService) Patch(projectId string, datasetId string, dataset *Dataset) *DatasetsPatchCall {
	c := &DatasetsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.dataset = dataset
	return c
}

// AccessPolicyVersion sets the optional parameter "accessPolicyVersion": The
// version of the provided access policy schema. Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected. This version refers
// to the schema version of the access policy and not the version of access
// policy. This field's value can be equal or more than the access policy
// schema provided in the request. For example, * Operations updating
// conditional access policy binding in datasets must specify version 3. Some
// of the operations are : - Adding a new access policy entry with condition. -
// Removing an access policy entry with condition. - Updating an access policy
// entry with condition. * But dataset with no conditional role bindings in
// access policy may specify any valid value or leave the field unset. If unset
// or if 0 or 1 value is used for dataset with conditional bindings, request
// will be rejected. This field will be mapped to IAM Policy version
// (https://cloud.google.com/iam/docs/policies#versions) and will be used to
// set policy in IAM.
func (c *DatasetsPatchCall) AccessPolicyVersion(accessPolicyVersion int64) *DatasetsPatchCall {
	c.urlParams_.Set("accessPolicyVersion", fmt.Sprint(accessPolicyVersion))
	return c
}

// UpdateMode sets the optional parameter "updateMode": Specifies the fields of
// dataset that update/patch operation is targeting By default, both metadata
// and ACL fields are updated.
//
// Possible values:
//
//	"UPDATE_MODE_UNSPECIFIED" - The default value. Default to the UPDATE_FULL.
//	"UPDATE_METADATA" - Includes metadata information for the dataset, such as
//
// friendlyName, description, labels, etc.
//
//	"UPDATE_ACL" - Includes ACL information for the dataset, which defines
//
// dataset access for one or more entities.
//
//	"UPDATE_FULL" - Includes both dataset metadata and ACL information.
func (c *DatasetsPatchCall) UpdateMode(updateMode string) *DatasetsPatchCall {
	c.urlParams_.Set("updateMode", updateMode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatasetsPatchCall) Fields(s ...googleapi.Field) *DatasetsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatasetsPatchCall) Context(ctx context.Context) *DatasetsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatasetsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatasetsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.dataset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.datasets.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.datasets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Dataset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatasetsPatchCall) Do(opts ...googleapi.CallOption) (*Dataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Dataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.datasets.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatasetsUndeleteCall struct {
	s                      *Service
	projectId              string
	datasetId              string
	undeletedatasetrequest *UndeleteDatasetRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Undelete: Undeletes a dataset which is within time travel window based on
// datasetId. If a time is specified, the dataset version deleted at that time
// is undeleted, else the last live version is undeleted.
//
// - datasetId: Dataset ID of dataset being deleted.
// - projectId: Project ID of the dataset to be undeleted.
func (r *DatasetsService) Undelete(projectId string, datasetId string, undeletedatasetrequest *UndeleteDatasetRequest) *DatasetsUndeleteCall {
	c := &DatasetsUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.undeletedatasetrequest = undeletedatasetrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatasetsUndeleteCall) Fields(s ...googleapi.Field) *DatasetsUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatasetsUndeleteCall) Context(ctx context.Context) *DatasetsUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatasetsUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatasetsUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.undeletedatasetrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}:undelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.datasets.undelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.datasets.undelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Dataset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatasetsUndeleteCall) Do(opts ...googleapi.CallOption) (*Dataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Dataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.datasets.undelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatasetsUpdateCall struct {
	s          *Service
	projectId  string
	datasetId  string
	dataset    *Dataset
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates information in an existing dataset. The update method
// replaces the entire dataset resource, whereas the patch method only replaces
// fields that are provided in the submitted dataset resource.
//
// - datasetId: Dataset ID of the dataset being updated.
// - projectId: Project ID of the dataset being updated.
func (r *DatasetsService) Update(projectId string, datasetId string, dataset *Dataset) *DatasetsUpdateCall {
	c := &DatasetsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.dataset = dataset
	return c
}

// AccessPolicyVersion sets the optional parameter "accessPolicyVersion": The
// version of the provided access policy schema. Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected. This version refers
// to the schema version of the access policy and not the version of access
// policy. This field's value can be equal or more than the access policy
// schema provided in the request. For example, * Operations updating
// conditional access policy binding in datasets must specify version 3. Some
// of the operations are : - Adding a new access policy entry with condition. -
// Removing an access policy entry with condition. - Updating an access policy
// entry with condition. * But dataset with no conditional role bindings in
// access policy may specify any valid value or leave the field unset. If unset
// or if 0 or 1 value is used for dataset with conditional bindings, request
// will be rejected. This field will be mapped to IAM Policy version
// (https://cloud.google.com/iam/docs/policies#versions) and will be used to
// set policy in IAM.
func (c *DatasetsUpdateCall) AccessPolicyVersion(accessPolicyVersion int64) *DatasetsUpdateCall {
	c.urlParams_.Set("accessPolicyVersion", fmt.Sprint(accessPolicyVersion))
	return c
}

// UpdateMode sets the optional parameter "updateMode": Specifies the fields of
// dataset that update/patch operation is targeting By default, both metadata
// and ACL fields are updated.
//
// Possible values:
//
//	"UPDATE_MODE_UNSPECIFIED" - The default value. Default to the UPDATE_FULL.
//	"UPDATE_METADATA" - Includes metadata information for the dataset, such as
//
// friendlyName, description, labels, etc.
//
//	"UPDATE_ACL" - Includes ACL information for the dataset, which defines
//
// dataset access for one or more entities.
//
//	"UPDATE_FULL" - Includes both dataset metadata and ACL information.
func (c *DatasetsUpdateCall) UpdateMode(updateMode string) *DatasetsUpdateCall {
	c.urlParams_.Set("updateMode", updateMode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatasetsUpdateCall) Fields(s ...googleapi.Field) *DatasetsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatasetsUpdateCall) Context(ctx context.Context) *DatasetsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatasetsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatasetsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.dataset)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.datasets.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.datasets.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Dataset.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatasetsUpdateCall) Do(opts ...googleapi.CallOption) (*Dataset, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Dataset{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.datasets.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type JobsCancelCall struct {
	s          *Service
	projectId  string
	jobId      string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Cancel: Requests that a job be cancelled. This call will return immediately,
// and the client will need to poll for the job status to see if the cancel
// completed successfully. Cancelled jobs may still incur costs.
//
// - jobId: Job ID of the job to cancel.
// - projectId: Project ID of the job to cancel.
func (r *JobsService) Cancel(projectId string, jobId string) *JobsCancelCall {
	c := &JobsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.jobId = jobId
	return c
}

// Location sets the optional parameter "location": The geographic location of
// the job. You must specify the location
// (https://cloud.google.com/bigquery/docs/locations#specify_locations) to run
// the job for the following scenarios: * If the location to run a job is not
// in the `us` or the `eu` multi-regional location * If the job's location is
// in a single region (for example, `us-central1`)
func (c *JobsCancelCall) Location(location string) *JobsCancelCall {
	c.urlParams_.Set("location", location)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *JobsCancelCall) Fields(s ...googleapi.Field) *JobsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *JobsCancelCall) Context(ctx context.Context) *JobsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *JobsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *JobsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/jobs/{+jobId}/cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"jobId":     c.jobId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.jobs.cancel", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.jobs.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *JobCancelResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *JobsCancelCall) Do(opts ...googleapi.CallOption) (*JobCancelResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &JobCancelResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.jobs.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type JobsDeleteCall struct {
	s          *Service
	projectId  string
	jobId      string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Requests the deletion of the metadata of a job. This call returns
// when the job's metadata is deleted.
//
//   - jobId: Job ID of the job for which metadata is to be deleted. If this is a
//     parent job which has child jobs, the metadata from all child jobs will be
//     deleted as well. Direct deletion of the metadata of child jobs is not
//     allowed.
//   - projectId: Project ID of the job for which metadata is to be deleted.
func (r *JobsService) Delete(projectId string, jobId string) *JobsDeleteCall {
	c := &JobsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.jobId = jobId
	return c
}

// Location sets the optional parameter "location": The geographic location of
// the job. Required. For more information, see how to specify locations
// (https://cloud.google.com/bigquery/docs/locations#specify_locations).
func (c *JobsDeleteCall) Location(location string) *JobsDeleteCall {
	c.urlParams_.Set("location", location)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *JobsDeleteCall) Fields(s ...googleapi.Field) *JobsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *JobsDeleteCall) Context(ctx context.Context) *JobsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *JobsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *JobsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/jobs/{+jobId}/delete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"jobId":     c.jobId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.jobs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.jobs.delete" call.
func (c *JobsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.jobs.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type JobsGetCall struct {
	s            *Service
	projectId    string
	jobId        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns information about a specific job. Job information is available
// for a six month period after creation. Requires that you're the person who
// ran the job, or have the Is Owner project role.
//
// - jobId: Job ID of the requested job.
// - projectId: Project ID of the requested job.
func (r *JobsService) Get(projectId string, jobId string) *JobsGetCall {
	c := &JobsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.jobId = jobId
	return c
}

// Location sets the optional parameter "location": The geographic location of
// the job. You must specify the location to run the job for the following
// scenarios: * If the location to run a job is not in the `us` or the `eu`
// multi-regional location * If the job's location is in a single region (for
// example, `us-central1`) For more information, see how to specify locations
// (https://cloud.google.com/bigquery/docs/locations#specify_locations).
func (c *JobsGetCall) Location(location string) *JobsGetCall {
	c.urlParams_.Set("location", location)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *JobsGetCall) Fields(s ...googleapi.Field) *JobsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *JobsGetCall) IfNoneMatch(entityTag string) *JobsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *JobsGetCall) Context(ctx context.Context) *JobsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *JobsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *JobsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/jobs/{+jobId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"jobId":     c.jobId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.jobs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.jobs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Job.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *JobsGetCall) Do(opts ...googleapi.CallOption) (*Job, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Job{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.jobs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type JobsGetQueryResultsCall struct {
	s            *Service
	projectId    string
	jobId        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetQueryResults: RPC to get the results of a query job.
//
// - jobId: Job ID of the query job.
// - projectId: Project ID of the query job.
func (r *JobsService) GetQueryResults(projectId string, jobId string) *JobsGetQueryResultsCall {
	c := &JobsGetQueryResultsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.jobId = jobId
	return c
}

// FormatOptionsUseInt64Timestamp sets the optional parameter
// "formatOptions.useInt64Timestamp": Output timestamp as usec int64. Default
// is false.
func (c *JobsGetQueryResultsCall) FormatOptionsUseInt64Timestamp(formatOptionsUseInt64Timestamp bool) *JobsGetQueryResultsCall {
	c.urlParams_.Set("formatOptions.useInt64Timestamp", fmt.Sprint(formatOptionsUseInt64Timestamp))
	return c
}

// Location sets the optional parameter "location": The geographic location of
// the job. You must specify the location to run the job for the following
// scenarios: * If the location to run a job is not in the `us` or the `eu`
// multi-regional location * If the job's location is in a single region (for
// example, `us-central1`) For more information, see how to specify locations
// (https://cloud.google.com/bigquery/docs/locations#specify_locations).
func (c *JobsGetQueryResultsCall) Location(location string) *JobsGetQueryResultsCall {
	c.urlParams_.Set("location", location)
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// results to read.
func (c *JobsGetQueryResultsCall) MaxResults(maxResults int64) *JobsGetQueryResultsCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call, to request the next page of results.
func (c *JobsGetQueryResultsCall) PageToken(pageToken string) *JobsGetQueryResultsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// StartIndex sets the optional parameter "startIndex": Zero-based index of the
// starting row.
func (c *JobsGetQueryResultsCall) StartIndex(startIndex uint64) *JobsGetQueryResultsCall {
	c.urlParams_.Set("startIndex", fmt.Sprint(startIndex))
	return c
}

// TimeoutMs sets the optional parameter "timeoutMs": Optional: Specifies the
// maximum amount of time, in milliseconds, that the client is willing to wait
// for the query to complete. By default, this limit is 10 seconds (10,000
// milliseconds). If the query is complete, the jobComplete field in the
// response is true. If the query has not yet completed, jobComplete is false.
// You can request a longer timeout period in the timeoutMs field. However, the
// call is not guaranteed to wait for the specified timeout; it typically
// returns after around 200 seconds (200,000 milliseconds), even if the query
// is not complete. If jobComplete is false, you can continue to wait for the
// query to complete by calling the getQueryResults method until the
// jobComplete field in the getQueryResults response is true.
func (c *JobsGetQueryResultsCall) TimeoutMs(timeoutMs int64) *JobsGetQueryResultsCall {
	c.urlParams_.Set("timeoutMs", fmt.Sprint(timeoutMs))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *JobsGetQueryResultsCall) Fields(s ...googleapi.Field) *JobsGetQueryResultsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *JobsGetQueryResultsCall) IfNoneMatch(entityTag string) *JobsGetQueryResultsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *JobsGetQueryResultsCall) Context(ctx context.Context) *JobsGetQueryResultsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *JobsGetQueryResultsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *JobsGetQueryResultsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/queries/{+jobId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"jobId":     c.jobId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.jobs.getQueryResults", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.jobs.getQueryResults" call.
// Any non-2xx status code is an error. Response headers are in either
// *GetQueryResultsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *JobsGetQueryResultsCall) Do(opts ...googleapi.CallOption) (*GetQueryResultsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GetQueryResultsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.jobs.getQueryResults", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *JobsGetQueryResultsCall) Pages(ctx context.Context, f func(*GetQueryResultsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.PageToken == "" {
			return nil
		}
		c.PageToken(x.PageToken)
	}
}

type JobsInsertCall struct {
	s          *Service
	projectId  string
	job        *Job
	urlParams_ gensupport.URLParams
	mediaInfo_ *gensupport.MediaInfo
	ctx_       context.Context
	header_    http.Header
}

// Insert: Starts a new asynchronous job. This API has two different kinds of
// endpoint URIs, as this method supports a variety of use cases. * The
// *Metadata* URI is used for most interactions, as it accepts the job
// configuration directly. * The *Upload* URI is ONLY for the case when you're
// sending both a load job configuration and a data stream together. In this
// case, the Upload URI accepts the job configuration and the data as two
// distinct multipart MIME parts.
//
// - projectId: Project ID of project that will be billed for the job.
func (r *JobsService) Insert(projectId string, job *Job) *JobsInsertCall {
	c := &JobsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.job = job
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk size
// may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the upload
// request will be determined by sniffing the contents of r, unless a
// MediaOption generated by googleapi.ContentType is supplied.
// At most one of Media and ResumableMedia may be set.
func (c *JobsInsertCall) Media(r io.Reader, options ...googleapi.MediaOption) *JobsInsertCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be canceled
// with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType identifies the
// MIME media type of the upload, such as "image/png". If mediaType is "", it
// will be auto-detected. The provided ctx will supersede any context
// previously provided to the Context method.
func (c *JobsInsertCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *JobsInsertCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called after every
// chunk. It should be a low-latency function in order to not slow down the
// upload operation. This should only be called when using ResumableMedia (as
// opposed to Media).
func (c *JobsInsertCall) ProgressUpdater(pu googleapi.ProgressUpdater) *JobsInsertCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *JobsInsertCall) Fields(s ...googleapi.Field) *JobsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *JobsInsertCall) Context(ctx context.Context) *JobsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *JobsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *JobsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.job)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/jobs")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/bigquery/v2/projects/{+projectId}/jobs")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	newBody, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, newBody)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.jobs.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.jobs.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Job.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *JobsInsertCall) Do(opts ...googleapi.CallOption) (*Job, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, gensupport.WrapError(err)
		}
	}
	ret := &Job{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.jobs.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type JobsListCall struct {
	s            *Service
	projectId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all jobs that you started in the specified project. Job
// information is available for a six month period after creation. The job list
// is sorted in reverse chronological order, by job creation time. Requires the
// Can View project role, or the Is Owner project role if you set the allUsers
// property.
//
// - projectId: Project ID of the jobs to list.
func (r *JobsService) List(projectId string) *JobsListCall {
	c := &JobsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	return c
}

// AllUsers sets the optional parameter "allUsers": Whether to display jobs
// owned by all users in the project. Default False.
func (c *JobsListCall) AllUsers(allUsers bool) *JobsListCall {
	c.urlParams_.Set("allUsers", fmt.Sprint(allUsers))
	return c
}

// MaxCreationTime sets the optional parameter "maxCreationTime": Max value for
// job creation time, in milliseconds since the POSIX epoch. If set, only jobs
// created before or at this timestamp are returned.
func (c *JobsListCall) MaxCreationTime(maxCreationTime uint64) *JobsListCall {
	c.urlParams_.Set("maxCreationTime", fmt.Sprint(maxCreationTime))
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results to return in a single response page. Leverage the page tokens to
// iterate through the entire collection.
func (c *JobsListCall) MaxResults(maxResults int64) *JobsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// MinCreationTime sets the optional parameter "minCreationTime": Min value for
// job creation time, in milliseconds since the POSIX epoch. If set, only jobs
// created after or at this timestamp are returned.
func (c *JobsListCall) MinCreationTime(minCreationTime uint64) *JobsListCall {
	c.urlParams_.Set("minCreationTime", fmt.Sprint(minCreationTime))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call, to request the next page of results.
func (c *JobsListCall) PageToken(pageToken string) *JobsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ParentJobId sets the optional parameter "parentJobId": If set, show only
// child jobs of the specified parent. Otherwise, show all top-level jobs.
func (c *JobsListCall) ParentJobId(parentJobId string) *JobsListCall {
	c.urlParams_.Set("parentJobId", parentJobId)
	return c
}

// Projection sets the optional parameter "projection": Restrict information
// returned to a set of selected fields
//
// Possible values:
//
//	"full" - Includes all job data
//	"minimal" - Does not include the job configuration
func (c *JobsListCall) Projection(projection string) *JobsListCall {
	c.urlParams_.Set("projection", projection)
	return c
}

// StateFilter sets the optional parameter "stateFilter": Filter for job state
//
// Possible values:
//
//	"done" - Finished jobs
//	"pending" - Pending jobs
//	"running" - Running jobs
func (c *JobsListCall) StateFilter(stateFilter ...string) *JobsListCall {
	c.urlParams_.SetMulti("stateFilter", append([]string{}, stateFilter...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *JobsListCall) Fields(s ...googleapi.Field) *JobsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *JobsListCall) IfNoneMatch(entityTag string) *JobsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *JobsListCall) Context(ctx context.Context) *JobsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *JobsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *JobsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/jobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.jobs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.jobs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *JobList.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *JobsListCall) Do(opts ...googleapi.CallOption) (*JobList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &JobList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.jobs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *JobsListCall) Pages(ctx context.Context, f func(*JobList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type JobsQueryCall struct {
	s            *Service
	projectId    string
	queryrequest *QueryRequest
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Query: Runs a BigQuery SQL query synchronously and returns query results if
// the query completes within a specified timeout.
//
// - projectId: Project ID of the query request.
func (r *JobsService) Query(projectId string, queryrequest *QueryRequest) *JobsQueryCall {
	c := &JobsQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.queryrequest = queryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *JobsQueryCall) Fields(s ...googleapi.Field) *JobsQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *JobsQueryCall) Context(ctx context.Context) *JobsQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *JobsQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *JobsQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.queryrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/queries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.jobs.query", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.jobs.query" call.
// Any non-2xx status code is an error. Response headers are in either
// *QueryResponse.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *JobsQueryCall) Do(opts ...googleapi.CallOption) (*QueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &QueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.jobs.query", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ModelsDeleteCall struct {
	s          *Service
	projectId  string
	datasetId  string
	modelId    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the model specified by modelId from the dataset.
//
// - datasetId: Dataset ID of the model to delete.
// - modelId: Model ID of the model to delete.
// - projectId: Project ID of the model to delete.
func (r *ModelsService) Delete(projectId string, datasetId string, modelId string) *ModelsDeleteCall {
	c := &ModelsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.modelId = modelId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsDeleteCall) Fields(s ...googleapi.Field) *ModelsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsDeleteCall) Context(ctx context.Context) *ModelsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"modelId":   c.modelId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.models.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.models.delete" call.
func (c *ModelsDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.models.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type ModelsGetCall struct {
	s            *Service
	projectId    string
	datasetId    string
	modelId      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified model resource by model ID.
//
// - datasetId: Dataset ID of the requested model.
// - modelId: Model ID of the requested model.
// - projectId: Project ID of the requested model.
func (r *ModelsService) Get(projectId string, datasetId string, modelId string) *ModelsGetCall {
	c := &ModelsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.modelId = modelId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsGetCall) Fields(s ...googleapi.Field) *ModelsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ModelsGetCall) IfNoneMatch(entityTag string) *ModelsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsGetCall) Context(ctx context.Context) *ModelsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"modelId":   c.modelId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.models.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.models.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Model.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ModelsGetCall) Do(opts ...googleapi.CallOption) (*Model, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Model{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.models.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ModelsListCall struct {
	s            *Service
	projectId    string
	datasetId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all models in the specified dataset. Requires the READER dataset
// role. After retrieving the list of models, you can get information about a
// particular model by calling the models.get method.
//
// - datasetId: Dataset ID of the models to list.
// - projectId: Project ID of the models to list.
func (r *ModelsService) List(projectId string, datasetId string) *ModelsListCall {
	c := &ModelsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results to return in a single response page. Leverage the page tokens to
// iterate through the entire collection.
func (c *ModelsListCall) MaxResults(maxResults int64) *ModelsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call to request the next page of results
func (c *ModelsListCall) PageToken(pageToken string) *ModelsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsListCall) Fields(s ...googleapi.Field) *ModelsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ModelsListCall) IfNoneMatch(entityTag string) *ModelsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsListCall) Context(ctx context.Context) *ModelsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/models")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.models.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.models.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListModelsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ModelsListCall) Do(opts ...googleapi.CallOption) (*ListModelsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListModelsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.models.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ModelsListCall) Pages(ctx context.Context, f func(*ListModelsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ModelsPatchCall struct {
	s          *Service
	projectId  string
	datasetId  string
	modelId    string
	model      *Model
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Patch specific fields in the specified model.
//
// - datasetId: Dataset ID of the model to patch.
// - modelId: Model ID of the model to patch.
// - projectId: Project ID of the model to patch.
func (r *ModelsService) Patch(projectId string, datasetId string, modelId string, model *Model) *ModelsPatchCall {
	c := &ModelsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.modelId = modelId
	c.model = model
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ModelsPatchCall) Fields(s ...googleapi.Field) *ModelsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ModelsPatchCall) Context(ctx context.Context) *ModelsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ModelsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ModelsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.model)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"modelId":   c.modelId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.models.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.models.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Model.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ModelsPatchCall) Do(opts ...googleapi.CallOption) (*Model, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Model{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.models.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsGetServiceAccountCall struct {
	s            *Service
	projectId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetServiceAccount: RPC to get the service account for a project used for
// interactions with Google Cloud KMS
//
// - projectId: ID of the project.
func (r *ProjectsService) GetServiceAccount(projectId string) *ProjectsGetServiceAccountCall {
	c := &ProjectsGetServiceAccountCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGetServiceAccountCall) Fields(s ...googleapi.Field) *ProjectsGetServiceAccountCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsGetServiceAccountCall) IfNoneMatch(entityTag string) *ProjectsGetServiceAccountCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGetServiceAccountCall) Context(ctx context.Context) *ProjectsGetServiceAccountCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGetServiceAccountCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetServiceAccountCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/serviceAccount")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.projects.getServiceAccount", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.projects.getServiceAccount" call.
// Any non-2xx status code is an error. Response headers are in either
// *GetServiceAccountResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsGetServiceAccountCall) Do(opts ...googleapi.CallOption) (*GetServiceAccountResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GetServiceAccountResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.projects.getServiceAccount", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: RPC to list projects to which the user has been granted any project
// role. Users of this method are encouraged to consider the Resource Manager
// (https://cloud.google.com/resource-manager/docs/) API, which provides the
// underlying data for this method and has more capabilities.
func (r *ProjectsService) List() *ProjectsListCall {
	c := &ProjectsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// MaxResults sets the optional parameter "maxResults": `maxResults` unset
// returns all results, up to 50 per page. Additionally, the number of projects
// in a page may be fewer than `maxResults` because projects are retrieved and
// then filtered to only projects with the BigQuery API enabled.
func (c *ProjectsListCall) MaxResults(maxResults int64) *ProjectsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call, to request the next page of results. If not present, no
// further pages are present.
func (c *ProjectsListCall) PageToken(pageToken string) *ProjectsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsListCall) Fields(s ...googleapi.Field) *ProjectsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsListCall) IfNoneMatch(entityTag string) *ProjectsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsListCall) Context(ctx context.Context) *ProjectsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.projects.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.projects.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ProjectList.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsListCall) Do(opts ...googleapi.CallOption) (*ProjectList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ProjectList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.projects.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsListCall) Pages(ctx context.Context, f func(*ProjectList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RoutinesDeleteCall struct {
	s          *Service
	projectId  string
	datasetId  string
	routineId  string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the routine specified by routineId from the dataset.
//
// - datasetId: Dataset ID of the routine to delete.
// - projectId: Project ID of the routine to delete.
// - routineId: Routine ID of the routine to delete.
func (r *RoutinesService) Delete(projectId string, datasetId string, routineId string) *RoutinesDeleteCall {
	c := &RoutinesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.routineId = routineId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RoutinesDeleteCall) Fields(s ...googleapi.Field) *RoutinesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RoutinesDeleteCall) Context(ctx context.Context) *RoutinesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RoutinesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RoutinesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"routineId": c.routineId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.routines.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.routines.delete" call.
func (c *RoutinesDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.routines.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type RoutinesGetCall struct {
	s            *Service
	projectId    string
	datasetId    string
	routineId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified routine resource by routine ID.
//
// - datasetId: Dataset ID of the requested routine.
// - projectId: Project ID of the requested routine.
// - routineId: Routine ID of the requested routine.
func (r *RoutinesService) Get(projectId string, datasetId string, routineId string) *RoutinesGetCall {
	c := &RoutinesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.routineId = routineId
	return c
}

// ReadMask sets the optional parameter "readMask": If set, only the Routine
// fields in the field mask are returned in the response. If unset, all Routine
// fields are returned.
func (c *RoutinesGetCall) ReadMask(readMask string) *RoutinesGetCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RoutinesGetCall) Fields(s ...googleapi.Field) *RoutinesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RoutinesGetCall) IfNoneMatch(entityTag string) *RoutinesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RoutinesGetCall) Context(ctx context.Context) *RoutinesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RoutinesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RoutinesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"routineId": c.routineId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.routines.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.routines.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Routine.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RoutinesGetCall) Do(opts ...googleapi.CallOption) (*Routine, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Routine{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.routines.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RoutinesGetIamPolicyCall struct {
	s                   *Service
	resource            string
	getiampolicyrequest *GetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *RoutinesService) GetIamPolicy(resource string, getiampolicyrequest *GetIamPolicyRequest) *RoutinesGetIamPolicyCall {
	c := &RoutinesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.getiampolicyrequest = getiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RoutinesGetIamPolicyCall) Fields(s ...googleapi.Field) *RoutinesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RoutinesGetIamPolicyCall) Context(ctx context.Context) *RoutinesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RoutinesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RoutinesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.getiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.routines.getIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.routines.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RoutinesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.routines.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RoutinesInsertCall struct {
	s          *Service
	projectId  string
	datasetId  string
	routine    *Routine
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a new routine in the dataset.
//
// - datasetId: Dataset ID of the new routine.
// - projectId: Project ID of the new routine.
func (r *RoutinesService) Insert(projectId string, datasetId string, routine *Routine) *RoutinesInsertCall {
	c := &RoutinesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.routine = routine
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RoutinesInsertCall) Fields(s ...googleapi.Field) *RoutinesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RoutinesInsertCall) Context(ctx context.Context) *RoutinesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RoutinesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RoutinesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.routine)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/routines")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.routines.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.routines.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Routine.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RoutinesInsertCall) Do(opts ...googleapi.CallOption) (*Routine, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Routine{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.routines.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RoutinesListCall struct {
	s            *Service
	projectId    string
	datasetId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all routines in the specified dataset. Requires the READER
// dataset role.
//
// - datasetId: Dataset ID of the routines to list.
// - projectId: Project ID of the routines to list.
func (r *RoutinesService) List(projectId string, datasetId string) *RoutinesListCall {
	c := &RoutinesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	return c
}

// Filter sets the optional parameter "filter": If set, then only the Routines
// matching this filter are returned. The supported format is
// `routineType:{RoutineType}`, where `{RoutineType}` is a RoutineType enum.
// For example: `routineType:SCALAR_FUNCTION`.
func (c *RoutinesListCall) Filter(filter string) *RoutinesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results to return in a single response page. Leverage the page tokens to
// iterate through the entire collection.
func (c *RoutinesListCall) MaxResults(maxResults int64) *RoutinesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call, to request the next page of results
func (c *RoutinesListCall) PageToken(pageToken string) *RoutinesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReadMask sets the optional parameter "readMask": If set, then only the
// Routine fields in the field mask, as well as project_id, dataset_id and
// routine_id, are returned in the response. If unset, then the following
// Routine fields are returned: etag, project_id, dataset_id, routine_id,
// routine_type, creation_time, last_modified_time, and language.
func (c *RoutinesListCall) ReadMask(readMask string) *RoutinesListCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RoutinesListCall) Fields(s ...googleapi.Field) *RoutinesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RoutinesListCall) IfNoneMatch(entityTag string) *RoutinesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RoutinesListCall) Context(ctx context.Context) *RoutinesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RoutinesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RoutinesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/routines")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.routines.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.routines.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRoutinesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RoutinesListCall) Do(opts ...googleapi.CallOption) (*ListRoutinesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRoutinesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.routines.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RoutinesListCall) Pages(ctx context.Context, f func(*ListRoutinesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RoutinesSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *RoutinesService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *RoutinesSetIamPolicyCall {
	c := &RoutinesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RoutinesSetIamPolicyCall) Fields(s ...googleapi.Field) *RoutinesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RoutinesSetIamPolicyCall) Context(ctx context.Context) *RoutinesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RoutinesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RoutinesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.routines.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.routines.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RoutinesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.routines.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RoutinesTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *RoutinesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *RoutinesTestIamPermissionsCall {
	c := &RoutinesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RoutinesTestIamPermissionsCall) Fields(s ...googleapi.Field) *RoutinesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RoutinesTestIamPermissionsCall) Context(ctx context.Context) *RoutinesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RoutinesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RoutinesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.routines.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.routines.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RoutinesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.routines.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RoutinesUpdateCall struct {
	s          *Service
	projectId  string
	datasetId  string
	routineId  string
	routine    *Routine
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates information in an existing routine. The update method
// replaces the entire Routine resource.
//
// - datasetId: Dataset ID of the routine to update.
// - projectId: Project ID of the routine to update.
// - routineId: Routine ID of the routine to update.
func (r *RoutinesService) Update(projectId string, datasetId string, routineId string, routine *Routine) *RoutinesUpdateCall {
	c := &RoutinesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.routineId = routineId
	c.routine = routine
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RoutinesUpdateCall) Fields(s ...googleapi.Field) *RoutinesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RoutinesUpdateCall) Context(ctx context.Context) *RoutinesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RoutinesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RoutinesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.routine)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"routineId": c.routineId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.routines.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.routines.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Routine.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RoutinesUpdateCall) Do(opts ...googleapi.CallOption) (*Routine, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Routine{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.routines.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RowAccessPoliciesBatchDeleteCall struct {
	s                                   *Service
	projectId                           string
	datasetId                           string
	tableId                             string
	batchdeleterowaccesspoliciesrequest *BatchDeleteRowAccessPoliciesRequest
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// BatchDelete: Deletes provided row access policies.
//
// - datasetId: Dataset ID of the table to delete the row access policies.
// - projectId: Project ID of the table to delete the row access policies.
// - tableId: Table ID of the table to delete the row access policies.
func (r *RowAccessPoliciesService) BatchDelete(projectId string, datasetId string, tableId string, batchdeleterowaccesspoliciesrequest *BatchDeleteRowAccessPoliciesRequest) *RowAccessPoliciesBatchDeleteCall {
	c := &RowAccessPoliciesBatchDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.tableId = tableId
	c.batchdeleterowaccesspoliciesrequest = batchdeleterowaccesspoliciesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RowAccessPoliciesBatchDeleteCall) Fields(s ...googleapi.Field) *RowAccessPoliciesBatchDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RowAccessPoliciesBatchDeleteCall) Context(ctx context.Context) *RowAccessPoliciesBatchDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RowAccessPoliciesBatchDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RowAccessPoliciesBatchDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.batchdeleterowaccesspoliciesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies:batchDelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"tableId":   c.tableId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.batchDelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.rowAccessPolicies.batchDelete" call.
func (c *RowAccessPoliciesBatchDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.batchDelete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type RowAccessPoliciesDeleteCall struct {
	s          *Service
	projectId  string
	datasetId  string
	tableId    string
	policyId   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a row access policy.
//
// - datasetId: Dataset ID of the table to delete the row access policy.
// - policyId: Policy ID of the row access policy.
// - projectId: Project ID of the table to delete the row access policy.
// - tableId: Table ID of the table to delete the row access policy.
func (r *RowAccessPoliciesService) Delete(projectId string, datasetId string, tableId string, policyId string) *RowAccessPoliciesDeleteCall {
	c := &RowAccessPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.tableId = tableId
	c.policyId = policyId
	return c
}

// Force sets the optional parameter "force": If set to true, it deletes the
// row access policy even if it's the last row access policy on the table and
// the deletion will widen the access rather narrowing it.
func (c *RowAccessPoliciesDeleteCall) Force(force bool) *RowAccessPoliciesDeleteCall {
	c.urlParams_.Set("force", fmt.Sprint(force))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RowAccessPoliciesDeleteCall) Fields(s ...googleapi.Field) *RowAccessPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RowAccessPoliciesDeleteCall) Context(ctx context.Context) *RowAccessPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RowAccessPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RowAccessPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies/{+policyId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"tableId":   c.tableId,
		"policyId":  c.policyId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.rowAccessPolicies.delete" call.
func (c *RowAccessPoliciesDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type RowAccessPoliciesGetCall struct {
	s            *Service
	projectId    string
	datasetId    string
	tableId      string
	policyId     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified row access policy by policy ID.
//
// - datasetId: Dataset ID of the table to get the row access policy.
// - policyId: Policy ID of the row access policy.
// - projectId: Project ID of the table to get the row access policy.
// - tableId: Table ID of the table to get the row access policy.
func (r *RowAccessPoliciesService) Get(projectId string, datasetId string, tableId string, policyId string) *RowAccessPoliciesGetCall {
	c := &RowAccessPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.tableId = tableId
	c.policyId = policyId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RowAccessPoliciesGetCall) Fields(s ...googleapi.Field) *RowAccessPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RowAccessPoliciesGetCall) IfNoneMatch(entityTag string) *RowAccessPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RowAccessPoliciesGetCall) Context(ctx context.Context) *RowAccessPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RowAccessPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RowAccessPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies/{+policyId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"tableId":   c.tableId,
		"policyId":  c.policyId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.rowAccessPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *RowAccessPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RowAccessPoliciesGetCall) Do(opts ...googleapi.CallOption) (*RowAccessPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RowAccessPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RowAccessPoliciesGetIamPolicyCall struct {
	s                   *Service
	resource            string
	getiampolicyrequest *GetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *RowAccessPoliciesService) GetIamPolicy(resource string, getiampolicyrequest *GetIamPolicyRequest) *RowAccessPoliciesGetIamPolicyCall {
	c := &RowAccessPoliciesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.getiampolicyrequest = getiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RowAccessPoliciesGetIamPolicyCall) Fields(s ...googleapi.Field) *RowAccessPoliciesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RowAccessPoliciesGetIamPolicyCall) Context(ctx context.Context) *RowAccessPoliciesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RowAccessPoliciesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RowAccessPoliciesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.getiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.getIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.rowAccessPolicies.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *RowAccessPoliciesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RowAccessPoliciesInsertCall struct {
	s               *Service
	projectId       string
	datasetId       string
	tableId         string
	rowaccesspolicy *RowAccessPolicy
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Insert: Creates a row access policy.
//
// - datasetId: Dataset ID of the table to get the row access policy.
// - projectId: Project ID of the table to get the row access policy.
// - tableId: Table ID of the table to get the row access policy.
func (r *RowAccessPoliciesService) Insert(projectId string, datasetId string, tableId string, rowaccesspolicy *RowAccessPolicy) *RowAccessPoliciesInsertCall {
	c := &RowAccessPoliciesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.tableId = tableId
	c.rowaccesspolicy = rowaccesspolicy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RowAccessPoliciesInsertCall) Fields(s ...googleapi.Field) *RowAccessPoliciesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RowAccessPoliciesInsertCall) Context(ctx context.Context) *RowAccessPoliciesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RowAccessPoliciesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RowAccessPoliciesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rowaccesspolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"tableId":   c.tableId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.rowAccessPolicies.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *RowAccessPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RowAccessPoliciesInsertCall) Do(opts ...googleapi.CallOption) (*RowAccessPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RowAccessPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RowAccessPoliciesListCall struct {
	s            *Service
	projectId    string
	datasetId    string
	tableId      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all row access policies on the specified table.
//
// - datasetId: Dataset ID of row access policies to list.
// - projectId: Project ID of the row access policies to list.
// - tableId: Table ID of the table to list row access policies.
func (r *RowAccessPoliciesService) List(projectId string, datasetId string, tableId string) *RowAccessPoliciesListCall {
	c := &RowAccessPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.tableId = tableId
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return in a single response page. Leverage the page tokens to
// iterate through the entire collection.
func (c *RowAccessPoliciesListCall) PageSize(pageSize int64) *RowAccessPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call, to request the next page of results.
func (c *RowAccessPoliciesListCall) PageToken(pageToken string) *RowAccessPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RowAccessPoliciesListCall) Fields(s ...googleapi.Field) *RowAccessPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *RowAccessPoliciesListCall) IfNoneMatch(entityTag string) *RowAccessPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RowAccessPoliciesListCall) Context(ctx context.Context) *RowAccessPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RowAccessPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RowAccessPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"tableId":   c.tableId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.rowAccessPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRowAccessPoliciesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RowAccessPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListRowAccessPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRowAccessPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *RowAccessPoliciesListCall) Pages(ctx context.Context, f func(*ListRowAccessPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type RowAccessPoliciesTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *RowAccessPoliciesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *RowAccessPoliciesTestIamPermissionsCall {
	c := &RowAccessPoliciesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RowAccessPoliciesTestIamPermissionsCall) Fields(s ...googleapi.Field) *RowAccessPoliciesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RowAccessPoliciesTestIamPermissionsCall) Context(ctx context.Context) *RowAccessPoliciesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RowAccessPoliciesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RowAccessPoliciesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.rowAccessPolicies.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *RowAccessPoliciesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type RowAccessPoliciesUpdateCall struct {
	s               *Service
	projectId       string
	datasetId       string
	tableId         string
	policyId        string
	rowaccesspolicy *RowAccessPolicy
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Update: Updates a row access policy.
//
// - datasetId: Dataset ID of the table to get the row access policy.
// - policyId: Policy ID of the row access policy.
// - projectId: Project ID of the table to get the row access policy.
// - tableId: Table ID of the table to get the row access policy.
func (r *RowAccessPoliciesService) Update(projectId string, datasetId string, tableId string, policyId string, rowaccesspolicy *RowAccessPolicy) *RowAccessPoliciesUpdateCall {
	c := &RowAccessPoliciesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.tableId = tableId
	c.policyId = policyId
	c.rowaccesspolicy = rowaccesspolicy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *RowAccessPoliciesUpdateCall) Fields(s ...googleapi.Field) *RowAccessPoliciesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *RowAccessPoliciesUpdateCall) Context(ctx context.Context) *RowAccessPoliciesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *RowAccessPoliciesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *RowAccessPoliciesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.rowaccesspolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies/{+policyId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"tableId":   c.tableId,
		"policyId":  c.policyId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.rowAccessPolicies.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *RowAccessPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *RowAccessPoliciesUpdateCall) Do(opts ...googleapi.CallOption) (*RowAccessPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RowAccessPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.rowAccessPolicies.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type TabledataInsertAllCall struct {
	s                         *Service
	projectId                 string
	datasetId                 string
	tableId                   string
	tabledatainsertallrequest *TableDataInsertAllRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// InsertAll: Streams data into BigQuery one record at a time without needing
// to run a load job.
//
// - datasetId: Dataset ID of the destination.
// - projectId: Project ID of the destination.
// - tableId: Table ID of the destination.
func (r *TabledataService) InsertAll(projectId string, datasetId string, tableId string, tabledatainsertallrequest *TableDataInsertAllRequest) *TabledataInsertAllCall {
	c := &TabledataInsertAllCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.tableId = tableId
	c.tabledatainsertallrequest = tabledatainsertallrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TabledataInsertAllCall) Fields(s ...googleapi.Field) *TabledataInsertAllCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TabledataInsertAllCall) Context(ctx context.Context) *TabledataInsertAllCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TabledataInsertAllCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TabledataInsertAllCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.tabledatainsertallrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/insertAll")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"tableId":   c.tableId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.tabledata.insertAll", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.tabledata.insertAll" call.
// Any non-2xx status code is an error. Response headers are in either
// *TableDataInsertAllResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TabledataInsertAllCall) Do(opts ...googleapi.CallOption) (*TableDataInsertAllResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TableDataInsertAllResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.tabledata.insertAll", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type TabledataListCall struct {
	s            *Service
	projectId    string
	datasetId    string
	tableId      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List the content of a table in rows.
//
// - datasetId: Dataset id of the table to list.
// - projectId: Project id of the table to list.
// - tableId: Table id of the table to list.
func (r *TabledataService) List(projectId string, datasetId string, tableId string) *TabledataListCall {
	c := &TabledataListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.tableId = tableId
	return c
}

// FormatOptionsUseInt64Timestamp sets the optional parameter
// "formatOptions.useInt64Timestamp": Output timestamp as usec int64. Default
// is false.
func (c *TabledataListCall) FormatOptionsUseInt64Timestamp(formatOptionsUseInt64Timestamp bool) *TabledataListCall {
	c.urlParams_.Set("formatOptions.useInt64Timestamp", fmt.Sprint(formatOptionsUseInt64Timestamp))
	return c
}

// MaxResults sets the optional parameter "maxResults": Row limit of the table.
func (c *TabledataListCall) MaxResults(maxResults int64) *TabledataListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": To retrieve the next page
// of table data, set this field to the string provided in the pageToken field
// of the response body from your previous call to tabledata.list.
func (c *TabledataListCall) PageToken(pageToken string) *TabledataListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// SelectedFields sets the optional parameter "selectedFields": Subset of
// fields to return, supports select into sub fields. Example: selected_fields
// = "a,e.d.f";
func (c *TabledataListCall) SelectedFields(selectedFields string) *TabledataListCall {
	c.urlParams_.Set("selectedFields", selectedFields)
	return c
}

// StartIndex sets the optional parameter "startIndex": Start row index of the
// table.
func (c *TabledataListCall) StartIndex(startIndex uint64) *TabledataListCall {
	c.urlParams_.Set("startIndex", fmt.Sprint(startIndex))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TabledataListCall) Fields(s ...googleapi.Field) *TabledataListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TabledataListCall) IfNoneMatch(entityTag string) *TabledataListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TabledataListCall) Context(ctx context.Context) *TabledataListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TabledataListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TabledataListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/data")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"tableId":   c.tableId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.tabledata.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.tabledata.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *TableDataList.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TabledataListCall) Do(opts ...googleapi.CallOption) (*TableDataList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TableDataList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.tabledata.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *TabledataListCall) Pages(ctx context.Context, f func(*TableDataList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.PageToken == "" {
			return nil
		}
		c.PageToken(x.PageToken)
	}
}

type TablesDeleteCall struct {
	s          *Service
	projectId  string
	datasetId  string
	tableId    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the table specified by tableId from the dataset. If the
// table contains data, all the data will be deleted.
//
// - datasetId: Dataset ID of the table to delete.
// - projectId: Project ID of the table to delete.
// - tableId: Table ID of the table to delete.
func (r *TablesService) Delete(projectId string, datasetId string, tableId string) *TablesDeleteCall {
	c := &TablesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.tableId = tableId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TablesDeleteCall) Fields(s ...googleapi.Field) *TablesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TablesDeleteCall) Context(ctx context.Context) *TablesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TablesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TablesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"tableId":   c.tableId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.tables.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.tables.delete" call.
func (c *TablesDeleteCall) Do(opts ...googleapi.CallOption) error {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if err != nil {
		return err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return gensupport.WrapError(err)
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.tables.delete", "response", internallog.HTTPResponse(res, nil))
	return nil
}

type TablesGetCall struct {
	s            *Service
	projectId    string
	datasetId    string
	tableId      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified table resource by table ID. This method does not
// return the data in the table, it only returns the table resource, which
// describes the structure of this table.
//
// - datasetId: Dataset ID of the requested table.
// - projectId: Project ID of the requested table.
// - tableId: Table ID of the requested table.
func (r *TablesService) Get(projectId string, datasetId string, tableId string) *TablesGetCall {
	c := &TablesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.tableId = tableId
	return c
}

// SelectedFields sets the optional parameter "selectedFields": List of table
// schema fields to return (comma-separated). If unspecified, all fields are
// returned. A fieldMask cannot be used here because the fields will
// automatically be converted from camelCase to snake_case and the conversion
// will fail if there are underscores. Since these are fields in BigQuery table
// schemas, underscores are allowed.
func (c *TablesGetCall) SelectedFields(selectedFields string) *TablesGetCall {
	c.urlParams_.Set("selectedFields", selectedFields)
	return c
}

// View sets the optional parameter "view": Specifies the view that determines
// which table information is returned. By default, basic table information and
// storage statistics (STORAGE_STATS) are returned.
//
// Possible values:
//
//	"TABLE_METADATA_VIEW_UNSPECIFIED" - The default value. Default to the
//
// STORAGE_STATS view.
//
//	"BASIC" - Includes basic table information including schema and
//
// partitioning specification. This view does not include storage statistics
// such as numRows or numBytes. This view is significantly more efficient and
// should be used to support high query rates.
//
//	"STORAGE_STATS" - Includes all information in the BASIC view as well as
//
// storage statistics (numBytes, numLongTermBytes, numRows and
// lastModifiedTime).
//
//	"FULL" - Includes all table information, including storage statistics. It
//
// returns same information as STORAGE_STATS view, but may contain additional
// information in the future.
func (c *TablesGetCall) View(view string) *TablesGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TablesGetCall) Fields(s ...googleapi.Field) *TablesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TablesGetCall) IfNoneMatch(entityTag string) *TablesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TablesGetCall) Context(ctx context.Context) *TablesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TablesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TablesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"tableId":   c.tableId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.tables.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.tables.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Table.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TablesGetCall) Do(opts ...googleapi.CallOption) (*Table, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Table{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.tables.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type TablesGetIamPolicyCall struct {
	s                   *Service
	resource            string
	getiampolicyrequest *GetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *TablesService) GetIamPolicy(resource string, getiampolicyrequest *GetIamPolicyRequest) *TablesGetIamPolicyCall {
	c := &TablesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.getiampolicyrequest = getiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TablesGetIamPolicyCall) Fields(s ...googleapi.Field) *TablesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TablesGetIamPolicyCall) Context(ctx context.Context) *TablesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TablesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TablesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.getiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.tables.getIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.tables.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TablesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.tables.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type TablesInsertCall struct {
	s          *Service
	projectId  string
	datasetId  string
	table      *Table
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a new, empty table in the dataset.
//
// - datasetId: Dataset ID of the new table.
// - projectId: Project ID of the new table.
func (r *TablesService) Insert(projectId string, datasetId string, table *Table) *TablesInsertCall {
	c := &TablesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.table = table
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TablesInsertCall) Fields(s ...googleapi.Field) *TablesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TablesInsertCall) Context(ctx context.Context) *TablesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TablesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TablesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.table)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.tables.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.tables.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Table.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TablesInsertCall) Do(opts ...googleapi.CallOption) (*Table, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Table{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.tables.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type TablesListCall struct {
	s            *Service
	projectId    string
	datasetId    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all tables in the specified dataset. Requires the READER dataset
// role.
//
// - datasetId: Dataset ID of the tables to list.
// - projectId: Project ID of the tables to list.
func (r *TablesService) List(projectId string, datasetId string) *TablesListCall {
	c := &TablesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// results to return in a single response page. Leverage the page tokens to
// iterate through the entire collection.
func (c *TablesListCall) MaxResults(maxResults int64) *TablesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, returned by a
// previous call, to request the next page of results
func (c *TablesListCall) PageToken(pageToken string) *TablesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TablesListCall) Fields(s ...googleapi.Field) *TablesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TablesListCall) IfNoneMatch(entityTag string) *TablesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TablesListCall) Context(ctx context.Context) *TablesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TablesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TablesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.tables.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.tables.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *TableList.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TablesListCall) Do(opts ...googleapi.CallOption) (*TableList, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TableList{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.tables.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *TablesListCall) Pages(ctx context.Context, f func(*TableList) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type TablesPatchCall struct {
	s          *Service
	projectId  string
	datasetId  string
	tableId    string
	table      *Table
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates information in an existing table. The update method replaces
// the entire table resource, whereas the patch method only replaces fields
// that are provided in the submitted table resource. This method supports
// RFC5789 patch semantics.
//
// - datasetId: Dataset ID of the table to update.
// - projectId: Project ID of the table to update.
// - tableId: Table ID of the table to update.
func (r *TablesService) Patch(projectId string, datasetId string, tableId string, table *Table) *TablesPatchCall {
	c := &TablesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.tableId = tableId
	c.table = table
	return c
}

// AutodetectSchema sets the optional parameter "autodetect_schema": When true
// will autodetect schema, else will keep original schema
func (c *TablesPatchCall) AutodetectSchema(autodetectSchema bool) *TablesPatchCall {
	c.urlParams_.Set("autodetect_schema", fmt.Sprint(autodetectSchema))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TablesPatchCall) Fields(s ...googleapi.Field) *TablesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TablesPatchCall) Context(ctx context.Context) *TablesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TablesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TablesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.table)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"tableId":   c.tableId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.tables.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.tables.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Table.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TablesPatchCall) Do(opts ...googleapi.CallOption) (*Table, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Table{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.tables.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type TablesSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *TablesService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *TablesSetIamPolicyCall {
	c := &TablesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TablesSetIamPolicyCall) Fields(s ...googleapi.Field) *TablesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TablesSetIamPolicyCall) Context(ctx context.Context) *TablesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TablesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TablesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.tables.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.tables.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TablesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.tables.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type TablesTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *TablesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *TablesTestIamPermissionsCall {
	c := &TablesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TablesTestIamPermissionsCall) Fields(s ...googleapi.Field) *TablesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TablesTestIamPermissionsCall) Context(ctx context.Context) *TablesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TablesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TablesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.tables.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.tables.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *TablesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.tables.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type TablesUpdateCall struct {
	s          *Service
	projectId  string
	datasetId  string
	tableId    string
	table      *Table
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates information in an existing table. The update method replaces
// the entire Table resource, whereas the patch method only replaces fields
// that are provided in the submitted Table resource.
//
// - datasetId: Dataset ID of the table to update.
// - projectId: Project ID of the table to update.
// - tableId: Table ID of the table to update.
func (r *TablesService) Update(projectId string, datasetId string, tableId string, table *Table) *TablesUpdateCall {
	c := &TablesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.datasetId = datasetId
	c.tableId = tableId
	c.table = table
	return c
}

// AutodetectSchema sets the optional parameter "autodetect_schema": When true
// will autodetect schema, else will keep original schema
func (c *TablesUpdateCall) AutodetectSchema(autodetectSchema bool) *TablesUpdateCall {
	c.urlParams_.Set("autodetect_schema", fmt.Sprint(autodetectSchema))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TablesUpdateCall) Fields(s ...googleapi.Field) *TablesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TablesUpdateCall) Context(ctx context.Context) *TablesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TablesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TablesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.table)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"datasetId": c.datasetId,
		"tableId":   c.tableId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "bigquery.tables.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "bigquery.tables.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Table.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *TablesUpdateCall) Do(opts ...googleapi.CallOption) (*Table, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Table{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "bigquery.tables.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
