// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package policysimulator provides access to the Policy Simulator API.
//
// For product documentation, see: https://cloud.google.com/iam/docs/simulating-access
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/policysimulator/v1"
//	...
//	ctx := context.Background()
//	policysimulatorService, err := policysimulator.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	policysimulatorService, err := policysimulator.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	policysimulatorService, err := policysimulator.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package policysimulator // import "google.golang.org/api/policysimulator/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "policysimulator:v1"
const apiName = "policysimulator"
const apiVersion = "v1"
const basePath = "https://policysimulator.googleapis.com/"
const basePathTemplate = "https://policysimulator.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://policysimulator.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Folders = NewFoldersService(s)
	s.Operations = NewOperationsService(s)
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Folders *FoldersService

	Operations *OperationsService

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewFoldersService(s *Service) *FoldersService {
	rs := &FoldersService{s: s}
	rs.Locations = NewFoldersLocationsService(s)
	return rs
}

type FoldersService struct {
	s *Service

	Locations *FoldersLocationsService
}

func NewFoldersLocationsService(s *Service) *FoldersLocationsService {
	rs := &FoldersLocationsService{s: s}
	rs.AccessPolicySimulations = NewFoldersLocationsAccessPolicySimulationsService(s)
	rs.OrgPolicyViolationsPreviews = NewFoldersLocationsOrgPolicyViolationsPreviewsService(s)
	rs.Replays = NewFoldersLocationsReplaysService(s)
	return rs
}

type FoldersLocationsService struct {
	s *Service

	AccessPolicySimulations *FoldersLocationsAccessPolicySimulationsService

	OrgPolicyViolationsPreviews *FoldersLocationsOrgPolicyViolationsPreviewsService

	Replays *FoldersLocationsReplaysService
}

func NewFoldersLocationsAccessPolicySimulationsService(s *Service) *FoldersLocationsAccessPolicySimulationsService {
	rs := &FoldersLocationsAccessPolicySimulationsService{s: s}
	rs.Operations = NewFoldersLocationsAccessPolicySimulationsOperationsService(s)
	return rs
}

type FoldersLocationsAccessPolicySimulationsService struct {
	s *Service

	Operations *FoldersLocationsAccessPolicySimulationsOperationsService
}

func NewFoldersLocationsAccessPolicySimulationsOperationsService(s *Service) *FoldersLocationsAccessPolicySimulationsOperationsService {
	rs := &FoldersLocationsAccessPolicySimulationsOperationsService{s: s}
	return rs
}

type FoldersLocationsAccessPolicySimulationsOperationsService struct {
	s *Service
}

func NewFoldersLocationsOrgPolicyViolationsPreviewsService(s *Service) *FoldersLocationsOrgPolicyViolationsPreviewsService {
	rs := &FoldersLocationsOrgPolicyViolationsPreviewsService{s: s}
	rs.Operations = NewFoldersLocationsOrgPolicyViolationsPreviewsOperationsService(s)
	return rs
}

type FoldersLocationsOrgPolicyViolationsPreviewsService struct {
	s *Service

	Operations *FoldersLocationsOrgPolicyViolationsPreviewsOperationsService
}

func NewFoldersLocationsOrgPolicyViolationsPreviewsOperationsService(s *Service) *FoldersLocationsOrgPolicyViolationsPreviewsOperationsService {
	rs := &FoldersLocationsOrgPolicyViolationsPreviewsOperationsService{s: s}
	return rs
}

type FoldersLocationsOrgPolicyViolationsPreviewsOperationsService struct {
	s *Service
}

func NewFoldersLocationsReplaysService(s *Service) *FoldersLocationsReplaysService {
	rs := &FoldersLocationsReplaysService{s: s}
	rs.Operations = NewFoldersLocationsReplaysOperationsService(s)
	rs.Results = NewFoldersLocationsReplaysResultsService(s)
	return rs
}

type FoldersLocationsReplaysService struct {
	s *Service

	Operations *FoldersLocationsReplaysOperationsService

	Results *FoldersLocationsReplaysResultsService
}

func NewFoldersLocationsReplaysOperationsService(s *Service) *FoldersLocationsReplaysOperationsService {
	rs := &FoldersLocationsReplaysOperationsService{s: s}
	return rs
}

type FoldersLocationsReplaysOperationsService struct {
	s *Service
}

func NewFoldersLocationsReplaysResultsService(s *Service) *FoldersLocationsReplaysResultsService {
	rs := &FoldersLocationsReplaysResultsService{s: s}
	return rs
}

type FoldersLocationsReplaysResultsService struct {
	s *Service
}

func NewOperationsService(s *Service) *OperationsService {
	rs := &OperationsService{s: s}
	return rs
}

type OperationsService struct {
	s *Service
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Locations = NewOrganizationsLocationsService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Locations *OrganizationsLocationsService
}

func NewOrganizationsLocationsService(s *Service) *OrganizationsLocationsService {
	rs := &OrganizationsLocationsService{s: s}
	rs.AccessPolicySimulations = NewOrganizationsLocationsAccessPolicySimulationsService(s)
	rs.OrgPolicyViolationsPreviews = NewOrganizationsLocationsOrgPolicyViolationsPreviewsService(s)
	rs.Replays = NewOrganizationsLocationsReplaysService(s)
	return rs
}

type OrganizationsLocationsService struct {
	s *Service

	AccessPolicySimulations *OrganizationsLocationsAccessPolicySimulationsService

	OrgPolicyViolationsPreviews *OrganizationsLocationsOrgPolicyViolationsPreviewsService

	Replays *OrganizationsLocationsReplaysService
}

func NewOrganizationsLocationsAccessPolicySimulationsService(s *Service) *OrganizationsLocationsAccessPolicySimulationsService {
	rs := &OrganizationsLocationsAccessPolicySimulationsService{s: s}
	rs.Operations = NewOrganizationsLocationsAccessPolicySimulationsOperationsService(s)
	return rs
}

type OrganizationsLocationsAccessPolicySimulationsService struct {
	s *Service

	Operations *OrganizationsLocationsAccessPolicySimulationsOperationsService
}

func NewOrganizationsLocationsAccessPolicySimulationsOperationsService(s *Service) *OrganizationsLocationsAccessPolicySimulationsOperationsService {
	rs := &OrganizationsLocationsAccessPolicySimulationsOperationsService{s: s}
	return rs
}

type OrganizationsLocationsAccessPolicySimulationsOperationsService struct {
	s *Service
}

func NewOrganizationsLocationsOrgPolicyViolationsPreviewsService(s *Service) *OrganizationsLocationsOrgPolicyViolationsPreviewsService {
	rs := &OrganizationsLocationsOrgPolicyViolationsPreviewsService{s: s}
	rs.Operations = NewOrganizationsLocationsOrgPolicyViolationsPreviewsOperationsService(s)
	rs.OrgPolicyViolations = NewOrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsService(s)
	return rs
}

type OrganizationsLocationsOrgPolicyViolationsPreviewsService struct {
	s *Service

	Operations *OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsService

	OrgPolicyViolations *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsService
}

func NewOrganizationsLocationsOrgPolicyViolationsPreviewsOperationsService(s *Service) *OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsService {
	rs := &OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsService{s: s}
	return rs
}

type OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsService struct {
	s *Service
}

func NewOrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsService(s *Service) *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsService {
	rs := &OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsService{s: s}
	return rs
}

type OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsService struct {
	s *Service
}

func NewOrganizationsLocationsReplaysService(s *Service) *OrganizationsLocationsReplaysService {
	rs := &OrganizationsLocationsReplaysService{s: s}
	rs.Operations = NewOrganizationsLocationsReplaysOperationsService(s)
	rs.Results = NewOrganizationsLocationsReplaysResultsService(s)
	return rs
}

type OrganizationsLocationsReplaysService struct {
	s *Service

	Operations *OrganizationsLocationsReplaysOperationsService

	Results *OrganizationsLocationsReplaysResultsService
}

func NewOrganizationsLocationsReplaysOperationsService(s *Service) *OrganizationsLocationsReplaysOperationsService {
	rs := &OrganizationsLocationsReplaysOperationsService{s: s}
	return rs
}

type OrganizationsLocationsReplaysOperationsService struct {
	s *Service
}

func NewOrganizationsLocationsReplaysResultsService(s *Service) *OrganizationsLocationsReplaysResultsService {
	rs := &OrganizationsLocationsReplaysResultsService{s: s}
	return rs
}

type OrganizationsLocationsReplaysResultsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.AccessPolicySimulations = NewProjectsLocationsAccessPolicySimulationsService(s)
	rs.OrgPolicyViolationsPreviews = NewProjectsLocationsOrgPolicyViolationsPreviewsService(s)
	rs.Replays = NewProjectsLocationsReplaysService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	AccessPolicySimulations *ProjectsLocationsAccessPolicySimulationsService

	OrgPolicyViolationsPreviews *ProjectsLocationsOrgPolicyViolationsPreviewsService

	Replays *ProjectsLocationsReplaysService
}

func NewProjectsLocationsAccessPolicySimulationsService(s *Service) *ProjectsLocationsAccessPolicySimulationsService {
	rs := &ProjectsLocationsAccessPolicySimulationsService{s: s}
	rs.Operations = NewProjectsLocationsAccessPolicySimulationsOperationsService(s)
	return rs
}

type ProjectsLocationsAccessPolicySimulationsService struct {
	s *Service

	Operations *ProjectsLocationsAccessPolicySimulationsOperationsService
}

func NewProjectsLocationsAccessPolicySimulationsOperationsService(s *Service) *ProjectsLocationsAccessPolicySimulationsOperationsService {
	rs := &ProjectsLocationsAccessPolicySimulationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsAccessPolicySimulationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsOrgPolicyViolationsPreviewsService(s *Service) *ProjectsLocationsOrgPolicyViolationsPreviewsService {
	rs := &ProjectsLocationsOrgPolicyViolationsPreviewsService{s: s}
	rs.Operations = NewProjectsLocationsOrgPolicyViolationsPreviewsOperationsService(s)
	return rs
}

type ProjectsLocationsOrgPolicyViolationsPreviewsService struct {
	s *Service

	Operations *ProjectsLocationsOrgPolicyViolationsPreviewsOperationsService
}

func NewProjectsLocationsOrgPolicyViolationsPreviewsOperationsService(s *Service) *ProjectsLocationsOrgPolicyViolationsPreviewsOperationsService {
	rs := &ProjectsLocationsOrgPolicyViolationsPreviewsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOrgPolicyViolationsPreviewsOperationsService struct {
	s *Service
}

func NewProjectsLocationsReplaysService(s *Service) *ProjectsLocationsReplaysService {
	rs := &ProjectsLocationsReplaysService{s: s}
	rs.Operations = NewProjectsLocationsReplaysOperationsService(s)
	rs.Results = NewProjectsLocationsReplaysResultsService(s)
	return rs
}

type ProjectsLocationsReplaysService struct {
	s *Service

	Operations *ProjectsLocationsReplaysOperationsService

	Results *ProjectsLocationsReplaysResultsService
}

func NewProjectsLocationsReplaysOperationsService(s *Service) *ProjectsLocationsReplaysOperationsService {
	rs := &ProjectsLocationsReplaysOperationsService{s: s}
	return rs
}

type ProjectsLocationsReplaysOperationsService struct {
	s *Service
}

func NewProjectsLocationsReplaysResultsService(s *Service) *ProjectsLocationsReplaysResultsService {
	rs := &ProjectsLocationsReplaysResultsService{s: s}
	return rs
}

type ProjectsLocationsReplaysResultsService struct {
	s *Service
}

// GoogleCloudOrgpolicyV2AlternatePolicySpec: Similar to PolicySpec but with an
// extra 'launch' field for launch reference. The PolicySpec here is specific
// for dry-run.
type GoogleCloudOrgpolicyV2AlternatePolicySpec struct {
	// Launch: Reference to the launch that will be used while audit logging and to
	// control the launch. Should be set only in the alternate policy.
	Launch string `json:"launch,omitempty"`
	// Spec: Specify constraint for configurations of Google Cloud resources.
	Spec *GoogleCloudOrgpolicyV2PolicySpec `json:"spec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Launch") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Launch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2AlternatePolicySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2AlternatePolicySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2CustomConstraint: A custom constraint defined by
// customers which can *only* be applied to the given resource types and
// organization. By creating a custom constraint, customers can apply policies
// of this custom constraint. *Creating a custom constraint itself does NOT
// apply any policy enforcement*.
type GoogleCloudOrgpolicyV2CustomConstraint struct {
	// ActionType: Allow or deny type.
	//
	// Possible values:
	//   "ACTION_TYPE_UNSPECIFIED" - This is only used for distinguishing unset
	// values and should never be used. Results in an error.
	//   "ALLOW" - Allowed action type.
	//   "DENY" - Deny action type.
	ActionType string `json:"actionType,omitempty"`
	// Condition: A Common Expression Language (CEL) condition which is used in the
	// evaluation of the constraint. For example:
	// `resource.instanceName.matches("(production|test)_(.+_)?[\d]+")` or,
	// `resource.management.auto_upgrade == true` The max length of the condition
	// is 1000 characters.
	Condition string `json:"condition,omitempty"`
	// Description: Detailed information about this custom policy constraint. The
	// max length of the description is 2000 characters.
	Description string `json:"description,omitempty"`
	// DisplayName: One line display name for the UI. The max length of the
	// display_name is 200 characters.
	DisplayName string `json:"displayName,omitempty"`
	// MethodTypes: All the operations being applied for this constraint.
	//
	// Possible values:
	//   "METHOD_TYPE_UNSPECIFIED" - This is only used for distinguishing unset
	// values and should never be used. Results in an error.
	//   "CREATE" - Constraint applied when creating the resource.
	//   "UPDATE" - Constraint applied when updating the resource.
	//   "DELETE" - Constraint applied when deleting the resource. Not currently
	// supported.
	//   "REMOVE_GRANT" - Constraint applied when removing an IAM grant.
	//   "GOVERN_TAGS" - Constraint applied when enforcing forced tagging.
	MethodTypes []string `json:"methodTypes,omitempty"`
	// Name: Immutable. Name of the constraint. This is unique within the
	// organization. Format of the name should be *
	// `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
	// Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
	// The max length is 70 characters and the minimum length is 1. Note that the
	// prefix `organizations/{organization_id}/customConstraints/` is not counted.
	Name string `json:"name,omitempty"`
	// ResourceTypes: Immutable. The resource instance type on which this policy
	// applies. Format will be of the form : `/` Example: *
	// `compute.googleapis.com/Instance`.
	ResourceTypes []string `json:"resourceTypes,omitempty"`
	// UpdateTime: Output only. The last time this custom constraint was updated.
	// This represents the last time that the `CreateCustomConstraint` or
	// `UpdateCustomConstraint` methods were called.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2CustomConstraint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2CustomConstraint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2Policy: Defines an organization policy which is used
// to specify constraints for configurations of Google Cloud resources.
type GoogleCloudOrgpolicyV2Policy struct {
	// Alternate: Deprecated.
	Alternate *GoogleCloudOrgpolicyV2AlternatePolicySpec `json:"alternate,omitempty"`
	// DryRunSpec: Dry-run policy. Audit-only policy, can be used to monitor how
	// the policy would have impacted the existing and future resources if it's
	// enforced.
	DryRunSpec *GoogleCloudOrgpolicyV2PolicySpec `json:"dryRunSpec,omitempty"`
	// Etag: Optional. An opaque tag indicating the current state of the policy,
	// used for concurrency control. This 'etag' is computed by the server based on
	// the value of other fields, and may be sent on update and delete requests to
	// ensure the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`
	// Name: Immutable. The resource name of the policy. Must be one of the
	// following forms, where `constraint_name` is the name of the constraint which
	// this policy configures: *
	// `projects/{project_number}/policies/{constraint_name}` *
	// `folders/{folder_id}/policies/{constraint_name}` *
	// `organizations/{organization_id}/policies/{constraint_name}` For example,
	// `projects/123/policies/compute.disableSerialPortAccess`. Note:
	// `projects/{project_id}/policies/{constraint_name}` is also an acceptable
	// name for API requests, but responses will return the name using the
	// equivalent project number.
	Name string `json:"name,omitempty"`
	// Spec: Basic information about the organization policy.
	Spec *GoogleCloudOrgpolicyV2PolicySpec `json:"spec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Alternate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Alternate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2PolicySpec: Defines a Google Cloud policy
// specification which is used to specify constraints for configurations of
// Google Cloud resources.
type GoogleCloudOrgpolicyV2PolicySpec struct {
	// Etag: An opaque tag indicating the current version of the policySpec, used
	// for concurrency control. This field is ignored if used in a `CreatePolicy`
	// request. When the policy is returned from either a `GetPolicy` or a
	// `ListPolicies` request, this `etag` indicates the version of the current
	// policySpec to use when executing a read-modify-write loop. When the policy
	// is returned from a `GetEffectivePolicy` request, the `etag` will be unset.
	Etag string `json:"etag,omitempty"`
	// InheritFromParent: Determines the inheritance behavior for this policy. If
	// `inherit_from_parent` is true, policy rules set higher up in the hierarchy
	// (up to the closest root) are inherited and present in the effective policy.
	// If it is false, then no rules are inherited, and this policy becomes the new
	// root for evaluation. This field can be set only for policies which configure
	// list constraints.
	InheritFromParent bool `json:"inheritFromParent,omitempty"`
	// Reset: Ignores policies set above this resource and restores the
	// `constraint_default` enforcement behavior of the specific constraint at this
	// resource. This field can be set in policies for either list or boolean
	// constraints. If set, `rules` must be empty and `inherit_from_parent` must be
	// set to false.
	Reset bool `json:"reset,omitempty"`
	// Rules: In policies for boolean constraints, the following requirements
	// apply: - There must be one and only one policy rule where condition is
	// unset. - Boolean policy rules with conditions must set `enforced` to the
	// opposite of the policy rule without a condition. - During policy evaluation,
	// policy rules with conditions that are true for a target resource take
	// precedence.
	Rules []*GoogleCloudOrgpolicyV2PolicySpecPolicyRule `json:"rules,omitempty"`
	// UpdateTime: Output only. The time stamp this was previously updated. This
	// represents the last time a call to `CreatePolicy` or `UpdatePolicy` was made
	// for that policy.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2PolicySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2PolicySpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2PolicySpecPolicyRule: A rule used to express this
// policy.
type GoogleCloudOrgpolicyV2PolicySpecPolicyRule struct {
	// AllowAll: Setting this to true means that all values are allowed. This field
	// can be set only in policies for list constraints.
	AllowAll bool `json:"allowAll,omitempty"`
	// Condition: A condition that determines whether this rule is used to evaluate
	// the policy. When set, the google.type.Expr.expression field must contain 1
	// to 10 subexpressions, joined by the `||` or `&&` operators. Each
	// subexpression must use the `resource.matchTag()`, `resource.matchTagId()`,
	// `resource.hasTagKey()`, or `resource.hasTagKeyId()` Common Expression
	// Language (CEL) function. The `resource.matchTag()` function takes the
	// following arguments: * `key_name`: the namespaced name of the tag key, with
	// the organization ID and a slash (`/`) as a prefix; for example,
	// `123456789012/environment` * `value_name`: the short name of the tag value
	// For example: `resource.matchTag('123456789012/environment, 'prod')` The
	// `resource.matchTagId()` function takes the following arguments: * `key_id`:
	// the permanent ID of the tag key; for example, `tagKeys/123456789012` *
	// `value_id`: the permanent ID of the tag value; for example,
	// `tagValues/567890123456` For example:
	// `resource.matchTagId('tagKeys/123456789012', 'tagValues/567890123456')` The
	// `resource.hasTagKey()` function takes the following argument: * `key_name`:
	// the namespaced name of the tag key, with the organization ID and a slash
	// (`/`) as a prefix; for example, `123456789012/environment` For example:
	// `resource.hasTagKey('123456789012/environment')` The
	// `resource.hasTagKeyId()` function takes the following arguments: * `key_id`:
	// the permanent ID of the tag key; for example, `tagKeys/123456789012` For
	// example: `resource.hasTagKeyId('tagKeys/123456789012')`
	Condition *GoogleTypeExpr `json:"condition,omitempty"`
	// DenyAll: Setting this to true means that all values are denied. This field
	// can be set only in policies for list constraints.
	DenyAll bool `json:"denyAll,omitempty"`
	// Enforce: If `true`, then the policy is enforced. If `false`, then any
	// configuration is acceptable. This field can be set in policies for boolean
	// constraints, custom constraints and managed constraints.
	Enforce bool `json:"enforce,omitempty"`
	// Parameters: Optional. Required for managed constraints if parameters are
	// defined. Passes parameter values when policy enforcement is enabled. Ensure
	// that parameter value types match those defined in the constraint definition.
	// For example: ``` { "allowedLocations" : ["us-east1", "us-west1"], "allowAll"
	// : true } ```
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// Values: List of values to be used for this policy rule. This field can be
	// set only in policies for list constraints.
	Values *GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowAll") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowAll") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2PolicySpecPolicyRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2PolicySpecPolicyRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues: A message that holds
// specific allowed and denied values. This message can define specific values
// and subtrees of the Resource Manager resource hierarchy (`Organizations`,
// `Folders`, `Projects`) that are allowed or denied. This is achieved by using
// the `under:` and optional `is:` prefixes. The `under:` prefix is used to
// denote resource subtree values. The `is:` prefix is used to denote specific
// values, and is required only if the value contains a ":". Values prefixed
// with "is:" are treated the same as values with no prefix. Ancestry subtrees
// must be in one of the following formats: - `projects/` (for example,
// `projects/tokyo-rain-123`) - `folders/` (for example, `folders/1234`) -
// `organizations/` (for example, `organizations/1234`) The `supports_under`
// field of the associated `Constraint` defines whether ancestry prefixes can
// be used.
type GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues struct {
	// AllowedValues: List of values allowed at this resource.
	AllowedValues []string `json:"allowedValues,omitempty"`
	// DeniedValues: List of values denied at this resource.
	DeniedValues []string `json:"deniedValues,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedValues") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV2PolicySpecPolicyRuleStringValues
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1AccessStateDiff: A summary and comparison of the
// principal's access under the current (baseline) policies and the proposed
// (simulated) policies for a single access tuple.
type GoogleCloudPolicysimulatorV1AccessStateDiff struct {
	// AccessChange: How the principal's access, specified in the AccessState
	// field, changed between the current (baseline) policies and proposed
	// (simulated) policies.
	//
	// Possible values:
	//   "ACCESS_CHANGE_TYPE_UNSPECIFIED" - Default value. This value is unused.
	//   "NO_CHANGE" - The principal's access did not change. This includes the
	// case where both baseline and simulated are UNKNOWN, but the unknown
	// information is equivalent.
	//   "UNKNOWN_CHANGE" - The principal's access under both the current policies
	// and the proposed policies is `UNKNOWN`, but the unknown information differs
	// between them.
	//   "ACCESS_REVOKED" - The principal had access under the current policies
	// (`GRANTED`), but will no longer have access after the proposed changes
	// (`NOT_GRANTED`).
	//   "ACCESS_GAINED" - The principal did not have access under the current
	// policies (`NOT_GRANTED`), but will have access after the proposed changes
	// (`GRANTED`).
	//   "ACCESS_MAYBE_REVOKED" - This result can occur for the following reasons:
	// * The principal had access under the current policies (`GRANTED`), but their
	// access after the proposed changes is `UNKNOWN`. * The principal's access
	// under the current policies is `UNKNOWN`, but they will not have access after
	// the proposed changes (`NOT_GRANTED`).
	//   "ACCESS_MAYBE_GAINED" - This result can occur for the following reasons: *
	// The principal did not have access under the current policies
	// (`NOT_GRANTED`), but their access after the proposed changes is `UNKNOWN`. *
	// The principal's access under the current policies is `UNKNOWN`, but they
	// will have access after the proposed changes (`GRANTED`).
	AccessChange string `json:"accessChange,omitempty"`
	// Baseline: The results of evaluating the access tuple under the current
	// (baseline) policies. If the AccessState couldn't be fully evaluated, this
	// field explains why.
	Baseline *GoogleCloudPolicysimulatorV1ExplainedAccess `json:"baseline,omitempty"`
	// Simulated: The results of evaluating the access tuple under the proposed
	// (simulated) policies. If the AccessState couldn't be fully evaluated, this
	// field explains why.
	Simulated *GoogleCloudPolicysimulatorV1ExplainedAccess `json:"simulated,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessChange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessChange") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1AccessStateDiff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1AccessStateDiff
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1AccessTuple: Information about the principal,
// resource, and permission to check.
type GoogleCloudPolicysimulatorV1AccessTuple struct {
	// FullResourceName: Required. The full resource name that identifies the
	// resource. For example,
	// `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/m
	// y-instance`. For examples of full resource names for Google Cloud services,
	// see https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	FullResourceName string `json:"fullResourceName,omitempty"`
	// Permission: Required. The IAM permission to check for the specified
	// principal and resource. For a complete list of IAM permissions, see
	// https://cloud.google.com/iam/help/permissions/reference. For a complete list
	// of predefined IAM roles and the permissions in each role, see
	// https://cloud.google.com/iam/help/roles/reference.
	Permission string `json:"permission,omitempty"`
	// Principal: Required. The principal whose access you want to check, in the
	// form of the email address that represents that principal. For example,
	// `alice@example.com` or
	// `my-service-account@my-project.iam.gserviceaccount.com`. The principal must
	// be a Google Account or a service account. Other types of principals are not
	// supported.
	Principal string `json:"principal,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FullResourceName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FullResourceName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1AccessTuple) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1AccessTuple
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1BindingExplanation: Details about how a binding
// in a policy affects a principal's ability to use a permission.
type GoogleCloudPolicysimulatorV1BindingExplanation struct {
	// Access: Required. Indicates whether _this binding_ provides the specified
	// permission to the specified principal for the specified resource. This field
	// does _not_ indicate whether the principal actually has the permission for
	// the resource. There might be another binding that overrides this binding. To
	// determine whether the principal actually has the permission, use the
	// `access` field in the TroubleshootIamPolicyResponse.
	//
	// Possible values:
	//   "ACCESS_STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "GRANTED" - The principal has the permission.
	//   "NOT_GRANTED" - The principal does not have the permission.
	//   "UNKNOWN_CONDITIONAL" - The principal has the permission only if a
	// condition expression evaluates to `true`.
	//   "UNKNOWN_INFO_DENIED" - The user who created the Replay does not have
	// access to all of the policies that Policy Simulator needs to evaluate.
	Access string `json:"access,omitempty"`
	// Condition: A condition expression that prevents this binding from granting
	// access unless the expression evaluates to `true`. To learn about IAM
	// Conditions, see https://cloud.google.com/iam/docs/conditions-overview.
	Condition *GoogleTypeExpr `json:"condition,omitempty"`
	// Memberships: Indicates whether each principal in the binding includes the
	// principal specified in the request, either directly or indirectly. Each key
	// identifies a principal in the binding, and each value indicates whether the
	// principal in the binding includes the principal in the request. For example,
	// suppose that a binding includes the following principals: *
	// `user:alice@example.com` * `group:product-eng@example.com` The principal in
	// the replayed access tuple is `user:bob@example.com`. This user is a
	// principal of the group `group:product-eng@example.com`. For the first
	// principal in the binding, the key is `user:alice@example.com`, and the
	// `membership` field in the value is set to `MEMBERSHIP_NOT_INCLUDED`. For the
	// second principal in the binding, the key is `group:product-eng@example.com`,
	// and the `membership` field in the value is set to `MEMBERSHIP_INCLUDED`.
	Memberships map[string]GoogleCloudPolicysimulatorV1BindingExplanationAnnotatedMembership `json:"memberships,omitempty"`
	// Relevance: The relevance of this binding to the overall determination for
	// the entire policy.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Default value. This value is unused.
	//   "NORMAL" - The data point has a limited effect on the result. Changing the
	// data point is unlikely to affect the overall determination.
	//   "HIGH" - The data point has a strong effect on the result. Changing the
	// data point is likely to affect the overall determination.
	Relevance string `json:"relevance,omitempty"`
	// Role: The role that this binding grants. For example,
	// `roles/compute.serviceAgent`. For a complete list of predefined IAM roles,
	// as well as the permissions in each role, see
	// https://cloud.google.com/iam/help/roles/reference.
	Role string `json:"role,omitempty"`
	// RolePermission: Indicates whether the role granted by this binding contains
	// the specified permission.
	//
	// Possible values:
	//   "ROLE_PERMISSION_UNSPECIFIED" - Default value. This value is unused.
	//   "ROLE_PERMISSION_INCLUDED" - The permission is included in the role.
	//   "ROLE_PERMISSION_NOT_INCLUDED" - The permission is not included in the
	// role.
	//   "ROLE_PERMISSION_UNKNOWN_INFO_DENIED" - The user who created the Replay is
	// not allowed to access the binding.
	RolePermission string `json:"rolePermission,omitempty"`
	// RolePermissionRelevance: The relevance of the permission's existence, or
	// nonexistence, in the role to the overall determination for the entire
	// policy.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Default value. This value is unused.
	//   "NORMAL" - The data point has a limited effect on the result. Changing the
	// data point is unlikely to affect the overall determination.
	//   "HIGH" - The data point has a strong effect on the result. Changing the
	// data point is likely to affect the overall determination.
	RolePermissionRelevance string `json:"rolePermissionRelevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Access") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Access") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1BindingExplanation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1BindingExplanation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1BindingExplanationAnnotatedMembership: Details
// about whether the binding includes the principal.
type GoogleCloudPolicysimulatorV1BindingExplanationAnnotatedMembership struct {
	// Membership: Indicates whether the binding includes the principal.
	//
	// Possible values:
	//   "MEMBERSHIP_UNSPECIFIED" - Default value. This value is unused.
	//   "MEMBERSHIP_INCLUDED" - The binding includes the principal. The principal
	// can be included directly or indirectly. For example: * A principal is
	// included directly if that principal is listed in the binding. * A principal
	// is included indirectly if that principal is in a Google group or Google
	// Workspace domain that is listed in the binding.
	//   "MEMBERSHIP_NOT_INCLUDED" - The binding does not include the principal.
	//   "MEMBERSHIP_UNKNOWN_INFO_DENIED" - The user who created the Replay is not
	// allowed to access the binding.
	//   "MEMBERSHIP_UNKNOWN_UNSUPPORTED" - The principal is an unsupported type.
	// Only Google Accounts and service accounts are supported.
	Membership string `json:"membership,omitempty"`
	// Relevance: The relevance of the principal's status to the overall
	// determination for the binding.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Default value. This value is unused.
	//   "NORMAL" - The data point has a limited effect on the result. Changing the
	// data point is unlikely to affect the overall determination.
	//   "HIGH" - The data point has a strong effect on the result. Changing the
	// data point is likely to affect the overall determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Membership") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Membership") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1BindingExplanationAnnotatedMembership) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1BindingExplanationAnnotatedMembership
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1ExplainedAccess: Details about how a set of
// policies, listed in ExplainedPolicy, resulted in a certain AccessState when
// replaying an access tuple.
type GoogleCloudPolicysimulatorV1ExplainedAccess struct {
	// AccessState: Whether the principal in the access tuple has permission to
	// access the resource in the access tuple under the given policies.
	//
	// Possible values:
	//   "ACCESS_STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "GRANTED" - The principal has the permission.
	//   "NOT_GRANTED" - The principal does not have the permission.
	//   "UNKNOWN_CONDITIONAL" - The principal has the permission only if a
	// condition expression evaluates to `true`.
	//   "UNKNOWN_INFO_DENIED" - The user who created the Replay does not have
	// access to all of the policies that Policy Simulator needs to evaluate.
	AccessState string `json:"accessState,omitempty"`
	// Errors: If the AccessState is `UNKNOWN`, this field contains a list of
	// errors explaining why the result is `UNKNOWN`. If the `AccessState` is
	// `GRANTED` or `NOT_GRANTED`, this field is omitted.
	Errors []*GoogleRpcStatus `json:"errors,omitempty"`
	// Policies: If the AccessState is `UNKNOWN`, this field contains the policies
	// that led to that result. If the `AccessState` is `GRANTED` or `NOT_GRANTED`,
	// this field is omitted.
	Policies []*GoogleCloudPolicysimulatorV1ExplainedPolicy `json:"policies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessState") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1ExplainedAccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1ExplainedAccess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1ExplainedPolicy: Details about how a specific
// IAM Policy contributed to the access check.
type GoogleCloudPolicysimulatorV1ExplainedPolicy struct {
	// Access: Indicates whether _this policy_ provides the specified permission to
	// the specified principal for the specified resource. This field does _not_
	// indicate whether the principal actually has the permission for the resource.
	// There might be another policy that overrides this policy. To determine
	// whether the principal actually has the permission, use the `access` field in
	// the TroubleshootIamPolicyResponse.
	//
	// Possible values:
	//   "ACCESS_STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "GRANTED" - The principal has the permission.
	//   "NOT_GRANTED" - The principal does not have the permission.
	//   "UNKNOWN_CONDITIONAL" - The principal has the permission only if a
	// condition expression evaluates to `true`.
	//   "UNKNOWN_INFO_DENIED" - The user who created the Replay does not have
	// access to all of the policies that Policy Simulator needs to evaluate.
	Access string `json:"access,omitempty"`
	// BindingExplanations: Details about how each binding in the policy affects
	// the principal's ability, or inability, to use the permission for the
	// resource. If the user who created the Replay does not have access to the
	// policy, this field is omitted.
	BindingExplanations []*GoogleCloudPolicysimulatorV1BindingExplanation `json:"bindingExplanations,omitempty"`
	// FullResourceName: The full resource name that identifies the resource. For
	// example,
	// `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/m
	// y-instance`. If the user who created the Replay does not have access to the
	// policy, this field is omitted. For examples of full resource names for
	// Google Cloud services, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
	FullResourceName string `json:"fullResourceName,omitempty"`
	// Policy: The IAM policy attached to the resource. If the user who created the
	// Replay does not have access to the policy, this field is empty.
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`
	// Relevance: The relevance of this policy to the overall determination in the
	// TroubleshootIamPolicyResponse. If the user who created the Replay does not
	// have access to the policy, this field is omitted.
	//
	// Possible values:
	//   "HEURISTIC_RELEVANCE_UNSPECIFIED" - Default value. This value is unused.
	//   "NORMAL" - The data point has a limited effect on the result. Changing the
	// data point is unlikely to affect the overall determination.
	//   "HIGH" - The data point has a strong effect on the result. Changing the
	// data point is likely to affect the overall determination.
	Relevance string `json:"relevance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Access") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Access") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1ExplainedPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1ExplainedPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsPreviewsResponse:
// ListOrgPolicyViolationsPreviewsResponse is the response message for
// OrgPolicyViolationsPreviewService.ListOrgPolicyViolationsPreviews.
type GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsPreviewsResponse struct {
	// NextPageToken: A token that you can use to retrieve the next page of
	// results. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// OrgPolicyViolationsPreviews: The list of OrgPolicyViolationsPreview
	OrgPolicyViolationsPreviews []*GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreview `json:"orgPolicyViolationsPreviews,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsPreviewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsPreviewsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsResponse:
// ListOrgPolicyViolationsResponse is the response message for
// OrgPolicyViolationsPreviewService.ListOrgPolicyViolations
type GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsResponse struct {
	// NextPageToken: A token that you can use to retrieve the next page of
	// results. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// OrgPolicyViolations: The list of OrgPolicyViolations
	OrgPolicyViolations []*GoogleCloudPolicysimulatorV1OrgPolicyViolation `json:"orgPolicyViolations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1ListReplayResultsResponse: Response message for
// Simulator.ListReplayResults.
type GoogleCloudPolicysimulatorV1ListReplayResultsResponse struct {
	// NextPageToken: A token that you can use to retrieve the next page of
	// ReplayResult objects. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ReplayResults: The results of running a Replay.
	ReplayResults []*GoogleCloudPolicysimulatorV1ReplayResult `json:"replayResults,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1ListReplayResultsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1ListReplayResultsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1OrgPolicyOverlay: The proposed changes to
// OrgPolicy.
type GoogleCloudPolicysimulatorV1OrgPolicyOverlay struct {
	// CustomConstraints: Optional. The OrgPolicy CustomConstraint changes to
	// preview violations for. Any existing CustomConstraints with the same name
	// will be overridden in the simulation. That is, violations will be determined
	// as if all custom constraints in the overlay were instantiated. Only a single
	// custom_constraint is supported in the overlay at a time. For evaluating
	// multiple constraints, multiple `GenerateOrgPolicyViolationsPreview` requests
	// are made, where each request evaluates a single constraint.
	CustomConstraints []*GoogleCloudPolicysimulatorV1OrgPolicyOverlayCustomConstraintOverlay `json:"customConstraints,omitempty"`
	// Policies: Optional. The OrgPolicy changes to preview violations for. Any
	// existing OrgPolicies with the same name will be overridden in the
	// simulation. That is, violations will be determined as if all policies in the
	// overlay were created or updated.
	Policies []*GoogleCloudPolicysimulatorV1OrgPolicyOverlayPolicyOverlay `json:"policies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomConstraints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomConstraints") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1OrgPolicyOverlay) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1OrgPolicyOverlay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1OrgPolicyOverlayCustomConstraintOverlay: A
// change to an OrgPolicy custom constraint.
type GoogleCloudPolicysimulatorV1OrgPolicyOverlayCustomConstraintOverlay struct {
	// CustomConstraint: Optional. The new or updated custom constraint.
	CustomConstraint *GoogleCloudOrgpolicyV2CustomConstraint `json:"customConstraint,omitempty"`
	// CustomConstraintParent: Optional. Resource the constraint is attached to.
	// Example: "organization/987654"
	CustomConstraintParent string `json:"customConstraintParent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomConstraint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomConstraint") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1OrgPolicyOverlayCustomConstraintOverlay) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1OrgPolicyOverlayCustomConstraintOverlay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1OrgPolicyOverlayPolicyOverlay: A change to an
// OrgPolicy.
type GoogleCloudPolicysimulatorV1OrgPolicyOverlayPolicyOverlay struct {
	// Policy: Optional. The new or updated OrgPolicy.
	Policy *GoogleCloudOrgpolicyV2Policy `json:"policy,omitempty"`
	// PolicyParent: Optional. The parent of the policy we are attaching to.
	// Example: "projects/123456"
	PolicyParent string `json:"policyParent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1OrgPolicyOverlayPolicyOverlay) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1OrgPolicyOverlayPolicyOverlay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1OrgPolicyViolation: OrgPolicyViolation is a
// resource representing a single resource violating a single OrgPolicy
// constraint.
type GoogleCloudPolicysimulatorV1OrgPolicyViolation struct {
	// CustomConstraint: The custom constraint being violated.
	CustomConstraint *GoogleCloudOrgpolicyV2CustomConstraint `json:"customConstraint,omitempty"`
	// Error: Any error encountered during the evaluation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Name: The name of the `OrgPolicyViolation`. Example:
	// organizations/my-example-org/locations/global/orgPolicyViolationsPreviews/506
	// a5f7f/orgPolicyViolations/38ce`
	Name string `json:"name,omitempty"`
	// Resource: The resource violating the constraint.
	Resource *GoogleCloudPolicysimulatorV1ResourceContext `json:"resource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomConstraint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomConstraint") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1OrgPolicyViolation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1OrgPolicyViolation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreview:
// OrgPolicyViolationsPreview is a resource providing a preview of the
// violations that will exist if an OrgPolicy change is made. The list of
// violations are modeled as child resources and retrieved via a
// ListOrgPolicyViolations API call. There are potentially more
// OrgPolicyViolations than could fit in an embedded field. Thus, the use of a
// child resource instead of a field.
type GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreview struct {
	// CreateTime: Output only. Time when this `OrgPolicyViolationsPreview` was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// CustomConstraints: Output only. The names of the constraints against which
	// all `OrgPolicyViolations` were evaluated. If `OrgPolicyOverlay` only
	// contains `PolicyOverlay` then it contains the name of the configured custom
	// constraint, applicable to the specified policies. Otherwise it contains the
	// name of the constraint specified in `CustomConstraintOverlay`. Format:
	// `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
	// Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
	CustomConstraints []string `json:"customConstraints,omitempty"`
	// Name: Output only. The resource name of the `OrgPolicyViolationsPreview`. It
	// has the following format:
	// `organizations/{organization}/locations/{location}/orgPolicyViolationsPreview
	// s/{orgPolicyViolationsPreview}` Example:
	// `organizations/my-example-org/locations/global/orgPolicyViolationsPreviews/50
	// 6a5f7f`
	Name string `json:"name,omitempty"`
	// Overlay: Required. The proposed changes we are previewing violations for.
	Overlay *GoogleCloudPolicysimulatorV1OrgPolicyOverlay `json:"overlay,omitempty"`
	// ResourceCounts: Output only. A summary of the state of all resources scanned
	// for compliance with the changed OrgPolicy.
	ResourceCounts *GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreviewResourceCounts `json:"resourceCounts,omitempty"`
	// State: Output only. The state of the `OrgPolicyViolationsPreview`.
	//
	// Possible values:
	//   "PREVIEW_STATE_UNSPECIFIED" - The state is unspecified.
	//   "PREVIEW_PENDING" - The OrgPolicyViolationsPreview has not been created
	// yet.
	//   "PREVIEW_RUNNING" - The OrgPolicyViolationsPreview is currently being
	// created.
	//   "PREVIEW_SUCCEEDED" - The OrgPolicyViolationsPreview creation finished
	// successfully.
	//   "PREVIEW_FAILED" - The OrgPolicyViolationsPreview creation failed with an
	// error.
	State string `json:"state,omitempty"`
	// ViolationsCount: Output only. The number of OrgPolicyViolations in this
	// `OrgPolicyViolationsPreview`. This count may differ from
	// `resource_summary.noncompliant_count` because each OrgPolicyViolation is
	// specific to a resource **and** constraint. If there are multiple constraints
	// being evaluated (i.e. multiple policies in the overlay), a single resource
	// may violate multiple constraints.
	ViolationsCount int64 `json:"violationsCount,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreview) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreview
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreviewResourceCounts: A
// summary of the state of all resources scanned for compliance with the
// changed OrgPolicy.
type GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreviewResourceCounts struct {
	// Compliant: Output only. Number of scanned resources with zero violations.
	Compliant int64 `json:"compliant,omitempty"`
	// Errors: Output only. Number of resources that returned an error when
	// scanned.
	Errors int64 `json:"errors,omitempty"`
	// Noncompliant: Output only. Number of scanned resources with at least one
	// violation.
	Noncompliant int64 `json:"noncompliant,omitempty"`
	// Scanned: Output only. Number of resources checked for compliance. Must
	// equal: unenforced + noncompliant + compliant + error
	Scanned int64 `json:"scanned,omitempty"`
	// Unenforced: Output only. Number of resources where the constraint was not
	// enforced, i.e. the Policy set `enforced: false` for that resource.
	Unenforced int64 `json:"unenforced,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Compliant") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Compliant") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreviewResourceCounts) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreviewResourceCounts
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1Replay: A resource describing a `Replay`, or
// simulation.
type GoogleCloudPolicysimulatorV1Replay struct {
	// Config: Required. The configuration used for the `Replay`.
	Config *GoogleCloudPolicysimulatorV1ReplayConfig `json:"config,omitempty"`
	// Name: Output only. The resource name of the `Replay`, which has the
	// following format:
	// `{projects|folders|organizations}/{resource-id}/locations/global/replays/{rep
	// lay-id}`, where `{resource-id}` is the ID of the project, folder, or
	// organization that owns the Replay. Example:
	// `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03
	// -479ce1833c36`
	Name string `json:"name,omitempty"`
	// ResultsSummary: Output only. Summary statistics about the replayed log
	// entries.
	ResultsSummary *GoogleCloudPolicysimulatorV1ReplayResultsSummary `json:"resultsSummary,omitempty"`
	// State: Output only. The current state of the `Replay`.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default value. This value is unused.
	//   "PENDING" - The `Replay` has not started yet.
	//   "RUNNING" - The `Replay` is currently running.
	//   "SUCCEEDED" - The `Replay` has successfully completed.
	//   "FAILED" - The `Replay` has finished with an error.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1Replay) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1Replay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1ReplayConfig: The configuration used for a
// Replay.
type GoogleCloudPolicysimulatorV1ReplayConfig struct {
	// LogSource: The logs to use as input for the Replay.
	//
	// Possible values:
	//   "LOG_SOURCE_UNSPECIFIED" - An unspecified log source. If the log source is
	// unspecified, the Replay defaults to using `RECENT_ACCESSES`.
	//   "RECENT_ACCESSES" - All access logs from the last 90 days. These logs may
	// not include logs from the most recent 7 days.
	LogSource string `json:"logSource,omitempty"`
	// PolicyOverlay: A mapping of the resources that you want to simulate policies
	// for and the policies that you want to simulate. Keys are the full resource
	// names for the resources. For example,
	// `//cloudresourcemanager.googleapis.com/projects/my-project`. For examples of
	// full resource names for Google Cloud services, see
	// https://cloud.google.com/iam/help/troubleshooter/full-resource-names. Values
	// are Policy objects representing the policies that you want to simulate.
	// Replays automatically take into account any IAM policies inherited through
	// the resource hierarchy, and any policies set on descendant resources. You do
	// not need to include these policies in the policy overlay.
	PolicyOverlay map[string]GoogleIamV1Policy `json:"policyOverlay,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LogSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LogSource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1ReplayConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1ReplayConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1ReplayDiff: The difference between the results
// of evaluating an access tuple under the current (baseline) policies and
// under the proposed (simulated) policies. This difference explains how a
// principal's access could change if the proposed policies were applied.
type GoogleCloudPolicysimulatorV1ReplayDiff struct {
	// AccessDiff: A summary and comparison of the principal's access under the
	// current (baseline) policies and the proposed (simulated) policies for a
	// single access tuple. The evaluation of the principal's access is reported in
	// the AccessState field.
	AccessDiff *GoogleCloudPolicysimulatorV1AccessStateDiff `json:"accessDiff,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessDiff") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessDiff") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1ReplayDiff) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1ReplayDiff
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1ReplayOperationMetadata: Metadata about a Replay
// operation.
type GoogleCloudPolicysimulatorV1ReplayOperationMetadata struct {
	// StartTime: Time when the request was received.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StartTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StartTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1ReplayOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1ReplayOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1ReplayResult: The result of replaying a single
// access tuple against a simulated state.
type GoogleCloudPolicysimulatorV1ReplayResult struct {
	// AccessTuple: The access tuple that was replayed. This field includes
	// information about the principal, resource, and permission that were involved
	// in the access attempt.
	AccessTuple *GoogleCloudPolicysimulatorV1AccessTuple `json:"accessTuple,omitempty"`
	// Diff: The difference between the principal's access under the current
	// (baseline) policies and the principal's access under the proposed
	// (simulated) policies. This field is only included for access tuples that
	// were successfully replayed and had different results under the current
	// policies and the proposed policies.
	Diff *GoogleCloudPolicysimulatorV1ReplayDiff `json:"diff,omitempty"`
	// Error: The error that caused the access tuple replay to fail. This field is
	// only included for access tuples that were not replayed successfully.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// LastSeenDate: The latest date this access tuple was seen in the logs.
	LastSeenDate *GoogleTypeDate `json:"lastSeenDate,omitempty"`
	// Name: The resource name of the `ReplayResult`, in the following format:
	// `{projects|folders|organizations}/{resource-id}/locations/global/replays/{rep
	// lay-id}/results/{replay-result-id}`, where `{resource-id}` is the ID of the
	// project, folder, or organization that owns the Replay. Example:
	// `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03
	// -479ce1833c36/results/1234`
	Name string `json:"name,omitempty"`
	// Parent: The Replay that the access tuple was included in.
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessTuple") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessTuple") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1ReplayResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1ReplayResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1ReplayResultsSummary: Summary statistics about
// the replayed log entries.
type GoogleCloudPolicysimulatorV1ReplayResultsSummary struct {
	// DifferenceCount: The number of replayed log entries with a difference
	// between baseline and simulated policies.
	DifferenceCount int64 `json:"differenceCount,omitempty"`
	// ErrorCount: The number of log entries that could not be replayed.
	ErrorCount int64 `json:"errorCount,omitempty"`
	// LogCount: The total number of log entries replayed.
	LogCount int64 `json:"logCount,omitempty"`
	// NewestDate: The date of the newest log entry replayed.
	NewestDate *GoogleTypeDate `json:"newestDate,omitempty"`
	// OldestDate: The date of the oldest log entry replayed.
	OldestDate *GoogleTypeDate `json:"oldestDate,omitempty"`
	// UnchangedCount: The number of replayed log entries with no difference
	// between baseline and simulated policies.
	UnchangedCount int64 `json:"unchangedCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DifferenceCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DifferenceCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1ReplayResultsSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1ReplayResultsSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1ResourceContext: ResourceContext provides the
// context we know about a resource. It is similar in concept to
// google.cloud.asset.v1.Resource, but focuses on the information specifically
// used by Simulator.
type GoogleCloudPolicysimulatorV1ResourceContext struct {
	// Ancestors: The ancestry path of the resource in Google Cloud resource
	// hierarchy
	// (https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
	// represented as a list of relative resource names. An ancestry path starts
	// with the closest ancestor in the hierarchy and ends at root. If the resource
	// is a project, folder, or organization, the ancestry path starts from the
	// resource itself. Example: `["projects/123456789", "folders/5432",
	// "organizations/1234"]`
	Ancestors []string `json:"ancestors,omitempty"`
	// AssetType: The asset type of the resource as defined by CAIS. Example:
	// `compute.googleapis.com/Firewall` See Supported asset types
	// (https://cloud.google.com/asset-inventory/docs/supported-asset-types) for
	// more information.
	AssetType string `json:"assetType,omitempty"`
	// Resource: The full name of the resource. Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/insta
	// nce1` See Resource names
	// (https://cloud.google.com/apis/design/resource_names#full_resource_name) for
	// more information.
	Resource string `json:"resource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Ancestors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Ancestors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1ResourceContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1ResourceContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1betaCreateOrgPolicyViolationsPreviewOperationMeta
// data: CreateOrgPolicyViolationsPreviewOperationMetadata is metadata about an
// OrgPolicyViolationsPreview generations operation.
type GoogleCloudPolicysimulatorV1betaCreateOrgPolicyViolationsPreviewOperationMetadata struct {
	// RequestTime: Time when the request was received.
	RequestTime string `json:"requestTime,omitempty"`
	// ResourcesFound: Total number of resources that need scanning. Should equal
	// resource_scanned + resources_pending
	ResourcesFound int64 `json:"resourcesFound,omitempty"`
	// ResourcesPending: Number of resources still to scan.
	ResourcesPending int64 `json:"resourcesPending,omitempty"`
	// ResourcesScanned: Number of resources already scanned.
	ResourcesScanned int64 `json:"resourcesScanned,omitempty"`
	// StartTime: Time when the request started processing, i.e., when the state
	// was set to RUNNING.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. The current state of the operation.
	//
	// Possible values:
	//   "PREVIEW_STATE_UNSPECIFIED" - The state is unspecified.
	//   "PREVIEW_PENDING" - The OrgPolicyViolationsPreview has not been created
	// yet.
	//   "PREVIEW_RUNNING" - The OrgPolicyViolationsPreview is currently being
	// created.
	//   "PREVIEW_SUCCEEDED" - The OrgPolicyViolationsPreview creation finished
	// successfully.
	//   "PREVIEW_FAILED" - The OrgPolicyViolationsPreview creation failed with an
	// error.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1betaCreateOrgPolicyViolationsPreviewOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1betaCreateOrgPolicyViolationsPreviewOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1betaGenerateOrgPolicyViolationsPreviewOperationMe
// tadata: GenerateOrgPolicyViolationsPreviewOperationMetadata is metadata
// about an OrgPolicyViolationsPreview generations operation.
type GoogleCloudPolicysimulatorV1betaGenerateOrgPolicyViolationsPreviewOperationMetadata struct {
	// RequestTime: Time when the request was received.
	RequestTime string `json:"requestTime,omitempty"`
	// ResourcesFound: Total number of resources that need scanning. Should equal
	// resource_scanned + resources_pending
	ResourcesFound int64 `json:"resourcesFound,omitempty"`
	// ResourcesPending: Number of resources still to scan.
	ResourcesPending int64 `json:"resourcesPending,omitempty"`
	// ResourcesScanned: Number of resources already scanned.
	ResourcesScanned int64 `json:"resourcesScanned,omitempty"`
	// StartTime: Time when the request started processing, i.e. when the state was
	// set to RUNNING.
	StartTime string `json:"startTime,omitempty"`
	// State: The current state of the operation.
	//
	// Possible values:
	//   "PREVIEW_STATE_UNSPECIFIED" - The state is unspecified.
	//   "PREVIEW_PENDING" - The OrgPolicyViolationsPreview has not been created
	// yet.
	//   "PREVIEW_RUNNING" - The OrgPolicyViolationsPreview is currently being
	// created.
	//   "PREVIEW_SUCCEEDED" - The OrgPolicyViolationsPreview creation finished
	// successfully.
	//   "PREVIEW_FAILED" - The OrgPolicyViolationsPreview creation failed with an
	// error.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1betaGenerateOrgPolicyViolationsPreviewOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1betaGenerateOrgPolicyViolationsPreviewOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1betaOrgPolicyOverlay: The proposed changes to
// OrgPolicy.
type GoogleCloudPolicysimulatorV1betaOrgPolicyOverlay struct {
	// CustomConstraints: Optional. The OrgPolicy CustomConstraint changes to
	// preview violations for. Any existing CustomConstraints with the same name
	// will be overridden in the simulation. That is, violations will be determined
	// as if all custom constraints in the overlay were instantiated. Only a single
	// custom_constraint is supported in the overlay at a time. For evaluating
	// multiple constraints, multiple `GenerateOrgPolicyViolationsPreview` requests
	// are made, where each request evaluates a single constraint.
	CustomConstraints []*GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayCustomConstraintOverlay `json:"customConstraints,omitempty"`
	// Policies: Optional. The OrgPolicy changes to preview violations for. Any
	// existing OrgPolicies with the same name will be overridden in the
	// simulation. That is, violations will be determined as if all policies in the
	// overlay were created or updated.
	Policies []*GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayPolicyOverlay `json:"policies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomConstraints") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomConstraints") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1betaOrgPolicyOverlay) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1betaOrgPolicyOverlay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayCustomConstraintOverlay: A
// change to an OrgPolicy custom constraint.
type GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayCustomConstraintOverlay struct {
	// CustomConstraint: Optional. The new or updated custom constraint.
	CustomConstraint *GoogleCloudOrgpolicyV2CustomConstraint `json:"customConstraint,omitempty"`
	// CustomConstraintParent: Optional. Resource the constraint is attached to.
	// Example: "organization/987654"
	CustomConstraintParent string `json:"customConstraintParent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CustomConstraint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CustomConstraint") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayCustomConstraintOverlay) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayCustomConstraintOverlay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayPolicyOverlay: A change to
// an OrgPolicy.
type GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayPolicyOverlay struct {
	// Policy: Optional. The new or updated OrgPolicy.
	Policy *GoogleCloudOrgpolicyV2Policy `json:"policy,omitempty"`
	// PolicyParent: Optional. The parent of the policy we are attaching to.
	// Example: "projects/123456"
	PolicyParent string `json:"policyParent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayPolicyOverlay) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1betaOrgPolicyOverlayPolicyOverlay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview:
// OrgPolicyViolationsPreview is a resource providing a preview of the
// violations that will exist if an OrgPolicy change is made. The list of
// violations are modeled as child resources and retrieved via a
// ListOrgPolicyViolations API call. There are potentially more
// OrgPolicyViolations than could fit in an embedded field. Thus, the use of a
// child resource instead of a field.
type GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview struct {
	// CreateTime: Output only. Time when this `OrgPolicyViolationsPreview` was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// CustomConstraints: Output only. The names of the constraints against which
	// all `OrgPolicyViolations` were evaluated. If `OrgPolicyOverlay` only
	// contains `PolicyOverlay` then it contains the name of the configured custom
	// constraint, applicable to the specified policies. Otherwise it contains the
	// name of the constraint specified in `CustomConstraintOverlay`. Format:
	// `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
	// Example: `organizations/123/customConstraints/custom.createOnlyE2TypeVms`
	CustomConstraints []string `json:"customConstraints,omitempty"`
	// Name: Output only. The resource name of the `OrgPolicyViolationsPreview`. It
	// has the following format:
	// `organizations/{organization}/locations/{location}/orgPolicyViolationsPreview
	// s/{orgPolicyViolationsPreview}` Example:
	// `organizations/my-example-org/locations/global/orgPolicyViolationsPreviews/50
	// 6a5f7f`
	Name string `json:"name,omitempty"`
	// Overlay: Required. The proposed changes we are previewing violations for.
	Overlay *GoogleCloudPolicysimulatorV1betaOrgPolicyOverlay `json:"overlay,omitempty"`
	// ResourceCounts: Output only. A summary of the state of all resources scanned
	// for compliance with the changed OrgPolicy.
	ResourceCounts *GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreviewResourceCounts `json:"resourceCounts,omitempty"`
	// State: Output only. The state of the `OrgPolicyViolationsPreview`.
	//
	// Possible values:
	//   "PREVIEW_STATE_UNSPECIFIED" - The state is unspecified.
	//   "PREVIEW_PENDING" - The OrgPolicyViolationsPreview has not been created
	// yet.
	//   "PREVIEW_RUNNING" - The OrgPolicyViolationsPreview is currently being
	// created.
	//   "PREVIEW_SUCCEEDED" - The OrgPolicyViolationsPreview creation finished
	// successfully.
	//   "PREVIEW_FAILED" - The OrgPolicyViolationsPreview creation failed with an
	// error.
	State string `json:"state,omitempty"`
	// ViolationsCount: Output only. The number of OrgPolicyViolations in this
	// `OrgPolicyViolationsPreview`. This count may differ from
	// `resource_summary.noncompliant_count` because each OrgPolicyViolation is
	// specific to a resource **and** constraint. If there are multiple constraints
	// being evaluated (i.e. multiple policies in the overlay), a single resource
	// may violate multiple constraints.
	ViolationsCount int64 `json:"violationsCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreview
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreviewResourceCounts: A
// summary of the state of all resources scanned for compliance with the
// changed OrgPolicy.
type GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreviewResourceCounts struct {
	// Compliant: Output only. Number of scanned resources with zero violations.
	Compliant int64 `json:"compliant,omitempty"`
	// Errors: Output only. Number of resources that returned an error when
	// scanned.
	Errors int64 `json:"errors,omitempty"`
	// Noncompliant: Output only. Number of scanned resources with at least one
	// violation.
	Noncompliant int64 `json:"noncompliant,omitempty"`
	// Scanned: Output only. Number of resources checked for compliance. Must
	// equal: unenforced + noncompliant + compliant + error
	Scanned int64 `json:"scanned,omitempty"`
	// Unenforced: Output only. Number of resources where the constraint was not
	// enforced, i.e. the Policy set `enforced: false` for that resource.
	Unenforced int64 `json:"unenforced,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Compliant") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Compliant") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreviewResourceCounts) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudPolicysimulatorV1betaOrgPolicyViolationsPreviewResourceCounts
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type GoogleIamV1AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*GoogleIamV1AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type GoogleIamV1AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Binding: Associates `members`, or principals, with a `role`.
type GoogleIamV1Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *GoogleTypeExpr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Policy: An Identity and Access Management (IAM) policy, which
// specifies access controls for Google Cloud resources. A `Policy` is a
// collection of `bindings`. A `binding` binds one or more `members`, or
// principals, to a single `role`. Principals can be user accounts, service
// accounts, Google groups, and domains (such as G Suite). A `role` is a named
// list of permissions; each `role` can be an IAM predefined role or a
// user-created custom role. For some types of Google Cloud resources, a
// `binding` can also specify a `condition`, which is a logical expression that
// allows access to a resource only if the expression evaluates to `true`. A
// condition can add constraints based on attributes of the request, the
// resource, or both. To learn which resources support conditions in their IAM
// policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type GoogleIamV1Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*GoogleIamV1AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*GoogleIamV1Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets `ListOperationsRequest.return_partial_success` and reads across
	// collections. For example, when attempting to list all resources across all
	// supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified elsewhere or
// are insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeExpr: Represents a textual expression in the Common Expression
// Language (CEL) syntax. CEL is a C-like expression language. The syntax and
// semantics of CEL are documented at https://github.com/google/cel-spec.
// Example (Comparison): title: "Summary size limit" description: "Determines
// if a summary is less than 100 chars" expression: "document.summary.size() <
// 100" Example (Equality): title: "Requestor is owner" description:
// "Determines if requestor is the document owner" expression: "document.owner
// == request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type GoogleTypeExpr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeExpr) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeExpr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type FoldersLocationsAccessPolicySimulationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *FoldersLocationsAccessPolicySimulationsOperationsService) Get(name string) *FoldersLocationsAccessPolicySimulationsOperationsGetCall {
	c := &FoldersLocationsAccessPolicySimulationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsAccessPolicySimulationsOperationsGetCall) Fields(s ...googleapi.Field) *FoldersLocationsAccessPolicySimulationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsAccessPolicySimulationsOperationsGetCall) IfNoneMatch(entityTag string) *FoldersLocationsAccessPolicySimulationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsAccessPolicySimulationsOperationsGetCall) Context(ctx context.Context) *FoldersLocationsAccessPolicySimulationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsAccessPolicySimulationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsAccessPolicySimulationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.accessPolicySimulations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.folders.locations.accessPolicySimulations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersLocationsAccessPolicySimulationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.accessPolicySimulations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsOrgPolicyViolationsPreviewsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *FoldersLocationsOrgPolicyViolationsPreviewsOperationsService) Get(name string) *FoldersLocationsOrgPolicyViolationsPreviewsOperationsGetCall {
	c := &FoldersLocationsOrgPolicyViolationsPreviewsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsOrgPolicyViolationsPreviewsOperationsGetCall) Fields(s ...googleapi.Field) *FoldersLocationsOrgPolicyViolationsPreviewsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsOrgPolicyViolationsPreviewsOperationsGetCall) IfNoneMatch(entityTag string) *FoldersLocationsOrgPolicyViolationsPreviewsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsOrgPolicyViolationsPreviewsOperationsGetCall) Context(ctx context.Context) *FoldersLocationsOrgPolicyViolationsPreviewsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsOrgPolicyViolationsPreviewsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsOrgPolicyViolationsPreviewsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.orgPolicyViolationsPreviews.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.folders.locations.orgPolicyViolationsPreviews.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersLocationsOrgPolicyViolationsPreviewsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.orgPolicyViolationsPreviews.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsReplaysCreateCall struct {
	s                                  *Service
	parent                             string
	googlecloudpolicysimulatorv1replay *GoogleCloudPolicysimulatorV1Replay
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Create: Creates and starts a Replay using the given ReplayConfig.
//
//   - parent: The parent resource where this Replay will be created. This
//     resource must be a project, folder, or organization with a location.
//     Example: `projects/my-example-project/locations/global`.
func (r *FoldersLocationsReplaysService) Create(parent string, googlecloudpolicysimulatorv1replay *GoogleCloudPolicysimulatorV1Replay) *FoldersLocationsReplaysCreateCall {
	c := &FoldersLocationsReplaysCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudpolicysimulatorv1replay = googlecloudpolicysimulatorv1replay
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsReplaysCreateCall) Fields(s ...googleapi.Field) *FoldersLocationsReplaysCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsReplaysCreateCall) Context(ctx context.Context) *FoldersLocationsReplaysCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsReplaysCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsReplaysCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudpolicysimulatorv1replay)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/replays")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.replays.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.folders.locations.replays.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersLocationsReplaysCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.replays.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsReplaysGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified Replay. Each `Replay` is available for at least 7
// days.
//
//   - name: The name of the Replay to retrieve, in the following format:
//     `{projects|folders|organizations}/{resource-id}/locations/global/replays/{r
//     eplay-id}`, where `{resource-id}` is the ID of the project, folder, or
//     organization that owns the `Replay`. Example:
//     `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e
//     03-479ce1833c36`.
func (r *FoldersLocationsReplaysService) Get(name string) *FoldersLocationsReplaysGetCall {
	c := &FoldersLocationsReplaysGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsReplaysGetCall) Fields(s ...googleapi.Field) *FoldersLocationsReplaysGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsReplaysGetCall) IfNoneMatch(entityTag string) *FoldersLocationsReplaysGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsReplaysGetCall) Context(ctx context.Context) *FoldersLocationsReplaysGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsReplaysGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsReplaysGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.replays.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.folders.locations.replays.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudPolicysimulatorV1Replay.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersLocationsReplaysGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicysimulatorV1Replay, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicysimulatorV1Replay{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.replays.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsReplaysOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *FoldersLocationsReplaysOperationsService) Get(name string) *FoldersLocationsReplaysOperationsGetCall {
	c := &FoldersLocationsReplaysOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsReplaysOperationsGetCall) Fields(s ...googleapi.Field) *FoldersLocationsReplaysOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsReplaysOperationsGetCall) IfNoneMatch(entityTag string) *FoldersLocationsReplaysOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsReplaysOperationsGetCall) Context(ctx context.Context) *FoldersLocationsReplaysOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsReplaysOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsReplaysOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.replays.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.folders.locations.replays.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersLocationsReplaysOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.replays.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsReplaysOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *FoldersLocationsReplaysOperationsService) List(name string) *FoldersLocationsReplaysOperationsListCall {
	c := &FoldersLocationsReplaysOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *FoldersLocationsReplaysOperationsListCall) Filter(filter string) *FoldersLocationsReplaysOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *FoldersLocationsReplaysOperationsListCall) PageSize(pageSize int64) *FoldersLocationsReplaysOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *FoldersLocationsReplaysOperationsListCall) PageToken(pageToken string) *FoldersLocationsReplaysOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// ListOperationsResponse.unreachable field. This can only be `true` when
// reading across collections. For example, when `parent` is set to
// "projects/example/locations/-". This field is not supported by default and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *FoldersLocationsReplaysOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *FoldersLocationsReplaysOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsReplaysOperationsListCall) Fields(s ...googleapi.Field) *FoldersLocationsReplaysOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsReplaysOperationsListCall) IfNoneMatch(entityTag string) *FoldersLocationsReplaysOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsReplaysOperationsListCall) Context(ctx context.Context) *FoldersLocationsReplaysOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsReplaysOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsReplaysOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.replays.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.folders.locations.replays.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersLocationsReplaysOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.replays.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsReplaysOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersLocationsReplaysResultsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the results of running a Replay.
//
//   - parent: The Replay whose results are listed, in the following format:
//     `{projects|folders|organizations}/{resource-id}/locations/global/replays/{r
//     eplay-id}` Example:
//     `projects/my-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce
//     1833c36`.
func (r *FoldersLocationsReplaysResultsService) List(parent string) *FoldersLocationsReplaysResultsListCall {
	c := &FoldersLocationsReplaysResultsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// ReplayResult objects to return. Defaults to 5000. The maximum value is 5000;
// values above 5000 are rounded down to 5000.
func (c *FoldersLocationsReplaysResultsListCall) PageSize(pageSize int64) *FoldersLocationsReplaysResultsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous Simulator.ListReplayResults call. Provide this token to
// retrieve the next page of results. When paginating, all other parameters
// provided to [Simulator.ListReplayResults[] must match the call that provided
// the page token.
func (c *FoldersLocationsReplaysResultsListCall) PageToken(pageToken string) *FoldersLocationsReplaysResultsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsReplaysResultsListCall) Fields(s ...googleapi.Field) *FoldersLocationsReplaysResultsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsReplaysResultsListCall) IfNoneMatch(entityTag string) *FoldersLocationsReplaysResultsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsReplaysResultsListCall) Context(ctx context.Context) *FoldersLocationsReplaysResultsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsReplaysResultsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsReplaysResultsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/results")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.replays.results.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.folders.locations.replays.results.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudPolicysimulatorV1ListReplayResultsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersLocationsReplaysResultsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicysimulatorV1ListReplayResultsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicysimulatorV1ListReplayResultsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.folders.locations.replays.results.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsReplaysResultsListCall) Pages(ctx context.Context, f func(*GoogleCloudPolicysimulatorV1ListReplayResultsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *OperationsService) Get(name string) *OperationsGetCall {
	c := &OperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OperationsGetCall) Fields(s ...googleapi.Field) *OperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OperationsGetCall) IfNoneMatch(entityTag string) *OperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OperationsGetCall) Context(ctx context.Context) *OperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *OperationsService) List(name string) *OperationsListCall {
	c := &OperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *OperationsListCall) Filter(filter string) *OperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *OperationsListCall) PageSize(pageSize int64) *OperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *OperationsListCall) PageToken(pageToken string) *OperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// ListOperationsResponse.unreachable field. This can only be `true` when
// reading across collections. For example, when `parent` is set to
// "projects/example/locations/-". This field is not supported by default and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *OperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *OperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OperationsListCall) Fields(s ...googleapi.Field) *OperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OperationsListCall) IfNoneMatch(entityTag string) *OperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OperationsListCall) Context(ctx context.Context) *OperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsAccessPolicySimulationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *OrganizationsLocationsAccessPolicySimulationsOperationsService) Get(name string) *OrganizationsLocationsAccessPolicySimulationsOperationsGetCall {
	c := &OrganizationsLocationsAccessPolicySimulationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsAccessPolicySimulationsOperationsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsAccessPolicySimulationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsAccessPolicySimulationsOperationsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsAccessPolicySimulationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsAccessPolicySimulationsOperationsGetCall) Context(ctx context.Context) *OrganizationsLocationsAccessPolicySimulationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsAccessPolicySimulationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsAccessPolicySimulationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.accessPolicySimulations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.organizations.locations.accessPolicySimulations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsAccessPolicySimulationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.accessPolicySimulations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsOrgPolicyViolationsPreviewsCreateCall struct {
	s                                                      *Service
	parent                                                 string
	googlecloudpolicysimulatorv1orgpolicyviolationspreview *GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreview
	urlParams_                                             gensupport.URLParams
	ctx_                                                   context.Context
	header_                                                http.Header
}

// Create: CreateOrgPolicyViolationsPreview creates an
// OrgPolicyViolationsPreview for the proposed changes in the provided
// OrgPolicyViolationsPreview.OrgPolicyOverlay. The changes to OrgPolicy are
// specified by this `OrgPolicyOverlay`. The resources to scan are inferred
// from these specified changes.
//
//   - parent: The organization under which this OrgPolicyViolationsPreview will
//     be created. Example: `organizations/my-example-org/locations/global`.
func (r *OrganizationsLocationsOrgPolicyViolationsPreviewsService) Create(parent string, googlecloudpolicysimulatorv1orgpolicyviolationspreview *GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreview) *OrganizationsLocationsOrgPolicyViolationsPreviewsCreateCall {
	c := &OrganizationsLocationsOrgPolicyViolationsPreviewsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudpolicysimulatorv1orgpolicyviolationspreview = googlecloudpolicysimulatorv1orgpolicyviolationspreview
	return c
}

// OrgPolicyViolationsPreviewId sets the optional parameter
// "orgPolicyViolationsPreviewId": An optional user-specified ID for the
// OrgPolicyViolationsPreview. If not provided, a random ID will be generated.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsCreateCall) OrgPolicyViolationsPreviewId(orgPolicyViolationsPreviewId string) *OrganizationsLocationsOrgPolicyViolationsPreviewsCreateCall {
	c.urlParams_.Set("orgPolicyViolationsPreviewId", orgPolicyViolationsPreviewId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOrgPolicyViolationsPreviewsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsCreateCall) Context(ctx context.Context) *OrganizationsLocationsOrgPolicyViolationsPreviewsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudpolicysimulatorv1orgpolicyviolationspreview)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/orgPolicyViolationsPreviews")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.orgPolicyViolationsPreviews.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.organizations.locations.orgPolicyViolationsPreviews.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.orgPolicyViolationsPreviews.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsOrgPolicyViolationsPreviewsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: GetOrgPolicyViolationsPreview gets the specified
// OrgPolicyViolationsPreview. Each OrgPolicyViolationsPreview is available for
// at least 7 days.
//
// - name: The name of the OrgPolicyViolationsPreview to get.
func (r *OrganizationsLocationsOrgPolicyViolationsPreviewsService) Get(name string) *OrganizationsLocationsOrgPolicyViolationsPreviewsGetCall {
	c := &OrganizationsLocationsOrgPolicyViolationsPreviewsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOrgPolicyViolationsPreviewsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsOrgPolicyViolationsPreviewsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsGetCall) Context(ctx context.Context) *OrganizationsLocationsOrgPolicyViolationsPreviewsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.orgPolicyViolationsPreviews.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.organizations.locations.orgPolicyViolationsPreviews.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreview.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreview, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicysimulatorV1OrgPolicyViolationsPreview{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.orgPolicyViolationsPreviews.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsOrgPolicyViolationsPreviewsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: ListOrgPolicyViolationsPreviews lists each OrgPolicyViolationsPreview
// in an organization. Each OrgPolicyViolationsPreview is available for at
// least 7 days.
//
//   - parent: The parent the violations are scoped to. Format:
//     `organizations/{organization}/locations/{location}` Example:
//     `organizations/my-example-org/locations/global`.
func (r *OrganizationsLocationsOrgPolicyViolationsPreviewsService) List(parent string) *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall {
	c := &OrganizationsLocationsOrgPolicyViolationsPreviewsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. The service may return fewer than this value. If unspecified, at
// most 5 items will be returned. The maximum value is 10; values above 10 will
// be coerced to 10.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall) PageSize(pageSize int64) *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous call. Provide this to retrieve the subsequent page. When
// paginating, all other parameters must match the call that provided the page
// token.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall) PageToken(pageToken string) *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall) Context(ctx context.Context) *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/orgPolicyViolationsPreviews")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.orgPolicyViolationsPreviews.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.organizations.locations.orgPolicyViolationsPreviews.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsPreviewsResponse.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsPreviewsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsPreviewsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.orgPolicyViolationsPreviews.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsListCall) Pages(ctx context.Context, f func(*GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsPreviewsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsService) Get(name string) *OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsGetCall {
	c := &OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsGetCall) Context(ctx context.Context) *OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.orgPolicyViolationsPreviews.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.organizations.locations.orgPolicyViolationsPreviews.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.orgPolicyViolationsPreviews.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: ListOrgPolicyViolations lists the OrgPolicyViolations that are present
// in an OrgPolicyViolationsPreview.
//
//   - parent: The OrgPolicyViolationsPreview to get OrgPolicyViolations from.
//     Format:
//     organizations/{organization}/locations/{location}/orgPolicyViolationsPrevie
//     ws/{orgPolicyViolationsPreview}.
func (r *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsService) List(parent string) *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall {
	c := &OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of items
// to return. The service may return fewer than this value. If unspecified, at
// most 1000 items will be returned. The maximum value is 1000; values above
// 1000 will be coerced to 1000.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall) PageSize(pageSize int64) *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous call. Provide this to retrieve the subsequent page. When
// paginating, all other parameters must match the call that provided the page
// token.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall) PageToken(pageToken string) *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall) Context(ctx context.Context) *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/orgPolicyViolations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.orgPolicyViolationsPreviews.orgPolicyViolations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.organizations.locations.orgPolicyViolationsPreviews.orgPolicyViolations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.orgPolicyViolationsPreviews.orgPolicyViolations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsOrgPolicyViolationsPreviewsOrgPolicyViolationsListCall) Pages(ctx context.Context, f func(*GoogleCloudPolicysimulatorV1ListOrgPolicyViolationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsReplaysCreateCall struct {
	s                                  *Service
	parent                             string
	googlecloudpolicysimulatorv1replay *GoogleCloudPolicysimulatorV1Replay
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Create: Creates and starts a Replay using the given ReplayConfig.
//
//   - parent: The parent resource where this Replay will be created. This
//     resource must be a project, folder, or organization with a location.
//     Example: `projects/my-example-project/locations/global`.
func (r *OrganizationsLocationsReplaysService) Create(parent string, googlecloudpolicysimulatorv1replay *GoogleCloudPolicysimulatorV1Replay) *OrganizationsLocationsReplaysCreateCall {
	c := &OrganizationsLocationsReplaysCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudpolicysimulatorv1replay = googlecloudpolicysimulatorv1replay
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsReplaysCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsReplaysCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsReplaysCreateCall) Context(ctx context.Context) *OrganizationsLocationsReplaysCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsReplaysCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsReplaysCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudpolicysimulatorv1replay)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/replays")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.replays.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.organizations.locations.replays.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsReplaysCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.replays.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsReplaysGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified Replay. Each `Replay` is available for at least 7
// days.
//
//   - name: The name of the Replay to retrieve, in the following format:
//     `{projects|folders|organizations}/{resource-id}/locations/global/replays/{r
//     eplay-id}`, where `{resource-id}` is the ID of the project, folder, or
//     organization that owns the `Replay`. Example:
//     `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e
//     03-479ce1833c36`.
func (r *OrganizationsLocationsReplaysService) Get(name string) *OrganizationsLocationsReplaysGetCall {
	c := &OrganizationsLocationsReplaysGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsReplaysGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsReplaysGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsReplaysGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsReplaysGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsReplaysGetCall) Context(ctx context.Context) *OrganizationsLocationsReplaysGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsReplaysGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsReplaysGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.replays.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.organizations.locations.replays.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudPolicysimulatorV1Replay.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsReplaysGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicysimulatorV1Replay, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicysimulatorV1Replay{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.replays.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsReplaysOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *OrganizationsLocationsReplaysOperationsService) Get(name string) *OrganizationsLocationsReplaysOperationsGetCall {
	c := &OrganizationsLocationsReplaysOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsReplaysOperationsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsReplaysOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsReplaysOperationsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsReplaysOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsReplaysOperationsGetCall) Context(ctx context.Context) *OrganizationsLocationsReplaysOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsReplaysOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsReplaysOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.replays.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.organizations.locations.replays.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsReplaysOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.replays.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsReplaysOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *OrganizationsLocationsReplaysOperationsService) List(name string) *OrganizationsLocationsReplaysOperationsListCall {
	c := &OrganizationsLocationsReplaysOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *OrganizationsLocationsReplaysOperationsListCall) Filter(filter string) *OrganizationsLocationsReplaysOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *OrganizationsLocationsReplaysOperationsListCall) PageSize(pageSize int64) *OrganizationsLocationsReplaysOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *OrganizationsLocationsReplaysOperationsListCall) PageToken(pageToken string) *OrganizationsLocationsReplaysOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// ListOperationsResponse.unreachable field. This can only be `true` when
// reading across collections. For example, when `parent` is set to
// "projects/example/locations/-". This field is not supported by default and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *OrganizationsLocationsReplaysOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *OrganizationsLocationsReplaysOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsReplaysOperationsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsReplaysOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsReplaysOperationsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsReplaysOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsReplaysOperationsListCall) Context(ctx context.Context) *OrganizationsLocationsReplaysOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsReplaysOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsReplaysOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.replays.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.organizations.locations.replays.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsReplaysOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.replays.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsReplaysOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsReplaysResultsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the results of running a Replay.
//
//   - parent: The Replay whose results are listed, in the following format:
//     `{projects|folders|organizations}/{resource-id}/locations/global/replays/{r
//     eplay-id}` Example:
//     `projects/my-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce
//     1833c36`.
func (r *OrganizationsLocationsReplaysResultsService) List(parent string) *OrganizationsLocationsReplaysResultsListCall {
	c := &OrganizationsLocationsReplaysResultsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// ReplayResult objects to return. Defaults to 5000. The maximum value is 5000;
// values above 5000 are rounded down to 5000.
func (c *OrganizationsLocationsReplaysResultsListCall) PageSize(pageSize int64) *OrganizationsLocationsReplaysResultsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous Simulator.ListReplayResults call. Provide this token to
// retrieve the next page of results. When paginating, all other parameters
// provided to [Simulator.ListReplayResults[] must match the call that provided
// the page token.
func (c *OrganizationsLocationsReplaysResultsListCall) PageToken(pageToken string) *OrganizationsLocationsReplaysResultsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsReplaysResultsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsReplaysResultsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsReplaysResultsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsReplaysResultsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsReplaysResultsListCall) Context(ctx context.Context) *OrganizationsLocationsReplaysResultsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsReplaysResultsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsReplaysResultsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/results")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.replays.results.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.organizations.locations.replays.results.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudPolicysimulatorV1ListReplayResultsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OrganizationsLocationsReplaysResultsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicysimulatorV1ListReplayResultsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicysimulatorV1ListReplayResultsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.organizations.locations.replays.results.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsReplaysResultsListCall) Pages(ctx context.Context, f func(*GoogleCloudPolicysimulatorV1ListReplayResultsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAccessPolicySimulationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsAccessPolicySimulationsOperationsService) Get(name string) *ProjectsLocationsAccessPolicySimulationsOperationsGetCall {
	c := &ProjectsLocationsAccessPolicySimulationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAccessPolicySimulationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAccessPolicySimulationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAccessPolicySimulationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAccessPolicySimulationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAccessPolicySimulationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsAccessPolicySimulationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAccessPolicySimulationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAccessPolicySimulationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.accessPolicySimulations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.projects.locations.accessPolicySimulations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAccessPolicySimulationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.accessPolicySimulations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOrgPolicyViolationsPreviewsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOrgPolicyViolationsPreviewsOperationsService) Get(name string) *ProjectsLocationsOrgPolicyViolationsPreviewsOperationsGetCall {
	c := &ProjectsLocationsOrgPolicyViolationsPreviewsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOrgPolicyViolationsPreviewsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOrgPolicyViolationsPreviewsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOrgPolicyViolationsPreviewsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOrgPolicyViolationsPreviewsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOrgPolicyViolationsPreviewsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOrgPolicyViolationsPreviewsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOrgPolicyViolationsPreviewsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOrgPolicyViolationsPreviewsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.orgPolicyViolationsPreviews.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.projects.locations.orgPolicyViolationsPreviews.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOrgPolicyViolationsPreviewsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.orgPolicyViolationsPreviews.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReplaysCreateCall struct {
	s                                  *Service
	parent                             string
	googlecloudpolicysimulatorv1replay *GoogleCloudPolicysimulatorV1Replay
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Create: Creates and starts a Replay using the given ReplayConfig.
//
//   - parent: The parent resource where this Replay will be created. This
//     resource must be a project, folder, or organization with a location.
//     Example: `projects/my-example-project/locations/global`.
func (r *ProjectsLocationsReplaysService) Create(parent string, googlecloudpolicysimulatorv1replay *GoogleCloudPolicysimulatorV1Replay) *ProjectsLocationsReplaysCreateCall {
	c := &ProjectsLocationsReplaysCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudpolicysimulatorv1replay = googlecloudpolicysimulatorv1replay
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReplaysCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsReplaysCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReplaysCreateCall) Context(ctx context.Context) *ProjectsLocationsReplaysCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReplaysCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReplaysCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudpolicysimulatorv1replay)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/replays")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.replays.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.projects.locations.replays.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsReplaysCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.replays.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReplaysGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified Replay. Each `Replay` is available for at least 7
// days.
//
//   - name: The name of the Replay to retrieve, in the following format:
//     `{projects|folders|organizations}/{resource-id}/locations/global/replays/{r
//     eplay-id}`, where `{resource-id}` is the ID of the project, folder, or
//     organization that owns the `Replay`. Example:
//     `projects/my-example-project/locations/global/replays/506a5f7f-38ce-4d7d-8e
//     03-479ce1833c36`.
func (r *ProjectsLocationsReplaysService) Get(name string) *ProjectsLocationsReplaysGetCall {
	c := &ProjectsLocationsReplaysGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReplaysGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsReplaysGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReplaysGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsReplaysGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReplaysGetCall) Context(ctx context.Context) *ProjectsLocationsReplaysGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReplaysGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReplaysGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.replays.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.projects.locations.replays.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudPolicysimulatorV1Replay.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsReplaysGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicysimulatorV1Replay, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicysimulatorV1Replay{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.replays.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReplaysOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsReplaysOperationsService) Get(name string) *ProjectsLocationsReplaysOperationsGetCall {
	c := &ProjectsLocationsReplaysOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReplaysOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsReplaysOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReplaysOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsReplaysOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReplaysOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsReplaysOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReplaysOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReplaysOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.replays.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.projects.locations.replays.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsReplaysOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.replays.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsReplaysOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsReplaysOperationsService) List(name string) *ProjectsLocationsReplaysOperationsListCall {
	c := &ProjectsLocationsReplaysOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsReplaysOperationsListCall) Filter(filter string) *ProjectsLocationsReplaysOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsReplaysOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsReplaysOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsReplaysOperationsListCall) PageToken(pageToken string) *ProjectsLocationsReplaysOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// ListOperationsResponse.unreachable field. This can only be `true` when
// reading across collections. For example, when `parent` is set to
// "projects/example/locations/-". This field is not supported by default and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *ProjectsLocationsReplaysOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsReplaysOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReplaysOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsReplaysOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReplaysOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsReplaysOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReplaysOperationsListCall) Context(ctx context.Context) *ProjectsLocationsReplaysOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReplaysOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReplaysOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.replays.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.projects.locations.replays.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsReplaysOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.replays.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsReplaysOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsReplaysResultsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the results of running a Replay.
//
//   - parent: The Replay whose results are listed, in the following format:
//     `{projects|folders|organizations}/{resource-id}/locations/global/replays/{r
//     eplay-id}` Example:
//     `projects/my-project/locations/global/replays/506a5f7f-38ce-4d7d-8e03-479ce
//     1833c36`.
func (r *ProjectsLocationsReplaysResultsService) List(parent string) *ProjectsLocationsReplaysResultsListCall {
	c := &ProjectsLocationsReplaysResultsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// ReplayResult objects to return. Defaults to 5000. The maximum value is 5000;
// values above 5000 are rounded down to 5000.
func (c *ProjectsLocationsReplaysResultsListCall) PageSize(pageSize int64) *ProjectsLocationsReplaysResultsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous Simulator.ListReplayResults call. Provide this token to
// retrieve the next page of results. When paginating, all other parameters
// provided to [Simulator.ListReplayResults[] must match the call that provided
// the page token.
func (c *ProjectsLocationsReplaysResultsListCall) PageToken(pageToken string) *ProjectsLocationsReplaysResultsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsReplaysResultsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsReplaysResultsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsReplaysResultsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsReplaysResultsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsReplaysResultsListCall) Context(ctx context.Context) *ProjectsLocationsReplaysResultsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsReplaysResultsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsReplaysResultsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/results")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.replays.results.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "policysimulator.projects.locations.replays.results.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudPolicysimulatorV1ListReplayResultsResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsReplaysResultsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudPolicysimulatorV1ListReplayResultsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudPolicysimulatorV1ListReplayResultsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "policysimulator.projects.locations.replays.results.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsReplaysResultsListCall) Pages(ctx context.Context, f func(*GoogleCloudPolicysimulatorV1ListReplayResultsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
