// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/services/ad_group_ad_label_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [AdGroupAdLabelService.GetAdGroupAdLabel][google.ads.googleads.v1.services.AdGroupAdLabelService.GetAdGroupAdLabel].
type GetAdGroupAdLabelRequest struct {
	// The resource name of the ad group ad label to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAdGroupAdLabelRequest) Reset()         { *m = GetAdGroupAdLabelRequest{} }
func (m *GetAdGroupAdLabelRequest) String() string { return proto.CompactTextString(m) }
func (*GetAdGroupAdLabelRequest) ProtoMessage()    {}
func (*GetAdGroupAdLabelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_54f0c11a748eada4, []int{0}
}

func (m *GetAdGroupAdLabelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAdGroupAdLabelRequest.Unmarshal(m, b)
}
func (m *GetAdGroupAdLabelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAdGroupAdLabelRequest.Marshal(b, m, deterministic)
}
func (m *GetAdGroupAdLabelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAdGroupAdLabelRequest.Merge(m, src)
}
func (m *GetAdGroupAdLabelRequest) XXX_Size() int {
	return xxx_messageInfo_GetAdGroupAdLabelRequest.Size(m)
}
func (m *GetAdGroupAdLabelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAdGroupAdLabelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAdGroupAdLabelRequest proto.InternalMessageInfo

func (m *GetAdGroupAdLabelRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [AdGroupAdLabelService.MutateAdGroupAdLabels][google.ads.googleads.v1.services.AdGroupAdLabelService.MutateAdGroupAdLabels].
type MutateAdGroupAdLabelsRequest struct {
	// ID of the customer whose ad group ad labels are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on ad group ad labels.
	Operations []*AdGroupAdLabelOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdGroupAdLabelsRequest) Reset()         { *m = MutateAdGroupAdLabelsRequest{} }
func (m *MutateAdGroupAdLabelsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupAdLabelsRequest) ProtoMessage()    {}
func (*MutateAdGroupAdLabelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_54f0c11a748eada4, []int{1}
}

func (m *MutateAdGroupAdLabelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupAdLabelsRequest.Unmarshal(m, b)
}
func (m *MutateAdGroupAdLabelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupAdLabelsRequest.Marshal(b, m, deterministic)
}
func (m *MutateAdGroupAdLabelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupAdLabelsRequest.Merge(m, src)
}
func (m *MutateAdGroupAdLabelsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupAdLabelsRequest.Size(m)
}
func (m *MutateAdGroupAdLabelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupAdLabelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupAdLabelsRequest proto.InternalMessageInfo

func (m *MutateAdGroupAdLabelsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateAdGroupAdLabelsRequest) GetOperations() []*AdGroupAdLabelOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateAdGroupAdLabelsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateAdGroupAdLabelsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, remove) on an ad group ad label.
type AdGroupAdLabelOperation struct {
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*AdGroupAdLabelOperation_Create
	//	*AdGroupAdLabelOperation_Remove
	Operation            isAdGroupAdLabelOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *AdGroupAdLabelOperation) Reset()         { *m = AdGroupAdLabelOperation{} }
func (m *AdGroupAdLabelOperation) String() string { return proto.CompactTextString(m) }
func (*AdGroupAdLabelOperation) ProtoMessage()    {}
func (*AdGroupAdLabelOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_54f0c11a748eada4, []int{2}
}

func (m *AdGroupAdLabelOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupAdLabelOperation.Unmarshal(m, b)
}
func (m *AdGroupAdLabelOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupAdLabelOperation.Marshal(b, m, deterministic)
}
func (m *AdGroupAdLabelOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupAdLabelOperation.Merge(m, src)
}
func (m *AdGroupAdLabelOperation) XXX_Size() int {
	return xxx_messageInfo_AdGroupAdLabelOperation.Size(m)
}
func (m *AdGroupAdLabelOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupAdLabelOperation.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupAdLabelOperation proto.InternalMessageInfo

type isAdGroupAdLabelOperation_Operation interface {
	isAdGroupAdLabelOperation_Operation()
}

type AdGroupAdLabelOperation_Create struct {
	Create *resources.AdGroupAdLabel `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type AdGroupAdLabelOperation_Remove struct {
	Remove string `protobuf:"bytes,2,opt,name=remove,proto3,oneof"`
}

func (*AdGroupAdLabelOperation_Create) isAdGroupAdLabelOperation_Operation() {}

func (*AdGroupAdLabelOperation_Remove) isAdGroupAdLabelOperation_Operation() {}

func (m *AdGroupAdLabelOperation) GetOperation() isAdGroupAdLabelOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *AdGroupAdLabelOperation) GetCreate() *resources.AdGroupAdLabel {
	if x, ok := m.GetOperation().(*AdGroupAdLabelOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *AdGroupAdLabelOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*AdGroupAdLabelOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdGroupAdLabelOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdGroupAdLabelOperation_Create)(nil),
		(*AdGroupAdLabelOperation_Remove)(nil),
	}
}

// Response message for an ad group ad labels mutate.
type MutateAdGroupAdLabelsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateAdGroupAdLabelResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *MutateAdGroupAdLabelsResponse) Reset()         { *m = MutateAdGroupAdLabelsResponse{} }
func (m *MutateAdGroupAdLabelsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupAdLabelsResponse) ProtoMessage()    {}
func (*MutateAdGroupAdLabelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_54f0c11a748eada4, []int{3}
}

func (m *MutateAdGroupAdLabelsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupAdLabelsResponse.Unmarshal(m, b)
}
func (m *MutateAdGroupAdLabelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupAdLabelsResponse.Marshal(b, m, deterministic)
}
func (m *MutateAdGroupAdLabelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupAdLabelsResponse.Merge(m, src)
}
func (m *MutateAdGroupAdLabelsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupAdLabelsResponse.Size(m)
}
func (m *MutateAdGroupAdLabelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupAdLabelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupAdLabelsResponse proto.InternalMessageInfo

func (m *MutateAdGroupAdLabelsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateAdGroupAdLabelsResponse) GetResults() []*MutateAdGroupAdLabelResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for an ad group ad label mutate.
type MutateAdGroupAdLabelResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdGroupAdLabelResult) Reset()         { *m = MutateAdGroupAdLabelResult{} }
func (m *MutateAdGroupAdLabelResult) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupAdLabelResult) ProtoMessage()    {}
func (*MutateAdGroupAdLabelResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_54f0c11a748eada4, []int{4}
}

func (m *MutateAdGroupAdLabelResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupAdLabelResult.Unmarshal(m, b)
}
func (m *MutateAdGroupAdLabelResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupAdLabelResult.Marshal(b, m, deterministic)
}
func (m *MutateAdGroupAdLabelResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupAdLabelResult.Merge(m, src)
}
func (m *MutateAdGroupAdLabelResult) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupAdLabelResult.Size(m)
}
func (m *MutateAdGroupAdLabelResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupAdLabelResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupAdLabelResult proto.InternalMessageInfo

func (m *MutateAdGroupAdLabelResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetAdGroupAdLabelRequest)(nil), "google.ads.googleads.v1.services.GetAdGroupAdLabelRequest")
	proto.RegisterType((*MutateAdGroupAdLabelsRequest)(nil), "google.ads.googleads.v1.services.MutateAdGroupAdLabelsRequest")
	proto.RegisterType((*AdGroupAdLabelOperation)(nil), "google.ads.googleads.v1.services.AdGroupAdLabelOperation")
	proto.RegisterType((*MutateAdGroupAdLabelsResponse)(nil), "google.ads.googleads.v1.services.MutateAdGroupAdLabelsResponse")
	proto.RegisterType((*MutateAdGroupAdLabelResult)(nil), "google.ads.googleads.v1.services.MutateAdGroupAdLabelResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/services/ad_group_ad_label_service.proto", fileDescriptor_54f0c11a748eada4)
}

var fileDescriptor_54f0c11a748eada4 = []byte{
	// 674 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xcf, 0x6b, 0xd4, 0x4e,
	0x14, 0xff, 0x66, 0xf7, 0x4b, 0xb5, 0xb3, 0x55, 0x71, 0xa4, 0x34, 0xc4, 0x8a, 0x4b, 0x2c, 0x58,
	0xf6, 0x90, 0x90, 0xad, 0x97, 0x8d, 0xd6, 0x9a, 0x82, 0xdd, 0x8a, 0x3f, 0x5a, 0x52, 0x58, 0x50,
	0x16, 0xc2, 0x34, 0x19, 0x43, 0x20, 0xc9, 0xc4, 0x99, 0xc9, 0x42, 0x29, 0x3d, 0xe8, 0xdd, 0x93,
	0xff, 0x81, 0x47, 0xff, 0x07, 0xf1, 0xde, 0x93, 0xe0, 0xc9, 0xbb, 0x07, 0xf1, 0xaf, 0x90, 0x64,
	0x32, 0xdb, 0xee, 0xba, 0x61, 0xb5, 0xb7, 0x97, 0xf7, 0xe3, 0xf3, 0x79, 0x9f, 0xf7, 0xe6, 0x05,
	0x3c, 0x0a, 0x09, 0x09, 0x63, 0x6c, 0xa2, 0x80, 0x99, 0xc2, 0x2c, 0xac, 0x91, 0x65, 0x32, 0x4c,
	0x47, 0x91, 0x8f, 0x99, 0x89, 0x02, 0x2f, 0xa4, 0x24, 0xcf, 0x3c, 0x14, 0x78, 0x31, 0x3a, 0xc4,
	0xb1, 0x57, 0x85, 0x8c, 0x8c, 0x12, 0x4e, 0x60, 0x5b, 0x94, 0x19, 0x28, 0x60, 0xc6, 0x18, 0xc1,
	0x18, 0x59, 0x86, 0x44, 0xd0, 0x7a, 0x75, 0x1c, 0x14, 0x33, 0x92, 0xd3, 0x99, 0x24, 0x02, 0x5c,
	0x5b, 0x95, 0xa5, 0x59, 0x64, 0xa2, 0x34, 0x25, 0x1c, 0xf1, 0x88, 0xa4, 0xac, 0x8a, 0xae, 0x54,
	0x51, 0x9a, 0xf9, 0x26, 0xe3, 0x88, 0xe7, 0xd3, 0x81, 0xa2, 0xcc, 0x8f, 0x23, 0x9c, 0x72, 0x11,
	0xd0, 0xb7, 0x80, 0xda, 0xc7, 0xdc, 0x09, 0xfa, 0x05, 0x99, 0x13, 0x3c, 0x2b, 0xa8, 0x5c, 0xfc,
	0x26, 0xc7, 0x8c, 0xc3, 0x3b, 0xe0, 0x8a, 0x6c, 0xc8, 0x4b, 0x51, 0x82, 0x55, 0xa5, 0xad, 0xac,
	0x2f, 0xba, 0x4b, 0xd2, 0xf9, 0x02, 0x25, 0x58, 0xff, 0xa9, 0x80, 0xd5, 0xe7, 0x39, 0x47, 0x1c,
	0x4f, 0x82, 0x30, 0x89, 0x72, 0x1b, 0xb4, 0xfc, 0x9c, 0x71, 0x92, 0x60, 0xea, 0x45, 0x41, 0x85,
	0x01, 0xa4, 0xeb, 0x49, 0x00, 0x5f, 0x02, 0x40, 0x32, 0x4c, 0x85, 0x10, 0xb5, 0xd1, 0x6e, 0xae,
	0xb7, 0xba, 0x3d, 0x63, 0xde, 0x10, 0x8d, 0x49, 0xba, 0x3d, 0x89, 0xe0, 0x9e, 0x03, 0x83, 0x77,
	0xc1, 0xb5, 0x0c, 0x51, 0x1e, 0xa1, 0xd8, 0x7b, 0x8d, 0xa2, 0x38, 0xa7, 0x58, 0x6d, 0xb6, 0x95,
	0xf5, 0xcb, 0xee, 0xd5, 0xca, 0xbd, 0x23, 0xbc, 0x85, 0xd4, 0x11, 0x8a, 0xa3, 0x00, 0x71, 0xec,
	0x91, 0x34, 0x3e, 0x52, 0xff, 0x2f, 0xd3, 0x96, 0xa4, 0x73, 0x2f, 0x8d, 0x8f, 0xf4, 0xf7, 0x0a,
	0x58, 0xa9, 0x61, 0x85, 0x4f, 0xc1, 0x82, 0x4f, 0x31, 0xe2, 0x62, 0x48, 0xad, 0xae, 0x55, 0x2b,
	0x60, 0xbc, 0xe3, 0x29, 0x05, 0xbb, 0xff, 0xb9, 0x15, 0x04, 0x54, 0xc1, 0x02, 0xc5, 0x09, 0x19,
	0x61, 0xb5, 0x51, 0x4c, 0xab, 0x88, 0x88, 0xef, 0xed, 0x16, 0x58, 0x1c, 0xcb, 0xd3, 0xbf, 0x28,
	0xe0, 0x56, 0xcd, 0xe8, 0x59, 0x46, 0x52, 0x86, 0xe1, 0x0e, 0x58, 0x9e, 0xd2, 0xef, 0x61, 0x4a,
	0x09, 0x2d, 0xa7, 0xd0, 0xea, 0x42, 0xd9, 0x24, 0xcd, 0x7c, 0xe3, 0xa0, 0x7c, 0x2f, 0xee, 0x8d,
	0xc9, 0xc9, 0x3c, 0x2e, 0xd2, 0xe1, 0x00, 0x5c, 0xa2, 0x98, 0xe5, 0x31, 0x97, 0xfb, 0x79, 0x30,
	0x7f, 0x3f, 0xb3, 0x3a, 0x73, 0x4b, 0x10, 0x57, 0x82, 0xe9, 0x0e, 0xd0, 0xea, 0xd3, 0xfe, 0xea,
	0xfd, 0x75, 0xbf, 0x36, 0xc1, 0xf2, 0x64, 0xf5, 0x81, 0xe8, 0x00, 0x7e, 0x56, 0xc0, 0xf5, 0x3f,
	0xde, 0x36, 0xb4, 0xe7, 0x77, 0x5e, 0x77, 0x10, 0xda, 0xbf, 0x2f, 0x55, 0xef, 0xbd, 0xfb, 0xf6,
	0xe3, 0x43, 0x63, 0x03, 0x5a, 0xc5, 0x79, 0x1f, 0x4f, 0xc8, 0xd9, 0x94, 0x37, 0xc0, 0xcc, 0x8e,
	0x89, 0x26, 0x37, 0x68, 0x76, 0x4e, 0xe0, 0x77, 0x05, 0x2c, 0xcf, 0x5c, 0x2f, 0x7c, 0x78, 0xb1,
	0xe9, 0xcb, 0x93, 0xd4, 0xb6, 0x2e, 0x5c, 0x2f, 0xde, 0x95, 0xbe, 0x55, 0xaa, 0xea, 0xe9, 0xf7,
	0x0a, 0x55, 0x67, 0x32, 0x8e, 0xcf, 0x1d, 0xfa, 0x66, 0xe7, 0x64, 0x5a, 0x94, 0x9d, 0x94, 0xa0,
	0xb6, 0xd2, 0xd1, 0x6e, 0x9e, 0x3a, 0xea, 0x19, 0x71, 0x65, 0x65, 0x11, 0x33, 0x7c, 0x92, 0x6c,
	0xbf, 0x6d, 0x80, 0x35, 0x9f, 0x24, 0x73, 0x9b, 0xdc, 0xd6, 0x66, 0x2e, 0x7e, 0xbf, 0xf8, 0xb1,
	0xed, 0x2b, 0xaf, 0x76, 0xab, 0xfa, 0x90, 0xc4, 0x28, 0x0d, 0x0d, 0x42, 0x43, 0x33, 0xc4, 0x69,
	0xf9, 0xdb, 0x33, 0xcf, 0x18, 0xeb, 0x7f, 0xf4, 0xf7, 0xa5, 0xf1, 0xb1, 0xd1, 0xec, 0x3b, 0xce,
	0xa7, 0x46, 0xbb, 0x2f, 0x00, 0x9d, 0x80, 0x19, 0xc2, 0x2c, 0xac, 0x81, 0x65, 0x54, 0xc4, 0xec,
	0x54, 0xa6, 0x0c, 0x9d, 0x80, 0x0d, 0xc7, 0x29, 0xc3, 0x81, 0x35, 0x94, 0x29, 0xbf, 0x1a, 0x6b,
	0xc2, 0x6f, 0xdb, 0x4e, 0xc0, 0x6c, 0x7b, 0x9c, 0x64, 0xdb, 0x03, 0xcb, 0xb6, 0x65, 0xda, 0xe1,
	0x42, 0xd9, 0xe7, 0xc6, 0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0x2b, 0x7e, 0x23, 0xf1, 0x8f, 0x06,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AdGroupAdLabelServiceClient is the client API for AdGroupAdLabelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AdGroupAdLabelServiceClient interface {
	// Returns the requested ad group ad label in full detail.
	GetAdGroupAdLabel(ctx context.Context, in *GetAdGroupAdLabelRequest, opts ...grpc.CallOption) (*resources.AdGroupAdLabel, error)
	// Creates and removes ad group ad labels.
	// Operation statuses are returned.
	MutateAdGroupAdLabels(ctx context.Context, in *MutateAdGroupAdLabelsRequest, opts ...grpc.CallOption) (*MutateAdGroupAdLabelsResponse, error)
}

type adGroupAdLabelServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAdGroupAdLabelServiceClient(cc grpc.ClientConnInterface) AdGroupAdLabelServiceClient {
	return &adGroupAdLabelServiceClient{cc}
}

func (c *adGroupAdLabelServiceClient) GetAdGroupAdLabel(ctx context.Context, in *GetAdGroupAdLabelRequest, opts ...grpc.CallOption) (*resources.AdGroupAdLabel, error) {
	out := new(resources.AdGroupAdLabel)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.AdGroupAdLabelService/GetAdGroupAdLabel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adGroupAdLabelServiceClient) MutateAdGroupAdLabels(ctx context.Context, in *MutateAdGroupAdLabelsRequest, opts ...grpc.CallOption) (*MutateAdGroupAdLabelsResponse, error) {
	out := new(MutateAdGroupAdLabelsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.AdGroupAdLabelService/MutateAdGroupAdLabels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AdGroupAdLabelServiceServer is the server API for AdGroupAdLabelService service.
type AdGroupAdLabelServiceServer interface {
	// Returns the requested ad group ad label in full detail.
	GetAdGroupAdLabel(context.Context, *GetAdGroupAdLabelRequest) (*resources.AdGroupAdLabel, error)
	// Creates and removes ad group ad labels.
	// Operation statuses are returned.
	MutateAdGroupAdLabels(context.Context, *MutateAdGroupAdLabelsRequest) (*MutateAdGroupAdLabelsResponse, error)
}

// UnimplementedAdGroupAdLabelServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAdGroupAdLabelServiceServer struct {
}

func (*UnimplementedAdGroupAdLabelServiceServer) GetAdGroupAdLabel(ctx context.Context, req *GetAdGroupAdLabelRequest) (*resources.AdGroupAdLabel, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAdGroupAdLabel not implemented")
}
func (*UnimplementedAdGroupAdLabelServiceServer) MutateAdGroupAdLabels(ctx context.Context, req *MutateAdGroupAdLabelsRequest) (*MutateAdGroupAdLabelsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateAdGroupAdLabels not implemented")
}

func RegisterAdGroupAdLabelServiceServer(s *grpc.Server, srv AdGroupAdLabelServiceServer) {
	s.RegisterService(&_AdGroupAdLabelService_serviceDesc, srv)
}

func _AdGroupAdLabelService_GetAdGroupAdLabel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdGroupAdLabelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupAdLabelServiceServer).GetAdGroupAdLabel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.AdGroupAdLabelService/GetAdGroupAdLabel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupAdLabelServiceServer).GetAdGroupAdLabel(ctx, req.(*GetAdGroupAdLabelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdGroupAdLabelService_MutateAdGroupAdLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateAdGroupAdLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupAdLabelServiceServer).MutateAdGroupAdLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.AdGroupAdLabelService/MutateAdGroupAdLabels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupAdLabelServiceServer).MutateAdGroupAdLabels(ctx, req.(*MutateAdGroupAdLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AdGroupAdLabelService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.AdGroupAdLabelService",
	HandlerType: (*AdGroupAdLabelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAdGroupAdLabel",
			Handler:    _AdGroupAdLabelService_GetAdGroupAdLabel_Handler,
		},
		{
			MethodName: "MutateAdGroupAdLabels",
			Handler:    _AdGroupAdLabelService_MutateAdGroupAdLabels_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/ad_group_ad_label_service.proto",
}
