// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/services/customer_manager_link_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [CustomerManagerLinkService.GetCustomerManagerLink][google.ads.googleads.v1.services.CustomerManagerLinkService.GetCustomerManagerLink].
type GetCustomerManagerLinkRequest struct {
	// The resource name of the CustomerManagerLink to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCustomerManagerLinkRequest) Reset()         { *m = GetCustomerManagerLinkRequest{} }
func (m *GetCustomerManagerLinkRequest) String() string { return proto.CompactTextString(m) }
func (*GetCustomerManagerLinkRequest) ProtoMessage()    {}
func (*GetCustomerManagerLinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_aaa2b7db8eabbebe, []int{0}
}

func (m *GetCustomerManagerLinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCustomerManagerLinkRequest.Unmarshal(m, b)
}
func (m *GetCustomerManagerLinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCustomerManagerLinkRequest.Marshal(b, m, deterministic)
}
func (m *GetCustomerManagerLinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCustomerManagerLinkRequest.Merge(m, src)
}
func (m *GetCustomerManagerLinkRequest) XXX_Size() int {
	return xxx_messageInfo_GetCustomerManagerLinkRequest.Size(m)
}
func (m *GetCustomerManagerLinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCustomerManagerLinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCustomerManagerLinkRequest proto.InternalMessageInfo

func (m *GetCustomerManagerLinkRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [CustomerManagerLinkService.MutateCustomerManagerLink][google.ads.googleads.v1.services.CustomerManagerLinkService.MutateCustomerManagerLink].
type MutateCustomerManagerLinkRequest struct {
	// The ID of the customer whose customer manager links are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual customer manager links.
	Operations           []*CustomerManagerLinkOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *MutateCustomerManagerLinkRequest) Reset()         { *m = MutateCustomerManagerLinkRequest{} }
func (m *MutateCustomerManagerLinkRequest) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerManagerLinkRequest) ProtoMessage()    {}
func (*MutateCustomerManagerLinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_aaa2b7db8eabbebe, []int{1}
}

func (m *MutateCustomerManagerLinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerManagerLinkRequest.Unmarshal(m, b)
}
func (m *MutateCustomerManagerLinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerManagerLinkRequest.Marshal(b, m, deterministic)
}
func (m *MutateCustomerManagerLinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerManagerLinkRequest.Merge(m, src)
}
func (m *MutateCustomerManagerLinkRequest) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerManagerLinkRequest.Size(m)
}
func (m *MutateCustomerManagerLinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerManagerLinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerManagerLinkRequest proto.InternalMessageInfo

func (m *MutateCustomerManagerLinkRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateCustomerManagerLinkRequest) GetOperations() []*CustomerManagerLinkOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// Updates the status of a CustomerManagerLink.
// The following actions are possible:
// 1. Update operation with status ACTIVE accepts a pending invitation.
// 2. Update operation with status REFUSED declines a pending invitation.
// 3. Update operation with status INACTIVE terminates link to manager.
type CustomerManagerLinkOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*CustomerManagerLinkOperation_Update
	Operation            isCustomerManagerLinkOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *CustomerManagerLinkOperation) Reset()         { *m = CustomerManagerLinkOperation{} }
func (m *CustomerManagerLinkOperation) String() string { return proto.CompactTextString(m) }
func (*CustomerManagerLinkOperation) ProtoMessage()    {}
func (*CustomerManagerLinkOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_aaa2b7db8eabbebe, []int{2}
}

func (m *CustomerManagerLinkOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomerManagerLinkOperation.Unmarshal(m, b)
}
func (m *CustomerManagerLinkOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomerManagerLinkOperation.Marshal(b, m, deterministic)
}
func (m *CustomerManagerLinkOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomerManagerLinkOperation.Merge(m, src)
}
func (m *CustomerManagerLinkOperation) XXX_Size() int {
	return xxx_messageInfo_CustomerManagerLinkOperation.Size(m)
}
func (m *CustomerManagerLinkOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomerManagerLinkOperation.DiscardUnknown(m)
}

var xxx_messageInfo_CustomerManagerLinkOperation proto.InternalMessageInfo

func (m *CustomerManagerLinkOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isCustomerManagerLinkOperation_Operation interface {
	isCustomerManagerLinkOperation_Operation()
}

type CustomerManagerLinkOperation_Update struct {
	Update *resources.CustomerManagerLink `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

func (*CustomerManagerLinkOperation_Update) isCustomerManagerLinkOperation_Operation() {}

func (m *CustomerManagerLinkOperation) GetOperation() isCustomerManagerLinkOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *CustomerManagerLinkOperation) GetUpdate() *resources.CustomerManagerLink {
	if x, ok := m.GetOperation().(*CustomerManagerLinkOperation_Update); ok {
		return x.Update
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CustomerManagerLinkOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CustomerManagerLinkOperation_Update)(nil),
	}
}

// Response message for a CustomerManagerLink mutate.
type MutateCustomerManagerLinkResponse struct {
	// A result that identifies the resource affected by the mutate request.
	Results              []*MutateCustomerManagerLinkResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *MutateCustomerManagerLinkResponse) Reset()         { *m = MutateCustomerManagerLinkResponse{} }
func (m *MutateCustomerManagerLinkResponse) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerManagerLinkResponse) ProtoMessage()    {}
func (*MutateCustomerManagerLinkResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_aaa2b7db8eabbebe, []int{3}
}

func (m *MutateCustomerManagerLinkResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerManagerLinkResponse.Unmarshal(m, b)
}
func (m *MutateCustomerManagerLinkResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerManagerLinkResponse.Marshal(b, m, deterministic)
}
func (m *MutateCustomerManagerLinkResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerManagerLinkResponse.Merge(m, src)
}
func (m *MutateCustomerManagerLinkResponse) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerManagerLinkResponse.Size(m)
}
func (m *MutateCustomerManagerLinkResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerManagerLinkResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerManagerLinkResponse proto.InternalMessageInfo

func (m *MutateCustomerManagerLinkResponse) GetResults() []*MutateCustomerManagerLinkResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the customer manager link mutate.
type MutateCustomerManagerLinkResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomerManagerLinkResult) Reset()         { *m = MutateCustomerManagerLinkResult{} }
func (m *MutateCustomerManagerLinkResult) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerManagerLinkResult) ProtoMessage()    {}
func (*MutateCustomerManagerLinkResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_aaa2b7db8eabbebe, []int{4}
}

func (m *MutateCustomerManagerLinkResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerManagerLinkResult.Unmarshal(m, b)
}
func (m *MutateCustomerManagerLinkResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerManagerLinkResult.Marshal(b, m, deterministic)
}
func (m *MutateCustomerManagerLinkResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerManagerLinkResult.Merge(m, src)
}
func (m *MutateCustomerManagerLinkResult) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerManagerLinkResult.Size(m)
}
func (m *MutateCustomerManagerLinkResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerManagerLinkResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerManagerLinkResult proto.InternalMessageInfo

func (m *MutateCustomerManagerLinkResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetCustomerManagerLinkRequest)(nil), "google.ads.googleads.v1.services.GetCustomerManagerLinkRequest")
	proto.RegisterType((*MutateCustomerManagerLinkRequest)(nil), "google.ads.googleads.v1.services.MutateCustomerManagerLinkRequest")
	proto.RegisterType((*CustomerManagerLinkOperation)(nil), "google.ads.googleads.v1.services.CustomerManagerLinkOperation")
	proto.RegisterType((*MutateCustomerManagerLinkResponse)(nil), "google.ads.googleads.v1.services.MutateCustomerManagerLinkResponse")
	proto.RegisterType((*MutateCustomerManagerLinkResult)(nil), "google.ads.googleads.v1.services.MutateCustomerManagerLinkResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/services/customer_manager_link_service.proto", fileDescriptor_aaa2b7db8eabbebe)
}

var fileDescriptor_aaa2b7db8eabbebe = []byte{
	// 619 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x54, 0x4f, 0x6e, 0xd3, 0x4c,
	0x14, 0xff, 0xec, 0x7e, 0x2a, 0xea, 0x04, 0x36, 0x5e, 0x80, 0x31, 0x45, 0x35, 0xa6, 0x8b, 0x28,
	0x8b, 0xb1, 0x12, 0xa4, 0x0a, 0x5c, 0x25, 0xc8, 0x69, 0xd4, 0x14, 0x89, 0x40, 0x64, 0xa4, 0x2c,
	0x20, 0x22, 0x9a, 0xc6, 0x53, 0xcb, 0x8a, 0xed, 0x31, 0x9e, 0x71, 0x36, 0x55, 0x25, 0xc4, 0x82,
	0x0b, 0x70, 0x03, 0xd8, 0x71, 0x04, 0x8e, 0xd0, 0x1d, 0xe2, 0x0a, 0xac, 0x7a, 0x04, 0x56, 0xc8,
	0x1e, 0x8f, 0x13, 0xa4, 0x38, 0x41, 0x74, 0xf7, 0x3c, 0xf3, 0xde, 0xef, 0xcf, 0x9b, 0xf7, 0x0c,
	0x7a, 0x1e, 0x21, 0x5e, 0x80, 0x4d, 0xe4, 0x52, 0x93, 0x87, 0x59, 0x34, 0x6f, 0x9a, 0x14, 0x27,
	0x73, 0x7f, 0x8a, 0xa9, 0x39, 0x4d, 0x29, 0x23, 0x21, 0x4e, 0x26, 0x21, 0x8a, 0x90, 0x87, 0x93,
	0x49, 0xe0, 0x47, 0xb3, 0x49, 0x71, 0x0d, 0xe3, 0x84, 0x30, 0xa2, 0xe8, 0xbc, 0x14, 0x22, 0x97,
	0xc2, 0x12, 0x05, 0xce, 0x9b, 0x50, 0xa0, 0x68, 0xed, 0x2a, 0x9e, 0x04, 0x53, 0x92, 0x26, 0x95,
	0x44, 0x9c, 0x40, 0xdb, 0x15, 0xe5, 0xb1, 0x6f, 0xa2, 0x28, 0x22, 0x0c, 0x31, 0x9f, 0x44, 0xb4,
	0xb8, 0x2d, 0xe8, 0xcd, 0xfc, 0xeb, 0x34, 0x3d, 0x33, 0xcf, 0x7c, 0x1c, 0xb8, 0x93, 0x10, 0x51,
	0x51, 0x7f, 0x67, 0xa9, 0x7e, 0x1a, 0xf8, 0x38, 0x62, 0xfc, 0xc2, 0xe8, 0x81, 0xfb, 0x7d, 0xcc,
	0x8e, 0x0a, 0xea, 0x01, 0x67, 0x7e, 0xee, 0x47, 0x33, 0x07, 0xbf, 0x4b, 0x31, 0x65, 0xca, 0x43,
	0x70, 0x4b, 0x48, 0x9c, 0x44, 0x28, 0xc4, 0xaa, 0xa4, 0x4b, 0xf5, 0x1d, 0xe7, 0xa6, 0x38, 0x7c,
	0x81, 0x42, 0x6c, 0x7c, 0x91, 0x80, 0x3e, 0x48, 0x19, 0x62, 0x78, 0x0d, 0xd2, 0x1e, 0xa8, 0x95,
	0x16, 0x7d, 0xb7, 0xc0, 0x01, 0xe2, 0xe8, 0x99, 0xab, 0xbc, 0x05, 0x80, 0xc4, 0x38, 0xe1, 0xd6,
	0x54, 0x59, 0xdf, 0xaa, 0xd7, 0x5a, 0x1d, 0xb8, 0xa9, 0xb5, 0x70, 0x05, 0xe5, 0x4b, 0x01, 0xe3,
	0x2c, 0x21, 0x1a, 0xdf, 0x24, 0xb0, 0xbb, 0x2e, 0x59, 0x39, 0x04, 0xb5, 0x34, 0x76, 0x11, 0xc3,
	0x79, 0xeb, 0xd4, 0xff, 0x75, 0xa9, 0x5e, 0x6b, 0x69, 0x42, 0x81, 0xe8, 0x2e, 0x3c, 0xce, 0xba,
	0x3b, 0x40, 0x74, 0xe6, 0x00, 0x9e, 0x9e, 0xc5, 0xca, 0x10, 0x6c, 0xf3, 0x2f, 0x55, 0xce, 0xeb,
	0x0e, 0x2a, 0x95, 0x97, 0x4f, 0xbe, 0x4a, 0xfa, 0xc9, 0x7f, 0x4e, 0x81, 0xd3, 0xad, 0x81, 0x9d,
	0x52, 0xbd, 0xf1, 0x5e, 0x02, 0x0f, 0xd6, 0xb4, 0x98, 0xc6, 0x24, 0xa2, 0x58, 0x79, 0x03, 0x6e,
	0x24, 0x98, 0xa6, 0x01, 0xa3, 0xaa, 0x94, 0xf7, 0xcf, 0xde, 0xdc, 0xbf, 0x75, 0xa8, 0x69, 0xc0,
	0x1c, 0x81, 0x68, 0x1c, 0x83, 0xbd, 0x0d, 0xb9, 0x7f, 0x35, 0x2d, 0xad, 0x5f, 0x5b, 0x40, 0x5b,
	0x01, 0xf1, 0x8a, 0x0b, 0x52, 0xbe, 0x4b, 0xe0, 0xf6, 0xea, 0x99, 0x54, 0x9e, 0x6e, 0x76, 0xb3,
	0x76, 0x9a, 0xb5, 0x7f, 0x7c, 0x14, 0xa3, 0xf3, 0xe1, 0xc7, 0xcf, 0x4f, 0xf2, 0x63, 0xe5, 0x20,
	0x5b, 0xd9, 0xf3, 0x3f, 0x2c, 0xb6, 0xc5, 0x04, 0x53, 0xb3, 0x51, 0xee, 0xf0, 0x52, 0x2d, 0x35,
	0x1b, 0x17, 0xca, 0x95, 0x04, 0xee, 0x56, 0xf6, 0x4e, 0xe9, 0x5e, 0xeb, 0x91, 0xb8, 0xb3, 0xa3,
	0xeb, 0x3d, 0x74, 0x3e, 0x3e, 0x46, 0x2f, 0xb7, 0xd9, 0x31, 0x9e, 0x64, 0x36, 0x17, 0xbe, 0xce,
	0x97, 0xf6, 0xb6, 0xdd, 0xb8, 0x58, 0xe9, 0xd2, 0x0a, 0x73, 0x74, 0x4b, 0x6a, 0x68, 0xf7, 0x2e,
	0x6d, 0x75, 0xa1, 0xa0, 0x88, 0x62, 0x9f, 0xc2, 0x29, 0x09, 0xbb, 0x1f, 0x65, 0xb0, 0x3f, 0x25,
	0xe1, 0x46, 0xb5, 0xdd, 0xbd, 0xea, 0x11, 0x19, 0x66, 0x9b, 0x38, 0x94, 0x5e, 0x9f, 0x14, 0x20,
	0x1e, 0x09, 0x50, 0xe4, 0x41, 0x92, 0x78, 0xa6, 0x87, 0xa3, 0x7c, 0x4f, 0xcd, 0x05, 0x6d, 0xf5,
	0xbf, 0xfd, 0x50, 0x04, 0x9f, 0xe5, 0xad, 0xbe, 0x6d, 0x7f, 0x95, 0xf5, 0x3e, 0x07, 0xb4, 0x5d,
	0x0a, 0x79, 0x98, 0x45, 0xa3, 0x26, 0x2c, 0x88, 0xe9, 0xa5, 0x48, 0x19, 0xdb, 0x2e, 0x1d, 0x97,
	0x29, 0xe3, 0x51, 0x73, 0x2c, 0x52, 0xae, 0xe4, 0x7d, 0x7e, 0x6e, 0x59, 0xb6, 0x4b, 0x2d, 0xab,
	0x4c, 0xb2, 0xac, 0x51, 0xd3, 0xb2, 0x44, 0xda, 0xe9, 0x76, 0xae, 0xf3, 0xd1, 0xef, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x6f, 0x29, 0xbf, 0x9d, 0x82, 0x06, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CustomerManagerLinkServiceClient is the client API for CustomerManagerLinkService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CustomerManagerLinkServiceClient interface {
	// Returns the requested CustomerManagerLink in full detail.
	GetCustomerManagerLink(ctx context.Context, in *GetCustomerManagerLinkRequest, opts ...grpc.CallOption) (*resources.CustomerManagerLink, error)
	// Creates or updates customer manager links. Operation statuses are returned.
	MutateCustomerManagerLink(ctx context.Context, in *MutateCustomerManagerLinkRequest, opts ...grpc.CallOption) (*MutateCustomerManagerLinkResponse, error)
}

type customerManagerLinkServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCustomerManagerLinkServiceClient(cc grpc.ClientConnInterface) CustomerManagerLinkServiceClient {
	return &customerManagerLinkServiceClient{cc}
}

func (c *customerManagerLinkServiceClient) GetCustomerManagerLink(ctx context.Context, in *GetCustomerManagerLinkRequest, opts ...grpc.CallOption) (*resources.CustomerManagerLink, error) {
	out := new(resources.CustomerManagerLink)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.CustomerManagerLinkService/GetCustomerManagerLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customerManagerLinkServiceClient) MutateCustomerManagerLink(ctx context.Context, in *MutateCustomerManagerLinkRequest, opts ...grpc.CallOption) (*MutateCustomerManagerLinkResponse, error) {
	out := new(MutateCustomerManagerLinkResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.CustomerManagerLinkService/MutateCustomerManagerLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CustomerManagerLinkServiceServer is the server API for CustomerManagerLinkService service.
type CustomerManagerLinkServiceServer interface {
	// Returns the requested CustomerManagerLink in full detail.
	GetCustomerManagerLink(context.Context, *GetCustomerManagerLinkRequest) (*resources.CustomerManagerLink, error)
	// Creates or updates customer manager links. Operation statuses are returned.
	MutateCustomerManagerLink(context.Context, *MutateCustomerManagerLinkRequest) (*MutateCustomerManagerLinkResponse, error)
}

// UnimplementedCustomerManagerLinkServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCustomerManagerLinkServiceServer struct {
}

func (*UnimplementedCustomerManagerLinkServiceServer) GetCustomerManagerLink(ctx context.Context, req *GetCustomerManagerLinkRequest) (*resources.CustomerManagerLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomerManagerLink not implemented")
}
func (*UnimplementedCustomerManagerLinkServiceServer) MutateCustomerManagerLink(ctx context.Context, req *MutateCustomerManagerLinkRequest) (*MutateCustomerManagerLinkResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MutateCustomerManagerLink not implemented")
}

func RegisterCustomerManagerLinkServiceServer(s *grpc.Server, srv CustomerManagerLinkServiceServer) {
	s.RegisterService(&_CustomerManagerLinkService_serviceDesc, srv)
}

func _CustomerManagerLinkService_GetCustomerManagerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomerManagerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerManagerLinkServiceServer).GetCustomerManagerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.CustomerManagerLinkService/GetCustomerManagerLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerManagerLinkServiceServer).GetCustomerManagerLink(ctx, req.(*GetCustomerManagerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomerManagerLinkService_MutateCustomerManagerLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateCustomerManagerLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerManagerLinkServiceServer).MutateCustomerManagerLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.CustomerManagerLinkService/MutateCustomerManagerLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerManagerLinkServiceServer).MutateCustomerManagerLink(ctx, req.(*MutateCustomerManagerLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CustomerManagerLinkService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.CustomerManagerLinkService",
	HandlerType: (*CustomerManagerLinkServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCustomerManagerLink",
			Handler:    _CustomerManagerLinkService_GetCustomerManagerLink_Handler,
		},
		{
			MethodName: "MutateCustomerManagerLink",
			Handler:    _CustomerManagerLinkService_MutateCustomerManagerLink_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/customer_manager_link_service.proto",
}
