// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/services/customer_client_link_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v3/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [CustomerClientLinkService.GetCustomerClientLink][google.ads.googleads.v3.services.CustomerClientLinkService.GetCustomerClientLink].
type GetCustomerClientLinkRequest struct {
	// Required. The resource name of the customer client link to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetCustomerClientLinkRequest) Reset()         { *m = GetCustomerClientLinkRequest{} }
func (m *GetCustomerClientLinkRequest) String() string { return proto.CompactTextString(m) }
func (*GetCustomerClientLinkRequest) ProtoMessage()    {}
func (*GetCustomerClientLinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0b6996d934213c3f, []int{0}
}

func (m *GetCustomerClientLinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetCustomerClientLinkRequest.Unmarshal(m, b)
}
func (m *GetCustomerClientLinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetCustomerClientLinkRequest.Marshal(b, m, deterministic)
}
func (m *GetCustomerClientLinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetCustomerClientLinkRequest.Merge(m, src)
}
func (m *GetCustomerClientLinkRequest) XXX_Size() int {
	return xxx_messageInfo_GetCustomerClientLinkRequest.Size(m)
}
func (m *GetCustomerClientLinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetCustomerClientLinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetCustomerClientLinkRequest proto.InternalMessageInfo

func (m *GetCustomerClientLinkRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [CustomerClientLinkService.MutateCustomerClientLink][google.ads.googleads.v3.services.CustomerClientLinkService.MutateCustomerClientLink].
type MutateCustomerClientLinkRequest struct {
	// Required. The ID of the customer whose customer link are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The operation to perform on the individual CustomerClientLink.
	Operation            *CustomerClientLinkOperation `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *MutateCustomerClientLinkRequest) Reset()         { *m = MutateCustomerClientLinkRequest{} }
func (m *MutateCustomerClientLinkRequest) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerClientLinkRequest) ProtoMessage()    {}
func (*MutateCustomerClientLinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0b6996d934213c3f, []int{1}
}

func (m *MutateCustomerClientLinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerClientLinkRequest.Unmarshal(m, b)
}
func (m *MutateCustomerClientLinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerClientLinkRequest.Marshal(b, m, deterministic)
}
func (m *MutateCustomerClientLinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerClientLinkRequest.Merge(m, src)
}
func (m *MutateCustomerClientLinkRequest) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerClientLinkRequest.Size(m)
}
func (m *MutateCustomerClientLinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerClientLinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerClientLinkRequest proto.InternalMessageInfo

func (m *MutateCustomerClientLinkRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateCustomerClientLinkRequest) GetOperation() *CustomerClientLinkOperation {
	if m != nil {
		return m.Operation
	}
	return nil
}

// A single operation (create, update) on a CustomerClientLink.
type CustomerClientLinkOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*CustomerClientLinkOperation_Create
	//	*CustomerClientLinkOperation_Update
	Operation            isCustomerClientLinkOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *CustomerClientLinkOperation) Reset()         { *m = CustomerClientLinkOperation{} }
func (m *CustomerClientLinkOperation) String() string { return proto.CompactTextString(m) }
func (*CustomerClientLinkOperation) ProtoMessage()    {}
func (*CustomerClientLinkOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_0b6996d934213c3f, []int{2}
}

func (m *CustomerClientLinkOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomerClientLinkOperation.Unmarshal(m, b)
}
func (m *CustomerClientLinkOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomerClientLinkOperation.Marshal(b, m, deterministic)
}
func (m *CustomerClientLinkOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomerClientLinkOperation.Merge(m, src)
}
func (m *CustomerClientLinkOperation) XXX_Size() int {
	return xxx_messageInfo_CustomerClientLinkOperation.Size(m)
}
func (m *CustomerClientLinkOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomerClientLinkOperation.DiscardUnknown(m)
}

var xxx_messageInfo_CustomerClientLinkOperation proto.InternalMessageInfo

func (m *CustomerClientLinkOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isCustomerClientLinkOperation_Operation interface {
	isCustomerClientLinkOperation_Operation()
}

type CustomerClientLinkOperation_Create struct {
	Create *resources.CustomerClientLink `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type CustomerClientLinkOperation_Update struct {
	Update *resources.CustomerClientLink `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

func (*CustomerClientLinkOperation_Create) isCustomerClientLinkOperation_Operation() {}

func (*CustomerClientLinkOperation_Update) isCustomerClientLinkOperation_Operation() {}

func (m *CustomerClientLinkOperation) GetOperation() isCustomerClientLinkOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *CustomerClientLinkOperation) GetCreate() *resources.CustomerClientLink {
	if x, ok := m.GetOperation().(*CustomerClientLinkOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *CustomerClientLinkOperation) GetUpdate() *resources.CustomerClientLink {
	if x, ok := m.GetOperation().(*CustomerClientLinkOperation_Update); ok {
		return x.Update
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CustomerClientLinkOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CustomerClientLinkOperation_Create)(nil),
		(*CustomerClientLinkOperation_Update)(nil),
	}
}

// Response message for a CustomerClientLink mutate.
type MutateCustomerClientLinkResponse struct {
	// A result that identifies the resource affected by the mutate request.
	Result               *MutateCustomerClientLinkResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *MutateCustomerClientLinkResponse) Reset()         { *m = MutateCustomerClientLinkResponse{} }
func (m *MutateCustomerClientLinkResponse) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerClientLinkResponse) ProtoMessage()    {}
func (*MutateCustomerClientLinkResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0b6996d934213c3f, []int{3}
}

func (m *MutateCustomerClientLinkResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerClientLinkResponse.Unmarshal(m, b)
}
func (m *MutateCustomerClientLinkResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerClientLinkResponse.Marshal(b, m, deterministic)
}
func (m *MutateCustomerClientLinkResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerClientLinkResponse.Merge(m, src)
}
func (m *MutateCustomerClientLinkResponse) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerClientLinkResponse.Size(m)
}
func (m *MutateCustomerClientLinkResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerClientLinkResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerClientLinkResponse proto.InternalMessageInfo

func (m *MutateCustomerClientLinkResponse) GetResult() *MutateCustomerClientLinkResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// The result for a single customer client link mutate.
type MutateCustomerClientLinkResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateCustomerClientLinkResult) Reset()         { *m = MutateCustomerClientLinkResult{} }
func (m *MutateCustomerClientLinkResult) String() string { return proto.CompactTextString(m) }
func (*MutateCustomerClientLinkResult) ProtoMessage()    {}
func (*MutateCustomerClientLinkResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_0b6996d934213c3f, []int{4}
}

func (m *MutateCustomerClientLinkResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateCustomerClientLinkResult.Unmarshal(m, b)
}
func (m *MutateCustomerClientLinkResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateCustomerClientLinkResult.Marshal(b, m, deterministic)
}
func (m *MutateCustomerClientLinkResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateCustomerClientLinkResult.Merge(m, src)
}
func (m *MutateCustomerClientLinkResult) XXX_Size() int {
	return xxx_messageInfo_MutateCustomerClientLinkResult.Size(m)
}
func (m *MutateCustomerClientLinkResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateCustomerClientLinkResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateCustomerClientLinkResult proto.InternalMessageInfo

func (m *MutateCustomerClientLinkResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetCustomerClientLinkRequest)(nil), "google.ads.googleads.v3.services.GetCustomerClientLinkRequest")
	proto.RegisterType((*MutateCustomerClientLinkRequest)(nil), "google.ads.googleads.v3.services.MutateCustomerClientLinkRequest")
	proto.RegisterType((*CustomerClientLinkOperation)(nil), "google.ads.googleads.v3.services.CustomerClientLinkOperation")
	proto.RegisterType((*MutateCustomerClientLinkResponse)(nil), "google.ads.googleads.v3.services.MutateCustomerClientLinkResponse")
	proto.RegisterType((*MutateCustomerClientLinkResult)(nil), "google.ads.googleads.v3.services.MutateCustomerClientLinkResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/services/customer_client_link_service.proto", fileDescriptor_0b6996d934213c3f)
}

var fileDescriptor_0b6996d934213c3f = []byte{
	// 655 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x95, 0xcf, 0x6b, 0xd4, 0x40,
	0x14, 0xc7, 0x4d, 0x5a, 0x0a, 0x9d, 0xd5, 0xcb, 0x40, 0x71, 0xdd, 0x96, 0x76, 0x89, 0x3d, 0x94,
	0x45, 0x26, 0xd0, 0xa5, 0x28, 0xa9, 0x2b, 0x66, 0x8b, 0xb6, 0x82, 0xb5, 0x65, 0x85, 0x22, 0xba,
	0xb0, 0x4e, 0x93, 0x69, 0x0c, 0x4d, 0x32, 0x31, 0x33, 0xd9, 0x4b, 0xed, 0x45, 0xf0, 0xe0, 0xd9,
	0x93, 0x57, 0x6f, 0xfa, 0xa7, 0xf4, 0xea, 0xad, 0x20, 0x78, 0xf0, 0xe4, 0x1f, 0x21, 0x92, 0xcc,
	0x4c, 0x36, 0xa5, 0x9b, 0x5d, 0x68, 0x6f, 0x6f, 0xf3, 0xbe, 0xf3, 0x79, 0x3f, 0x67, 0x16, 0x6c,
	0x79, 0x94, 0x7a, 0x01, 0x31, 0xb1, 0xcb, 0x4c, 0x61, 0x66, 0xd6, 0xb0, 0x6d, 0x32, 0x92, 0x0c,
	0x7d, 0x87, 0x30, 0xd3, 0x49, 0x19, 0xa7, 0x21, 0x49, 0x06, 0x4e, 0xe0, 0x93, 0x88, 0x0f, 0x02,
	0x3f, 0x3a, 0x1e, 0x48, 0x2f, 0x8a, 0x13, 0xca, 0x29, 0x6c, 0x8a, 0x93, 0x08, 0xbb, 0x0c, 0x15,
	0x10, 0x34, 0x6c, 0x23, 0x05, 0x69, 0x3c, 0xac, 0x0a, 0x93, 0x10, 0x46, 0xd3, 0xa4, 0x2a, 0x8e,
	0xe0, 0x37, 0x96, 0xd4, 0xe9, 0xd8, 0x37, 0x71, 0x14, 0x51, 0x8e, 0xb9, 0x4f, 0x23, 0x26, 0xbd,
	0xb7, 0x4b, 0x5e, 0x71, 0x56, 0x3a, 0x56, 0x4a, 0x8e, 0x23, 0x9f, 0x04, 0xee, 0xe0, 0x90, 0xbc,
	0xc3, 0x43, 0x9f, 0x26, 0x52, 0x20, 0xf3, 0x36, 0xf3, 0x5f, 0x87, 0xe9, 0x91, 0x54, 0x85, 0x98,
	0xc9, 0xc8, 0xc6, 0x0e, 0x58, 0xda, 0x26, 0x7c, 0x4b, 0xa6, 0xb6, 0x95, 0xd3, 0x9f, 0xfb, 0xd1,
	0x71, 0x8f, 0xbc, 0x4f, 0x09, 0xe3, 0x70, 0x0d, 0xdc, 0x52, 0x15, 0x0c, 0x22, 0x1c, 0x92, 0xba,
	0xd6, 0xd4, 0xd6, 0xe6, 0xbb, 0x33, 0xbf, 0x6d, 0xbd, 0x77, 0x53, 0x79, 0x5e, 0xe0, 0x90, 0x18,
	0xdf, 0x35, 0xb0, 0xb2, 0x9b, 0x72, 0xcc, 0x49, 0x35, 0x6d, 0x15, 0xd4, 0x8a, 0x2e, 0xf8, 0x6e,
	0x99, 0x05, 0xd4, 0xf7, 0x67, 0x2e, 0x7c, 0x0b, 0xe6, 0x69, 0x4c, 0x92, 0xbc, 0x07, 0x75, 0xbd,
	0xa9, 0xad, 0xd5, 0xd6, 0x3b, 0x68, 0xda, 0x04, 0xd0, 0xe5, 0xa8, 0x7b, 0x0a, 0x22, 0x42, 0x8c,
	0xa0, 0xc6, 0x67, 0x1d, 0x2c, 0x4e, 0xd0, 0xc3, 0x4d, 0x50, 0x4b, 0x63, 0x17, 0x73, 0x92, 0xb7,
	0xaa, 0x3e, 0x9b, 0xe7, 0xd0, 0x50, 0x39, 0xa8, 0x6e, 0xa2, 0xa7, 0x59, 0x37, 0x77, 0x31, 0x3b,
	0xee, 0x01, 0x21, 0xcf, 0x6c, 0xb8, 0x07, 0xe6, 0x9c, 0x84, 0x60, 0x2e, 0x7a, 0x55, 0x5b, 0xdf,
	0xa8, 0xcc, 0xbd, 0xd8, 0x8d, 0x31, 0xc9, 0xef, 0xdc, 0xe8, 0x49, 0x4c, 0x06, 0x14, 0x78, 0xd9,
	0x8c, 0xab, 0x03, 0x05, 0xa6, 0x5b, 0x2b, 0x35, 0xd8, 0xf8, 0x00, 0x9a, 0xd5, 0x63, 0x63, 0x31,
	0x8d, 0x18, 0x81, 0xaf, 0xc0, 0x5c, 0x42, 0x58, 0x1a, 0x70, 0x59, 0xd2, 0xe3, 0xe9, 0xe3, 0x98,
	0xc0, 0x4c, 0x03, 0xde, 0x93, 0x3c, 0xe3, 0x09, 0x58, 0x9e, 0xac, 0x84, 0x77, 0xc7, 0x6e, 0xe0,
	0xc5, 0xe5, 0x5b, 0xff, 0x3a, 0x0b, 0xee, 0x5c, 0x26, 0xbc, 0x14, 0xc9, 0xc0, 0x5f, 0x1a, 0x58,
	0x18, 0xbb, 0xe5, 0xf0, 0xd1, 0xf4, 0x42, 0x26, 0x5d, 0x8f, 0xc6, 0xd5, 0x46, 0x61, 0xec, 0x9e,
	0xdb, 0x17, 0x8b, 0xfa, 0xf8, 0xf3, 0xcf, 0x17, 0xfd, 0x3e, 0xdc, 0xc8, 0x5e, 0x8c, 0x93, 0x0b,
	0x9e, 0x8e, 0xba, 0x18, 0xcc, 0x6c, 0x15, 0x4f, 0xc8, 0x08, 0xc5, 0xcc, 0xd6, 0x29, 0xfc, 0xa7,
	0x81, 0x7a, 0x55, 0x17, 0xa1, 0x7d, 0x9d, 0x59, 0x89, 0x2a, 0xbb, 0xd7, 0x1a, 0x77, 0xbe, 0x42,
	0xc6, 0x9b, 0x73, 0x7b, 0xa1, 0x74, 0xf7, 0xef, 0x15, 0x0b, 0x98, 0x97, 0xde, 0x31, 0x1e, 0x64,
	0xa5, 0x8f, 0x6a, 0x3d, 0x29, 0x69, 0x3b, 0xad, 0xd3, 0x71, 0x95, 0x5b, 0x61, 0x1e, 0xd3, 0xd2,
	0x5a, 0x8d, 0xc5, 0x33, 0xbb, 0x3e, 0xca, 0x4b, 0x5a, 0xb1, 0xcf, 0x90, 0x43, 0xc3, 0xee, 0x27,
	0x1d, 0xac, 0x3a, 0x34, 0x9c, 0x5a, 0x43, 0x77, 0xb9, 0x72, 0x83, 0xf6, 0xb3, 0x1b, 0xbf, 0xaf,
	0xbd, 0xde, 0x91, 0x0c, 0x8f, 0x06, 0x38, 0xf2, 0x10, 0x4d, 0x3c, 0xd3, 0x23, 0x51, 0xfe, 0x1e,
	0x98, 0xa3, 0xa8, 0xd5, 0xff, 0x35, 0x9b, 0xca, 0xf8, 0xa6, 0xcf, 0x6c, 0xdb, 0xf6, 0x0f, 0xbd,
	0xb9, 0x2d, 0x80, 0xb6, 0xcb, 0x90, 0x30, 0x33, 0xeb, 0xa0, 0x8d, 0x64, 0x60, 0x76, 0xa6, 0x24,
	0x7d, 0xdb, 0x65, 0xfd, 0x42, 0xd2, 0x3f, 0x68, 0xf7, 0x95, 0xe4, 0xaf, 0xbe, 0x2a, 0xbe, 0x5b,
	0x96, 0xed, 0x32, 0xcb, 0x2a, 0x44, 0x96, 0x75, 0xd0, 0xb6, 0x2c, 0x25, 0x3b, 0x9c, 0xcb, 0xf3,
	0x6c, 0xff, 0x0f, 0x00, 0x00, 0xff, 0xff, 0x1b, 0xaf, 0x67, 0x35, 0x12, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CustomerClientLinkServiceClient is the client API for CustomerClientLinkService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CustomerClientLinkServiceClient interface {
	// Returns the requested CustomerClientLink in full detail.
	GetCustomerClientLink(ctx context.Context, in *GetCustomerClientLinkRequest, opts ...grpc.CallOption) (*resources.CustomerClientLink, error)
	// Creates or updates a customer client link. Operation statuses are returned.
	MutateCustomerClientLink(ctx context.Context, in *MutateCustomerClientLinkRequest, opts ...grpc.CallOption) (*MutateCustomerClientLinkResponse, error)
}

type customerClientLinkServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCustomerClientLinkServiceClient(cc grpc.ClientConnInterface) CustomerClientLinkServiceClient {
	return &customerClientLinkServiceClient{cc}
}

func (c *customerClientLinkServiceClient) GetCustomerClientLink(ctx context.Context, in *GetCustomerClientLinkRequest, opts ...grpc.CallOption) (*resources.CustomerClientLink, error) {
	out := new(resources.CustomerClientLink)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.CustomerClientLinkService/GetCustomerClientLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customerClientLinkServiceClient) MutateCustomerClientLink(ctx context.Context, in *MutateCustomerClientLinkRequest, opts ...grpc.CallOption) (*MutateCustomerClientLinkResponse, error) {
	out := new(MutateCustomerClientLinkResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.CustomerClientLinkService/MutateCustomerClientLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CustomerClientLinkServiceServer is the server API for CustomerClientLinkService service.
type CustomerClientLinkServiceServer interface {
	// Returns the requested CustomerClientLink in full detail.
	GetCustomerClientLink(context.Context, *GetCustomerClientLinkRequest) (*resources.CustomerClientLink, error)
	// Creates or updates a customer client link. Operation statuses are returned.
	MutateCustomerClientLink(context.Context, *MutateCustomerClientLinkRequest) (*MutateCustomerClientLinkResponse, error)
}

// UnimplementedCustomerClientLinkServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCustomerClientLinkServiceServer struct {
}

func (*UnimplementedCustomerClientLinkServiceServer) GetCustomerClientLink(ctx context.Context, req *GetCustomerClientLinkRequest) (*resources.CustomerClientLink, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomerClientLink not implemented")
}
func (*UnimplementedCustomerClientLinkServiceServer) MutateCustomerClientLink(ctx context.Context, req *MutateCustomerClientLinkRequest) (*MutateCustomerClientLinkResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MutateCustomerClientLink not implemented")
}

func RegisterCustomerClientLinkServiceServer(s *grpc.Server, srv CustomerClientLinkServiceServer) {
	s.RegisterService(&_CustomerClientLinkService_serviceDesc, srv)
}

func _CustomerClientLinkService_GetCustomerClientLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomerClientLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerClientLinkServiceServer).GetCustomerClientLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.CustomerClientLinkService/GetCustomerClientLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerClientLinkServiceServer).GetCustomerClientLink(ctx, req.(*GetCustomerClientLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomerClientLinkService_MutateCustomerClientLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateCustomerClientLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerClientLinkServiceServer).MutateCustomerClientLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.CustomerClientLinkService/MutateCustomerClientLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerClientLinkServiceServer).MutateCustomerClientLink(ctx, req.(*MutateCustomerClientLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CustomerClientLinkService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.CustomerClientLinkService",
	HandlerType: (*CustomerClientLinkServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCustomerClientLink",
			Handler:    _CustomerClientLinkService_GetCustomerClientLink_Handler,
		},
		{
			MethodName: "MutateCustomerClientLink",
			Handler:    _CustomerClientLinkService_MutateCustomerClientLink_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/customer_client_link_service.proto",
}
