// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/osconfig/agentendpoint/v1beta/agentendpoint.proto

package agentendpoint

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A request message to receive task notifications.
type ReceiveTaskNotificationRequest struct {
	// Required. This is the GCE instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. The version of the agent making the request.
	AgentVersion         string   `protobuf:"bytes,2,opt,name=agent_version,json=agentVersion,proto3" json:"agent_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReceiveTaskNotificationRequest) Reset()         { *m = ReceiveTaskNotificationRequest{} }
func (m *ReceiveTaskNotificationRequest) String() string { return proto.CompactTextString(m) }
func (*ReceiveTaskNotificationRequest) ProtoMessage()    {}
func (*ReceiveTaskNotificationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{0}
}

func (m *ReceiveTaskNotificationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiveTaskNotificationRequest.Unmarshal(m, b)
}
func (m *ReceiveTaskNotificationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiveTaskNotificationRequest.Marshal(b, m, deterministic)
}
func (m *ReceiveTaskNotificationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiveTaskNotificationRequest.Merge(m, src)
}
func (m *ReceiveTaskNotificationRequest) XXX_Size() int {
	return xxx_messageInfo_ReceiveTaskNotificationRequest.Size(m)
}
func (m *ReceiveTaskNotificationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiveTaskNotificationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiveTaskNotificationRequest proto.InternalMessageInfo

func (m *ReceiveTaskNotificationRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

func (m *ReceiveTaskNotificationRequest) GetAgentVersion() string {
	if m != nil {
		return m.AgentVersion
	}
	return ""
}

// The streaming rpc message that notifies the agent when it has a task
// that it needs to perform on the VM instance.
type ReceiveTaskNotificationResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReceiveTaskNotificationResponse) Reset()         { *m = ReceiveTaskNotificationResponse{} }
func (m *ReceiveTaskNotificationResponse) String() string { return proto.CompactTextString(m) }
func (*ReceiveTaskNotificationResponse) ProtoMessage()    {}
func (*ReceiveTaskNotificationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{1}
}

func (m *ReceiveTaskNotificationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReceiveTaskNotificationResponse.Unmarshal(m, b)
}
func (m *ReceiveTaskNotificationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReceiveTaskNotificationResponse.Marshal(b, m, deterministic)
}
func (m *ReceiveTaskNotificationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReceiveTaskNotificationResponse.Merge(m, src)
}
func (m *ReceiveTaskNotificationResponse) XXX_Size() int {
	return xxx_messageInfo_ReceiveTaskNotificationResponse.Size(m)
}
func (m *ReceiveTaskNotificationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReceiveTaskNotificationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReceiveTaskNotificationResponse proto.InternalMessageInfo

// A request message for signaling the start of a task execution.
type StartNextTaskRequest struct {
	// Required. This is the GCE instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken      string   `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartNextTaskRequest) Reset()         { *m = StartNextTaskRequest{} }
func (m *StartNextTaskRequest) String() string { return proto.CompactTextString(m) }
func (*StartNextTaskRequest) ProtoMessage()    {}
func (*StartNextTaskRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{2}
}

func (m *StartNextTaskRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartNextTaskRequest.Unmarshal(m, b)
}
func (m *StartNextTaskRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartNextTaskRequest.Marshal(b, m, deterministic)
}
func (m *StartNextTaskRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartNextTaskRequest.Merge(m, src)
}
func (m *StartNextTaskRequest) XXX_Size() int {
	return xxx_messageInfo_StartNextTaskRequest.Size(m)
}
func (m *StartNextTaskRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartNextTaskRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartNextTaskRequest proto.InternalMessageInfo

func (m *StartNextTaskRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

// A response message that contains the details of the task to work on.
type StartNextTaskResponse struct {
	// The details of the task that should be worked on.  Can be empty if there
	// is no new task to work on.
	Task                 *Task    `protobuf:"bytes,1,opt,name=task,proto3" json:"task,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartNextTaskResponse) Reset()         { *m = StartNextTaskResponse{} }
func (m *StartNextTaskResponse) String() string { return proto.CompactTextString(m) }
func (*StartNextTaskResponse) ProtoMessage()    {}
func (*StartNextTaskResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{3}
}

func (m *StartNextTaskResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartNextTaskResponse.Unmarshal(m, b)
}
func (m *StartNextTaskResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartNextTaskResponse.Marshal(b, m, deterministic)
}
func (m *StartNextTaskResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartNextTaskResponse.Merge(m, src)
}
func (m *StartNextTaskResponse) XXX_Size() int {
	return xxx_messageInfo_StartNextTaskResponse.Size(m)
}
func (m *StartNextTaskResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StartNextTaskResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StartNextTaskResponse proto.InternalMessageInfo

func (m *StartNextTaskResponse) GetTask() *Task {
	if m != nil {
		return m.Task
	}
	return nil
}

// A request message for reporting the progress of current task.
type ReportTaskProgressRequest struct {
	// Required. This is the GCE instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. Unique identifier of the task this applies to.
	TaskId string `protobuf:"bytes,2,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Required. The type of task to report progress on.
	//
	// Progress must include the appropriate message based on this enum as
	// specified below:
	// APPLY_PATCHES = ApplyPatchesTaskProgress
	// EXEC_STEP = Progress not supported for this type.
	TaskType TaskType `protobuf:"varint,3,opt,name=task_type,json=taskType,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.TaskType" json:"task_type,omitempty"`
	// Intermediate progress of the current task.
	//
	// Types that are valid to be assigned to Progress:
	//	*ReportTaskProgressRequest_ApplyPatchesTaskProgress
	//	*ReportTaskProgressRequest_ExecStepTaskProgress
	Progress             isReportTaskProgressRequest_Progress `protobuf_oneof:"progress"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *ReportTaskProgressRequest) Reset()         { *m = ReportTaskProgressRequest{} }
func (m *ReportTaskProgressRequest) String() string { return proto.CompactTextString(m) }
func (*ReportTaskProgressRequest) ProtoMessage()    {}
func (*ReportTaskProgressRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{4}
}

func (m *ReportTaskProgressRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskProgressRequest.Unmarshal(m, b)
}
func (m *ReportTaskProgressRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskProgressRequest.Marshal(b, m, deterministic)
}
func (m *ReportTaskProgressRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskProgressRequest.Merge(m, src)
}
func (m *ReportTaskProgressRequest) XXX_Size() int {
	return xxx_messageInfo_ReportTaskProgressRequest.Size(m)
}
func (m *ReportTaskProgressRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskProgressRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskProgressRequest proto.InternalMessageInfo

func (m *ReportTaskProgressRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

func (m *ReportTaskProgressRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func (m *ReportTaskProgressRequest) GetTaskType() TaskType {
	if m != nil {
		return m.TaskType
	}
	return TaskType_TASK_TYPE_UNSPECIFIED
}

type isReportTaskProgressRequest_Progress interface {
	isReportTaskProgressRequest_Progress()
}

type ReportTaskProgressRequest_ApplyPatchesTaskProgress struct {
	ApplyPatchesTaskProgress *ApplyPatchesTaskProgress `protobuf:"bytes,4,opt,name=apply_patches_task_progress,json=applyPatchesTaskProgress,proto3,oneof"`
}

type ReportTaskProgressRequest_ExecStepTaskProgress struct {
	ExecStepTaskProgress *ExecStepTaskProgress `protobuf:"bytes,5,opt,name=exec_step_task_progress,json=execStepTaskProgress,proto3,oneof"`
}

func (*ReportTaskProgressRequest_ApplyPatchesTaskProgress) isReportTaskProgressRequest_Progress() {}

func (*ReportTaskProgressRequest_ExecStepTaskProgress) isReportTaskProgressRequest_Progress() {}

func (m *ReportTaskProgressRequest) GetProgress() isReportTaskProgressRequest_Progress {
	if m != nil {
		return m.Progress
	}
	return nil
}

func (m *ReportTaskProgressRequest) GetApplyPatchesTaskProgress() *ApplyPatchesTaskProgress {
	if x, ok := m.GetProgress().(*ReportTaskProgressRequest_ApplyPatchesTaskProgress); ok {
		return x.ApplyPatchesTaskProgress
	}
	return nil
}

func (m *ReportTaskProgressRequest) GetExecStepTaskProgress() *ExecStepTaskProgress {
	if x, ok := m.GetProgress().(*ReportTaskProgressRequest_ExecStepTaskProgress); ok {
		return x.ExecStepTaskProgress
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReportTaskProgressRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReportTaskProgressRequest_ApplyPatchesTaskProgress)(nil),
		(*ReportTaskProgressRequest_ExecStepTaskProgress)(nil),
	}
}

// The response message after the agent reported the current task progress.
type ReportTaskProgressResponse struct {
	// Instructs agent to continue or not.
	TaskDirective        TaskDirective `protobuf:"varint,1,opt,name=task_directive,json=taskDirective,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.TaskDirective" json:"task_directive,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ReportTaskProgressResponse) Reset()         { *m = ReportTaskProgressResponse{} }
func (m *ReportTaskProgressResponse) String() string { return proto.CompactTextString(m) }
func (*ReportTaskProgressResponse) ProtoMessage()    {}
func (*ReportTaskProgressResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{5}
}

func (m *ReportTaskProgressResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskProgressResponse.Unmarshal(m, b)
}
func (m *ReportTaskProgressResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskProgressResponse.Marshal(b, m, deterministic)
}
func (m *ReportTaskProgressResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskProgressResponse.Merge(m, src)
}
func (m *ReportTaskProgressResponse) XXX_Size() int {
	return xxx_messageInfo_ReportTaskProgressResponse.Size(m)
}
func (m *ReportTaskProgressResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskProgressResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskProgressResponse proto.InternalMessageInfo

func (m *ReportTaskProgressResponse) GetTaskDirective() TaskDirective {
	if m != nil {
		return m.TaskDirective
	}
	return TaskDirective_TASK_DIRECTIVE_UNSPECIFIED
}

// A request message for signaling the completion of a task execution.
type ReportTaskCompleteRequest struct {
	// Required. This is the GCE instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. Unique identifier of the task this applies to.
	TaskId string `protobuf:"bytes,2,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Required. The type of task to report completed.
	//
	// The output must include the appropriate message based on the following
	// enum values:
	// APPLY_PATCHES = ApplyPatchesTaskOutput
	// EXEC_STEP = ExecStepTaskOutput
	TaskType TaskType `protobuf:"varint,3,opt,name=task_type,json=taskType,proto3,enum=google.cloud.osconfig.agentendpoint.v1beta.TaskType" json:"task_type,omitempty"`
	// Descriptive error message if the task execution ended in error.
	ErrorMessage string `protobuf:"bytes,4,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Final output details of the current task.
	//
	// Types that are valid to be assigned to Output:
	//	*ReportTaskCompleteRequest_ApplyPatchesTaskOutput
	//	*ReportTaskCompleteRequest_ExecStepTaskOutput
	Output               isReportTaskCompleteRequest_Output `protobuf_oneof:"output"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ReportTaskCompleteRequest) Reset()         { *m = ReportTaskCompleteRequest{} }
func (m *ReportTaskCompleteRequest) String() string { return proto.CompactTextString(m) }
func (*ReportTaskCompleteRequest) ProtoMessage()    {}
func (*ReportTaskCompleteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{6}
}

func (m *ReportTaskCompleteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskCompleteRequest.Unmarshal(m, b)
}
func (m *ReportTaskCompleteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskCompleteRequest.Marshal(b, m, deterministic)
}
func (m *ReportTaskCompleteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskCompleteRequest.Merge(m, src)
}
func (m *ReportTaskCompleteRequest) XXX_Size() int {
	return xxx_messageInfo_ReportTaskCompleteRequest.Size(m)
}
func (m *ReportTaskCompleteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskCompleteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskCompleteRequest proto.InternalMessageInfo

func (m *ReportTaskCompleteRequest) GetInstanceIdToken() string {
	if m != nil {
		return m.InstanceIdToken
	}
	return ""
}

func (m *ReportTaskCompleteRequest) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func (m *ReportTaskCompleteRequest) GetTaskType() TaskType {
	if m != nil {
		return m.TaskType
	}
	return TaskType_TASK_TYPE_UNSPECIFIED
}

func (m *ReportTaskCompleteRequest) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

type isReportTaskCompleteRequest_Output interface {
	isReportTaskCompleteRequest_Output()
}

type ReportTaskCompleteRequest_ApplyPatchesTaskOutput struct {
	ApplyPatchesTaskOutput *ApplyPatchesTaskOutput `protobuf:"bytes,5,opt,name=apply_patches_task_output,json=applyPatchesTaskOutput,proto3,oneof"`
}

type ReportTaskCompleteRequest_ExecStepTaskOutput struct {
	ExecStepTaskOutput *ExecStepTaskOutput `protobuf:"bytes,6,opt,name=exec_step_task_output,json=execStepTaskOutput,proto3,oneof"`
}

func (*ReportTaskCompleteRequest_ApplyPatchesTaskOutput) isReportTaskCompleteRequest_Output() {}

func (*ReportTaskCompleteRequest_ExecStepTaskOutput) isReportTaskCompleteRequest_Output() {}

func (m *ReportTaskCompleteRequest) GetOutput() isReportTaskCompleteRequest_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (m *ReportTaskCompleteRequest) GetApplyPatchesTaskOutput() *ApplyPatchesTaskOutput {
	if x, ok := m.GetOutput().(*ReportTaskCompleteRequest_ApplyPatchesTaskOutput); ok {
		return x.ApplyPatchesTaskOutput
	}
	return nil
}

func (m *ReportTaskCompleteRequest) GetExecStepTaskOutput() *ExecStepTaskOutput {
	if x, ok := m.GetOutput().(*ReportTaskCompleteRequest_ExecStepTaskOutput); ok {
		return x.ExecStepTaskOutput
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ReportTaskCompleteRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ReportTaskCompleteRequest_ApplyPatchesTaskOutput)(nil),
		(*ReportTaskCompleteRequest_ExecStepTaskOutput)(nil),
	}
}

// The response message after the agent signaled the current task complete.
type ReportTaskCompleteResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReportTaskCompleteResponse) Reset()         { *m = ReportTaskCompleteResponse{} }
func (m *ReportTaskCompleteResponse) String() string { return proto.CompactTextString(m) }
func (*ReportTaskCompleteResponse) ProtoMessage()    {}
func (*ReportTaskCompleteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5f4dbeb1b15ec34f, []int{7}
}

func (m *ReportTaskCompleteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReportTaskCompleteResponse.Unmarshal(m, b)
}
func (m *ReportTaskCompleteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReportTaskCompleteResponse.Marshal(b, m, deterministic)
}
func (m *ReportTaskCompleteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportTaskCompleteResponse.Merge(m, src)
}
func (m *ReportTaskCompleteResponse) XXX_Size() int {
	return xxx_messageInfo_ReportTaskCompleteResponse.Size(m)
}
func (m *ReportTaskCompleteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportTaskCompleteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReportTaskCompleteResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*ReceiveTaskNotificationRequest)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReceiveTaskNotificationRequest")
	proto.RegisterType((*ReceiveTaskNotificationResponse)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReceiveTaskNotificationResponse")
	proto.RegisterType((*StartNextTaskRequest)(nil), "google.cloud.osconfig.agentendpoint.v1beta.StartNextTaskRequest")
	proto.RegisterType((*StartNextTaskResponse)(nil), "google.cloud.osconfig.agentendpoint.v1beta.StartNextTaskResponse")
	proto.RegisterType((*ReportTaskProgressRequest)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReportTaskProgressRequest")
	proto.RegisterType((*ReportTaskProgressResponse)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReportTaskProgressResponse")
	proto.RegisterType((*ReportTaskCompleteRequest)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReportTaskCompleteRequest")
	proto.RegisterType((*ReportTaskCompleteResponse)(nil), "google.cloud.osconfig.agentendpoint.v1beta.ReportTaskCompleteResponse")
}

func init() {
	proto.RegisterFile("google/cloud/osconfig/agentendpoint/v1beta/agentendpoint.proto", fileDescriptor_5f4dbeb1b15ec34f)
}

var fileDescriptor_5f4dbeb1b15ec34f = []byte{
	// 780 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x56, 0x4f, 0x4f, 0xdb, 0x48,
	0x14, 0x8f, 0x81, 0x0d, 0x30, 0x4b, 0x58, 0xed, 0x08, 0x36, 0xc1, 0x8b, 0x16, 0xd6, 0x7b, 0x41,
	0x7b, 0xb0, 0xd9, 0xec, 0x6a, 0xa5, 0xd5, 0x4a, 0xec, 0x26, 0x25, 0x05, 0xda, 0x42, 0x23, 0x83,
	0xa8, 0x54, 0xa9, 0x72, 0x07, 0xfb, 0xc5, 0x8c, 0x62, 0x3c, 0x53, 0xcf, 0x24, 0x22, 0xaa, 0xd4,
	0x9e, 0xda, 0x8f, 0xd0, 0x6b, 0x4f, 0x3d, 0xf7, 0xd6, 0x0f, 0xd1, 0x5b, 0xbf, 0x41, 0x6f, 0xfd,
	0x1a, 0x95, 0xc7, 0x36, 0x24, 0x21, 0xa9, 0x70, 0xe8, 0xa5, 0xa7, 0x28, 0xef, 0xcd, 0xfb, 0xfd,
	0x7e, 0x7e, 0xef, 0x37, 0x7f, 0xd0, 0x96, 0xcf, 0x98, 0x1f, 0x80, 0xe5, 0x06, 0xac, 0xe3, 0x59,
	0x4c, 0xb8, 0x2c, 0x6c, 0x51, 0xdf, 0x22, 0x3e, 0x84, 0x12, 0x42, 0x8f, 0x33, 0x1a, 0x4a, 0xab,
	0xfb, 0xc7, 0x09, 0x48, 0x32, 0x18, 0x34, 0x79, 0xc4, 0x24, 0xc3, 0xbf, 0x27, 0xf5, 0xa6, 0xaa,
	0x37, 0xb3, 0x7a, 0x73, 0x70, 0x69, 0x52, 0xaf, 0xaf, 0xa5, 0x5c, 0x84, 0x53, 0xab, 0x45, 0x21,
	0xf0, 0x9c, 0x13, 0x38, 0x25, 0x5d, 0xca, 0xa2, 0x04, 0x4c, 0xff, 0x2f, 0x87, 0x18, 0xbf, 0x03,
	0x42, 0x3a, 0x9c, 0x05, 0xd4, 0xa5, 0x20, 0x52, 0x80, 0xbf, 0x73, 0x00, 0x48, 0x22, 0xda, 0x59,
	0x5d, 0xb9, 0x4f, 0x99, 0x1b, 0x50, 0xc8, 0x3e, 0xcf, 0x78, 0x8a, 0x7e, 0xb1, 0xc1, 0x05, 0xda,
	0x85, 0x23, 0x22, 0xda, 0x07, 0x4c, 0xd2, 0x16, 0x75, 0x89, 0xa4, 0x2c, 0xb4, 0xe1, 0x49, 0xac,
	0x00, 0x5b, 0xe8, 0x47, 0x1a, 0x0a, 0x49, 0x42, 0x17, 0x1c, 0xea, 0x39, 0x92, 0xb5, 0x21, 0xac,
	0x68, 0xeb, 0xda, 0xc6, 0x7c, 0x7d, 0xfa, 0x63, 0x6d, 0xca, 0xfe, 0x21, 0xcb, 0xee, 0x79, 0x47,
	0x71, 0x0e, 0x6f, 0xa0, 0x92, 0xd2, 0xe3, 0x74, 0x21, 0x12, 0x94, 0x85, 0x95, 0xa9, 0xcb, 0xc5,
	0x0b, 0x2a, 0x73, 0x9c, 0x24, 0x8c, 0x5f, 0xd1, 0xda, 0x58, 0x72, 0xc1, 0x59, 0x28, 0xc0, 0xd8,
	0x41, 0x4b, 0x87, 0x92, 0x44, 0xf2, 0x00, 0xce, 0x65, 0xbc, 0x68, 0x52, 0x55, 0xc6, 0x23, 0xb4,
	0x3c, 0x04, 0x94, 0x30, 0xe0, 0x6d, 0x34, 0x13, 0x77, 0x4a, 0x15, 0x7f, 0x5f, 0xdd, 0x34, 0xaf,
	0x3f, 0x6f, 0x53, 0xe1, 0xa8, 0x6a, 0xe3, 0xc3, 0x34, 0x5a, 0xb1, 0x81, 0xb3, 0x48, 0x81, 0x37,
	0x23, 0xe6, 0x47, 0x20, 0xc4, 0xc4, 0x3d, 0x5c, 0x45, 0xb3, 0x31, 0xac, 0x43, 0xbd, 0xfe, 0xee,
	0x15, 0xe3, 0xd8, 0x9e, 0x87, 0x8f, 0xd1, 0xbc, 0xca, 0xca, 0x1e, 0x87, 0xca, 0xf4, 0xba, 0xb6,
	0xb1, 0x58, 0xfd, 0x2b, 0xaf, 0xee, 0xa3, 0x1e, 0x87, 0x04, 0x75, 0x4e, 0xa6, 0x7f, 0xf1, 0x0b,
	0x0d, 0xfd, 0x4c, 0x38, 0x0f, 0x7a, 0x0e, 0x27, 0xd2, 0x3d, 0x05, 0xe1, 0x28, 0x1a, 0x9e, 0x7e,
	0x4d, 0x65, 0x46, 0xb5, 0x68, 0x3b, 0x0f, 0x55, 0x2d, 0x86, 0x6b, 0x26, 0x68, 0xfd, 0x9d, 0xd9,
	0x2d, 0xd8, 0x15, 0x32, 0x26, 0x87, 0x7b, 0xa8, 0x0c, 0xe7, 0xe0, 0x3a, 0x42, 0x02, 0x1f, 0x92,
	0xf0, 0x9d, 0x92, 0xf0, 0x7f, 0x1e, 0x09, 0x8d, 0x73, 0x70, 0x0f, 0x25, 0xf0, 0x21, 0xfa, 0x25,
	0x18, 0x11, 0xaf, 0x23, 0x34, 0x97, 0x71, 0x19, 0xcf, 0x90, 0x3e, 0x6a, 0xa4, 0xa9, 0x6f, 0x1e,
	0xa3, 0x45, 0x25, 0xcd, 0xa3, 0x11, 0xb8, 0x92, 0x76, 0x41, 0x0d, 0x74, 0xb1, 0xfa, 0x4f, 0xde,
	0x49, 0x6c, 0x67, 0x00, 0x76, 0x49, 0xf6, 0xff, 0x35, 0x3e, 0x0d, 0x78, 0xea, 0x16, 0x3b, 0xe3,
	0x01, 0x48, 0xf8, 0xc6, 0x3c, 0xf5, 0x1b, 0x2a, 0x41, 0x14, 0xb1, 0xc8, 0x39, 0x03, 0x21, 0x88,
	0x0f, 0xca, 0x44, 0xf3, 0xf6, 0x82, 0x0a, 0xee, 0x27, 0x31, 0xfc, 0x1c, 0xad, 0x8c, 0xf0, 0x1d,
	0xeb, 0x48, 0xde, 0x91, 0xe9, 0xc8, 0xeb, 0x37, 0x71, 0xdd, 0x7d, 0x85, 0xb4, 0x5b, 0xb0, 0x7f,
	0x22, 0x23, 0x33, 0x58, 0xa0, 0xe5, 0x21, 0xc7, 0xa5, 0xe4, 0x45, 0x45, 0xbe, 0x35, 0xa9, 0xdf,
	0x2e, 0x88, 0x31, 0x5c, 0x89, 0xd6, 0xe7, 0x50, 0x31, 0x61, 0x31, 0x56, 0xfb, 0x9d, 0x76, 0x39,
	0xe8, 0xc4, 0x69, 0xd5, 0x97, 0xb3, 0x68, 0xa9, 0x16, 0x33, 0x35, 0x52, 0xa6, 0x43, 0x88, 0xba,
	0xd4, 0x05, 0xfc, 0x4e, 0x43, 0xe5, 0x31, 0x07, 0x28, 0xbe, 0x93, 0x47, 0xf2, 0x97, 0xaf, 0x00,
	0xfd, 0xee, 0x57, 0xc1, 0x4a, 0x4f, 0xf4, 0xc2, 0xa6, 0x86, 0x5f, 0x69, 0xa8, 0x34, 0x70, 0x1a,
	0xe3, 0x5c, 0x3b, 0x7a, 0xd4, 0x8d, 0xa0, 0xd7, 0x6e, 0x80, 0x90, 0x49, 0xc3, 0x6f, 0x34, 0x84,
	0xaf, 0xee, 0x79, 0xdc, 0xc8, 0xd7, 0x80, 0x31, 0xd7, 0x80, 0x7e, 0xfb, 0xa6, 0x30, 0x63, 0x74,
	0x66, 0x8e, 0x99, 0x54, 0xe7, 0xd0, 0xd1, 0x32, 0xa9, 0xce, 0x61, 0xe3, 0x1a, 0x05, 0xfc, 0x56,
	0x43, 0xfa, 0x3d, 0xc6, 0xda, 0x1d, 0xde, 0x68, 0xb5, 0x92, 0x63, 0x6d, 0x27, 0xa6, 0x68, 0xc6,
	0xcf, 0x9a, 0x1e, 0xde, 0xcf, 0x43, 0x34, 0x1e, 0x27, 0xd3, 0x9d, 0xef, 0x5a, 0x18, 0x01, 0x64,
	0x14, 0x74, 0xfd, 0x7d, 0xad, 0x7c, 0x51, 0x98, 0xc0, 0x11, 0x4e, 0x85, 0xe9, 0xb2, 0xb3, 0xfa,
	0x6b, 0x0d, 0xc5, 0xbf, 0x39, 0x58, 0xea, 0x78, 0x60, 0xe3, 0x36, 0xe3, 0x37, 0x57, 0x53, 0x7b,
	0xf8, 0x20, 0x45, 0xf0, 0x59, 0x40, 0x42, 0xdf, 0x64, 0x91, 0x6f, 0xf9, 0x10, 0xaa, 0x17, 0x99,
	0x75, 0xc9, 0x79, 0x9d, 0x57, 0xde, 0xbf, 0x03, 0xc1, 0x93, 0xa2, 0xc2, 0xf8, 0xf3, 0x73, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x5d, 0x3f, 0xd8, 0x3d, 0xf6, 0x0a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AgentEndpointServiceClient is the client API for AgentEndpointService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentEndpointServiceClient interface {
	// Stream established by client to receive Task notifications.
	ReceiveTaskNotification(ctx context.Context, in *ReceiveTaskNotificationRequest, opts ...grpc.CallOption) (AgentEndpointService_ReceiveTaskNotificationClient, error)
	// Signals the start of a task execution and returns the task info.
	StartNextTask(ctx context.Context, in *StartNextTaskRequest, opts ...grpc.CallOption) (*StartNextTaskResponse, error)
	// Signals an intermediary progress checkpoint in task execution.
	ReportTaskProgress(ctx context.Context, in *ReportTaskProgressRequest, opts ...grpc.CallOption) (*ReportTaskProgressResponse, error)
	// Signals that the task execution is complete and optionally returns the next
	// task.
	ReportTaskComplete(ctx context.Context, in *ReportTaskCompleteRequest, opts ...grpc.CallOption) (*ReportTaskCompleteResponse, error)
	// Lookup the effective guest policy that applies to a VM instance. This
	// lookup merges all policies that are assigned to the instance ancestry.
	LookupEffectiveGuestPolicy(ctx context.Context, in *LookupEffectiveGuestPolicyRequest, opts ...grpc.CallOption) (*EffectiveGuestPolicy, error)
}

type agentEndpointServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAgentEndpointServiceClient(cc grpc.ClientConnInterface) AgentEndpointServiceClient {
	return &agentEndpointServiceClient{cc}
}

func (c *agentEndpointServiceClient) ReceiveTaskNotification(ctx context.Context, in *ReceiveTaskNotificationRequest, opts ...grpc.CallOption) (AgentEndpointService_ReceiveTaskNotificationClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AgentEndpointService_serviceDesc.Streams[0], "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/ReceiveTaskNotification", opts...)
	if err != nil {
		return nil, err
	}
	x := &agentEndpointServiceReceiveTaskNotificationClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AgentEndpointService_ReceiveTaskNotificationClient interface {
	Recv() (*ReceiveTaskNotificationResponse, error)
	grpc.ClientStream
}

type agentEndpointServiceReceiveTaskNotificationClient struct {
	grpc.ClientStream
}

func (x *agentEndpointServiceReceiveTaskNotificationClient) Recv() (*ReceiveTaskNotificationResponse, error) {
	m := new(ReceiveTaskNotificationResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *agentEndpointServiceClient) StartNextTask(ctx context.Context, in *StartNextTaskRequest, opts ...grpc.CallOption) (*StartNextTaskResponse, error) {
	out := new(StartNextTaskResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/StartNextTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) ReportTaskProgress(ctx context.Context, in *ReportTaskProgressRequest, opts ...grpc.CallOption) (*ReportTaskProgressResponse, error) {
	out := new(ReportTaskProgressResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/ReportTaskProgress", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) ReportTaskComplete(ctx context.Context, in *ReportTaskCompleteRequest, opts ...grpc.CallOption) (*ReportTaskCompleteResponse, error) {
	out := new(ReportTaskCompleteResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/ReportTaskComplete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) LookupEffectiveGuestPolicy(ctx context.Context, in *LookupEffectiveGuestPolicyRequest, opts ...grpc.CallOption) (*EffectiveGuestPolicy, error) {
	out := new(EffectiveGuestPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/LookupEffectiveGuestPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentEndpointServiceServer is the server API for AgentEndpointService service.
type AgentEndpointServiceServer interface {
	// Stream established by client to receive Task notifications.
	ReceiveTaskNotification(*ReceiveTaskNotificationRequest, AgentEndpointService_ReceiveTaskNotificationServer) error
	// Signals the start of a task execution and returns the task info.
	StartNextTask(context.Context, *StartNextTaskRequest) (*StartNextTaskResponse, error)
	// Signals an intermediary progress checkpoint in task execution.
	ReportTaskProgress(context.Context, *ReportTaskProgressRequest) (*ReportTaskProgressResponse, error)
	// Signals that the task execution is complete and optionally returns the next
	// task.
	ReportTaskComplete(context.Context, *ReportTaskCompleteRequest) (*ReportTaskCompleteResponse, error)
	// Lookup the effective guest policy that applies to a VM instance. This
	// lookup merges all policies that are assigned to the instance ancestry.
	LookupEffectiveGuestPolicy(context.Context, *LookupEffectiveGuestPolicyRequest) (*EffectiveGuestPolicy, error)
}

// UnimplementedAgentEndpointServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAgentEndpointServiceServer struct {
}

func (*UnimplementedAgentEndpointServiceServer) ReceiveTaskNotification(req *ReceiveTaskNotificationRequest, srv AgentEndpointService_ReceiveTaskNotificationServer) error {
	return status.Errorf(codes.Unimplemented, "method ReceiveTaskNotification not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) StartNextTask(ctx context.Context, req *StartNextTaskRequest) (*StartNextTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartNextTask not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) ReportTaskProgress(ctx context.Context, req *ReportTaskProgressRequest) (*ReportTaskProgressResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportTaskProgress not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) ReportTaskComplete(ctx context.Context, req *ReportTaskCompleteRequest) (*ReportTaskCompleteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportTaskComplete not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) LookupEffectiveGuestPolicy(ctx context.Context, req *LookupEffectiveGuestPolicyRequest) (*EffectiveGuestPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupEffectiveGuestPolicy not implemented")
}

func RegisterAgentEndpointServiceServer(s *grpc.Server, srv AgentEndpointServiceServer) {
	s.RegisterService(&_AgentEndpointService_serviceDesc, srv)
}

func _AgentEndpointService_ReceiveTaskNotification_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReceiveTaskNotificationRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AgentEndpointServiceServer).ReceiveTaskNotification(m, &agentEndpointServiceReceiveTaskNotificationServer{stream})
}

type AgentEndpointService_ReceiveTaskNotificationServer interface {
	Send(*ReceiveTaskNotificationResponse) error
	grpc.ServerStream
}

type agentEndpointServiceReceiveTaskNotificationServer struct {
	grpc.ServerStream
}

func (x *agentEndpointServiceReceiveTaskNotificationServer) Send(m *ReceiveTaskNotificationResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _AgentEndpointService_StartNextTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartNextTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).StartNextTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/StartNextTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).StartNextTask(ctx, req.(*StartNextTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_ReportTaskProgress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportTaskProgressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).ReportTaskProgress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/ReportTaskProgress",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).ReportTaskProgress(ctx, req.(*ReportTaskProgressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_ReportTaskComplete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportTaskCompleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).ReportTaskComplete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/ReportTaskComplete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).ReportTaskComplete(ctx, req.(*ReportTaskCompleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_LookupEffectiveGuestPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupEffectiveGuestPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).LookupEffectiveGuestPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService/LookupEffectiveGuestPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).LookupEffectiveGuestPolicy(ctx, req.(*LookupEffectiveGuestPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AgentEndpointService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.osconfig.agentendpoint.v1beta.AgentEndpointService",
	HandlerType: (*AgentEndpointServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "StartNextTask",
			Handler:    _AgentEndpointService_StartNextTask_Handler,
		},
		{
			MethodName: "ReportTaskProgress",
			Handler:    _AgentEndpointService_ReportTaskProgress_Handler,
		},
		{
			MethodName: "ReportTaskComplete",
			Handler:    _AgentEndpointService_ReportTaskComplete_Handler,
		},
		{
			MethodName: "LookupEffectiveGuestPolicy",
			Handler:    _AgentEndpointService_LookupEffectiveGuestPolicy_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReceiveTaskNotification",
			Handler:       _AgentEndpointService_ReceiveTaskNotification_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/osconfig/agentendpoint/v1beta/agentendpoint.proto",
}
