// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/recommendationengine/v1beta1/prediction_service.proto

package recommendationengine

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_struct "github.com/golang/protobuf/ptypes/struct"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for Predict method.
type PredictRequest struct {
	// Required. Full resource name of the format:
	// {name=projects/*/locations/global/catalogs/default_catalog/eventStores/default_event_store/placements/*}
	// The id of the recommendation engine placement. This id is used to identify
	// the set of models that will be used to make the prediction.
	//
	// We currently support three placements with the following IDs by default:
	//
	// * `shopping_cart`: Predicts items frequently bought together with one or
	//   more catalog items in the same shopping session. Commonly displayed after
	//   `add-to-cart` events, on product detail pages, or on the shopping cart
	//   page.
	//
	// * `home_page`: Predicts the next product that a user will most likely
	//   engage with or purchase based on the shopping or viewing history of the
	//   specified `userId` or `visitorId`. For example - Recommendations for you.
	//
	// * `product_detail`: Predicts the next product that a user will most likely
	//   engage with or purchase. The prediction is based on the shopping or
	//   viewing history of the specified `userId` or `visitorId` and its
	//   relevance to a specified `CatalogItem`. Typically used on product detail
	//   pages. For example - More items like this.
	//
	// * `recently_viewed_default`: Returns up to 75 items recently viewed by the
	//   specified `userId` or `visitorId`, most recent ones first. Returns
	//   nothing if neither of them has viewed any items yet. For example -
	//   Recently viewed.
	//
	// The full list of available placements can be seen at
	// https://console.cloud.google.com/recommendation/datafeeds/default_catalog/dashboard
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Context about the user, what they are looking at and what action
	// they took to trigger the predict request. Note that this user event detail
	// won't be ingested to userEvent logs. Thus, a separate userEvent write
	// request is required for event logging.
	UserEvent *UserEvent `protobuf:"bytes,2,opt,name=user_event,json=userEvent,proto3" json:"user_event,omitempty"`
	// Optional. Maximum number of results to return per page. Set this property
	// to the number of prediction results required. If zero, the service will
	// choose a reasonable default.
	PageSize int32 `protobuf:"varint,7,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The previous PredictResponse.next_page_token.
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter for restricting prediction results. Accepts values for
	// tags and the `filterOutOfStockItems` flag.
	//
	//  * Tag expressions. Restricts predictions to items that match all of the
	//    specified tags. Boolean operators `OR` and `NOT` are supported if the
	//    expression is enclosed in parentheses, and must be separated from the
	//    tag values by a space. `-"tagA"` is also supported and is equivalent to
	//    `NOT "tagA"`. Tag values must be double quoted UTF-8 encoded strings
	//    with a size limit of 1 KiB.
	//
	//  * filterOutOfStockItems. Restricts predictions to items that do not have a
	//    stockState value of OUT_OF_STOCK.
	//
	// Examples:
	//
	//  * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
	//  * filterOutOfStockItems  tag=(-"promotional")
	//  * filterOutOfStockItems
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Use dryRun mode for this prediction query. If set to true, a
	// dummy model will be used that returns arbitrary catalog items.
	// Note that the dryRun mode should only be used for testing the API, or if
	// the model is not ready.
	DryRun bool `protobuf:"varint,4,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// Optional. Additional domain specific parameters for the predictions.
	//
	// Allowed values:
	//
	// * `returnCatalogItem`: Boolean. If set to true, the associated catalogItem
	//    object will be returned in the
	//   `PredictResponse.PredictionResult.itemMetadata` object in the method
	//    response.
	// * `returnItemScore`: Boolean. If set to true, the prediction 'score'
	//    corresponding to each returned item will be set in the `metadata`
	//    field in the prediction response. The given 'score' indicates the
	//    probability of an item being clicked/purchased given the user's context
	//    and history.
	Params map[string]*_struct.Value `protobuf:"bytes,6,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The labels for the predict request.
	//
	//  * Label keys can contain lowercase letters, digits and hyphens, must start
	//    with a letter, and must end with a letter or digit.
	//  * Non-zero label values can contain lowercase letters, digits and hyphens,
	//    must start with a letter, and must end with a letter or digit.
	//  * No more than 64 labels can be associated with a given request.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	Labels               map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PredictRequest) Reset()         { *m = PredictRequest{} }
func (m *PredictRequest) String() string { return proto.CompactTextString(m) }
func (*PredictRequest) ProtoMessage()    {}
func (*PredictRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_73deb4cba861f96f, []int{0}
}

func (m *PredictRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictRequest.Unmarshal(m, b)
}
func (m *PredictRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictRequest.Marshal(b, m, deterministic)
}
func (m *PredictRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictRequest.Merge(m, src)
}
func (m *PredictRequest) XXX_Size() int {
	return xxx_messageInfo_PredictRequest.Size(m)
}
func (m *PredictRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PredictRequest proto.InternalMessageInfo

func (m *PredictRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PredictRequest) GetUserEvent() *UserEvent {
	if m != nil {
		return m.UserEvent
	}
	return nil
}

func (m *PredictRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *PredictRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *PredictRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *PredictRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *PredictRequest) GetParams() map[string]*_struct.Value {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *PredictRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Response message for predict method.
type PredictResponse struct {
	// A list of recommended items. The order represents the ranking (from the
	// most relevant item to the least).
	Results []*PredictResponse_PredictionResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// A unique recommendation token. This should be included in the user event
	// logs resulting from this recommendation, which enables accurate attribution
	// of recommendation model performance.
	RecommendationToken string `protobuf:"bytes,2,opt,name=recommendation_token,json=recommendationToken,proto3" json:"recommendation_token,omitempty"`
	// IDs of items in the request that were missing from the catalog.
	ItemsMissingInCatalog []string `protobuf:"bytes,3,rep,name=items_missing_in_catalog,json=itemsMissingInCatalog,proto3" json:"items_missing_in_catalog,omitempty"`
	// True if the dryRun property was set in the request.
	DryRun bool `protobuf:"varint,4,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// Additional domain specific prediction response metadata.
	Metadata map[string]*_struct.Value `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If empty, the list is complete. If nonempty, the token to pass to the next
	// request's PredictRequest.page_token.
	NextPageToken        string   `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PredictResponse) Reset()         { *m = PredictResponse{} }
func (m *PredictResponse) String() string { return proto.CompactTextString(m) }
func (*PredictResponse) ProtoMessage()    {}
func (*PredictResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_73deb4cba861f96f, []int{1}
}

func (m *PredictResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictResponse.Unmarshal(m, b)
}
func (m *PredictResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictResponse.Marshal(b, m, deterministic)
}
func (m *PredictResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictResponse.Merge(m, src)
}
func (m *PredictResponse) XXX_Size() int {
	return xxx_messageInfo_PredictResponse.Size(m)
}
func (m *PredictResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PredictResponse proto.InternalMessageInfo

func (m *PredictResponse) GetResults() []*PredictResponse_PredictionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *PredictResponse) GetRecommendationToken() string {
	if m != nil {
		return m.RecommendationToken
	}
	return ""
}

func (m *PredictResponse) GetItemsMissingInCatalog() []string {
	if m != nil {
		return m.ItemsMissingInCatalog
	}
	return nil
}

func (m *PredictResponse) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *PredictResponse) GetMetadata() map[string]*_struct.Value {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PredictResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// PredictionResult represents the recommendation prediction results.
type PredictResponse_PredictionResult struct {
	// ID of the recommended catalog item
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Additional item metadata / annotations.
	//
	// Possible values:
	//
	// * `catalogItem`: JSON representation of the catalogItem. Will be set if
	//   `returnCatalogItem` is set to true in `PredictRequest.params`.
	// * `score`: Prediction score in double value. Will be set if
	//   `returnItemScore` is set to true in `PredictRequest.params`.
	ItemMetadata         map[string]*_struct.Value `protobuf:"bytes,2,rep,name=item_metadata,json=itemMetadata,proto3" json:"item_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *PredictResponse_PredictionResult) Reset()         { *m = PredictResponse_PredictionResult{} }
func (m *PredictResponse_PredictionResult) String() string { return proto.CompactTextString(m) }
func (*PredictResponse_PredictionResult) ProtoMessage()    {}
func (*PredictResponse_PredictionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_73deb4cba861f96f, []int{1, 0}
}

func (m *PredictResponse_PredictionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictResponse_PredictionResult.Unmarshal(m, b)
}
func (m *PredictResponse_PredictionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictResponse_PredictionResult.Marshal(b, m, deterministic)
}
func (m *PredictResponse_PredictionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictResponse_PredictionResult.Merge(m, src)
}
func (m *PredictResponse_PredictionResult) XXX_Size() int {
	return xxx_messageInfo_PredictResponse_PredictionResult.Size(m)
}
func (m *PredictResponse_PredictionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictResponse_PredictionResult.DiscardUnknown(m)
}

var xxx_messageInfo_PredictResponse_PredictionResult proto.InternalMessageInfo

func (m *PredictResponse_PredictionResult) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PredictResponse_PredictionResult) GetItemMetadata() map[string]*_struct.Value {
	if m != nil {
		return m.ItemMetadata
	}
	return nil
}

func init() {
	proto.RegisterType((*PredictRequest)(nil), "google.cloud.recommendationengine.v1beta1.PredictRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommendationengine.v1beta1.PredictRequest.LabelsEntry")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.recommendationengine.v1beta1.PredictRequest.ParamsEntry")
	proto.RegisterType((*PredictResponse)(nil), "google.cloud.recommendationengine.v1beta1.PredictResponse")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.recommendationengine.v1beta1.PredictResponse.MetadataEntry")
	proto.RegisterType((*PredictResponse_PredictionResult)(nil), "google.cloud.recommendationengine.v1beta1.PredictResponse.PredictionResult")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.recommendationengine.v1beta1.PredictResponse.PredictionResult.ItemMetadataEntry")
}

func init() {
	proto.RegisterFile("google/cloud/recommendationengine/v1beta1/prediction_service.proto", fileDescriptor_73deb4cba861f96f)
}

var fileDescriptor_73deb4cba861f96f = []byte{
	// 835 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xdd, 0x6e, 0xe3, 0x44,
	0x14, 0x96, 0x9d, 0x26, 0x6d, 0xa6, 0x74, 0x7f, 0x86, 0x85, 0x5a, 0x66, 0x25, 0xa2, 0x20, 0xa1,
	0x6c, 0xc5, 0xda, 0x6a, 0x41, 0x82, 0x0d, 0xe2, 0xa2, 0xad, 0x22, 0xa8, 0x60, 0xa5, 0xe2, 0x2e,
	0xbb, 0x80, 0xb4, 0xb2, 0x26, 0xf6, 0xa9, 0x3b, 0xac, 0x3d, 0x63, 0x66, 0xc6, 0x29, 0x59, 0x84,
	0x84, 0xf6, 0x15, 0x78, 0x03, 0x2e, 0x79, 0x0e, 0xae, 0xb8, 0x42, 0x70, 0xc7, 0x15, 0x08, 0x1e,
	0x04, 0x79, 0xc6, 0x4e, 0x9c, 0x92, 0x8b, 0xd0, 0xf6, 0xce, 0x73, 0xbe, 0x33, 0xdf, 0x77, 0xfe,
	0xc6, 0x07, 0x1d, 0x24, 0x9c, 0x27, 0x29, 0xf8, 0x51, 0xca, 0x8b, 0xd8, 0x17, 0x10, 0xf1, 0x2c,
	0x03, 0x16, 0x13, 0x45, 0x39, 0x03, 0x96, 0x50, 0x06, 0xfe, 0x64, 0x77, 0x0c, 0x8a, 0xec, 0xfa,
	0xb9, 0x80, 0x98, 0x46, 0x25, 0x10, 0x4a, 0x10, 0x13, 0x1a, 0x81, 0x97, 0x0b, 0xae, 0x38, 0xbe,
	0x67, 0x38, 0x3c, 0xcd, 0xe1, 0x2d, 0xe3, 0xf0, 0x2a, 0x0e, 0xf7, 0x6e, 0x25, 0x47, 0x72, 0xea,
	0x13, 0xc6, 0xb8, 0xd2, 0x4e, 0xd2, 0x10, 0xb9, 0xaf, 0x37, 0xd0, 0x53, 0x0a, 0x69, 0x1c, 0x8e,
	0xe1, 0x8c, 0x4c, 0x28, 0x17, 0x95, 0xc3, 0x70, 0xf5, 0x68, 0x0b, 0x09, 0x22, 0x84, 0x09, 0x30,
	0x55, 0xdd, 0xad, 0xa5, 0xf5, 0x69, 0x5c, 0x9c, 0xfa, 0x52, 0x89, 0x22, 0xaa, 0xd1, 0xed, 0x86,
	0x74, 0x94, 0xd2, 0xd9, 0xb5, 0xfe, 0x1f, 0x6b, 0xe8, 0xc6, 0xb1, 0xc9, 0x3c, 0x80, 0xaf, 0x0b,
	0x90, 0x0a, 0x6f, 0xa3, 0x35, 0x46, 0x32, 0x70, 0xac, 0x9e, 0x35, 0xe8, 0x1e, 0xb4, 0xfe, 0xdc,
	0xb7, 0x03, 0x6d, 0xc0, 0x9f, 0x23, 0x34, 0x97, 0x75, 0xec, 0x9e, 0x35, 0xd8, 0xdc, 0x7b, 0xc7,
	0x5b, 0xb9, 0x3a, 0xde, 0x67, 0x12, 0xc4, 0xa8, 0xbc, 0x6b, 0x48, 0xbb, 0x45, 0x7d, 0xc6, 0x3d,
	0xd4, 0xcd, 0x49, 0x02, 0xa1, 0xa4, 0xcf, 0xc1, 0x59, 0xef, 0x59, 0x83, 0x76, 0xe9, 0x62, 0x05,
	0x1b, 0xa5, 0xf5, 0x84, 0x3e, 0x07, 0xdc, 0x47, 0x48, 0x7b, 0x28, 0xfe, 0x0c, 0x98, 0xb3, 0x51,
	0x87, 0x66, 0x05, 0xfa, 0xe2, 0xa3, 0xd2, 0x8a, 0x5f, 0x43, 0x9d, 0x53, 0x9a, 0x2a, 0x10, 0x4e,
	0x6b, 0x8e, 0x57, 0x26, 0x7c, 0x17, 0xad, 0xc7, 0x62, 0x1a, 0x8a, 0x82, 0x39, 0x6b, 0x3d, 0x6b,
	0xb0, 0x51, 0xa1, 0xb1, 0x98, 0x06, 0x05, 0xc3, 0x63, 0xd4, 0xc9, 0x89, 0x20, 0x99, 0x74, 0x3a,
	0xbd, 0xd6, 0x60, 0x73, 0x6f, 0xf4, 0x3f, 0xd2, 0x5a, 0x2c, 0x9f, 0x77, 0xac, 0x79, 0x46, 0x4c,
	0x89, 0x69, 0xa5, 0x61, 0x98, 0x4b, 0x8d, 0x94, 0x8c, 0x21, 0x95, 0x4e, 0xf7, 0xaa, 0x1a, 0x9f,
	0x68, 0x9e, 0xa6, 0x86, 0x61, 0x76, 0x3f, 0x45, 0x9b, 0x0d, 0x7d, 0x7c, 0x0b, 0xb5, 0x9e, 0xc1,
	0xd4, 0x74, 0x32, 0x28, 0x3f, 0xf1, 0x5b, 0xa8, 0x3d, 0x21, 0x69, 0x01, 0x55, 0xfb, 0x5e, 0xad,
	0x63, 0xa8, 0xc7, 0xc6, 0x7b, 0x5c, 0xa2, 0x81, 0x71, 0x1a, 0xda, 0xef, 0x59, 0xee, 0x03, 0xb4,
	0xd9, 0x90, 0x5b, 0x42, 0x79, 0xa7, 0x49, 0xd9, 0x6d, 0x5c, 0xed, 0xff, 0xdd, 0x46, 0x37, 0x67,
	0x91, 0xcb, 0x9c, 0x33, 0x09, 0x18, 0xd0, 0xba, 0x00, 0x59, 0xa4, 0x4a, 0x3a, 0x96, 0x2e, 0xc3,
	0xc7, 0x97, 0x29, 0x83, 0x21, 0xab, 0xcf, 0x94, 0xb3, 0x40, 0x73, 0x06, 0x35, 0x37, 0xde, 0x45,
	0x77, 0x16, 0x99, 0xaa, 0xc9, 0x31, 0x31, 0xbe, 0xbc, 0x88, 0x99, 0xf1, 0x79, 0x17, 0x39, 0x54,
	0x41, 0x26, 0xc3, 0x8c, 0x4a, 0x49, 0x59, 0x12, 0x52, 0x16, 0x46, 0x44, 0x91, 0x94, 0x27, 0x4e,
	0xab, 0xd7, 0x1a, 0x74, 0x83, 0x57, 0x34, 0xfe, 0xd0, 0xc0, 0x47, 0xec, 0xd0, 0x80, 0x78, 0xfb,
	0xc2, 0x68, 0xcd, 0xa6, 0x2a, 0x46, 0x1b, 0x19, 0x28, 0x12, 0x13, 0x45, 0x9c, 0xb6, 0x4e, 0xf6,
	0xa3, 0x2b, 0x24, 0xfb, 0xb0, 0xa2, 0xd2, 0x7d, 0x08, 0x66, 0xcc, 0xf8, 0x4d, 0x74, 0x93, 0xc1,
	0x37, 0x2a, 0x6c, 0xbc, 0x8f, 0x8e, 0xce, 0x72, 0xab, 0x34, 0x1f, 0xd7, 0xcf, 0xc3, 0xfd, 0xde,
	0x46, 0xb7, 0x2e, 0x16, 0x0c, 0xdf, 0x40, 0x36, 0x8d, 0xab, 0x6e, 0xda, 0x34, 0xc6, 0x2f, 0x2c,
	0xb4, 0x55, 0x66, 0x19, 0xce, 0x02, 0xb7, 0x75, 0xe0, 0x4f, 0xaf, 0xb1, 0x4b, 0xde, 0x91, 0x82,
	0x6c, 0x31, 0x9b, 0x97, 0x68, 0xc3, 0xe4, 0x3e, 0x41, 0xb7, 0xff, 0xe3, 0x72, 0x2d, 0xb3, 0x7c,
	0x82, 0xb6, 0xae, 0x9d, 0x74, 0xef, 0x57, 0x1b, 0xdd, 0x9e, 0xa7, 0x78, 0x62, 0x76, 0x07, 0xfe,
	0xcb, 0x42, 0xeb, 0x95, 0x15, 0x3f, 0xb8, 0xf4, 0x4b, 0x77, 0x87, 0x97, 0xaf, 0x7b, 0x3f, 0x7c,
	0xf1, 0xfb, 0x3f, 0x3f, 0xd8, 0x5f, 0xf4, 0x1f, 0xcd, 0xb6, 0xc6, 0xb7, 0xe5, 0x7f, 0xfc, 0x83,
	0x5c, 0xf0, 0xaf, 0x20, 0x52, 0xd2, 0xdf, 0xf1, 0x53, 0x1e, 0x99, 0x15, 0xe5, 0xef, 0xf8, 0xd5,
	0xac, 0x97, 0x9f, 0xfa, 0x0f, 0x7f, 0xa2, 0xb8, 0x80, 0xf2, 0x94, 0xa7, 0x24, 0x82, 0x0c, 0x58,
	0x79, 0xe3, 0xbb, 0x61, 0xb5, 0x27, 0x87, 0xd6, 0x8e, 0xfb, 0xe4, 0x97, 0xfd, 0x37, 0x96, 0x46,
	0x64, 0x62, 0x26, 0x39, 0x95, 0x5e, 0xc4, 0xb3, 0xdf, 0xf6, 0xbd, 0x33, 0xa5, 0x72, 0x39, 0xf4,
	0xfd, 0xf3, 0xf3, 0xf3, 0x0b, 0xa0, 0x4f, 0x0a, 0x75, 0x66, 0x36, 0xde, 0xfd, 0x3c, 0x25, 0xea,
	0x94, 0x8b, 0xec, 0xe0, 0x67, 0x0b, 0xdd, 0x8f, 0x78, 0xb6, 0x7a, 0xee, 0xc7, 0xd6, 0x97, 0x4f,
	0x2b, 0xe7, 0x84, 0xa7, 0x84, 0x25, 0x1e, 0x17, 0x89, 0x9f, 0x00, 0xd3, 0x6d, 0xf3, 0xe7, 0x92,
	0x2b, 0xec, 0xd6, 0xf7, 0x97, 0x81, 0x3f, 0xda, 0xed, 0x60, 0x74, 0xb8, 0x7f, 0xf4, 0x93, 0x7d,
	0xef, 0x43, 0xa3, 0x73, 0xa8, 0x83, 0x0a, 0x16, 0x7c, 0x47, 0x26, 0xa8, 0xc7, 0xbb, 0x07, 0x25,
	0xd1, 0xb8, 0xa3, 0xd5, 0xdf, 0xfe, 0x37, 0x00, 0x00, 0xff, 0xff, 0x8f, 0xe7, 0xd7, 0xe8, 0x86,
	0x08, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PredictionServiceClient is the client API for PredictionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PredictionServiceClient interface {
	// Makes a recommendation prediction. If using API Key based authentication,
	// the API Key must be registered using the
	// [PredictionApiKeyRegistry][google.cloud.recommendationengine.v1beta1.PredictionApiKeyRegistry]
	// service. [Learn more](/recommendations-ai/docs/setting-up#register-key).
	Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error)
}

type predictionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPredictionServiceClient(cc grpc.ClientConnInterface) PredictionServiceClient {
	return &predictionServiceClient{cc}
}

func (c *predictionServiceClient) Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error) {
	out := new(PredictResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recommendationengine.v1beta1.PredictionService/Predict", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PredictionServiceServer is the server API for PredictionService service.
type PredictionServiceServer interface {
	// Makes a recommendation prediction. If using API Key based authentication,
	// the API Key must be registered using the
	// [PredictionApiKeyRegistry][google.cloud.recommendationengine.v1beta1.PredictionApiKeyRegistry]
	// service. [Learn more](/recommendations-ai/docs/setting-up#register-key).
	Predict(context.Context, *PredictRequest) (*PredictResponse, error)
}

// UnimplementedPredictionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPredictionServiceServer struct {
}

func (*UnimplementedPredictionServiceServer) Predict(ctx context.Context, req *PredictRequest) (*PredictResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Predict not implemented")
}

func RegisterPredictionServiceServer(s *grpc.Server, srv PredictionServiceServer) {
	s.RegisterService(&_PredictionService_serviceDesc, srv)
}

func _PredictionService_Predict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).Predict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommendationengine.v1beta1.PredictionService/Predict",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).Predict(ctx, req.(*PredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PredictionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recommendationengine.v1beta1.PredictionService",
	HandlerType: (*PredictionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Predict",
			Handler:    _PredictionService_Predict_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recommendationengine/v1beta1/prediction_service.proto",
}
