// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/healthcare/logging/fhir.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A log entry for a FHIR import long-running operation.
type ImportFhirLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source in Cloud Storage (for example,
	// `gs://{bucket_id}/{path/to/file}`) or BigQuery (for example,
	// `bq://{projectId}.{bqDatasetId}`).
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The ID in the source file of the FHIR resource being imported.
	ResourceId string `protobuf:"bytes,2,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ImportFhirLogEntry) Reset() {
	*x = ImportFhirLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_fhir_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportFhirLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportFhirLogEntry) ProtoMessage() {}

func (x *ImportFhirLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_fhir_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportFhirLogEntry.ProtoReflect.Descriptor instead.
func (*ImportFhirLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_fhir_proto_rawDescGZIP(), []int{0}
}

func (x *ImportFhirLogEntry) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *ImportFhirLogEntry) GetResourceId() string {
	if x != nil {
		return x.ResourceId
	}
	return ""
}

func (x *ImportFhirLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A log entry for a FHIR export long-running operation.
type ExportFhirLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The destination in Cloud Storage (for example,
	// `gs://{bucket_id}/{path/to/file}`) or BigQuery (for example,
	// `bq://{projectId}.{bqDatasetId}`).
	Destination string `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// The resource being exported (e.g.
	// `projects/{projectId}/locations/{locationId}/datasets/{datasetId}/fhirStores/{fhirStoreId}/fhir/Patient/{patientId}`).
	ResourceName string `protobuf:"bytes,3,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,4,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *ExportFhirLogEntry) Reset() {
	*x = ExportFhirLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_fhir_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportFhirLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportFhirLogEntry) ProtoMessage() {}

func (x *ExportFhirLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_fhir_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportFhirLogEntry.ProtoReflect.Descriptor instead.
func (*ExportFhirLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_fhir_proto_rawDescGZIP(), []int{1}
}

func (x *ExportFhirLogEntry) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *ExportFhirLogEntry) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *ExportFhirLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A log entry for a FHIR configure search long-running operation
type FhirConfigureSearchLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the resource being reindexed.
	ResourceId string `protobuf:"bytes,1,opt,name=resource_id,json=resourceId,proto3" json:"resource_id,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *FhirConfigureSearchLogEntry) Reset() {
	*x = FhirConfigureSearchLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_fhir_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FhirConfigureSearchLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FhirConfigureSearchLogEntry) ProtoMessage() {}

func (x *FhirConfigureSearchLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_fhir_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FhirConfigureSearchLogEntry.ProtoReflect.Descriptor instead.
func (*FhirConfigureSearchLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_fhir_proto_rawDescGZIP(), []int{2}
}

func (x *FhirConfigureSearchLogEntry) GetResourceId() string {
	if x != nil {
		return x.ResourceId
	}
	return ""
}

func (x *FhirConfigureSearchLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A log entry for a FHIR store Pub/Sub notification.
type FhirNotificationLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource being changed (for example,
	// `projects/{projectId}/locations/{locationId}/datasets/{datasetId}/fhirStores/{fhirStoreId}/fhir/Patient/{patientId}`).
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The Pub/Sub topic that the notification is published on.
	PubsubTopic string `protobuf:"bytes,2,opt,name=pubsub_topic,json=pubsubTopic,proto3" json:"pubsub_topic,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *FhirNotificationLogEntry) Reset() {
	*x = FhirNotificationLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_fhir_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FhirNotificationLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FhirNotificationLogEntry) ProtoMessage() {}

func (x *FhirNotificationLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_fhir_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FhirNotificationLogEntry.ProtoReflect.Descriptor instead.
func (*FhirNotificationLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_fhir_proto_rawDescGZIP(), []int{3}
}

func (x *FhirNotificationLogEntry) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *FhirNotificationLogEntry) GetPubsubTopic() string {
	if x != nil {
		return x.PubsubTopic
	}
	return ""
}

func (x *FhirNotificationLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A log entry for a FHIR streaming export notification.
type FhirStreamLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource being changed (for example,
	// `projects/{projectId}/locations/{locationId}/datasets/{datasetId}/fhirStores/{fhirStoreId}/fhir/Patient/{patientId}`).
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The destination in BigQuery (for example,
	// `bq://{projectId}.{bqDatasetId}.{bqTableId}`).
	Destination string `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *FhirStreamLogEntry) Reset() {
	*x = FhirStreamLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_fhir_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FhirStreamLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FhirStreamLogEntry) ProtoMessage() {}

func (x *FhirStreamLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_fhir_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FhirStreamLogEntry.ProtoReflect.Descriptor instead.
func (*FhirStreamLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_fhir_proto_rawDescGZIP(), []int{4}
}

func (x *FhirStreamLogEntry) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *FhirStreamLogEntry) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *FhirStreamLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A log entry for a FHIR streaming deidentification notification.
type FhirDeidentifyStreamToStoreLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource that changed (for example,
	// `projects/{projectId}/locations/{locationId}/datasets/{datasetId}/fhirStores/{fhirStoreId}/fhir/Patient/{patientId}`).
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The destination FHIR store name. (for example,
	// `projects/{projectId}/locations/{locationId}/datasets/{datasetId}/fhirStores/{fhirStoreId}`).
	Destination string `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// The error code and message.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *FhirDeidentifyStreamToStoreLogEntry) Reset() {
	*x = FhirDeidentifyStreamToStoreLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_healthcare_logging_fhir_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FhirDeidentifyStreamToStoreLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FhirDeidentifyStreamToStoreLogEntry) ProtoMessage() {}

func (x *FhirDeidentifyStreamToStoreLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_healthcare_logging_fhir_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FhirDeidentifyStreamToStoreLogEntry.ProtoReflect.Descriptor instead.
func (*FhirDeidentifyStreamToStoreLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_healthcare_logging_fhir_proto_rawDescGZIP(), []int{5}
}

func (x *FhirDeidentifyStreamToStoreLogEntry) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *FhirDeidentifyStreamToStoreLogEntry) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *FhirDeidentifyStreamToStoreLogEntry) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

var File_google_cloud_healthcare_logging_fhir_proto protoreflect.FileDescriptor

var file_google_cloud_healthcare_logging_fhir_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2f, 0x66, 0x68, 0x69, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x63, 0x61, 0x72, 0x65, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x77, 0x0a, 0x12, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x46, 0x68, 0x69, 0x72, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x16, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22,
	0x85, 0x01, 0x0a, 0x12, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x68, 0x69, 0x72, 0x4c, 0x6f,
	0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x68, 0x0a, 0x1b, 0x46, 0x68, 0x69, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4c, 0x6f,
	0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x22, 0x8c, 0x01, 0x0a, 0x18, 0x46, 0x68, 0x69, 0x72, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x22, 0x85, 0x01, 0x0a, 0x12, 0x46, 0x68, 0x69, 0x72, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4c,
	0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28,
	0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x96, 0x01, 0x0a, 0x23, 0x46, 0x68, 0x69,
	0x72, 0x44, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x54, 0x6f, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x42, 0x6d, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x61, 0x72, 0x65,
	0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_healthcare_logging_fhir_proto_rawDescOnce sync.Once
	file_google_cloud_healthcare_logging_fhir_proto_rawDescData = file_google_cloud_healthcare_logging_fhir_proto_rawDesc
)

func file_google_cloud_healthcare_logging_fhir_proto_rawDescGZIP() []byte {
	file_google_cloud_healthcare_logging_fhir_proto_rawDescOnce.Do(func() {
		file_google_cloud_healthcare_logging_fhir_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_healthcare_logging_fhir_proto_rawDescData)
	})
	return file_google_cloud_healthcare_logging_fhir_proto_rawDescData
}

var file_google_cloud_healthcare_logging_fhir_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_healthcare_logging_fhir_proto_goTypes = []interface{}{
	(*ImportFhirLogEntry)(nil),                  // 0: google.cloud.healthcare.logging.ImportFhirLogEntry
	(*ExportFhirLogEntry)(nil),                  // 1: google.cloud.healthcare.logging.ExportFhirLogEntry
	(*FhirConfigureSearchLogEntry)(nil),         // 2: google.cloud.healthcare.logging.FhirConfigureSearchLogEntry
	(*FhirNotificationLogEntry)(nil),            // 3: google.cloud.healthcare.logging.FhirNotificationLogEntry
	(*FhirStreamLogEntry)(nil),                  // 4: google.cloud.healthcare.logging.FhirStreamLogEntry
	(*FhirDeidentifyStreamToStoreLogEntry)(nil), // 5: google.cloud.healthcare.logging.FhirDeidentifyStreamToStoreLogEntry
	(*status.Status)(nil),                       // 6: google.rpc.Status
}
var file_google_cloud_healthcare_logging_fhir_proto_depIdxs = []int32{
	6, // 0: google.cloud.healthcare.logging.ImportFhirLogEntry.error:type_name -> google.rpc.Status
	6, // 1: google.cloud.healthcare.logging.ExportFhirLogEntry.error:type_name -> google.rpc.Status
	6, // 2: google.cloud.healthcare.logging.FhirConfigureSearchLogEntry.error:type_name -> google.rpc.Status
	6, // 3: google.cloud.healthcare.logging.FhirNotificationLogEntry.error:type_name -> google.rpc.Status
	6, // 4: google.cloud.healthcare.logging.FhirStreamLogEntry.error:type_name -> google.rpc.Status
	6, // 5: google.cloud.healthcare.logging.FhirDeidentifyStreamToStoreLogEntry.error:type_name -> google.rpc.Status
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_healthcare_logging_fhir_proto_init() }
func file_google_cloud_healthcare_logging_fhir_proto_init() {
	if File_google_cloud_healthcare_logging_fhir_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_healthcare_logging_fhir_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportFhirLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_healthcare_logging_fhir_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportFhirLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_healthcare_logging_fhir_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FhirConfigureSearchLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_healthcare_logging_fhir_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FhirNotificationLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_healthcare_logging_fhir_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FhirStreamLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_healthcare_logging_fhir_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FhirDeidentifyStreamToStoreLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_healthcare_logging_fhir_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_healthcare_logging_fhir_proto_goTypes,
		DependencyIndexes: file_google_cloud_healthcare_logging_fhir_proto_depIdxs,
		MessageInfos:      file_google_cloud_healthcare_logging_fhir_proto_msgTypes,
	}.Build()
	File_google_cloud_healthcare_logging_fhir_proto = out.File
	file_google_cloud_healthcare_logging_fhir_proto_rawDesc = nil
	file_google_cloud_healthcare_logging_fhir_proto_goTypes = nil
	file_google_cloud_healthcare_logging_fhir_proto_depIdxs = nil
}
