/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha1 "k8s.io/csi-api/pkg/apis/csi/v1alpha1"
)

// CSINodeInfoLister helps list CSINodeInfos.
type CSINodeInfoLister interface {
	// List lists all CSINodeInfos in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.CSINodeInfo, err error)
	// Get retrieves the CSINodeInfo from the index for a given name.
	Get(name string) (*v1alpha1.CSINodeInfo, error)
	CSINodeInfoListerExpansion
}

// cSINodeInfoLister implements the CSINodeInfoLister interface.
type cSINodeInfoLister struct {
	indexer cache.Indexer
}

// NewCSINodeInfoLister returns a new CSINodeInfoLister.
func NewCSINodeInfoLister(indexer cache.Indexer) CSINodeInfoLister {
	return &cSINodeInfoLister{indexer: indexer}
}

// List lists all CSINodeInfos in the indexer.
func (s *cSINodeInfoLister) List(selector labels.Selector) (ret []*v1alpha1.CSINodeInfo, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.CSINodeInfo))
	})
	return ret, err
}

// Get retrieves the CSINodeInfo from the index for a given name.
func (s *cSINodeInfoLister) Get(name string) (*v1alpha1.CSINodeInfo, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("csinodeinfo"), name)
	}
	return obj.(*v1alpha1.CSINodeInfo), nil
}
