/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha2

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1alpha2 "sigs.k8s.io/gateway-api/apis/v1alpha2"
)

// ReferenceGrantLister helps list ReferenceGrants.
// All objects returned here must be treated as read-only.
type ReferenceGrantLister interface {
	// List lists all ReferenceGrants in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha2.ReferenceGrant, err error)
	// ReferenceGrants returns an object that can list and get ReferenceGrants.
	ReferenceGrants(namespace string) ReferenceGrantNamespaceLister
	ReferenceGrantListerExpansion
}

// referenceGrantLister implements the ReferenceGrantLister interface.
type referenceGrantLister struct {
	indexer cache.Indexer
}

// NewReferenceGrantLister returns a new ReferenceGrantLister.
func NewReferenceGrantLister(indexer cache.Indexer) ReferenceGrantLister {
	return &referenceGrantLister{indexer: indexer}
}

// List lists all ReferenceGrants in the indexer.
func (s *referenceGrantLister) List(selector labels.Selector) (ret []*v1alpha2.ReferenceGrant, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha2.ReferenceGrant))
	})
	return ret, err
}

// ReferenceGrants returns an object that can list and get ReferenceGrants.
func (s *referenceGrantLister) ReferenceGrants(namespace string) ReferenceGrantNamespaceLister {
	return referenceGrantNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ReferenceGrantNamespaceLister helps list and get ReferenceGrants.
// All objects returned here must be treated as read-only.
type ReferenceGrantNamespaceLister interface {
	// List lists all ReferenceGrants in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha2.ReferenceGrant, err error)
	// Get retrieves the ReferenceGrant from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha2.ReferenceGrant, error)
	ReferenceGrantNamespaceListerExpansion
}

// referenceGrantNamespaceLister implements the ReferenceGrantNamespaceLister
// interface.
type referenceGrantNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ReferenceGrants in the indexer for a given namespace.
func (s referenceGrantNamespaceLister) List(selector labels.Selector) (ret []*v1alpha2.ReferenceGrant, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha2.ReferenceGrant))
	})
	return ret, err
}

// Get retrieves the ReferenceGrant from the indexer for a given namespace and name.
func (s referenceGrantNamespaceLister) Get(name string) (*v1alpha2.ReferenceGrant, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha2.Resource("referencegrant"), name)
	}
	return obj.(*v1alpha2.ReferenceGrant), nil
}
