/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.setting.globalswitch;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.OOoO.return;
import com.ubnt.data.GlobalSwitchSettingDefaults;
import com.ubnt.data.Setting;
import com.ubnt.data.StpVersion;
import com.ubnt.model.api.setting.globalswitch.AclNetworkIsolationDto;
import com.ubnt.model.api.setting.globalswitch.ImmutableGlobalSwitchSettingDto;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonSerialize(as=ImmutableGlobalSwitchSettingDto.class)
@JsonDeserialize(builder=ImmutableGlobalSwitchSettingDto.Builder.class)
@Value.Immutable
@return
public interface GlobalSwitchSettingDto {
    @JsonProperty(value="dhcp_snoop")
    public boolean dhcpSnooping();

    @JsonProperty(value="dot1x_fallback_networkconf_id")
    public Optional<String> dot1xFallbackNetworkconfId();

    @JsonProperty(value="dot1x_portctrl_enabled")
    public boolean dot1xPortControlEnabled();

    @JsonProperty(value="flowctrl_enabled")
    public boolean flowControlEnabled();

    @JsonProperty(value="jumboframe_enabled")
    public boolean jumboFrameEnabled();

    @JsonProperty(value="radiusprofile_id")
    public Optional<String> radiusProfileId();

    @JsonProperty(value="stp_version")
    public StpVersion stpVersion();

    @JsonProperty(value="switch_exclusions")
    public List<String> switchExclusions();

    @JsonProperty(value="acl_device_isolation")
    public List<String> aclDeviceIsolation();

    @JsonProperty(value="acl_l3_isolation")
    public List<AclNetworkIsolationDto> aclNetworkIsolation();

    @JsonProperty(value="forward_unknown_mcast_router_ports")
    public boolean forwardUnknownMcastRouterPorts();

    @JsonProperty(value="flood_known_protocols")
    public boolean floodKnownProtocols();

    public static ImmutableGlobalSwitchSettingDto.Builder builder() {
        return ImmutableGlobalSwitchSettingDto.builder();
    }

    public static GlobalSwitchSettingDto fromLegacy(Setting setting) {
        List<AclNetworkIsolationDto> list = setting.getList("acl_l3_isolation").stream().map(AclNetworkIsolationDto::fromLegacy).toList();
        return GlobalSwitchSettingDto.builder().dhcpSnooping(setting.getOptionalBoolean("dhcp_snoop").orElse(true)).dot1xFallbackNetworkconfId(setting.getOptionalString("dot1x_fallback_networkconf_id")).dot1xPortControlEnabled(setting.getOptionalBoolean("dot1x_portctrl_enabled").orElse(false)).flowControlEnabled(setting.getOptionalBoolean("flowctrl_enabled").orElse(false)).jumboFrameEnabled(setting.getOptionalBoolean("jumboframe_enabled").orElse(false)).radiusProfileId(setting.getOptionalString("radiusprofile_id")).stpVersion(setting.getOptionalString("stp_version").flatMap(StpVersion::ofStringValue).orElse(GlobalSwitchSettingDefaults.\u00d500000)).switchExclusions(setting.getStringList("switch_exclusions")).aclDeviceIsolation(setting.getStringList("acl_device_isolation")).aclNetworkIsolation(list).forwardUnknownMcastRouterPorts(setting.getOptionalBoolean("forward_unknown_mcast_router_ports").orElse(true)).floodKnownProtocols(setting.getOptionalBoolean("flood_known_protocols").orElse(true)).build();
    }
}

