/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.common.pattern;

import ch.qos.logback.access.common.pattern.AccessConverter;
import ch.qos.logback.access.common.spi.IAccessEvent;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.time.ZoneId;
import java.util.List;
import java.util.Locale;

public class DateConverter
extends AccessConverter {
    CachingDateFormatter cachingDateFormatter = null;

    public void start() {
        String datePattern = this.getFirstOption();
        if (datePattern == null) {
            datePattern = "dd/MMM/yyyy:HH:mm:ss Z";
        } else if (datePattern.equals("ISO8601")) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        } else if (datePattern.equals("STRICT")) {
            datePattern = "yyyy-MM-dd'T'HH:mm:ss,SSS";
        }
        List optionList = this.getOptionList();
        ZoneId zoneId = null;
        if (optionList != null && optionList.size() > 1) {
            String zoneIdString = (String)optionList.get(1);
            zoneId = ZoneId.of(zoneIdString);
        }
        Locale locale = null;
        if (optionList != null && optionList.size() > 2) {
            String localeIdStr = (String)optionList.get(2);
            locale = Locale.forLanguageTag(localeIdStr);
            this.addInfo("Setting locale to \"" + String.valueOf(locale) + "\"");
        }
        try {
            this.cachingDateFormatter = new CachingDateFormatter(datePattern, zoneId, locale);
        }
        catch (IllegalArgumentException e) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + datePattern, e);
            this.addWarn("Defaulting to  dd/MMM/yyyy:HH:mm:ss Z");
            this.cachingDateFormatter = new CachingDateFormatter("dd/MMM/yyyy:HH:mm:ss Z", zoneId);
        }
        super.start();
    }

    public String convert(IAccessEvent accessEvent) {
        long timestamp = accessEvent.getTimeStamp();
        return this.cachingDateFormatter.format(timestamp);
    }

    @Deprecated
    public CachingDateFormatter internalCachingDateFormatter() {
        return this.cachingDateFormatter;
    }
}

