/* DO NOT EDIT
 * This dissector is autogenerated
 */

/* packet-dcerpc-butc.c
 * Routines for BUTC packet disassembly
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "config.h"

#include <epan/packet.h>
#include <wsutil/array.h>
#include "packet-dcerpc.h"
#include "packet-dcerpc-nt.h"
#include "packet-windows-common.h"
#include "packet-dcerpc-butc.h"

void proto_register_butc(void);
void proto_reg_handoff_butc(void);

static int proto_butc;


/* INCLUDED FILE : ETH_HF */
static int hf_butc_opnum;
static int hf_butc_rc;
static int hf_butc_Restore_flags_TC_RESTORE_CREATE;
static int hf_butc_Restore_flags_TC_RESTORE_INCR;
static int hf_butc_afsNetAddr_type;
static int hf_butc_afsNetAddr_data;
static int hf_butc_tc_dumpDesc_vid;
static int hf_butc_tc_dumpDesc_name;
static int hf_butc_tc_dumpDesc_partition;
static int hf_butc_tc_dumpDesc_date;
static int hf_butc_tc_dumpDesc_cloneDate;
static int hf_butc_tc_dumpDesc_hostAddr;
static int hf_butc_tc_dumpDesc_spare1;
static int hf_butc_tc_dumpDesc_spare2;
static int hf_butc_tc_dumpDesc_spare3;
static int hf_butc_tc_dumpDesc_spare4;
static int hf_butc_tc_restoreDesc_frag;
static int hf_butc_tc_restoreDesc_tapeName;
static int hf_butc_tc_restoreDesc_position;
static int hf_butc_tc_restoreDesc_origVid;
static int hf_butc_tc_restoreDesc_vid;
static int hf_butc_tc_restoreDesc_partition;
static int hf_butc_tc_restoreDesc_flags;
static int hf_butc_tc_restoreDesc_hostAddr;
static int hf_butc_tc_restoreDesc_realDumpId;
static int hf_butc_tc_restoreDesc_spare2;
static int hf_butc_tc_restoreDesc_spare3;
static int hf_butc_tc_restoreDesc_spare4;
static int hf_butc_tc_restoreDesc_oldName;
static int hf_butc_tc_restoreDesc_newName;
static int hf_butc_tc_dumpStat_dumpID;
static int hf_butc_tc_dumpStat_bytesDumped;
static int hf_butc_tc_dumpStat_volumeBeingDumped;
static int hf_butc_tc_dumpStat_numVolErrs;
static int hf_butc_tc_dumpStat_flags;
static int hf_butc_tc_dumpStat_spare1;
static int hf_butc_tc_dumpStat_spare2;
static int hf_butc_tc_dumpStat_spare3;
static int hf_butc_tc_dumpStat_spare4;
static int hf_butc_tc_tapeLabel_size;
static int hf_butc_tc_tapeLabel_size_ext;
static int hf_butc_tc_tapeLabel_spare1;
static int hf_butc_tc_tapeLabel_spare2;
static int hf_butc_tc_tapeLabel_spare3;
static int hf_butc_tc_tapeLabel_spare4;
static int hf_butc_tc_tapeLabel_nameLen;
static int hf_butc_tc_tapeLabel_name;
static int hf_butc_tc_tapeSet_id;
static int hf_butc_tc_tapeSet_tapeServer;
static int hf_butc_tc_tapeSet_format;
static int hf_butc_tc_tapeSet_maxTapes;
static int hf_butc_tc_tapeSet_a;
static int hf_butc_tc_tapeSet_b;
static int hf_butc_tc_tapeSet_expDate;
static int hf_butc_tc_tapeSet_expType;
static int hf_butc_tc_tapeSet_spare1;
static int hf_butc_tc_tapeSet_spare2;
static int hf_butc_tc_tapeSet_spare3;
static int hf_butc_tc_tapeSet_spare4;
static int hf_butc_tc_tcInfo_tcVersion;
static int hf_butc_tc_tcInfo_spare1;
static int hf_butc_tc_tcInfo_spare2;
static int hf_butc_tc_tcInfo_spare3;
static int hf_butc_tc_tcInfo_spare4;
static int hf_butc_tc_restoreArray_tc_restoreArray_len;
static int hf_butc_tc_restoreArray_tc_restoreArray_val;
static int hf_butc_tc_dumpArray_tc_dumpArray_len;
static int hf_butc_tc_dumpArray_tc_dumpArray;
static int hf_butc_tc_dumpInterface_dumpPath;
static int hf_butc_tc_dumpInterface_volumeSetName;
static int hf_butc_tc_dumpInterface_dumpName;
static int hf_butc_tc_dumpInterface_tapeSet;
static int hf_butc_tc_dumpInterface_parentDumpId;
static int hf_butc_tc_dumpInterface_dumpLevel;
static int hf_butc_tc_dumpInterface_spare1;
static int hf_butc_tc_dumpInterface_spare2;
static int hf_butc_tc_dumpInterface_spare3;
static int hf_butc_tc_dumpInterface_spare4;
static int hf_butc_tc_statusInfoSwitchVol_nKBytes;
static int hf_butc_tc_statusInfoSwitchVol_volumeName;
static int hf_butc_tc_statusInfoSwitchVol_volsFailed;
static int hf_butc_tc_statusInfoSwitchVol_spare1;
static int hf_butc_tc_statusInfoSwitchLabel_tapeLabel;
static int hf_butc_tc_statusInfoSwitchLabel_spare1;
static int hf_butc_tc_statusInfoSwitch_TCOP_NONE_none;
static int hf_butc_tc_statusInfoSwitch_TCOP_DUMP_vol;
static int hf_butc_tc_statusInfoSwitch_TCOP_RESTORE_vol;
static int hf_butc_tc_statusInfoSwitch_TCOP_LABELTAPE_label;
static int hf_butc_tc_statusInfoSwitch_TCOP_READLABEL_label;
static int hf_butc_tc_statusInfoSwitch_TCOP_SCANTAPE_spare1;
static int hf_butc_tc_statusInfoSwitch_TCOP_STATUS_spare2;
static int hf_butc_tc_statusInfoSwitch_TCOP_SAVEDB_spare3;
static int hf_butc_tc_statusInfoSwitch_TCOP_RESTOREDB_spare4;
static int hf_butc_tc_statusInfoSwitch_TCOP_SPARE_spare5;
static int hf_butc_tciStatusS_taskName;
static int hf_butc_tciStatusS_flags;
static int hf_butc_tciStatusS_lastPolled;
static int hf_butc_tciStatusS_info;
static int hf_butc_tciStatusS_taskId;
static int hf_butc_tciStatusS_spare2;
static int hf_butc_tciStatusS_spare3;
static int hf_butc_tciStatusS_spare4;
static int hf_butc_BUTC_PerformDump_tcdiPtr;
static int hf_butc_BUTC_PerformDump_dumps;
static int hf_butc_BUTC_PerformDump_dumpID;
static int hf_butc_BUTC_PerformRestore_dumpSetName;
static int hf_butc_BUTC_PerformRestore_restores;
static int hf_butc_BUTC_PerformRestore_dumpID;
static int hf_butc_BUTC_AbortDump_dumpID;
static int hf_butc_BUTC_LabelTape_label;
static int hf_butc_BUTC_LabelTape_taskId;
static int hf_butc_BUTC_ReadLabel_taskId;
static int hf_butc_BUTC_ScanDumps_addDbFlag;
static int hf_butc_BUTC_ScanDumps_taskId;
static int hf_butc_BUTC_TCInfo_tciptr;
static int hf_butc_BUTC_SaveDb_taskId;
static int hf_butc_BUTC_RestoreDb_taskId;
static int hf_butc_BUTC_EndStatus_taskId;
static int hf_butc_BUTC_GetStatus_taskId;
static int hf_butc_BUTC_GetStatus_statusPtr;
static int hf_butc_BUTC_RequestAbort_taskId;
static int hf_butc_BUTC_ScanStatus_taskId;
static int hf_butc_BUTC_ScanStatus_statusPtr;
static int hf_butc_BUTC_ScanStatus_flags;
/* END OF INCLUDED FILE : ETH_HF */





/* INCLUDED FILE : ETH_ETT */
static int ett_butc;
static int ett_butc_Restore_flags;
static int ett_butc_afsNetAddr;
static int ett_butc_tc_dumpDesc;
static int ett_butc_tc_restoreDesc;
static int ett_butc_tc_dumpStat;
static int ett_butc_tc_tapeLabel;
static int ett_butc_tc_tapeSet;
static int ett_butc_tc_tcInfo;
static int ett_butc_tc_restoreArray;
static int ett_butc_tc_dumpArray;
static int ett_butc_tc_dumpInterface;
static int ett_butc_tc_statusInfoSwitchVol;
static int ett_butc_tc_statusInfoSwitchLabel;
static int ett_butc_tc_statusInfoSwitch;
static int ett_butc_tciStatusS;
/* END OF INCLUDED FILE : ETH_ETT */



static int
butc_dissect_NameString_t(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep, int hf_index, uint32_t param _U_)
{
    offset=dissect_ndr_vstring(tvb, offset, pinfo, tree, di, drep, 1, hf_index, false, NULL);
    return offset;
}



/* INCLUDED FILE : ETH_CODE */
static e_guid_t uuid_dcerpc_butc = {
	  0x1d193c08, 0x000b, 0x11ca,
	  { 0xba, 0x1d, 0x02, 0x60, 0x8c, 0x2e, 0xa9, 0x6e}
};

static uint16_t ver_butc = 4;

static const true_false_string TC_RESTORE_CREATE_tfs = {
    "TC_RESTORE_CREATE is SET",
    "TC_RESTORE_CREATE is NOT set"
};

static const true_false_string TC_RESTORE_INCR_tfs = {
    "TC_RESTORE_INCR is SET",
    "TC_RESTORE_INCR is NOT set"
};


int
butc_dissect_Restore_flags(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, dcerpc_info *di, uint8_t *drep, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    uint32_t flags;

    ALIGN_TO_4_BYTES;

    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, 4, ENC_LITTLE_ENDIAN);
 	   tree=proto_item_add_subtree(item, ett_butc_Restore_flags);
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, NULL, di, drep, -1, &flags);


    proto_tree_add_boolean(tree, hf_butc_Restore_flags_TC_RESTORE_CREATE, tvb, offset-4, 4, flags);
    if(flags&0x00000001){
 	   proto_item_append_text(item, " TC_RESTORE_CREATE");
    }
    flags&=(~0x00000001);

    proto_tree_add_boolean(tree, hf_butc_Restore_flags_TC_RESTORE_INCR, tvb, offset-4, 4, flags);
    if(flags&0x00000002){
 	   proto_item_append_text(item, " TC_RESTORE_INCR");
    }
    flags&=(~0x00000002);

    if(flags){
 	   proto_item_append_text(item, "UNKNOWN-FLAGS");
    }

    return offset;
}

static int
butc_dissect_uint16(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep, int hf_index, uint32_t param _U_)
{
    offset=dissect_ndr_uint16(tvb, offset, pinfo, tree, di, drep, hf_index, NULL);
    return offset;
}

static int
butc_dissect_afsNetAddr_type(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint16(tvb, offset, pinfo, tree, di, drep, hf_butc_afsNetAddr_type, param);
	 return offset;
}


static int
butc_dissect_uint8(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep, int hf_index, uint32_t param _U_)
{
    offset=dissect_ndr_uint8(tvb, offset, pinfo, tree, di, drep, hf_index, NULL);
    return offset;
}

static int
butc_dissect_afsNetAddr_data(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint8(tvb, offset, pinfo, tree, di, drep, hf_butc_afsNetAddr_data, param);
	 return offset;
}

static int
fixedarray_butc_dissect_afsNetAddr_data(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 int count=14;
	 while(count--){
		 offset=butc_dissect_afsNetAddr_data(tvb, offset, pinfo, tree, di, drep);
	 }

	 return offset;
}


int
butc_dissect_afsNetAddr(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, dcerpc_info *di _U_, uint8_t *drep _U_, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_2_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, ENC_NA);
 	   tree=proto_item_add_subtree(item, ett_butc_afsNetAddr);
    }

    offset=butc_dissect_afsNetAddr_type(tvb, offset, pinfo, tree, di, drep);

    offset=fixedarray_butc_dissect_afsNetAddr_data(tvb, offset, pinfo, tree, di, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}

static int
butc_dissect_udlong(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep, int hf_index, uint32_t param _U_)
{

    offset=dissect_ndr_duint32(tvb, offset, pinfo, tree, di, drep, hf_index, NULL);

    return offset;
}

static int
butc_dissect_tc_dumpDesc_vid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_udlong(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpDesc_vid, param);
	 return offset;
}

static int
butc_dissect_tc_dumpDesc_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_NameString_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpDesc_name, param);
	 return offset;
}


static int
butc_dissect_int32(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep, int hf_index, uint32_t param _U_)
{
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, di, drep, hf_index, NULL);
    return offset;
}

static int
butc_dissect_tc_dumpDesc_partition(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpDesc_partition, param);
	 return offset;
}


static int
butc_dissect_time_t(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep, int hf_index, uint32_t param _U_)
{

    offset=dissect_ndr_time_t(tvb, offset, pinfo, tree, di, drep, hf_index, NULL);

    return offset;
}

static int
butc_dissect_tc_dumpDesc_date(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_time_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpDesc_date, param);
	 return offset;
}

static int
butc_dissect_tc_dumpDesc_cloneDate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_time_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpDesc_cloneDate, param);
	 return offset;
}

static int
butc_dissect_tc_dumpDesc_hostAddr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_afsNetAddr(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpDesc_hostAddr, param);
	 return offset;
}


static int
butc_dissect_uint32(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep, int hf_index, uint32_t param _U_)
{
    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree, di, drep, hf_index, NULL);
    return offset;
}

static int
butc_dissect_tc_dumpDesc_spare1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpDesc_spare1, param);
	 return offset;
}

static int
butc_dissect_tc_dumpDesc_spare2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpDesc_spare2, param);
	 return offset;
}

static int
butc_dissect_tc_dumpDesc_spare3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpDesc_spare3, param);
	 return offset;
}

static int
butc_dissect_tc_dumpDesc_spare4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpDesc_spare4, param);
	 return offset;
}


int
butc_dissect_tc_dumpDesc(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, dcerpc_info *di _U_, uint8_t *drep _U_, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, ENC_NA);
 	   tree=proto_item_add_subtree(item, ett_butc_tc_dumpDesc);
    }

    offset=butc_dissect_tc_dumpDesc_vid(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpDesc_name(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpDesc_partition(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpDesc_date(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpDesc_cloneDate(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpDesc_hostAddr(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpDesc_spare1(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpDesc_spare2(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpDesc_spare3(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpDesc_spare4(tvb, offset, pinfo, tree, di, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
butc_dissect_tc_restoreDesc_frag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_frag, param);
	 return offset;
}

static int
butc_dissect_tc_restoreDesc_tapeName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_NameString_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_tapeName, param);
	 return offset;
}

static int
butc_dissect_tc_restoreDesc_position(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_position, param);
	 return offset;
}

static int
butc_dissect_tc_restoreDesc_origVid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_udlong(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_origVid, param);
	 return offset;
}

static int
butc_dissect_tc_restoreDesc_vid(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_udlong(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_vid, param);
	 return offset;
}

static int
butc_dissect_tc_restoreDesc_partition(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_partition, param);
	 return offset;
}

static int
butc_dissect_tc_restoreDesc_flags(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_Restore_flags(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_flags, param);
	 return offset;
}

static int
butc_dissect_tc_restoreDesc_hostAddr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_afsNetAddr(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_hostAddr, param);
	 return offset;
}

static int
butc_dissect_tc_restoreDesc_realDumpId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_realDumpId, param);
	 return offset;
}

static int
butc_dissect_tc_restoreDesc_spare2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_spare2, param);
	 return offset;
}

static int
butc_dissect_tc_restoreDesc_spare3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_spare3, param);
	 return offset;
}

static int
butc_dissect_tc_restoreDesc_spare4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_spare4, param);
	 return offset;
}

static int
butc_dissect_tc_restoreDesc_oldName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_NameString_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_oldName, param);
	 return offset;
}

static int
butc_dissect_tc_restoreDesc_newName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_NameString_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreDesc_newName, param);
	 return offset;
}


int
butc_dissect_tc_restoreDesc(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, dcerpc_info *di _U_, uint8_t *drep _U_, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, ENC_NA);
 	   tree=proto_item_add_subtree(item, ett_butc_tc_restoreDesc);
    }

    offset=butc_dissect_tc_restoreDesc_frag(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_restoreDesc_tapeName(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_restoreDesc_position(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_restoreDesc_origVid(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_restoreDesc_vid(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_restoreDesc_partition(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_restoreDesc_flags(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_restoreDesc_hostAddr(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_restoreDesc_realDumpId(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_restoreDesc_spare2(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_restoreDesc_spare3(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_restoreDesc_spare4(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_restoreDesc_oldName(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_restoreDesc_newName(tvb, offset, pinfo, tree, di, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
butc_dissect_tc_dumpStat_dumpID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpStat_dumpID, param);
	 return offset;
}

static int
butc_dissect_tc_dumpStat_bytesDumped(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpStat_bytesDumped, param);
	 return offset;
}

static int
butc_dissect_tc_dumpStat_volumeBeingDumped(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_udlong(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpStat_volumeBeingDumped, param);
	 return offset;
}

static int
butc_dissect_tc_dumpStat_numVolErrs(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpStat_numVolErrs, param);
	 return offset;
}

static int
butc_dissect_tc_dumpStat_flags(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpStat_flags, param);
	 return offset;
}

static int
butc_dissect_tc_dumpStat_spare1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpStat_spare1, param);
	 return offset;
}

static int
butc_dissect_tc_dumpStat_spare2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpStat_spare2, param);
	 return offset;
}

static int
butc_dissect_tc_dumpStat_spare3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpStat_spare3, param);
	 return offset;
}

static int
butc_dissect_tc_dumpStat_spare4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpStat_spare4, param);
	 return offset;
}


int
butc_dissect_tc_dumpStat(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, dcerpc_info *di _U_, uint8_t *drep _U_, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, ENC_NA);
 	   tree=proto_item_add_subtree(item, ett_butc_tc_dumpStat);
    }

    offset=butc_dissect_tc_dumpStat_dumpID(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpStat_bytesDumped(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpStat_volumeBeingDumped(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpStat_numVolErrs(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpStat_flags(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpStat_spare1(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpStat_spare2(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpStat_spare3(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpStat_spare4(tvb, offset, pinfo, tree, di, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
butc_dissect_tc_tapeLabel_size(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeLabel_size, param);
	 return offset;
}

static int
butc_dissect_tc_tapeLabel_size_ext(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeLabel_size_ext, param);
	 return offset;
}

static int
butc_dissect_tc_tapeLabel_spare1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeLabel_spare1, param);
	 return offset;
}

static int
butc_dissect_tc_tapeLabel_spare2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeLabel_spare2, param);
	 return offset;
}

static int
butc_dissect_tc_tapeLabel_spare3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeLabel_spare3, param);
	 return offset;
}

static int
butc_dissect_tc_tapeLabel_spare4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeLabel_spare4, param);
	 return offset;
}

static int
butc_dissect_tc_tapeLabel_nameLen(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeLabel_nameLen, param);
	 return offset;
}

static int
butc_dissect_tc_tapeLabel_name(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_NameString_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeLabel_name, param);
	 return offset;
}


int
butc_dissect_tc_tapeLabel(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, dcerpc_info *di _U_, uint8_t *drep _U_, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, ENC_NA);
 	   tree=proto_item_add_subtree(item, ett_butc_tc_tapeLabel);
    }

    offset=butc_dissect_tc_tapeLabel_size(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeLabel_size_ext(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeLabel_spare1(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeLabel_spare2(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeLabel_spare3(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeLabel_spare4(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeLabel_nameLen(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeLabel_name(tvb, offset, pinfo, tree, di, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
butc_dissect_tc_tapeSet_id(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeSet_id, param);
	 return offset;
}

static int
butc_dissect_tc_tapeSet_tapeServer(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_NameString_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeSet_tapeServer, param);
	 return offset;
}

static int
butc_dissect_tc_tapeSet_format(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_NameString_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeSet_format, param);
	 return offset;
}

static int
butc_dissect_tc_tapeSet_maxTapes(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeSet_maxTapes, param);
	 return offset;
}

static int
butc_dissect_tc_tapeSet_a(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeSet_a, param);
	 return offset;
}

static int
butc_dissect_tc_tapeSet_b(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeSet_b, param);
	 return offset;
}

static int
butc_dissect_tc_tapeSet_expDate(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeSet_expDate, param);
	 return offset;
}

static int
butc_dissect_tc_tapeSet_expType(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeSet_expType, param);
	 return offset;
}

static int
butc_dissect_tc_tapeSet_spare1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeSet_spare1, param);
	 return offset;
}

static int
butc_dissect_tc_tapeSet_spare2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeSet_spare2, param);
	 return offset;
}

static int
butc_dissect_tc_tapeSet_spare3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeSet_spare3, param);
	 return offset;
}

static int
butc_dissect_tc_tapeSet_spare4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tapeSet_spare4, param);
	 return offset;
}


int
butc_dissect_tc_tapeSet(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, dcerpc_info *di _U_, uint8_t *drep _U_, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, ENC_NA);
 	   tree=proto_item_add_subtree(item, ett_butc_tc_tapeSet);
    }

    offset=butc_dissect_tc_tapeSet_id(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeSet_tapeServer(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeSet_format(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeSet_maxTapes(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeSet_a(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeSet_b(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeSet_expDate(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeSet_expType(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeSet_spare1(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeSet_spare2(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeSet_spare3(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tapeSet_spare4(tvb, offset, pinfo, tree, di, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
butc_dissect_tc_tcInfo_tcVersion(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tcInfo_tcVersion, param);
	 return offset;
}

static int
butc_dissect_tc_tcInfo_spare1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tcInfo_spare1, param);
	 return offset;
}

static int
butc_dissect_tc_tcInfo_spare2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tcInfo_spare2, param);
	 return offset;
}

static int
butc_dissect_tc_tcInfo_spare3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tcInfo_spare3, param);
	 return offset;
}

static int
butc_dissect_tc_tcInfo_spare4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_tcInfo_spare4, param);
	 return offset;
}


int
butc_dissect_tc_tcInfo(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, dcerpc_info *di _U_, uint8_t *drep _U_, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, ENC_NA);
 	   tree=proto_item_add_subtree(item, ett_butc_tc_tcInfo);
    }

    offset=butc_dissect_tc_tcInfo_tcVersion(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tcInfo_spare1(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tcInfo_spare2(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tcInfo_spare3(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_tcInfo_spare4(tvb, offset, pinfo, tree, di, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
butc_dissect_tc_restoreArray_tc_restoreArray_len(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreArray_tc_restoreArray_len, param);
	 return offset;
}

static int
butc_dissect_tc_restoreArray_tc_restoreArray_val(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_tc_restoreDesc(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_restoreArray_tc_restoreArray_val, param);
	 return offset;
}

static int
ptr_butc_dissect_tc_restoreArray_tc_restoreArray_val(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_tc_restoreArray_tc_restoreArray_val, NDR_POINTER_PTR, "tc_restoreArray_val", -1);
	 return offset;
}

static int
ucarray_ptr_butc_dissect_tc_restoreArray_tc_restoreArray_val(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, di, drep, ptr_butc_dissect_tc_restoreArray_tc_restoreArray_val);
	 return offset;
}


int
butc_dissect_tc_restoreArray(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, dcerpc_info *di _U_, uint8_t *drep _U_, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, ENC_NA);
 	   tree=proto_item_add_subtree(item, ett_butc_tc_restoreArray);
    }

    offset=butc_dissect_tc_restoreArray_tc_restoreArray_len(tvb, offset, pinfo, tree, di, drep);

    offset=ucarray_ptr_butc_dissect_tc_restoreArray_tc_restoreArray_val(tvb, offset, pinfo, tree, di, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
butc_dissect_tc_dumpArray_tc_dumpArray_len(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpArray_tc_dumpArray_len, param);
	 return offset;
}

static int
butc_dissect_tc_dumpArray_tc_dumpArray(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_tc_dumpDesc(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpArray_tc_dumpArray, param);
	 return offset;
}

static int
ptr_butc_dissect_tc_dumpArray_tc_dumpArray(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 offset=dissect_ndr_embedded_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_tc_dumpArray_tc_dumpArray, NDR_POINTER_PTR, "tc_dumpArray", -1);
	 return offset;
}

static int
ucarray_ptr_butc_dissect_tc_dumpArray_tc_dumpArray(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 offset=dissect_ndr_ucarray(tvb, offset, pinfo, tree, di, drep, ptr_butc_dissect_tc_dumpArray_tc_dumpArray);
	 return offset;
}


int
butc_dissect_tc_dumpArray(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, dcerpc_info *di _U_, uint8_t *drep _U_, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, ENC_NA);
 	   tree=proto_item_add_subtree(item, ett_butc_tc_dumpArray);
    }

    offset=butc_dissect_tc_dumpArray_tc_dumpArray_len(tvb, offset, pinfo, tree, di, drep);

    offset=ucarray_ptr_butc_dissect_tc_dumpArray_tc_dumpArray(tvb, offset, pinfo, tree, di, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
butc_dissect_tc_dumpInterface_dumpPath(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_NameString_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpInterface_dumpPath, param);
	 return offset;
}

static int
butc_dissect_tc_dumpInterface_volumeSetName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_NameString_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpInterface_volumeSetName, param);
	 return offset;
}

static int
butc_dissect_tc_dumpInterface_dumpName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_NameString_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpInterface_dumpName, param);
	 return offset;
}

static int
butc_dissect_tc_dumpInterface_tapeSet(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_tc_tapeSet(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpInterface_tapeSet, param);
	 return offset;
}

static int
butc_dissect_tc_dumpInterface_parentDumpId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpInterface_parentDumpId, param);
	 return offset;
}

static int
butc_dissect_tc_dumpInterface_dumpLevel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpInterface_dumpLevel, param);
	 return offset;
}

static int
butc_dissect_tc_dumpInterface_spare1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpInterface_spare1, param);
	 return offset;
}

static int
butc_dissect_tc_dumpInterface_spare2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpInterface_spare2, param);
	 return offset;
}

static int
butc_dissect_tc_dumpInterface_spare3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpInterface_spare3, param);
	 return offset;
}

static int
butc_dissect_tc_dumpInterface_spare4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_dumpInterface_spare4, param);
	 return offset;
}


int
butc_dissect_tc_dumpInterface(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, dcerpc_info *di _U_, uint8_t *drep _U_, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, ENC_NA);
 	   tree=proto_item_add_subtree(item, ett_butc_tc_dumpInterface);
    }

    offset=butc_dissect_tc_dumpInterface_dumpPath(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpInterface_volumeSetName(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpInterface_dumpName(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpInterface_tapeSet(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpInterface_parentDumpId(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpInterface_dumpLevel(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpInterface_spare1(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpInterface_spare2(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpInterface_spare3(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_dumpInterface_spare4(tvb, offset, pinfo, tree, di, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
butc_dissect_tc_statusInfoSwitchVol_nKBytes(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitchVol_nKBytes, param);
	 return offset;
}

static int
butc_dissect_tc_statusInfoSwitchVol_volumeName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_NameString_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitchVol_volumeName, param);
	 return offset;
}

static int
butc_dissect_tc_statusInfoSwitchVol_volsFailed(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitchVol_volsFailed, param);
	 return offset;
}

static int
butc_dissect_tc_statusInfoSwitchVol_spare1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitchVol_spare1, param);
	 return offset;
}


int
butc_dissect_tc_statusInfoSwitchVol(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, dcerpc_info *di _U_, uint8_t *drep _U_, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, ENC_NA);
 	   tree=proto_item_add_subtree(item, ett_butc_tc_statusInfoSwitchVol);
    }

    offset=butc_dissect_tc_statusInfoSwitchVol_nKBytes(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_statusInfoSwitchVol_volumeName(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_statusInfoSwitchVol_volsFailed(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_statusInfoSwitchVol_spare1(tvb, offset, pinfo, tree, di, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
butc_dissect_tc_statusInfoSwitchLabel_tapeLabel(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_tc_tapeLabel(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitchLabel_tapeLabel, param);
	 return offset;
}

static int
butc_dissect_tc_statusInfoSwitchLabel_spare1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitchLabel_spare1, param);
	 return offset;
}


int
butc_dissect_tc_statusInfoSwitchLabel(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, dcerpc_info *di _U_, uint8_t *drep _U_, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, ENC_NA);
 	   tree=proto_item_add_subtree(item, ett_butc_tc_statusInfoSwitchLabel);
    }

    offset=butc_dissect_tc_statusInfoSwitchLabel_tapeLabel(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tc_statusInfoSwitchLabel_spare1(tvb, offset, pinfo, tree, di, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
butc_dissect_union_tc_statusInfoSwitch_TCOP_NONE_none(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitch_TCOP_NONE_none, param);
    return offset;
}

static int
butc_dissect_union_tc_statusInfoSwitch_TCOP_DUMP_vol(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_tc_statusInfoSwitchVol(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitch_TCOP_DUMP_vol, param);
    return offset;
}

static int
butc_dissect_union_tc_statusInfoSwitch_TCOP_RESTORE_vol(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_tc_statusInfoSwitchVol(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitch_TCOP_RESTORE_vol, param);
    return offset;
}

static int
butc_dissect_union_tc_statusInfoSwitch_TCOP_LABELTAPE_label(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_tc_statusInfoSwitchLabel(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitch_TCOP_LABELTAPE_label, param);
    return offset;
}

static int
butc_dissect_union_tc_statusInfoSwitch_TCOP_READLABEL_label(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_tc_statusInfoSwitchLabel(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitch_TCOP_READLABEL_label, param);
    return offset;
}

static int
butc_dissect_union_tc_statusInfoSwitch_TCOP_SCANTAPE_spare1(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitch_TCOP_SCANTAPE_spare1, param);
    return offset;
}

static int
butc_dissect_union_tc_statusInfoSwitch_TCOP_STATUS_spare2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitch_TCOP_STATUS_spare2, param);
    return offset;
}

static int
butc_dissect_union_tc_statusInfoSwitch_TCOP_SAVEDB_spare3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitch_TCOP_SAVEDB_spare3, param);
    return offset;
}

static int
butc_dissect_union_tc_statusInfoSwitch_TCOP_RESTOREDB_spare4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitch_TCOP_RESTOREDB_spare4, param);
    return offset;
}

static int
butc_dissect_union_tc_statusInfoSwitch_TCOP_SPARE_spare5(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tc_statusInfoSwitch_TCOP_SPARE_spare5, param);
    return offset;
}


static int
butc_dissect_union_tc_statusInfoSwitch(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *parent_tree, dcerpc_info *di, uint8_t *drep, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;
    uint32_t level = 0;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   tree=proto_tree_add_subtree(parent_tree, tvb, offset, -1, ett_butc_tc_statusInfoSwitch, &item, "tc_statusInfoSwitch");
    }

    offset=dissect_ndr_uint32(tvb, offset, pinfo, tree,
 							 di, drep, hf_index, &level);

    switch(level){
    case TCOP_NONE:
 	   ALIGN_TO_4_BYTES;
 	   offset=butc_dissect_union_tc_statusInfoSwitch_TCOP_NONE_none(tvb, offset, pinfo, tree, di, drep);
 	   break;

    case TCOP_DUMP:
 	   ALIGN_TO_4_BYTES;
 	   offset=butc_dissect_union_tc_statusInfoSwitch_TCOP_DUMP_vol(tvb, offset, pinfo, tree, di, drep);
 	   break;

    case TCOP_RESTORE:
 	   ALIGN_TO_4_BYTES;
 	   offset=butc_dissect_union_tc_statusInfoSwitch_TCOP_RESTORE_vol(tvb, offset, pinfo, tree, di, drep);
 	   break;

    case TCOP_LABELTAPE:
 	   ALIGN_TO_4_BYTES;
 	   offset=butc_dissect_union_tc_statusInfoSwitch_TCOP_LABELTAPE_label(tvb, offset, pinfo, tree, di, drep);
 	   break;

    case TCOP_READLABEL:
 	   ALIGN_TO_4_BYTES;
 	   offset=butc_dissect_union_tc_statusInfoSwitch_TCOP_READLABEL_label(tvb, offset, pinfo, tree, di, drep);
 	   break;

    case TCOP_SCANTAPE:
 	   ALIGN_TO_4_BYTES;
 	   offset=butc_dissect_union_tc_statusInfoSwitch_TCOP_SCANTAPE_spare1(tvb, offset, pinfo, tree, di, drep);
 	   break;

    case TCOP_STATUS:
 	   ALIGN_TO_4_BYTES;
 	   offset=butc_dissect_union_tc_statusInfoSwitch_TCOP_STATUS_spare2(tvb, offset, pinfo, tree, di, drep);
 	   break;

    case TCOP_SAVEDB:
 	   ALIGN_TO_4_BYTES;
 	   offset=butc_dissect_union_tc_statusInfoSwitch_TCOP_SAVEDB_spare3(tvb, offset, pinfo, tree, di, drep);
 	   break;

    case TCOP_RESTOREDB:
 	   ALIGN_TO_4_BYTES;
 	   offset=butc_dissect_union_tc_statusInfoSwitch_TCOP_RESTOREDB_spare4(tvb, offset, pinfo, tree, di, drep);
 	   break;

    case TCOP_SPARE:
 	   ALIGN_TO_4_BYTES;
 	   offset=butc_dissect_union_tc_statusInfoSwitch_TCOP_SPARE_spare5(tvb, offset, pinfo, tree, di, drep);
 	   break;

    }

    proto_item_set_len(item, offset-old_offset);

   return offset;
}
static int
butc_dissect_tciStatusS_taskName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_NameString_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tciStatusS_taskName, param);
	 return offset;
}

static int
butc_dissect_tciStatusS_flags(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tciStatusS_flags, param);
	 return offset;
}

static int
butc_dissect_tciStatusS_lastPolled(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_time_t(tvb, offset, pinfo, tree, di, drep, hf_butc_tciStatusS_lastPolled, param);
	 return offset;
}

static int
butc_dissect_tciStatusS_info(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_union_tc_statusInfoSwitch(tvb, offset, pinfo, tree, di, drep, hf_butc_tciStatusS_info, param);
	 return offset;
}

static int
butc_dissect_tciStatusS_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tciStatusS_taskId, param);
	 return offset;
}

static int
butc_dissect_tciStatusS_spare2(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tciStatusS_spare2, param);
	 return offset;
}

static int
butc_dissect_tciStatusS_spare3(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tciStatusS_spare3, param);
	 return offset;
}

static int
butc_dissect_tciStatusS_spare4(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
	 uint32_t param=0;
	 offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_tciStatusS_spare4, param);
	 return offset;
}


int
butc_dissect_tciStatusS(tvbuff_t *tvb, int offset, packet_info *pinfo _U_, proto_tree *parent_tree, dcerpc_info *di _U_, uint8_t *drep _U_, int hf_index, uint32_t param _U_)
{
    proto_item *item=NULL;
    proto_tree *tree=NULL;
    int old_offset;

    ALIGN_TO_4_BYTES;

    old_offset=offset;
    if(parent_tree){
 	   item=proto_tree_add_item(parent_tree, hf_index, tvb, offset, -1, ENC_NA);
 	   tree=proto_item_add_subtree(item, ett_butc_tciStatusS);
    }

    offset=butc_dissect_tciStatusS_taskName(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tciStatusS_flags(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tciStatusS_lastPolled(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tciStatusS_info(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tciStatusS_taskId(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tciStatusS_spare2(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tciStatusS_spare3(tvb, offset, pinfo, tree, di, drep);

    offset=butc_dissect_tciStatusS_spare4(tvb, offset, pinfo, tree, di, drep);

    proto_item_set_len(item, offset-old_offset);

    return offset;
}
static int
butc_dissect_BUTC_PerformDump_tcdiPtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_tc_dumpInterface(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_PerformDump_tcdiPtr, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_PerformDump_tcdiPtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_PerformDump_tcdiPtr, NDR_POINTER_REF, "tcdiPtr", -1);
    return offset;
}

static int
butc_dissect_BUTC_PerformDump_dumps(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_tc_dumpArray(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_PerformDump_dumps, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_PerformDump_dumps(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_PerformDump_dumps, NDR_POINTER_REF, "dumps", -1);
    return offset;
}

static int
butc_dissect_BUTC_PerformDump_dumpID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_PerformDump_dumpID, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_PerformDump_dumpID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_PerformDump_dumpID, NDR_POINTER_REF, "dumpID", -1);
    return offset;
}


static int
butc_dissect_BUTC_PerformDump_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ref_butc_dissect_BUTC_PerformDump_tcdiPtr(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

 	   offset=ref_butc_dissect_BUTC_PerformDump_dumps(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);


   return offset;
}

static int
butc_dissect_BUTC_PerformDump_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ref_butc_dissect_BUTC_PerformDump_dumpID(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}
static int
butc_dissect_BUTC_PerformRestore_dumpSetName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_NameString_t(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_PerformRestore_dumpSetName, param);
    return offset;
}

static int
ptr_butc_dissect_BUTC_PerformRestore_dumpSetName(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_PerformRestore_dumpSetName, NDR_POINTER_PTR, "dumpSetName", -1);
    return offset;
}

static int
butc_dissect_BUTC_PerformRestore_restores(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_tc_restoreArray(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_PerformRestore_restores, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_PerformRestore_restores(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_PerformRestore_restores, NDR_POINTER_REF, "restores", -1);
    return offset;
}

static int
butc_dissect_BUTC_PerformRestore_dumpID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_PerformRestore_dumpID, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_PerformRestore_dumpID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_PerformRestore_dumpID, NDR_POINTER_REF, "dumpID", -1);
    return offset;
}


static int
butc_dissect_BUTC_PerformRestore_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ptr_butc_dissect_BUTC_PerformRestore_dumpSetName(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

 	   offset=ref_butc_dissect_BUTC_PerformRestore_restores(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);


   return offset;
}

static int
butc_dissect_BUTC_PerformRestore_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ref_butc_dissect_BUTC_PerformRestore_dumpID(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}
static int
butc_dissect_BUTC_AbortDump_dumpID(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_AbortDump_dumpID, param);
    return offset;
}


static int
butc_dissect_BUTC_AbortDump_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=butc_dissect_BUTC_AbortDump_dumpID(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);


   return offset;
}

static int
butc_dissect_BUTC_AbortDump_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}
static int
butc_dissect_BUTC_LabelTape_label(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_tc_tapeLabel(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_LabelTape_label, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_LabelTape_label(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_LabelTape_label, NDR_POINTER_REF, "label", -1);
    return offset;
}

static int
butc_dissect_BUTC_LabelTape_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_LabelTape_taskId, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_LabelTape_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_LabelTape_taskId, NDR_POINTER_REF, "taskId", -1);
    return offset;
}


static int
butc_dissect_BUTC_LabelTape_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ref_butc_dissect_BUTC_LabelTape_label(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);


   return offset;
}

static int
butc_dissect_BUTC_LabelTape_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ref_butc_dissect_BUTC_LabelTape_taskId(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}
static int
butc_dissect_BUTC_ReadLabel_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_ReadLabel_taskId, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_ReadLabel_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_ReadLabel_taskId, NDR_POINTER_REF, "taskId", -1);
    return offset;
}


static int
butc_dissect_BUTC_ReadLabel_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{

   return offset;
}

static int
butc_dissect_BUTC_ReadLabel_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ref_butc_dissect_BUTC_ReadLabel_taskId(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}
static int
butc_dissect_BUTC_ScanDumps_addDbFlag(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_int32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_ScanDumps_addDbFlag, param);
    return offset;
}

static int
butc_dissect_BUTC_ScanDumps_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_ScanDumps_taskId, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_ScanDumps_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_ScanDumps_taskId, NDR_POINTER_REF, "taskId", -1);
    return offset;
}


static int
butc_dissect_BUTC_ScanDumps_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=butc_dissect_BUTC_ScanDumps_addDbFlag(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);


   return offset;
}

static int
butc_dissect_BUTC_ScanDumps_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ref_butc_dissect_BUTC_ScanDumps_taskId(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}
static int
butc_dissect_BUTC_TCInfo_tciptr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_tc_tcInfo(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_TCInfo_tciptr, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_TCInfo_tciptr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_TCInfo_tciptr, NDR_POINTER_REF, "tciptr", -1);
    return offset;
}


static int
butc_dissect_BUTC_TCInfo_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{

   return offset;
}

static int
butc_dissect_BUTC_TCInfo_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ref_butc_dissect_BUTC_TCInfo_tciptr(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}
static int
butc_dissect_BUTC_SaveDb_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_SaveDb_taskId, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_SaveDb_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_SaveDb_taskId, NDR_POINTER_REF, "taskId", -1);
    return offset;
}


static int
butc_dissect_BUTC_SaveDb_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{

   return offset;
}

static int
butc_dissect_BUTC_SaveDb_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ref_butc_dissect_BUTC_SaveDb_taskId(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}
static int
butc_dissect_BUTC_RestoreDb_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_RestoreDb_taskId, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_RestoreDb_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_RestoreDb_taskId, NDR_POINTER_REF, "taskId", -1);
    return offset;
}


static int
butc_dissect_BUTC_RestoreDb_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{

   return offset;
}

static int
butc_dissect_BUTC_RestoreDb_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ref_butc_dissect_BUTC_RestoreDb_taskId(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}
static int
butc_dissect_BUTC_EndStatus_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_EndStatus_taskId, param);
    return offset;
}


static int
butc_dissect_BUTC_EndStatus_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=butc_dissect_BUTC_EndStatus_taskId(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);


   return offset;
}

static int
butc_dissect_BUTC_EndStatus_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}
static int
butc_dissect_BUTC_GetStatus_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_GetStatus_taskId, param);
    return offset;
}

static int
butc_dissect_BUTC_GetStatus_statusPtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_tciStatusS(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_GetStatus_statusPtr, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_GetStatus_statusPtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_GetStatus_statusPtr, NDR_POINTER_REF, "statusPtr", -1);
    return offset;
}


static int
butc_dissect_BUTC_GetStatus_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=butc_dissect_BUTC_GetStatus_taskId(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);


   return offset;
}

static int
butc_dissect_BUTC_GetStatus_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ref_butc_dissect_BUTC_GetStatus_statusPtr(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}
static int
butc_dissect_BUTC_RequestAbort_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_RequestAbort_taskId, param);
    return offset;
}


static int
butc_dissect_BUTC_RequestAbort_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=butc_dissect_BUTC_RequestAbort_taskId(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);


   return offset;
}

static int
butc_dissect_BUTC_RequestAbort_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}
static int
butc_dissect_BUTC_ScanStatus_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_ScanStatus_taskId, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_ScanStatus_taskId(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_ScanStatus_taskId, NDR_POINTER_REF, "taskId", -1);
    return offset;
}

static int
butc_dissect_BUTC_ScanStatus_statusPtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_tciStatusS(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_ScanStatus_statusPtr, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_ScanStatus_statusPtr(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_ScanStatus_statusPtr, NDR_POINTER_REF, "statusPtr", -1);
    return offset;
}

static int
butc_dissect_BUTC_ScanStatus_flags(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    uint32_t param=0;
    offset=butc_dissect_uint32(tvb, offset, pinfo, tree, di, drep, hf_butc_BUTC_ScanStatus_flags, param);
    return offset;
}

static int
ref_butc_dissect_BUTC_ScanStatus_flags(tvbuff_t *tvb, int offset, packet_info *pinfo, proto_tree *tree, dcerpc_info *di, uint8_t *drep)
{
    offset=dissect_ndr_toplevel_pointer(tvb, offset, pinfo, tree, di, drep, butc_dissect_BUTC_ScanStatus_flags, NDR_POINTER_REF, "flags", -1);
    return offset;
}


static int
butc_dissect_BUTC_ScanStatus_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ref_butc_dissect_BUTC_ScanStatus_taskId(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

 	   offset=ref_butc_dissect_BUTC_ScanStatus_flags(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);


   return offset;
}

static int
butc_dissect_BUTC_ScanStatus_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
 	   offset=ref_butc_dissect_BUTC_ScanStatus_taskId(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

 	   offset=ref_butc_dissect_BUTC_ScanStatus_statusPtr(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

 	   offset=ref_butc_dissect_BUTC_ScanStatus_flags(tvb, offset, pinfo, tree, di, drep);
 	   offset=dissect_deferred_pointers(pinfo, tvb, offset, di, drep);

   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}

static int
butc_dissect_BUTC_GetServerInterfaces_request(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{

   return offset;
}

static int
butc_dissect_BUTC_GetServerInterfaces_response(tvbuff_t *tvb _U_, int offset _U_, packet_info *pinfo _U_, proto_tree *tree _U_, dcerpc_info* di _U_, uint8_t *drep _U_)
{
   offset=dissect_ntstatus(tvb, offset, pinfo, tree, di, drep, hf_butc_rc, NULL);


   return offset;
}
/* END OF INCLUDED FILE : ETH_CODE */



void
proto_register_butc(void)
{
        static hf_register_info hf[] = {



/* INCLUDED FILE : ETH_HFARR */
		{ &hf_butc_opnum,
		  { "Operation", "butc.opnum", FT_UINT16, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_rc,
		  { "Return code", "butc.rc", FT_UINT32, BASE_HEX|BASE_EXT_STRING,
		  &NT_errors_ext, 0,
		 NULL, HFILL }},

		{ &hf_butc_Restore_flags_TC_RESTORE_CREATE,
		  { "TC_RESTORE_CREATE", "butc.Restore_flags.TC_RESTORE_CREATE", FT_BOOLEAN, 32,
		  TFS(&TC_RESTORE_CREATE_tfs), 0x00000001,
		 NULL, HFILL }},

		{ &hf_butc_Restore_flags_TC_RESTORE_INCR,
		  { "TC_RESTORE_INCR", "butc.Restore_flags.TC_RESTORE_INCR", FT_BOOLEAN, 32,
		  TFS(&TC_RESTORE_INCR_tfs), 0x00000002,
		 NULL, HFILL }},

		{ &hf_butc_afsNetAddr_type,
		  { "type", "butc.afsNetAddr.type", FT_UINT16, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_afsNetAddr_data,
		  { "data", "butc.afsNetAddr.data", FT_UINT8, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpDesc_vid,
		  { "vid", "butc.tc_dumpDesc.vid", FT_UINT64, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpDesc_name,
		  { "name", "butc.tc_dumpDesc.name", FT_STRING, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpDesc_partition,
		  { "partition", "butc.tc_dumpDesc.partition", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpDesc_date,
		  { "date", "butc.tc_dumpDesc.date", FT_ABSOLUTE_TIME, ABSOLUTE_TIME_LOCAL,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpDesc_cloneDate,
		  { "cloneDate", "butc.tc_dumpDesc.cloneDate", FT_ABSOLUTE_TIME, ABSOLUTE_TIME_LOCAL,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpDesc_hostAddr,
		  { "hostAddr", "butc.tc_dumpDesc.hostAddr", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpDesc_spare1,
		  { "spare1", "butc.tc_dumpDesc.spare1", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpDesc_spare2,
		  { "spare2", "butc.tc_dumpDesc.spare2", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpDesc_spare3,
		  { "spare3", "butc.tc_dumpDesc.spare3", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpDesc_spare4,
		  { "spare4", "butc.tc_dumpDesc.spare4", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_frag,
		  { "frag", "butc.tc_restoreDesc.frag", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_tapeName,
		  { "tapeName", "butc.tc_restoreDesc.tapeName", FT_STRING, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_position,
		  { "position", "butc.tc_restoreDesc.position", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_origVid,
		  { "origVid", "butc.tc_restoreDesc.origVid", FT_UINT64, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_vid,
		  { "vid", "butc.tc_restoreDesc.vid", FT_UINT64, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_partition,
		  { "partition", "butc.tc_restoreDesc.partition", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_flags,
		  { "flags", "butc.tc_restoreDesc.flags", FT_UINT32, BASE_HEX,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_hostAddr,
		  { "hostAddr", "butc.tc_restoreDesc.hostAddr", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_realDumpId,
		  { "realDumpId", "butc.tc_restoreDesc.realDumpId", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_spare2,
		  { "spare2", "butc.tc_restoreDesc.spare2", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_spare3,
		  { "spare3", "butc.tc_restoreDesc.spare3", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_spare4,
		  { "spare4", "butc.tc_restoreDesc.spare4", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_oldName,
		  { "oldName", "butc.tc_restoreDesc.oldName", FT_STRING, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreDesc_newName,
		  { "newName", "butc.tc_restoreDesc.newName", FT_STRING, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpStat_dumpID,
		  { "dumpID", "butc.tc_dumpStat.dumpID", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpStat_bytesDumped,
		  { "bytesDumped", "butc.tc_dumpStat.bytesDumped", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpStat_volumeBeingDumped,
		  { "volumeBeingDumped", "butc.tc_dumpStat.volumeBeingDumped", FT_UINT64, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpStat_numVolErrs,
		  { "numVolErrs", "butc.tc_dumpStat.numVolErrs", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpStat_flags,
		  { "flags", "butc.tc_dumpStat.flags", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpStat_spare1,
		  { "spare1", "butc.tc_dumpStat.spare1", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpStat_spare2,
		  { "spare2", "butc.tc_dumpStat.spare2", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpStat_spare3,
		  { "spare3", "butc.tc_dumpStat.spare3", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpStat_spare4,
		  { "spare4", "butc.tc_dumpStat.spare4", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeLabel_size,
		  { "size", "butc.tc_tapeLabel.size", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeLabel_size_ext,
		  { "size_ext", "butc.tc_tapeLabel.size_ext", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeLabel_spare1,
		  { "spare1", "butc.tc_tapeLabel.spare1", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeLabel_spare2,
		  { "spare2", "butc.tc_tapeLabel.spare2", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeLabel_spare3,
		  { "spare3", "butc.tc_tapeLabel.spare3", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeLabel_spare4,
		  { "spare4", "butc.tc_tapeLabel.spare4", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeLabel_nameLen,
		  { "nameLen", "butc.tc_tapeLabel.nameLen", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeLabel_name,
		  { "name", "butc.tc_tapeLabel.name", FT_STRING, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeSet_id,
		  { "id", "butc.tc_tapeSet.id", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeSet_tapeServer,
		  { "tapeServer", "butc.tc_tapeSet.tapeServer", FT_STRING, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeSet_format,
		  { "format", "butc.tc_tapeSet.format", FT_STRING, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeSet_maxTapes,
		  { "maxTapes", "butc.tc_tapeSet.maxTapes", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeSet_a,
		  { "a", "butc.tc_tapeSet.a", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeSet_b,
		  { "b", "butc.tc_tapeSet.b", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeSet_expDate,
		  { "expDate", "butc.tc_tapeSet.expDate", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeSet_expType,
		  { "expType", "butc.tc_tapeSet.expType", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeSet_spare1,
		  { "spare1", "butc.tc_tapeSet.spare1", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeSet_spare2,
		  { "spare2", "butc.tc_tapeSet.spare2", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeSet_spare3,
		  { "spare3", "butc.tc_tapeSet.spare3", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tapeSet_spare4,
		  { "spare4", "butc.tc_tapeSet.spare4", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tcInfo_tcVersion,
		  { "tcVersion", "butc.tc_tcInfo.tcVersion", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tcInfo_spare1,
		  { "spare1", "butc.tc_tcInfo.spare1", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tcInfo_spare2,
		  { "spare2", "butc.tc_tcInfo.spare2", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tcInfo_spare3,
		  { "spare3", "butc.tc_tcInfo.spare3", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_tcInfo_spare4,
		  { "spare4", "butc.tc_tcInfo.spare4", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreArray_tc_restoreArray_len,
		  { "tc_restoreArray_len", "butc.tc_restoreArray.tc_restoreArray_len", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_restoreArray_tc_restoreArray_val,
		  { "tc_restoreArray_val", "butc.tc_restoreArray.tc_restoreArray_val", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpArray_tc_dumpArray_len,
		  { "tc_dumpArray_len", "butc.tc_dumpArray.tc_dumpArray_len", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpArray_tc_dumpArray,
		  { "tc_dumpArray", "butc.tc_dumpArray.tc_dumpArray", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpInterface_dumpPath,
		  { "dumpPath", "butc.tc_dumpInterface.dumpPath", FT_STRING, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpInterface_volumeSetName,
		  { "volumeSetName", "butc.tc_dumpInterface.volumeSetName", FT_STRING, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpInterface_dumpName,
		  { "dumpName", "butc.tc_dumpInterface.dumpName", FT_STRING, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpInterface_tapeSet,
		  { "tapeSet", "butc.tc_dumpInterface.tapeSet", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpInterface_parentDumpId,
		  { "parentDumpId", "butc.tc_dumpInterface.parentDumpId", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpInterface_dumpLevel,
		  { "dumpLevel", "butc.tc_dumpInterface.dumpLevel", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpInterface_spare1,
		  { "spare1", "butc.tc_dumpInterface.spare1", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpInterface_spare2,
		  { "spare2", "butc.tc_dumpInterface.spare2", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpInterface_spare3,
		  { "spare3", "butc.tc_dumpInterface.spare3", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_dumpInterface_spare4,
		  { "spare4", "butc.tc_dumpInterface.spare4", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitchVol_nKBytes,
		  { "nKBytes", "butc.tc_statusInfoSwitchVol.nKBytes", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitchVol_volumeName,
		  { "volumeName", "butc.tc_statusInfoSwitchVol.volumeName", FT_STRING, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitchVol_volsFailed,
		  { "volsFailed", "butc.tc_statusInfoSwitchVol.volsFailed", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitchVol_spare1,
		  { "spare1", "butc.tc_statusInfoSwitchVol.spare1", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitchLabel_tapeLabel,
		  { "tapeLabel", "butc.tc_statusInfoSwitchLabel.tapeLabel", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitchLabel_spare1,
		  { "spare1", "butc.tc_statusInfoSwitchLabel.spare1", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitch_TCOP_NONE_none,
		  { "none", "butc.tc_statusInfoSwitch.none", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitch_TCOP_DUMP_vol,
		  { "vol", "butc.tc_statusInfoSwitch.vol", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitch_TCOP_RESTORE_vol,
		  { "vol", "butc.tc_statusInfoSwitch.vol", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitch_TCOP_LABELTAPE_label,
		  { "label", "butc.tc_statusInfoSwitch.label", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitch_TCOP_READLABEL_label,
		  { "label", "butc.tc_statusInfoSwitch.label", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitch_TCOP_SCANTAPE_spare1,
		  { "spare1", "butc.tc_statusInfoSwitch.spare1", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitch_TCOP_STATUS_spare2,
		  { "spare2", "butc.tc_statusInfoSwitch.spare2", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitch_TCOP_SAVEDB_spare3,
		  { "spare3", "butc.tc_statusInfoSwitch.spare3", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitch_TCOP_RESTOREDB_spare4,
		  { "spare4", "butc.tc_statusInfoSwitch.spare4", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tc_statusInfoSwitch_TCOP_SPARE_spare5,
		  { "spare5", "butc.tc_statusInfoSwitch.spare5", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tciStatusS_taskName,
		  { "taskName", "butc.tciStatusS.taskName", FT_STRING, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tciStatusS_flags,
		  { "flags", "butc.tciStatusS.flags", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tciStatusS_lastPolled,
		  { "lastPolled", "butc.tciStatusS.lastPolled", FT_ABSOLUTE_TIME, ABSOLUTE_TIME_LOCAL,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tciStatusS_info,
		  { "info", "butc.tciStatusS.info", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tciStatusS_taskId,
		  { "taskId", "butc.tciStatusS.taskId", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tciStatusS_spare2,
		  { "spare2", "butc.tciStatusS.spare2", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tciStatusS_spare3,
		  { "spare3", "butc.tciStatusS.spare3", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_tciStatusS_spare4,
		  { "spare4", "butc.tciStatusS.spare4", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_PerformDump_tcdiPtr,
		  { "tcdiPtr", "butc.BUTC_PerformDump.tcdiPtr", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_PerformDump_dumps,
		  { "dumps", "butc.BUTC_PerformDump.dumps", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_PerformDump_dumpID,
		  { "dumpID", "butc.BUTC_PerformDump.dumpID", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_PerformRestore_dumpSetName,
		  { "dumpSetName", "butc.BUTC_PerformRestore.dumpSetName", FT_STRING, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_PerformRestore_restores,
		  { "restores", "butc.BUTC_PerformRestore.restores", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_PerformRestore_dumpID,
		  { "dumpID", "butc.BUTC_PerformRestore.dumpID", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_AbortDump_dumpID,
		  { "dumpID", "butc.BUTC_AbortDump.dumpID", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_LabelTape_label,
		  { "label", "butc.BUTC_LabelTape.label", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_LabelTape_taskId,
		  { "taskId", "butc.BUTC_LabelTape.taskId", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_ReadLabel_taskId,
		  { "taskId", "butc.BUTC_ReadLabel.taskId", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_ScanDumps_addDbFlag,
		  { "addDbFlag", "butc.BUTC_ScanDumps.addDbFlag", FT_INT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_ScanDumps_taskId,
		  { "taskId", "butc.BUTC_ScanDumps.taskId", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_TCInfo_tciptr,
		  { "tciptr", "butc.BUTC_TCInfo.tciptr", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_SaveDb_taskId,
		  { "taskId", "butc.BUTC_SaveDb.taskId", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_RestoreDb_taskId,
		  { "taskId", "butc.BUTC_RestoreDb.taskId", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_EndStatus_taskId,
		  { "taskId", "butc.BUTC_EndStatus.taskId", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_GetStatus_taskId,
		  { "taskId", "butc.BUTC_GetStatus.taskId", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_GetStatus_statusPtr,
		  { "statusPtr", "butc.BUTC_GetStatus.statusPtr", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_RequestAbort_taskId,
		  { "taskId", "butc.BUTC_RequestAbort.taskId", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_ScanStatus_taskId,
		  { "taskId", "butc.BUTC_ScanStatus.taskId", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_ScanStatus_statusPtr,
		  { "statusPtr", "butc.BUTC_ScanStatus.statusPtr", FT_NONE, BASE_NONE,
		  NULL, 0,
		 NULL, HFILL }},

		{ &hf_butc_BUTC_ScanStatus_flags,
		  { "flags", "butc.BUTC_ScanStatus.flags", FT_UINT32, BASE_DEC,
		  NULL, 0,
		 NULL, HFILL }},

/* END OF INCLUDED FILE : ETH_HFARR */


	};

        static int *ett[] = {


/* INCLUDED FILE : ETH_ETTARR */
		 &ett_butc,
		 &ett_butc_Restore_flags,
		 &ett_butc_afsNetAddr,
		 &ett_butc_tc_dumpDesc,
		 &ett_butc_tc_restoreDesc,
		 &ett_butc_tc_dumpStat,
		 &ett_butc_tc_tapeLabel,
		 &ett_butc_tc_tapeSet,
		 &ett_butc_tc_tcInfo,
		 &ett_butc_tc_restoreArray,
		 &ett_butc_tc_dumpArray,
		 &ett_butc_tc_dumpInterface,
		 &ett_butc_tc_statusInfoSwitchVol,
		 &ett_butc_tc_statusInfoSwitchLabel,
		 &ett_butc_tc_statusInfoSwitch,
		 &ett_butc_tciStatusS,
/* END OF INCLUDED FILE : ETH_ETTARR */


        };

        proto_butc = proto_register_protocol("DCE/RPC BUTC", "BUTC", "butc");
	proto_register_field_array(proto_butc, hf, array_length(hf));
        proto_register_subtree_array(ett, array_length(ett));
}

static const dcerpc_sub_dissector function_dissectors[] = {


/* INCLUDED FILE : ETH_FT */
	 { 0, "BUTC_PerformDump",
		 butc_dissect_BUTC_PerformDump_request,
		 butc_dissect_BUTC_PerformDump_response },
	 { 1, "BUTC_PerformRestore",
		 butc_dissect_BUTC_PerformRestore_request,
		 butc_dissect_BUTC_PerformRestore_response },
	 { 2, "BUTC_AbortDump",
		 butc_dissect_BUTC_AbortDump_request,
		 butc_dissect_BUTC_AbortDump_response },
	 { 3, "BUTC_LabelTape",
		 butc_dissect_BUTC_LabelTape_request,
		 butc_dissect_BUTC_LabelTape_response },
	 { 4, "BUTC_ReadLabel",
		 butc_dissect_BUTC_ReadLabel_request,
		 butc_dissect_BUTC_ReadLabel_response },
	 { 5, "BUTC_ScanDumps",
		 butc_dissect_BUTC_ScanDumps_request,
		 butc_dissect_BUTC_ScanDumps_response },
	 { 6, "BUTC_TCInfo",
		 butc_dissect_BUTC_TCInfo_request,
		 butc_dissect_BUTC_TCInfo_response },
	 { 7, "BUTC_SaveDb",
		 butc_dissect_BUTC_SaveDb_request,
		 butc_dissect_BUTC_SaveDb_response },
	 { 8, "BUTC_RestoreDb",
		 butc_dissect_BUTC_RestoreDb_request,
		 butc_dissect_BUTC_RestoreDb_response },
	 { 9, "BUTC_EndStatus",
		 butc_dissect_BUTC_EndStatus_request,
		 butc_dissect_BUTC_EndStatus_response },
	 { 10, "BUTC_GetStatus",
		 butc_dissect_BUTC_GetStatus_request,
		 butc_dissect_BUTC_GetStatus_response },
	 { 11, "BUTC_RequestAbort",
		 butc_dissect_BUTC_RequestAbort_request,
		 butc_dissect_BUTC_RequestAbort_response },
	 { 12, "BUTC_ScanStatus",
		 butc_dissect_BUTC_ScanStatus_request,
		 butc_dissect_BUTC_ScanStatus_response },
	 { 13, "BUTC_GetServerInterfaces",
		 butc_dissect_BUTC_GetServerInterfaces_request,
		 butc_dissect_BUTC_GetServerInterfaces_response },
/* END OF INCLUDED FILE : ETH_FT */


	{ 0, NULL, NULL, NULL },
};

void
proto_reg_handoff_butc(void)
{


/* INCLUDED FILE : ETH_HANDOFF */
	  dcerpc_init_uuid(proto_butc, ett_butc,
		  &uuid_dcerpc_butc, ver_butc,
		  function_dissectors, hf_butc_opnum);
/* END OF INCLUDED FILE : ETH_HANDOFF */


}
