"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WlmPlugin = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const WlmPlugin = function (Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.wlm = components.clientAction.namespaceFactory();
  const wlm = Client.prototype.wlm.prototype;

  // Get WLM stats across all nodes
  wlm.getStats = ca({
    url: {
      fmt: '/_wlm/stats'
    },
    method: 'GET'
  });

  // Get WLM stats for a specific node
  wlm.getNodeStats = ca({
    url: {
      fmt: '/_wlm/<%=nodeId%>/stats',
      req: {
        nodeId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });

  // List all workload groups
  wlm.getWorkloadGroups = ca({
    url: {
      fmt: '/_wlm/workload_group'
    },
    method: 'GET'
  });

  // Get workload group by name
  wlm.getWorkloadGroup = ca({
    url: {
      fmt: '/_wlm/workload_group/<%=name%>',
      req: {
        name: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });

  // Create workload group
  wlm.createWorkloadGroup = ca({
    url: {
      fmt: '/_wlm/workload_group'
    },
    method: 'PUT',
    needBody: true
  });

  // Update workload group
  wlm.updateWorkloadGroup = ca({
    url: {
      fmt: '/_wlm/workload_group/<%=name%>',
      req: {
        name: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'PUT',
    needBody: true
  });

  // Delete workload group
  wlm.deleteWorkloadGroup = ca({
    url: {
      fmt: '/_wlm/workload_group/<%=name%>',
      req: {
        name: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });

  // Get stats for specific workload group
  wlm.getWorkloadGroupStats = ca({
    url: {
      fmt: '/_wlm/stats/<%=workloadGroupId%>',
      req: {
        workloadGroupId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });

  // Create index rule
  wlm.createRule = ca({
    url: {
      fmt: '/_rules/workload_group'
    },
    method: 'PUT',
    needBody: true
  });

  // Get all index rules
  wlm.getRules = ca({
    url: {
      fmt: '/_rules/workload_group'
    },
    method: 'GET'
  });

  // Delete index rule
  wlm.deleteRule = ca({
    url: {
      fmt: '/_rules/workload_group/<%=ruleId%>',
      req: {
        ruleId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'DELETE'
  });

  // Update index rule
  wlm.updateRule = ca({
    url: {
      fmt: '/_rules/workload_group/<%=ruleId%>',
      req: {
        ruleId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'PUT',
    needBody: true
  });

  // Get node level cpu and memory threshold
  wlm.getThresholds = ca({
    url: {
      fmt: '/_cluster/settings'
    },
    method: 'GET',
    needBody: false,
    qs: ['include_defaults']
  });
};
exports.WlmPlugin = WlmPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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