"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryInsightsDashboardsPlugin = void 0;
var _queryInsightsPlugin = require("./clusters/queryInsightsPlugin");
var _wlmPlugin = require("./clusters/wlmPlugin");
var _routes = require("./routes");
var _wlmRoutes = require("./routes/wlmRoutes");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class QueryInsightsDashboardsPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, {
    dataSource
  }) {
    const dataSourceEnabled = !!dataSource;
    const router = core.http.createRouter();
    const queryInsightsClient = core.opensearch.legacy.createClient('opensearch_queryInsights', {
      plugins: [_queryInsightsPlugin.QueryInsightsPlugin]
    });
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_queryInsightsPlugin.QueryInsightsPlugin);
    }

    // @ts-ignore
    core.http.registerRouteHandlerContext('queryInsights_plugin', (_context, _request) => {
      return {
        logger: this.logger,
        queryInsightsClient
      };
    });
    // Register WLM custom client
    const wlmClient = core.opensearch.legacy.createClient('opensearch_wlm', {
      plugins: [_wlmPlugin.WlmPlugin]
    });
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_wlmPlugin.WlmPlugin);
    }

    // @ts-ignore - Register WLM context
    core.http.registerRouteHandlerContext('wlm_plugin', (_context, _request) => {
      return {
        logger: this.logger,
        wlmClient
      };
    });

    // Register server side APIs
    (0, _routes.defineRoutes)(router, dataSourceEnabled);
    (0, _wlmRoutes.defineWlmRoutes)(router, dataSourceEnabled);
    return {};
  }
  start(_core) {
    this.logger.debug('query-insights-dashboards: Started');
    return {};
  }
  stop() {}
}
exports.QueryInsightsDashboardsPlugin = QueryInsightsDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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