/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.lang.EvalJavaBsh;
import com.sun.electric.tool.lang.EvalJython;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractTest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ScriptingTest
extends AbstractTest {
    public ScriptingTest(String name) {
        super(name);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        if (EvalJavaBsh.hasBeanShell()) {
            list.add(new ScriptingTest("BeanShell"));
        }
        if (EvalJython.hasJython()) {
            list.add(new ScriptingTest("Jython"));
        }
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/Scripting/output/";
    }

    public Boolean BeanShell() {
        String testParameter = this.createMessageOutput();
        String fileName = ScriptingTest.dataDir(this.getRegressionPath(), testParameter) + "BSH_MakeInverter.bsh";
        EvalJavaBsh evaluator = new EvalJavaBsh();
        try {
            evaluator.doSource(fileName);
        }
        catch (JobException e) {
            return Boolean.FALSE;
        }
        Cell lay = Library.findLibrary("BeanShellTest").findNodeProto("InverterJ{lay}");
        if (lay == null) {
            System.out.println("InverterJ cell in BeanShellTest not found");
            return Boolean.FALSE;
        }
        lay.lowLevelSetCreationDate(new Date(0L));
        return this.compareCellResults(lay, this.getResultName());
    }

    public Boolean Jython() {
        String testParameter = this.createMessageOutput();
        String fileName = ScriptingTest.dataDir(this.getRegressionPath(), testParameter) + "JY_MakeInverter.jy";
        EvalJython.runScriptNoJob(fileName);
        Cell lay = Library.findLibrary("JythonTest").findNodeProto("InverterP{lay}");
        if (lay == null) {
            System.out.println("InverterJ cell in JythonTest not found");
            return Boolean.FALSE;
        }
        lay.lowLevelSetCreationDate(new Date(0L));
        return this.compareCellResults(lay, this.getResultName());
    }
}

