/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.runtime.taskParallel;

import com.sun.electric.tool.util.concurrent.datastructures.IStructure;
import com.sun.electric.tool.util.concurrent.patterns.PTask;
import com.sun.electric.tool.util.concurrent.runtime.ThreadID;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.PoolWorkerStrategy;
import java.util.concurrent.Semaphore;

public class SynchronizedWorker
extends PoolWorkerStrategy {
    protected IStructure<PTask> taskPool = null;
    protected Semaphore sem;

    public SynchronizedWorker(IStructure<PTask> taskPool, Semaphore sem) {
        this.taskPool = taskPool;
        this.abort = false;
        this.sem = sem;
    }

    @Override
    public void trigger() {
        this.sem.release();
    }

    @Override
    public void execute() {
        this.threadId = ThreadID.get();
        this.executed = 0;
        while (!this.abort) {
            this.checkForWait();
            this.sem.acquireUninterruptibly();
            PTask task = this.taskPool.remove();
            if (task != null) {
                try {
                    task.setThreadID(ThreadID.get());
                    task.before();
                    task.execute();
                    ++this.executed;
                    continue;
                }
                finally {
                    task.after();
                    continue;
                }
            }
            Thread.yield();
        }
    }
}

