/* -*- mode:c -*-
 *
 * Copyright 2020 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/* Declare symbolic names for all the GPIOs that we care about.
 * Note: Those with interrupt handlers must be declared first. */

GPIO_INT(WP_L,           PIN(I, 4), GPIO_INT_BOTH | GPIO_PULL_UP,   switch_interrupt)          /* Write protect input */
#ifdef CONFIG_LOW_POWER_IDLE
GPIO_INT(UART1_RX,       PIN(B, 0), GPIO_INT_FALLING | GPIO_PULL_UP, uart_deepsleep_interrupt) /* UART1 RX input */
#endif

/*
 * Because HW port0 and port1 cc pin order invert, FW invert it again.
 * ex. FW portA pins are mapping to: HW port1 GPF4, GPF5, ADC7, Vbus, Vconn.
 *     FW portB pins are mapping to: HW port0 GPH1, GPH2, ADC3, Vbus, Vconn.
 *     FW portC pins are mapping to: HW port3 GPP0, GPP1, ADC16, Vbus, Vconn.
 */
GPIO(USBPD_PORTA_VBUS_SEN1P1, PIN(J, 0), GPIO_OUT_LOW)  /* VBUSSEN1P1 */
GPIO(USBPD_PORTA_VBUS_DROP,   PIN(F, 3), GPIO_OUT_LOW)  /* VBUSDISP1 */
GPIO(USBPD_PORTA_VBUS_OUTPUT, PIN(F, 1), GPIO_OUT_LOW)  /* VBUSOUTSWENP1 */
GPIO(USBPD_PORTA_VBUS_INPUT,  PIN(E, 3), GPIO_OUT_HIGH) /* VBUSINSWENP1 */
GPIO(USBPD_PORTA_VBUS_OV_OC,  PIN(C, 3), GPIO_INPUT)    /* VSWFLTP1 1? */
GPIO(USBPD_PORTA_CC1_VCONN,   PIN(E, 1), GPIO_OUT_LOW)
GPIO(USBPD_PORTA_CC2_VCONN,   PIN(J, 5), GPIO_OUT_LOW)
GPIO(USBPD_PORTA_VCONN_OV_OC, PIN(B, 5), GPIO_INPUT)    /* VCONSWFLTP1 1? */
GPIO(USBPD_PORTB_VBUS_SEN1P0, PIN(H, 0), GPIO_OUT_LOW)  /* VBUSSEN1P0 */
GPIO(USBPD_PORTB_VBUS_DROP,   PIN(D, 5), GPIO_OUT_LOW)  /* VBUSDISP0 */
GPIO(USBPD_PORTB_VBUS_OUTPUT, PIN(A, 6), GPIO_OUT_LOW)  /* VBUSOUTSWENP0 */
GPIO(USBPD_PORTB_VBUS_INPUT,  PIN(A, 7), GPIO_OUT_HIGH) /* VBUSINSWENP0 */
GPIO(USBPD_PORTB_VBUS_OV_OC,  PIN(D, 2), GPIO_INPUT)    /* VSWFLTP0 */
GPIO(USBPD_PORTB_CC1_VCONN,   PIN(A, 5), GPIO_OUT_LOW)
GPIO(USBPD_PORTB_CC2_VCONN,   PIN(A, 4), GPIO_OUT_LOW)
GPIO(USBPD_PORTB_VCONN_OV_OC, PIN(D, 4), GPIO_INPUT)    /* VCONSWFLTP0 */
GPIO(USBPD_PORTC_VBUS_SEN1P3, PIN(P, 2), GPIO_OUT_LOW)  /* VBUSSEN1P3 */
GPIO(USBPD_PORTC_VBUS_DROP,   PIN(P, 3), GPIO_OUT_LOW)  /* VBUSDISP3 */
GPIO(USBPD_PORTC_VBUS_OUTPUT, PIN(P, 4), GPIO_OUT_LOW)  /* VBUSOUTSWENP3 */
GPIO(USBPD_PORTC_VBUS_INPUT,  PIN(P, 5), GPIO_OUT_HIGH) /* VBUSINSWENP3 */
GPIO(USBPD_PORTC_VBUS_OV_OC,  PIN(P, 6), GPIO_INPUT)    /* VSWFLTP3 */
GPIO(USBPD_PORTC_CC1_VCONN,   PIN(O, 0), GPIO_OUT_LOW)
GPIO(USBPD_PORTC_CC2_VCONN,   PIN(O, 1), GPIO_OUT_LOW)
GPIO(USBPD_PORTC_VCONN_OV_OC, PIN(O, 2), GPIO_INPUT)    /* VCONSWFLTP3 */

GPIO(I2C_A_SCL,      PIN(B, 3), GPIO_INPUT)
GPIO(I2C_A_SDA,      PIN(B, 4), GPIO_INPUT)
GPIO(I2C_B_SCL,      PIN(C, 1), GPIO_INPUT)
GPIO(I2C_B_SDA,      PIN(C, 2), GPIO_INPUT)
GPIO(I2C_C_SCL,      PIN(F, 6), GPIO_INPUT)
GPIO(I2C_C_SDA,      PIN(F, 7), GPIO_INPUT)
GPIO(I2C_E_SCL,      PIN(E, 0), GPIO_INPUT)
GPIO(I2C_E_SDA,      PIN(E, 7), GPIO_INPUT)

/* KSO/KSI pins can be used as GPIO input. */
GPIO(BOARD_VERSION1, PIN(KSO_H, 5), GPIO_INPUT)
GPIO(BOARD_VERSION2, PIN(KSO_H, 6), GPIO_INPUT)
GPIO(BOARD_VERSION3, PIN(KSO_H, 7), GPIO_INPUT)

/* Unimplemented signals which we need to emulate for now */
UNIMPLEMENTED(ENTERING_RW)
UNIMPLEMENTED(PCH_SCI_L)
UNIMPLEMENTED(PCH_WAKE_L)
UNIMPLEMENTED(POWER_BUTTON_L)
UNIMPLEMENTED(LID_OPEN)

ALTERNATE(PIN_MASK(B, 0x03), 1, MODULE_UART, GPIO_PULL_UP) /* UART1 */
ALTERNATE(PIN_MASK(B, 0x18), 1, MODULE_I2C, 0)             /* I2C A SCL/SDA */
ALTERNATE(PIN_MASK(C, 0x06), 1, MODULE_I2C, 0)             /* I2C B SCL/SDA */
ALTERNATE(PIN_MASK(F, 0xC0), 1, MODULE_I2C, 0)             /* I2C C SCL/SDA */
ALTERNATE(PIN_MASK(E, 0x81), 1, MODULE_I2C, 0)             /* I2C E SCL/SDA E0/E7 */
ALTERNATE(PIN_MASK(I, 0x88), 1, MODULE_ADC, 0)             /* ADC CH3, CH7 */
ALTERNATE(PIN_MASK(L, 0x0F), 1, MODULE_ADC, 0)             /* ADC CH13-CH16 */
