// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2017 Western Digital Corporation or its affiliates.
 *
 * This file is released under the GPL.
 */

#include <linux/blkdev.h>
#include "blk-mq-debugfs.h"

int queue_zone_wlock_show(void *data, struct seq_file *m)
{
	struct request_queue *q = data;
	unsigned int i;

	if (!q->seq_zones_wlock)
		return 0;

	for (i = 0; i < q->nr_zones; i++)
		if (test_bit(i, q->seq_zones_wlock))
			seq_printf(m, "%u\n", i);

	return 0;
}
