/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * GPIO driver for AMD
 *
 * Copyright (c) 2014,2015 Ken Xue <Ken.Xue@amd.com>
 *		Jeff Wu <Jeff.Wu@amd.com>
 */

#ifndef _PINCTRL_AMD_H
#define _PINCTRL_AMD_H

#define AMD_GPIO_PINS_PER_BANK  64

#define AMD_GPIO_PINS_BANK0     63
#define AMD_GPIO_PINS_BANK1     64
#define AMD_GPIO_PINS_BANK2     56
#define AMD_GPIO_PINS_BANK3     32

#define WAKE_INT_MASTER_REG 0xfc
#define INTERNAL_GPIO0_DEBOUNCE (1 << 15)
#define EOI_MASK (1 << 29)

#define WAKE_INT_STATUS_REG0 0x2f8
#define WAKE_INT_STATUS_REG1 0x2fc

#define DB_TMR_OUT_OFF			0
#define DB_TMR_OUT_UNIT_OFF		4
#define DB_CNTRL_OFF			5
#define DB_TMR_LARGE_OFF		7
#define LEVEL_TRIG_OFF			8
#define ACTIVE_LEVEL_OFF		9
#define INTERRUPT_ENABLE_OFF		11
#define INTERRUPT_MASK_OFF		12
#define WAKE_CNTRL_OFF_S0I3             13
#define WAKE_CNTRL_OFF_S3               14
#define WAKE_CNTRL_OFF_S4               15
#define PIN_STS_OFF			16
#define DRV_STRENGTH_SEL_OFF		17
#define PULL_UP_ENABLE_OFF		20
#define PULL_DOWN_ENABLE_OFF		21
#define OUTPUT_VALUE_OFF		22
#define OUTPUT_ENABLE_OFF		23
#define SW_CNTRL_IN_OFF			24
#define SW_CNTRL_EN_OFF			25
#define WAKECNTRL_Z_OFF			27
#define INTERRUPT_STS_OFF		28
#define WAKE_STS_OFF			29

#define DB_TMR_OUT_MASK	0xFUL
#define DB_CNTRl_MASK	0x3UL
#define ACTIVE_LEVEL_MASK	0x3UL
#define DRV_STRENGTH_SEL_MASK	0x3UL

#define ACTIVE_LEVEL_HIGH	0x0UL
#define ACTIVE_LEVEL_LOW	0x1UL
#define ACTIVE_LEVEL_BOTH	0x2UL

#define DB_TYPE_NO_DEBOUNCE               0x0UL
#define DB_TYPE_PRESERVE_LOW_GLITCH       0x1UL
#define DB_TYPE_PRESERVE_HIGH_GLITCH      0x2UL
#define DB_TYPE_REMOVE_GLITCH             0x3UL

#define EDGE_TRAGGER	0x0UL
#define LEVEL_TRIGGER	0x1UL

#define ACTIVE_HIGH	0x0UL
#define ACTIVE_LOW	0x1UL
#define BOTH_EADGE	0x2UL

#define ENABLE_INTERRUPT	0x1UL
#define DISABLE_INTERRUPT	0x0UL

#define ENABLE_INTERRUPT_MASK	0x0UL
#define DISABLE_INTERRUPT_MASK	0x1UL

#define CLR_INTR_STAT	0x1UL

#define NSELECTS	0x4

#define FUNCTION_MASK		GENMASK(1, 0)
#define FUNCTION_INVALID	GENMASK(7, 0)

struct amd_function {
	const char *name;
	const char * const groups[NSELECTS];
	unsigned ngroups;
	int index;
};

struct amd_gpio {
	raw_spinlock_t          lock;
	void __iomem            *base;
	void __iomem            *iomux_base;

	const struct pingroup *groups;
	u32 ngroups;
	struct pinctrl_dev *pctrl;
	struct gpio_chip        gc;
	unsigned int            hwbank_num;
	struct resource         *res;
	struct platform_device  *pdev;
	u32			*saved_regs;
	int			irq;
};

/*  KERNCZ configuration*/
static const struct pinctrl_pin_desc kerncz_pins[] = {
	PINCTRL_PIN(0, "GPIO_0"),
	PINCTRL_PIN(1, "GPIO_1"),
	PINCTRL_PIN(2, "GPIO_2"),
	PINCTRL_PIN(3, "GPIO_3"),
	PINCTRL_PIN(4, "GPIO_4"),
	PINCTRL_PIN(5, "GPIO_5"),
	PINCTRL_PIN(6, "GPIO_6"),
	PINCTRL_PIN(7, "GPIO_7"),
	PINCTRL_PIN(8, "GPIO_8"),
	PINCTRL_PIN(9, "GPIO_9"),
	PINCTRL_PIN(10, "GPIO_10"),
	PINCTRL_PIN(11, "GPIO_11"),
	PINCTRL_PIN(12, "GPIO_12"),
	PINCTRL_PIN(13, "GPIO_13"),
	PINCTRL_PIN(14, "GPIO_14"),
	PINCTRL_PIN(15, "GPIO_15"),
	PINCTRL_PIN(16, "GPIO_16"),
	PINCTRL_PIN(17, "GPIO_17"),
	PINCTRL_PIN(18, "GPIO_18"),
	PINCTRL_PIN(19, "GPIO_19"),
	PINCTRL_PIN(20, "GPIO_20"),
	PINCTRL_PIN(21, "GPIO_21"),
	PINCTRL_PIN(22, "GPIO_22"),
	PINCTRL_PIN(23, "GPIO_23"),
	PINCTRL_PIN(24, "GPIO_24"),
	PINCTRL_PIN(25, "GPIO_25"),
	PINCTRL_PIN(26, "GPIO_26"),
	PINCTRL_PIN(27, "GPIO_27"),
	PINCTRL_PIN(28, "GPIO_28"),
	PINCTRL_PIN(29, "GPIO_29"),
	PINCTRL_PIN(30, "GPIO_30"),
	PINCTRL_PIN(31, "GPIO_31"),
	PINCTRL_PIN(32, "GPIO_32"),
	PINCTRL_PIN(33, "GPIO_33"),
	PINCTRL_PIN(34, "GPIO_34"),
	PINCTRL_PIN(35, "GPIO_35"),
	PINCTRL_PIN(36, "GPIO_36"),
	PINCTRL_PIN(37, "GPIO_37"),
	PINCTRL_PIN(38, "GPIO_38"),
	PINCTRL_PIN(39, "GPIO_39"),
	PINCTRL_PIN(40, "GPIO_40"),
	PINCTRL_PIN(41, "GPIO_41"),
	PINCTRL_PIN(42, "GPIO_42"),
	PINCTRL_PIN(43, "GPIO_43"),
	PINCTRL_PIN(44, "GPIO_44"),
	PINCTRL_PIN(45, "GPIO_45"),
	PINCTRL_PIN(46, "GPIO_46"),
	PINCTRL_PIN(47, "GPIO_47"),
	PINCTRL_PIN(48, "GPIO_48"),
	PINCTRL_PIN(49, "GPIO_49"),
	PINCTRL_PIN(50, "GPIO_50"),
	PINCTRL_PIN(51, "GPIO_51"),
	PINCTRL_PIN(52, "GPIO_52"),
	PINCTRL_PIN(53, "GPIO_53"),
	PINCTRL_PIN(54, "GPIO_54"),
	PINCTRL_PIN(55, "GPIO_55"),
	PINCTRL_PIN(56, "GPIO_56"),
	PINCTRL_PIN(57, "GPIO_57"),
	PINCTRL_PIN(58, "GPIO_58"),
	PINCTRL_PIN(59, "GPIO_59"),
	PINCTRL_PIN(60, "GPIO_60"),
	PINCTRL_PIN(61, "GPIO_61"),
	PINCTRL_PIN(62, "GPIO_62"),
	PINCTRL_PIN(64, "GPIO_64"),
	PINCTRL_PIN(65, "GPIO_65"),
	PINCTRL_PIN(66, "GPIO_66"),
	PINCTRL_PIN(67, "GPIO_67"),
	PINCTRL_PIN(68, "GPIO_68"),
	PINCTRL_PIN(69, "GPIO_69"),
	PINCTRL_PIN(70, "GPIO_70"),
	PINCTRL_PIN(71, "GPIO_71"),
	PINCTRL_PIN(72, "GPIO_72"),
	PINCTRL_PIN(73, "GPIO_73"),
	PINCTRL_PIN(74, "GPIO_74"),
	PINCTRL_PIN(75, "GPIO_75"),
	PINCTRL_PIN(76, "GPIO_76"),
	PINCTRL_PIN(77, "GPIO_77"),
	PINCTRL_PIN(78, "GPIO_78"),
	PINCTRL_PIN(79, "GPIO_79"),
	PINCTRL_PIN(80, "GPIO_80"),
	PINCTRL_PIN(81, "GPIO_81"),
	PINCTRL_PIN(82, "GPIO_82"),
	PINCTRL_PIN(83, "GPIO_83"),
	PINCTRL_PIN(84, "GPIO_84"),
	PINCTRL_PIN(85, "GPIO_85"),
	PINCTRL_PIN(86, "GPIO_86"),
	PINCTRL_PIN(87, "GPIO_87"),
	PINCTRL_PIN(88, "GPIO_88"),
	PINCTRL_PIN(89, "GPIO_89"),
	PINCTRL_PIN(90, "GPIO_90"),
	PINCTRL_PIN(91, "GPIO_91"),
	PINCTRL_PIN(92, "GPIO_92"),
	PINCTRL_PIN(93, "GPIO_93"),
	PINCTRL_PIN(94, "GPIO_94"),
	PINCTRL_PIN(95, "GPIO_95"),
	PINCTRL_PIN(96, "GPIO_96"),
	PINCTRL_PIN(97, "GPIO_97"),
	PINCTRL_PIN(98, "GPIO_98"),
	PINCTRL_PIN(99, "GPIO_99"),
	PINCTRL_PIN(100, "GPIO_100"),
	PINCTRL_PIN(101, "GPIO_101"),
	PINCTRL_PIN(102, "GPIO_102"),
	PINCTRL_PIN(103, "GPIO_103"),
	PINCTRL_PIN(104, "GPIO_104"),
	PINCTRL_PIN(105, "GPIO_105"),
	PINCTRL_PIN(106, "GPIO_106"),
	PINCTRL_PIN(107, "GPIO_107"),
	PINCTRL_PIN(108, "GPIO_108"),
	PINCTRL_PIN(109, "GPIO_109"),
	PINCTRL_PIN(110, "GPIO_110"),
	PINCTRL_PIN(111, "GPIO_111"),
	PINCTRL_PIN(112, "GPIO_112"),
	PINCTRL_PIN(113, "GPIO_113"),
	PINCTRL_PIN(114, "GPIO_114"),
	PINCTRL_PIN(115, "GPIO_115"),
	PINCTRL_PIN(116, "GPIO_116"),
	PINCTRL_PIN(117, "GPIO_117"),
	PINCTRL_PIN(118, "GPIO_118"),
	PINCTRL_PIN(119, "GPIO_119"),
	PINCTRL_PIN(120, "GPIO_120"),
	PINCTRL_PIN(121, "GPIO_121"),
	PINCTRL_PIN(122, "GPIO_122"),
	PINCTRL_PIN(123, "GPIO_123"),
	PINCTRL_PIN(124, "GPIO_124"),
	PINCTRL_PIN(125, "GPIO_125"),
	PINCTRL_PIN(126, "GPIO_126"),
	PINCTRL_PIN(127, "GPIO_127"),
	PINCTRL_PIN(128, "GPIO_128"),
	PINCTRL_PIN(129, "GPIO_129"),
	PINCTRL_PIN(130, "GPIO_130"),
	PINCTRL_PIN(131, "GPIO_131"),
	PINCTRL_PIN(132, "GPIO_132"),
	PINCTRL_PIN(133, "GPIO_133"),
	PINCTRL_PIN(134, "GPIO_134"),
	PINCTRL_PIN(135, "GPIO_135"),
	PINCTRL_PIN(136, "GPIO_136"),
	PINCTRL_PIN(137, "GPIO_137"),
	PINCTRL_PIN(138, "GPIO_138"),
	PINCTRL_PIN(139, "GPIO_139"),
	PINCTRL_PIN(140, "GPIO_140"),
	PINCTRL_PIN(141, "GPIO_141"),
	PINCTRL_PIN(142, "GPIO_142"),
	PINCTRL_PIN(143, "GPIO_143"),
	PINCTRL_PIN(144, "GPIO_144"),
	PINCTRL_PIN(145, "GPIO_145"),
	PINCTRL_PIN(146, "GPIO_146"),
	PINCTRL_PIN(147, "GPIO_147"),
	PINCTRL_PIN(148, "GPIO_148"),
	PINCTRL_PIN(149, "GPIO_149"),
	PINCTRL_PIN(150, "GPIO_150"),
	PINCTRL_PIN(151, "GPIO_151"),
	PINCTRL_PIN(152, "GPIO_152"),
	PINCTRL_PIN(153, "GPIO_153"),
	PINCTRL_PIN(154, "GPIO_154"),
	PINCTRL_PIN(155, "GPIO_155"),
	PINCTRL_PIN(156, "GPIO_156"),
	PINCTRL_PIN(157, "GPIO_157"),
	PINCTRL_PIN(158, "GPIO_158"),
	PINCTRL_PIN(159, "GPIO_159"),
	PINCTRL_PIN(160, "GPIO_160"),
	PINCTRL_PIN(161, "GPIO_161"),
	PINCTRL_PIN(162, "GPIO_162"),
	PINCTRL_PIN(163, "GPIO_163"),
	PINCTRL_PIN(164, "GPIO_164"),
	PINCTRL_PIN(165, "GPIO_165"),
	PINCTRL_PIN(166, "GPIO_166"),
	PINCTRL_PIN(167, "GPIO_167"),
	PINCTRL_PIN(168, "GPIO_168"),
	PINCTRL_PIN(169, "GPIO_169"),
	PINCTRL_PIN(170, "GPIO_170"),
	PINCTRL_PIN(171, "GPIO_171"),
	PINCTRL_PIN(172, "GPIO_172"),
	PINCTRL_PIN(173, "GPIO_173"),
	PINCTRL_PIN(174, "GPIO_174"),
	PINCTRL_PIN(175, "GPIO_175"),
	PINCTRL_PIN(176, "GPIO_176"),
	PINCTRL_PIN(177, "GPIO_177"),
	PINCTRL_PIN(178, "GPIO_178"),
	PINCTRL_PIN(179, "GPIO_179"),
	PINCTRL_PIN(180, "GPIO_180"),
	PINCTRL_PIN(181, "GPIO_181"),
	PINCTRL_PIN(182, "GPIO_182"),
	PINCTRL_PIN(183, "GPIO_183"),
};

#define AMD_PINS(...) (const unsigned int []){__VA_ARGS__}

enum amd_functions {
	IMX_F0_GPIO0,
	IMX_F1_GPIO0,
	IMX_F2_GPIO0,
	IMX_F3_GPIO0,
	IMX_F0_GPIO1,
	IMX_F1_GPIO1,
	IMX_F2_GPIO1,
	IMX_F3_GPIO1,
	IMX_F0_GPIO2,
	IMX_F1_GPIO2,
	IMX_F2_GPIO2,
	IMX_F3_GPIO2,
	IMX_F0_GPIO3,
	IMX_F1_GPIO3,
	IMX_F2_GPIO3,
	IMX_F3_GPIO3,
	IMX_F0_GPIO4,
	IMX_F1_GPIO4,
	IMX_F2_GPIO4,
	IMX_F3_GPIO4,
	IMX_F0_GPIO5,
	IMX_F1_GPIO5,
	IMX_F2_GPIO5,
	IMX_F3_GPIO5,
	IMX_F0_GPIO6,
	IMX_F1_GPIO6,
	IMX_F2_GPIO6,
	IMX_F3_GPIO6,
	IMX_F0_GPIO7,
	IMX_F1_GPIO7,
	IMX_F2_GPIO7,
	IMX_F3_GPIO7,
	IMX_F0_GPIO8,
	IMX_F1_GPIO8,
	IMX_F2_GPIO8,
	IMX_F3_GPIO8,
	IMX_F0_GPIO9,
	IMX_F1_GPIO9,
	IMX_F2_GPIO9,
	IMX_F3_GPIO9,
	IMX_F0_GPIO10,
	IMX_F1_GPIO10,
	IMX_F2_GPIO10,
	IMX_F3_GPIO10,
	IMX_F0_GPIO11,
	IMX_F1_GPIO11,
	IMX_F2_GPIO11,
	IMX_F3_GPIO11,
	IMX_F0_GPIO12,
	IMX_F1_GPIO12,
	IMX_F2_GPIO12,
	IMX_F3_GPIO12,
	IMX_F0_GPIO13,
	IMX_F1_GPIO13,
	IMX_F2_GPIO13,
	IMX_F3_GPIO13,
	IMX_F0_GPIO14,
	IMX_F1_GPIO14,
	IMX_F2_GPIO14,
	IMX_F3_GPIO14,
	IMX_F0_GPIO15,
	IMX_F1_GPIO15,
	IMX_F2_GPIO15,
	IMX_F3_GPIO15,
	IMX_F0_GPIO16,
	IMX_F1_GPIO16,
	IMX_F2_GPIO16,
	IMX_F3_GPIO16,
	IMX_F0_GPIO17,
	IMX_F1_GPIO17,
	IMX_F2_GPIO17,
	IMX_F3_GPIO17,
	IMX_F0_GPIO18,
	IMX_F1_GPIO18,
	IMX_F2_GPIO18,
	IMX_F3_GPIO18,
	IMX_F0_GPIO19,
	IMX_F1_GPIO19,
	IMX_F2_GPIO19,
	IMX_F3_GPIO19,
	IMX_F0_GPIO20,
	IMX_F1_GPIO20,
	IMX_F2_GPIO20,
	IMX_F3_GPIO20,
	IMX_F0_GPIO21,
	IMX_F1_GPIO21,
	IMX_F2_GPIO21,
	IMX_F3_GPIO21,
	IMX_F0_GPIO22,
	IMX_F1_GPIO22,
	IMX_F2_GPIO22,
	IMX_F3_GPIO22,
	IMX_F0_GPIO23,
	IMX_F1_GPIO23,
	IMX_F2_GPIO23,
	IMX_F3_GPIO23,
	IMX_F0_GPIO24,
	IMX_F1_GPIO24,
	IMX_F2_GPIO24,
	IMX_F3_GPIO24,
	IMX_F0_GPIO25,
	IMX_F1_GPIO25,
	IMX_F2_GPIO25,
	IMX_F3_GPIO25,
	IMX_F0_GPIO26,
	IMX_F1_GPIO26,
	IMX_F2_GPIO26,
	IMX_F3_GPIO26,
	IMX_F0_GPIO27,
	IMX_F1_GPIO27,
	IMX_F2_GPIO27,
	IMX_F3_GPIO27,
	IMX_F0_GPIO28,
	IMX_F1_GPIO28,
	IMX_F2_GPIO28,
	IMX_F3_GPIO28,
	IMX_F0_GPIO29,
	IMX_F1_GPIO29,
	IMX_F2_GPIO29,
	IMX_F3_GPIO29,
	IMX_F0_GPIO30,
	IMX_F1_GPIO30,
	IMX_F2_GPIO30,
	IMX_F3_GPIO30,
	IMX_F0_GPIO31,
	IMX_F1_GPIO31,
	IMX_F2_GPIO31,
	IMX_F3_GPIO31,
	IMX_F0_GPIO32,
	IMX_F1_GPIO32,
	IMX_F2_GPIO32,
	IMX_F3_GPIO32,
	IMX_F0_GPIO33,
	IMX_F1_GPIO33,
	IMX_F2_GPIO33,
	IMX_F3_GPIO33,
	IMX_F0_GPIO34,
	IMX_F1_GPIO34,
	IMX_F2_GPIO34,
	IMX_F3_GPIO34,
	IMX_F0_GPIO35,
	IMX_F1_GPIO35,
	IMX_F2_GPIO35,
	IMX_F3_GPIO35,
	IMX_F0_GPIO36,
	IMX_F1_GPIO36,
	IMX_F2_GPIO36,
	IMX_F3_GPIO36,
	IMX_F0_GPIO37,
	IMX_F1_GPIO37,
	IMX_F2_GPIO37,
	IMX_F3_GPIO37,
	IMX_F0_GPIO38,
	IMX_F1_GPIO38,
	IMX_F2_GPIO38,
	IMX_F3_GPIO38,
	IMX_F0_GPIO39,
	IMX_F1_GPIO39,
	IMX_F2_GPIO39,
	IMX_F3_GPIO39,
	IMX_F0_GPIO40,
	IMX_F1_GPIO40,
	IMX_F2_GPIO40,
	IMX_F3_GPIO40,
	IMX_F0_GPIO41,
	IMX_F1_GPIO41,
	IMX_F2_GPIO41,
	IMX_F3_GPIO41,
	IMX_F0_GPIO42,
	IMX_F1_GPIO42,
	IMX_F2_GPIO42,
	IMX_F3_GPIO42,
	IMX_F0_GPIO43,
	IMX_F1_GPIO43,
	IMX_F2_GPIO43,
	IMX_F3_GPIO43,
	IMX_F0_GPIO44,
	IMX_F1_GPIO44,
	IMX_F2_GPIO44,
	IMX_F3_GPIO44,
	IMX_F0_GPIO45,
	IMX_F1_GPIO45,
	IMX_F2_GPIO45,
	IMX_F3_GPIO45,
	IMX_F0_GPIO46,
	IMX_F1_GPIO46,
	IMX_F2_GPIO46,
	IMX_F3_GPIO46,
	IMX_F0_GPIO47,
	IMX_F1_GPIO47,
	IMX_F2_GPIO47,
	IMX_F3_GPIO47,
	IMX_F0_GPIO48,
	IMX_F1_GPIO48,
	IMX_F2_GPIO48,
	IMX_F3_GPIO48,
	IMX_F0_GPIO49,
	IMX_F1_GPIO49,
	IMX_F2_GPIO49,
	IMX_F3_GPIO49,
	IMX_F0_GPIO50,
	IMX_F1_GPIO50,
	IMX_F2_GPIO50,
	IMX_F3_GPIO50,
	IMX_F0_GPIO51,
	IMX_F1_GPIO51,
	IMX_F2_GPIO51,
	IMX_F3_GPIO51,
	IMX_F0_GPIO52,
	IMX_F1_GPIO52,
	IMX_F2_GPIO52,
	IMX_F3_GPIO52,
	IMX_F0_GPIO53,
	IMX_F1_GPIO53,
	IMX_F2_GPIO53,
	IMX_F3_GPIO53,
	IMX_F0_GPIO54,
	IMX_F1_GPIO54,
	IMX_F2_GPIO54,
	IMX_F3_GPIO54,
	IMX_F0_GPIO55,
	IMX_F1_GPIO55,
	IMX_F2_GPIO55,
	IMX_F3_GPIO55,
	IMX_F0_GPIO56,
	IMX_F1_GPIO56,
	IMX_F2_GPIO56,
	IMX_F3_GPIO56,
	IMX_F0_GPIO57,
	IMX_F1_GPIO57,
	IMX_F2_GPIO57,
	IMX_F3_GPIO57,
	IMX_F0_GPIO58,
	IMX_F1_GPIO58,
	IMX_F2_GPIO58,
	IMX_F3_GPIO58,
	IMX_F0_GPIO59,
	IMX_F1_GPIO59,
	IMX_F2_GPIO59,
	IMX_F3_GPIO59,
	IMX_F0_GPIO60,
	IMX_F1_GPIO60,
	IMX_F2_GPIO60,
	IMX_F3_GPIO60,
	IMX_F0_GPIO61,
	IMX_F1_GPIO61,
	IMX_F2_GPIO61,
	IMX_F3_GPIO61,
	IMX_F0_GPIO62,
	IMX_F1_GPIO62,
	IMX_F2_GPIO62,
	IMX_F3_GPIO62,
	IMX_F0_GPIO64,
	IMX_F1_GPIO64,
	IMX_F2_GPIO64,
	IMX_F3_GPIO64,
	IMX_F0_GPIO65,
	IMX_F1_GPIO65,
	IMX_F2_GPIO65,
	IMX_F3_GPIO65,
	IMX_F0_GPIO66,
	IMX_F1_GPIO66,
	IMX_F2_GPIO66,
	IMX_F3_GPIO66,
	IMX_F0_GPIO67,
	IMX_F1_GPIO67,
	IMX_F2_GPIO67,
	IMX_F3_GPIO67,
	IMX_F0_GPIO68,
	IMX_F1_GPIO68,
	IMX_F2_GPIO68,
	IMX_F3_GPIO68,
	IMX_F0_GPIO69,
	IMX_F1_GPIO69,
	IMX_F2_GPIO69,
	IMX_F3_GPIO69,
	IMX_F0_GPIO70,
	IMX_F1_GPIO70,
	IMX_F2_GPIO70,
	IMX_F3_GPIO70,
	IMX_F0_GPIO71,
	IMX_F1_GPIO71,
	IMX_F2_GPIO71,
	IMX_F3_GPIO71,
	IMX_F0_GPIO72,
	IMX_F1_GPIO72,
	IMX_F2_GPIO72,
	IMX_F3_GPIO72,
	IMX_F0_GPIO73,
	IMX_F1_GPIO73,
	IMX_F2_GPIO73,
	IMX_F3_GPIO73,
	IMX_F0_GPIO74,
	IMX_F1_GPIO74,
	IMX_F2_GPIO74,
	IMX_F3_GPIO74,
	IMX_F0_GPIO75,
	IMX_F1_GPIO75,
	IMX_F2_GPIO75,
	IMX_F3_GPIO75,
	IMX_F0_GPIO76,
	IMX_F1_GPIO76,
	IMX_F2_GPIO76,
	IMX_F3_GPIO76,
	IMX_F0_GPIO77,
	IMX_F1_GPIO77,
	IMX_F2_GPIO77,
	IMX_F3_GPIO77,
	IMX_F0_GPIO78,
	IMX_F1_GPIO78,
	IMX_F2_GPIO78,
	IMX_F3_GPIO78,
	IMX_F0_GPIO79,
	IMX_F1_GPIO79,
	IMX_F2_GPIO79,
	IMX_F3_GPIO79,
	IMX_F0_GPIO80,
	IMX_F1_GPIO80,
	IMX_F2_GPIO80,
	IMX_F3_GPIO80,
	IMX_F0_GPIO81,
	IMX_F1_GPIO81,
	IMX_F2_GPIO81,
	IMX_F3_GPIO81,
	IMX_F0_GPIO82,
	IMX_F1_GPIO82,
	IMX_F2_GPIO82,
	IMX_F3_GPIO82,
	IMX_F0_GPIO83,
	IMX_F1_GPIO83,
	IMX_F2_GPIO83,
	IMX_F3_GPIO83,
	IMX_F0_GPIO84,
	IMX_F1_GPIO84,
	IMX_F2_GPIO84,
	IMX_F3_GPIO84,
	IMX_F0_GPIO85,
	IMX_F1_GPIO85,
	IMX_F2_GPIO85,
	IMX_F3_GPIO85,
	IMX_F0_GPIO86,
	IMX_F1_GPIO86,
	IMX_F2_GPIO86,
	IMX_F3_GPIO86,
	IMX_F0_GPIO87,
	IMX_F1_GPIO87,
	IMX_F2_GPIO87,
	IMX_F3_GPIO87,
	IMX_F0_GPIO88,
	IMX_F1_GPIO88,
	IMX_F2_GPIO88,
	IMX_F3_GPIO88,
	IMX_F0_GPIO89,
	IMX_F1_GPIO89,
	IMX_F2_GPIO89,
	IMX_F3_GPIO89,
	IMX_F0_GPIO90,
	IMX_F1_GPIO90,
	IMX_F2_GPIO90,
	IMX_F3_GPIO90,
	IMX_F0_GPIO91,
	IMX_F1_GPIO91,
	IMX_F2_GPIO91,
	IMX_F3_GPIO91,
	IMX_F0_GPIO92,
	IMX_F1_GPIO92,
	IMX_F2_GPIO92,
	IMX_F3_GPIO92,
	IMX_F0_GPIO93,
	IMX_F1_GPIO93,
	IMX_F2_GPIO93,
	IMX_F3_GPIO93,
	IMX_F0_GPIO94,
	IMX_F1_GPIO94,
	IMX_F2_GPIO94,
	IMX_F3_GPIO94,
	IMX_F0_GPIO95,
	IMX_F1_GPIO95,
	IMX_F2_GPIO95,
	IMX_F3_GPIO95,
	IMX_F0_GPIO96,
	IMX_F1_GPIO96,
	IMX_F2_GPIO96,
	IMX_F3_GPIO96,
	IMX_F0_GPIO97,
	IMX_F1_GPIO97,
	IMX_F2_GPIO97,
	IMX_F3_GPIO97,
	IMX_F0_GPIO98,
	IMX_F1_GPIO98,
	IMX_F2_GPIO98,
	IMX_F3_GPIO98,
	IMX_F0_GPIO99,
	IMX_F1_GPIO99,
	IMX_F2_GPIO99,
	IMX_F3_GPIO99,
	IMX_F0_GPIO100,
	IMX_F1_GPIO100,
	IMX_F2_GPIO100,
	IMX_F3_GPIO100,
	IMX_F0_GPIO101,
	IMX_F1_GPIO101,
	IMX_F2_GPIO101,
	IMX_F3_GPIO101,
	IMX_F0_GPIO102,
	IMX_F1_GPIO102,
	IMX_F2_GPIO102,
	IMX_F3_GPIO102,
	IMX_F0_GPIO103,
	IMX_F1_GPIO103,
	IMX_F2_GPIO103,
	IMX_F3_GPIO103,
	IMX_F0_GPIO104,
	IMX_F1_GPIO104,
	IMX_F2_GPIO104,
	IMX_F3_GPIO104,
	IMX_F0_GPIO105,
	IMX_F1_GPIO105,
	IMX_F2_GPIO105,
	IMX_F3_GPIO105,
	IMX_F0_GPIO106,
	IMX_F1_GPIO106,
	IMX_F2_GPIO106,
	IMX_F3_GPIO106,
	IMX_F0_GPIO107,
	IMX_F1_GPIO107,
	IMX_F2_GPIO107,
	IMX_F3_GPIO107,
	IMX_F0_GPIO108,
	IMX_F1_GPIO108,
	IMX_F2_GPIO108,
	IMX_F3_GPIO108,
	IMX_F0_GPIO109,
	IMX_F1_GPIO109,
	IMX_F2_GPIO109,
	IMX_F3_GPIO109,
	IMX_F0_GPIO110,
	IMX_F1_GPIO110,
	IMX_F2_GPIO110,
	IMX_F3_GPIO110,
	IMX_F0_GPIO111,
	IMX_F1_GPIO111,
	IMX_F2_GPIO111,
	IMX_F3_GPIO111,
	IMX_F0_GPIO112,
	IMX_F1_GPIO112,
	IMX_F2_GPIO112,
	IMX_F3_GPIO112,
	IMX_F0_GPIO113,
	IMX_F1_GPIO113,
	IMX_F2_GPIO113,
	IMX_F3_GPIO113,
	IMX_F0_GPIO114,
	IMX_F1_GPIO114,
	IMX_F2_GPIO114,
	IMX_F3_GPIO114,
	IMX_F0_GPIO115,
	IMX_F1_GPIO115,
	IMX_F2_GPIO115,
	IMX_F3_GPIO115,
	IMX_F0_GPIO116,
	IMX_F1_GPIO116,
	IMX_F2_GPIO116,
	IMX_F3_GPIO116,
	IMX_F0_GPIO117,
	IMX_F1_GPIO117,
	IMX_F2_GPIO117,
	IMX_F3_GPIO117,
	IMX_F0_GPIO118,
	IMX_F1_GPIO118,
	IMX_F2_GPIO118,
	IMX_F3_GPIO118,
	IMX_F0_GPIO119,
	IMX_F1_GPIO119,
	IMX_F2_GPIO119,
	IMX_F3_GPIO119,
	IMX_F0_GPIO120,
	IMX_F1_GPIO120,
	IMX_F2_GPIO120,
	IMX_F3_GPIO120,
	IMX_F0_GPIO121,
	IMX_F1_GPIO121,
	IMX_F2_GPIO121,
	IMX_F3_GPIO121,
	IMX_F0_GPIO122,
	IMX_F1_GPIO122,
	IMX_F2_GPIO122,
	IMX_F3_GPIO122,
	IMX_F0_GPIO123,
	IMX_F1_GPIO123,
	IMX_F2_GPIO123,
	IMX_F3_GPIO123,
	IMX_F0_GPIO124,
	IMX_F1_GPIO124,
	IMX_F2_GPIO124,
	IMX_F3_GPIO124,
	IMX_F0_GPIO125,
	IMX_F1_GPIO125,
	IMX_F2_GPIO125,
	IMX_F3_GPIO125,
	IMX_F0_GPIO126,
	IMX_F1_GPIO126,
	IMX_F2_GPIO126,
	IMX_F3_GPIO126,
	IMX_F0_GPIO127,
	IMX_F1_GPIO127,
	IMX_F2_GPIO127,
	IMX_F3_GPIO127,
	IMX_F0_GPIO128,
	IMX_F1_GPIO128,
	IMX_F2_GPIO128,
	IMX_F3_GPIO128,
	IMX_F0_GPIO129,
	IMX_F1_GPIO129,
	IMX_F2_GPIO129,
	IMX_F3_GPIO129,
	IMX_F0_GPIO130,
	IMX_F1_GPIO130,
	IMX_F2_GPIO130,
	IMX_F3_GPIO130,
	IMX_F0_GPIO131,
	IMX_F1_GPIO131,
	IMX_F2_GPIO131,
	IMX_F3_GPIO131,
	IMX_F0_GPIO132,
	IMX_F1_GPIO132,
	IMX_F2_GPIO132,
	IMX_F3_GPIO132,
	IMX_F0_GPIO133,
	IMX_F1_GPIO133,
	IMX_F2_GPIO133,
	IMX_F3_GPIO133,
	IMX_F0_GPIO134,
	IMX_F1_GPIO134,
	IMX_F2_GPIO134,
	IMX_F3_GPIO134,
	IMX_F0_GPIO135,
	IMX_F1_GPIO135,
	IMX_F2_GPIO135,
	IMX_F3_GPIO135,
	IMX_F0_GPIO136,
	IMX_F1_GPIO136,
	IMX_F2_GPIO136,
	IMX_F3_GPIO136,
	IMX_F0_GPIO137,
	IMX_F1_GPIO137,
	IMX_F2_GPIO137,
	IMX_F3_GPIO137,
	IMX_F0_GPIO138,
	IMX_F1_GPIO138,
	IMX_F2_GPIO138,
	IMX_F3_GPIO138,
	IMX_F0_GPIO139,
	IMX_F1_GPIO139,
	IMX_F2_GPIO139,
	IMX_F3_GPIO139,
	IMX_F0_GPIO140,
	IMX_F1_GPIO140,
	IMX_F2_GPIO140,
	IMX_F3_GPIO140,
	IMX_F0_GPIO141,
	IMX_F1_GPIO141,
	IMX_F2_GPIO141,
	IMX_F3_GPIO141,
	IMX_F0_GPIO142,
	IMX_F1_GPIO142,
	IMX_F2_GPIO142,
	IMX_F3_GPIO142,
	IMX_F0_GPIO143,
	IMX_F1_GPIO143,
	IMX_F2_GPIO143,
	IMX_F3_GPIO143,
	IMX_F0_GPIO144,
	IMX_F1_GPIO144,
	IMX_F2_GPIO144,
	IMX_F3_GPIO144,
};

#define AMD_PINCTRL_FUNC_GRP(_number, _func)						\
	[IMX_F##_func##_GPIO##_number] =						\
		PINCTRL_PINGROUP("IMX_F"#_func "_GPIO"#_number,	AMD_PINS(_number), 1)

static const struct pingroup kerncz_groups[] = {
	AMD_PINCTRL_FUNC_GRP(0, 0),
	AMD_PINCTRL_FUNC_GRP(0, 1),
	AMD_PINCTRL_FUNC_GRP(0, 2),
	AMD_PINCTRL_FUNC_GRP(0, 3),
	AMD_PINCTRL_FUNC_GRP(1, 0),
	AMD_PINCTRL_FUNC_GRP(1, 1),
	AMD_PINCTRL_FUNC_GRP(1, 2),
	AMD_PINCTRL_FUNC_GRP(1, 3),
	AMD_PINCTRL_FUNC_GRP(2, 0),
	AMD_PINCTRL_FUNC_GRP(2, 1),
	AMD_PINCTRL_FUNC_GRP(2, 2),
	AMD_PINCTRL_FUNC_GRP(2, 3),
	AMD_PINCTRL_FUNC_GRP(3, 0),
	AMD_PINCTRL_FUNC_GRP(3, 1),
	AMD_PINCTRL_FUNC_GRP(3, 2),
	AMD_PINCTRL_FUNC_GRP(3, 3),
	AMD_PINCTRL_FUNC_GRP(4, 0),
	AMD_PINCTRL_FUNC_GRP(4, 1),
	AMD_PINCTRL_FUNC_GRP(4, 2),
	AMD_PINCTRL_FUNC_GRP(4, 3),
	AMD_PINCTRL_FUNC_GRP(5, 0),
	AMD_PINCTRL_FUNC_GRP(5, 1),
	AMD_PINCTRL_FUNC_GRP(5, 2),
	AMD_PINCTRL_FUNC_GRP(5, 3),
	AMD_PINCTRL_FUNC_GRP(6, 0),
	AMD_PINCTRL_FUNC_GRP(6, 1),
	AMD_PINCTRL_FUNC_GRP(6, 2),
	AMD_PINCTRL_FUNC_GRP(6, 3),
	AMD_PINCTRL_FUNC_GRP(7, 0),
	AMD_PINCTRL_FUNC_GRP(7, 1),
	AMD_PINCTRL_FUNC_GRP(7, 2),
	AMD_PINCTRL_FUNC_GRP(7, 3),
	AMD_PINCTRL_FUNC_GRP(8, 0),
	AMD_PINCTRL_FUNC_GRP(8, 1),
	AMD_PINCTRL_FUNC_GRP(8, 2),
	AMD_PINCTRL_FUNC_GRP(8, 3),
	AMD_PINCTRL_FUNC_GRP(9, 0),
	AMD_PINCTRL_FUNC_GRP(9, 1),
	AMD_PINCTRL_FUNC_GRP(9, 2),
	AMD_PINCTRL_FUNC_GRP(9, 3),
	AMD_PINCTRL_FUNC_GRP(10, 0),
	AMD_PINCTRL_FUNC_GRP(10, 1),
	AMD_PINCTRL_FUNC_GRP(10, 2),
	AMD_PINCTRL_FUNC_GRP(10, 3),
	AMD_PINCTRL_FUNC_GRP(11, 0),
	AMD_PINCTRL_FUNC_GRP(11, 1),
	AMD_PINCTRL_FUNC_GRP(11, 2),
	AMD_PINCTRL_FUNC_GRP(11, 3),
	AMD_PINCTRL_FUNC_GRP(12, 0),
	AMD_PINCTRL_FUNC_GRP(12, 1),
	AMD_PINCTRL_FUNC_GRP(12, 2),
	AMD_PINCTRL_FUNC_GRP(12, 3),
	AMD_PINCTRL_FUNC_GRP(13, 0),
	AMD_PINCTRL_FUNC_GRP(13, 1),
	AMD_PINCTRL_FUNC_GRP(13, 2),
	AMD_PINCTRL_FUNC_GRP(13, 3),
	AMD_PINCTRL_FUNC_GRP(14, 0),
	AMD_PINCTRL_FUNC_GRP(14, 1),
	AMD_PINCTRL_FUNC_GRP(14, 2),
	AMD_PINCTRL_FUNC_GRP(14, 3),
	AMD_PINCTRL_FUNC_GRP(15, 0),
	AMD_PINCTRL_FUNC_GRP(15, 1),
	AMD_PINCTRL_FUNC_GRP(15, 2),
	AMD_PINCTRL_FUNC_GRP(15, 3),
	AMD_PINCTRL_FUNC_GRP(16, 0),
	AMD_PINCTRL_FUNC_GRP(16, 1),
	AMD_PINCTRL_FUNC_GRP(16, 2),
	AMD_PINCTRL_FUNC_GRP(16, 3),
	AMD_PINCTRL_FUNC_GRP(17, 0),
	AMD_PINCTRL_FUNC_GRP(17, 1),
	AMD_PINCTRL_FUNC_GRP(17, 2),
	AMD_PINCTRL_FUNC_GRP(17, 3),
	AMD_PINCTRL_FUNC_GRP(18, 0),
	AMD_PINCTRL_FUNC_GRP(18, 1),
	AMD_PINCTRL_FUNC_GRP(18, 2),
	AMD_PINCTRL_FUNC_GRP(18, 3),
	AMD_PINCTRL_FUNC_GRP(19, 0),
	AMD_PINCTRL_FUNC_GRP(19, 1),
	AMD_PINCTRL_FUNC_GRP(19, 2),
	AMD_PINCTRL_FUNC_GRP(19, 3),
	AMD_PINCTRL_FUNC_GRP(20, 0),
	AMD_PINCTRL_FUNC_GRP(20, 1),
	AMD_PINCTRL_FUNC_GRP(20, 2),
	AMD_PINCTRL_FUNC_GRP(20, 3),
	AMD_PINCTRL_FUNC_GRP(21, 0),
	AMD_PINCTRL_FUNC_GRP(21, 1),
	AMD_PINCTRL_FUNC_GRP(21, 2),
	AMD_PINCTRL_FUNC_GRP(21, 3),
	AMD_PINCTRL_FUNC_GRP(22, 0),
	AMD_PINCTRL_FUNC_GRP(22, 1),
	AMD_PINCTRL_FUNC_GRP(22, 2),
	AMD_PINCTRL_FUNC_GRP(22, 3),
	AMD_PINCTRL_FUNC_GRP(23, 0),
	AMD_PINCTRL_FUNC_GRP(23, 1),
	AMD_PINCTRL_FUNC_GRP(23, 2),
	AMD_PINCTRL_FUNC_GRP(23, 3),
	AMD_PINCTRL_FUNC_GRP(24, 0),
	AMD_PINCTRL_FUNC_GRP(24, 1),
	AMD_PINCTRL_FUNC_GRP(24, 2),
	AMD_PINCTRL_FUNC_GRP(24, 3),
	AMD_PINCTRL_FUNC_GRP(25, 0),
	AMD_PINCTRL_FUNC_GRP(25, 1),
	AMD_PINCTRL_FUNC_GRP(25, 2),
	AMD_PINCTRL_FUNC_GRP(25, 3),
	AMD_PINCTRL_FUNC_GRP(26, 0),
	AMD_PINCTRL_FUNC_GRP(26, 1),
	AMD_PINCTRL_FUNC_GRP(26, 2),
	AMD_PINCTRL_FUNC_GRP(26, 3),
	AMD_PINCTRL_FUNC_GRP(27, 0),
	AMD_PINCTRL_FUNC_GRP(27, 1),
	AMD_PINCTRL_FUNC_GRP(27, 2),
	AMD_PINCTRL_FUNC_GRP(27, 3),
	AMD_PINCTRL_FUNC_GRP(28, 0),
	AMD_PINCTRL_FUNC_GRP(28, 1),
	AMD_PINCTRL_FUNC_GRP(28, 2),
	AMD_PINCTRL_FUNC_GRP(28, 3),
	AMD_PINCTRL_FUNC_GRP(29, 0),
	AMD_PINCTRL_FUNC_GRP(29, 1),
	AMD_PINCTRL_FUNC_GRP(29, 2),
	AMD_PINCTRL_FUNC_GRP(29, 3),
	AMD_PINCTRL_FUNC_GRP(30, 0),
	AMD_PINCTRL_FUNC_GRP(30, 1),
	AMD_PINCTRL_FUNC_GRP(30, 2),
	AMD_PINCTRL_FUNC_GRP(30, 3),
	AMD_PINCTRL_FUNC_GRP(31, 0),
	AMD_PINCTRL_FUNC_GRP(31, 1),
	AMD_PINCTRL_FUNC_GRP(31, 2),
	AMD_PINCTRL_FUNC_GRP(31, 3),
	AMD_PINCTRL_FUNC_GRP(32, 0),
	AMD_PINCTRL_FUNC_GRP(32, 1),
	AMD_PINCTRL_FUNC_GRP(32, 2),
	AMD_PINCTRL_FUNC_GRP(32, 3),
	AMD_PINCTRL_FUNC_GRP(33, 0),
	AMD_PINCTRL_FUNC_GRP(33, 1),
	AMD_PINCTRL_FUNC_GRP(33, 2),
	AMD_PINCTRL_FUNC_GRP(33, 3),
	AMD_PINCTRL_FUNC_GRP(34, 0),
	AMD_PINCTRL_FUNC_GRP(34, 1),
	AMD_PINCTRL_FUNC_GRP(34, 2),
	AMD_PINCTRL_FUNC_GRP(34, 3),
	AMD_PINCTRL_FUNC_GRP(35, 0),
	AMD_PINCTRL_FUNC_GRP(35, 1),
	AMD_PINCTRL_FUNC_GRP(35, 2),
	AMD_PINCTRL_FUNC_GRP(35, 3),
	AMD_PINCTRL_FUNC_GRP(36, 0),
	AMD_PINCTRL_FUNC_GRP(36, 1),
	AMD_PINCTRL_FUNC_GRP(36, 2),
	AMD_PINCTRL_FUNC_GRP(36, 3),
	AMD_PINCTRL_FUNC_GRP(37, 0),
	AMD_PINCTRL_FUNC_GRP(37, 1),
	AMD_PINCTRL_FUNC_GRP(37, 2),
	AMD_PINCTRL_FUNC_GRP(37, 3),
	AMD_PINCTRL_FUNC_GRP(38, 0),
	AMD_PINCTRL_FUNC_GRP(38, 1),
	AMD_PINCTRL_FUNC_GRP(38, 2),
	AMD_PINCTRL_FUNC_GRP(38, 3),
	AMD_PINCTRL_FUNC_GRP(39, 0),
	AMD_PINCTRL_FUNC_GRP(39, 1),
	AMD_PINCTRL_FUNC_GRP(39, 2),
	AMD_PINCTRL_FUNC_GRP(39, 3),
	AMD_PINCTRL_FUNC_GRP(40, 0),
	AMD_PINCTRL_FUNC_GRP(40, 1),
	AMD_PINCTRL_FUNC_GRP(40, 2),
	AMD_PINCTRL_FUNC_GRP(40, 3),
	AMD_PINCTRL_FUNC_GRP(41, 0),
	AMD_PINCTRL_FUNC_GRP(41, 1),
	AMD_PINCTRL_FUNC_GRP(41, 2),
	AMD_PINCTRL_FUNC_GRP(41, 3),
	AMD_PINCTRL_FUNC_GRP(42, 0),
	AMD_PINCTRL_FUNC_GRP(42, 1),
	AMD_PINCTRL_FUNC_GRP(42, 2),
	AMD_PINCTRL_FUNC_GRP(42, 3),
	AMD_PINCTRL_FUNC_GRP(43, 0),
	AMD_PINCTRL_FUNC_GRP(43, 1),
	AMD_PINCTRL_FUNC_GRP(43, 2),
	AMD_PINCTRL_FUNC_GRP(43, 3),
	AMD_PINCTRL_FUNC_GRP(44, 0),
	AMD_PINCTRL_FUNC_GRP(44, 1),
	AMD_PINCTRL_FUNC_GRP(44, 2),
	AMD_PINCTRL_FUNC_GRP(44, 3),
	AMD_PINCTRL_FUNC_GRP(45, 0),
	AMD_PINCTRL_FUNC_GRP(45, 1),
	AMD_PINCTRL_FUNC_GRP(45, 2),
	AMD_PINCTRL_FUNC_GRP(45, 3),
	AMD_PINCTRL_FUNC_GRP(46, 0),
	AMD_PINCTRL_FUNC_GRP(46, 1),
	AMD_PINCTRL_FUNC_GRP(46, 2),
	AMD_PINCTRL_FUNC_GRP(46, 3),
	AMD_PINCTRL_FUNC_GRP(47, 0),
	AMD_PINCTRL_FUNC_GRP(47, 1),
	AMD_PINCTRL_FUNC_GRP(47, 2),
	AMD_PINCTRL_FUNC_GRP(47, 3),
	AMD_PINCTRL_FUNC_GRP(48, 0),
	AMD_PINCTRL_FUNC_GRP(48, 1),
	AMD_PINCTRL_FUNC_GRP(48, 2),
	AMD_PINCTRL_FUNC_GRP(48, 3),
	AMD_PINCTRL_FUNC_GRP(49, 0),
	AMD_PINCTRL_FUNC_GRP(49, 1),
	AMD_PINCTRL_FUNC_GRP(49, 2),
	AMD_PINCTRL_FUNC_GRP(49, 3),
	AMD_PINCTRL_FUNC_GRP(50, 0),
	AMD_PINCTRL_FUNC_GRP(50, 1),
	AMD_PINCTRL_FUNC_GRP(50, 2),
	AMD_PINCTRL_FUNC_GRP(50, 3),
	AMD_PINCTRL_FUNC_GRP(51, 0),
	AMD_PINCTRL_FUNC_GRP(51, 1),
	AMD_PINCTRL_FUNC_GRP(51, 2),
	AMD_PINCTRL_FUNC_GRP(51, 3),
	AMD_PINCTRL_FUNC_GRP(52, 0),
	AMD_PINCTRL_FUNC_GRP(52, 1),
	AMD_PINCTRL_FUNC_GRP(52, 2),
	AMD_PINCTRL_FUNC_GRP(52, 3),
	AMD_PINCTRL_FUNC_GRP(53, 0),
	AMD_PINCTRL_FUNC_GRP(53, 1),
	AMD_PINCTRL_FUNC_GRP(53, 2),
	AMD_PINCTRL_FUNC_GRP(53, 3),
	AMD_PINCTRL_FUNC_GRP(54, 0),
	AMD_PINCTRL_FUNC_GRP(54, 1),
	AMD_PINCTRL_FUNC_GRP(54, 2),
	AMD_PINCTRL_FUNC_GRP(54, 3),
	AMD_PINCTRL_FUNC_GRP(55, 0),
	AMD_PINCTRL_FUNC_GRP(55, 1),
	AMD_PINCTRL_FUNC_GRP(55, 2),
	AMD_PINCTRL_FUNC_GRP(55, 3),
	AMD_PINCTRL_FUNC_GRP(56, 0),
	AMD_PINCTRL_FUNC_GRP(56, 1),
	AMD_PINCTRL_FUNC_GRP(56, 2),
	AMD_PINCTRL_FUNC_GRP(56, 3),
	AMD_PINCTRL_FUNC_GRP(57, 0),
	AMD_PINCTRL_FUNC_GRP(57, 1),
	AMD_PINCTRL_FUNC_GRP(57, 2),
	AMD_PINCTRL_FUNC_GRP(57, 3),
	AMD_PINCTRL_FUNC_GRP(58, 0),
	AMD_PINCTRL_FUNC_GRP(58, 1),
	AMD_PINCTRL_FUNC_GRP(58, 2),
	AMD_PINCTRL_FUNC_GRP(58, 3),
	AMD_PINCTRL_FUNC_GRP(59, 0),
	AMD_PINCTRL_FUNC_GRP(59, 1),
	AMD_PINCTRL_FUNC_GRP(59, 2),
	AMD_PINCTRL_FUNC_GRP(59, 3),
	AMD_PINCTRL_FUNC_GRP(60, 0),
	AMD_PINCTRL_FUNC_GRP(60, 1),
	AMD_PINCTRL_FUNC_GRP(60, 2),
	AMD_PINCTRL_FUNC_GRP(60, 3),
	AMD_PINCTRL_FUNC_GRP(61, 0),
	AMD_PINCTRL_FUNC_GRP(61, 1),
	AMD_PINCTRL_FUNC_GRP(61, 2),
	AMD_PINCTRL_FUNC_GRP(61, 3),
	AMD_PINCTRL_FUNC_GRP(62, 0),
	AMD_PINCTRL_FUNC_GRP(62, 1),
	AMD_PINCTRL_FUNC_GRP(62, 2),
	AMD_PINCTRL_FUNC_GRP(62, 3),
	AMD_PINCTRL_FUNC_GRP(64, 0),
	AMD_PINCTRL_FUNC_GRP(64, 1),
	AMD_PINCTRL_FUNC_GRP(64, 2),
	AMD_PINCTRL_FUNC_GRP(64, 3),
	AMD_PINCTRL_FUNC_GRP(65, 0),
	AMD_PINCTRL_FUNC_GRP(65, 1),
	AMD_PINCTRL_FUNC_GRP(65, 2),
	AMD_PINCTRL_FUNC_GRP(65, 3),
	AMD_PINCTRL_FUNC_GRP(66, 0),
	AMD_PINCTRL_FUNC_GRP(66, 1),
	AMD_PINCTRL_FUNC_GRP(66, 2),
	AMD_PINCTRL_FUNC_GRP(66, 3),
	AMD_PINCTRL_FUNC_GRP(67, 0),
	AMD_PINCTRL_FUNC_GRP(67, 1),
	AMD_PINCTRL_FUNC_GRP(67, 2),
	AMD_PINCTRL_FUNC_GRP(67, 3),
	AMD_PINCTRL_FUNC_GRP(68, 0),
	AMD_PINCTRL_FUNC_GRP(68, 1),
	AMD_PINCTRL_FUNC_GRP(68, 2),
	AMD_PINCTRL_FUNC_GRP(68, 3),
	AMD_PINCTRL_FUNC_GRP(69, 0),
	AMD_PINCTRL_FUNC_GRP(69, 1),
	AMD_PINCTRL_FUNC_GRP(69, 2),
	AMD_PINCTRL_FUNC_GRP(69, 3),
	AMD_PINCTRL_FUNC_GRP(70, 0),
	AMD_PINCTRL_FUNC_GRP(70, 1),
	AMD_PINCTRL_FUNC_GRP(70, 2),
	AMD_PINCTRL_FUNC_GRP(70, 3),
	AMD_PINCTRL_FUNC_GRP(71, 0),
	AMD_PINCTRL_FUNC_GRP(71, 1),
	AMD_PINCTRL_FUNC_GRP(71, 2),
	AMD_PINCTRL_FUNC_GRP(71, 3),
	AMD_PINCTRL_FUNC_GRP(72, 0),
	AMD_PINCTRL_FUNC_GRP(72, 1),
	AMD_PINCTRL_FUNC_GRP(72, 2),
	AMD_PINCTRL_FUNC_GRP(72, 3),
	AMD_PINCTRL_FUNC_GRP(73, 0),
	AMD_PINCTRL_FUNC_GRP(73, 1),
	AMD_PINCTRL_FUNC_GRP(73, 2),
	AMD_PINCTRL_FUNC_GRP(73, 3),
	AMD_PINCTRL_FUNC_GRP(74, 0),
	AMD_PINCTRL_FUNC_GRP(74, 1),
	AMD_PINCTRL_FUNC_GRP(74, 2),
	AMD_PINCTRL_FUNC_GRP(74, 3),
	AMD_PINCTRL_FUNC_GRP(75, 0),
	AMD_PINCTRL_FUNC_GRP(75, 1),
	AMD_PINCTRL_FUNC_GRP(75, 2),
	AMD_PINCTRL_FUNC_GRP(75, 3),
	AMD_PINCTRL_FUNC_GRP(76, 0),
	AMD_PINCTRL_FUNC_GRP(76, 1),
	AMD_PINCTRL_FUNC_GRP(76, 2),
	AMD_PINCTRL_FUNC_GRP(76, 3),
	AMD_PINCTRL_FUNC_GRP(77, 0),
	AMD_PINCTRL_FUNC_GRP(77, 1),
	AMD_PINCTRL_FUNC_GRP(77, 2),
	AMD_PINCTRL_FUNC_GRP(77, 3),
	AMD_PINCTRL_FUNC_GRP(78, 0),
	AMD_PINCTRL_FUNC_GRP(78, 1),
	AMD_PINCTRL_FUNC_GRP(78, 2),
	AMD_PINCTRL_FUNC_GRP(78, 3),
	AMD_PINCTRL_FUNC_GRP(79, 0),
	AMD_PINCTRL_FUNC_GRP(79, 1),
	AMD_PINCTRL_FUNC_GRP(79, 2),
	AMD_PINCTRL_FUNC_GRP(79, 3),
	AMD_PINCTRL_FUNC_GRP(80, 0),
	AMD_PINCTRL_FUNC_GRP(80, 1),
	AMD_PINCTRL_FUNC_GRP(80, 2),
	AMD_PINCTRL_FUNC_GRP(80, 3),
	AMD_PINCTRL_FUNC_GRP(81, 0),
	AMD_PINCTRL_FUNC_GRP(81, 1),
	AMD_PINCTRL_FUNC_GRP(81, 2),
	AMD_PINCTRL_FUNC_GRP(81, 3),
	AMD_PINCTRL_FUNC_GRP(82, 0),
	AMD_PINCTRL_FUNC_GRP(82, 1),
	AMD_PINCTRL_FUNC_GRP(82, 2),
	AMD_PINCTRL_FUNC_GRP(82, 3),
	AMD_PINCTRL_FUNC_GRP(83, 0),
	AMD_PINCTRL_FUNC_GRP(83, 1),
	AMD_PINCTRL_FUNC_GRP(83, 2),
	AMD_PINCTRL_FUNC_GRP(83, 3),
	AMD_PINCTRL_FUNC_GRP(84, 0),
	AMD_PINCTRL_FUNC_GRP(84, 1),
	AMD_PINCTRL_FUNC_GRP(84, 2),
	AMD_PINCTRL_FUNC_GRP(84, 3),
	AMD_PINCTRL_FUNC_GRP(85, 0),
	AMD_PINCTRL_FUNC_GRP(85, 1),
	AMD_PINCTRL_FUNC_GRP(85, 2),
	AMD_PINCTRL_FUNC_GRP(85, 3),
	AMD_PINCTRL_FUNC_GRP(86, 0),
	AMD_PINCTRL_FUNC_GRP(86, 1),
	AMD_PINCTRL_FUNC_GRP(86, 2),
	AMD_PINCTRL_FUNC_GRP(86, 3),
	AMD_PINCTRL_FUNC_GRP(87, 0),
	AMD_PINCTRL_FUNC_GRP(87, 1),
	AMD_PINCTRL_FUNC_GRP(87, 2),
	AMD_PINCTRL_FUNC_GRP(87, 3),
	AMD_PINCTRL_FUNC_GRP(88, 0),
	AMD_PINCTRL_FUNC_GRP(88, 1),
	AMD_PINCTRL_FUNC_GRP(88, 2),
	AMD_PINCTRL_FUNC_GRP(88, 3),
	AMD_PINCTRL_FUNC_GRP(89, 0),
	AMD_PINCTRL_FUNC_GRP(89, 1),
	AMD_PINCTRL_FUNC_GRP(89, 2),
	AMD_PINCTRL_FUNC_GRP(89, 3),
	AMD_PINCTRL_FUNC_GRP(90, 0),
	AMD_PINCTRL_FUNC_GRP(90, 1),
	AMD_PINCTRL_FUNC_GRP(90, 2),
	AMD_PINCTRL_FUNC_GRP(90, 3),
	AMD_PINCTRL_FUNC_GRP(91, 0),
	AMD_PINCTRL_FUNC_GRP(91, 1),
	AMD_PINCTRL_FUNC_GRP(91, 2),
	AMD_PINCTRL_FUNC_GRP(91, 3),
	AMD_PINCTRL_FUNC_GRP(92, 0),
	AMD_PINCTRL_FUNC_GRP(92, 1),
	AMD_PINCTRL_FUNC_GRP(92, 2),
	AMD_PINCTRL_FUNC_GRP(92, 3),
	AMD_PINCTRL_FUNC_GRP(93, 0),
	AMD_PINCTRL_FUNC_GRP(93, 1),
	AMD_PINCTRL_FUNC_GRP(93, 2),
	AMD_PINCTRL_FUNC_GRP(93, 3),
	AMD_PINCTRL_FUNC_GRP(94, 0),
	AMD_PINCTRL_FUNC_GRP(94, 1),
	AMD_PINCTRL_FUNC_GRP(94, 2),
	AMD_PINCTRL_FUNC_GRP(94, 3),
	AMD_PINCTRL_FUNC_GRP(95, 0),
	AMD_PINCTRL_FUNC_GRP(95, 1),
	AMD_PINCTRL_FUNC_GRP(95, 2),
	AMD_PINCTRL_FUNC_GRP(95, 3),
	AMD_PINCTRL_FUNC_GRP(96, 0),
	AMD_PINCTRL_FUNC_GRP(96, 1),
	AMD_PINCTRL_FUNC_GRP(96, 2),
	AMD_PINCTRL_FUNC_GRP(96, 3),
	AMD_PINCTRL_FUNC_GRP(97, 0),
	AMD_PINCTRL_FUNC_GRP(97, 1),
	AMD_PINCTRL_FUNC_GRP(97, 2),
	AMD_PINCTRL_FUNC_GRP(97, 3),
	AMD_PINCTRL_FUNC_GRP(98, 0),
	AMD_PINCTRL_FUNC_GRP(98, 1),
	AMD_PINCTRL_FUNC_GRP(98, 2),
	AMD_PINCTRL_FUNC_GRP(98, 3),
	AMD_PINCTRL_FUNC_GRP(99, 0),
	AMD_PINCTRL_FUNC_GRP(99, 1),
	AMD_PINCTRL_FUNC_GRP(99, 2),
	AMD_PINCTRL_FUNC_GRP(99, 3),
	AMD_PINCTRL_FUNC_GRP(100, 0),
	AMD_PINCTRL_FUNC_GRP(100, 1),
	AMD_PINCTRL_FUNC_GRP(100, 2),
	AMD_PINCTRL_FUNC_GRP(100, 3),
	AMD_PINCTRL_FUNC_GRP(101, 0),
	AMD_PINCTRL_FUNC_GRP(101, 1),
	AMD_PINCTRL_FUNC_GRP(101, 2),
	AMD_PINCTRL_FUNC_GRP(101, 3),
	AMD_PINCTRL_FUNC_GRP(102, 0),
	AMD_PINCTRL_FUNC_GRP(102, 1),
	AMD_PINCTRL_FUNC_GRP(102, 2),
	AMD_PINCTRL_FUNC_GRP(102, 3),
	AMD_PINCTRL_FUNC_GRP(103, 0),
	AMD_PINCTRL_FUNC_GRP(103, 1),
	AMD_PINCTRL_FUNC_GRP(103, 2),
	AMD_PINCTRL_FUNC_GRP(103, 3),
	AMD_PINCTRL_FUNC_GRP(104, 0),
	AMD_PINCTRL_FUNC_GRP(104, 1),
	AMD_PINCTRL_FUNC_GRP(104, 2),
	AMD_PINCTRL_FUNC_GRP(104, 3),
	AMD_PINCTRL_FUNC_GRP(105, 0),
	AMD_PINCTRL_FUNC_GRP(105, 1),
	AMD_PINCTRL_FUNC_GRP(105, 2),
	AMD_PINCTRL_FUNC_GRP(105, 3),
	AMD_PINCTRL_FUNC_GRP(106, 0),
	AMD_PINCTRL_FUNC_GRP(106, 1),
	AMD_PINCTRL_FUNC_GRP(106, 2),
	AMD_PINCTRL_FUNC_GRP(106, 3),
	AMD_PINCTRL_FUNC_GRP(107, 0),
	AMD_PINCTRL_FUNC_GRP(107, 1),
	AMD_PINCTRL_FUNC_GRP(107, 2),
	AMD_PINCTRL_FUNC_GRP(107, 3),
	AMD_PINCTRL_FUNC_GRP(108, 0),
	AMD_PINCTRL_FUNC_GRP(108, 1),
	AMD_PINCTRL_FUNC_GRP(108, 2),
	AMD_PINCTRL_FUNC_GRP(108, 3),
	AMD_PINCTRL_FUNC_GRP(109, 0),
	AMD_PINCTRL_FUNC_GRP(109, 1),
	AMD_PINCTRL_FUNC_GRP(109, 2),
	AMD_PINCTRL_FUNC_GRP(109, 3),
	AMD_PINCTRL_FUNC_GRP(110, 0),
	AMD_PINCTRL_FUNC_GRP(110, 1),
	AMD_PINCTRL_FUNC_GRP(110, 2),
	AMD_PINCTRL_FUNC_GRP(110, 3),
	AMD_PINCTRL_FUNC_GRP(111, 0),
	AMD_PINCTRL_FUNC_GRP(111, 1),
	AMD_PINCTRL_FUNC_GRP(111, 2),
	AMD_PINCTRL_FUNC_GRP(111, 3),
	AMD_PINCTRL_FUNC_GRP(112, 0),
	AMD_PINCTRL_FUNC_GRP(112, 1),
	AMD_PINCTRL_FUNC_GRP(112, 2),
	AMD_PINCTRL_FUNC_GRP(112, 3),
	AMD_PINCTRL_FUNC_GRP(113, 0),
	AMD_PINCTRL_FUNC_GRP(113, 1),
	AMD_PINCTRL_FUNC_GRP(113, 2),
	AMD_PINCTRL_FUNC_GRP(113, 3),
	AMD_PINCTRL_FUNC_GRP(114, 0),
	AMD_PINCTRL_FUNC_GRP(114, 1),
	AMD_PINCTRL_FUNC_GRP(114, 2),
	AMD_PINCTRL_FUNC_GRP(114, 3),
	AMD_PINCTRL_FUNC_GRP(115, 0),
	AMD_PINCTRL_FUNC_GRP(115, 1),
	AMD_PINCTRL_FUNC_GRP(115, 2),
	AMD_PINCTRL_FUNC_GRP(115, 3),
	AMD_PINCTRL_FUNC_GRP(116, 0),
	AMD_PINCTRL_FUNC_GRP(116, 1),
	AMD_PINCTRL_FUNC_GRP(116, 2),
	AMD_PINCTRL_FUNC_GRP(116, 3),
	AMD_PINCTRL_FUNC_GRP(117, 0),
	AMD_PINCTRL_FUNC_GRP(117, 1),
	AMD_PINCTRL_FUNC_GRP(117, 2),
	AMD_PINCTRL_FUNC_GRP(117, 3),
	AMD_PINCTRL_FUNC_GRP(118, 0),
	AMD_PINCTRL_FUNC_GRP(118, 1),
	AMD_PINCTRL_FUNC_GRP(118, 2),
	AMD_PINCTRL_FUNC_GRP(118, 3),
	AMD_PINCTRL_FUNC_GRP(119, 0),
	AMD_PINCTRL_FUNC_GRP(119, 1),
	AMD_PINCTRL_FUNC_GRP(119, 2),
	AMD_PINCTRL_FUNC_GRP(119, 3),
	AMD_PINCTRL_FUNC_GRP(120, 0),
	AMD_PINCTRL_FUNC_GRP(120, 1),
	AMD_PINCTRL_FUNC_GRP(120, 2),
	AMD_PINCTRL_FUNC_GRP(120, 3),
	AMD_PINCTRL_FUNC_GRP(121, 0),
	AMD_PINCTRL_FUNC_GRP(121, 1),
	AMD_PINCTRL_FUNC_GRP(121, 2),
	AMD_PINCTRL_FUNC_GRP(121, 3),
	AMD_PINCTRL_FUNC_GRP(122, 0),
	AMD_PINCTRL_FUNC_GRP(122, 1),
	AMD_PINCTRL_FUNC_GRP(122, 2),
	AMD_PINCTRL_FUNC_GRP(122, 3),
	AMD_PINCTRL_FUNC_GRP(123, 0),
	AMD_PINCTRL_FUNC_GRP(123, 1),
	AMD_PINCTRL_FUNC_GRP(123, 2),
	AMD_PINCTRL_FUNC_GRP(123, 3),
	AMD_PINCTRL_FUNC_GRP(124, 0),
	AMD_PINCTRL_FUNC_GRP(124, 1),
	AMD_PINCTRL_FUNC_GRP(124, 2),
	AMD_PINCTRL_FUNC_GRP(124, 3),
	AMD_PINCTRL_FUNC_GRP(125, 0),
	AMD_PINCTRL_FUNC_GRP(125, 1),
	AMD_PINCTRL_FUNC_GRP(125, 2),
	AMD_PINCTRL_FUNC_GRP(125, 3),
	AMD_PINCTRL_FUNC_GRP(126, 0),
	AMD_PINCTRL_FUNC_GRP(126, 1),
	AMD_PINCTRL_FUNC_GRP(126, 2),
	AMD_PINCTRL_FUNC_GRP(126, 3),
	AMD_PINCTRL_FUNC_GRP(127, 0),
	AMD_PINCTRL_FUNC_GRP(127, 1),
	AMD_PINCTRL_FUNC_GRP(127, 2),
	AMD_PINCTRL_FUNC_GRP(127, 3),
	AMD_PINCTRL_FUNC_GRP(128, 0),
	AMD_PINCTRL_FUNC_GRP(128, 1),
	AMD_PINCTRL_FUNC_GRP(128, 2),
	AMD_PINCTRL_FUNC_GRP(128, 3),
	AMD_PINCTRL_FUNC_GRP(129, 0),
	AMD_PINCTRL_FUNC_GRP(129, 1),
	AMD_PINCTRL_FUNC_GRP(129, 2),
	AMD_PINCTRL_FUNC_GRP(129, 3),
	AMD_PINCTRL_FUNC_GRP(130, 0),
	AMD_PINCTRL_FUNC_GRP(130, 1),
	AMD_PINCTRL_FUNC_GRP(130, 2),
	AMD_PINCTRL_FUNC_GRP(130, 3),
	AMD_PINCTRL_FUNC_GRP(131, 0),
	AMD_PINCTRL_FUNC_GRP(131, 1),
	AMD_PINCTRL_FUNC_GRP(131, 2),
	AMD_PINCTRL_FUNC_GRP(131, 3),
	AMD_PINCTRL_FUNC_GRP(132, 0),
	AMD_PINCTRL_FUNC_GRP(132, 1),
	AMD_PINCTRL_FUNC_GRP(132, 2),
	AMD_PINCTRL_FUNC_GRP(132, 3),
	AMD_PINCTRL_FUNC_GRP(133, 0),
	AMD_PINCTRL_FUNC_GRP(133, 1),
	AMD_PINCTRL_FUNC_GRP(133, 2),
	AMD_PINCTRL_FUNC_GRP(133, 3),
	AMD_PINCTRL_FUNC_GRP(134, 0),
	AMD_PINCTRL_FUNC_GRP(134, 1),
	AMD_PINCTRL_FUNC_GRP(134, 2),
	AMD_PINCTRL_FUNC_GRP(134, 3),
	AMD_PINCTRL_FUNC_GRP(135, 0),
	AMD_PINCTRL_FUNC_GRP(135, 1),
	AMD_PINCTRL_FUNC_GRP(135, 2),
	AMD_PINCTRL_FUNC_GRP(135, 3),
	AMD_PINCTRL_FUNC_GRP(136, 0),
	AMD_PINCTRL_FUNC_GRP(136, 1),
	AMD_PINCTRL_FUNC_GRP(136, 2),
	AMD_PINCTRL_FUNC_GRP(136, 3),
	AMD_PINCTRL_FUNC_GRP(137, 0),
	AMD_PINCTRL_FUNC_GRP(137, 1),
	AMD_PINCTRL_FUNC_GRP(137, 2),
	AMD_PINCTRL_FUNC_GRP(137, 3),
	AMD_PINCTRL_FUNC_GRP(138, 0),
	AMD_PINCTRL_FUNC_GRP(138, 1),
	AMD_PINCTRL_FUNC_GRP(138, 2),
	AMD_PINCTRL_FUNC_GRP(138, 3),
	AMD_PINCTRL_FUNC_GRP(139, 0),
	AMD_PINCTRL_FUNC_GRP(139, 1),
	AMD_PINCTRL_FUNC_GRP(139, 2),
	AMD_PINCTRL_FUNC_GRP(139, 3),
	AMD_PINCTRL_FUNC_GRP(140, 0),
	AMD_PINCTRL_FUNC_GRP(140, 1),
	AMD_PINCTRL_FUNC_GRP(140, 2),
	AMD_PINCTRL_FUNC_GRP(140, 3),
	AMD_PINCTRL_FUNC_GRP(141, 0),
	AMD_PINCTRL_FUNC_GRP(141, 1),
	AMD_PINCTRL_FUNC_GRP(141, 2),
	AMD_PINCTRL_FUNC_GRP(141, 3),
	AMD_PINCTRL_FUNC_GRP(142, 0),
	AMD_PINCTRL_FUNC_GRP(142, 1),
	AMD_PINCTRL_FUNC_GRP(142, 2),
	AMD_PINCTRL_FUNC_GRP(142, 3),
	AMD_PINCTRL_FUNC_GRP(143, 0),
	AMD_PINCTRL_FUNC_GRP(143, 1),
	AMD_PINCTRL_FUNC_GRP(143, 2),
	AMD_PINCTRL_FUNC_GRP(143, 3),
	AMD_PINCTRL_FUNC_GRP(144, 0),
	AMD_PINCTRL_FUNC_GRP(144, 1),
	AMD_PINCTRL_FUNC_GRP(144, 2),
	AMD_PINCTRL_FUNC_GRP(144, 3),

	PINCTRL_PINGROUP("i2c0", AMD_PINS(145, 146), 2),
	PINCTRL_PINGROUP("i2c1", AMD_PINS(147, 148), 2),
	PINCTRL_PINGROUP("i2c2", AMD_PINS(113, 114), 2),
	PINCTRL_PINGROUP("i2c3", AMD_PINS(19, 20), 2),
	PINCTRL_PINGROUP("uart0", AMD_PINS(135, 136, 137, 138, 139), 5),
	PINCTRL_PINGROUP("uart1", AMD_PINS(140, 141, 142, 143, 144), 5),
};

#define AMD_PMUX_FUNC(_number) {						\
	.name = "iomux_gpio_"#_number,						\
	.groups = {								\
		"IMX_F0_GPIO"#_number, "IMX_F1_GPIO"#_number,			\
		"IMX_F2_GPIO"#_number, "IMX_F3_GPIO"#_number,			\
	},									\
	.index = _number,							\
	.ngroups = NSELECTS,							\
}

static const struct amd_function pmx_functions[] = {
	AMD_PMUX_FUNC(0),
	AMD_PMUX_FUNC(1),
	AMD_PMUX_FUNC(2),
	AMD_PMUX_FUNC(3),
	AMD_PMUX_FUNC(4),
	AMD_PMUX_FUNC(5),
	AMD_PMUX_FUNC(6),
	AMD_PMUX_FUNC(7),
	AMD_PMUX_FUNC(8),
	AMD_PMUX_FUNC(9),
	AMD_PMUX_FUNC(10),
	AMD_PMUX_FUNC(11),
	AMD_PMUX_FUNC(12),
	AMD_PMUX_FUNC(13),
	AMD_PMUX_FUNC(14),
	AMD_PMUX_FUNC(15),
	AMD_PMUX_FUNC(16),
	AMD_PMUX_FUNC(17),
	AMD_PMUX_FUNC(18),
	AMD_PMUX_FUNC(19),
	AMD_PMUX_FUNC(20),
	AMD_PMUX_FUNC(21),
	AMD_PMUX_FUNC(22),
	AMD_PMUX_FUNC(23),
	AMD_PMUX_FUNC(24),
	AMD_PMUX_FUNC(25),
	AMD_PMUX_FUNC(26),
	AMD_PMUX_FUNC(27),
	AMD_PMUX_FUNC(28),
	AMD_PMUX_FUNC(29),
	AMD_PMUX_FUNC(30),
	AMD_PMUX_FUNC(31),
	AMD_PMUX_FUNC(32),
	AMD_PMUX_FUNC(33),
	AMD_PMUX_FUNC(34),
	AMD_PMUX_FUNC(35),
	AMD_PMUX_FUNC(36),
	AMD_PMUX_FUNC(37),
	AMD_PMUX_FUNC(38),
	AMD_PMUX_FUNC(39),
	AMD_PMUX_FUNC(40),
	AMD_PMUX_FUNC(41),
	AMD_PMUX_FUNC(42),
	AMD_PMUX_FUNC(43),
	AMD_PMUX_FUNC(44),
	AMD_PMUX_FUNC(45),
	AMD_PMUX_FUNC(46),
	AMD_PMUX_FUNC(47),
	AMD_PMUX_FUNC(48),
	AMD_PMUX_FUNC(49),
	AMD_PMUX_FUNC(50),
	AMD_PMUX_FUNC(51),
	AMD_PMUX_FUNC(52),
	AMD_PMUX_FUNC(53),
	AMD_PMUX_FUNC(54),
	AMD_PMUX_FUNC(55),
	AMD_PMUX_FUNC(56),
	AMD_PMUX_FUNC(57),
	AMD_PMUX_FUNC(58),
	AMD_PMUX_FUNC(59),
	AMD_PMUX_FUNC(60),
	AMD_PMUX_FUNC(61),
	AMD_PMUX_FUNC(62),
	AMD_PMUX_FUNC(64),
	AMD_PMUX_FUNC(65),
	AMD_PMUX_FUNC(66),
	AMD_PMUX_FUNC(67),
	AMD_PMUX_FUNC(68),
	AMD_PMUX_FUNC(69),
	AMD_PMUX_FUNC(70),
	AMD_PMUX_FUNC(71),
	AMD_PMUX_FUNC(72),
	AMD_PMUX_FUNC(73),
	AMD_PMUX_FUNC(74),
	AMD_PMUX_FUNC(75),
	AMD_PMUX_FUNC(76),
	AMD_PMUX_FUNC(77),
	AMD_PMUX_FUNC(78),
	AMD_PMUX_FUNC(79),
	AMD_PMUX_FUNC(80),
	AMD_PMUX_FUNC(81),
	AMD_PMUX_FUNC(82),
	AMD_PMUX_FUNC(83),
	AMD_PMUX_FUNC(84),
	AMD_PMUX_FUNC(85),
	AMD_PMUX_FUNC(86),
	AMD_PMUX_FUNC(87),
	AMD_PMUX_FUNC(88),
	AMD_PMUX_FUNC(89),
	AMD_PMUX_FUNC(90),
	AMD_PMUX_FUNC(91),
	AMD_PMUX_FUNC(92),
	AMD_PMUX_FUNC(93),
	AMD_PMUX_FUNC(94),
	AMD_PMUX_FUNC(95),
	AMD_PMUX_FUNC(96),
	AMD_PMUX_FUNC(97),
	AMD_PMUX_FUNC(98),
	AMD_PMUX_FUNC(99),
	AMD_PMUX_FUNC(100),
	AMD_PMUX_FUNC(101),
	AMD_PMUX_FUNC(102),
	AMD_PMUX_FUNC(103),
	AMD_PMUX_FUNC(104),
	AMD_PMUX_FUNC(105),
	AMD_PMUX_FUNC(106),
	AMD_PMUX_FUNC(107),
	AMD_PMUX_FUNC(108),
	AMD_PMUX_FUNC(109),
	AMD_PMUX_FUNC(110),
	AMD_PMUX_FUNC(111),
	AMD_PMUX_FUNC(112),
	AMD_PMUX_FUNC(113),
	AMD_PMUX_FUNC(114),
	AMD_PMUX_FUNC(115),
	AMD_PMUX_FUNC(116),
	AMD_PMUX_FUNC(117),
	AMD_PMUX_FUNC(118),
	AMD_PMUX_FUNC(119),
	AMD_PMUX_FUNC(120),
	AMD_PMUX_FUNC(121),
	AMD_PMUX_FUNC(122),
	AMD_PMUX_FUNC(123),
	AMD_PMUX_FUNC(124),
	AMD_PMUX_FUNC(125),
	AMD_PMUX_FUNC(126),
	AMD_PMUX_FUNC(127),
	AMD_PMUX_FUNC(128),
	AMD_PMUX_FUNC(129),
	AMD_PMUX_FUNC(130),
	AMD_PMUX_FUNC(131),
	AMD_PMUX_FUNC(132),
	AMD_PMUX_FUNC(133),
	AMD_PMUX_FUNC(134),
	AMD_PMUX_FUNC(135),
	AMD_PMUX_FUNC(136),
	AMD_PMUX_FUNC(137),
	AMD_PMUX_FUNC(138),
	AMD_PMUX_FUNC(139),
	AMD_PMUX_FUNC(140),
	AMD_PMUX_FUNC(141),
	AMD_PMUX_FUNC(142),
	AMD_PMUX_FUNC(143),
	AMD_PMUX_FUNC(144),
};

#endif
