/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.fabric;

import com.mysql.cj.fabric.ServerMode;
import com.mysql.cj.fabric.ServerRole;

public class Server
implements Comparable<Server> {
    private String groupName;
    private String uuid;
    private String hostname;
    private int port;
    private ServerMode mode;
    private ServerRole role;
    private double weight;

    public Server(String groupName, String uuid, String hostname, int port, ServerMode mode, ServerRole role, double weight) {
        this.groupName = groupName;
        this.uuid = uuid;
        this.hostname = hostname;
        this.port = port;
        this.mode = mode;
        this.role = role;
        this.weight = weight;
        assert (uuid != null && !"".equals(uuid));
        assert (hostname != null && !"".equals(hostname));
        assert (port > 0);
        assert (mode != null);
        assert (role != null);
        assert (weight > 0.0);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public ServerMode getMode() {
        return this.mode;
    }

    public ServerRole getRole() {
        return this.role;
    }

    public double getWeight() {
        return this.weight;
    }

    public String getHostPortString() {
        return this.hostname + ":" + this.port;
    }

    public boolean isMaster() {
        return this.role == ServerRole.PRIMARY;
    }

    public boolean isSlave() {
        return this.role == ServerRole.SECONDARY || this.role == ServerRole.SPARE;
    }

    public String toString() {
        return String.format("Server[%s, %s:%d, %s, %s, weight=%s]", new Object[]{this.uuid, this.hostname, this.port, this.mode, this.role, this.weight});
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof Server)) {
            return false;
        }
        Server s2 = (Server)o2;
        return s2.getUuid().equals(this.getUuid());
    }

    public int hashCode() {
        return this.getUuid().hashCode();
    }

    @Override
    public int compareTo(Server other) {
        return this.getUuid().compareTo(other.getUuid());
    }
}

