/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ServerAddress;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionId;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerType;
import com.mongodb.connection.ServerVersion;

@Immutable
public class ConnectionDescription {
    private final ConnectionId connectionId;
    private final ServerVersion serverVersion;
    private final ServerType serverType;
    private final int maxBatchCount;
    private final int maxDocumentSize;
    private final int maxMessageSize;
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 0x2000000;
    private static final int DEFAULT_MAX_WRITE_BATCH_SIZE = 512;

    public ConnectionDescription(ServerId serverId) {
        this(new ConnectionId(serverId), new ServerVersion(), ServerType.UNKNOWN, 512, ServerDescription.getDefaultMaxDocumentSize(), 0x2000000);
    }

    public ConnectionDescription(ConnectionId connectionId, ServerVersion serverVersion, ServerType serverType, int maxBatchCount, int maxDocumentSize, int maxMessageSize) {
        this.connectionId = connectionId;
        this.serverType = serverType;
        this.maxBatchCount = maxBatchCount;
        this.maxDocumentSize = maxDocumentSize;
        this.maxMessageSize = maxMessageSize;
        this.serverVersion = serverVersion;
    }

    ConnectionDescription withConnectionId(ConnectionId connectionId) {
        Assertions.notNull("connectionId", connectionId);
        return new ConnectionDescription(connectionId, this.serverVersion, this.serverType, this.maxBatchCount, this.maxDocumentSize, this.maxMessageSize);
    }

    public ServerAddress getServerAddress() {
        return this.connectionId.getServerId().getAddress();
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public int getMaxBatchCount() {
        return this.maxBatchCount;
    }

    public int getMaxDocumentSize() {
        return this.maxDocumentSize;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public static int getDefaultMaxMessageSize() {
        return 0x2000000;
    }

    public static int getDefaultMaxWriteBatchSize() {
        return 512;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionDescription that = (ConnectionDescription)o;
        if (this.maxBatchCount != that.maxBatchCount) {
            return false;
        }
        if (this.maxDocumentSize != that.maxDocumentSize) {
            return false;
        }
        if (this.maxMessageSize != that.maxMessageSize) {
            return false;
        }
        if (!this.connectionId.equals(that.connectionId)) {
            return false;
        }
        if (this.serverType != that.serverType) {
            return false;
        }
        return this.serverVersion.equals(that.serverVersion);
    }

    public int hashCode() {
        int result = this.connectionId.hashCode();
        result = 31 * result + this.serverVersion.hashCode();
        result = 31 * result + this.serverType.hashCode();
        result = 31 * result + this.maxBatchCount;
        result = 31 * result + this.maxDocumentSize;
        result = 31 * result + this.maxMessageSize;
        return result;
    }
}

