/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.ClusterDescription;
import com.mongodb.DBObject;
import com.mongodb.ServerDescription;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.TaggableReadPreference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReadPreference {
    @Deprecated
    public static final ReadPreference PRIMARY;
    @Deprecated
    public static final ReadPreference SECONDARY;
    private static final ReadPreference _PRIMARY;
    private static final ReadPreference _SECONDARY;
    private static final ReadPreference _SECONDARY_PREFERRED;
    private static final ReadPreference _PRIMARY_PREFERRED;
    private static final ReadPreference _NEAREST;

    ReadPreference() {
    }

    public abstract boolean isSlaveOk();

    @Deprecated
    public abstract DBObject toDBObject();

    public abstract String getName();

    abstract List<ServerDescription> choose(ClusterDescription var1);

    public static ReadPreference primary() {
        return _PRIMARY;
    }

    public static ReadPreference primaryPreferred() {
        return _PRIMARY_PREFERRED;
    }

    public static ReadPreference secondary() {
        return _SECONDARY;
    }

    public static ReadPreference secondaryPreferred() {
        return _SECONDARY_PREFERRED;
    }

    public static ReadPreference nearest() {
        return _NEAREST;
    }

    public static TaggableReadPreference primaryPreferred(TagSet tagSet) {
        return ReadPreference.primaryPreferred(Arrays.asList(tagSet));
    }

    public static TaggableReadPreference secondary(TagSet tagSet) {
        return ReadPreference.secondary(Arrays.asList(tagSet));
    }

    public static TaggableReadPreference secondaryPreferred(TagSet tagSet) {
        return ReadPreference.secondaryPreferred(Arrays.asList(tagSet));
    }

    public static TaggableReadPreference nearest(TagSet tagSet) {
        return ReadPreference.nearest(Arrays.asList(tagSet));
    }

    public static TaggableReadPreference primaryPreferred(List<TagSet> tagSetList) {
        return new TaggableReadPreference.PrimaryPreferredReadPreference(tagSetList);
    }

    public static TaggableReadPreference secondary(List<TagSet> tagSetList) {
        return new TaggableReadPreference.SecondaryReadPreference(tagSetList);
    }

    public static TaggableReadPreference secondaryPreferred(List<TagSet> tagSetList) {
        return new TaggableReadPreference.SecondaryPreferredReadPreference(tagSetList);
    }

    public static TaggableReadPreference nearest(List<TagSet> tagSetList) {
        return new TaggableReadPreference.NearestReadPreference(tagSetList);
    }

    @Deprecated
    public static TaggableReadPreference primaryPreferred(DBObject firstTagSet, DBObject ... remainingTagSets) {
        return new TaggableReadPreference.PrimaryPreferredReadPreference(ReadPreference.toTagsList(firstTagSet, remainingTagSets));
    }

    @Deprecated
    public static TaggableReadPreference secondary(DBObject firstTagSet, DBObject ... remainingTagSets) {
        return new TaggableReadPreference.SecondaryReadPreference(ReadPreference.toTagsList(firstTagSet, remainingTagSets));
    }

    @Deprecated
    public static TaggableReadPreference secondaryPreferred(DBObject firstTagSet, DBObject ... remainingTagSets) {
        return new TaggableReadPreference.SecondaryPreferredReadPreference(ReadPreference.toTagsList(firstTagSet, remainingTagSets));
    }

    @Deprecated
    public static TaggableReadPreference nearest(DBObject firstTagSet, DBObject ... remainingTagSets) {
        return new TaggableReadPreference.NearestReadPreference(ReadPreference.toTagsList(firstTagSet, remainingTagSets));
    }

    public static ReadPreference valueOf(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if ((name = name.toLowerCase()).equals(_PRIMARY.getName().toLowerCase())) {
            return _PRIMARY;
        }
        if (name.equals(_SECONDARY.getName().toLowerCase())) {
            return _SECONDARY;
        }
        if (name.equals(_SECONDARY_PREFERRED.getName().toLowerCase())) {
            return _SECONDARY_PREFERRED;
        }
        if (name.equals(_PRIMARY_PREFERRED.getName().toLowerCase())) {
            return _PRIMARY_PREFERRED;
        }
        if (name.equals(_NEAREST.getName().toLowerCase())) {
            return _NEAREST;
        }
        throw new IllegalArgumentException("No match for read preference of " + name);
    }

    public static TaggableReadPreference valueOf(String name, List<TagSet> tagSetList) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if ((name = name.toLowerCase()).equals(PRIMARY.getName().toLowerCase())) {
            throw new IllegalArgumentException("Primary read preference can not also specify tag sets");
        }
        if (name.equals(_SECONDARY.getName().toLowerCase())) {
            return ReadPreference.secondary(tagSetList);
        }
        if (name.equals(_SECONDARY_PREFERRED.getName().toLowerCase())) {
            return ReadPreference.secondaryPreferred(tagSetList);
        }
        if (name.equals(_PRIMARY_PREFERRED.getName().toLowerCase())) {
            return ReadPreference.primaryPreferred(tagSetList);
        }
        if (name.equals(_NEAREST.getName().toLowerCase())) {
            return ReadPreference.nearest(tagSetList);
        }
        throw new IllegalArgumentException("No match for read preference of " + name);
    }

    @Deprecated
    public static TaggableReadPreference valueOf(String name, DBObject firstTagSet, DBObject ... remainingTagSets) {
        return ReadPreference.valueOf(name, ReadPreference.toTagsList(firstTagSet, remainingTagSets));
    }

    @Deprecated
    public static ReadPreference withTags(Map<String, String> tags) {
        return new TaggedReadPreference(tags);
    }

    @Deprecated
    public static ReadPreference withTags(DBObject tags) {
        return new TaggedReadPreference(tags);
    }

    private static List<TagSet> toTagsList(DBObject firstTagSet, DBObject ... remainingTagSets) {
        ArrayList<TagSet> tagsList = new ArrayList<TagSet>(remainingTagSets.length + 1);
        tagsList.add(ReadPreference.toTags(firstTagSet));
        for (DBObject cur : remainingTagSets) {
            tagsList.add(ReadPreference.toTags(cur));
        }
        return tagsList;
    }

    private static TagSet toTags(DBObject tagsDocument) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (String key : tagsDocument.keySet()) {
            tagList.add(new Tag(key, tagsDocument.get(key).toString()));
        }
        return new TagSet(tagList);
    }

    static {
        _PRIMARY = new PrimaryReadPreference();
        _SECONDARY = new TaggableReadPreference.SecondaryReadPreference();
        _SECONDARY_PREFERRED = new TaggableReadPreference.SecondaryPreferredReadPreference();
        _PRIMARY_PREFERRED = new TaggableReadPreference.PrimaryPreferredReadPreference();
        _NEAREST = new TaggableReadPreference.NearestReadPreference();
        PRIMARY = _PRIMARY;
        SECONDARY = _SECONDARY_PREFERRED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static class TaggedReadPreference
    extends ReadPreference {
        private final DBObject _tags;
        private final ReadPreference _pref;

        public TaggedReadPreference(Map<String, String> tags) {
            if (tags == null || tags.size() == 0) {
                throw new IllegalArgumentException("tags can not be null or empty");
            }
            this._tags = new BasicDBObject(tags);
            List<DBObject> maps = TaggedReadPreference.splitMapIntoMultipleMaps(this._tags);
            this._pref = new TaggableReadPreference.SecondaryReadPreference(ReadPreference.toTagsList(maps.get(0), this.getRemainingMaps(maps)));
        }

        public TaggedReadPreference(DBObject tags) {
            if (tags == null || tags.keySet().size() == 0) {
                throw new IllegalArgumentException("tags can not be null or empty");
            }
            this._tags = tags;
            List<DBObject> maps = TaggedReadPreference.splitMapIntoMultipleMaps(this._tags);
            this._pref = new TaggableReadPreference.SecondaryReadPreference(ReadPreference.toTagsList(maps.get(0), this.getRemainingMaps(maps)));
        }

        public DBObject getTags() {
            BasicDBObject tags = new BasicDBObject();
            for (String key : this._tags.keySet()) {
                tags.put(key, this._tags.get(key));
            }
            return tags;
        }

        @Override
        public boolean isSlaveOk() {
            return this._pref.isSlaveOk();
        }

        @Override
        List<ServerDescription> choose(ClusterDescription clusterDescription) {
            return this._pref.choose(clusterDescription);
        }

        @Override
        public DBObject toDBObject() {
            return this._pref.toDBObject();
        }

        @Override
        public String getName() {
            return this._pref.getName();
        }

        private static List<DBObject> splitMapIntoMultipleMaps(DBObject tags) {
            ArrayList<DBObject> tagList = new ArrayList<DBObject>(tags.keySet().size());
            for (String key : tags.keySet()) {
                tagList.add(new BasicDBObject(key, tags.get(key).toString()));
            }
            return tagList;
        }

        private DBObject[] getRemainingMaps(List<DBObject> maps) {
            if (maps.size() <= 1) {
                return new DBObject[0];
            }
            return maps.subList(1, maps.size() - 1).toArray(new DBObject[maps.size() - 1]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrimaryReadPreference
    extends ReadPreference {
        private PrimaryReadPreference() {
        }

        @Override
        public boolean isSlaveOk() {
            return false;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        List<ServerDescription> choose(ClusterDescription clusterDescription) {
            return clusterDescription.getPrimaries();
        }

        @Override
        public DBObject toDBObject() {
            return new BasicDBObject("mode", this.getName());
        }

        @Override
        public String getName() {
            return "primary";
        }
    }
}

