/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.io;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.ProfilerEventHandler;
import com.mysql.cj.api.authentication.AuthenticationProvider;
import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.conf.ReadableProperty;
import com.mysql.cj.api.io.PacketBuffer;
import com.mysql.cj.api.io.Protocol;
import com.mysql.cj.api.io.SocketConnection;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.jdbc.ResultSetInternalMethods;
import com.mysql.cj.api.jdbc.Statement;
import com.mysql.cj.api.jdbc.interceptors.StatementInterceptorV2;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.core.Constants;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.MysqlType;
import com.mysql.cj.core.ServerVersion;
import com.mysql.cj.core.exceptions.CJConnectionFeatureNotAvailableException;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.CJPacketTooBigException;
import com.mysql.cj.core.exceptions.CJTimeoutException;
import com.mysql.cj.core.exceptions.ClosedOnExpiredPasswordException;
import com.mysql.cj.core.exceptions.DataTruncationException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.FeatureNotAvailableException;
import com.mysql.cj.core.exceptions.OperationCancelledException;
import com.mysql.cj.core.exceptions.PasswordExpiredException;
import com.mysql.cj.core.exceptions.UnableToConnectException;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.io.AbstractProtocol;
import com.mysql.cj.core.io.ExportControlled;
import com.mysql.cj.core.profiler.ProfilerEventHandlerFactory;
import com.mysql.cj.core.profiler.ProfilerEventImpl;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.core.util.LazyString;
import com.mysql.cj.core.util.LogUtils;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.core.util.TestUtils;
import com.mysql.cj.jdbc.MysqlIO;
import com.mysql.cj.jdbc.PreparedStatement;
import com.mysql.cj.jdbc.ResultSetImpl;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.util.ResultSetUtil;
import com.mysql.cj.jdbc.util.TimeUtil;
import com.mysql.cj.mysqla.authentication.MysqlaAuthenticationProvider;
import com.mysql.cj.mysqla.io.Buffer;
import com.mysql.cj.mysqla.io.CompressedInputStream;
import com.mysql.cj.mysqla.io.CompressedPacketSender;
import com.mysql.cj.mysqla.io.DebugBufferingPacketSender;
import com.mysql.cj.mysqla.io.MysqlaCapabilities;
import com.mysql.cj.mysqla.io.MysqlaServerSession;
import com.mysql.cj.mysqla.io.SimplePacketSender;
import com.mysql.cj.mysqla.io.TimeTrackingPacketSender;
import com.mysql.cj.mysqla.io.TracingPacketSender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.SocketException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MysqlaProtocol
extends AbstractProtocol
implements Protocol {
    protected static final int INITIAL_PACKET_SIZE = 1024;
    protected static final int COMP_HEADER_LENGTH = 3;
    private static final int MAX_PACKET_DUMP_LENGTH = 1024;
    protected static final int MAX_QUERY_SIZE_TO_EXPLAIN = 0x100000;
    private static final String EXPLAINABLE_STATEMENT = "SELECT";
    private static final String[] EXPLAINABLE_STATEMENT_EXTENSION = new String[]{"INSERT", "UPDATE", "REPLACE", "DELETE"};
    protected MysqlaServerSession serverSession;
    protected CompressedPacketSender compressedPacketSender;
    private Buffer sendPacket = null;
    protected Buffer sharedSendPacket = null;
    protected Buffer reusablePacket = null;
    protected byte packetSequence = 0;
    protected byte readPacketSequence = (byte)-1;
    protected boolean checkPacketSequence = false;
    protected boolean useCompression = false;
    protected byte[] packetHeaderBuf = new byte[4];
    private int maxAllowedPacket = 0x100000;
    private boolean packetSequenceReset = false;
    private boolean needToGrabQueryFromPacket;
    private boolean autoGenerateTestcaseScript;
    private boolean logSlowQueries = false;
    private boolean useAutoSlowLog;
    private boolean profileSQL = false;
    private boolean useNanosForElapsedTime;
    private long slowQueryThreshold;
    private String queryTimingUnits;
    private int commandCount = 0;
    protected boolean hadWarnings = false;
    private int warningCount = 0;
    private boolean queryBadIndexUsed = false;
    private boolean queryNoIndexUsed = false;
    private boolean serverQueryWasSlow = false;
    protected MysqlIO resultsHandler = null;
    protected boolean platformDbCharsetMatches = true;
    private int statementExecutionDepth = 0;
    private List<StatementInterceptorV2> statementInterceptors;
    private ReadableProperty<Boolean> maintainTimeStats;
    private ReadableProperty<Integer> maxQuerySizeToLog;
    private static String jvmPlatformCharset = null;

    public static MysqlaProtocol getInstance(MysqlConnection conn, SocketConnection socketConnection, PropertySet propertySet, Log log) {
        MysqlaProtocol protocol = new MysqlaProtocol(log);
        protocol.init(conn, propertySet.getIntegerReadableProperty("socketTimeout").getValue(), socketConnection, propertySet);
        return protocol;
    }

    public MysqlaProtocol(Log logger) {
        this.log = logger;
    }

    @Override
    public void init(MysqlConnection conn, int socketTimeout, SocketConnection phConnection, PropertySet propSet) {
        this.connection = conn;
        this.setPropertySet(propSet);
        this.socketConnection = phConnection;
        if (this.getPropertySet().getBooleanReadableProperty("enablePacketDebug").getValue().booleanValue()) {
            this.packetDebugRingBuffer = new LinkedList();
        }
        this.maintainTimeStats = this.propertySet.getBooleanReadableProperty("maintainTimeStats");
        this.maxQuerySizeToLog = this.propertySet.getIntegerReadableProperty("maxQuerySizeToLog");
        this.traceProtocol = this.propertySet.getBooleanReadableProperty("traceProtocol").getValue();
        this.useAutoSlowLog = this.propertySet.getBooleanReadableProperty("autoSlowLog").getValue();
        this.logSlowQueries = this.propertySet.getBooleanReadableProperty("logSlowQueries").getValue();
        this.reusablePacket = new Buffer(1024);
        this.sendPacket = new Buffer(1024);
        this.exceptionInterceptor = this.socketConnection.getExceptionInterceptor();
        this.packetSender = new SimplePacketSender(this.socketConnection.getMysqlOutput());
        this.profileSQL = this.propertySet.getBooleanReadableProperty("profileSQL").getValue();
        this.autoGenerateTestcaseScript = this.propertySet.getBooleanReadableProperty("autoGenerateTestcaseScript").getValue();
        boolean bl = this.needToGrabQueryFromPacket = this.profileSQL || this.logSlowQueries || this.autoGenerateTestcaseScript;
        if (this.propertySet.getBooleanReadableProperty("useNanosForElapsedTime").getValue().booleanValue() && TimeUtil.nanoTimeAvailable()) {
            this.useNanosForElapsedTime = true;
            this.queryTimingUnits = Messages.getString("Nanoseconds");
        } else {
            this.queryTimingUnits = Messages.getString("Milliseconds");
        }
        if (this.propertySet.getBooleanReadableProperty("logSlowQueries").getValue().booleanValue()) {
            this.calculateSlowQueryThreshold();
        }
        this.authProvider = new MysqlaAuthenticationProvider(this.log);
        this.authProvider.init(conn, this, this.getPropertySet(), this.socketConnection.getExceptionInterceptor());
        this.resultsHandler = new MysqlIO(this, this.getPropertySet(), (JdbcConnection)this.connection);
    }

    @Override
    public void negotiateSSLConnection(int packLength) {
        if (!ExportControlled.enabled()) {
            throw new CJConnectionFeatureNotAvailableException(this.getPropertySet(), this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), null);
        }
        long clientParam = this.serverSession.getClientParam();
        this.serverSession.setClientParam(clientParam |= 0x800L);
        Buffer packet = new Buffer(packLength);
        packet.setPosition(0);
        packet.writeLong(clientParam);
        packet.writeLong(0xFFFFFFL);
        packet.writeByte(AuthenticationProvider.getCharsetForHandshake(this.authProvider.getEncodingForHandshake(), this.serverSession.getCapabilities().getServerVersion()));
        packet.writeBytesNoNull(new byte[23]);
        this.send(packet, packet.getPosition());
        try {
            ExportControlled.transformSocketToSSLSocket(this.socketConnection, this.serverSession.getServerVersion());
        }
        catch (FeatureNotAvailableException nae) {
            throw new CJConnectionFeatureNotAvailableException(this.getPropertySet(), this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), nae);
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.getConnection().getPropertySet(), this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, ioEx, this.getExceptionInterceptor());
        }
        this.packetSender = new SimplePacketSender(this.socketConnection.getMysqlOutput());
    }

    @Override
    public void rejectConnection(String message) {
        try {
            ((JdbcConnection)this.connection).close();
        }
        catch (SQLException e2) {
            throw ExceptionFactory.createException(e2.getMessage(), e2, this.getExceptionInterceptor());
        }
        this.socketConnection.forceClose();
        throw ExceptionFactory.createException(UnableToConnectException.class, message, this.getExceptionInterceptor());
    }

    @Override
    public void rejectProtocol(Buffer buf) {
        try {
            this.socketConnection.getMysqlSocket().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int errno = 2000;
        errno = buf.readInt();
        String serverErrorMessage = "";
        try {
            serverErrorMessage = buf.readString("ASCII");
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder errorBuf = new StringBuilder(Messages.getString("MysqlIO.10"));
        errorBuf.append(serverErrorMessage);
        errorBuf.append("\"");
        String xOpen = SQLError.mysqlToSqlState(errno);
        throw ExceptionFactory.createException(SQLError.get(xOpen) + ", " + errorBuf.toString(), xOpen, errno, false, null, this.getExceptionInterceptor());
    }

    @Override
    public void beforeHandshake() {
        this.checkPacketSequence = false;
        this.readPacketSequence = 0;
        this.serverSession = new MysqlaServerSession(this.propertySet);
        MysqlaCapabilities capabilities = this.readServerCapabilities();
        this.serverSession.setCapabilities(capabilities);
    }

    @Override
    public void afterHandshake() {
        this.checkTransactionState();
        PropertySet pset = this.getPropertySet();
        if ((this.serverSession.getCapabilities().getCapabilityFlags() & 0x20) != 0 && pset.getBooleanReadableProperty("useCompression").getValue().booleanValue() && !(this.socketConnection.getMysqlInput().getUnderlyingStream() instanceof CompressedInputStream)) {
            this.useCompression = true;
            this.socketConnection.setMysqlInput(new CompressedInputStream(this.socketConnection.getMysqlInput(), pset.getBooleanReadableProperty("traceProtocol"), this.log));
            this.compressedPacketSender = new CompressedPacketSender(this.socketConnection.getMysqlOutput());
            this.packetSender = this.compressedPacketSender;
        }
        this.decoratePacketSender();
        try {
            this.socketConnection.setMysqlSocket(this.socketConnection.getSocketFactory().afterHandshake());
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.getPropertySet(), this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, ioEx, this.getExceptionInterceptor());
        }
    }

    @Override
    public MysqlaCapabilities readServerCapabilities() {
        Buffer buf = this.readPacket();
        MysqlaCapabilities serverCapabilities = new MysqlaCapabilities();
        serverCapabilities.setInitialHandshakePacket(buf);
        if (serverCapabilities.getProtocolVersion() == -1) {
            this.rejectProtocol(buf);
        }
        return serverCapabilities;
    }

    @Override
    public MysqlaServerSession getServerSession() {
        return this.serverSession;
    }

    @Override
    public void changeDatabase(String database) {
        if (database == null || database.length() == 0) {
            return;
        }
        try {
            this.sendCommand(2, database, null, false, null, 0);
        }
        catch (CJException ex) {
            if (this.getPropertySet().getBooleanReadableProperty("createDatabaseIfNotExist").getValue().booleanValue()) {
                this.sendCommand(3, "CREATE DATABASE IF NOT EXISTS " + database, null, false, null, 0);
                this.sendCommand(2, database, null, false, null, 0);
            }
            throw ExceptionFactory.createCommunicationsException(this.getPropertySet(), this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, ex, this.getExceptionInterceptor());
        }
    }

    @Override
    public final Buffer readPacket() {
        try {
            int lengthRead = this.socketConnection.getMysqlInput().readFully(this.packetHeaderBuf, 0, 4);
            if (lengthRead < 4) {
                this.socketConnection.forceClose();
                throw new IOException(Messages.getString("MysqlIO.1"));
            }
            int packetLength = (this.packetHeaderBuf[0] & 0xFF) + ((this.packetHeaderBuf[1] & 0xFF) << 8) + ((this.packetHeaderBuf[2] & 0xFF) << 16);
            if (packetLength > this.maxAllowedPacket) {
                throw new CJPacketTooBigException(packetLength, this.maxAllowedPacket);
            }
            if (this.traceProtocol) {
                StringBuilder traceMessageBuf = new StringBuilder();
                traceMessageBuf.append(Messages.getString("MysqlIO.2"));
                traceMessageBuf.append(packetLength);
                traceMessageBuf.append(Messages.getString("MysqlIO.3"));
                traceMessageBuf.append(StringUtils.dumpAsHex(this.packetHeaderBuf, 4));
                this.log.logTrace(traceMessageBuf.toString());
            }
            byte multiPacketSeq = this.packetHeaderBuf[3];
            if (!this.packetSequenceReset) {
                if (this.enablePacketDebug && this.checkPacketSequence) {
                    this.checkPacketSequencing(multiPacketSeq);
                }
            } else {
                this.packetSequenceReset = false;
            }
            this.readPacketSequence = multiPacketSeq;
            byte[] buffer = new byte[packetLength + 1];
            int numBytesRead = this.socketConnection.getMysqlInput().readFully(buffer, 0, packetLength);
            if (numBytesRead != packetLength) {
                throw new IOException(Messages.getString("MysqlIO.104", new Object[]{packetLength, numBytesRead}));
            }
            buffer[packetLength] = 0;
            Buffer packet = new Buffer(buffer);
            packet.setBufLength(packetLength + 1);
            if (this.traceProtocol) {
                StringBuilder traceMessageBuf = new StringBuilder();
                traceMessageBuf.append(Messages.getString("MysqlIO.4"));
                traceMessageBuf.append(MysqlaProtocol.getPacketDumpToLog(packet, packetLength));
                this.log.logTrace(traceMessageBuf.toString());
            }
            if (this.enablePacketDebug) {
                this.enqueuePacketForDebugging(false, false, this.packetHeaderBuf, packet);
            }
            if (this.maintainTimeStats.getValue().booleanValue()) {
                this.lastPacketReceivedTimeMs = System.currentTimeMillis();
            }
            return packet;
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, ioEx, this.getExceptionInterceptor());
        }
        catch (CJException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ExceptionFactory.createException(ex.getMessage(), ex, this.getExceptionInterceptor());
        }
        catch (OutOfMemoryError oom) {
            try {
                ((JdbcConnection)this.connection).realClose(false, false, true, oom);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw oom;
        }
    }

    @Override
    public Buffer readNextPacket() {
        Buffer packet = this.checkErrorPacket();
        this.packetSequence = (byte)(this.packetSequence + 1);
        return packet;
    }

    @Override
    public final void send(PacketBuffer packet, int packetLen) {
        try {
            if (this.maxAllowedPacket > 0 && packetLen > this.maxAllowedPacket) {
                throw new CJPacketTooBigException(packetLen, this.maxAllowedPacket);
            }
            this.packetSequence = (byte)(this.packetSequence + 1);
            this.packetSender.send(packet.getByteBuffer(), packetLen, this.packetSequence);
            if (packet == this.sharedSendPacket) {
                this.reclaimLargeSharedSendPacket();
            }
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.getPropertySet(), this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, ioEx, this.getExceptionInterceptor());
        }
    }

    @Override
    public final Buffer sendCommand(int command, String extraData, Buffer queryPacket, boolean skipCheck, String extraDataCharEncoding, int timeoutMillis) {
        ++this.commandCount;
        this.enablePacketDebug = this.getPropertySet().getBooleanReadableProperty("enablePacketDebug").getValue();
        this.readPacketSequence = 0;
        int oldTimeout = 0;
        if (timeoutMillis != 0) {
            try {
                oldTimeout = this.socketConnection.getMysqlSocket().getSoTimeout();
                this.socketConnection.getMysqlSocket().setSoTimeout(timeoutMillis);
            }
            catch (SocketException e2) {
                throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, e2, this.getExceptionInterceptor());
            }
        }
        try {
            int bytesLeft;
            this.resultsHandler.checkForOutstandingStreamingData();
            this.serverSession.setStatusFlags(0, true);
            this.hadWarnings = false;
            this.setWarningCount(0);
            this.queryNoIndexUsed = false;
            this.queryBadIndexUsed = false;
            this.serverQueryWasSlow = false;
            if (this.useCompression && (bytesLeft = this.socketConnection.getMysqlInput().available()) > 0) {
                this.socketConnection.getMysqlInput().skip(bytesLeft);
            }
            try {
                this.clearInputStream();
                if (queryPacket == null) {
                    int packLength = 4 + (extraData != null ? extraData.length() : 0) + 2;
                    if (this.sendPacket == null) {
                        this.sendPacket = new Buffer(packLength);
                        this.sendPacket.setPosition(0);
                    }
                    this.packetSequence = (byte)-1;
                    this.readPacketSequence = 0;
                    this.checkPacketSequence = true;
                    this.sendPacket.setPosition(0);
                    this.sendPacket.writeByte((byte)command);
                    if (command == 2 || command == 5 || command == 6 || command == 3 || command == 22) {
                        if (extraDataCharEncoding == null) {
                            this.sendPacket.writeStringNoNull(extraData);
                        } else {
                            this.sendPacket.writeStringNoNull(extraData, extraDataCharEncoding);
                        }
                    } else if (command == 12) {
                        long id = Long.parseLong(extraData);
                        this.sendPacket.writeLong(id);
                    }
                    this.send(this.sendPacket, this.sendPacket.getPosition());
                } else {
                    this.packetSequence = (byte)-1;
                    this.send(queryPacket, queryPacket.getPosition());
                }
            }
            catch (CJException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, ex, this.getExceptionInterceptor());
            }
            Buffer returnPacket = null;
            if (!skipCheck) {
                if (command == 23 || command == 26) {
                    this.readPacketSequence = 0;
                    this.packetSequenceReset = true;
                }
                returnPacket = this.checkErrorPacket(command);
            }
            Buffer buffer = returnPacket;
            return buffer;
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, ioEx, this.getExceptionInterceptor());
        }
        finally {
            if (timeoutMillis != 0) {
                try {
                    this.socketConnection.getMysqlSocket().setSoTimeout(oldTimeout);
                }
                catch (SocketException e3) {
                    throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, e3, this.getExceptionInterceptor());
                }
            }
        }
    }

    public void checkTransactionState() {
        int transState = this.serverSession.getTransactionState();
        try {
            if (transState == 3) {
                ((JdbcConnection)this.connection).transactionCompleted();
            } else if (transState == 2) {
                ((JdbcConnection)this.connection).transactionBegun();
            }
        }
        catch (SQLException e2) {
            throw ExceptionFactory.createException(e2.getMessage(), e2, this.getExceptionInterceptor());
        }
    }

    public void resetMaxBuf() {
        this.maxAllowedPacket = this.propertySet.getIntegerReadableProperty("maxAllowedPacket").getValue();
    }

    private void checkPacketSequencing(byte multiPacketSeq) {
        if (multiPacketSeq == -128 && this.readPacketSequence != 127) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, new IOException(Messages.getString("MysqlIO.108", new Object[]{multiPacketSeq})), this.getExceptionInterceptor());
        }
        if (this.readPacketSequence == -1 && multiPacketSeq != 0) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, new IOException(Messages.getString("MysqlIO.109", new Object[]{multiPacketSeq})), this.getExceptionInterceptor());
        }
        if (multiPacketSeq != -128 && this.readPacketSequence != -1 && multiPacketSeq != this.readPacketSequence + 1) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, new IOException(Messages.getString("MysqlIO.110", new Object[]{multiPacketSeq})), this.getExceptionInterceptor());
        }
    }

    private static final String getPacketDumpToLog(Buffer packetToDump, int packetLength) {
        if (packetLength < 1024) {
            return packetToDump.dump(packetLength);
        }
        StringBuilder packetDumpBuf = new StringBuilder(4096);
        packetDumpBuf.append(packetToDump.dump(1024));
        packetDumpBuf.append(Messages.getString("MysqlIO.36"));
        packetDumpBuf.append(1024);
        packetDumpBuf.append(Messages.getString("MysqlIO.37"));
        return packetDumpBuf.toString();
    }

    private void enqueuePacketForDebugging(boolean isPacketBeingSent, boolean isPacketReused, byte[] header, Buffer packet) {
        if (this.packetDebugRingBuffer.size() + 1 > this.propertySet.getIntegerReadableProperty("packetDebugBufferSize").getValue()) {
            this.packetDebugRingBuffer.removeFirst();
        }
        StringBuilder packetDump = null;
        if (!isPacketBeingSent) {
            int bytesToDump = Math.min(1024, packet.getBufLength());
            Buffer packetToDump = new Buffer(4 + bytesToDump);
            packetToDump.setPosition(0);
            packetToDump.writeBytesNoNull(header);
            packetToDump.writeBytesNoNull(packet.getBytes(0, bytesToDump));
            String packetPayload = packetToDump.dump(bytesToDump);
            packetDump = new StringBuilder(96 + packetPayload.length());
            packetDump.append("Server ");
            packetDump.append(isPacketReused ? "(re-used) " : "(new) ");
            packetDump.append(packet.toSuperString());
            packetDump.append(" --------------------> Client\n");
            packetDump.append("\nPacket payload:\n\n");
            packetDump.append(packetPayload);
            if (bytesToDump == 1024) {
                packetDump.append("\nNote: Packet of " + packet.getBufLength() + " bytes truncated to " + 1024 + " bytes.\n");
            }
        }
        this.packetDebugRingBuffer.addLast(packetDump);
    }

    public Buffer checkErrorPacket() {
        return this.checkErrorPacket(-1);
    }

    private Buffer checkErrorPacket(int command) {
        Buffer resultPacket = null;
        this.serverSession.setStatusFlags(0);
        try {
            resultPacket = this.reuseAndReadPacket(this.reusablePacket);
        }
        catch (CJException ex) {
            throw ex;
        }
        catch (Exception fallThru) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, fallThru, this.getExceptionInterceptor());
        }
        this.checkErrorPacket(resultPacket);
        return resultPacket;
    }

    public void checkErrorPacket(Buffer resultPacket) {
        byte statusCode = resultPacket.readByte();
        if (statusCode == -1) {
            int errno = 2000;
            errno = resultPacket.readInt();
            String xOpen = null;
            String serverErrorMessage = resultPacket.readString(this.serverSession.getErrorMessageEncoding());
            if (serverErrorMessage.charAt(0) == '#') {
                if (serverErrorMessage.length() > 6) {
                    xOpen = serverErrorMessage.substring(1, 6);
                    serverErrorMessage = serverErrorMessage.substring(6);
                    if (xOpen.equals("HY000")) {
                        xOpen = SQLError.mysqlToSqlState(errno);
                    }
                } else {
                    xOpen = SQLError.mysqlToSqlState(errno);
                }
            } else {
                xOpen = SQLError.mysqlToSqlState(errno);
            }
            this.clearInputStream();
            StringBuilder errorBuf = new StringBuilder();
            String xOpenErrorMessage = SQLError.get(xOpen);
            boolean useOnlyServerErrorMessages = this.propertySet.getBooleanReadableProperty("useOnlyServerErrorMessages").getValue();
            if (!useOnlyServerErrorMessages && xOpenErrorMessage != null) {
                errorBuf.append(xOpenErrorMessage);
                errorBuf.append(Messages.getString("MysqlIO.68"));
            }
            errorBuf.append(serverErrorMessage);
            if (!useOnlyServerErrorMessages && xOpenErrorMessage != null) {
                errorBuf.append("\"");
            }
            this.resultsHandler.appendDeadlockStatusInformation(xOpen, errorBuf);
            if (xOpen != null) {
                if (xOpen.startsWith("22")) {
                    throw new DataTruncationException(errorBuf.toString(), 0, true, false, 0, 0, errno);
                }
                if (errno == 1820) {
                    throw ExceptionFactory.createException(PasswordExpiredException.class, errorBuf.toString(), this.getExceptionInterceptor());
                }
                if (errno == 1862) {
                    throw ExceptionFactory.createException(ClosedOnExpiredPasswordException.class, errorBuf.toString(), this.getExceptionInterceptor());
                }
            }
            throw ExceptionFactory.createException(errorBuf.toString(), xOpen, errno, false, null, this.getExceptionInterceptor());
        }
    }

    private void reclaimLargeSharedSendPacket() {
        if (this.sharedSendPacket != null && this.sharedSendPacket.getCapacity() > 0x100000) {
            this.sharedSendPacket = new Buffer(1024);
        }
    }

    public void clearInputStream() {
        try {
            int len;
            while ((len = this.socketConnection.getMysqlInput().available()) > 0 && this.socketConnection.getMysqlInput().skip(len) > 0L) {
            }
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, ioEx, this.getExceptionInterceptor());
        }
    }

    public void reclaimLargeReusablePacket() {
        if (this.reusablePacket != null && this.reusablePacket.getCapacity() > 0x100000) {
            this.reusablePacket = new Buffer(1024);
        }
    }

    public final Buffer reuseAndReadPacket(Buffer reuse) {
        return this.reuseAndReadPacket(reuse, -1);
    }

    public final Buffer reuseAndReadPacket(Buffer reuse, int existingPacketLength) {
        try {
            reuse.setWasMultiPacket(false);
            int packetLength = 0;
            if (existingPacketLength == -1) {
                int lengthRead = this.socketConnection.getMysqlInput().readFully(this.packetHeaderBuf, 0, 4);
                if (lengthRead < 4) {
                    this.socketConnection.forceClose();
                    throw new IOException(Messages.getString("MysqlIO.43"));
                }
                packetLength = (this.packetHeaderBuf[0] & 0xFF) + ((this.packetHeaderBuf[1] & 0xFF) << 8) + ((this.packetHeaderBuf[2] & 0xFF) << 16);
            } else {
                packetLength = existingPacketLength;
            }
            if (this.traceProtocol) {
                StringBuilder traceMessageBuf = new StringBuilder();
                traceMessageBuf.append(Messages.getString("MysqlIO.44"));
                traceMessageBuf.append(packetLength);
                traceMessageBuf.append(Messages.getString("MysqlIO.45"));
                traceMessageBuf.append(StringUtils.dumpAsHex(this.packetHeaderBuf, 4));
                this.log.logTrace(traceMessageBuf.toString());
            }
            byte multiPacketSeq = this.packetHeaderBuf[3];
            if (!this.packetSequenceReset) {
                if (this.enablePacketDebug && this.checkPacketSequence) {
                    this.checkPacketSequencing(multiPacketSeq);
                }
            } else {
                this.packetSequenceReset = false;
            }
            this.readPacketSequence = multiPacketSeq;
            reuse.setPosition(0);
            if (reuse.getByteBuffer().length <= packetLength) {
                reuse.setByteBuffer(new byte[packetLength + 1]);
            }
            reuse.setBufLength(packetLength);
            int numBytesRead = this.socketConnection.getMysqlInput().readFully(reuse.getByteBuffer(), 0, packetLength);
            if (numBytesRead != packetLength) {
                throw new IOException(Messages.getString("MysqlIO.104", new Object[]{packetLength, numBytesRead}));
            }
            if (this.traceProtocol) {
                StringBuilder traceMessageBuf = new StringBuilder();
                traceMessageBuf.append(Messages.getString("MysqlIO.46"));
                traceMessageBuf.append(MysqlaProtocol.getPacketDumpToLog(reuse, packetLength));
                this.log.logTrace(traceMessageBuf.toString());
            }
            if (this.enablePacketDebug) {
                this.enqueuePacketForDebugging(false, true, this.packetHeaderBuf, reuse);
            }
            boolean isMultiPacket = false;
            if (packetLength == 0xFFFFFF) {
                reuse.setPosition(0xFFFFFF);
                isMultiPacket = true;
                packetLength = this.readRemainingMultiPackets(reuse, multiPacketSeq);
            }
            if (!isMultiPacket) {
                reuse.getByteBuffer()[packetLength] = 0;
            }
            if (this.maintainTimeStats.getValue().booleanValue()) {
                this.lastPacketReceivedTimeMs = System.currentTimeMillis();
            }
            return reuse;
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, ioEx, this.getExceptionInterceptor());
        }
        catch (Exception ex) {
            throw ExceptionFactory.createException(ex.getMessage(), ex, this.getExceptionInterceptor());
        }
        catch (OutOfMemoryError oom) {
            try {
                this.clearInputStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((JdbcConnection)this.connection).realClose(false, false, true, oom);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw oom;
        }
    }

    private int readRemainingMultiPackets(Buffer reuse, byte multiPacketSeq) throws IOException {
        int packetLength = -1;
        Buffer multiPacket = null;
        do {
            int lengthRead;
            if ((lengthRead = this.socketConnection.getMysqlInput().readFully(this.packetHeaderBuf, 0, 4)) < 4) {
                this.socketConnection.forceClose();
                throw new IOException(Messages.getString("MysqlIO.47"));
            }
            packetLength = (this.packetHeaderBuf[0] & 0xFF) + ((this.packetHeaderBuf[1] & 0xFF) << 8) + ((this.packetHeaderBuf[2] & 0xFF) << 16);
            if (multiPacket == null) {
                multiPacket = new Buffer(packetLength);
            }
            if ((multiPacketSeq = (byte)(multiPacketSeq + 1)) != this.packetHeaderBuf[3]) {
                throw new IOException(Messages.getString("MysqlIO.49"));
            }
            multiPacket.setPosition(0);
            multiPacket.setBufLength(packetLength);
            byte[] byteBuf = multiPacket.getByteBuffer();
            int lengthToWrite = packetLength;
            int bytesRead = this.socketConnection.getMysqlInput().readFully(byteBuf, 0, packetLength);
            if (bytesRead != lengthToWrite) {
                throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, ExceptionFactory.createException(Messages.getString("MysqlIO.50") + lengthToWrite + Messages.getString("MysqlIO.51") + bytesRead + ".", this.getExceptionInterceptor()), this.getExceptionInterceptor());
            }
            reuse.writeBytesNoNull(byteBuf, 0, lengthToWrite);
        } while (packetLength == 0xFFFFFF);
        reuse.setPosition(0);
        reuse.setWasMultiPacket(true);
        return packetLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResultSetInternalMethods sqlQueryDirect(StatementImpl callingStatement, String query, String characterEncoding, Buffer queryPacket, int maxRows, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, Field[] cachedMetadata) {
        ++this.statementExecutionDepth;
        try {
            ResultSetInternalMethods interceptedResults;
            ResultSetInternalMethods interceptedResults2;
            if (this.statementInterceptors != null && (interceptedResults2 = this.invokeStatementInterceptorsPre(query, callingStatement, false)) != null) {
                ResultSetInternalMethods resultSetInternalMethods = interceptedResults2;
                return resultSetInternalMethods;
            }
            long queryStartTime = 0L;
            long queryEndTime = 0L;
            String statementComment = ((JdbcConnection)this.connection).getStatementComment();
            if (this.propertySet.getBooleanReadableProperty("includeThreadNamesAsStatementComment").getValue().booleanValue()) {
                statementComment = (statementComment != null ? statementComment + ", " : "") + "java thread: " + Thread.currentThread().getName();
            }
            if (query != null) {
                int packLength = 1 + query.length() * 3 + 2;
                byte[] commentAsBytes = null;
                if (statementComment != null) {
                    commentAsBytes = StringUtils.getBytes(statementComment, characterEncoding);
                    packLength += commentAsBytes.length;
                    packLength += 6;
                }
                if (this.sendPacket == null) {
                    this.sendPacket = new Buffer(packLength);
                }
                this.sendPacket.setPosition(0);
                this.sendPacket.writeByte((byte)3);
                if (commentAsBytes != null) {
                    this.sendPacket.writeBytesNoNull(Constants.SLASH_STAR_SPACE_AS_BYTES);
                    this.sendPacket.writeBytesNoNull(commentAsBytes);
                    this.sendPacket.writeBytesNoNull(Constants.SPACE_STAR_SLASH_SPACE_AS_BYTES);
                }
                if (characterEncoding != null) {
                    if (this.platformDbCharsetMatches) {
                        this.sendPacket.writeStringNoNull(query, characterEncoding);
                    } else if (StringUtils.startsWithIgnoreCaseAndWs(query, "LOAD DATA")) {
                        this.sendPacket.writeBytesNoNull(StringUtils.getBytes(query));
                    } else {
                        this.sendPacket.writeStringNoNull(query, characterEncoding);
                    }
                } else {
                    this.sendPacket.writeStringNoNull(query);
                }
                queryPacket = this.sendPacket;
            }
            byte[] queryBuf = null;
            int oldPacketPosition = 0;
            if (this.needToGrabQueryFromPacket) {
                queryBuf = queryPacket.getByteBuffer();
                oldPacketPosition = queryPacket.getPosition();
                queryStartTime = this.getCurrentTimeNanosOrMillis();
            }
            if (this.autoGenerateTestcaseScript) {
                String testcaseQuery = null;
                testcaseQuery = query != null ? (statementComment != null ? "/* " + statementComment + " */ " + query : query) : StringUtils.toString(queryBuf, 1, oldPacketPosition - 1);
                StringBuilder debugBuf = new StringBuilder(testcaseQuery.length() + 32);
                ((JdbcConnection)this.connection).generateConnectionCommentBlock(debugBuf);
                debugBuf.append(testcaseQuery);
                debugBuf.append(';');
                TestUtils.dumpTestcaseQuery(debugBuf.toString());
            }
            Buffer resultPacket = this.sendCommand(3, null, queryPacket, false, null, 0);
            long fetchBeginTime = 0L;
            long fetchEndTime = 0L;
            String profileQueryToLog = null;
            boolean queryWasSlow = false;
            if (this.profileSQL || this.logSlowQueries) {
                queryEndTime = this.getCurrentTimeNanosOrMillis();
                boolean shouldExtractQuery = false;
                if (this.profileSQL) {
                    shouldExtractQuery = true;
                } else if (this.logSlowQueries) {
                    long queryTime = queryEndTime - queryStartTime;
                    boolean logSlow = false;
                    if (!this.useAutoSlowLog) {
                        logSlow = queryTime > (long)this.propertySet.getIntegerReadableProperty("slowQueryThresholdMillis").getValue().intValue();
                    } else {
                        logSlow = ((JdbcConnection)this.connection).isAbonormallyLongQuery(queryTime);
                        ((JdbcConnection)this.connection).reportQueryTime(queryTime);
                    }
                    if (logSlow) {
                        shouldExtractQuery = true;
                        queryWasSlow = true;
                    }
                }
                if (shouldExtractQuery) {
                    boolean truncated = false;
                    int extractPosition = oldPacketPosition;
                    if (oldPacketPosition > this.maxQuerySizeToLog.getValue()) {
                        extractPosition = this.maxQuerySizeToLog.getValue() + 1;
                        truncated = true;
                    }
                    profileQueryToLog = StringUtils.toString(queryBuf, 1, extractPosition - 1);
                    if (truncated) {
                        profileQueryToLog = profileQueryToLog + Messages.getString("MysqlIO.25");
                    }
                }
                fetchBeginTime = queryEndTime;
            }
            ResultSetInternalMethods rs = this.resultsHandler.readAllResults(callingStatement, maxRows, resultSetType, resultSetConcurrency, streamResults, catalog, resultPacket, false, -1L, cachedMetadata);
            if (queryWasSlow && !this.serverQueryWasSlow) {
                StringBuilder mesgBuf = new StringBuilder(48 + profileQueryToLog.length());
                mesgBuf.append(Messages.getString("MysqlIO.SlowQuery", new Object[]{String.valueOf(this.useAutoSlowLog ? " 95% of all queries " : Long.valueOf(this.slowQueryThreshold)), this.queryTimingUnits, queryEndTime - queryStartTime}));
                mesgBuf.append(profileQueryToLog);
                ProfilerEventHandler eventSink = ProfilerEventHandlerFactory.getInstance(this.connection);
                eventSink.consumeEvent(new ProfilerEventImpl(6, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), (int)(queryEndTime - queryStartTime), this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), mesgBuf.toString()));
                if (this.propertySet.getBooleanReadableProperty("explainSlowQueries").getValue().booleanValue()) {
                    if (oldPacketPosition < 0x100000) {
                        this.explainSlowQuery(queryPacket.getBytes(1, oldPacketPosition - 1), profileQueryToLog);
                    } else {
                        this.log.logWarn(Messages.getString("MysqlIO.28") + 0x100000 + Messages.getString("MysqlIO.29"));
                    }
                }
            }
            if (this.logSlowQueries) {
                ProfilerEventHandler eventSink = ProfilerEventHandlerFactory.getInstance(this.connection);
                if (this.queryBadIndexUsed && this.profileSQL) {
                    eventSink.consumeEvent(new ProfilerEventImpl(6, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), queryEndTime - queryStartTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), Messages.getString("MysqlIO.33") + profileQueryToLog));
                }
                if (this.queryNoIndexUsed && this.profileSQL) {
                    eventSink.consumeEvent(new ProfilerEventImpl(6, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), queryEndTime - queryStartTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), Messages.getString("MysqlIO.35") + profileQueryToLog));
                }
                if (this.serverQueryWasSlow && this.profileSQL) {
                    eventSink.consumeEvent(new ProfilerEventImpl(6, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), queryEndTime - queryStartTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), Messages.getString("MysqlIO.ServerSlowQuery") + profileQueryToLog));
                }
            }
            if (this.profileSQL) {
                fetchEndTime = this.getCurrentTimeNanosOrMillis();
                ProfilerEventHandler eventSink = ProfilerEventHandlerFactory.getInstance(this.connection);
                eventSink.consumeEvent(new ProfilerEventImpl(3, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), queryEndTime - queryStartTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), profileQueryToLog));
                eventSink.consumeEvent(new ProfilerEventImpl(5, "", catalog, this.connection.getId(), callingStatement != null ? callingStatement.getId() : 999, rs.resultId, System.currentTimeMillis(), fetchEndTime - fetchBeginTime, this.queryTimingUnits, null, LogUtils.findCallingClassAndMethod(new Throwable()), null));
            }
            if (this.hadWarnings) {
                this.resultsHandler.scanForAndThrowDataTruncation();
            }
            if (this.statementInterceptors != null && (interceptedResults = this.invokeStatementInterceptorsPost(query, callingStatement, rs, false, null)) != null) {
                rs = interceptedResults;
            }
            ResultSetImpl resultSetImpl = rs;
            return resultSetImpl;
        }
        catch (CJException | SQLException sqlEx) {
            if (this.statementInterceptors != null) {
                this.invokeStatementInterceptorsPost(query, callingStatement, null, false, sqlEx);
            }
            if (callingStatement != null) {
                Object object = callingStatement.cancelTimeoutMutex;
                synchronized (object) {
                    if (callingStatement.wasCancelled) {
                        CJException cause = null;
                        cause = callingStatement.wasCancelledByTimeout ? new CJTimeoutException() : new OperationCancelledException();
                        try {
                            callingStatement.resetCancelledState();
                        }
                        catch (SQLException e2) {
                            throw ExceptionFactory.createException(e2.getMessage(), e2);
                        }
                        throw cause;
                    }
                }
            }
            if (sqlEx instanceof CJException) {
                throw (CJException)sqlEx;
            }
            throw ExceptionFactory.createException(sqlEx.getMessage(), sqlEx);
        }
        finally {
            --this.statementExecutionDepth;
        }
    }

    public ResultSetInternalMethods invokeStatementInterceptorsPre(String sql, Statement interceptedStatement, boolean forceExecute) {
        ResultSetInternalMethods previousResultSet = null;
        int s2 = this.statementInterceptors.size();
        for (int i2 = 0; i2 < s2; ++i2) {
            boolean shouldExecute;
            StatementInterceptorV2 interceptor = this.statementInterceptors.get(i2);
            boolean executeTopLevelOnly = interceptor.executeTopLevelOnly();
            boolean bl = shouldExecute = executeTopLevelOnly && (this.statementExecutionDepth == 1 || forceExecute) || !executeTopLevelOnly;
            if (!shouldExecute) continue;
            String sqlToInterceptor = sql;
            try {
                ResultSetInternalMethods interceptedResultSet = interceptor.preProcess(sqlToInterceptor, interceptedStatement, (JdbcConnection)this.connection);
                if (interceptedResultSet == null) continue;
                previousResultSet = interceptedResultSet;
                continue;
            }
            catch (SQLException ex) {
                throw ExceptionFactory.createException(ex.getMessage(), ex);
            }
        }
        return previousResultSet;
    }

    public ResultSetInternalMethods invokeStatementInterceptorsPost(String sql, Statement interceptedStatement, ResultSetInternalMethods originalResultSet, boolean forceExecute, Exception statementException) {
        int s2 = this.statementInterceptors.size();
        for (int i2 = 0; i2 < s2; ++i2) {
            boolean shouldExecute;
            StatementInterceptorV2 interceptor = this.statementInterceptors.get(i2);
            boolean executeTopLevelOnly = interceptor.executeTopLevelOnly();
            boolean bl = shouldExecute = executeTopLevelOnly && (this.statementExecutionDepth == 1 || forceExecute) || !executeTopLevelOnly;
            if (!shouldExecute) continue;
            String sqlToInterceptor = sql;
            try {
                ResultSetInternalMethods interceptedResultSet = interceptor.postProcess(sqlToInterceptor, interceptedStatement, originalResultSet, (JdbcConnection)this.connection, this.getWarningCount(), this.queryNoIndexUsed, this.queryBadIndexUsed, statementException);
                if (interceptedResultSet == null) continue;
                originalResultSet = interceptedResultSet;
                continue;
            }
            catch (SQLException ex) {
                throw ExceptionFactory.createException(ex.getMessage(), ex);
            }
        }
        return originalResultSet;
    }

    public long getCurrentTimeNanosOrMillis() {
        if (this.useNanosForElapsedTime) {
            return TimeUtil.getCurrentTimeNanosOrMillis();
        }
        return System.currentTimeMillis();
    }

    public boolean hadWarnings() {
        return this.hadWarnings;
    }

    public void setHadWarnings(boolean hadWarnings) {
        this.hadWarnings = hadWarnings;
    }

    public void explainSlowQuery(byte[] querySQL, String truncatedQuery) {
        if (StringUtils.startsWithIgnoreCaseAndWs(truncatedQuery, EXPLAINABLE_STATEMENT) || StringUtils.startsWithIgnoreCaseAndWs(truncatedQuery, EXPLAINABLE_STATEMENT_EXTENSION) != -1) {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = (PreparedStatement)((JdbcConnection)this.connection).clientPrepareStatement("EXPLAIN ?");
                stmt.setBytesNoEscapeNoQuotes(1, querySQL);
                rs = stmt.executeQuery();
                StringBuilder explainResults = new StringBuilder(Messages.getString("MysqlIO.8") + truncatedQuery + Messages.getString("MysqlIO.9"));
                ResultSetUtil.appendResultSetSlashGStyle(explainResults, rs);
                this.log.logWarn(explainResults.toString());
            }
            catch (CJException | SQLException ex) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ex2) {
                    throw ExceptionFactory.createException(ex2.getMessage(), ex2);
                }
            }
            catch (Exception ex) {
                throw ExceptionFactory.createException(ex.getMessage(), ex, this.getExceptionInterceptor());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ex) {
                    throw ExceptionFactory.createException(ex.getMessage(), ex);
                }
            }
        }
    }

    public final void skipPacket() {
        try {
            int lengthRead = this.socketConnection.getMysqlInput().readFully(this.packetHeaderBuf, 0, 4);
            if (lengthRead < 4) {
                this.socketConnection.forceClose();
                throw new IOException(Messages.getString("MysqlIO.1"));
            }
            int packetLength = (this.packetHeaderBuf[0] & 0xFF) + ((this.packetHeaderBuf[1] & 0xFF) << 8) + ((this.packetHeaderBuf[2] & 0xFF) << 16);
            if (this.traceProtocol) {
                StringBuilder traceMessageBuf = new StringBuilder();
                traceMessageBuf.append(Messages.getString("MysqlIO.2"));
                traceMessageBuf.append(packetLength);
                traceMessageBuf.append(Messages.getString("MysqlIO.3"));
                traceMessageBuf.append(StringUtils.dumpAsHex(this.packetHeaderBuf, 4));
                this.log.logTrace(traceMessageBuf.toString());
            }
            byte multiPacketSeq = this.packetHeaderBuf[3];
            if (!this.packetSequenceReset) {
                if (this.enablePacketDebug && this.checkPacketSequence) {
                    this.checkPacketSequencing(multiPacketSeq);
                }
            } else {
                this.packetSequenceReset = false;
            }
            this.readPacketSequence = multiPacketSeq;
            this.socketConnection.getMysqlInput().skipFully(packetLength);
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, ioEx, this.getExceptionInterceptor());
        }
        catch (CJException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ExceptionFactory.createException(ex.getMessage(), ex, this.getExceptionInterceptor());
        }
        catch (OutOfMemoryError oom) {
            try {
                ((JdbcConnection)this.connection).realClose(false, false, true, oom);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw oom;
        }
    }

    public final void quit() {
        try {
            try {
                if (!this.socketConnection.getMysqlSocket().isClosed()) {
                    try {
                        this.socketConnection.getMysqlSocket().shutdownInput();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                }
            }
            catch (IOException ioEx) {
                this.log.logWarn("Caught while disconnecting...", ioEx);
            }
            Buffer packet = new Buffer(6);
            packet.setPosition(0);
            this.packetSequence = (byte)-1;
            packet.writeByte((byte)1);
            this.send(packet, packet.getPosition());
        }
        finally {
            this.socketConnection.forceClose();
        }
    }

    public Buffer getSharedSendPacket() {
        if (this.sharedSendPacket == null) {
            this.sharedSendPacket = new Buffer(1024);
        }
        this.sharedSendPacket.setPosition(0);
        return this.sharedSendPacket;
    }

    private void calculateSlowQueryThreshold() {
        this.slowQueryThreshold = this.propertySet.getIntegerReadableProperty("slowQueryThresholdMillis").getValue().intValue();
        if (this.propertySet.getBooleanReadableProperty("useNanosForElapsedTime").getValue().booleanValue()) {
            long nanosThreshold = this.propertySet.getLongReadableProperty("slowQueryThresholdNanos").getValue();
            this.slowQueryThreshold = nanosThreshold != 0L ? nanosThreshold : (this.slowQueryThreshold *= 1000000L);
        }
    }

    @Override
    public void changeUser(String user, String password, String database) {
        this.packetSequence = (byte)-1;
        this.authProvider.changeUser(this.serverSession, user, password, database);
    }

    public void checkForCharsetMismatch() {
        String characterEncoding = this.propertySet.getStringReadableProperty("characterEncoding").getValue();
        if (characterEncoding != null) {
            String encodingToCheck = jvmPlatformCharset;
            if (encodingToCheck == null) {
                encodingToCheck = Constants.PLATFORM_ENCODING;
            }
            this.platformDbCharsetMatches = encodingToCheck == null ? false : encodingToCheck.equals(characterEncoding);
        }
    }

    public void setServerSlowQueryFlags() {
        MysqlaServerSession state = this.serverSession;
        this.queryBadIndexUsed = state.noGoodIndexUsed();
        this.queryNoIndexUsed = state.noIndexUsed();
        this.serverQueryWasSlow = state.queryWasSlow();
    }

    protected boolean useNanosForElapsedTime() {
        return this.useNanosForElapsedTime;
    }

    public long getSlowQueryThreshold() {
        return this.slowQueryThreshold;
    }

    public String getQueryTimingUnits() {
        return this.queryTimingUnits;
    }

    public int getCommandCount() {
        return this.commandCount;
    }

    protected void decoratePacketSender() {
        TimeTrackingPacketSender ttSender = new TimeTrackingPacketSender(this.packetSender);
        this.setPacketSentTimeHolder(ttSender);
        this.packetSender = ttSender;
        if (this.traceProtocol) {
            this.packetSender = new TracingPacketSender(this.packetSender, this.log, this.socketConnection.getHost(), this.getServerSession().getCapabilities().getThreadId());
        }
        if (this.enablePacketDebug) {
            this.packetSender = new DebugBufferingPacketSender(this.packetSender, this.packetDebugRingBuffer);
        }
    }

    public void setStatementInterceptors(List<StatementInterceptorV2> statementInterceptors) {
        this.statementInterceptors = statementInterceptors.isEmpty() ? null : statementInterceptors;
    }

    public List<StatementInterceptorV2> getStatementInterceptors() {
        return this.statementInterceptors;
    }

    public void setSocketTimeout(int milliseconds) {
        try {
            this.socketConnection.getMysqlSocket().setSoTimeout(milliseconds);
        }
        catch (SocketException e2) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("MysqlIO.112"), e2, this.getExceptionInterceptor());
        }
    }

    public void releaseResources() {
        if (this.compressedPacketSender != null) {
            this.compressedPacketSender.stop();
        }
    }

    @Override
    public void connect(String user, String password, String database) {
        this.beforeHandshake();
        this.authProvider.connect(this.serverSession, user, password, database);
    }

    @Override
    public JdbcConnection getConnection() {
        return (JdbcConnection)this.connection;
    }

    public void setConnection(JdbcConnection connection) {
        this.connection = connection;
    }

    protected boolean isDataAvailable() {
        try {
            return this.socketConnection.getMysqlInput().available() > 0;
        }
        catch (IOException ioEx) {
            throw ExceptionFactory.createCommunicationsException(this.propertySet, this.serverSession, this.getPacketSentTimeHolder().getLastPacketSentTime(), this.lastPacketReceivedTimeMs, ioEx, this.getExceptionInterceptor());
        }
    }

    @Override
    public MysqlIO getResultsHandler() {
        return this.resultsHandler;
    }

    public Buffer getReusablePacket() {
        return this.reusablePacket;
    }

    public void setReusablePacket(Buffer packet) {
        this.reusablePacket = packet;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void setWarningCount(int warningCount) {
        this.warningCount = warningCount;
    }

    public byte[] getPacketHeaderBuf() {
        return this.packetHeaderBuf;
    }

    public void dumpPacketRingBuffer() {
        if (this.packetDebugRingBuffer != null && this.getPropertySet().getBooleanReadableProperty("enablePacketDebug").getValue().booleanValue()) {
            StringBuilder dumpBuffer = new StringBuilder();
            dumpBuffer.append("Last " + this.packetDebugRingBuffer.size() + " packets received from server, from oldest->newest:\n");
            dumpBuffer.append("\n");
            Iterator ringBufIter = this.packetDebugRingBuffer.iterator();
            while (ringBufIter.hasNext()) {
                dumpBuffer.append((CharSequence)ringBufIter.next());
                dumpBuffer.append("\n");
            }
            this.log.logTrace(dumpBuffer.toString());
        }
    }

    public void incrementPacketSequence() {
        this.packetSequence = (byte)(this.packetSequence + 1);
    }

    public boolean doesPlatformDbCharsetMatches() {
        return this.platformDbCharsetMatches;
    }

    @Override
    public String getPasswordCharacterEncoding() {
        String encoding = this.propertySet.getStringReadableProperty("passwordCharacterEncoding").getStringValue();
        if (encoding != null) {
            return encoding;
        }
        encoding = this.propertySet.getStringReadableProperty("characterEncoding").getValue();
        if (encoding != null) {
            return encoding;
        }
        return "UTF-8";
    }

    @Override
    public boolean versionMeetsMinimum(int major, int minor, int subminor) {
        return this.serverSession.getServerVersion().meetsMinimum(new ServerVersion(major, minor, subminor));
    }

    public static MysqlType findMysqlType(PropertySet propertySet, int mysqlTypeId, short colFlag, long length, LazyString tableName, LazyString originalTableName, int collationIndex, String encoding) {
        boolean isImplicitTemporaryTable;
        boolean isUnsigned = (colFlag & 0x20) > 0;
        boolean isFromFunction = originalTableName.length() == 0;
        boolean isBinary = (colFlag & 0x80) > 0;
        boolean bl = isImplicitTemporaryTable = tableName.length() > 0 && tableName.toString().startsWith("#sql_");
        boolean isOpaqueBinary = isBinary && collationIndex == 63 && (mysqlTypeId == 254 || mysqlTypeId == 253 || mysqlTypeId == 15) ? !isImplicitTemporaryTable : "binary".equalsIgnoreCase(encoding);
        switch (mysqlTypeId) {
            case 0: 
            case 246: {
                return isUnsigned ? MysqlType.DECIMAL_UNSIGNED : MysqlType.DECIMAL;
            }
            case 1: {
                if (length == 1L) {
                    if (propertySet.getBooleanReadableProperty("transformedBitIsBoolean").getValue().booleanValue()) {
                        return MysqlType.BOOLEAN;
                    }
                    if (propertySet.getBooleanReadableProperty("tinyInt1isBit").getValue().booleanValue()) {
                        return MysqlType.BIT;
                    }
                }
                return isUnsigned ? MysqlType.TINYINT_UNSIGNED : MysqlType.TINYINT;
            }
            case 2: {
                return isUnsigned ? MysqlType.SMALLINT_UNSIGNED : MysqlType.SMALLINT;
            }
            case 3: {
                return isUnsigned ? MysqlType.INT_UNSIGNED : MysqlType.INT;
            }
            case 4: {
                return isUnsigned ? MysqlType.FLOAT_UNSIGNED : MysqlType.FLOAT;
            }
            case 5: {
                return isUnsigned ? MysqlType.DOUBLE_UNSIGNED : MysqlType.DOUBLE;
            }
            case 6: {
                return MysqlType.NULL;
            }
            case 7: {
                return MysqlType.TIMESTAMP;
            }
            case 8: {
                return isUnsigned ? MysqlType.BIGINT_UNSIGNED : MysqlType.BIGINT;
            }
            case 9: {
                return isUnsigned ? MysqlType.MEDIUMINT_UNSIGNED : MysqlType.MEDIUMINT;
            }
            case 10: {
                return MysqlType.DATE;
            }
            case 11: {
                return MysqlType.TIME;
            }
            case 12: {
                return MysqlType.DATETIME;
            }
            case 13: {
                return MysqlType.YEAR;
            }
            case 15: 
            case 253: {
                if (!(!isOpaqueBinary || isFromFunction && propertySet.getBooleanReadableProperty("functionsNeverReturnBlobs").getValue().booleanValue())) {
                    return MysqlType.VARBINARY;
                }
                return MysqlType.VARCHAR;
            }
            case 16: {
                return MysqlType.BIT;
            }
            case 245: {
                return MysqlType.JSON;
            }
            case 247: {
                return MysqlType.ENUM;
            }
            case 248: {
                return MysqlType.SET;
            }
            case 249: {
                if (!isBinary || collationIndex != 63 || propertySet.getBooleanReadableProperty("blobsAreStrings").getValue().booleanValue() || isFromFunction && propertySet.getBooleanReadableProperty("functionsNeverReturnBlobs").getValue().booleanValue()) {
                    return MysqlType.TINYTEXT;
                }
                return MysqlType.TINYBLOB;
            }
            case 250: {
                if (!isBinary || collationIndex != 63 || propertySet.getBooleanReadableProperty("blobsAreStrings").getValue().booleanValue() || isFromFunction && propertySet.getBooleanReadableProperty("functionsNeverReturnBlobs").getValue().booleanValue()) {
                    return MysqlType.MEDIUMTEXT;
                }
                return MysqlType.MEDIUMBLOB;
            }
            case 251: {
                if (!isBinary || collationIndex != 63 || propertySet.getBooleanReadableProperty("blobsAreStrings").getValue().booleanValue() || isFromFunction && propertySet.getBooleanReadableProperty("functionsNeverReturnBlobs").getValue().booleanValue()) {
                    return MysqlType.LONGTEXT;
                }
                return MysqlType.LONGBLOB;
            }
            case 252: {
                int newMysqlTypeId = mysqlTypeId;
                if (length <= MysqlType.TINYBLOB.getPrecision()) {
                    newMysqlTypeId = 249;
                } else {
                    if (length <= MysqlType.BLOB.getPrecision()) {
                        if (!isBinary || collationIndex != 63 || propertySet.getBooleanReadableProperty("blobsAreStrings").getValue().booleanValue() || isFromFunction && propertySet.getBooleanReadableProperty("functionsNeverReturnBlobs").getValue().booleanValue()) {
                            newMysqlTypeId = 15;
                            return MysqlType.TEXT;
                        }
                        return MysqlType.BLOB;
                    }
                    newMysqlTypeId = length <= MysqlType.MEDIUMBLOB.getPrecision() ? 250 : 251;
                }
                return MysqlaProtocol.findMysqlType(propertySet, newMysqlTypeId, colFlag, length, tableName, originalTableName, collationIndex, encoding);
            }
            case 254: {
                if (isOpaqueBinary && !propertySet.getBooleanReadableProperty("blobsAreStrings").getValue().booleanValue()) {
                    return MysqlType.BINARY;
                }
                return MysqlType.CHAR;
            }
            case 255: {
                return MysqlType.GEOMETRY;
            }
        }
        return MysqlType.UNKNOWN;
    }

    static {
        OutputStreamWriter outWriter = null;
        try {
            outWriter = new OutputStreamWriter(new ByteArrayOutputStream());
            jvmPlatformCharset = outWriter.getEncoding();
        }
        finally {
            try {
                if (outWriter != null) {
                    outWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

