/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.io.ValueDecoder;
import com.mysql.cj.api.io.ValueFactory;
import com.mysql.cj.core.io.MysqlTextValueDecoder;
import com.mysql.cj.jdbc.ResultSetRow;
import java.sql.SQLException;

public class ByteArrayRow
extends ResultSetRow {
    byte[][] internalRowData;

    public ByteArrayRow(byte[][] internalRowData, ExceptionInterceptor exceptionInterceptor, ValueDecoder valueDecoder) {
        super(exceptionInterceptor);
        this.internalRowData = internalRowData;
        this.valueDecoder = valueDecoder;
    }

    public ByteArrayRow(byte[][] internalRowData, ExceptionInterceptor exceptionInterceptor) {
        super(exceptionInterceptor);
        this.internalRowData = internalRowData;
        this.valueDecoder = new MysqlTextValueDecoder();
    }

    @Override
    public byte[] getColumnValue(int index) throws SQLException {
        if (this.getNull(index)) {
            return null;
        }
        return this.internalRowData[index];
    }

    @Override
    public void setColumnValue(int index, byte[] value) throws SQLException {
        this.internalRowData[index] = value;
    }

    @Override
    public boolean isNull(int index) throws SQLException {
        return this.internalRowData[index] == null;
    }

    @Override
    public long length(int index) throws SQLException {
        if (this.internalRowData[index] == null) {
            return 0L;
        }
        return this.internalRowData[index].length;
    }

    @Override
    public <T> T getValue(int columnIndex, ValueFactory<T> vf) throws SQLException {
        byte[] columnData = this.internalRowData[columnIndex];
        int length = columnData == null ? 0 : columnData.length;
        return this.getValueFromBytes(columnIndex, columnData, 0, length, vf);
    }
}

