/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.core;

import org.linphone.core.CallDirection;
import org.linphone.core.LinphoneAddress;
import org.linphone.core.LinphoneCall;
import org.linphone.core.LinphoneCallLog;
import org.linphone.core.LinphoneCallParams;
import org.linphone.core.LinphoneCoreFactory;
import org.linphone.jlinphone.core.LinphoneCallLogImpl;
import org.linphone.jlinphone.core.LinphoneCoreImpl;
import org.linphone.jlinphone.media.AudioStream;
import org.linphone.jlinphone.media.AudioStreamParameters;
import org.linphone.jlinphone.media.jsr135.AudioStreamImpl;
import org.linphone.jortp.JOrtpFactory;
import org.linphone.jortp.Logger;
import org.linphone.jortp.PayloadType;
import org.linphone.jortp.RtpException;
import org.linphone.jortp.RtpProfile;
import org.linphone.jortp.SocketAddress;
import org.linphone.sal.Sal;
import org.linphone.sal.SalException;
import org.linphone.sal.SalFactory;
import org.linphone.sal.SalMediaDescription;
import org.linphone.sal.SalOp;
import org.linphone.sal.SalStreamDescription;

class LinphoneCallImpl
implements LinphoneCall {
    private CallDirection mDir;
    private LinphoneCall.State mState = LinphoneCall.State.Idle;
    private SalOp mOp;
    private SalMediaDescription mLocalDesc;
    private SalMediaDescription mFinal;
    private AudioStreamImpl mAudioStream;
    private LinphoneCallLogImpl mCallLog;
    private final LinphoneCoreImpl mCore;
    private static final Logger mLog = JOrtpFactory.instance().createLogger("LinphoneCore");

    protected LinphoneCallImpl(LinphoneCoreImpl aCore, SalOp op, CallDirection dir) throws SalException {
        this.mOp = op;
        this.mDir = dir;
        this.mOp.setUserContext(this);
        this.mLocalDesc = this.makeLocalDesc();
        this.mCore = aCore;
        this.mCallLog = new LinphoneCallLogImpl(dir, op.getFrom(), op.getTo());
        op.callSetLocalMediaDescription(this.getLocalMediaDescription());
        this.initMediaStreams();
    }

    public LinphoneAddress getRemoteAddress() {
        if (this.mOp != null) {
            if (this.mDir == CallDirection.Incoming) {
                return LinphoneCoreFactory.instance().createLinphoneAddress(this.mOp.getFrom());
            }
            return LinphoneCoreFactory.instance().createLinphoneAddress(this.mOp.getTo());
        }
        return null;
    }

    public SalMediaDescription getLocalMediaDescription() {
        return this.mLocalDesc;
    }

    public SalMediaDescription getFinalMediaDescription() {
        return this.mFinal;
    }

    public void setFinalMediaDescription(SalMediaDescription aDescription) {
        this.mFinal = aDescription;
    }

    public void setState(LinphoneCall.State aState) {
        this.setState(aState, null);
    }

    public void setState(LinphoneCall.State aState, String message) {
        this.mState = aState;
        String displayStatus = null;
        if (aState == LinphoneCall.State.Connected) {
            displayStatus = "Connected to " + this.getRemoteAddress().getUserName() != null ? this.getRemoteAddress().getUserName() : this.getRemoteAddress().toString();
            this.mCallLog.setCallStatus(LinphoneCallLog.CallStatus.Sucess);
        } else if (aState == LinphoneCall.State.IncomingReceived) {
            displayStatus = this.getRemoteAddress().getUserName() != null ? this.getRemoteAddress().getUserName() : String.valueOf(this.getRemoteAddress().toString()) + " is calling you";
            this.mCallLog.setCallStatus(LinphoneCallLog.CallStatus.Missed);
        } else if (aState == LinphoneCall.State.OutgoingRinging) {
            displayStatus = "Remote ringing...";
            this.mCallLog.setCallStatus(LinphoneCallLog.CallStatus.Declined);
        } else if (aState == LinphoneCall.State.OutgoingEarlyMedia) {
            displayStatus = "Early media...";
            this.mCallLog.setCallStatus(LinphoneCallLog.CallStatus.Declined);
        } else if (aState == LinphoneCall.State.CallEnd) {
            displayStatus = "Call terminated";
        } else if (aState == LinphoneCall.State.Error) {
            displayStatus = "Call failure [" + message + "]";
        } else if (aState == LinphoneCall.State.OutgoingInit) {
            displayStatus = "Calling  " + (this.getRemoteAddress().getUserName() != null ? this.getRemoteAddress().getUserName() : this.getRemoteAddress().toString());
        }
        if (displayStatus != null) {
            this.mCore.getListener().displayStatus(this.mCore, displayStatus);
        }
        this.mCore.getListener().callState(this.mCore, this, this.mState, message);
    }

    public LinphoneCallLog getCallLog() {
        return this.mCallLog;
    }

    public CallDirection getDirection() {
        return this.mDir;
    }

    public LinphoneCall.State getState() {
        return this.mState;
    }

    private SalMediaDescription makeLocalDesc() throws SalException {
        SalMediaDescription md = SalFactory.instance().createSalMediaDescription();
        SalStreamDescription sd = new SalStreamDescription();
        PayloadType[] pts = new PayloadType[1];
        sd.setAddress(this.getSal().getLocalAddr());
        sd.setPort(7078);
        sd.setProto(SalStreamDescription.Proto.RtpAvp);
        sd.setType(SalStreamDescription.Type.Audio);
        PayloadType amr = JOrtpFactory.instance().createPayloadType();
        amr.setClockRate(8000);
        amr.setMimeType("AMR");
        amr.appendRecvFmtp("octet-align=1");
        amr.setNumChannels(1);
        amr.setType(PayloadType.MediaType.Audio);
        amr.setNumber(114);
        pts[0] = amr;
        sd.setPayloadTypes(pts);
        md.addStreamDescription(sd);
        md.setAddress(this.getSal().getLocalAddr());
        return md;
    }

    public void initMediaStreams() throws SalException {
        this.mAudioStream = new AudioStreamImpl();
        try {
            String host = "0.0.0.0";
            int port = this.getLocalMediaDescription().getStream(0).getPort();
            SocketAddress addr = JOrtpFactory.instance().createSocketAddress(host, port);
            if (this.mCore.mRtpTransport != null) {
                this.mAudioStream.setRtpTransport(this.mCore.mRtpTransport);
            }
            this.mAudioStream.init(addr);
        }
        catch (RtpException e) {
            this.mAudioStream.stop();
            throw new SalException("Cannot init media stream", e);
        }
    }

    public void startMediaStreams() {
        if (this.mAudioStream != null) {
            try {
                this.mAudioStream.start(this.makeAudioStreamParams());
            }
            catch (RtpException e) {
                mLog.error("Cannot start stream", e);
            }
        }
    }

    private RtpProfile makeProfile(SalStreamDescription sd) {
        RtpProfile prof = JOrtpFactory.instance().createRtpProfile();
        PayloadType[] pts = sd.getPayloadTypes();
        int i = 0;
        while (i < pts.length) {
            prof.setPayloadType(pts[i], pts[i].getNumber());
            ++i;
        }
        return prof;
    }

    private AudioStreamParameters makeAudioStreamParams() {
        AudioStreamParameters p = null;
        SalStreamDescription sd = this.getFinalMediaDescription().getStream(0);
        if (sd != null) {
            SocketAddress dest = JOrtpFactory.instance().createSocketAddress(sd.getAddress(), sd.getPort());
            p = new AudioStreamParameters();
            p.setRtpProfile(this.makeProfile(sd));
            p.setRemoteDest(dest);
            p.setActivePayloadTypeNumber(sd.getPayloadTypes()[0].getNumber());
        }
        return p;
    }

    public void terminateMediaStreams() {
        if (this.mAudioStream != null) {
            this.mAudioStream.stop();
            this.mAudioStream = null;
        }
    }

    public AudioStream getAudioStream() {
        return this.mAudioStream;
    }

    public SalOp getOp() {
        return this.mOp;
    }

    private Sal getSal() {
        return this.mOp.getSal();
    }

    private void setCallLog(LinphoneCallLogImpl aCallLog) {
        this.mCallLog = aCallLog;
    }

    public void sendDtmf(char number) {
        this.mOp.sendDtmf(number);
    }

    public LinphoneCallParams getCurrentParamsReadOnly() {
        throw new RuntimeException("Not implemented yet");
    }

    public void enableCamera(boolean enabled) {
        throw new RuntimeException("Not implemented yet");
    }

    public void enableEchoCancellation(boolean enable) {
        throw new RuntimeException("Not implemented yet");
    }

    public void enableEchoLimiter(boolean enable) {
        throw new RuntimeException("Not implemented yet");
    }

    public LinphoneCallParams getCurrentParamsCopy() {
        throw new RuntimeException("Not implemented yet");
    }

    public LinphoneCall getReplacedCall() {
        throw new RuntimeException("Not implemented yet");
    }

    public boolean isEchoCancellationEnabled() {
        throw new RuntimeException("Not implemented yet");
    }

    public boolean isEchoLimiterEnabled() {
        throw new RuntimeException("Not implemented yet");
    }
}

