/*
 * Decompiled with CFR 0.152.
 */
package org.linphone.jlinphone.gui;

import javax.microedition.pim.Contact;
import javax.microedition.pim.PIMException;
import net.rim.device.api.collection.ReadableList;
import net.rim.device.api.system.Display;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.component.KeywordFilterField;
import net.rim.device.api.ui.component.KeywordProvider;
import net.rim.device.api.ui.component.ListField;
import net.rim.device.api.ui.component.ListFieldCallback;
import org.linphone.jlinphone.gui.ContactListSource;

public class SearchableContactList
implements ListFieldCallback {
    final Listener mListener;
    ContactListSource mContactList;
    KeywordFilterField mKeywordFilterField = new KeywordFilterField(){

        protected boolean keyChar(char key, int status, int time) {
            if (key != '\n') {
                return super.keyChar(key, status, time);
            }
            return this.navigationClick(0, 0);
        }

        protected boolean navigationClick(int status, int time) {
            if (SearchableContactList.this.mListener != null) {
                SearchableContactList.this.mListener.onSelected((Contact)this.getCallback().get((ListField)this, this.getSelectedIndex()));
            }
            return true;
        }
    };

    public SearchableContactList(Listener aListener) throws PIMException {
        this.mListener = aListener;
        this.mContactList = new ContactListSource();
        this.mKeywordFilterField.setSourceList((ReadableList)this.mContactList, (KeywordProvider)this.mContactList);
        this.mKeywordFilterField.setCallback((ListFieldCallback)this);
    }

    public SearchableContactList() throws PIMException {
        this(null);
    }

    public KeywordFilterField getKeywordFilterField() {
        return this.mKeywordFilterField;
    }

    public void drawListRow(ListField listField, Graphics graphics, int index, int y, int width) {
        if (listField.getSelectedIndex() != index) {
            graphics.setBackgroundColor(index % 2 == 0 ? 0xD3D3D3 : 0xA9A9A9);
            graphics.clear();
        }
        Contact lContact = (Contact)this.get(listField, index);
        String[] lContactNames = lContact.getStringArray(106, 0);
        int lCurrentX = 0;
        graphics.setFont(Font.getDefault().derive(1));
        if (lContactNames[1] != null) {
            graphics.drawText(lContactNames[1], 0, y, 0);
            lCurrentX = graphics.getFont().getAdvance(lContactNames[1]);
        }
        if (lCurrentX > 0) {
            graphics.setFont(Font.getDefault());
        }
        if (lContactNames[0] != null) {
            graphics.drawText(lContactNames[0], lCurrentX + graphics.getFont().getAdvance(" "), y, 0);
            lCurrentX += graphics.getFont().getAdvance(" ") + graphics.getFont().getAdvance(lContactNames[0]);
        }
        if (lContact.countValues(115) > 0) {
            graphics.setFont(Font.getDefault().derive(2, Font.getDefault().getHeight() - 2));
            String lType = "[" + this.mContactList.getContactList().getAttributeLabel(lContact.getAttributes(115, 0)) + "]";
            graphics.drawText(lType, lCurrentX + graphics.getFont().getAdvance(" "), y, 0);
            String lContactTel = lContact.getString(115, 0);
            graphics.drawText(lContactTel, (lCurrentX += graphics.getFont().getAdvance(" ") + graphics.getFont().getAdvance(lType)) + graphics.getFont().getAdvance(" "), y, 0);
        }
    }

    public Object get(ListField listField, int index) {
        return ((KeywordFilterField)listField).getResultList().getAt(index);
    }

    public int getPreferredWidth(ListField listField) {
        return Display.getWidth();
    }

    public int indexOfList(ListField listField, String prefix, int start) {
        return -1;
    }

    static interface Listener {
        public void onSelected(Contact var1);
    }
}

