/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.core;

import sip4me.gov.nist.core.Host;
import sip4me.gov.nist.core.HostPort;
import sip4me.gov.nist.core.LexerCore;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.ParserCore;
import sip4me.gov.nist.core.StringTokenizer;

public class HostNameParser
extends ParserCore {
    public HostNameParser(LexerCore lexer) {
        this.lexer = lexer;
        lexer.selectLexer("charLexer");
    }

    protected String domainLabel() throws ParseException {
        StringBuffer retval = new StringBuffer();
        if (ParserCore.debug) {
            this.dbg_enter("domainLabel");
        }
        try {
            while (this.lexer.hasMoreChars()) {
                char la = this.lexer.lookAhead(0);
                if (StringTokenizer.isAlpha(la)) {
                    this.lexer.consume(1);
                    retval.append(la);
                    continue;
                }
                if (StringTokenizer.isDigit(la)) {
                    this.lexer.consume(1);
                    retval.append(la);
                    continue;
                }
                if (la != '-') break;
                this.lexer.consume(1);
                retval.append(la);
            }
            String string = retval.toString();
            return string;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("domainLabel");
            }
        }
    }

    protected String ipv6Reference() throws ParseException {
        StringBuffer retval = new StringBuffer();
        if (ParserCore.debug) {
            this.dbg_enter("domainLabel");
        }
        try {
            while (this.lexer.hasMoreChars()) {
                char la = this.lexer.lookAhead(0);
                if (StringTokenizer.isHexDigit(la)) {
                    this.lexer.consume(1);
                    retval.append(la);
                    continue;
                }
                if (la == '.' || la == ':' || la == '[') {
                    this.lexer.consume(1);
                    retval.append(la);
                    continue;
                }
                if (la != ']') break;
                this.lexer.consume(1);
                retval.append(la);
                String string = retval.toString();
                return string;
            }
            throw new ParseException(String.valueOf(this.lexer.getBuffer()) + ": Illegal Host name ", this.lexer.getPtr());
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("domainLabel");
            }
        }
    }

    public Host host() throws ParseException {
        if (ParserCore.debug) {
            this.dbg_enter("host");
        }
        try {
            StringBuffer hname = new StringBuffer();
            if (this.lexer.lookAhead(0) == '[') {
                hname.append(this.ipv6Reference());
            } else {
                String nextTok = this.domainLabel();
                hname.append(nextTok);
                while (this.lexer.hasMoreChars()) {
                    if (this.lexer.lookAhead(0) != '.') break;
                    this.lexer.consume(1);
                    nextTok = this.domainLabel();
                    hname.append(".");
                    hname.append(nextTok);
                }
            }
            String hostname = hname.toString();
            if (hostname.equals("")) {
                throw new ParseException(String.valueOf(this.lexer.getBuffer()) + ": Illegal Host name ", this.lexer.getPtr());
            }
            Host host = new Host(hostname);
            return host;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("host");
            }
        }
    }

    public HostPort hostPort() throws ParseException {
        if (ParserCore.debug) {
            this.dbg_enter("hostPort");
        }
        try {
            Host host = this.host();
            HostPort hp = new HostPort();
            hp.setHost(host);
            if (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == ':') {
                this.lexer.consume(1);
                try {
                    String port = this.lexer.number();
                    hp.setPort(Integer.parseInt(port));
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException(String.valueOf(this.lexer.getBuffer()) + " :Error parsing port ", this.lexer.getPtr());
                }
            }
            HostPort hostPort = hp;
            return hostPort;
        }
        finally {
            if (ParserCore.debug) {
                this.dbg_leave("hostPort");
            }
        }
    }
}

