/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.core;

import sip4me.gov.nist.core.Host;

public final class HostPort {
    protected Host host = null;
    protected Integer port = null;

    public String encode() {
        StringBuffer retval = new StringBuffer();
        retval.append(this.host.encode());
        if (this.port != null) {
            retval.append(':').append(this.port.toString());
        }
        return retval.toString();
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        HostPort that = (HostPort)other;
        if (this.port == null && that.port != null || this.port != null && that.port == null) {
            return false;
        }
        if (this.port == that.port && this.host.equals(that.host)) {
            return true;
        }
        return this.host.equals(that.host) && this.port.equals(that.port);
    }

    public Host getHost() {
        return this.host;
    }

    public int getPort() {
        if (this.port == null) {
            return -1;
        }
        return this.port;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public void removePort() {
        this.port = null;
    }

    public void setHost(Host h) {
        this.host = h;
    }

    public void setPort(int p) {
        this.port = new Integer(p);
    }

    public Object clone() {
        HostPort retval = new HostPort();
        if (this.host != null) {
            retval.host = (Host)this.host.clone();
        }
        if (this.port != null) {
            retval.port = new Integer(this.port);
        }
        return retval;
    }
}

