/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.javax.sdp.fields;

import java.util.Vector;
import sip4me.gov.nist.javax.sdp.SdpException;
import sip4me.gov.nist.javax.sdp.SdpParseException;
import sip4me.gov.nist.javax.sdp.fields.SDPField;
import sip4me.gov.nist.javax.sdp.fields.SDPObjectList;
import sip4me.gov.nist.javax.sdp.fields.TypedTime;

public class RepeatField
extends SDPField {
    protected TypedTime repeatInterval;
    protected TypedTime activeDuration;
    protected SDPObjectList offsets = new SDPObjectList();

    public Object clone() {
        RepeatField retval = new RepeatField();
        if (this.repeatInterval != null) {
            retval.repeatInterval = (TypedTime)this.repeatInterval.clone();
        }
        if (this.activeDuration != null) {
            retval.activeDuration = (TypedTime)this.activeDuration.clone();
        }
        retval.offsets = (SDPObjectList)this.offsets.clone();
        return retval;
    }

    public RepeatField() {
        super("r=");
    }

    public void setRepeatInterval(TypedTime interval) {
        this.repeatInterval = interval;
    }

    public void setActiveDuration(TypedTime duration) {
        this.activeDuration = duration;
    }

    public void addOffset(TypedTime offset) {
        this.offsets.addElement(offset);
    }

    public Vector getOffsets() {
        return this.offsets;
    }

    public int getRepeatInterval() throws SdpParseException {
        if (this.repeatInterval == null) {
            return -1;
        }
        return this.repeatInterval.getTime();
    }

    public void setRepeatInterval(int repeatInterval) throws SdpException {
        if (repeatInterval < 0) {
            throw new SdpException("The repeat interval is <0");
        }
        if (this.repeatInterval == null) {
            this.repeatInterval = new TypedTime();
        }
        this.repeatInterval.setTime(repeatInterval);
    }

    public int getActiveDuration() throws SdpParseException {
        if (this.activeDuration == null) {
            return -1;
        }
        return this.activeDuration.getTime();
    }

    public void setActiveDuration(int activeDuration) throws SdpException {
        if (activeDuration < 0) {
            throw new SdpException("The active Duration is <0");
        }
        if (this.activeDuration == null) {
            this.activeDuration = new TypedTime();
        }
        this.activeDuration.setTime(activeDuration);
    }

    public int[] getOffsetArray() throws SdpParseException {
        int[] result = new int[this.offsets.size()];
        int i = 0;
        while (i < this.offsets.size()) {
            TypedTime typedTime = (TypedTime)this.offsets.elementAt(i);
            result[i] = typedTime.getTime();
            ++i;
        }
        return result;
    }

    public void setOffsetArray(int[] offsets) throws SdpException {
        int i = 0;
        while (i < offsets.length) {
            TypedTime typedTime = new TypedTime();
            typedTime.setTime(offsets[i]);
            this.addOffset(typedTime);
            ++i;
        }
    }

    public boolean getTypedTime() throws SdpParseException {
        return true;
    }

    public void setTypedTime(boolean typedTime) {
    }

    public String encode() {
        String retval = "r=" + this.repeatInterval.encode() + " " + this.activeDuration.encode();
        int i = 0;
        while (i < this.offsets.size()) {
            TypedTime off = (TypedTime)this.offsets.elementAt(i);
            retval = String.valueOf(retval) + " " + off.encode();
            ++i;
        }
        retval = String.valueOf(retval) + "\r\n";
        return retval;
    }
}

