/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.javax.sdp.parser;

import sip4me.gov.nist.core.Host;
import sip4me.gov.nist.core.HostNameParser;
import sip4me.gov.nist.core.ParseException;
import sip4me.gov.nist.core.Token;
import sip4me.gov.nist.javax.sdp.fields.OriginField;
import sip4me.gov.nist.javax.sdp.fields.SDPField;
import sip4me.gov.nist.javax.sdp.parser.Lexer;
import sip4me.gov.nist.javax.sdp.parser.SDPParser;

public class OriginFieldParser
extends SDPParser {
    public OriginFieldParser(String originField) {
        this.lexer = new Lexer("charLexer", originField);
    }

    protected OriginFieldParser() {
    }

    public OriginField originField() throws ParseException {
        try {
            OriginField originField = new OriginField();
            this.lexer.match(111);
            this.lexer.SPorHT();
            this.lexer.match(61);
            this.lexer.SPorHT();
            String rest = this.lexer.getRest();
            int indexOfNextSpace = rest.indexOf(32);
            originField.setUsername(rest.substring(0, indexOfNextSpace));
            Lexer newLexer = new Lexer("charLexer", rest.substring(indexOfNextSpace + 1));
            newLexer.SPorHT();
            newLexer.match(4095);
            Token sessionId = newLexer.getNextToken();
            originField.setSessionId(sessionId.getTokenValue());
            newLexer.SPorHT();
            newLexer.match(4095);
            Token sessionVersion = newLexer.getNextToken();
            originField.setSessionVersion(Long.parseLong(sessionVersion.getTokenValue()));
            newLexer.SPorHT();
            newLexer.match(4095);
            Token networkType = newLexer.getNextToken();
            originField.setNettype(networkType.getTokenValue());
            newLexer.SPorHT();
            newLexer.match(4095);
            Token addressType = newLexer.getNextToken();
            originField.setAddrtype(addressType.getTokenValue());
            newLexer.SPorHT();
            String host = newLexer.getRest();
            Lexer lexer = new Lexer("charLexer", host);
            HostNameParser hostNameParser = new HostNameParser(lexer);
            Host h = hostNameParser.host();
            originField.setAddress(h);
            return originField;
        }
        catch (Exception e) {
            throw new ParseException(this.lexer.getBuffer(), this.lexer.getPtr());
        }
    }

    public SDPField parse() throws ParseException {
        return this.originField();
    }
}

