/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.header;

import sip4me.gov.nist.core.GenericObject;
import sip4me.gov.nist.core.Utils;

public final class CallIdentifier
extends GenericObject {
    protected String localId;
    protected String host;

    public CallIdentifier() {
    }

    public CallIdentifier(String localId, String host) {
        this.localId = localId;
        this.host = host;
    }

    public CallIdentifier(String cid) throws IllegalArgumentException {
        this.setCallIdHeader(cid);
    }

    public String encode() {
        if (this.host != null) {
            return String.valueOf(this.localId) + "@" + this.host;
        }
        return this.localId;
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        CallIdentifier that = (CallIdentifier)other;
        if (this.localId.compareTo(that.localId) != 0) {
            return false;
        }
        if (this.host == that.host) {
            return true;
        }
        if (this.host == null && that.host != null || this.host != null && that.host == null) {
            return false;
        }
        return Utils.compareToIgnoreCase(this.host, that.host) == 0;
    }

    public String getLocalId() {
        return this.localId;
    }

    public String getHost() {
        return this.host;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public void setCallIdHeader(String cid) throws IllegalArgumentException {
        if (cid == null) {
            throw new IllegalArgumentException("NULL!");
        }
        int index = cid.indexOf(64);
        if (index == -1) {
            this.localId = cid;
            this.host = null;
        } else {
            this.localId = cid.substring(0, index);
            this.host = cid.substring(index + 1, cid.length());
            if (this.localId == null || this.host == null) {
                throw new IllegalArgumentException("CallIdHeader  must be token@token or token");
            }
        }
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Object clone() {
        CallIdentifier retval = new CallIdentifier();
        if (this.localId != null) {
            retval.localId = new String(this.localId);
        }
        if (this.host != null) {
            retval.host = new String(this.host);
        }
        return retval;
    }
}

