//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            PMMLCG1gen.h
Description:     Prime Modulus Multiplicative Linear Congruential Generator
Library:         random
Original Author: Nelson Minar
Date:            1996-09-09
Modified by:     Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/

// This generator returns successive pseudo-random UNSIGNED INTEGERS
// in the closed interval [0, 2^31-3]:

// These parameters particularly recommended by Park & Miller.
// Modulus is 2^31 - 1.

#define PMMLCG1MULTIPLIER         16807 
#define PMMLCG1MODULUS       0x7fffffff

#import <random/RandomNumberGenerator.h>


@interface PMMLCG1: RandomNumberGenerator

{

// Parameters:

   int a;		// multiplier
   int m;		// modulus
   int q;		// quotient
   int r;		// reminder

// Data objects (state variables):

   unsigned state;	// vector of lagged values (state vector)

}

// The following RandomNumberGenerator methods are overridden:

// -initState;
// -resetState;

// -(void) getState: (void *) stateBuf;
// -(void) setState: (void *) stateBuf;

// -(unsigned) getUnsignedSample;

@end
