//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            ProbabilityDistribution.h
Description:     Common superclass for all distributions
Library:         random
Original Author: Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/

// THIS CLASS IS NOT MEANT TO BE INSTANTIATED !
// It is a superclass for actual distributions.

#import <random.h>
#import <swarmobject/SwarmObject.h>
#import <random/RandomDefs.h>


@interface ProbabilityDistribution: SwarmObject //<ProbabilityDistribution>

{

// Data objects and fixed variables:

   id <RandomNumberGenerator> randomGenerator ;

// Parameters:

   unsigned stateSize;			// set by initState
   BOOL optionsInitialized;		// set by setParameters:
   unsigned generatorMax;		// set by setGenerator
   double maxDivisor;			// set by setGenerator

   UnsignedOverlayDouble duuMask;	// set by initState

// Working variables:

   unsigned currentCount;		// set by initState et al

}

// Methods that conform to the ProbabilityDistribution protocol:

+create: (id) aZone setGenerator: (id) generator;
-(void) setGenerator: (id) generator;

-(id) getGenerator;
-(BOOL) getOptionsInitialized;

// Methods that conform to the InternalState protocol:

-(void) getState: (void *) state;
-(void) setState: (void *) state;
-(unsigned) getStateSize;

// Methods overridden by subclasses:

-initState;
-resetState;

// temporary methods:

- (void) describe: outStream;
-(int) verifySelf;

@end
