// Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// quickie interface to Blt_Graph. Elements, legends, etc need to be handled
// more gracefully. Bindings to mouse (seem BLT demos), autoscrolling,
// etc should be added.

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#import <swarmgraph/global.h>
#import <swarmgraph/Histo.h>
#ifndef _TK_
#import <swarmgraph/JavaBar.h>
#endif

@implementation Histo

-createEnd {
  [super createEnd];
#ifdef _TK_
  // create the graph with one element
  [globalTkInterp eval: "barchart %s;", widgetName];
#else
  {
    jBar = [JavaBar new];
  }
#endif
  [self setWidth: 400 Height: 247];		  // golden ratio

  numPoints = 0;
  
  return self;
}

// you can only call this once. Fix it.
-setNumPoints: (int) n Labels: (char **) l Colors: (char **) c{
  int i;

  numPoints = n;

  elements = [[self getZone] alloc: (sizeof(*elements) * n)];
#ifndef _TK_
  colors = [[self getZone] alloc: (sizeof(*colors) * n)];
  labels = [[self getZone] alloc: (sizeof(*labels) * n)];
#endif
  for (i = 0; i < n; i++) {
    char strBuffer[256];
    sprintf(strBuffer, "%d", i);
    elements[i] = strdup(strBuffer);
#ifdef _TK_
    [globalTkInterp eval: "%s element create %s; %s element configure %s -relief flat", widgetName, strBuffer, widgetName, elements[i]];
    if (l && l[i])
      [globalTkInterp eval: "%s element configure %s -label \"%s\"",
		      widgetName, elements[i], l[i]];
    if (c && c[i])
      [globalTkInterp eval: "%s element configure %s -foreground \"%s\"",
		      widgetName, elements[i], c[i]];
#else
    labels[i] = l[i] ? strdup(l[i]) : NULL;
    colors[i] = c[i] ? strdup(c[i]) : NULL;
#endif
  }    

  return self;
}

-drawHistoWithDouble: (double *) points {
  int i;
#ifdef _TK_
  for (i = 0; i < numPoints; i++)
    [globalTkInterp eval: "%s element configure %s -data { %d %f }",
		    widgetName, elements[i], i, points[i]];
#else
  [jBar reset];
  for (i = 0; i < numPoints; i++) {
    char * color = colors[i] ? colors[i] : "black";
    char * label = labels[i] ? labels[i] : "";

    [jBar addBar: label value: points[i] color: color];
  }
  [jBar update];
#endif
  return self;
}

// ick. How to do two data formats right?
-drawHistoWithInt: (int *) points {
  int i;
#ifdef _TK_
  for (i = 0; i < numPoints; i++)
    [globalTkInterp eval: "%s element configure %s -data { %d %d }",
		    widgetName, elements[i], i, points[i]];
#else
  [jBar reset];
  for (i = 0; i < numPoints; i++) {
    char * color = colors[i] ? colors[i] : "black";
    char * label = labels[i] ? labels[i] : "";

fprintf(stderr, "hist int: adding %s %s %d\n", label, color, points[i]);

    [jBar addBar: label value: (double)points[i] color: color];
  }
  [jBar update];
#endif
  return self;
}

-drawHistoWithInt: (int *) points atLocations: (double *) locations {
#ifdef _TK_
  int i;
  for (i = 0; i < numPoints; i++)
    [globalTkInterp eval: "%s element configure %s -data { %g %d }",
		    widgetName, elements[i], locations[i], points[i]];
#endif
  return self;
}

-drawHistoWithDouble: (double *) points atLocations: (double *) locations {
#ifdef _TK_
  int i;
  for (i = 0; i < numPoints; i++)
    [globalTkInterp eval: "%s element configure %s -data { %g %g }",
		    widgetName, elements[i], locations[i], points[i]];
#endif
  return self;
}

// this code is in common with BLTGraph
-title: (char *) t {
#ifdef _TK_
  [globalTkInterp eval: "%s configure -title \"%s\";", widgetName, t];
#endif
  [self setWindowTitle: t];
  return self;
}

-axisLabelsX: (char *) xl Y: (char *) yl {
#ifdef _TK_
  [globalTkInterp eval: "%s xaxis configure -title \"%s\"; %s yaxis configure -title \"%s\";",
		  widgetName, xl, widgetName, yl];
#endif
  return self;
}

-pack {
#ifdef _TK_
  [globalTkInterp eval: "pack %s -fill both -expand true;", widgetName];
#endif
  return self;
}

@end

