/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.ArrayList;
import java.util.List;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.CombinationDataset;
import org.jfree.data.Dataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.HighLowDataset;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.SeriesDataset;
import org.jfree.data.SubSeriesDataset;
import org.jfree.data.XYDataset;

public class CombinedDataset
extends AbstractSeriesDataset
implements XYDataset,
HighLowDataset,
IntervalXYDataset,
CombinationDataset {
    private List datasetInfo = new ArrayList();

    public CombinedDataset() {
    }

    public CombinedDataset(SeriesDataset[] seriesDatasetArray) {
        this.add(seriesDatasetArray);
    }

    public void add(SeriesDataset seriesDataset) {
        this.fastAdd(seriesDataset);
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, this);
        this.notifyListeners(datasetChangeEvent);
    }

    public void add(SeriesDataset[] seriesDatasetArray) {
        for (int i = 0; i < seriesDatasetArray.length; ++i) {
            this.fastAdd(seriesDatasetArray[i]);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, this);
        this.notifyListeners(datasetChangeEvent);
    }

    public void add(SeriesDataset seriesDataset, int n) {
        this.add(new SubSeriesDataset(seriesDataset, n));
    }

    private void fastAdd(SeriesDataset seriesDataset) {
        for (int i = 0; i < seriesDataset.getSeriesCount(); ++i) {
            this.datasetInfo.add(new DatasetInfo(seriesDataset, i));
        }
    }

    public int getSeriesCount() {
        return this.datasetInfo.size();
    }

    public String getSeriesName(int n) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return datasetInfo.data.getSeriesName(datasetInfo.series);
    }

    public Number getXValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((XYDataset)datasetInfo.data).getXValue(datasetInfo.series, n2);
    }

    public Number getYValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((XYDataset)datasetInfo.data).getYValue(datasetInfo.series, n2);
    }

    public int getItemCount(int n) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((XYDataset)datasetInfo.data).getItemCount(datasetInfo.series);
    }

    public Number getHighValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((HighLowDataset)datasetInfo.data).getHighValue(datasetInfo.series, n2);
    }

    public Number getLowValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((HighLowDataset)datasetInfo.data).getLowValue(datasetInfo.series, n2);
    }

    public Number getOpenValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((HighLowDataset)datasetInfo.data).getOpenValue(datasetInfo.series, n2);
    }

    public Number getCloseValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((HighLowDataset)datasetInfo.data).getCloseValue(datasetInfo.series, n2);
    }

    public Number getVolumeValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        return ((HighLowDataset)datasetInfo.data).getVolumeValue(datasetInfo.series, n2);
    }

    public Number getStartXValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getStartXValue(datasetInfo.series, n2);
        }
        return this.getXValue(n, n2);
    }

    public Number getEndXValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getEndXValue(datasetInfo.series, n2);
        }
        return this.getXValue(n, n2);
    }

    public Number getStartYValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getStartYValue(datasetInfo.series, n2);
        }
        return this.getYValue(n, n2);
    }

    public Number getEndYValue(int n, int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getEndYValue(datasetInfo.series, n2);
        }
        return this.getYValue(n, n2);
    }

    public SeriesDataset getParent() {
        SeriesDataset seriesDataset = null;
        for (int i = 0; i < this.datasetInfo.size(); ++i) {
            SeriesDataset seriesDataset2 = this.getDatasetInfo(i).data;
            if (seriesDataset2 instanceof CombinationDataset) {
                SeriesDataset seriesDataset3 = ((CombinationDataset)((Object)seriesDataset2)).getParent();
                if (seriesDataset == null) {
                    seriesDataset = seriesDataset3;
                    continue;
                }
                if (seriesDataset == seriesDataset3) continue;
                return null;
            }
            return null;
        }
        return seriesDataset;
    }

    public int[] getMap() {
        int[] nArray = null;
        for (int i = 0; i < this.datasetInfo.size(); ++i) {
            int[] nArray2;
            SeriesDataset seriesDataset = this.getDatasetInfo(i).data;
            if (seriesDataset instanceof CombinationDataset) {
                nArray2 = ((CombinationDataset)((Object)seriesDataset)).getMap();
                if (nArray2 == null) {
                    return null;
                }
            } else {
                return null;
            }
            nArray = this.joinMap(nArray, nArray2);
        }
        return nArray;
    }

    public int getChildPosition(Dataset dataset) {
        int n = 0;
        for (int i = 0; i < this.datasetInfo.size(); ++i) {
            SeriesDataset seriesDataset = this.getDatasetInfo(i).data;
            if (seriesDataset instanceof CombinedDataset) {
                int n2 = ((CombinedDataset)seriesDataset).getChildPosition(dataset);
                if (n2 >= 0) {
                    return n + n2;
                }
                ++n;
                continue;
            }
            if (dataset == seriesDataset) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private DatasetInfo getDatasetInfo(int n) {
        return (DatasetInfo)this.datasetInfo.get(n);
    }

    private int[] joinMap(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return nArray2;
        }
        if (nArray2 == null) {
            return nArray;
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    private class DatasetInfo {
        private SeriesDataset data;
        private int series;

        DatasetInfo(SeriesDataset seriesDataset, int n) {
            this.data = seriesDataset;
            this.series = n;
        }
    }
}

