/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jsynoptic.base.ContextualActionProvider;
import jsynoptic.base.Linkable;
import jsynoptic.builtin.Abstract1DShape;
import jsynoptic.builtin.TextShape;
import jsynoptic.ui.LongAction;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.EndNotificationListener;
import simtools.diagram.Resizable;
import simtools.shapes.AbstractShape;
import simtools.ui.ActionCheckBox;
import simtools.ui.ResourceFinder;

public class TextArrayShape
extends AbstractShape
implements Resizable,
ContextualActionProvider,
Linkable,
EndNotificationListener {
    static final long serialVersionUID = 1320844024842187479L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$TextArrayShape == null ? (class$jsynoptic$builtin$TextArrayShape = TextArrayShape.class$("jsynoptic.builtin.TextArrayShape")) : class$jsynoptic$builtin$TextArrayShape);
    protected String link;
    protected boolean autoresize;
    protected Vector cells;
    protected boolean forceSameFont;
    static /* synthetic */ Class class$jsynoptic$builtin$TextArrayShape;

    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public boolean isAutoresize() {
        return this.autoresize;
    }

    public void setAutoresize(boolean bl) {
        this.autoresize = bl;
    }

    protected TextArrayShape() {
    }

    public TextArrayShape(String string, int n, int n2) {
        this.cells = new Vector();
        TextShape textShape = new TextShape(string, n, n2, false);
        this.cells.add(textShape);
        textShape.setDelegateEndNotificationListener(this);
        this._w = n;
        this._h = n2;
        if (this._w < 40) {
            this._w = 40;
        }
        if (this._h < 20) {
            this._h = 20;
        }
        this._y = n2;
        textShape.setAnchor(this._ox, this._oy + this._y);
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        Iterator iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            ((TextShape)iterator.next()).translate(n, n2);
        }
    }

    public void setAnchor(int n, int n2) {
        super.setAnchor(n, n2);
        this.positionCells();
    }

    public void draw(Graphics2D graphics2D) {
        Iterator iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            ((TextShape)iterator.next()).draw(graphics2D);
        }
    }

    public void unifyFonts() {
        Serializable serializable;
        int n;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = this._w - 10;
        double d4 = this._h / this.cells.size() - 10;
        if (d3 <= 0.0 || d4 <= 0.0) {
            return;
        }
        for (n = 0; n < this.cells.size(); ++n) {
            serializable = (TextShape)this.cells.get(n);
            double d5 = d3 / (double)(serializable.getText().length() * TextShape.referenceWidth);
            double d6 = d4 / (double)TextShape.referenceHeight;
            d = Math.min(d5, d);
            d2 = Math.min(d6, d2);
        }
        n = (int)((double)TextShape.referenceBaseline * d4 / (double)TextShape.referenceHeight);
        serializable = TextShape.referenceFont.deriveFont(AffineTransform.getScaleInstance(d, d2));
        for (int i = 0; i < this.cells.size(); ++i) {
            TextShape textShape = (TextShape)this.cells.get(i);
            textShape.currentFont = serializable;
            textShape.baseline = n;
        }
    }

    protected void positionCells() {
        int n = this._h / this.cells.size();
        for (int i = 0; i < this.cells.size(); ++i) {
            TextShape textShape = (TextShape)this.cells.get(i);
            textShape.setAnchor(this._ox, this._oy + (i + 1) * n);
            textShape.setDimensions(this._w, n);
        }
        if (this.forceSameFont) {
            this.unifyFonts();
        }
    }

    public void resize(int n, int n2) {
        int n3;
        this._w += n;
        this._h += n2;
        if (this._w < 40) {
            this._w = 40;
        }
        if ((n3 = (int)Math.rint((double)this._h / (double)this.cells.size())) < 20) {
            n3 = 20;
        }
        this._h = n3 * this.cells.size();
        this._oy += this._y - this._h;
        this._y = this._h;
        this.positionCells();
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return null;
        }
        if (n == 4) {
            return null;
        }
        if (n == 5) {
            return null;
        }
        if (n == 1) {
            // empty if block
        }
        Vector<String> vector = new Vector<String>();
        vector.add(resources.getString("Properties..."));
        vector.add(resources.getString("NewCell"));
        if (object instanceof DataSource) {
            for (int i = 0; i < this.cells.size(); ++i) {
                vector.add(resources.getString("SetSourceForCell") + (i + 1));
            }
            vector.add(resources.getString("AddSourceAsCell") + (this.cells.size() + 1));
        }
        if (object instanceof DataSourceCollection) {
            vector.add(resources.getString("SetOneCellPerSource"));
            vector.add(resources.getString("CreateNewCellsForEachSource"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        if (string.equals(resources.getString("Properties..."))) {
            new LongAction(16L, null, this){

                protected void doAction() {
                    PropertiesPanel propertiesPanel = new PropertiesPanel();
                    int n = JOptionPane.showConfirmDialog(null, propertiesPanel, resources.getString("TextProperties"), 2, -1);
                    if (n == 0) {
                        propertiesPanel.updateProperties();
                        TextArrayShape.this.notifyChange();
                    }
                }
            }.start();
            return true;
        }
        if (string.equals(resources.getString("NewCell"))) {
            int n = this._h / this.cells.size();
            TextShape textShape = new TextShape(resources.getString("Text"), this._w, n, false);
            textShape.setDelegateEndNotificationListener(this);
            this.cells.add(textShape);
            this._h += n;
            this._y = this._h;
            this.positionCells();
            this.notifyChange();
            return true;
        }
        if (string.startsWith(resources.getString("AddSourceAsCell"))) {
            int n = this._h / this.cells.size();
            TextShape textShape = new TextShape("", this._w, n, false);
            textShape.setDelegateEndNotificationListener(this);
            textShape.setSource((DataSource)object);
            this.cells.add(textShape);
            this._h += n;
            this._y = this._h;
            this.positionCells();
            this.notifyChange();
            return true;
        }
        if (string.startsWith(resources.getString("SetSourceForCell"))) {
            int n = (int)Long.parseLong(string.substring(resources.getString("SetSourceForCell").length()));
            ((TextShape)this.cells.get(n - 1)).setSource((DataSource)object);
            this.notifyChange();
            return true;
        }
        if (string.equals(resources.getString("SetOneCellPerSource"))) {
            DataSourceCollection dataSourceCollection = (DataSourceCollection)object;
            int n = this._h / this.cells.size();
            Object object2 = this.cells.iterator();
            while (object2.hasNext()) {
                TextShape textShape = (TextShape)object2.next();
                textShape.setDelegateEndNotificationListener(textShape);
            }
            object2 = new Vector();
            for (int i = 0; i < dataSourceCollection.size(); ++i) {
                TextShape textShape = new TextShape("", this._w, n, false);
                textShape.setDelegateEndNotificationListener(this);
                textShape.setSource((DataSource)dataSourceCollection.get(i));
                ((Vector)object2).add(textShape);
            }
            this.cells = object2;
            Rectangle rectangle = this.getBounds();
            this._y = this._h = n * this.cells.size();
            this.positionCells();
            rectangle.add(this.getBounds());
            this.notifyChange(rectangle);
            return true;
        }
        if (string.equals(resources.getString("CreateNewCellsForEachSource"))) {
            DataSourceCollection dataSourceCollection = (DataSourceCollection)object;
            int n = this._h / this.cells.size();
            for (int i = 0; i < dataSourceCollection.size(); ++i) {
                TextShape textShape = new TextShape("", this._w, n, false);
                textShape.setDelegateEndNotificationListener(this);
                textShape.setSource((DataSource)dataSourceCollection.get(i));
                this.cells.add(textShape);
            }
            this._y = this._h = n * this.cells.size();
            this.positionCells();
            this.notifyChange();
            return true;
        }
        return false;
    }

    public boolean canDoAction(double d, double d2, Object object, String string, int n) {
        return true;
    }

    public void adjustSize() {
        Object object;
        Object object2;
        int n = Integer.MIN_VALUE;
        String string = "";
        Font font = null;
        Iterator iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            object2 = (TextShape)iterator.next();
            font = ((TextShape)object2).currentFont;
            object = ((TextShape)object2).getText();
            int n2 = ((String)object).length();
            if (n >= n2) continue;
            n = n2;
            string = object;
        }
        if (font == null) {
            return;
        }
        this._w = 10 + TextShape.referenceGraphics.getFontMetrics(font).stringWidth(string);
        if (this._w < 40) {
            this._w = 40;
        }
        int n3 = this._h / this.cells.size();
        object2 = this.cells.iterator();
        while (object2.hasNext()) {
            object = (TextShape)object2.next();
            ((TextShape)object).overrideDimensions(this._w, n3);
        }
    }

    protected AbstractShape cloneShape() {
        TextArrayShape textArrayShape = (TextArrayShape)super.cloneShape();
        textArrayShape.cells = new Vector();
        Iterator iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            textArrayShape.cells.add(((TextShape)iterator.next()).cloneShape());
            ((TextShape)textArrayShape.cells.lastElement()).setDelegateEndNotificationListener(textArrayShape);
        }
        textArrayShape.positionCells();
        return textArrayShape;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Iterator iterator;
        objectInputStream.defaultReadObject();
        if (this.forceSameFont) {
            iterator = this.cells.iterator();
            while (iterator.hasNext()) {
                ((TextShape)iterator.next()).lockedFont = true;
            }
            this.unifyFonts();
        }
        iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            ((TextShape)iterator.next()).setDelegateEndNotificationListener(this);
        }
    }

    public void notificationEnd(Object object) {
        Rectangle rectangle = null;
        Iterator iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            TextShape textShape = (TextShape)iterator.next();
            textShape.setDirtyState(false);
            textShape.notificationEnd(object);
            if (!textShape.isDirtyState()) continue;
            if (rectangle == null) {
                rectangle = textShape.getBounds();
                continue;
            }
            rectangle.add(textShape.getBounds());
        }
        if (rectangle == null) {
            return;
        }
        if (this.forceSameFont) {
            rectangle = this.getBounds();
            if (this.autoresize) {
                this.adjustSize();
                rectangle.add(this.getBounds());
            } else {
                this.unifyFonts();
            }
        }
        this.notifyChange(rectangle);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PropertiesPanel
    extends JPanel {
        JPanel cards;
        JComboBox cbx;
        ActionCheckBox cbSameFont;
        JCheckBox cbResize;

        public PropertiesPanel() {
            this.setLayout(new BorderLayout());
            Box box = Box.createVerticalBox();
            this.cbx = new JComboBox();
            box.add(this.cbx);
            this.cards = new JPanel();
            this.cards.setLayout(new CardLayout());
            int n = 0;
            Object object = TextArrayShape.this.cells.iterator();
            while (object.hasNext()) {
                TextShape textShape = (TextShape)object.next();
                Abstract1DShape.PropertiesPanel propertiesPanel = textShape.createPanel(false);
                this.cbx.addItem(propertiesPanel);
                this.cards.add((Component)propertiesPanel, Integer.toString(n++));
                propertiesPanel.addPropertyChangeListener(resources.getString("Name"), new PropertyChangeListener(this){
                    private final /* synthetic */ PropertiesPanel this$1;
                    {
                        this.this$1 = propertiesPanel;
                    }

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        this.this$1.cbx.repaint();
                    }
                });
            }
            this.cbx.setEditable(false);
            this.cbx.addActionListener(new ActionListener(this){
                private final /* synthetic */ PropertiesPanel this$1;
                {
                    this.this$1 = propertiesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CardLayout cardLayout = (CardLayout)this.this$1.cards.getLayout();
                    cardLayout.show(this.this$1.cards, Integer.toString(this.this$1.cbx.getSelectedIndex()));
                }
            });
            box.add(this.cards);
            object = Box.createHorizontalBox();
            this.cbSameFont = new ActionCheckBox(this, resources.getString("UseAUniqueFontForTheWholeArray"), TextArrayShape.this.forceSameFont){
                private final /* synthetic */ PropertiesPanel this$1;
                {
                    this.this$1 = propertiesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.cbResize.setEnabled(this.this$1.cbSameFont.isSelected());
                }
            };
            ((Container)object).add(this.cbSameFont);
            ((Container)object).add(Box.createHorizontalGlue());
            box.add((Component)object);
            object = Box.createHorizontalBox();
            this.cbResize = new JCheckBox(resources.getString("AutoResize"), TextArrayShape.this.autoresize);
            ((Container)object).add(this.cbResize);
            ((Container)object).add(Box.createHorizontalGlue());
            box.add((Component)object);
            this.cbSameFont.apply();
            this.add((Component)box, "Center");
        }

        public void updateProperties() {
            TextArrayShape.this.forceSameFont = this.cbSameFont.isSelected();
            TextArrayShape.this.autoresize = this.cbResize.isSelected();
            Iterator iterator = TextArrayShape.this.cells.iterator();
            while (iterator.hasNext()) {
                ((TextShape)iterator.next()).lockedFont = TextArrayShape.this.forceSameFont;
            }
            int n = this.cards.getComponentCount();
            for (int i = 0; i < n; ++i) {
                ((Abstract1DShape.PropertiesPanel)this.cards.getComponent(i)).updateProperties();
            }
        }
    }
}

