/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.parser;

import jsynoptic.parser.ExpressionNode;
import jsynoptic.parser.ExpressionParser;

public class NodeForPower
extends ExpressionNode {
    public NodeForPower(int n) {
        super(n);
    }

    public NodeForPower(ExpressionParser expressionParser, int n) {
        super(expressionParser, n);
    }

    public Number evaluate() {
        if (this.jjtGetNumChildren() != 2) {
            return null;
        }
        Number number = ((ExpressionNode)this.jjtGetChild(0)).evaluate();
        Number number2 = ((ExpressionNode)this.jjtGetChild(1)).evaluate();
        if (number2 instanceof Float || number2 instanceof Double) {
            return new Double(Math.pow(number.doubleValue(), number2.doubleValue()));
        }
        if (number2.longValue() < 0L) {
            return new Double(Math.pow(number.doubleValue(), number2.doubleValue()));
        }
        if (number instanceof Float || number instanceof Double) {
            return new Double(NodeForPower.powDouble(number.doubleValue(), number2.longValue()));
        }
        return new Long(NodeForPower.powLong(number.longValue(), number2.longValue()));
    }

    public static long powLong(long l, long l2) {
        if (l2 == 0L) {
            return 1L;
        }
        if (l2 == 1L) {
            return l;
        }
        if ((l2 & 1L) == 0L) {
            return NodeForPower.powLong(l * l, l2 >>> 1);
        }
        return l * NodeForPower.powLong(l * l, l2 >>> 1);
    }

    public static double powDouble(double d, long l) {
        if (l == 0L) {
            return 1.0;
        }
        if (l == 1L) {
            return d;
        }
        if ((l & 1L) == 0L) {
            return NodeForPower.powDouble(d * d, l >>> 1);
        }
        return d * NodeForPower.powDouble(d * d, l >>> 1);
    }
}

