/* $Id: TspAggrConsumerFactory.java,v 1.2 2005/04/09 05:13:12 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.consumer.util.aggregator;

import java.util.HashSet;
import java.util.Set;

import tsp.core.consumer.TspConsumerException;
import tsp.core.consumer.simple.TspSimpleConsumer;
import tsp.core.consumer.simple.TspSimpleConsumerFactory;
import tsp.core.consumer.simple.TspSimpleConsumerImpl;


public class TspAggrConsumerFactory {
	
	private final TspSimpleConsumerFactory simplefactory;
	
	public TspAggrConsumerFactory(String[] args){
		simplefactory = new TspSimpleConsumerFactory(args);
	}
	
	
	public TspSimpleConsumer createAggrConsumer(TspAggrNamedConsumer[] namedConsumers) throws TspConsumerException{
//		 check that all namespaces are different
		Set s = new HashSet();
		for(int i = 0 ; i < namedConsumers.length ; i++){
			s.add(namedConsumers[i].getNamespace());
			if(s.size() != i+1){
				throw new TspConsumerException("namespace : '" + namedConsumers[i].getNamespace() + "' is duplicated");
			}
		}		
		return new TspAggrConsumerImpl(namedConsumers);
	}
		
	public TspSimpleConsumer createAggrConsumer(TspAggrURL[] urls) throws TspConsumerException{
		TspAggrNamedConsumer[] namedConsumers= new TspAggrNamedConsumer[urls.length];
		for(int i = 0 ; i < urls.length ; i++){
			TspSimpleConsumer consumer = simplefactory.createSimpleConsumer(urls[i].getUrl());
			namedConsumers[i] = new TspAggrNamedConsumer(urls[i].getNamespace(), consumer);
		}		
		return createAggrConsumer(namedConsumers);		
	}
	
	 

}
