/* $Id: TspAggrConsumerImpl.java,v 1.2 2005/04/09 05:13:12 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.consumer.util.aggregator;

import java.util.LinkedList;
import java.util.List;
import java.util.HashMap;
import java.util.Map;

import tsp.core.common.url.TspURL;
import tsp.core.common.url.TspURLException;
import tsp.core.config.TspConfig;
import tsp.core.consumer.TspConsumer;
import tsp.core.consumer.TspConsumerException;
import tsp.core.consumer.TspSession;
import tsp.core.consumer.simple.TspSimpleConsumer;
import tsp.core.consumer.simple.TspSimpleConsumerImpl;
import tsp.core.consumer.simple.TspSimpleSession;
import tsp.core.consumer.simple.TspSimpleSessionImpl;

class TspAggrConsumerImpl implements TspSimpleConsumer {
	
	private TspAggrNamedConsumer[] consumers;
	
		
	TspAggrConsumerImpl(TspAggrNamedConsumer[] consumers){
		this.consumers = consumers;		
	}
	
	
	public TspSimpleSession openSession() throws TspURLException, TspConsumerException {
		
		List sessionList = new LinkedList();
		for(int i = 0 ; i < consumers.length ; i++){
			TspSimpleSession session = consumers[i].getConsumer().openSession();
			sessionList.add(new TspAggrSubSession( session, consumers[i].getNamespace()));
		}	
		return new TspAggrSessionImpl((TspAggrSubSession[])sessionList.toArray(new TspAggrSubSession[0]));
	}
	
	
}
