/* Copyright (c) 2010 Axel Wachtler
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: hexparse.c,v 1.6 2010/09/05 18:24:58 dath Exp $ */
/**
 * @file
 * @brief Wireless bootloader application, resides in bootloader section
 *
 * @author Daniel Thiele
 *         Dietzsch und Thiele PartG
 *         Bautzner Str. 67 01099 Dresden
 *         www.ib-dt.de daniel.thiele@ib-dt.de
 *
 * @ingroup grpAppWiBo
 */

#include <stdint.h>
#include <ctype.h>
#include <string.h>
#include "hexparse.h"

static uint8_t htoi(char c)
{
	uint8_t a;
	if (isdigit(c)) {
		a = c - '0';
	} else {
		a = c - 'a' + 10;
	}
	return a;
}

/*
 * TODO: parse and validate checksum
 */
uint8_t parsehexline(uint8_t *ln, hexrec_t *rec)
{
	uint8_t *ptr;
	uint8_t i;
	uint8_t checksum;

	if (strlen((char*) ln) < 1 + 2 + 4 + 2 + 2)
		return 0; /* 1 character pivot ':'
		 2 character (1 byte) length
		 4 character (2 byte) address
		 2 character (1 byte) type
		 2 character (1 byte) checksum
		 */
	ptr = ln;
	if (ptr[0] != ':') {
		return 0; /* no valid hex line */
	}

	rec->len = ((htoi(ptr[1]) << 4) & 0xF0) | ((uint8_t) htoi(ptr[2]) & 0x0F);
	rec->addr = ((htoi(ptr[3]) << 12) & 0xF000)
			| ((htoi(ptr[4]) << 8) & 0x0F00) | ((htoi(ptr[5]) << 4) & 0x00F0)
			| ((htoi(ptr[6]) << 0) & 0x000F);
	rec->type = (htoi(ptr[7]) << 4) | (htoi(ptr[8]) & 0x0F);

	for (i = 0; i < rec->len; i++) {
		rec->data[i] = ((htoi(ptr[9 + i * 2]) << 4) & 0xF0) | (htoi(ptr[9 + 1
				+ i * 2]) & 0x0F);
	}
	checksum = ((htoi(ptr[9 + i * 2]) << 4) & 0xF0) | (htoi(ptr[9 + 1 + i * 2])
			& 0x0F);

	return 1;
}

/* EOF */
